/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.babelfish;

import java.io.File;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import oracle.jdbc.babelfish.TranslationCache;
import oracle.jdbc.babelfish.Translator;
import oracle.jdbc.driver.DatabaseError;

public class TranslationManager {
    private static final ConcurrentHashMap<String, TranslationCache> translationCacheRegistry = new ConcurrentHashMap();
    private static Map<String, String> defaultErrorFile = new ConcurrentHashMap<String, String>();
    private static final String SEPARATOR = "\u0000";

    public static Translator getTranslator(String connectionURL, String user, String translationProfile, String localErrorTranslationFilePath) throws SQLException {
        if (localErrorTranslationFilePath == null && defaultErrorFile.containsKey(translationProfile)) {
            localErrorTranslationFilePath = defaultErrorFile.get(translationProfile);
        }
        File localErrorTranslationFile = null;
        if (localErrorTranslationFilePath != null && !(localErrorTranslationFile = new File(localErrorTranslationFilePath)).exists()) {
            throw (SQLException)DatabaseError.createSqlException(277).fillInStackTrace();
        }
        assert (!(".*\u0000.*".matches(connectionURL) || ".*\u0000.*".matches(user) || ".*\u0000.*".matches(translationProfile)));
        String key = connectionURL + SEPARATOR + user + SEPARATOR + translationProfile;
        TranslationCache trnscache = translationCacheRegistry.get(key);
        if (trnscache == null) {
            trnscache = new TranslationCache(localErrorTranslationFile);
            translationCacheRegistry.putIfAbsent(key, trnscache);
        }
        Translator trnsltr = new Translator(translationProfile, localErrorTranslationFile, trnscache);
        return trnsltr;
    }
}

