/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.convert;

import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import org.directwebremoting.Container;
import org.directwebremoting.ConversionException;
import org.directwebremoting.WebContextFactory;
import org.directwebremoting.extend.AbstractConverter;
import org.directwebremoting.extend.ContainerUtil;
import org.directwebremoting.extend.DataUrlDownloadManager;
import org.directwebremoting.extend.DownloadManager;
import org.directwebremoting.extend.FormField;
import org.directwebremoting.extend.InboundVariable;
import org.directwebremoting.extend.NonNestedOutboundVariable;
import org.directwebremoting.extend.OutboundContext;
import org.directwebremoting.extend.OutboundVariable;
import org.directwebremoting.io.FileTransfer;
import org.directwebremoting.io.InputStreamFactory;
import org.directwebremoting.util.BrowserDetect;
import org.directwebremoting.util.CopyUtils;
import org.directwebremoting.util.UserAgent;

public class FileConverter
extends AbstractConverter {
    @Override
    public Object convertInbound(Class<?> paramType, InboundVariable data) throws ConversionException {
        if (data.isNull()) {
            return null;
        }
        try {
            final FormField formField = data.getFormField();
            if (paramType == FileTransfer.class) {
                InputStreamFactory inFactory = new InputStreamFactory(){

                    @Override
                    public InputStream getInputStream() throws IOException {
                        return formField.getInputStream();
                    }

                    @Override
                    public void close() throws IOException {
                        formField.getInputStream().close();
                    }
                };
                return new FileTransfer(formField.getName(), formField.getMimeType(), formField.getFileSize(), inFactory);
            }
            if (paramType == InputStream.class) {
                return formField.getInputStream();
            }
            if (paramType == BufferedImage.class) {
                return ImageIO.read(formField.getInputStream());
            }
            if (paramType.isArray() && paramType.getComponentType() == Byte.TYPE) {
                InputStream in = formField.getInputStream();
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                CopyUtils.copy(in, (OutputStream)out);
                return out.toByteArray();
            }
        }
        catch (IOException ex) {
            throw new ConversionException(paramType, (Throwable)ex);
        }
        throw new ConversionException(paramType, "File conversion is not possible for a " + paramType);
    }

    @Override
    public OutboundVariable convertOutbound(Object object, OutboundContext outboundContext) throws ConversionException {
        if (object == null) {
            return new NonNestedOutboundVariable("null");
        }
        try {
            FileTransfer transfer;
            if (object instanceof BufferedImage) {
                transfer = new FileTransfer((BufferedImage)object, "png");
            } else if (object instanceof InputStream) {
                final InputStream in = (InputStream)object;
                transfer = new FileTransfer("download.dat", "binary/octet-stream", -1L, new InputStreamFactory(){

                    @Override
                    public InputStream getInputStream() throws IOException {
                        return in;
                    }

                    @Override
                    public void close() throws IOException {
                        in.close();
                    }
                });
            } else if (object instanceof FileTransfer) {
                transfer = (FileTransfer)object;
            } else if (object.getClass().isArray() && object.getClass().getComponentType() == Byte.TYPE) {
                transfer = new FileTransfer("download.dat", "binary/octet-stream", (byte[])object);
            } else {
                throw new ConversionException(object.getClass());
            }
            Container container = WebContextFactory.get().getContainer();
            boolean preferDataUrlSchema = ContainerUtil.getBooleanSetting(container, "preferDataUrlSchema", false);
            DownloadManager downloadManager = preferDataUrlSchema && this.isDataUrlAvailable() ? new DataUrlDownloadManager() : container.getBean(DownloadManager.class);
            String url = downloadManager.addFileTransfer(transfer);
            return new NonNestedOutboundVariable(url);
        }
        catch (IOException ex) {
            throw new ConversionException(this.getClass(), (Throwable)ex);
        }
    }

    protected boolean isDataUrlAvailable() {
        HttpServletRequest request = WebContextFactory.get().getHttpServletRequest();
        return BrowserDetect.atLeast(request, UserAgent.IE, 8) || BrowserDetect.atLeast(request, UserAgent.Gecko, 20041107) || BrowserDetect.atLeast(request, UserAgent.AppleWebKit, 2) || BrowserDetect.atLeast(request, UserAgent.Opera, 8);
    }
}

