/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ingest.geoip;

import com.maxmind.db.Network;
import com.maxmind.geoip2.exception.AddressNotFoundException;
import com.maxmind.geoip2.model.AsnResponse;
import com.maxmind.geoip2.model.CityResponse;
import com.maxmind.geoip2.model.CountryResponse;
import com.maxmind.geoip2.record.City;
import com.maxmind.geoip2.record.Continent;
import com.maxmind.geoip2.record.Country;
import com.maxmind.geoip2.record.Location;
import com.maxmind.geoip2.record.Subdivision;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.opensearch.OpenSearchParseException;
import org.opensearch.SpecialPermission;
import org.opensearch.common.network.InetAddresses;
import org.opensearch.common.network.NetworkAddress;
import org.opensearch.ingest.AbstractProcessor;
import org.opensearch.ingest.ConfigurationUtils;
import org.opensearch.ingest.IngestDocument;
import org.opensearch.ingest.Processor;
import org.opensearch.ingest.geoip.DatabaseReaderLazyLoader;
import org.opensearch.ingest.geoip.IngestGeoIpModulePlugin;
import org.opensearch.secure_sm.AccessController;

public final class GeoIpProcessor
extends AbstractProcessor {
    public static final String TYPE = "geoip";
    private static final String CITY_DB_SUFFIX = "-City";
    private static final String COUNTRY_DB_SUFFIX = "-Country";
    private static final String ASN_DB_SUFFIX = "-ASN";
    private final String field;
    private final String targetField;
    private final DatabaseReaderLazyLoader lazyLoader;
    private final Set<Property> properties;
    private final boolean ignoreMissing;
    private final IngestGeoIpModulePlugin.GeoIpCache cache;
    private final boolean firstOnly;

    GeoIpProcessor(String tag, String description, String field, DatabaseReaderLazyLoader lazyLoader, String targetField, Set<Property> properties, boolean ignoreMissing, IngestGeoIpModulePlugin.GeoIpCache cache, boolean firstOnly) {
        super(tag, description);
        this.field = field;
        this.targetField = targetField;
        this.lazyLoader = lazyLoader;
        this.properties = properties;
        this.ignoreMissing = ignoreMissing;
        this.cache = cache;
        this.firstOnly = firstOnly;
    }

    boolean isIgnoreMissing() {
        return this.ignoreMissing;
    }

    public IngestDocument execute(IngestDocument ingestDocument) throws IOException {
        Object ip = ingestDocument.getFieldValue(this.field, Object.class, this.ignoreMissing);
        if (ip == null && this.ignoreMissing) {
            return ingestDocument;
        }
        if (ip == null) {
            throw new IllegalArgumentException("field [" + this.field + "] is null, cannot extract geoip information.");
        }
        if (ip instanceof String) {
            Map<String, Object> geoData = this.getGeoData((String)ip);
            if (!geoData.isEmpty()) {
                ingestDocument.setFieldValue(this.targetField, geoData);
            }
        } else if (ip instanceof List) {
            boolean match = false;
            ArrayList<Map<String, Object>> geoDataList = new ArrayList<Map<String, Object>>(((List)ip).size());
            for (Object ipAddr : (List)ip) {
                if (!(ipAddr instanceof String)) {
                    throw new IllegalArgumentException("array in field [" + this.field + "] should only contain strings");
                }
                Map<String, Object> geoData = this.getGeoData((String)ipAddr);
                if (geoData.isEmpty()) {
                    geoDataList.add(null);
                    continue;
                }
                if (this.firstOnly) {
                    ingestDocument.setFieldValue(this.targetField, geoData);
                    return ingestDocument;
                }
                match = true;
                geoDataList.add(geoData);
            }
            if (match) {
                ingestDocument.setFieldValue(this.targetField, geoDataList);
            }
        } else {
            throw new IllegalArgumentException("field [" + this.field + "] should contain only string or array of strings");
        }
        return ingestDocument;
    }

    private Map<String, Object> getGeoData(String ip) throws IOException {
        Map<String, Object> geoData;
        String databaseType = this.lazyLoader.getDatabaseType();
        InetAddress ipAddress = InetAddresses.forString((String)ip);
        if (databaseType.endsWith(CITY_DB_SUFFIX)) {
            try {
                geoData = this.retrieveCityGeoData(ipAddress);
            }
            catch (AddressNotFoundRuntimeException e) {
                geoData = Collections.emptyMap();
            }
        } else if (databaseType.endsWith(COUNTRY_DB_SUFFIX)) {
            try {
                geoData = this.retrieveCountryGeoData(ipAddress);
            }
            catch (AddressNotFoundRuntimeException e) {
                geoData = Collections.emptyMap();
            }
        } else if (databaseType.endsWith(ASN_DB_SUFFIX)) {
            try {
                geoData = this.retrieveAsnGeoData(ipAddress);
            }
            catch (AddressNotFoundRuntimeException e) {
                geoData = Collections.emptyMap();
            }
        } else {
            throw new OpenSearchParseException("Unsupported database type [" + this.lazyLoader.getDatabaseType() + "]", (Throwable)new IllegalStateException(), new Object[0]);
        }
        return geoData;
    }

    public String getType() {
        return TYPE;
    }

    String getField() {
        return this.field;
    }

    String getTargetField() {
        return this.targetField;
    }

    String getDatabaseType() throws IOException {
        return this.lazyLoader.getDatabaseType();
    }

    Set<Property> getProperties() {
        return this.properties;
    }

    private Map<String, Object> retrieveCityGeoData(InetAddress ipAddress) {
        SpecialPermission.check();
        CityResponse response = (CityResponse)AccessController.doPrivileged(() -> this.cache.putIfAbsent(ipAddress, CityResponse.class, ip -> {
            try {
                return this.lazyLoader.get().city(ip);
            }
            catch (AddressNotFoundException e) {
                throw new AddressNotFoundRuntimeException(e);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }));
        Country country = response.getCountry();
        City city = response.getCity();
        Location location = response.getLocation();
        Continent continent = response.getContinent();
        Subdivision subdivision = response.getMostSpecificSubdivision();
        HashMap<String, Object> geoData = new HashMap<String, Object>();
        for (Property property : this.properties) {
            switch (property.ordinal()) {
                case 0: {
                    geoData.put("ip", NetworkAddress.format((InetAddress)ipAddress));
                    break;
                }
                case 1: {
                    String countryIsoCode = country.getIsoCode();
                    if (countryIsoCode == null) break;
                    geoData.put("country_iso_code", countryIsoCode);
                    break;
                }
                case 2: {
                    String countryName = country.getName();
                    if (countryName == null) break;
                    geoData.put("country_name", countryName);
                    break;
                }
                case 3: {
                    String continentName = continent.getName();
                    if (continentName == null) break;
                    geoData.put("continent_name", continentName);
                    break;
                }
                case 4: {
                    String countryIso = country.getIsoCode();
                    String subdivisionIso = subdivision.getIsoCode();
                    if (countryIso == null || subdivisionIso == null) break;
                    String regionIsoCode = countryIso + "-" + subdivisionIso;
                    geoData.put("region_iso_code", regionIsoCode);
                    break;
                }
                case 5: {
                    String subdivisionName = subdivision.getName();
                    if (subdivisionName == null) break;
                    geoData.put("region_name", subdivisionName);
                    break;
                }
                case 6: {
                    String cityName = city.getName();
                    if (cityName == null) break;
                    geoData.put("city_name", cityName);
                    break;
                }
                case 7: {
                    String locationTimeZone = location.getTimeZone();
                    if (locationTimeZone == null) break;
                    geoData.put("timezone", locationTimeZone);
                    break;
                }
                case 8: {
                    Double latitude = location.getLatitude();
                    Double longitude = location.getLongitude();
                    if (latitude == null || longitude == null) break;
                    HashMap<String, Double> locationObject = new HashMap<String, Double>();
                    locationObject.put("lat", latitude);
                    locationObject.put("lon", longitude);
                    geoData.put("location", locationObject);
                }
            }
        }
        return geoData;
    }

    private Map<String, Object> retrieveCountryGeoData(InetAddress ipAddress) {
        SpecialPermission.check();
        CountryResponse response = (CountryResponse)AccessController.doPrivileged(() -> this.cache.putIfAbsent(ipAddress, CountryResponse.class, ip -> {
            try {
                return this.lazyLoader.get().country(ip);
            }
            catch (AddressNotFoundException e) {
                throw new AddressNotFoundRuntimeException(e);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }));
        Country country = response.getCountry();
        Continent continent = response.getContinent();
        HashMap<String, Object> geoData = new HashMap<String, Object>();
        for (Property property : this.properties) {
            switch (property.ordinal()) {
                case 0: {
                    geoData.put("ip", NetworkAddress.format((InetAddress)ipAddress));
                    break;
                }
                case 1: {
                    String countryIsoCode = country.getIsoCode();
                    if (countryIsoCode == null) break;
                    geoData.put("country_iso_code", countryIsoCode);
                    break;
                }
                case 2: {
                    String countryName = country.getName();
                    if (countryName == null) break;
                    geoData.put("country_name", countryName);
                    break;
                }
                case 3: {
                    String continentName = continent.getName();
                    if (continentName == null) break;
                    geoData.put("continent_name", continentName);
                }
            }
        }
        return geoData;
    }

    private Map<String, Object> retrieveAsnGeoData(InetAddress ipAddress) {
        SpecialPermission.check();
        AsnResponse response = (AsnResponse)AccessController.doPrivileged(() -> this.cache.putIfAbsent(ipAddress, AsnResponse.class, ip -> {
            try {
                return this.lazyLoader.get().asn(ip);
            }
            catch (AddressNotFoundException e) {
                throw new AddressNotFoundRuntimeException(e);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }));
        Long asn = response.getAutonomousSystemNumber();
        String organization_name = response.getAutonomousSystemOrganization();
        Network network = response.getNetwork();
        HashMap<String, Object> geoData = new HashMap<String, Object>();
        for (Property property : this.properties) {
            switch (property.ordinal()) {
                case 0: {
                    geoData.put("ip", NetworkAddress.format((InetAddress)ipAddress));
                    break;
                }
                case 9: {
                    if (asn == null) break;
                    geoData.put("asn", asn);
                    break;
                }
                case 10: {
                    if (organization_name == null) break;
                    geoData.put("organization_name", organization_name);
                    break;
                }
                case 11: {
                    if (network == null) break;
                    geoData.put("network", network.toString());
                }
            }
        }
        return geoData;
    }

    static final class AddressNotFoundRuntimeException
    extends RuntimeException {
        AddressNotFoundRuntimeException(Throwable cause) {
            super(cause);
        }
    }

    static enum Property {
        IP,
        COUNTRY_ISO_CODE,
        COUNTRY_NAME,
        CONTINENT_NAME,
        REGION_ISO_CODE,
        REGION_NAME,
        CITY_NAME,
        TIMEZONE,
        LOCATION,
        ASN,
        ORGANIZATION_NAME,
        NETWORK;

        static final EnumSet<Property> ALL_CITY_PROPERTIES;
        static final EnumSet<Property> ALL_COUNTRY_PROPERTIES;
        static final EnumSet<Property> ALL_ASN_PROPERTIES;

        public static Property parseProperty(String databaseType, String value) {
            EnumSet<Property> validProperties = EnumSet.noneOf(Property.class);
            if (databaseType.endsWith(GeoIpProcessor.CITY_DB_SUFFIX)) {
                validProperties = ALL_CITY_PROPERTIES;
            } else if (databaseType.endsWith(GeoIpProcessor.COUNTRY_DB_SUFFIX)) {
                validProperties = ALL_COUNTRY_PROPERTIES;
            } else if (databaseType.endsWith(GeoIpProcessor.ASN_DB_SUFFIX)) {
                validProperties = ALL_ASN_PROPERTIES;
            }
            try {
                Property property = Property.valueOf(value.toUpperCase(Locale.ROOT));
                if (!validProperties.contains((Object)property)) {
                    throw new IllegalArgumentException("invalid");
                }
                return property;
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("illegal property value [" + value + "]. valid values are " + Arrays.toString(validProperties.toArray()));
            }
        }

        static {
            ALL_CITY_PROPERTIES = EnumSet.of(IP, new Property[]{COUNTRY_ISO_CODE, COUNTRY_NAME, CONTINENT_NAME, REGION_ISO_CODE, REGION_NAME, CITY_NAME, TIMEZONE, LOCATION});
            ALL_COUNTRY_PROPERTIES = EnumSet.of(IP, CONTINENT_NAME, COUNTRY_NAME, COUNTRY_ISO_CODE);
            ALL_ASN_PROPERTIES = EnumSet.of(IP, ASN, ORGANIZATION_NAME, NETWORK);
        }
    }

    public static final class Factory
    implements Processor.Factory {
        static final Set<Property> DEFAULT_CITY_PROPERTIES = Collections.unmodifiableSet(EnumSet.of(Property.CONTINENT_NAME, new Property[]{Property.COUNTRY_NAME, Property.COUNTRY_ISO_CODE, Property.REGION_ISO_CODE, Property.REGION_NAME, Property.CITY_NAME, Property.LOCATION}));
        static final Set<Property> DEFAULT_COUNTRY_PROPERTIES = Collections.unmodifiableSet(EnumSet.of(Property.CONTINENT_NAME, Property.COUNTRY_NAME, Property.COUNTRY_ISO_CODE));
        static final Set<Property> DEFAULT_ASN_PROPERTIES = Collections.unmodifiableSet(EnumSet.of(Property.IP, Property.ASN, Property.ORGANIZATION_NAME, Property.NETWORK));
        private final Map<String, DatabaseReaderLazyLoader> databaseReaders;
        private final IngestGeoIpModulePlugin.GeoIpCache cache;

        Map<String, DatabaseReaderLazyLoader> databaseReaders() {
            return Collections.unmodifiableMap(this.databaseReaders);
        }

        public Factory(Map<String, DatabaseReaderLazyLoader> databaseReaders, IngestGeoIpModulePlugin.GeoIpCache cache) {
            this.databaseReaders = databaseReaders;
            this.cache = cache;
        }

        public GeoIpProcessor create(Map<String, Processor.Factory> registry, String processorTag, String description, Map<String, Object> config) throws IOException {
            Set<Property> properties;
            String ipField = ConfigurationUtils.readStringProperty((String)GeoIpProcessor.TYPE, (String)processorTag, config, (String)"field");
            String targetField = ConfigurationUtils.readStringProperty((String)GeoIpProcessor.TYPE, (String)processorTag, config, (String)"target_field", (String)GeoIpProcessor.TYPE);
            String databaseFile = ConfigurationUtils.readStringProperty((String)GeoIpProcessor.TYPE, (String)processorTag, config, (String)"database_file", (String)"GeoLite2-City.mmdb");
            List propertyNames = ConfigurationUtils.readOptionalList((String)GeoIpProcessor.TYPE, (String)processorTag, config, (String)"properties");
            boolean ignoreMissing = ConfigurationUtils.readBooleanProperty((String)GeoIpProcessor.TYPE, (String)processorTag, config, (String)"ignore_missing", (boolean)false);
            boolean firstOnly = ConfigurationUtils.readBooleanProperty((String)GeoIpProcessor.TYPE, (String)processorTag, config, (String)"first_only", (boolean)true);
            DatabaseReaderLazyLoader lazyLoader = this.databaseReaders.get(databaseFile);
            if (lazyLoader == null) {
                throw ConfigurationUtils.newConfigurationException((String)GeoIpProcessor.TYPE, (String)processorTag, (String)"database_file", (String)("database file [" + databaseFile + "] doesn't exist"));
            }
            String databaseType = lazyLoader.getDatabaseType();
            if (propertyNames != null) {
                EnumSet<Property> modifiableProperties = EnumSet.noneOf(Property.class);
                for (String fieldName : propertyNames) {
                    try {
                        modifiableProperties.add(Property.parseProperty(databaseType, fieldName));
                    }
                    catch (IllegalArgumentException e) {
                        throw ConfigurationUtils.newConfigurationException((String)GeoIpProcessor.TYPE, (String)processorTag, (String)"properties", (String)e.getMessage());
                    }
                }
                properties = Collections.unmodifiableSet(modifiableProperties);
            } else if (databaseType.endsWith(GeoIpProcessor.CITY_DB_SUFFIX)) {
                properties = DEFAULT_CITY_PROPERTIES;
            } else if (databaseType.endsWith(GeoIpProcessor.COUNTRY_DB_SUFFIX)) {
                properties = DEFAULT_COUNTRY_PROPERTIES;
            } else if (databaseType.endsWith(GeoIpProcessor.ASN_DB_SUFFIX)) {
                properties = DEFAULT_ASN_PROPERTIES;
            } else {
                throw ConfigurationUtils.newConfigurationException((String)GeoIpProcessor.TYPE, (String)processorTag, (String)"database_file", (String)("Unsupported database type [" + databaseType + "]"));
            }
            return new GeoIpProcessor(processorTag, description, ipField, lazyLoader, targetField, properties, ignoreMissing, this.cache, firstOnly);
        }
    }
}

