/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import org.bouncycastle.crypto.fips.FipsSHS;
import org.bouncycastle.jcajce.provider.MacParametersCreator;
import org.bouncycastle.jcajce.spec.KMACParameterSpec;

class KMACParametersCreator<T extends FipsSHS.KMACParameters>
implements MacParametersCreator {
    private final FipsSHS.KMACParameters baseParameters;

    KMACParametersCreator(FipsSHS.KMACParameters kMACParameters) {
        this.baseParameters = kMACParameters;
    }

    public FipsSHS.KMACParameters getBaseParameters() {
        return this.baseParameters;
    }

    public FipsSHS.KMACParameters createParameters(boolean bl, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (algorithmParameterSpec instanceof IvParameterSpec) {
            return this.baseParameters.withCustomizationString(((IvParameterSpec)algorithmParameterSpec).getIV());
        }
        if (algorithmParameterSpec instanceof KMACParameterSpec) {
            KMACParameterSpec kMACParameterSpec = (KMACParameterSpec)algorithmParameterSpec;
            return this.baseParameters.withMACSize(kMACParameterSpec.getMacSizeInBits()).withCustomizationString(kMACParameterSpec.getCustomizationString());
        }
        return this.baseParameters;
    }
}

