/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.pipeline.common;

import java.util.Map;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.common.collect.Tuple;
import org.opensearch.common.document.DocumentField;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.XContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.ingest.ConfigurationUtils;
import org.opensearch.search.SearchHit;
import org.opensearch.search.pipeline.AbstractProcessor;
import org.opensearch.search.pipeline.Processor;
import org.opensearch.search.pipeline.SearchResponseProcessor;

public class RenameFieldResponseProcessor
extends AbstractProcessor
implements SearchResponseProcessor {
    private final String oldField;
    private final String newField;
    private final boolean ignoreMissing;
    public static final String TYPE = "rename_field";

    public RenameFieldResponseProcessor(String tag, String description, boolean ignoreFailure, String oldField, String newField, boolean ignoreMissing) {
        super(tag, description, ignoreFailure);
        this.oldField = oldField;
        this.newField = newField;
        this.ignoreMissing = ignoreMissing;
    }

    public String getType() {
        return TYPE;
    }

    public String getOldField() {
        return this.oldField;
    }

    public String getNewField() {
        return this.newField;
    }

    public boolean isIgnoreMissing() {
        return this.ignoreMissing;
    }

    public SearchResponse processResponse(SearchRequest request, SearchResponse response) throws Exception {
        SearchHit[] hits;
        boolean foundField = false;
        for (SearchHit hit : hits = response.getHits().getHits()) {
            BytesReference sourceRef;
            Tuple typeAndSourceMap;
            Map sourceAsMap;
            Map fields = hit.getFields();
            if (fields.containsKey(this.oldField)) {
                foundField = true;
                DocumentField old = hit.removeDocumentField(this.oldField);
                DocumentField newDocField = new DocumentField(this.newField, old.getValues());
                hit.setDocumentField(this.newField, newDocField);
            }
            if (hit.hasSource() && (sourceAsMap = (Map)(typeAndSourceMap = XContentHelper.convertToMap((BytesReference)(sourceRef = hit.getSourceRef()), (boolean)false, (MediaType)null)).v2()).containsKey(this.oldField)) {
                foundField = true;
                Object val = sourceAsMap.remove(this.oldField);
                sourceAsMap.put(this.newField, val);
                XContentBuilder builder = XContentBuilder.builder((XContent)((MediaType)typeAndSourceMap.v1()).xContent());
                builder.map(sourceAsMap);
                hit.sourceRef(BytesReference.bytes((XContentBuilder)builder));
            }
            if (foundField || this.ignoreMissing) continue;
            throw new IllegalArgumentException("Document with id " + hit.getId() + " is missing field " + this.oldField);
        }
        return response;
    }

    public static final class Factory
    implements Processor.Factory<SearchResponseProcessor> {
        Factory() {
        }

        public RenameFieldResponseProcessor create(Map<String, Processor.Factory<SearchResponseProcessor>> processorFactories, String tag, String description, boolean ignoreFailure, Map<String, Object> config, Processor.PipelineContext pipelineContext) throws Exception {
            String oldField = ConfigurationUtils.readStringProperty((String)RenameFieldResponseProcessor.TYPE, (String)tag, config, (String)"field");
            String newField = ConfigurationUtils.readStringProperty((String)RenameFieldResponseProcessor.TYPE, (String)tag, config, (String)"target_field");
            boolean ignoreMissing = ConfigurationUtils.readBooleanProperty((String)RenameFieldResponseProcessor.TYPE, (String)tag, config, (String)"ignore_missing", (boolean)false);
            return new RenameFieldResponseProcessor(tag, description, ignoreFailure, oldField, newField, ignoreMissing);
        }
    }
}

