/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.pipeline.common;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.common.collect.Tuple;
import org.opensearch.common.document.DocumentField;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.XContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.ingest.ConfigurationUtils;
import org.opensearch.search.SearchHit;
import org.opensearch.search.pipeline.AbstractProcessor;
import org.opensearch.search.pipeline.Processor;
import org.opensearch.search.pipeline.SearchResponseProcessor;

public class SplitResponseProcessor
extends AbstractProcessor
implements SearchResponseProcessor {
    public static final String TYPE = "split";
    public static final String SPLIT_FIELD = "field";
    public static final String SEPARATOR = "separator";
    public static final String PRESERVE_TRAILING = "preserve_trailing";
    public static final String TARGET_FIELD = "target_field";
    private final String splitField;
    private final String separator;
    private final boolean preserveTrailing;
    private final String targetField;

    SplitResponseProcessor(String tag, String description, boolean ignoreFailure, String splitField, String separator, boolean preserveTrailing, String targetField) {
        super(tag, description, ignoreFailure);
        this.splitField = Objects.requireNonNull(splitField);
        this.separator = Objects.requireNonNull(separator);
        this.preserveTrailing = preserveTrailing;
        this.targetField = targetField == null ? splitField : targetField;
    }

    public String getSplitField() {
        return this.splitField;
    }

    public String getSeparator() {
        return this.separator;
    }

    public boolean isPreserveTrailing() {
        return this.preserveTrailing;
    }

    public String getTargetField() {
        return this.targetField;
    }

    public String getType() {
        return TYPE;
    }

    public SearchResponse processResponse(SearchRequest request, SearchResponse response) throws Exception {
        SearchHit[] hits;
        for (SearchHit hit : hits = response.getHits().getHits()) {
            BytesReference sourceRef;
            Tuple typeAndSourceMap;
            Map sourceAsMap;
            Map fields = hit.getFields();
            if (fields.containsKey(this.splitField)) {
                DocumentField docField = (DocumentField)hit.getFields().get(this.splitField);
                if (docField == null) {
                    throw new IllegalArgumentException("field [" + this.splitField + "] is null, cannot split.");
                }
                Object val = docField.getValue();
                if (!(val instanceof String)) {
                    throw new IllegalArgumentException("field [" + this.splitField + "] is not a string, cannot split");
                }
                String[] strings = ((String)val).split(this.separator, this.preserveTrailing ? -1 : 0);
                hit.setDocumentField(this.targetField, new DocumentField(this.targetField, Arrays.asList(strings)));
            }
            if (!hit.hasSource() || !(sourceAsMap = (Map)(typeAndSourceMap = XContentHelper.convertToMap((BytesReference)(sourceRef = hit.getSourceRef()), (boolean)false, (MediaType)null)).v2()).containsKey(this.splitField)) continue;
            Object val = sourceAsMap.get(this.splitField);
            if (val instanceof String) {
                String[] strings = ((String)val).split(this.separator, this.preserveTrailing ? -1 : 0);
                sourceAsMap.put(this.targetField, Arrays.asList(strings));
            }
            XContentBuilder builder = XContentBuilder.builder((XContent)((MediaType)typeAndSourceMap.v1()).xContent());
            builder.map(sourceAsMap);
            hit.sourceRef(BytesReference.bytes((XContentBuilder)builder));
        }
        return response;
    }

    static class Factory
    implements Processor.Factory<SearchResponseProcessor> {
        Factory() {
        }

        public SplitResponseProcessor create(Map<String, Processor.Factory<SearchResponseProcessor>> processorFactories, String tag, String description, boolean ignoreFailure, Map<String, Object> config, Processor.PipelineContext pipelineContext) {
            String splitField = ConfigurationUtils.readStringProperty((String)SplitResponseProcessor.TYPE, (String)tag, config, (String)SplitResponseProcessor.SPLIT_FIELD);
            String separator = ConfigurationUtils.readStringProperty((String)SplitResponseProcessor.TYPE, (String)tag, config, (String)SplitResponseProcessor.SEPARATOR);
            boolean preserveTrailing = ConfigurationUtils.readBooleanProperty((String)SplitResponseProcessor.TYPE, (String)tag, config, (String)SplitResponseProcessor.PRESERVE_TRAILING, (boolean)false);
            String targetField = ConfigurationUtils.readStringProperty((String)SplitResponseProcessor.TYPE, (String)tag, config, (String)SplitResponseProcessor.TARGET_FIELD, (String)splitField);
            return new SplitResponseProcessor(tag, description, ignoreFailure, splitField, separator, preserveTrailing, targetField);
        }
    }
}

