/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.matchhighlight;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.matchhighlight.MatchRegionRetriever;
import org.apache.lucene.search.matchhighlight.OffsetRange;
import org.apache.lucene.search.matchhighlight.OffsetsRetrievalStrategySupplier;

public class MatchHighlighter {
    private final IndexSearcher searcher;
    private final OffsetsRetrievalStrategySupplier offsetsRetrievalStrategies;
    private final Analyzer analyzer;
    private final HashSet<String> fieldsAlwaysReturned = new HashSet();
    private final List<FieldValueHighlighter> fieldHighlighters = new ArrayList<FieldValueHighlighter>();

    public MatchHighlighter appendFieldHighlighter(FieldValueHighlighter highlighter) {
        this.fieldHighlighters.add(highlighter);
        this.fieldsAlwaysReturned.addAll(highlighter.alwaysFetchedFields());
        return this;
    }

    public void alwaysFetchFields(String ... fields) {
        for (String fld : fields) {
            this.fieldsAlwaysReturned.add(Objects.requireNonNull(fld));
        }
    }

    public MatchHighlighter(IndexSearcher searcher, Analyzer analyzer) {
        this(searcher, analyzer, MatchRegionRetriever.computeOffsetRetrievalStrategies(searcher.getIndexReader(), analyzer));
    }

    public MatchHighlighter(IndexSearcher searcher, Analyzer analyzer, OffsetsRetrievalStrategySupplier offsetsRetrievalStrategies) {
        this.searcher = searcher;
        this.offsetsRetrievalStrategies = offsetsRetrievalStrategies;
        this.analyzer = analyzer;
    }

    public Stream<DocHighlights> highlight(TopDocs topDocs, Query ... queries) throws IOException {
        LinkedHashMap docHits = new LinkedHashMap();
        for (ScoreDoc scoreDoc : topDocs.scoreDocs) {
            docHits.put(scoreDoc.doc, null);
        }
        Predicate<String> fieldsToLoadUnconditionally = this.fieldsAlwaysReturned::contains;
        Predicate<String> fieldsToLoadIfWithHits = fieldName -> this.fieldHighlighters.stream().anyMatch(highlighter -> highlighter.isApplicable((String)fieldName, true) || highlighter.isApplicable((String)fieldName, false));
        for (Query q : queries) {
            MatchRegionRetriever highlighter = new MatchRegionRetriever(this.searcher, this.searcher.rewrite(q), this.offsetsRetrievalStrategies, fieldsToLoadUnconditionally, fieldsToLoadIfWithHits);
            highlighter.highlightDocuments(topDocs, (docId, leafReader, leafDocId, fieldValueProvider, hits) -> {
                DocHit docHit = (DocHit)docHits.get(docId);
                if (docHit == null) {
                    docHit = new DocHit(docId, fieldValueProvider);
                    docHits.put(docId, docHit);
                }
                docHit.addMatches(q, hits);
            });
        }
        return docHits.values().stream().filter(Objects::nonNull).map(this::computeDocFieldValues);
    }

    private DocHighlights computeDocFieldValues(DocHit docHit) {
        DocHighlights docHighlights = new DocHighlights(docHit.docId);
        for (Map.Entry<String, List<String>> e : docHit.fieldValues.entrySet()) {
            String field = e.getKey();
            List<String> values = e.getValue();
            String contiguousValue = this.contiguousFieldValue(field, values);
            List<OffsetRange> valueRanges = this.computeValueRanges(field, values);
            List<QueryOffsetRange> offsets = docHit.matchRanges.get(field);
            List<String> formattedValues = this.fieldValueHighlighter(field, offsets != null).format(field, values, contiguousValue, valueRanges, offsets);
            if (formattedValues == null) continue;
            docHighlights.fields.put(field, formattedValues);
        }
        return docHighlights;
    }

    private List<OffsetRange> computeValueRanges(String field, List<String> values) {
        ArrayList<OffsetRange> valueRanges = new ArrayList<OffsetRange>();
        int offset = 0;
        for (CharSequence charSequence : values) {
            valueRanges.add(new OffsetRange(offset, offset + charSequence.length()));
            offset += charSequence.length();
            offset += this.analyzer.getOffsetGap(field);
        }
        return valueRanges;
    }

    private String contiguousFieldValue(String field, List<String> values) {
        String value;
        if (values.size() == 1) {
            value = values.get(0);
        } else {
            String fieldGapPadding = " ".repeat(this.analyzer.getOffsetGap(field));
            value = String.join((CharSequence)fieldGapPadding, values);
        }
        return value;
    }

    private FieldValueHighlighter fieldValueHighlighter(String field, boolean hasMatches) {
        for (FieldValueHighlighter highlighter : this.fieldHighlighters) {
            if (!highlighter.isApplicable(field, hasMatches)) continue;
            return highlighter;
        }
        throw new RuntimeException("No field highlighter could be matched to field: " + field);
    }

    public static interface FieldValueHighlighter {
        public boolean isApplicable(String var1, boolean var2);

        public List<String> format(String var1, List<String> var2, String var3, List<OffsetRange> var4, List<QueryOffsetRange> var5);

        default public Collection<String> alwaysFetchedFields() {
            return Collections.emptyList();
        }

        default public FieldValueHighlighter or(FieldValueHighlighter other) {
            final FieldValueHighlighter first = this;
            final FieldValueHighlighter second = other;
            final HashSet<String> fieldUnion = new HashSet<String>();
            fieldUnion.addAll(first.alwaysFetchedFields());
            fieldUnion.addAll(second.alwaysFetchedFields());
            return new FieldValueHighlighter(){

                @Override
                public boolean isApplicable(String field, boolean hasMatches) {
                    return first.isApplicable(field, hasMatches) || second.isApplicable(field, hasMatches);
                }

                @Override
                public List<String> format(String field, List<String> values, String contiguousValue, List<OffsetRange> valueRanges, List<QueryOffsetRange> matchOffsets) {
                    FieldValueHighlighter delegate = first.isApplicable(field, matchOffsets != null && !matchOffsets.isEmpty()) ? first : second;
                    return delegate.format(field, values, contiguousValue, valueRanges, matchOffsets);
                }

                @Override
                public Collection<String> alwaysFetchedFields() {
                    return fieldUnion;
                }
            };
        }
    }

    public static class DocHighlights {
        public final int docId;
        public final Map<String, List<String>> fields = new LinkedHashMap<String, List<String>>();

        public DocHighlights(int docId) {
            this.docId = docId;
        }
    }

    private static class DocHit {
        final int docId;
        private final LinkedHashMap<String, List<QueryOffsetRange>> matchRanges = new LinkedHashMap();
        private final LinkedHashMap<String, List<String>> fieldValues = new LinkedHashMap();

        DocHit(int docId, MatchRegionRetriever.FieldValueProvider fieldValueProvider) {
            this.docId = docId;
            for (String fieldName : fieldValueProvider) {
                this.fieldValues.put(fieldName, fieldValueProvider.getValues(fieldName));
            }
        }

        void addMatches(Query query, Map<String, List<OffsetRange>> hits) {
            hits.forEach((field, offsets) -> {
                List target = this.matchRanges.computeIfAbsent((String)field, fld -> new ArrayList());
                offsets.forEach(o -> target.add(new QueryOffsetRange(query, o.from, o.to)));
            });
        }
    }

    public static class QueryOffsetRange
    extends OffsetRange {
        public final Query query;

        public QueryOffsetRange(Query query, int from, int to) {
            super(from, to);
            this.query = query;
        }

        @Override
        public QueryOffsetRange slice(int from, int to) {
            return new QueryOffsetRange(this.query, from, to);
        }
    }
}

