/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.indices.scale.searchonly;

import org.opensearch.action.support.clustermanager.AcknowledgedResponse;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.core.action.ActionListener;
import org.opensearch.indices.replication.common.ReplicationType;

class ScaleIndexOperationValidator {
    ScaleIndexOperationValidator() {
    }

    boolean validateScalePrerequisites(IndexMetadata indexMetadata, String index, ActionListener<AcknowledgedResponse> listener, boolean isScaleDown) {
        try {
            if (indexMetadata == null) {
                throw new IllegalArgumentException("Index [" + index + "] not found");
            }
            if (isScaleDown) {
                if (indexMetadata.getSettings().getAsBoolean(IndexMetadata.INDEX_BLOCKS_SEARCH_ONLY_SETTING.getKey(), false).booleanValue()) {
                    throw new IllegalStateException("Index [" + index + "] is already in search-only mode");
                }
                if (indexMetadata.getNumberOfSearchOnlyReplicas() == 0) {
                    throw new IllegalArgumentException("Cannot scale to zero without search replicas for index: " + index);
                }
                if (!indexMetadata.getSettings().getAsBoolean("index.remote_store.enabled", false).booleanValue()) {
                    throw new IllegalArgumentException("To scale to zero, index.remote_store.enabled must be enabled for index: " + index);
                }
                if (!ReplicationType.SEGMENT.toString().equals(indexMetadata.getSettings().get("index.replication.type"))) {
                    throw new IllegalArgumentException("To scale to zero, segment replication must be enabled for index: " + index);
                }
            } else if (!indexMetadata.getSettings().getAsBoolean(IndexMetadata.INDEX_BLOCKS_SEARCH_ONLY_SETTING.getKey(), false).booleanValue()) {
                throw new IllegalStateException("Index [" + index + "] is not in search-only mode");
            }
            return true;
        }
        catch (Exception e) {
            listener.onFailure(e);
            return false;
        }
    }
}

