/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gateway.remote.model;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.opensearch.Version;
import org.opensearch.cluster.metadata.Metadata;
import org.opensearch.common.io.Streams;
import org.opensearch.common.remote.AbstractClusterMetadataWriteableBlobEntity;
import org.opensearch.common.remote.BlobPathParameters;
import org.opensearch.core.common.io.stream.NamedWriteableAwareStreamInput;
import org.opensearch.core.common.io.stream.NamedWriteableRegistry;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.compress.Compressor;
import org.opensearch.gateway.remote.ClusterMetadataManifest;
import org.opensearch.index.remote.RemoteStoreUtils;
import org.opensearch.repositories.blobstore.ChecksumWritableBlobStoreFormat;

public class RemoteCustomMetadata
extends AbstractClusterMetadataWriteableBlobEntity<Metadata.Custom> {
    public static final String CUSTOM_METADATA = "custom";
    public static final String CUSTOM_DELIMITER = "--";
    public final ChecksumWritableBlobStoreFormat<Metadata.Custom> customBlobStoreFormat;
    private Metadata.Custom custom;
    private final String customType;
    private long metadataVersion;
    private final NamedWriteableRegistry namedWriteableRegistry;

    public RemoteCustomMetadata(Metadata.Custom custom, String customType, long metadataVersion, String clusterUUID, Compressor compressor, NamedWriteableRegistry namedWriteableRegistry) {
        super(clusterUUID, compressor, null);
        this.custom = custom;
        this.customType = customType;
        this.metadataVersion = metadataVersion;
        this.namedWriteableRegistry = namedWriteableRegistry;
        this.customBlobStoreFormat = new ChecksumWritableBlobStoreFormat(CUSTOM_METADATA, is -> RemoteCustomMetadata.readFrom(is, namedWriteableRegistry, customType));
    }

    public RemoteCustomMetadata(String blobName, String customType, String clusterUUID, Compressor compressor, NamedWriteableRegistry namedWriteableRegistry, Version version) {
        super(clusterUUID, compressor, null);
        this.blobName = blobName;
        this.customType = customType;
        this.namedWriteableRegistry = namedWriteableRegistry;
        this.customBlobStoreFormat = new ChecksumWritableBlobStoreFormat(CUSTOM_METADATA, is -> {
            is.setVersion(version);
            return RemoteCustomMetadata.readFrom(is, namedWriteableRegistry, customType);
        });
    }

    @Override
    public BlobPathParameters getBlobPathParameters() {
        String prefix = String.join((CharSequence)CUSTOM_DELIMITER, CUSTOM_METADATA, this.customType);
        return new BlobPathParameters(List.of("global-metadata"), prefix);
    }

    @Override
    public String getType() {
        return CUSTOM_METADATA;
    }

    @Override
    public String generateBlobFileName() {
        String blobFileName;
        this.blobFileName = blobFileName = String.join((CharSequence)"__", this.getBlobPathParameters().getFilePrefix(), RemoteStoreUtils.invertLong(this.metadataVersion), RemoteStoreUtils.invertLong(System.currentTimeMillis()), String.valueOf(1));
        return blobFileName;
    }

    @Override
    public InputStream serialize() throws IOException {
        return this.customBlobStoreFormat.serialize(this.custom, this.generateBlobFileName(), this.getCompressor()).streamInput();
    }

    @Override
    public Metadata.Custom deserialize(InputStream inputStream) throws IOException {
        return this.customBlobStoreFormat.deserialize(this.blobName, Streams.readFully(inputStream));
    }

    @Override
    public ClusterMetadataManifest.UploadedMetadata getUploadedMetadata() {
        assert (this.blobName != null);
        return new ClusterMetadataManifest.UploadedMetadataAttribute(String.join((CharSequence)CUSTOM_DELIMITER, CUSTOM_METADATA, this.customType), this.blobName);
    }

    public static Metadata.Custom readFrom(StreamInput streamInput, NamedWriteableRegistry namedWriteableRegistry, String customType) throws IOException {
        try (NamedWriteableAwareStreamInput in = new NamedWriteableAwareStreamInput(streamInput, namedWriteableRegistry);){
            Metadata.Custom custom = (Metadata.Custom)namedWriteableRegistry.getReader(Metadata.Custom.class, customType).read((StreamInput)in);
            return custom;
        }
    }
}

