/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.codec.composite.composite912;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.DocValuesSkipper;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.ReadAdvice;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.common.util.io.IOUtils;
import org.opensearch.index.codec.composite.CompositeIndexFieldInfo;
import org.opensearch.index.codec.composite.CompositeIndexReader;
import org.opensearch.index.codec.composite.LuceneDocValuesProducerFactory;
import org.opensearch.index.compositeindex.CompositeIndexMetadata;
import org.opensearch.index.compositeindex.datacube.Metric;
import org.opensearch.index.compositeindex.datacube.MetricStat;
import org.opensearch.index.compositeindex.datacube.startree.fileformats.meta.DimensionConfig;
import org.opensearch.index.compositeindex.datacube.startree.fileformats.meta.StarTreeMetadata;
import org.opensearch.index.compositeindex.datacube.startree.index.CompositeIndexValues;
import org.opensearch.index.compositeindex.datacube.startree.index.StarTreeValues;
import org.opensearch.index.compositeindex.datacube.startree.utils.StarTreeUtils;
import org.opensearch.index.mapper.CompositeMappedFieldType;

@ExperimentalApi
public class Composite912DocValuesReader
extends DocValuesProducer
implements CompositeIndexReader {
    private static final Logger logger = LogManager.getLogger(Composite912DocValuesReader.class);
    private final DocValuesProducer delegate;
    private IndexInput dataIn;
    private final Map<String, IndexInput> compositeIndexInputMap = new LinkedHashMap<String, IndexInput>();
    private final Map<String, CompositeIndexMetadata> compositeIndexMetadataMap = new LinkedHashMap<String, CompositeIndexMetadata>();
    private final List<String> fields;
    private DocValuesProducer compositeDocValuesProducer;
    private final List<CompositeIndexFieldInfo> compositeFieldInfos = new ArrayList<CompositeIndexFieldInfo>();
    private SegmentReadState readState;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Composite912DocValuesReader(DocValuesProducer producer, SegmentReadState readState) throws IOException {
        this.delegate = producer;
        this.fields = new ArrayList<String>();
        String metaFileName = IndexFileNames.segmentFileName((String)readState.segmentInfo.name, (String)readState.segmentSuffix, (String)"cim");
        String dataFileName = IndexFileNames.segmentFileName((String)readState.segmentInfo.name, (String)readState.segmentSuffix, (String)"cid");
        boolean success = false;
        try (ChecksumIndexInput metaIn = readState.directory.openChecksumInput(metaFileName);){
            this.dataIn = readState.directory.openInput(dataFileName, readState.context.withReadAdvice(ReadAdvice.NORMAL));
            CodecUtil.checkIndexHeader((DataInput)this.dataIn, (String)"Composite912FormatData", (int)0, (int)0, (byte[])readState.segmentInfo.getId(), (String)readState.segmentSuffix);
            Throwable priorE = null;
            try {
                long magicMarker;
                CodecUtil.checkIndexHeader((DataInput)metaIn, (String)"Composite912FormatMeta", (int)0, (int)0, (byte[])readState.segmentInfo.getId(), (String)readState.segmentSuffix);
                HashMap<String, DocValuesType> dimensionFieldTypeMap = new HashMap<String, DocValuesType>();
                block16: while ((magicMarker = metaIn.readLong()) != -1L) {
                    if (magicMarker < 0L) {
                        throw new CorruptIndexException("Unknown token encountered: " + magicMarker, (DataInput)metaIn);
                    }
                    if (3387940285652509L != magicMarker) {
                        logger.error("Invalid composite field magic marker");
                        throw new IOException("Invalid composite field magic marker");
                    }
                    int version = metaIn.readVInt();
                    if (1 != version) {
                        logger.error("Invalid composite field version");
                        throw new IOException("Invalid composite field version");
                    }
                    String compositeFieldName = metaIn.readString();
                    CompositeMappedFieldType.CompositeFieldType compositeFieldType = CompositeMappedFieldType.CompositeFieldType.fromName(metaIn.readString());
                    switch (compositeFieldType) {
                        case STAR_TREE: {
                            StarTreeMetadata starTreeMetadata = new StarTreeMetadata((IndexInput)metaIn, compositeFieldName, compositeFieldType, version);
                            this.compositeFieldInfos.add(new CompositeIndexFieldInfo(compositeFieldName, compositeFieldType));
                            IndexInput starTreeIndexInput = this.dataIn.slice("star-tree data slice for respective star-tree fields", starTreeMetadata.getDataStartFilePointer(), starTreeMetadata.getDataLength());
                            this.compositeIndexInputMap.put(compositeFieldName, starTreeIndexInput);
                            this.compositeIndexMetadataMap.put(compositeFieldName, starTreeMetadata);
                            Map<String, DimensionConfig> dimensionFieldToDocValuesMap = starTreeMetadata.getDimensionFields();
                            for (Map.Entry<String, DimensionConfig> dimensionEntry : dimensionFieldToDocValuesMap.entrySet()) {
                                String dimName = StarTreeUtils.fullyQualifiedFieldNameForStarTreeDimensionsDocValues(compositeFieldName, dimensionEntry.getKey());
                                this.fields.add(dimName);
                                dimensionFieldTypeMap.put(dimName, dimensionEntry.getValue().getDocValuesType());
                            }
                            for (Metric metric : starTreeMetadata.getMetrics()) {
                                for (MetricStat metricStat : metric.getBaseMetrics()) {
                                    this.fields.add(StarTreeUtils.fullyQualifiedFieldNameForStarTreeMetricsDocValues(compositeFieldName, metric.getField(), metricStat.getTypeName()));
                                }
                            }
                            continue block16;
                        }
                        default: {
                            throw new CorruptIndexException("Invalid composite field type found in the file", (DataInput)this.dataIn);
                        }
                    }
                }
                FieldInfos fieldInfos = new FieldInfos(StarTreeUtils.getFieldInfoList(this.fields, dimensionFieldTypeMap));
                this.readState = new SegmentReadState(readState.directory, readState.segmentInfo, fieldInfos, readState.context, readState.segmentSuffix);
                this.compositeDocValuesProducer = LuceneDocValuesProducerFactory.getDocValuesProducerForCompositeCodec("Composite912Codec", this.readState, "Composite912DocValuesData", "cidvd", "Composite912DocValuesMetadata", "cidvm");
            }
            catch (Throwable t) {
                priorE = t;
            }
            finally {
                CodecUtil.checkFooter((ChecksumIndexInput)metaIn, (Throwable)priorE);
            }
            success = true;
        }
        finally {
            if (!success) {
                IOUtils.closeWhileHandlingException((Closeable)((Object)this));
            }
        }
    }

    public NumericDocValues getNumeric(FieldInfo field) throws IOException {
        return this.delegate.getNumeric(field);
    }

    public BinaryDocValues getBinary(FieldInfo field) throws IOException {
        return this.delegate.getBinary(field);
    }

    public SortedDocValues getSorted(FieldInfo field) throws IOException {
        return this.delegate.getSorted(field);
    }

    public SortedNumericDocValues getSortedNumeric(FieldInfo field) throws IOException {
        return this.delegate.getSortedNumeric(field);
    }

    public SortedSetDocValues getSortedSet(FieldInfo field) throws IOException {
        return this.delegate.getSortedSet(field);
    }

    public void checkIntegrity() throws IOException {
        this.delegate.checkIntegrity();
        CodecUtil.checksumEntireFile((IndexInput)this.dataIn);
    }

    public void close() throws IOException {
        this.delegate.close();
        boolean success = false;
        try {
            IOUtils.close((Closeable)this.dataIn);
            IOUtils.close((Closeable)this.compositeDocValuesProducer);
            success = true;
        }
        finally {
            if (!success) {
                IOUtils.closeWhileHandlingException((Closeable)this.dataIn);
            }
            this.compositeIndexInputMap.clear();
            this.compositeIndexMetadataMap.clear();
            this.fields.clear();
            this.dataIn = null;
        }
    }

    @Override
    public List<CompositeIndexFieldInfo> getCompositeIndexFields() {
        return this.compositeFieldInfos;
    }

    @Override
    public CompositeIndexValues getCompositeIndexValues(CompositeIndexFieldInfo compositeIndexFieldInfo) throws IOException {
        switch (compositeIndexFieldInfo.getType()) {
            case STAR_TREE: {
                return new StarTreeValues(this.compositeIndexMetadataMap.get(compositeIndexFieldInfo.getField()), this.compositeIndexInputMap.get(compositeIndexFieldInfo.getField()), this.compositeDocValuesProducer, this.readState);
            }
        }
        throw new CorruptIndexException("Unsupported composite index field type: ", compositeIndexFieldInfo.getType().getName());
    }

    public static SortedNumericDocValues getSortedNumericDocValues(SortedNumericDocValues sortedNumeric) {
        return sortedNumeric == null ? DocValues.emptySortedNumeric() : sortedNumeric;
    }

    public DocValuesSkipper getSkipper(FieldInfo field) throws IOException {
        return this.delegate.getSkipper(field);
    }
}

