/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.compositeindex.datacube.startree.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.store.IndexInput;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.index.compositeindex.CompositeIndexMetadata;
import org.opensearch.index.compositeindex.datacube.Dimension;
import org.opensearch.index.compositeindex.datacube.Metric;
import org.opensearch.index.compositeindex.datacube.MetricStat;
import org.opensearch.index.compositeindex.datacube.ReadDimension;
import org.opensearch.index.compositeindex.datacube.startree.StarTreeField;
import org.opensearch.index.compositeindex.datacube.startree.StarTreeFieldConfiguration;
import org.opensearch.index.compositeindex.datacube.startree.fileformats.meta.DimensionConfig;
import org.opensearch.index.compositeindex.datacube.startree.fileformats.meta.StarTreeMetadata;
import org.opensearch.index.compositeindex.datacube.startree.index.CompositeIndexValues;
import org.opensearch.index.compositeindex.datacube.startree.node.StarTreeFactory;
import org.opensearch.index.compositeindex.datacube.startree.node.StarTreeNode;
import org.opensearch.index.compositeindex.datacube.startree.utils.StarTreeUtils;
import org.opensearch.index.compositeindex.datacube.startree.utils.iterator.SortedNumericStarTreeValuesIterator;
import org.opensearch.index.compositeindex.datacube.startree.utils.iterator.SortedSetStarTreeValuesIterator;
import org.opensearch.index.compositeindex.datacube.startree.utils.iterator.StarTreeValuesIterator;

@ExperimentalApi
public class StarTreeValues
implements CompositeIndexValues {
    private final StarTreeField starTreeField;
    private final StarTreeNode root;
    private final Map<String, Supplier<StarTreeValuesIterator>> dimensionValuesIteratorMap;
    private final Map<String, Supplier<StarTreeValuesIterator>> metricValuesIteratorMap;
    private final Map<String, String> attributes;
    private final StarTreeMetadata starTreeMetadata;

    public StarTreeValues(StarTreeField starTreeField, StarTreeNode root, Map<String, Supplier<StarTreeValuesIterator>> dimensionValuesIteratorMap, Map<String, Supplier<StarTreeValuesIterator>> metricValuesIteratorMap, Map<String, String> attributes, StarTreeMetadata compositeIndexMetadata) {
        this.starTreeField = starTreeField;
        this.root = root;
        this.dimensionValuesIteratorMap = dimensionValuesIteratorMap;
        this.metricValuesIteratorMap = metricValuesIteratorMap;
        this.attributes = attributes;
        this.starTreeMetadata = compositeIndexMetadata;
    }

    public StarTreeValues(CompositeIndexMetadata compositeIndexMetadata, IndexInput compositeIndexDataIn, DocValuesProducer compositeDocValuesProducer, SegmentReadState readState) throws IOException {
        this.starTreeMetadata = (StarTreeMetadata)compositeIndexMetadata;
        Set<String> skipStarNodeCreationInDims = this.starTreeMetadata.getSkipStarNodeCreationInDims();
        ArrayList<Dimension> readDimensions = new ArrayList<Dimension>();
        for (Map.Entry<String, DimensionConfig> dimensionEntry : this.starTreeMetadata.getDimensionFields().entrySet()) {
            String dimension = dimensionEntry.getKey();
            readDimensions.add(new ReadDimension(dimension, readState.fieldInfos.fieldInfo(StarTreeUtils.fullyQualifiedFieldNameForStarTreeDimensionsDocValues(this.starTreeMetadata.getCompositeFieldName(), dimension)).getDocValuesType(), dimensionEntry.getValue().getDimensionDataType()));
        }
        this.starTreeField = new StarTreeField(this.starTreeMetadata.getCompositeFieldName(), readDimensions, this.starTreeMetadata.getMetrics(), new StarTreeFieldConfiguration(this.starTreeMetadata.getMaxLeafDocs(), skipStarNodeCreationInDims, this.starTreeMetadata.getStarTreeBuildMode()));
        this.root = StarTreeFactory.createStarTree(compositeIndexDataIn, this.starTreeMetadata);
        this.dimensionValuesIteratorMap = new LinkedHashMap<String, Supplier<StarTreeValuesIterator>>();
        this.metricValuesIteratorMap = new LinkedHashMap<String, Supplier<StarTreeValuesIterator>>();
        for (String dimension : this.starTreeMetadata.getDimensionFields().keySet()) {
            this.dimensionValuesIteratorMap.put(dimension, () -> {
                try {
                    FieldInfo dimensionfieldInfo = null;
                    if (readState != null) {
                        dimensionfieldInfo = readState.fieldInfos.fieldInfo(StarTreeUtils.fullyQualifiedFieldNameForStarTreeDimensionsDocValues(this.starTreeField.getName(), dimension));
                    }
                    assert (dimensionfieldInfo != null);
                    if (dimensionfieldInfo.getDocValuesType().equals((Object)DocValuesType.SORTED_SET)) {
                        SortedSetDocValues dimensionSortedSetDocValues = compositeDocValuesProducer.getSortedSet(dimensionfieldInfo);
                        return new SortedSetStarTreeValuesIterator((DocIdSetIterator)StarTreeValues.getSortedSetDocValues(dimensionSortedSetDocValues));
                    }
                    SortedNumericDocValues dimensionSortedNumericDocValues = compositeDocValuesProducer.getSortedNumeric(dimensionfieldInfo);
                    return new SortedNumericStarTreeValuesIterator((DocIdSetIterator)StarTreeValues.getSortedNumericDocValues(dimensionSortedNumericDocValues));
                }
                catch (IOException e) {
                    throw new RuntimeException("Error loading dimension StarTreeValuesIterator", e);
                }
            });
        }
        for (Metric metric : this.starTreeMetadata.getMetrics()) {
            for (MetricStat metricStat : metric.getBaseMetrics()) {
                String metricFullName = StarTreeUtils.fullyQualifiedFieldNameForStarTreeMetricsDocValues(this.starTreeField.getName(), metric.getField(), metricStat.getTypeName());
                this.metricValuesIteratorMap.put(metricFullName, () -> {
                    try {
                        FieldInfo metricFieldInfo;
                        SortedNumericDocValues metricSortedNumericDocValues = null;
                        if (readState != null && (metricFieldInfo = readState.fieldInfos.fieldInfo(metricFullName)) != null) {
                            metricSortedNumericDocValues = compositeDocValuesProducer.getSortedNumeric(metricFieldInfo);
                        }
                        return new SortedNumericStarTreeValuesIterator((DocIdSetIterator)StarTreeValues.getSortedNumericDocValues(metricSortedNumericDocValues));
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Error loading metric DocIdSetIterator", e);
                    }
                });
            }
        }
        this.attributes = Map.of("segmentDocsCount", String.valueOf(this.starTreeMetadata.getSegmentAggregatedDocCount()), "starTreeDocsCount", String.valueOf(this.starTreeMetadata.getStarTreeDocCount()));
    }

    @Override
    public CompositeIndexValues getValues() {
        return this;
    }

    public StarTreeField getStarTreeField() {
        return this.starTreeField;
    }

    public StarTreeNode getRoot() {
        return this.root;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public StarTreeValuesIterator getDimensionValuesIterator(String dimension) {
        if (this.dimensionValuesIteratorMap.containsKey(dimension)) {
            return this.dimensionValuesIteratorMap.get(dimension).get();
        }
        throw new IllegalArgumentException("dimension [" + dimension + "] does not exist in the segment.");
    }

    public StarTreeValuesIterator getMetricValuesIterator(String fullyQualifiedMetricName) {
        if (this.metricValuesIteratorMap.containsKey(fullyQualifiedMetricName)) {
            return this.metricValuesIteratorMap.get(fullyQualifiedMetricName).get();
        }
        throw new IllegalArgumentException("metric [" + fullyQualifiedMetricName + "] does not exist in the segment.");
    }

    public int getStarTreeDocumentCount() {
        return this.starTreeMetadata.getStarTreeDocCount();
    }

    static SortedNumericDocValues getSortedNumericDocValues(SortedNumericDocValues sortedNumeric) {
        return sortedNumeric == null ? DocValues.emptySortedNumeric() : sortedNumeric;
    }

    static SortedSetDocValues getSortedSetDocValues(SortedSetDocValues sortedSetDv) {
        return sortedSetDv == null ? DocValues.emptySortedSet() : sortedSetDv;
    }
}

