/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.backpressure.trackers;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.search.backpressure.trackers.TaskResourceUsageTrackerType;
import org.opensearch.tasks.CancellableTask;
import org.opensearch.tasks.Task;
import org.opensearch.tasks.TaskCancellation;

public class TaskResourceUsageTrackers {
    private final EnumMap<TaskResourceUsageTrackerType, TaskResourceUsageTracker> all = new EnumMap(TaskResourceUsageTrackerType.class);

    public void addTracker(TaskResourceUsageTracker tracker, TaskResourceUsageTrackerType trackerType) {
        this.all.put(trackerType, tracker);
    }

    public Optional<TaskResourceUsageTracker> getTracker(TaskResourceUsageTrackerType type) {
        return Optional.ofNullable(this.all.get((Object)type));
    }

    public List<TaskResourceUsageTracker> all() {
        return new ArrayList<TaskResourceUsageTracker>(this.all.values());
    }

    public static abstract class TaskResourceUsageTracker {
        private final AtomicLong cancellations = new AtomicLong();
        protected ResourceUsageBreachEvaluator resourceUsageBreachEvaluator;

        public void setResourceUsageBreachEvaluator(ResourceUsageBreachEvaluator resourceUsageBreachEvaluator) {
            this.resourceUsageBreachEvaluator = resourceUsageBreachEvaluator;
        }

        public long incrementCancellations() {
            return this.cancellations.incrementAndGet();
        }

        public long getCancellations() {
            return this.cancellations.get();
        }

        public abstract String name();

        public void update(Task task) {
        }

        public Optional<TaskCancellation.Reason> checkAndMaybeGetCancellationReason(Task task) {
            return this.resourceUsageBreachEvaluator.evaluate(task);
        }

        public abstract Stats stats(List<? extends Task> var1);

        public List<TaskCancellation> getTaskCancellations(List<CancellableTask> tasks) {
            return tasks.stream().map(task -> this.getTaskCancellation((CancellableTask)task, List.of(this::incrementCancellations))).filter(TaskCancellation::isEligibleForCancellation).collect(Collectors.toList());
        }

        private TaskCancellation getTaskCancellation(CancellableTask task, List<Runnable> cancellationCallback) {
            Optional<TaskCancellation.Reason> reason = this.checkAndMaybeGetCancellationReason(task);
            ArrayList<TaskCancellation.Reason> reasons = new ArrayList<TaskCancellation.Reason>();
            reason.ifPresent(reasons::add);
            return new TaskCancellation(task, reasons, cancellationCallback);
        }

        public static interface ResourceUsageBreachEvaluator {
            public Optional<TaskCancellation.Reason> evaluate(Task var1);
        }

        public static interface Stats
        extends ToXContentObject,
        Writeable {
        }
    }
}

