/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport.grpc.proto.request.search.query;

import com.google.protobuf.ProtocolStringList;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import org.apache.lucene.util.BytesRef;
import org.opensearch.core.common.bytes.BytesArray;
import org.opensearch.index.query.AbstractQueryBuilder;
import org.opensearch.index.query.TermsQueryBuilder;
import org.opensearch.indices.TermsLookup;
import org.opensearch.protobufs.TermsLookupField;
import org.opensearch.protobufs.TermsLookupFieldStringArrayMap;
import org.opensearch.protobufs.TermsQueryField;
import org.opensearch.protobufs.ValueType;
import org.opensearch.transport.grpc.proto.request.search.query.TermsLookupProtoUtils;

public class TermsQueryBuilderProtoUtils {
    private TermsQueryBuilderProtoUtils() {
    }

    protected static TermsQueryBuilder fromProto(TermsQueryField termsQueryProto) {
        TermsQueryBuilder termsQueryBuilder;
        String fieldName = null;
        List<Object> values = null;
        TermsLookup termsLookup = null;
        String queryName = null;
        float boost = 1.0f;
        String valueTypeStr = TermsQueryBuilder.ValueType.DEFAULT.name();
        if (termsQueryProto.hasBoost()) {
            boost = termsQueryProto.getBoost();
        }
        if (termsQueryProto.hasUnderscoreName()) {
            queryName = termsQueryProto.getUnderscoreName();
        }
        if (termsQueryProto.hasValueType()) {
            valueTypeStr = TermsQueryBuilderProtoUtils.parseValueType(termsQueryProto.getValueType()).name();
        }
        if (termsQueryProto.getTermsLookupFieldStringArrayMapMap().size() > 1) {
            throw new IllegalArgumentException("[terms] query does not support more than one field. ");
        }
        for (Map.Entry entry : termsQueryProto.getTermsLookupFieldStringArrayMapMap().entrySet()) {
            fieldName = (String)entry.getKey();
            TermsLookupFieldStringArrayMap termsLookupFieldStringArrayMap = (TermsLookupFieldStringArrayMap)entry.getValue();
            if (termsLookupFieldStringArrayMap.hasTermsLookupField()) {
                TermsLookupField termsLookupField = termsLookupFieldStringArrayMap.getTermsLookupField();
                termsLookup = TermsLookupProtoUtils.parseTermsLookup(termsLookupField);
                continue;
            }
            if (termsLookupFieldStringArrayMap.hasStringArray()) {
                values = TermsQueryBuilderProtoUtils.parseValues(termsLookupFieldStringArrayMap.getStringArray().getStringArrayList());
                continue;
            }
            throw new IllegalArgumentException("termsLookupField and stringArray fields cannot both be null");
        }
        TermsQueryBuilder.ValueType valueType = TermsQueryBuilder.ValueType.fromString((String)valueTypeStr);
        if (valueType == TermsQueryBuilder.ValueType.BITMAP) {
            if (values != null && values.size() == 1 && values.get(0) instanceof BytesRef) {
                values.set(0, new BytesArray(Base64.getDecoder().decode(((BytesRef)values.get(0)).utf8ToString())));
            } else if (termsLookup == null) {
                throw new IllegalArgumentException("Invalid value for bitmap type: Expected a single-element array with a base64 encoded serialized bitmap.");
            }
        }
        if (values == null) {
            termsQueryBuilder = new TermsQueryBuilder(fieldName, termsLookup);
        } else if (termsLookup == null) {
            termsQueryBuilder = new TermsQueryBuilder(fieldName, (Iterable)values);
        } else {
            throw new IllegalArgumentException("values and termsLookup cannot both be null");
        }
        return ((TermsQueryBuilder)((TermsQueryBuilder)termsQueryBuilder.boost(boost)).queryName(queryName)).valueType(valueType);
    }

    public static TermsQueryBuilder.ValueType parseValueType(ValueType valueType) {
        switch (valueType) {
            case VALUE_TYPE_BITMAP: {
                return TermsQueryBuilder.ValueType.BITMAP;
            }
            case VALUE_TYPE_DEFAULT: {
                return TermsQueryBuilder.ValueType.DEFAULT;
            }
        }
        return TermsQueryBuilder.ValueType.DEFAULT;
    }

    static List<Object> parseValues(ProtocolStringList termsLookupFieldStringArray) throws IllegalArgumentException {
        ArrayList<Object> values = new ArrayList<Object>();
        for (Object value : termsLookupFieldStringArray) {
            Object convertedValue = AbstractQueryBuilder.maybeConvertToBytesRef(value);
            if (value == null) {
                throw new IllegalArgumentException("No value specified for terms query");
            }
            values.add(convertedValue);
        }
        return values;
    }
}

