/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport.grpc.proto.response.exceptions;

import java.util.HashMap;
import java.util.Map;
import org.opensearch.protobufs.ObjectMap;
import org.opensearch.script.ScriptException;
import org.opensearch.transport.grpc.proto.response.common.ObjectMapProtoUtils;

public class ScriptExceptionProtoUtils {
    private ScriptExceptionProtoUtils() {
    }

    public static Map<String, ObjectMap.Value> metadataToProto(ScriptException exception) {
        Map<String, ObjectMap.Value> map = new HashMap<String, ObjectMap.Value>();
        map.put("script_stack", ObjectMapProtoUtils.toProto(exception.getScriptStack()));
        map.put("script", ObjectMapProtoUtils.toProto(exception.getScript()));
        map.put("lang", ObjectMapProtoUtils.toProto(exception.getLang()));
        if (exception.getPos() != null) {
            map = ScriptExceptionProtoUtils.toProto(map, exception.getPos());
        }
        return map;
    }

    public static Map<String, ObjectMap.Value> toProto(Map<String, ObjectMap.Value> map, ScriptException.Position pos) {
        ObjectMap.Builder positionMapBuilder = ObjectMap.newBuilder();
        positionMapBuilder.putFields("offset", ObjectMapProtoUtils.toProto(pos.offset));
        positionMapBuilder.putFields("start", ObjectMapProtoUtils.toProto(pos.start));
        positionMapBuilder.putFields("end", ObjectMapProtoUtils.toProto(pos.end));
        ObjectMap.Value positionValue = ObjectMap.Value.newBuilder().setObjectMap(positionMapBuilder.build()).build();
        map.put("position", positionValue);
        return map;
    }
}

