/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport.grpc.proto.response.exceptions.opensearchexception;

import java.io.IOException;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opensearch.ExceptionsHelper;
import org.opensearch.OpenSearchException;
import org.opensearch.action.FailedNodeException;
import org.opensearch.action.search.SearchPhaseExecutionException;
import org.opensearch.common.breaker.ResponseLimitBreachedException;
import org.opensearch.core.common.ParsingException;
import org.opensearch.core.common.breaker.CircuitBreakingException;
import org.opensearch.protobufs.ErrorCause;
import org.opensearch.protobufs.ObjectMap;
import org.opensearch.protobufs.StringArray;
import org.opensearch.protobufs.StringOrStringArray;
import org.opensearch.script.ScriptException;
import org.opensearch.search.SearchParseException;
import org.opensearch.search.aggregations.MultiBucketConsumerService;
import org.opensearch.transport.grpc.proto.response.exceptions.CircuitBreakingExceptionProtoUtils;
import org.opensearch.transport.grpc.proto.response.exceptions.FailedNodeExceptionProtoUtils;
import org.opensearch.transport.grpc.proto.response.exceptions.ParsingExceptionProtoUtils;
import org.opensearch.transport.grpc.proto.response.exceptions.ResponseLimitBreachedExceptionProtoUtils;
import org.opensearch.transport.grpc.proto.response.exceptions.ScriptExceptionProtoUtils;
import org.opensearch.transport.grpc.proto.response.exceptions.SearchParseExceptionProtoUtils;
import org.opensearch.transport.grpc.proto.response.exceptions.SearchPhaseExecutionExceptionProtoUtils;
import org.opensearch.transport.grpc.proto.response.exceptions.TooManyBucketsExceptionProtoUtils;

public class OpenSearchExceptionProtoUtils {
    private OpenSearchExceptionProtoUtils() {
    }

    public static ErrorCause toProto(OpenSearchException exception) throws IOException {
        Throwable ex = ExceptionsHelper.unwrapCause((Throwable)exception);
        if (ex != exception) {
            return OpenSearchExceptionProtoUtils.generateThrowableProto(ex);
        }
        return OpenSearchExceptionProtoUtils.innerToProto((Throwable)exception, OpenSearchException.getExceptionName((Throwable)exception), exception.getMessage(), exception.getHeaders(), exception.getMetadata(), exception.getCause());
    }

    public static ErrorCause generateThrowableProto(Throwable t) throws IOException {
        if ((t = ExceptionsHelper.unwrapCause((Throwable)t)) instanceof OpenSearchException) {
            return OpenSearchExceptionProtoUtils.toProto((OpenSearchException)t);
        }
        return OpenSearchExceptionProtoUtils.innerToProto(t, OpenSearchException.getExceptionName((Throwable)t), t.getMessage(), Collections.emptyMap(), Collections.emptyMap(), t.getCause());
    }

    /*
     * WARNING - void declaration
     */
    public static ErrorCause innerToProto(Throwable throwable, String type, String message, Map<String, List<String>> headers, Map<String, List<String>> metadata, Throwable cause) throws IOException {
        Map.Entry<String, StringOrStringArray> protoEntry;
        ErrorCause.Builder errorCauseBuilder = ErrorCause.newBuilder();
        errorCauseBuilder.setType(type);
        if (message != null) {
            errorCauseBuilder.setReason(message);
        }
        for (Map.Entry<String, List<String>> entry : metadata.entrySet()) {
            protoEntry = OpenSearchExceptionProtoUtils.headerToValueProto(entry.getKey().substring("opensearch.".length()), entry.getValue());
            errorCauseBuilder.putMetadata((String)protoEntry.getKey(), (ObjectMap.Value)protoEntry.getValue());
        }
        if (throwable instanceof OpenSearchException) {
            OpenSearchException exception = (OpenSearchException)throwable;
            Map<String, ObjectMap.Value> map = OpenSearchExceptionProtoUtils.metadataToProto(exception);
            for (Map.Entry entry : map.entrySet()) {
                errorCauseBuilder.putMetadata((String)entry.getKey(), (ObjectMap.Value)entry.getValue());
            }
        }
        if (cause != null) {
            errorCauseBuilder.setCausedBy(OpenSearchExceptionProtoUtils.generateThrowableProto(cause));
        }
        if (!headers.isEmpty()) {
            for (Map.Entry entry : headers.entrySet()) {
                protoEntry = OpenSearchExceptionProtoUtils.headerToProto((String)entry.getKey(), (List)entry.getValue());
                errorCauseBuilder.putHeader(protoEntry.getKey(), protoEntry.getValue());
            }
        }
        errorCauseBuilder.setStackTrace(ExceptionsHelper.stackTrace((Throwable)throwable));
        Throwable[] allSuppressed = throwable.getSuppressed();
        if (allSuppressed.length > 0) {
            void var10_18;
            Throwable[] throwableArray = allSuppressed;
            int n = throwableArray.length;
            boolean bl = false;
            while (var10_18 < n) {
                Throwable suppressed = throwableArray[var10_18];
                errorCauseBuilder.addSuppressed(OpenSearchExceptionProtoUtils.generateThrowableProto(suppressed));
                ++var10_18;
            }
        }
        return errorCauseBuilder.build();
    }

    public static Map.Entry<String, StringOrStringArray> headerToProto(String key, List<String> values) throws IOException {
        if (values != null && !values.isEmpty()) {
            if (values.size() == 1) {
                return new AbstractMap.SimpleEntry<String, StringOrStringArray>(key, StringOrStringArray.newBuilder().setStringValue(values.get(0)).build());
            }
            StringArray.Builder stringArrayBuilder = StringArray.newBuilder();
            for (String val : values) {
                stringArrayBuilder.addStringArray(val);
            }
            StringOrStringArray stringOrStringArray = StringOrStringArray.newBuilder().setStringArray(stringArrayBuilder.build()).build();
            return new AbstractMap.SimpleEntry<String, StringOrStringArray>(key, stringOrStringArray);
        }
        return null;
    }

    public static Map.Entry<String, ObjectMap.Value> headerToValueProto(String key, List<String> values) throws IOException {
        if (values != null && !values.isEmpty()) {
            if (values.size() == 1) {
                return new AbstractMap.SimpleEntry<String, ObjectMap.Value>(key, ObjectMap.Value.newBuilder().setString(values.get(0)).build());
            }
            ObjectMap.ListValue.Builder listValueBuilder = ObjectMap.ListValue.newBuilder();
            for (String val : values) {
                listValueBuilder.addValue(ObjectMap.Value.newBuilder().setString(val).build());
            }
            return new AbstractMap.SimpleEntry<String, ObjectMap.Value>(key, ObjectMap.Value.newBuilder().setListValue(listValueBuilder).build());
        }
        return null;
    }

    public static Map<String, ObjectMap.Value> metadataToProto(OpenSearchException exception) {
        if (exception instanceof CircuitBreakingException) {
            return CircuitBreakingExceptionProtoUtils.metadataToProto((CircuitBreakingException)exception);
        }
        if (exception instanceof FailedNodeException) {
            return FailedNodeExceptionProtoUtils.metadataToProto((FailedNodeException)exception);
        }
        if (exception instanceof ParsingException) {
            return ParsingExceptionProtoUtils.metadataToProto((ParsingException)exception);
        }
        if (exception instanceof ResponseLimitBreachedException) {
            return ResponseLimitBreachedExceptionProtoUtils.metadataToProto((ResponseLimitBreachedException)exception);
        }
        if (exception instanceof ScriptException) {
            return ScriptExceptionProtoUtils.metadataToProto((ScriptException)exception);
        }
        if (exception instanceof SearchParseException) {
            return SearchParseExceptionProtoUtils.metadataToProto((SearchParseException)exception);
        }
        if (exception instanceof SearchPhaseExecutionException) {
            return SearchPhaseExecutionExceptionProtoUtils.metadataToProto((SearchPhaseExecutionException)exception);
        }
        if (exception instanceof MultiBucketConsumerService.TooManyBucketsException) {
            return TooManyBucketsExceptionProtoUtils.metadataToProto((MultiBucketConsumerService.TooManyBucketsException)exception);
        }
        return new HashMap<String, ObjectMap.Value>();
    }
}

