/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.minhash;

import java.util.Map;
import org.apache.lucene.analysis.TokenFilterFactory;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.minhash.MinHashFilter;

public class MinHashFilterFactory
extends TokenFilterFactory {
    public static final String NAME = "minHash";
    private final int hashCount;
    private final int bucketCount;
    private final int hashSetSize;
    private final boolean withRotation;

    public MinHashFilterFactory(Map<String, String> args) {
        super(args);
        this.hashCount = this.getInt(args, "hashCount", 1);
        this.bucketCount = this.getInt(args, "bucketCount", 512);
        this.hashSetSize = this.getInt(args, "hashSetSize", 1);
        this.withRotation = this.getBoolean(args, "withRotation", this.bucketCount > 1);
    }

    public MinHashFilterFactory() {
        throw MinHashFilterFactory.defaultCtorException();
    }

    public TokenStream create(TokenStream input) {
        return new MinHashFilter(input, this.hashCount, this.bucketCount, this.hashSetSize, this.withRotation);
    }
}

