/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.transport;

import com.amazon.randomcutforest.parkservices.ThresholdedRandomCutForest;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.FailedNodeException;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.nodes.TransportNodesAction;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.timeseries.caching.CacheProvider;
import org.opensearch.timeseries.caching.TimeSeriesCache;
import org.opensearch.timeseries.model.ModelProfile;
import org.opensearch.timeseries.model.ProfileName;
import org.opensearch.timeseries.task.TaskCacheManager;
import org.opensearch.timeseries.transport.ProfileNodeRequest;
import org.opensearch.timeseries.transport.ProfileNodeResponse;
import org.opensearch.timeseries.transport.ProfileRequest;
import org.opensearch.timeseries.transport.ProfileResponse;
import org.opensearch.transport.TransportService;

public class BaseProfileTransportAction<RCFModelType extends ThresholdedRandomCutForest, CacheType extends TimeSeriesCache<RCFModelType>, CacheProviderType extends CacheProvider<RCFModelType, CacheType>>
extends TransportNodesAction<ProfileRequest, ProfileResponse, ProfileNodeRequest, ProfileNodeResponse> {
    private static final Logger LOG = LogManager.getLogger(BaseProfileTransportAction.class);
    private CacheProviderType cacheProvider;
    private volatile int numModelsToReturn;
    private TaskCacheManager taskCacheManager;

    public BaseProfileTransportAction(String profileAction, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, CacheProviderType cacheProvider, Settings settings, Setting<Integer> maxModelNumberPerNode, TaskCacheManager taskCacheManager) {
        super(profileAction, threadPool, clusterService, transportService, actionFilters, ProfileRequest::new, ProfileNodeRequest::new, "management", ProfileNodeResponse.class);
        this.cacheProvider = cacheProvider;
        this.numModelsToReturn = (Integer)maxModelNumberPerNode.get(settings);
        this.taskCacheManager = taskCacheManager;
        clusterService.getClusterSettings().addSettingsUpdateConsumer(maxModelNumberPerNode, it -> {
            this.numModelsToReturn = it;
        });
    }

    protected ProfileResponse newResponse(ProfileRequest request, List<ProfileNodeResponse> responses, List<FailedNodeException> failures) {
        return new ProfileResponse(this.clusterService.getClusterName(), responses, failures);
    }

    protected ProfileNodeRequest newNodeRequest(ProfileRequest request) {
        return new ProfileNodeRequest(request);
    }

    protected ProfileNodeResponse newNodeResponse(StreamInput in) throws IOException {
        return new ProfileNodeResponse(in);
    }

    protected ProfileNodeResponse nodeOperation(ProfileNodeRequest request) {
        int limit;
        String configId = request.getConfigId();
        Set<ProfileName> profiles = request.getProfilesToBeRetrieved();
        long activeEntity = 0L;
        long totalUpdates = 0L;
        Map<String, Long> modelSize = null;
        List<ModelProfile> modelProfiles = null;
        int modelCount = 0;
        boolean coordinatingNode = false;
        if (profiles.contains(ProfileName.ACTIVE_ENTITIES)) {
            activeEntity = ((CacheProvider)this.cacheProvider).get().getActiveEntities(configId);
        }
        if (profiles.contains(ProfileName.INIT_PROGRESS) || profiles.contains(ProfileName.STATE)) {
            totalUpdates = ((CacheProvider)this.cacheProvider).get().getTotalUpdates(configId);
        }
        if (profiles.contains(ProfileName.TOTAL_SIZE_IN_BYTES)) {
            modelSize = ((CacheProvider)this.cacheProvider).get().getModelSize(configId);
        }
        if (profiles.contains(ProfileName.MODELS) && (limit = Math.min(this.numModelsToReturn, modelCount = (modelProfiles = ((CacheProvider)this.cacheProvider).get().getAllModelProfile(configId)).size())) != modelCount) {
            LOG.info("model number limit reached");
            modelProfiles = modelProfiles.subList(0, limit);
        }
        if (profiles.contains(ProfileName.COORDINATING_NODE)) {
            coordinatingNode = this.taskCacheManager.getRealtimeTaskCache(configId) != null;
        }
        return new ProfileNodeResponse(this.clusterService.localNode(), modelSize, activeEntity, totalUpdates, modelProfiles, modelCount, coordinatingNode);
    }
}

