"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.renderRectAnnotations = void 0;
var color_library_wrappers_1 = require("../../../../../common/color_library_wrappers");
var rect_1 = require("../primitives/rect");
var panel_transform_1 = require("../utils/panel_transform");
function renderRectAnnotations(ctx, annotations, rectStyle, rotation, renderingArea) {
    var fillColor = color_library_wrappers_1.stringToRGB(rectStyle.fill);
    fillColor.opacity *= rectStyle.opacity;
    var fill = {
        color: fillColor,
    };
    var strokeColor = color_library_wrappers_1.stringToRGB(rectStyle.stroke);
    strokeColor.opacity *= rectStyle.opacity;
    var stroke = {
        color: strokeColor,
        width: rectStyle.strokeWidth,
    };
    var rectsLength = annotations.length;
    var _loop_1 = function (i) {
        var _a = annotations[i], rect = _a.rect, panel = _a.panel;
        panel_transform_1.withPanelTransform(ctx, panel, rotation, renderingArea, function (ctx) {
            rect_1.renderRect(ctx, rect, fill, stroke);
        });
    };
    for (var i = 0; i < rectsLength; i++) {
        _loop_1(i);
    }
}
exports.renderRectAnnotations = renderRectAnnotations;
//# sourceMappingURL=rect.js.map