"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;
var _configSchema = require("@osd/config-schema");
var _helpers = require("../services/utils/helpers");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function _default(services, router, dataSourceEnabled) {
  const {
    destinationsService
  } = services;
  const fieldValidations = {
    from: _configSchema.schema.maybe(_configSchema.schema.number()),
    size: _configSchema.schema.maybe(_configSchema.schema.number()),
    search: _configSchema.schema.maybe(_configSchema.schema.string()),
    sortField: _configSchema.schema.maybe(_configSchema.schema.string()),
    sortDirection: _configSchema.schema.maybe(_configSchema.schema.string()),
    type: _configSchema.schema.maybe(_configSchema.schema.string())
  };
  router.get({
    path: '/api/alerting/destinations',
    validate: {
      query: (0, _helpers.createValidateQuerySchema)(dataSourceEnabled, fieldValidations)
    }
  }, destinationsService.getDestinations);
  router.get({
    path: '/api/alerting/destinations/{destinationId}',
    validate: {
      params: _configSchema.schema.object({
        destinationId: _configSchema.schema.string()
      }),
      query: (0, _helpers.createValidateQuerySchema)(dataSourceEnabled)
    }
  }, destinationsService.getDestination);
  router.post({
    path: '/api/alerting/destinations',
    validate: {
      body: _configSchema.schema.any(),
      query: (0, _helpers.createValidateQuerySchema)(dataSourceEnabled)
    }
  }, destinationsService.createDestination);
  const destinationsFieldValidation = {
    ifSeqNo: _configSchema.schema.string(),
    ifPrimaryTerm: _configSchema.schema.string()
  };
  router.put({
    path: '/api/alerting/destinations/{destinationId}',
    validate: {
      params: _configSchema.schema.object({
        destinationId: _configSchema.schema.string()
      }),
      query: (0, _helpers.createValidateQuerySchema)(dataSourceEnabled, destinationsFieldValidation),
      body: _configSchema.schema.any()
    }
  }, destinationsService.updateDestination);
  router.delete({
    path: '/api/alerting/destinations/{destinationId}',
    validate: {
      params: _configSchema.schema.object({
        destinationId: _configSchema.schema.string()
      }),
      query: (0, _helpers.createValidateQuerySchema)(dataSourceEnabled)
    }
  }, destinationsService.deleteDestination);
  const queryValidationFields = {
    search: _configSchema.schema.maybe(_configSchema.schema.string()),
    size: _configSchema.schema.number()
  };
  router.get({
    path: '/api/alerting/destinations/email_accounts',
    validate: {
      query: (0, _helpers.createValidateQuerySchema)(dataSourceEnabled, queryValidationFields)
    }
  }, destinationsService.getEmailAccounts);
  router.post({
    path: '/api/alerting/destinations/email_accounts',
    validate: {
      body: _configSchema.schema.any(),
      query: (0, _helpers.createValidateQuerySchema)(dataSourceEnabled, queryValidationFields)
    }
  }, destinationsService.createEmailAccount);
  router.get({
    path: '/api/alerting/destinations/email_accounts/{id}',
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      query: (0, _helpers.createValidateQuerySchema)(dataSourceEnabled, queryValidationFields)
    }
  }, destinationsService.getEmailAccount);
  router.put({
    path: '/api/alerting/destinations/email_accounts/{id}',
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      query: (0, _helpers.createValidateQuerySchema)(dataSourceEnabled, destinationsFieldValidation),
      body: _configSchema.schema.any()
    }
  }, destinationsService.updateEmailAccount);
  router.delete({
    path: '/api/alerting/destinations/email_accounts/{id}',
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      query: (0, _helpers.createValidateQuerySchema)(dataSourceEnabled)
    }
  }, destinationsService.deleteEmailAccount);
  router.get({
    path: '/api/alerting/destinations/email_groups',
    validate: {
      query: (0, _helpers.createValidateQuerySchema)(dataSourceEnabled, queryValidationFields)
    }
  }, destinationsService.getEmailGroups);
  router.post({
    path: '/api/alerting/destinations/email_groups',
    validate: {
      body: _configSchema.schema.any(),
      query: (0, _helpers.createValidateQuerySchema)(dataSourceEnabled)
    }
  }, destinationsService.createEmailGroup);
  router.get({
    path: '/api/alerting/destinations/email_groups/{id}',
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      query: (0, _helpers.createValidateQuerySchema)(dataSourceEnabled)
    }
  }, destinationsService.getEmailGroup);
  router.put({
    path: '/api/alerting/destinations/email_groups/{id}',
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      query: (0, _helpers.createValidateQuerySchema)(dataSourceEnabled, destinationsFieldValidation),
      body: _configSchema.schema.any()
    }
  }, destinationsService.updateEmailGroup);
  router.delete({
    path: '/api/alerting/destinations/email_groups/{id}',
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      query: (0, _helpers.createValidateQuerySchema)(dataSourceEnabled)
    }
  }, destinationsService.deleteEmailGroup);
}
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJfY29uZmlnU2NoZW1hIiwicmVxdWlyZSIsIl9oZWxwZXJzIiwiX2RlZmF1bHQiLCJzZXJ2aWNlcyIsInJvdXRlciIsImRhdGFTb3VyY2VFbmFibGVkIiwiZGVzdGluYXRpb25zU2VydmljZSIsImZpZWxkVmFsaWRhdGlvbnMiLCJmcm9tIiwic2NoZW1hIiwibWF5YmUiLCJudW1iZXIiLCJzaXplIiwic2VhcmNoIiwic3RyaW5nIiwic29ydEZpZWxkIiwic29ydERpcmVjdGlvbiIsInR5cGUiLCJnZXQiLCJwYXRoIiwidmFsaWRhdGUiLCJxdWVyeSIsImNyZWF0ZVZhbGlkYXRlUXVlcnlTY2hlbWEiLCJnZXREZXN0aW5hdGlvbnMiLCJwYXJhbXMiLCJvYmplY3QiLCJkZXN0aW5hdGlvbklkIiwiZ2V0RGVzdGluYXRpb24iLCJwb3N0IiwiYm9keSIsImFueSIsImNyZWF0ZURlc3RpbmF0aW9uIiwiZGVzdGluYXRpb25zRmllbGRWYWxpZGF0aW9uIiwiaWZTZXFObyIsImlmUHJpbWFyeVRlcm0iLCJwdXQiLCJ1cGRhdGVEZXN0aW5hdGlvbiIsImRlbGV0ZSIsImRlbGV0ZURlc3RpbmF0aW9uIiwicXVlcnlWYWxpZGF0aW9uRmllbGRzIiwiZ2V0RW1haWxBY2NvdW50cyIsImNyZWF0ZUVtYWlsQWNjb3VudCIsImlkIiwiZ2V0RW1haWxBY2NvdW50IiwidXBkYXRlRW1haWxBY2NvdW50IiwiZGVsZXRlRW1haWxBY2NvdW50IiwiZ2V0RW1haWxHcm91cHMiLCJjcmVhdGVFbWFpbEdyb3VwIiwiZ2V0RW1haWxHcm91cCIsInVwZGF0ZUVtYWlsR3JvdXAiLCJkZWxldGVFbWFpbEdyb3VwIiwibW9kdWxlIiwiZXhwb3J0cyIsImRlZmF1bHQiXSwic291cmNlcyI6WyJkZXN0aW5hdGlvbnMuanMiXSwic291cmNlc0NvbnRlbnQiOlsiLypcbiAqIENvcHlyaWdodCBPcGVuU2VhcmNoIENvbnRyaWJ1dG9yc1xuICogU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjBcbiAqL1xuXG5pbXBvcnQgeyBzY2hlbWEgfSBmcm9tICdAb3NkL2NvbmZpZy1zY2hlbWEnO1xuaW1wb3J0IHsgY3JlYXRlVmFsaWRhdGVRdWVyeVNjaGVtYSB9IGZyb20gJy4uL3NlcnZpY2VzL3V0aWxzL2hlbHBlcnMnO1xuXG5leHBvcnQgZGVmYXVsdCBmdW5jdGlvbiAoc2VydmljZXMsIHJvdXRlciwgZGF0YVNvdXJjZUVuYWJsZWQpIHtcbiAgY29uc3QgeyBkZXN0aW5hdGlvbnNTZXJ2aWNlIH0gPSBzZXJ2aWNlcztcblxuICBjb25zdCBmaWVsZFZhbGlkYXRpb25zID0ge1xuICAgIGZyb206IHNjaGVtYS5tYXliZShzY2hlbWEubnVtYmVyKCkpLFxuICAgIHNpemU6IHNjaGVtYS5tYXliZShzY2hlbWEubnVtYmVyKCkpLFxuICAgIHNlYXJjaDogc2NoZW1hLm1heWJlKHNjaGVtYS5zdHJpbmcoKSksXG4gICAgc29ydEZpZWxkOiBzY2hlbWEubWF5YmUoc2NoZW1hLnN0cmluZygpKSxcbiAgICBzb3J0RGlyZWN0aW9uOiBzY2hlbWEubWF5YmUoc2NoZW1hLnN0cmluZygpKSxcbiAgICB0eXBlOiBzY2hlbWEubWF5YmUoc2NoZW1hLnN0cmluZygpKSxcbiAgfTtcbiAgcm91dGVyLmdldChcbiAgICB7XG4gICAgICBwYXRoOiAnL2FwaS9hbGVydGluZy9kZXN0aW5hdGlvbnMnLFxuICAgICAgdmFsaWRhdGU6IHtcbiAgICAgICAgcXVlcnk6IGNyZWF0ZVZhbGlkYXRlUXVlcnlTY2hlbWEoZGF0YVNvdXJjZUVuYWJsZWQsIGZpZWxkVmFsaWRhdGlvbnMpLFxuICAgICAgfSxcbiAgICB9LFxuICAgIGRlc3RpbmF0aW9uc1NlcnZpY2UuZ2V0RGVzdGluYXRpb25zXG4gICk7XG5cbiAgcm91dGVyLmdldChcbiAgICB7XG4gICAgICBwYXRoOiAnL2FwaS9hbGVydGluZy9kZXN0aW5hdGlvbnMve2Rlc3RpbmF0aW9uSWR9JyxcbiAgICAgIHZhbGlkYXRlOiB7XG4gICAgICAgIHBhcmFtczogc2NoZW1hLm9iamVjdCh7XG4gICAgICAgICAgZGVzdGluYXRpb25JZDogc2NoZW1hLnN0cmluZygpLFxuICAgICAgICB9KSxcbiAgICAgICAgcXVlcnk6IGNyZWF0ZVZhbGlkYXRlUXVlcnlTY2hlbWEoZGF0YVNvdXJjZUVuYWJsZWQpLFxuICAgICAgfSxcbiAgICB9LFxuICAgIGRlc3RpbmF0aW9uc1NlcnZpY2UuZ2V0RGVzdGluYXRpb25cbiAgKTtcblxuICByb3V0ZXIucG9zdChcbiAgICB7XG4gICAgICBwYXRoOiAnL2FwaS9hbGVydGluZy9kZXN0aW5hdGlvbnMnLFxuICAgICAgdmFsaWRhdGU6IHtcbiAgICAgICAgYm9keTogc2NoZW1hLmFueSgpLFxuICAgICAgICBxdWVyeTogY3JlYXRlVmFsaWRhdGVRdWVyeVNjaGVtYShkYXRhU291cmNlRW5hYmxlZCksXG4gICAgICB9LFxuICAgIH0sXG4gICAgZGVzdGluYXRpb25zU2VydmljZS5jcmVhdGVEZXN0aW5hdGlvblxuICApO1xuXG4gIGNvbnN0IGRlc3RpbmF0aW9uc0ZpZWxkVmFsaWRhdGlvbiA9IHtcbiAgICBpZlNlcU5vOiBzY2hlbWEuc3RyaW5nKCksXG4gICAgaWZQcmltYXJ5VGVybTogc2NoZW1hLnN0cmluZygpLFxuICB9O1xuXG4gIHJvdXRlci5wdXQoXG4gICAge1xuICAgICAgcGF0aDogJy9hcGkvYWxlcnRpbmcvZGVzdGluYXRpb25zL3tkZXN0aW5hdGlvbklkfScsXG4gICAgICB2YWxpZGF0ZToge1xuICAgICAgICBwYXJhbXM6IHNjaGVtYS5vYmplY3Qoe1xuICAgICAgICAgIGRlc3RpbmF0aW9uSWQ6IHNjaGVtYS5zdHJpbmcoKSxcbiAgICAgICAgfSksXG4gICAgICAgIHF1ZXJ5OiBjcmVhdGVWYWxpZGF0ZVF1ZXJ5U2NoZW1hKGRhdGFTb3VyY2VFbmFibGVkLCBkZXN0aW5hdGlvbnNGaWVsZFZhbGlkYXRpb24pLFxuICAgICAgICBib2R5OiBzY2hlbWEuYW55KCksXG4gICAgICB9LFxuICAgIH0sXG4gICAgZGVzdGluYXRpb25zU2VydmljZS51cGRhdGVEZXN0aW5hdGlvblxuICApO1xuXG4gIHJvdXRlci5kZWxldGUoXG4gICAge1xuICAgICAgcGF0aDogJy9hcGkvYWxlcnRpbmcvZGVzdGluYXRpb25zL3tkZXN0aW5hdGlvbklkfScsXG4gICAgICB2YWxpZGF0ZToge1xuICAgICAgICBwYXJhbXM6IHNjaGVtYS5vYmplY3Qoe1xuICAgICAgICAgIGRlc3RpbmF0aW9uSWQ6IHNjaGVtYS5zdHJpbmcoKSxcbiAgICAgICAgfSksXG4gICAgICAgIHF1ZXJ5OiBjcmVhdGVWYWxpZGF0ZVF1ZXJ5U2NoZW1hKGRhdGFTb3VyY2VFbmFibGVkKSxcbiAgICAgIH0sXG4gICAgfSxcbiAgICBkZXN0aW5hdGlvbnNTZXJ2aWNlLmRlbGV0ZURlc3RpbmF0aW9uXG4gICk7XG5cbiAgY29uc3QgcXVlcnlWYWxpZGF0aW9uRmllbGRzID0ge1xuICAgIHNlYXJjaDogc2NoZW1hLm1heWJlKHNjaGVtYS5zdHJpbmcoKSksXG4gICAgc2l6ZTogc2NoZW1hLm51bWJlcigpLFxuICB9O1xuICByb3V0ZXIuZ2V0KFxuICAgIHtcbiAgICAgIHBhdGg6ICcvYXBpL2FsZXJ0aW5nL2Rlc3RpbmF0aW9ucy9lbWFpbF9hY2NvdW50cycsXG4gICAgICB2YWxpZGF0ZToge1xuICAgICAgICBxdWVyeTogY3JlYXRlVmFsaWRhdGVRdWVyeVNjaGVtYShkYXRhU291cmNlRW5hYmxlZCwgcXVlcnlWYWxpZGF0aW9uRmllbGRzKSxcbiAgICAgIH0sXG4gICAgfSxcbiAgICBkZXN0aW5hdGlvbnNTZXJ2aWNlLmdldEVtYWlsQWNjb3VudHNcbiAgKTtcblxuICByb3V0ZXIucG9zdChcbiAgICB7XG4gICAgICBwYXRoOiAnL2FwaS9hbGVydGluZy9kZXN0aW5hdGlvbnMvZW1haWxfYWNjb3VudHMnLFxuICAgICAgdmFsaWRhdGU6IHtcbiAgICAgICAgYm9keTogc2NoZW1hLmFueSgpLFxuICAgICAgICBxdWVyeTogY3JlYXRlVmFsaWRhdGVRdWVyeVNjaGVtYShkYXRhU291cmNlRW5hYmxlZCwgcXVlcnlWYWxpZGF0aW9uRmllbGRzKSxcbiAgICAgIH0sXG4gICAgfSxcbiAgICBkZXN0aW5hdGlvbnNTZXJ2aWNlLmNyZWF0ZUVtYWlsQWNjb3VudFxuICApO1xuXG4gIHJvdXRlci5nZXQoXG4gICAge1xuICAgICAgcGF0aDogJy9hcGkvYWxlcnRpbmcvZGVzdGluYXRpb25zL2VtYWlsX2FjY291bnRzL3tpZH0nLFxuICAgICAgdmFsaWRhdGU6IHtcbiAgICAgICAgcGFyYW1zOiBzY2hlbWEub2JqZWN0KHtcbiAgICAgICAgICBpZDogc2NoZW1hLnN0cmluZygpLFxuICAgICAgICB9KSxcbiAgICAgICAgcXVlcnk6IGNyZWF0ZVZhbGlkYXRlUXVlcnlTY2hlbWEoZGF0YVNvdXJjZUVuYWJsZWQsIHF1ZXJ5VmFsaWRhdGlvbkZpZWxkcyksXG4gICAgICB9LFxuICAgIH0sXG4gICAgZGVzdGluYXRpb25zU2VydmljZS5nZXRFbWFpbEFjY291bnRcbiAgKTtcblxuICByb3V0ZXIucHV0KFxuICAgIHtcbiAgICAgIHBhdGg6ICcvYXBpL2FsZXJ0aW5nL2Rlc3RpbmF0aW9ucy9lbWFpbF9hY2NvdW50cy97aWR9JyxcbiAgICAgIHZhbGlkYXRlOiB7XG4gICAgICAgIHBhcmFtczogc2NoZW1hLm9iamVjdCh7XG4gICAgICAgICAgaWQ6IHNjaGVtYS5zdHJpbmcoKSxcbiAgICAgICAgfSksXG4gICAgICAgIHF1ZXJ5OiBjcmVhdGVWYWxpZGF0ZVF1ZXJ5U2NoZW1hKGRhdGFTb3VyY2VFbmFibGVkLCBkZXN0aW5hdGlvbnNGaWVsZFZhbGlkYXRpb24pLFxuICAgICAgICBib2R5OiBzY2hlbWEuYW55KCksXG4gICAgICB9LFxuICAgIH0sXG4gICAgZGVzdGluYXRpb25zU2VydmljZS51cGRhdGVFbWFpbEFjY291bnRcbiAgKTtcblxuICByb3V0ZXIuZGVsZXRlKFxuICAgIHtcbiAgICAgIHBhdGg6ICcvYXBpL2FsZXJ0aW5nL2Rlc3RpbmF0aW9ucy9lbWFpbF9hY2NvdW50cy97aWR9JyxcbiAgICAgIHZhbGlkYXRlOiB7XG4gICAgICAgIHBhcmFtczogc2NoZW1hLm9iamVjdCh7XG4gICAgICAgICAgaWQ6IHNjaGVtYS5zdHJpbmcoKSxcbiAgICAgICAgfSksXG4gICAgICAgIHF1ZXJ5OiBjcmVhdGVWYWxpZGF0ZVF1ZXJ5U2NoZW1hKGRhdGFTb3VyY2VFbmFibGVkKSxcbiAgICAgIH0sXG4gICAgfSxcbiAgICBkZXN0aW5hdGlvbnNTZXJ2aWNlLmRlbGV0ZUVtYWlsQWNjb3VudFxuICApO1xuXG4gIHJvdXRlci5nZXQoXG4gICAge1xuICAgICAgcGF0aDogJy9hcGkvYWxlcnRpbmcvZGVzdGluYXRpb25zL2VtYWlsX2dyb3VwcycsXG4gICAgICB2YWxpZGF0ZToge1xuICAgICAgICBxdWVyeTogY3JlYXRlVmFsaWRhdGVRdWVyeVNjaGVtYShkYXRhU291cmNlRW5hYmxlZCwgcXVlcnlWYWxpZGF0aW9uRmllbGRzKSxcbiAgICAgIH0sXG4gICAgfSxcbiAgICBkZXN0aW5hdGlvbnNTZXJ2aWNlLmdldEVtYWlsR3JvdXBzXG4gICk7XG5cbiAgcm91dGVyLnBvc3QoXG4gICAge1xuICAgICAgcGF0aDogJy9hcGkvYWxlcnRpbmcvZGVzdGluYXRpb25zL2VtYWlsX2dyb3VwcycsXG4gICAgICB2YWxpZGF0ZToge1xuICAgICAgICBib2R5OiBzY2hlbWEuYW55KCksXG4gICAgICAgIHF1ZXJ5OiBjcmVhdGVWYWxpZGF0ZVF1ZXJ5U2NoZW1hKGRhdGFTb3VyY2VFbmFibGVkKSxcbiAgICAgIH0sXG4gICAgfSxcbiAgICBkZXN0aW5hdGlvbnNTZXJ2aWNlLmNyZWF0ZUVtYWlsR3JvdXBcbiAgKTtcblxuICByb3V0ZXIuZ2V0KFxuICAgIHtcbiAgICAgIHBhdGg6ICcvYXBpL2FsZXJ0aW5nL2Rlc3RpbmF0aW9ucy9lbWFpbF9ncm91cHMve2lkfScsXG4gICAgICB2YWxpZGF0ZToge1xuICAgICAgICBwYXJhbXM6IHNjaGVtYS5vYmplY3Qoe1xuICAgICAgICAgIGlkOiBzY2hlbWEuc3RyaW5nKCksXG4gICAgICAgIH0pLFxuICAgICAgICBxdWVyeTogY3JlYXRlVmFsaWRhdGVRdWVyeVNjaGVtYShkYXRhU291cmNlRW5hYmxlZCksXG4gICAgICB9LFxuICAgIH0sXG4gICAgZGVzdGluYXRpb25zU2VydmljZS5nZXRFbWFpbEdyb3VwXG4gICk7XG5cbiAgcm91dGVyLnB1dChcbiAgICB7XG4gICAgICBwYXRoOiAnL2FwaS9hbGVydGluZy9kZXN0aW5hdGlvbnMvZW1haWxfZ3JvdXBzL3tpZH0nLFxuICAgICAgdmFsaWRhdGU6IHtcbiAgICAgICAgcGFyYW1zOiBzY2hlbWEub2JqZWN0KHtcbiAgICAgICAgICBpZDogc2NoZW1hLnN0cmluZygpLFxuICAgICAgICB9KSxcbiAgICAgICAgcXVlcnk6IGNyZWF0ZVZhbGlkYXRlUXVlcnlTY2hlbWEoZGF0YVNvdXJjZUVuYWJsZWQsIGRlc3RpbmF0aW9uc0ZpZWxkVmFsaWRhdGlvbiksXG4gICAgICAgIGJvZHk6IHNjaGVtYS5hbnkoKSxcbiAgICAgIH0sXG4gICAgfSxcbiAgICBkZXN0aW5hdGlvbnNTZXJ2aWNlLnVwZGF0ZUVtYWlsR3JvdXBcbiAgKTtcblxuICByb3V0ZXIuZGVsZXRlKFxuICAgIHtcbiAgICAgIHBhdGg6ICcvYXBpL2FsZXJ0aW5nL2Rlc3RpbmF0aW9ucy9lbWFpbF9ncm91cHMve2lkfScsXG4gICAgICB2YWxpZGF0ZToge1xuICAgICAgICBwYXJhbXM6IHNjaGVtYS5vYmplY3Qoe1xuICAgICAgICAgIGlkOiBzY2hlbWEuc3RyaW5nKCksXG4gICAgICAgIH0pLFxuICAgICAgICBxdWVyeTogY3JlYXRlVmFsaWRhdGVRdWVyeVNjaGVtYShkYXRhU291cmNlRW5hYmxlZCksXG4gICAgICB9LFxuICAgIH0sXG4gICAgZGVzdGluYXRpb25zU2VydmljZS5kZWxldGVFbWFpbEdyb3VwXG4gICk7XG59XG4iXSwibWFwcGluZ3MiOiI7Ozs7OztBQUtBLElBQUFBLGFBQUEsR0FBQUMsT0FBQTtBQUNBLElBQUFDLFFBQUEsR0FBQUQsT0FBQTtBQU5BO0FBQ0E7QUFDQTtBQUNBOztBQUtlLFNBQUFFLFNBQVVDLFFBQVEsRUFBRUMsTUFBTSxFQUFFQyxpQkFBaUIsRUFBRTtFQUM1RCxNQUFNO0lBQUVDO0VBQW9CLENBQUMsR0FBR0gsUUFBUTtFQUV4QyxNQUFNSSxnQkFBZ0IsR0FBRztJQUN2QkMsSUFBSSxFQUFFQyxvQkFBTSxDQUFDQyxLQUFLLENBQUNELG9CQUFNLENBQUNFLE1BQU0sQ0FBQyxDQUFDLENBQUM7SUFDbkNDLElBQUksRUFBRUgsb0JBQU0sQ0FBQ0MsS0FBSyxDQUFDRCxvQkFBTSxDQUFDRSxNQUFNLENBQUMsQ0FBQyxDQUFDO0lBQ25DRSxNQUFNLEVBQUVKLG9CQUFNLENBQUNDLEtBQUssQ0FBQ0Qsb0JBQU0sQ0FBQ0ssTUFBTSxDQUFDLENBQUMsQ0FBQztJQUNyQ0MsU0FBUyxFQUFFTixvQkFBTSxDQUFDQyxLQUFLLENBQUNELG9CQUFNLENBQUNLLE1BQU0sQ0FBQyxDQUFDLENBQUM7SUFDeENFLGFBQWEsRUFBRVAsb0JBQU0sQ0FBQ0MsS0FBSyxDQUFDRCxvQkFBTSxDQUFDSyxNQUFNLENBQUMsQ0FBQyxDQUFDO0lBQzVDRyxJQUFJLEVBQUVSLG9CQUFNLENBQUNDLEtBQUssQ0FBQ0Qsb0JBQU0sQ0FBQ0ssTUFBTSxDQUFDLENBQUM7RUFDcEMsQ0FBQztFQUNEVixNQUFNLENBQUNjLEdBQUcsQ0FDUjtJQUNFQyxJQUFJLEVBQUUsNEJBQTRCO0lBQ2xDQyxRQUFRLEVBQUU7TUFDUkMsS0FBSyxFQUFFLElBQUFDLGtDQUF5QixFQUFDakIsaUJBQWlCLEVBQUVFLGdCQUFnQjtJQUN0RTtFQUNGLENBQUMsRUFDREQsbUJBQW1CLENBQUNpQixlQUN0QixDQUFDO0VBRURuQixNQUFNLENBQUNjLEdBQUcsQ0FDUjtJQUNFQyxJQUFJLEVBQUUsNENBQTRDO0lBQ2xEQyxRQUFRLEVBQUU7TUFDUkksTUFBTSxFQUFFZixvQkFBTSxDQUFDZ0IsTUFBTSxDQUFDO1FBQ3BCQyxhQUFhLEVBQUVqQixvQkFBTSxDQUFDSyxNQUFNLENBQUM7TUFDL0IsQ0FBQyxDQUFDO01BQ0ZPLEtBQUssRUFBRSxJQUFBQyxrQ0FBeUIsRUFBQ2pCLGlCQUFpQjtJQUNwRDtFQUNGLENBQUMsRUFDREMsbUJBQW1CLENBQUNxQixjQUN0QixDQUFDO0VBRUR2QixNQUFNLENBQUN3QixJQUFJLENBQ1Q7SUFDRVQsSUFBSSxFQUFFLDRCQUE0QjtJQUNsQ0MsUUFBUSxFQUFFO01BQ1JTLElBQUksRUFBRXBCLG9CQUFNLENBQUNxQixHQUFHLENBQUMsQ0FBQztNQUNsQlQsS0FBSyxFQUFFLElBQUFDLGtDQUF5QixFQUFDakIsaUJBQWlCO0lBQ3BEO0VBQ0YsQ0FBQyxFQUNEQyxtQkFBbUIsQ0FBQ3lCLGlCQUN0QixDQUFDO0VBRUQsTUFBTUMsMkJBQTJCLEdBQUc7SUFDbENDLE9BQU8sRUFBRXhCLG9CQUFNLENBQUNLLE1BQU0sQ0FBQyxDQUFDO0lBQ3hCb0IsYUFBYSxFQUFFekIsb0JBQU0sQ0FBQ0ssTUFBTSxDQUFDO0VBQy9CLENBQUM7RUFFRFYsTUFBTSxDQUFDK0IsR0FBRyxDQUNSO0lBQ0VoQixJQUFJLEVBQUUsNENBQTRDO0lBQ2xEQyxRQUFRLEVBQUU7TUFDUkksTUFBTSxFQUFFZixvQkFBTSxDQUFDZ0IsTUFBTSxDQUFDO1FBQ3BCQyxhQUFhLEVBQUVqQixvQkFBTSxDQUFDSyxNQUFNLENBQUM7TUFDL0IsQ0FBQyxDQUFDO01BQ0ZPLEtBQUssRUFBRSxJQUFBQyxrQ0FBeUIsRUFBQ2pCLGlCQUFpQixFQUFFMkIsMkJBQTJCLENBQUM7TUFDaEZILElBQUksRUFBRXBCLG9CQUFNLENBQUNxQixHQUFHLENBQUM7SUFDbkI7RUFDRixDQUFDLEVBQ0R4QixtQkFBbUIsQ0FBQzhCLGlCQUN0QixDQUFDO0VBRURoQyxNQUFNLENBQUNpQyxNQUFNLENBQ1g7SUFDRWxCLElBQUksRUFBRSw0Q0FBNEM7SUFDbERDLFFBQVEsRUFBRTtNQUNSSSxNQUFNLEVBQUVmLG9CQUFNLENBQUNnQixNQUFNLENBQUM7UUFDcEJDLGFBQWEsRUFBRWpCLG9CQUFNLENBQUNLLE1BQU0sQ0FBQztNQUMvQixDQUFDLENBQUM7TUFDRk8sS0FBSyxFQUFFLElBQUFDLGtDQUF5QixFQUFDakIsaUJBQWlCO0lBQ3BEO0VBQ0YsQ0FBQyxFQUNEQyxtQkFBbUIsQ0FBQ2dDLGlCQUN0QixDQUFDO0VBRUQsTUFBTUMscUJBQXFCLEdBQUc7SUFDNUIxQixNQUFNLEVBQUVKLG9CQUFNLENBQUNDLEtBQUssQ0FBQ0Qsb0JBQU0sQ0FBQ0ssTUFBTSxDQUFDLENBQUMsQ0FBQztJQUNyQ0YsSUFBSSxFQUFFSCxvQkFBTSxDQUFDRSxNQUFNLENBQUM7RUFDdEIsQ0FBQztFQUNEUCxNQUFNLENBQUNjLEdBQUcsQ0FDUjtJQUNFQyxJQUFJLEVBQUUsMkNBQTJDO0lBQ2pEQyxRQUFRLEVBQUU7TUFDUkMsS0FBSyxFQUFFLElBQUFDLGtDQUF5QixFQUFDakIsaUJBQWlCLEVBQUVrQyxxQkFBcUI7SUFDM0U7RUFDRixDQUFDLEVBQ0RqQyxtQkFBbUIsQ0FBQ2tDLGdCQUN0QixDQUFDO0VBRURwQyxNQUFNLENBQUN3QixJQUFJLENBQ1Q7SUFDRVQsSUFBSSxFQUFFLDJDQUEyQztJQUNqREMsUUFBUSxFQUFFO01BQ1JTLElBQUksRUFBRXBCLG9CQUFNLENBQUNxQixHQUFHLENBQUMsQ0FBQztNQUNsQlQsS0FBSyxFQUFFLElBQUFDLGtDQUF5QixFQUFDakIsaUJBQWlCLEVBQUVrQyxxQkFBcUI7SUFDM0U7RUFDRixDQUFDLEVBQ0RqQyxtQkFBbUIsQ0FBQ21DLGtCQUN0QixDQUFDO0VBRURyQyxNQUFNLENBQUNjLEdBQUcsQ0FDUjtJQUNFQyxJQUFJLEVBQUUsZ0RBQWdEO0lBQ3REQyxRQUFRLEVBQUU7TUFDUkksTUFBTSxFQUFFZixvQkFBTSxDQUFDZ0IsTUFBTSxDQUFDO1FBQ3BCaUIsRUFBRSxFQUFFakMsb0JBQU0sQ0FBQ0ssTUFBTSxDQUFDO01BQ3BCLENBQUMsQ0FBQztNQUNGTyxLQUFLLEVBQUUsSUFBQUMsa0NBQXlCLEVBQUNqQixpQkFBaUIsRUFBRWtDLHFCQUFxQjtJQUMzRTtFQUNGLENBQUMsRUFDRGpDLG1CQUFtQixDQUFDcUMsZUFDdEIsQ0FBQztFQUVEdkMsTUFBTSxDQUFDK0IsR0FBRyxDQUNSO0lBQ0VoQixJQUFJLEVBQUUsZ0RBQWdEO0lBQ3REQyxRQUFRLEVBQUU7TUFDUkksTUFBTSxFQUFFZixvQkFBTSxDQUFDZ0IsTUFBTSxDQUFDO1FBQ3BCaUIsRUFBRSxFQUFFakMsb0JBQU0sQ0FBQ0ssTUFBTSxDQUFDO01BQ3BCLENBQUMsQ0FBQztNQUNGTyxLQUFLLEVBQUUsSUFBQUMsa0NBQXlCLEVBQUNqQixpQkFBaUIsRUFBRTJCLDJCQUEyQixDQUFDO01BQ2hGSCxJQUFJLEVBQUVwQixvQkFBTSxDQUFDcUIsR0FBRyxDQUFDO0lBQ25CO0VBQ0YsQ0FBQyxFQUNEeEIsbUJBQW1CLENBQUNzQyxrQkFDdEIsQ0FBQztFQUVEeEMsTUFBTSxDQUFDaUMsTUFBTSxDQUNYO0lBQ0VsQixJQUFJLEVBQUUsZ0RBQWdEO0lBQ3REQyxRQUFRLEVBQUU7TUFDUkksTUFBTSxFQUFFZixvQkFBTSxDQUFDZ0IsTUFBTSxDQUFDO1FBQ3BCaUIsRUFBRSxFQUFFakMsb0JBQU0sQ0FBQ0ssTUFBTSxDQUFDO01BQ3BCLENBQUMsQ0FBQztNQUNGTyxLQUFLLEVBQUUsSUFBQUMsa0NBQXlCLEVBQUNqQixpQkFBaUI7SUFDcEQ7RUFDRixDQUFDLEVBQ0RDLG1CQUFtQixDQUFDdUMsa0JBQ3RCLENBQUM7RUFFRHpDLE1BQU0sQ0FBQ2MsR0FBRyxDQUNSO0lBQ0VDLElBQUksRUFBRSx5Q0FBeUM7SUFDL0NDLFFBQVEsRUFBRTtNQUNSQyxLQUFLLEVBQUUsSUFBQUMsa0NBQXlCLEVBQUNqQixpQkFBaUIsRUFBRWtDLHFCQUFxQjtJQUMzRTtFQUNGLENBQUMsRUFDRGpDLG1CQUFtQixDQUFDd0MsY0FDdEIsQ0FBQztFQUVEMUMsTUFBTSxDQUFDd0IsSUFBSSxDQUNUO0lBQ0VULElBQUksRUFBRSx5Q0FBeUM7SUFDL0NDLFFBQVEsRUFBRTtNQUNSUyxJQUFJLEVBQUVwQixvQkFBTSxDQUFDcUIsR0FBRyxDQUFDLENBQUM7TUFDbEJULEtBQUssRUFBRSxJQUFBQyxrQ0FBeUIsRUFBQ2pCLGlCQUFpQjtJQUNwRDtFQUNGLENBQUMsRUFDREMsbUJBQW1CLENBQUN5QyxnQkFDdEIsQ0FBQztFQUVEM0MsTUFBTSxDQUFDYyxHQUFHLENBQ1I7SUFDRUMsSUFBSSxFQUFFLDhDQUE4QztJQUNwREMsUUFBUSxFQUFFO01BQ1JJLE1BQU0sRUFBRWYsb0JBQU0sQ0FBQ2dCLE1BQU0sQ0FBQztRQUNwQmlCLEVBQUUsRUFBRWpDLG9CQUFNLENBQUNLLE1BQU0sQ0FBQztNQUNwQixDQUFDLENBQUM7TUFDRk8sS0FBSyxFQUFFLElBQUFDLGtDQUF5QixFQUFDakIsaUJBQWlCO0lBQ3BEO0VBQ0YsQ0FBQyxFQUNEQyxtQkFBbUIsQ0FBQzBDLGFBQ3RCLENBQUM7RUFFRDVDLE1BQU0sQ0FBQytCLEdBQUcsQ0FDUjtJQUNFaEIsSUFBSSxFQUFFLDhDQUE4QztJQUNwREMsUUFBUSxFQUFFO01BQ1JJLE1BQU0sRUFBRWYsb0JBQU0sQ0FBQ2dCLE1BQU0sQ0FBQztRQUNwQmlCLEVBQUUsRUFBRWpDLG9CQUFNLENBQUNLLE1BQU0sQ0FBQztNQUNwQixDQUFDLENBQUM7TUFDRk8sS0FBSyxFQUFFLElBQUFDLGtDQUF5QixFQUFDakIsaUJBQWlCLEVBQUUyQiwyQkFBMkIsQ0FBQztNQUNoRkgsSUFBSSxFQUFFcEIsb0JBQU0sQ0FBQ3FCLEdBQUcsQ0FBQztJQUNuQjtFQUNGLENBQUMsRUFDRHhCLG1CQUFtQixDQUFDMkMsZ0JBQ3RCLENBQUM7RUFFRDdDLE1BQU0sQ0FBQ2lDLE1BQU0sQ0FDWDtJQUNFbEIsSUFBSSxFQUFFLDhDQUE4QztJQUNwREMsUUFBUSxFQUFFO01BQ1JJLE1BQU0sRUFBRWYsb0JBQU0sQ0FBQ2dCLE1BQU0sQ0FBQztRQUNwQmlCLEVBQUUsRUFBRWpDLG9CQUFNLENBQUNLLE1BQU0sQ0FBQztNQUNwQixDQUFDLENBQUM7TUFDRk8sS0FBSyxFQUFFLElBQUFDLGtDQUF5QixFQUFDakIsaUJBQWlCO0lBQ3BEO0VBQ0YsQ0FBQyxFQUNEQyxtQkFBbUIsQ0FBQzRDLGdCQUN0QixDQUFDO0FBQ0g7QUFBQ0MsTUFBQSxDQUFBQyxPQUFBLEdBQUFBLE9BQUEsQ0FBQUMsT0FBQSJ9