/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.memoryoptsearch.faiss;

import java.io.IOException;
import java.util.Map;
import java.util.function.Supplier;
import lombok.Generated;
import org.apache.lucene.index.ByteVectorValues;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.VectorEncoding;
import org.apache.lucene.store.IndexInput;
import org.opensearch.knn.index.KNNVectorSimilarityFunction;
import org.opensearch.knn.memoryoptsearch.faiss.FaissIndex;
import org.opensearch.knn.memoryoptsearch.faiss.FaissSection;

public class FaissIndexFloatFlat
extends FaissIndex {
    public static final String IXF2 = "IxF2";
    public static final String IXFI = "IxFI";
    private static final Map<String, Supplier<KNNVectorSimilarityFunction>> INDEX_TYPE_TO_INDEX_FLOAT_FLAT = Map.of("IxF2", () -> KNNVectorSimilarityFunction.EUCLIDEAN, "IxFI", () -> KNNVectorSimilarityFunction.MAXIMUM_INNER_PRODUCT);
    private FaissSection floatVectors;
    private long oneVectorByteSize;
    private final KNNVectorSimilarityFunction vectorSimilarityFunction;

    public FaissIndexFloatFlat(String indexType) {
        super(indexType);
        this.vectorSimilarityFunction = INDEX_TYPE_TO_INDEX_FLOAT_FLAT.getOrDefault(indexType, () -> {
            throw new IllegalStateException("Faiss index float flat does not support the index type [" + indexType + "].");
        }).get();
    }

    @Override
    protected void doLoad(IndexInput input) throws IOException {
        this.readCommonHeader(input);
        this.oneVectorByteSize = 4L * (long)this.getDimension();
        this.floatVectors = new FaissSection(input, 4);
        if (this.floatVectors.getSectionSize() != (long)this.getTotalNumberOfVectors() * this.oneVectorByteSize) {
            throw new IllegalStateException("Got an inconsistent bytes size of vector [" + this.floatVectors.getSectionSize() + "] when faissIndexFloatFlat.totalNumberOfVectors=" + this.getTotalNumberOfVectors() + ", faissIndexFloatFlat.oneVectorByteSize=" + this.oneVectorByteSize);
        }
    }

    @Override
    public VectorEncoding getVectorEncoding() {
        return VectorEncoding.FLOAT32;
    }

    @Override
    public FloatVectorValues getFloatValues(IndexInput indexInput) {
        class FloatVectorValuesImpl
        extends FloatVectorValues {
            final IndexInput indexInput;
            final float[] buffer;

            public float[] vectorValue(int internalVectorId) throws IOException {
                this.indexInput.seek(FaissIndexFloatFlat.this.floatVectors.getBaseOffset() + (long)internalVectorId * FaissIndexFloatFlat.this.oneVectorByteSize);
                this.indexInput.readFloats(this.buffer, 0, this.buffer.length);
                return this.buffer;
            }

            public FloatVectorValues copy() {
                return new FloatVectorValuesImpl(this.indexInput.clone());
            }

            public int dimension() {
                return FaissIndexFloatFlat.this.dimension;
            }

            public int size() {
                return FaissIndexFloatFlat.this.totalNumberOfVectors;
            }

            @Generated
            public FloatVectorValuesImpl(IndexInput indexInput) {
                this.buffer = new float[FaissIndexFloatFlat.this.dimension];
                this.indexInput = indexInput;
            }
        }
        return new FloatVectorValuesImpl(indexInput);
    }

    @Override
    public ByteVectorValues getByteValues(IndexInput indexInput) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " does not support " + ByteVectorValues.class.getSimpleName());
    }

    @Override
    @Generated
    public KNNVectorSimilarityFunction getVectorSimilarityFunction() {
        return this.vectorSimilarityFunction;
    }
}

