/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.stats.events;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.opensearch.neuralsearch.settings.NeuralSearchSettingsAccessor;
import org.opensearch.neuralsearch.stats.common.StatSnapshot;
import org.opensearch.neuralsearch.stats.events.EventStatName;
import org.opensearch.neuralsearch.stats.events.EventStatType;
import org.opensearch.neuralsearch.stats.events.TimestampedEventStatSnapshot;

public class EventStatsManager {
    private static EventStatsManager INSTANCE;
    private NeuralSearchSettingsAccessor settingsAccessor;

    public static EventStatsManager instance() {
        if (INSTANCE == null) {
            INSTANCE = new EventStatsManager();
        }
        return INSTANCE;
    }

    public static void increment(EventStatName eventStatName) {
        EventStatsManager.instance().inc(eventStatName);
    }

    public void initialize(NeuralSearchSettingsAccessor settingsAccessor) {
        this.settingsAccessor = settingsAccessor;
    }

    public void inc(EventStatName eventStatName) {
        if (this.settingsAccessor.isStatsEnabled()) {
            eventStatName.getEventStat().increment();
        }
    }

    public Map<EventStatName, TimestampedEventStatSnapshot> getTimestampedEventStatSnapshots(EnumSet<EventStatName> statsToRetrieve) {
        HashMap<EventStatName, TimestampedEventStatSnapshot> eventStatsDataMap = new HashMap<EventStatName, TimestampedEventStatSnapshot>();
        for (EventStatName statName : statsToRetrieve) {
            StatSnapshot<?> snapshot;
            if (statName.getStatType() != EventStatType.TIMESTAMPED_EVENT_COUNTER || !((snapshot = statName.getEventStat().getStatSnapshot()) instanceof TimestampedEventStatSnapshot)) continue;
            eventStatsDataMap.put(statName, (TimestampedEventStatSnapshot)snapshot);
        }
        return eventStatsDataMap;
    }

    public void reset() {
        for (EventStatName statName : EventStatName.values()) {
            statName.getEventStat().reset();
        }
    }

    @Generated
    public EventStatsManager() {
    }
}

