/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.query_dsl;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch._types.query_dsl.QueryBase;
import org.opensearch.client.opensearch._types.query_dsl.QueryVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class DisMaxQuery
extends QueryBase
implements QueryVariant,
ToCopyableBuilder<Builder, DisMaxQuery> {
    @Nonnull
    private final List<Query> queries;
    @Nullable
    private final Float tieBreaker;
    public static final JsonpDeserializer<DisMaxQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DisMaxQuery::setupDisMaxQueryDeserializer);

    private DisMaxQuery(Builder builder) {
        super(builder);
        this.queries = ApiTypeHelper.unmodifiableRequired(builder.queries, (Object)this, "queries");
        this.tieBreaker = builder.tieBreaker;
    }

    public static DisMaxQuery of(Function<Builder, ObjectBuilder<DisMaxQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Query.Kind _queryKind() {
        return Query.Kind.DisMax;
    }

    @Nonnull
    public final List<Query> queries() {
        return this.queries;
    }

    @Nullable
    public final Float tieBreaker() {
        return this.tieBreaker;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("queries");
        generator.writeStartArray();
        for (Query item0 : this.queries) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
        if (this.tieBreaker != null) {
            generator.writeKey("tie_breaker");
            generator.write((double)this.tieBreaker.floatValue());
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupDisMaxQueryDeserializer(ObjectDeserializer<Builder> op) {
        DisMaxQuery.setupQueryBaseDeserializer(op);
        op.add(Builder::queries, JsonpDeserializer.arrayDeserializer(Query._DESERIALIZER), "queries");
        op.add(Builder::tieBreaker, JsonpDeserializer.floatDeserializer(), "tie_breaker");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.queries.hashCode();
        result = 31 * result + Objects.hashCode(this.tieBreaker);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DisMaxQuery other = (DisMaxQuery)o;
        return this.queries.equals(other.queries) && Objects.equals(this.tieBreaker, other.tieBreaker);
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, DisMaxQuery> {
        private List<Query> queries;
        @Nullable
        private Float tieBreaker;

        public Builder() {
        }

        private Builder(DisMaxQuery o) {
            super(o);
            this.queries = Builder._listCopy(o.queries);
            this.tieBreaker = o.tieBreaker;
        }

        private Builder(Builder o) {
            super(o);
            this.queries = Builder._listCopy(o.queries);
            this.tieBreaker = o.tieBreaker;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder queries(List<Query> list) {
            this.queries = Builder._listAddAll(this.queries, list);
            return this;
        }

        @Nonnull
        public final Builder queries(Query value, Query ... values) {
            this.queries = Builder._listAdd(this.queries, value, values);
            return this;
        }

        @Nonnull
        public final Builder queries(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.queries(fn.apply(new Query.Builder()).build(), new Query[0]);
        }

        @Nonnull
        public final Builder tieBreaker(@Nullable Float value) {
            this.tieBreaker = value;
            return this;
        }

        @Override
        @Nonnull
        public DisMaxQuery build() {
            this._checkSingleUse();
            return new DisMaxQuery(this);
        }
    }
}

