/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.query_dsl;

import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch._types.query_dsl.QueryBase;
import org.opensearch.client.opensearch._types.query_dsl.QueryVariant;
import org.opensearch.client.opensearch._types.query_dsl.TermsQueryField;
import org.opensearch.client.opensearch._types.query_dsl.TermsQueryValueType;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class TermsQuery
extends QueryBase
implements QueryVariant,
ToCopyableBuilder<Builder, TermsQuery> {
    @Nonnull
    private final String field;
    @Nonnull
    private final TermsQueryField terms;
    @Nullable
    private final TermsQueryValueType valueType;
    public static final JsonpDeserializer<TermsQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TermsQuery::setupTermsQueryDeserializer);

    private TermsQuery(Builder builder) {
        super(builder);
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.terms = ApiTypeHelper.requireNonNull(builder.terms, this, "terms");
        this.valueType = builder.valueType;
    }

    public static TermsQuery of(Function<Builder, ObjectBuilder<TermsQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Query.Kind _queryKind() {
        return Query.Kind.Terms;
    }

    @Nonnull
    public final String field() {
        return this.field;
    }

    @Nonnull
    public final TermsQueryField terms() {
        return this.terms;
    }

    @Nullable
    public final TermsQueryValueType valueType() {
        return this.valueType;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey(this.field);
        this.terms.serialize(generator, mapper);
        if (this.valueType != null) {
            generator.writeKey("value_type");
            this.valueType.serialize(generator, mapper);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupTermsQueryDeserializer(ObjectDeserializer<Builder> op) {
        TermsQuery.setupQueryBaseDeserializer(op);
        op.add(Builder::valueType, TermsQueryValueType._DESERIALIZER, "value_type");
        op.setUnknownFieldHandler((builder, name, parser, mapper) -> {
            builder.field((String)name);
            builder.terms(TermsQueryField._DESERIALIZER.deserialize((JsonParser)parser, (JsonpMapper)mapper));
        });
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.field.hashCode();
        result = 31 * result + this.terms.hashCode();
        result = 31 * result + Objects.hashCode(this.valueType);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TermsQuery other = (TermsQuery)o;
        return this.field.equals(other.field) && this.terms.equals(other.terms) && Objects.equals(this.valueType, other.valueType);
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, TermsQuery> {
        private String field;
        private TermsQueryField terms;
        @Nullable
        private TermsQueryValueType valueType;

        public Builder() {
        }

        private Builder(TermsQuery o) {
            super(o);
            this.field = o.field;
            this.terms = o.terms;
            this.valueType = o.valueType;
        }

        private Builder(Builder o) {
            super(o);
            this.field = o.field;
            this.terms = o.terms;
            this.valueType = o.valueType;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        @Nonnull
        public final Builder terms(TermsQueryField value) {
            this.terms = value;
            return this;
        }

        @Nonnull
        public final Builder terms(Function<TermsQueryField.Builder, ObjectBuilder<TermsQueryField>> fn) {
            return this.terms(fn.apply(new TermsQueryField.Builder()).build());
        }

        @Nonnull
        public final Builder valueType(@Nullable TermsQueryValueType value) {
            this.valueType = value;
            return this;
        }

        @Override
        @Nonnull
        public TermsQuery build() {
            this._checkSingleUse();
            return new TermsQuery(this);
        }
    }
}

