/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.client;

import java.net.SocketAddress;
import java.time.Duration;
import reactor.netty.http.HttpMetricsRecorder;

public interface HttpClientMetricsRecorder
extends HttpMetricsRecorder {
    public void recordDataReceivedTime(SocketAddress var1, String var2, String var3, String var4, Duration var5);

    default public void recordDataReceivedTime(SocketAddress remoteAddress, SocketAddress proxyAddress, String uri, String method, String status, Duration time) {
        this.recordDataReceivedTime(remoteAddress, uri, method, status, time);
    }

    public void recordDataSentTime(SocketAddress var1, String var2, String var3, Duration var4);

    default public void recordDataSentTime(SocketAddress remoteAddress, SocketAddress proxyAddress, String uri, String method, Duration time) {
        this.recordDataSentTime(remoteAddress, uri, method, time);
    }

    public void recordResponseTime(SocketAddress var1, String var2, String var3, String var4, Duration var5);

    default public void recordResponseTime(SocketAddress remoteAddress, SocketAddress proxyAddress, String uri, String method, String status, Duration time) {
        this.recordResponseTime(remoteAddress, uri, method, status, time);
    }

    default public void recordDataReceived(SocketAddress remoteAddress, SocketAddress proxyAddress, String uri, long bytes) {
        this.recordDataReceived(remoteAddress, uri, bytes);
    }

    default public void recordDataSent(SocketAddress remoteAddress, SocketAddress proxyAddress, String uri, long bytes) {
        this.recordDataSent(remoteAddress, uri, bytes);
    }

    default public void incrementErrorsCount(SocketAddress remoteAddress, SocketAddress proxyAddress, String uri) {
        this.incrementErrorsCount(remoteAddress, uri);
    }
}

