/*
 * Decompiled with CFR 0.152.
 */
package org.passay;

import java.util.Arrays;

public final class PasswordUtils {
    private PasswordUtils() {
    }

    public static String getMatchingCharacters(String characters, String input) {
        return PasswordUtils.getMatchingCharacters(characters, input, Integer.MAX_VALUE);
    }

    public static String getMatchingCharacters(String characters, String input, int maximumLength) {
        StringBuilder sb = new StringBuilder(input.length());
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (characters.indexOf(c) == -1) continue;
            if (sb.length() >= maximumLength) break;
            sb.append(c);
        }
        return sb.toString();
    }

    public static int countMatchingCharacters(String characters, String input) {
        return (int)input.chars().filter(x -> characters.indexOf(x) != -1).count();
    }

    public static char[] concatArrays(char[] first, char[] ... rest) {
        int totalLength = first.length;
        for (char[] array : rest) {
            if (array == null) continue;
            totalLength += array.length;
        }
        char[] result = Arrays.copyOf(first, totalLength);
        int offset = first.length;
        for (char[] array : rest) {
            if (array == null) continue;
            System.arraycopy(array, 0, result, offset, array.length);
            offset += array.length;
        }
        return result;
    }
}

