/*
 * Decompiled with CFR 0.152.
 */
package com.nulabinc.zxcvbn;

import com.nulabinc.zxcvbn.AttackTimes;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class TimeEstimates {
    private static final double GUESSES_PER_HOUR = 0.027777777777777776;
    private static final double GUESSES_ONLINE_NO_THROTTLING = 10.0;
    private static final double GUESSES_OFFLINE_SLOW_HASHING = 10000.0;
    private static final double GUESSES_OFFLINE_FAST_HASHING = 1.0E10;
    private static final int DELTA = 5;
    private static final double MINUTE = 60.0;
    private static final double HOUR = 3600.0;
    private static final double DAY = 86400.0;
    private static final double MONTH = 2678400.0;
    private static final double YEAR = 3.21408E7;
    private static final double CENTURY = 3.21408E9;

    private TimeEstimates() {
        throw new IllegalStateException("TimeEstimates should not be instantiated");
    }

    public static AttackTimes estimateAttackTimes(double guesses) {
        AttackTimes.CrackTimeSeconds crackTimeSeconds = new AttackTimes.CrackTimeSeconds(TimeEstimates.divide(guesses, 0.027777777777777776), guesses / 10.0, guesses / 10000.0, guesses / 1.0E10);
        AttackTimes.CrackTimesDisplay crackTimesDisplay = new AttackTimes.CrackTimesDisplay(TimeEstimates.displayTime(crackTimeSeconds.getOnlineThrottling100perHour()), TimeEstimates.displayTime(crackTimeSeconds.getOnlineNoThrottling10perSecond()), TimeEstimates.displayTime(crackTimeSeconds.getOfflineSlowHashing1e4perSecond()), TimeEstimates.displayTime(crackTimeSeconds.getOfflineFastHashing1e10PerSecond()));
        return new AttackTimes(crackTimeSeconds, crackTimesDisplay, TimeEstimates.guessesToScore(guesses));
    }

    public static int guessesToScore(double guesses) {
        if (guesses < 1005.0) {
            return 0;
        }
        if (guesses < 1000005.0) {
            return 1;
        }
        if (guesses < 1.00000005E8) {
            return 2;
        }
        if (guesses < 1.0000000005E10) {
            return 3;
        }
        return 4;
    }

    public static String displayTime(double seconds) {
        if (seconds < 1.0) {
            return "less than a second";
        }
        if (seconds < 60.0) {
            return TimeEstimates.format(seconds, "%s second");
        }
        if (seconds < 3600.0) {
            return TimeEstimates.format(TimeEstimates.divide(seconds, 60.0), "%s minute");
        }
        if (seconds < 86400.0) {
            return TimeEstimates.format(TimeEstimates.divide(seconds, 3600.0), "%s hour");
        }
        if (seconds < 2678400.0) {
            return TimeEstimates.format(TimeEstimates.divide(seconds, 86400.0), "%s day");
        }
        if (seconds < 3.21408E7) {
            return TimeEstimates.format(TimeEstimates.divide(seconds, 2678400.0), "%s month");
        }
        if (seconds < 3.21408E9) {
            return TimeEstimates.format(TimeEstimates.divide(seconds, 3.21408E7), "%s year");
        }
        return "centuries";
    }

    private static String format(double number, String text) {
        return String.format(text, Math.round(number)) + (number != 1.0 ? "s" : "");
    }

    private static double divide(double dividend, double divisor) {
        BigDecimal dividendDecimal = BigDecimal.valueOf(dividend);
        BigDecimal divisorDecimal = BigDecimal.valueOf(divisor);
        return dividendDecimal.divide(divisorDecimal, RoundingMode.HALF_DOWN).doubleValue();
    }
}

