/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.yaml.parser;

import net.sourceforge.plantuml.json.Json;
import net.sourceforge.plantuml.json.JsonArray;
import net.sourceforge.plantuml.json.JsonObject;
import net.sourceforge.plantuml.json.JsonValue;
import net.sourceforge.plantuml.yaml.parser.Monomorph;
import net.sourceforge.plantuml.yaml.parser.MonomorphType;

public class MonomorphToJson {
    public static JsonValue convert(Monomorph input) {
        if (input.getType() == MonomorphType.SCALAR) {
            return Json.value(input.getValue());
        }
        if (input.getType() == MonomorphType.LIST) {
            return MonomorphToJson.convertToArray(input);
        }
        if (input.getType() == MonomorphType.MAP) {
            return MonomorphToJson.convertToObject(input);
        }
        return null;
    }

    private static JsonArray convertToArray(Monomorph input) {
        JsonArray result = new JsonArray();
        for (int i = 0; i < input.size(); ++i) {
            Monomorph element = input.getElementAt(i);
            if (element.getType() == MonomorphType.SCALAR) {
                result.add(element.getValue());
                continue;
            }
            if (element.getType() == MonomorphType.MAP) {
                result.add(MonomorphToJson.convertToObject(element));
                continue;
            }
            throw new UnsupportedOperationException();
        }
        return result;
    }

    private static JsonObject convertToObject(Monomorph input) {
        JsonObject result = new JsonObject();
        for (String key : input.keys()) {
            Monomorph element = input.getMapValue(key);
            if (element.getType() == MonomorphType.SCALAR) {
                result.add(key, element.getValue());
                continue;
            }
            if (element.getType() == MonomorphType.MAP) {
                result.add(key, MonomorphToJson.convertToObject(element));
                continue;
            }
            if (element.getType() == MonomorphType.LIST) {
                result.add(key, MonomorphToJson.convertToArray(element));
                continue;
            }
            throw new UnsupportedOperationException();
        }
        return result;
    }
}

