/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.tag.common.core;

import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.WriteListener;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.JspTagException;
import jakarta.servlet.jsp.PageContext;
import jakarta.servlet.jsp.tagext.BodyTagSupport;
import jakarta.servlet.jsp.tagext.TryCatchFinally;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Locale;
import org.apache.taglibs.standard.resources.Resources;
import org.apache.taglibs.standard.tag.common.core.NullAttributeException;
import org.apache.taglibs.standard.tag.common.core.ParamParent;
import org.apache.taglibs.standard.tag.common.core.ParamSupport;
import org.apache.taglibs.standard.tag.common.core.Util;

public abstract class ImportSupport
extends BodyTagSupport
implements TryCatchFinally,
ParamParent {
    public static final String VALID_SCHEME_CHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+.-";
    public static final String DEFAULT_ENCODING = "ISO-8859-1";
    protected String url;
    protected String context;
    protected String charEncoding;
    private String var;
    private int scope;
    private String varReader;
    private Reader r;
    private boolean isAbsoluteUrl;
    private ParamSupport.ParamManager params;
    private String urlWithParams;

    public ImportSupport() {
        this.init();
    }

    private void init() {
        this.urlWithParams = null;
        this.charEncoding = null;
        this.context = null;
        this.varReader = null;
        this.var = null;
        this.url = null;
        this.params = null;
        this.scope = 1;
    }

    @Override
    public int doStartTag() throws JspException {
        if (!(this.context == null || this.context.startsWith("/") && this.url.startsWith("/"))) {
            throw new JspTagException(Resources.getMessage("IMPORT_BAD_RELATIVE"));
        }
        this.urlWithParams = null;
        this.params = new ParamSupport.ParamManager();
        if (this.url == null || this.url.equals("")) {
            throw new NullAttributeException("import", "url");
        }
        this.isAbsoluteUrl = this.isAbsoluteUrl();
        try {
            if (this.varReader != null) {
                this.r = this.acquireReader();
                this.pageContext.setAttribute(this.varReader, this.r);
            }
        }
        catch (IOException ex) {
            throw new JspTagException(ex.toString(), ex);
        }
        return 1;
    }

    @Override
    public int doEndTag() throws JspException {
        try {
            if (this.varReader == null) {
                if (this.var != null) {
                    this.pageContext.setAttribute(this.var, this.acquireString(), this.scope);
                } else {
                    this.pageContext.getOut().print(this.acquireString());
                }
            }
            return 6;
        }
        catch (IOException ex) {
            throw new JspTagException(ex.toString(), ex);
        }
    }

    @Override
    public void doCatch(Throwable t) throws Throwable {
        throw t;
    }

    @Override
    public void doFinally() {
        try {
            if (this.varReader != null) {
                if (this.r != null) {
                    this.r.close();
                }
                this.pageContext.removeAttribute(this.varReader, 1);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void release() {
        this.init();
        super.release();
    }

    public void setVar(String var) {
        this.var = var;
    }

    public void setVarReader(String varReader) {
        this.varReader = varReader;
    }

    public void setScope(String scope) {
        this.scope = Util.getScope(scope);
    }

    @Override
    public void addParameter(String name, String value) {
        this.params.addParameter(name, value);
    }

    private String acquireString() throws IOException, JspException {
        if (this.isAbsoluteUrl) {
            StringBuffer sb = new StringBuffer();
            try (BufferedReader r = new BufferedReader(this.acquireReader());){
                int i;
                while ((i = r.read()) != -1) {
                    sb.append((char)i);
                }
            }
            return sb.toString();
        }
        if (!(this.pageContext.getRequest() instanceof HttpServletRequest) || !(this.pageContext.getResponse() instanceof HttpServletResponse)) {
            throw new JspTagException(Resources.getMessage("IMPORT_REL_WITHOUT_HTTP"));
        }
        ServletContext c = null;
        String targetUrl = this.targetUrl();
        if (this.context != null) {
            c = this.pageContext.getServletContext().getContext(this.context);
        } else {
            c = this.pageContext.getServletContext();
            if (!targetUrl.startsWith("/")) {
                String sp = ((HttpServletRequest)this.pageContext.getRequest()).getServletPath();
                targetUrl = sp.substring(0, sp.lastIndexOf(47)) + '/' + targetUrl;
            }
        }
        if (c == null) {
            throw new JspTagException(Resources.getMessage("IMPORT_REL_WITHOUT_DISPATCHER", this.context, targetUrl));
        }
        RequestDispatcher rd = c.getRequestDispatcher(ImportSupport.stripSession(targetUrl));
        if (rd == null) {
            throw new JspTagException(ImportSupport.stripSession(targetUrl));
        }
        ImportResponseWrapper irw = new ImportResponseWrapper(this.pageContext);
        try {
            rd.include(this.pageContext.getRequest(), irw);
        }
        catch (IOException ex) {
            throw new JspException(ex);
        }
        catch (RuntimeException ex) {
            throw new JspException(ex);
        }
        catch (ServletException ex) {
            Throwable rc = ex.getRootCause();
            if (rc == null) {
                throw new JspException(ex);
            }
            throw new JspException(rc);
        }
        if (irw.getStatus() < 200 || irw.getStatus() > 299) {
            throw new JspTagException(irw.getStatus() + " " + ImportSupport.stripSession(targetUrl));
        }
        return irw.getString();
    }

    private Reader acquireReader() throws IOException, JspException {
        if (!this.isAbsoluteUrl) {
            return new StringReader(this.acquireString());
        }
        String target = this.targetUrl();
        try {
            int status;
            String charSet;
            URL u = new URL(target);
            URLConnection uc = u.openConnection();
            InputStream i = uc.getInputStream();
            InputStreamReader r = null;
            if (this.charEncoding != null && !this.charEncoding.equals("")) {
                charSet = this.charEncoding;
            } else {
                String contentType = uc.getContentType();
                if (contentType != null) {
                    charSet = Util.getContentTypeAttribute(contentType, "charset");
                    if (charSet == null) {
                        charSet = DEFAULT_ENCODING;
                    }
                } else {
                    charSet = DEFAULT_ENCODING;
                }
            }
            try {
                r = new InputStreamReader(i, charSet);
            }
            catch (Exception ex) {
                r = new InputStreamReader(i, DEFAULT_ENCODING);
            }
            if (uc instanceof HttpURLConnection && ((status = ((HttpURLConnection)uc).getResponseCode()) < 200 || status > 299)) {
                throw new JspTagException(status + " " + target);
            }
            return r;
        }
        catch (IOException ex) {
            throw new JspException(Resources.getMessage("IMPORT_ABS_ERROR", target, ex), ex);
        }
        catch (RuntimeException ex) {
            throw new JspException(Resources.getMessage("IMPORT_ABS_ERROR", target, ex), ex);
        }
    }

    private String targetUrl() {
        if (this.urlWithParams == null) {
            this.urlWithParams = this.params.aggregateParams(this.url);
        }
        return this.urlWithParams;
    }

    private boolean isAbsoluteUrl() throws JspTagException {
        return ImportSupport.isAbsoluteUrl(this.url);
    }

    public static boolean isAbsoluteUrl(String url) {
        if (url == null) {
            return false;
        }
        int colonPos = url.indexOf(":");
        if (colonPos == -1) {
            return false;
        }
        for (int i = 0; i < colonPos; ++i) {
            if (VALID_SCHEME_CHARS.indexOf(url.charAt(i)) != -1) continue;
            return false;
        }
        return true;
    }

    public static String stripSession(String url) {
        int sessionStart;
        StringBuffer u = new StringBuffer(url);
        while ((sessionStart = u.toString().indexOf(";jsessionid=")) != -1) {
            int sessionEnd = u.toString().indexOf(";", sessionStart + 1);
            if (sessionEnd == -1) {
                sessionEnd = u.toString().indexOf("?", sessionStart + 1);
            }
            if (sessionEnd == -1) {
                sessionEnd = u.length();
            }
            u.delete(sessionStart, sessionEnd);
        }
        return u.toString();
    }

    private static class PrintWriterWrapper
    extends PrintWriter {
        private StringWriter out;
        private Writer parentWriter;

        public PrintWriterWrapper(StringWriter out, Writer parentWriter) {
            super(out);
            this.out = out;
            this.parentWriter = parentWriter;
        }

        @Override
        public void flush() {
            try {
                this.parentWriter.write(this.out.toString());
                StringBuffer sb = this.out.getBuffer();
                sb.delete(0, sb.length());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private class ImportResponseWrapper
    extends HttpServletResponseWrapper {
        private StringWriter sw;
        private ByteArrayOutputStream bos;
        private ServletOutputStream sos;
        private boolean isWriterUsed;
        private boolean isStreamUsed;
        private int status;
        private PageContext pageContext;

        public ImportResponseWrapper(PageContext pageContext) {
            super((HttpServletResponse)pageContext.getResponse());
            this.sw = new StringWriter();
            this.bos = new ByteArrayOutputStream();
            this.sos = new ServletOutputStream(){

                @Override
                public boolean isReady() {
                    return false;
                }

                @Override
                public void setWriteListener(WriteListener writeListener) {
                }

                @Override
                public void write(int b) throws IOException {
                    ImportResponseWrapper.this.bos.write(b);
                }

                @Override
                public void flush() throws IOException {
                    ImportResponseWrapper.this.pageContext.getOut().write(ImportResponseWrapper.this.getString());
                    ImportResponseWrapper.this.bos.reset();
                }
            };
            this.status = 200;
            this.pageContext = pageContext;
        }

        @Override
        public PrintWriter getWriter() throws IOException {
            if (this.isStreamUsed) {
                throw new IllegalStateException(Resources.getMessage("IMPORT_ILLEGAL_STREAM"));
            }
            this.isWriterUsed = true;
            return new PrintWriterWrapper(this.sw, this.pageContext.getOut());
        }

        @Override
        public ServletOutputStream getOutputStream() {
            if (this.isWriterUsed) {
                throw new IllegalStateException(Resources.getMessage("IMPORT_ILLEGAL_WRITER"));
            }
            this.isStreamUsed = true;
            return this.sos;
        }

        @Override
        public void setContentType(String x) {
        }

        @Override
        public void setLocale(Locale x) {
        }

        @Override
        public void setStatus(int status) {
            this.status = status;
        }

        @Override
        public int getStatus() {
            return this.status;
        }

        public String getString() throws UnsupportedEncodingException {
            if (this.isWriterUsed) {
                return this.sw.toString();
            }
            if (this.isStreamUsed) {
                if (ImportSupport.this.charEncoding != null && !ImportSupport.this.charEncoding.equals("")) {
                    return this.bos.toString(ImportSupport.this.charEncoding);
                }
                return this.bos.toString(ImportSupport.DEFAULT_ENCODING);
            }
            return "";
        }
    }
}

