# BenchConfig
<span class="source-link">[[Source]](src/pony_bench/benchmark.md#L-0-53)</span>

Configuration of a benchmark.


```pony
class val BenchConfig
```

## Constructors

### create
<span class="source-link">[[Source]](src/pony_bench/benchmark.md#L-0-70)</span>


```pony
new val create(
  samples': USize val = 20,
  max_iterations': U64 val = 1000000000,
  max_sample_time': U64 val = 100000000)
: BenchConfig val^
```
#### Parameters

*   samples': [USize](builtin-USize.md) val = 20
*   max_iterations': [U64](builtin-U64.md) val = 1000000000
*   max_sample_time': [U64](builtin-U64.md) val = 100000000

#### Returns

* [BenchConfig](pony_bench-BenchConfig.md) val^

---

## Public fields

### let samples: [USize](builtin-USize.md) val
<span class="source-link">[[Source]](src/pony_bench/benchmark.md#L-0-57)</span>

Total number of samples to be measured. (Default: 20)




---

### let max_iterations: [U64](builtin-U64.md) val
<span class="source-link">[[Source]](src/pony_bench/benchmark.md#L-0-61)</span>

Maximum number of iterations to execute per sample. (Default: 1_000_000_000)




---

### let max_sample_time: [U64](builtin-U64.md) val
<span class="source-link">[[Source]](src/pony_bench/benchmark.md#L-0-65)</span>

Maximum time to execute a sample in Nanoseconds. (Default: 100_000_000)




---

