/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.assembler.ir.attributes;

import com.strobel.annotations.NotNull;
import com.strobel.assembler.metadata.Flags;
import com.strobel.assembler.metadata.ModuleReference;
import com.strobel.assembler.metadata.PackageReference;
import com.strobel.core.ArrayUtilities;
import com.strobel.core.VerifyArgument;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;

public final class PackageInfo {
    public static final PackageInfo[] EMPTY = new PackageInfo[0];
    private final EnumSet<Flags.Flag> _flags;
    private final PackageReference _package;
    private final List<ModuleReference> _modules;

    public PackageInfo(String name, int flags, String[] modules) {
        this._package = PackageReference.parse(VerifyArgument.notNull(name, "name"));
        this._flags = Flags.asFlagSet(flags, Flags.Kind.ExportsOpens);
        if (ArrayUtilities.isNullOrEmpty(modules)) {
            this._modules = Collections.emptyList();
        } else {
            VerifyArgument.noNullElements(modules, "modules");
            ModuleReference[] moduleReferences = new ModuleReference[modules.length];
            for (int i = 0; i < moduleReferences.length; ++i) {
                moduleReferences[i] = new ModuleReference(modules[i], null);
            }
            this._modules = ArrayUtilities.asUnmodifiableList(moduleReferences);
        }
    }

    @NotNull
    public EnumSet<Flags.Flag> getFlags() {
        return this._flags;
    }

    @NotNull
    public final PackageReference getPackage() {
        return this._package;
    }

    @NotNull
    public final List<ModuleReference> getModules() {
        return this._modules;
    }
}

