/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.assembler.metadata;

import com.strobel.assembler.metadata.JvmType;
import com.strobel.assembler.metadata.MetadataSystem;
import com.strobel.assembler.metadata.TypeDefinition;
import com.strobel.assembler.metadata.TypeMetadataVisitor;
import com.strobel.core.VerifyArgument;

public final class PrimitiveType
extends TypeDefinition {
    private final JvmType _jvmType;

    PrimitiveType(JvmType jvmType) {
        super(MetadataSystem.instance());
        this._jvmType = VerifyArgument.notNull(jvmType, "jvmType");
        this.setFlags(1L);
        this.setName(this._jvmType.getPrimitiveName());
    }

    @Override
    public String getInternalName() {
        return this._jvmType.getDescriptorPrefix();
    }

    @Override
    public final <R, P> R accept(TypeMetadataVisitor<P, R> visitor, P parameter) {
        return visitor.visitPrimitiveType(this, parameter);
    }

    @Override
    public String getSimpleName() {
        return this._jvmType.getPrimitiveName();
    }

    @Override
    public String getFullName() {
        return this._jvmType.getPrimitiveName();
    }

    @Override
    public final boolean isPrimitive() {
        return true;
    }

    @Override
    public final boolean isVoid() {
        return this._jvmType == JvmType.Void;
    }

    @Override
    public final JvmType getSimpleType() {
        return this._jvmType;
    }

    @Override
    protected StringBuilder appendName(StringBuilder sb, boolean fullName, boolean dottedName) {
        return sb.append(this._jvmType.getPrimitiveName());
    }

    @Override
    protected StringBuilder appendBriefDescription(StringBuilder sb) {
        return sb.append(this._jvmType.getPrimitiveName());
    }

    @Override
    protected StringBuilder appendSimpleDescription(StringBuilder sb) {
        return sb.append(this._jvmType.getPrimitiveName());
    }

    @Override
    protected StringBuilder appendErasedDescription(StringBuilder sb) {
        return sb.append(this._jvmType.getPrimitiveName());
    }

    @Override
    protected StringBuilder appendClassDescription(StringBuilder sb) {
        return sb.append(this._jvmType.getPrimitiveName());
    }

    @Override
    protected StringBuilder appendSignature(StringBuilder sb) {
        return sb.append(this._jvmType.getDescriptorPrefix());
    }

    @Override
    protected StringBuilder appendErasedSignature(StringBuilder sb) {
        return sb.append(this._jvmType.getDescriptorPrefix());
    }

    @Override
    protected StringBuilder appendClassSignature(StringBuilder sb) {
        return sb.append(this._jvmType.getDescriptorPrefix());
    }

    @Override
    protected StringBuilder appendErasedClassSignature(StringBuilder sb) {
        return sb.append(this._jvmType.getDescriptorPrefix());
    }

    @Override
    public StringBuilder appendGenericSignature(StringBuilder sb) {
        return sb.append(this._jvmType.getDescriptorPrefix());
    }
}

