/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast.transforms;

import com.strobel.assembler.metadata.CommonTypeReferences;
import com.strobel.assembler.metadata.FieldDefinition;
import com.strobel.assembler.metadata.FieldReference;
import com.strobel.assembler.metadata.Flags;
import com.strobel.assembler.metadata.LanguageFeature;
import com.strobel.assembler.metadata.MemberReference;
import com.strobel.assembler.metadata.MetadataResolver;
import com.strobel.assembler.metadata.MethodDefinition;
import com.strobel.assembler.metadata.MethodReference;
import com.strobel.assembler.metadata.ParameterDefinition;
import com.strobel.assembler.metadata.TypeDefinition;
import com.strobel.core.CollectionUtilities;
import com.strobel.core.StringUtilities;
import com.strobel.core.VerifyArgument;
import com.strobel.decompiler.DecompilerContext;
import com.strobel.decompiler.languages.java.ast.Annotation;
import com.strobel.decompiler.languages.java.ast.AnonymousObjectCreationExpression;
import com.strobel.decompiler.languages.java.ast.ArrayCreationExpression;
import com.strobel.decompiler.languages.java.ast.AssignmentExpression;
import com.strobel.decompiler.languages.java.ast.AstBuilder;
import com.strobel.decompiler.languages.java.ast.AstNode;
import com.strobel.decompiler.languages.java.ast.AstNodeCollection;
import com.strobel.decompiler.languages.java.ast.AstType;
import com.strobel.decompiler.languages.java.ast.BlockStatement;
import com.strobel.decompiler.languages.java.ast.CastExpression;
import com.strobel.decompiler.languages.java.ast.ConstructorDeclaration;
import com.strobel.decompiler.languages.java.ast.ContextTrackingVisitor;
import com.strobel.decompiler.languages.java.ast.EntityDeclaration;
import com.strobel.decompiler.languages.java.ast.EnumValueDeclaration;
import com.strobel.decompiler.languages.java.ast.Expression;
import com.strobel.decompiler.languages.java.ast.ExpressionStatement;
import com.strobel.decompiler.languages.java.ast.FieldDeclaration;
import com.strobel.decompiler.languages.java.ast.InstanceInitializer;
import com.strobel.decompiler.languages.java.ast.InvocationExpression;
import com.strobel.decompiler.languages.java.ast.JavaModifierToken;
import com.strobel.decompiler.languages.java.ast.Keys;
import com.strobel.decompiler.languages.java.ast.MemberReferenceExpression;
import com.strobel.decompiler.languages.java.ast.MethodDeclaration;
import com.strobel.decompiler.languages.java.ast.ObjectCreationExpression;
import com.strobel.decompiler.languages.java.ast.ParameterDeclaration;
import com.strobel.decompiler.languages.java.ast.ReturnStatement;
import com.strobel.decompiler.languages.java.ast.Statement;
import com.strobel.decompiler.languages.java.ast.SuperReferenceExpression;
import com.strobel.decompiler.languages.java.ast.TypeDeclaration;
import com.strobel.decompiler.languages.java.ast.TypeReferenceExpression;
import com.strobel.decompiler.languages.java.ast.VariableDeclarationStatement;
import com.strobel.decompiler.languages.java.ast.transforms.IAstTransform;
import com.strobel.decompiler.patterns.AnyNode;
import com.strobel.decompiler.patterns.Choice;
import com.strobel.decompiler.patterns.INode;
import com.strobel.decompiler.patterns.Match;
import com.strobel.decompiler.patterns.NamedNode;
import com.strobel.decompiler.patterns.Repeat;
import com.strobel.decompiler.patterns.SubtreeMatch;
import com.strobel.decompiler.patterns.TypedNode;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class EnumRewriterTransform
implements IAstTransform {
    private final DecompilerContext _context;

    public EnumRewriterTransform(DecompilerContext context) {
        this._context = VerifyArgument.notNull(context, "context");
    }

    @Override
    public void run(AstNode compilationUnit) {
        if (this._context.isSupported(LanguageFeature.ENUM_CLASSES)) {
            compilationUnit.acceptVisitor(new Visitor(this._context), null);
        }
    }

    private static final class Visitor
    extends ContextTrackingVisitor<Void> {
        private Map<String, FieldDeclaration> _valueFields = new LinkedHashMap<String, FieldDeclaration>();
        private Map<String, ObjectCreationExpression> _valueInitializers = new LinkedHashMap<String, ObjectCreationExpression>();
        private MemberReference _valuesField;
        private static final INode SUPER_PATTERN = new SubtreeMatch(new BlockStatement(new Repeat(new TypedNode(VariableDeclarationStatement.class)).toStatement(), new NamedNode("superCall", new ExpressionStatement(new InvocationExpression(-34, (Expression)new SuperReferenceExpression(-34), new Repeat(new AnyNode()).toExpression()))).toStatement(), new Repeat(new AnyNode()).toStatement()));

        protected Visitor(DecompilerContext context) {
            super(context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Void visitTypeDeclarationOverride(TypeDeclaration typeDeclaration, Void p) {
            MemberReference oldValuesField = this._valuesField;
            Map<String, FieldDeclaration> oldValueFields = this._valueFields;
            Map<String, ObjectCreationExpression> oldValueInitializers = this._valueInitializers;
            LinkedHashMap<String, FieldDeclaration> valueFields = new LinkedHashMap<String, FieldDeclaration>();
            LinkedHashMap<String, ObjectCreationExpression> valueInitializers = new LinkedHashMap<String, ObjectCreationExpression>();
            this._valuesField = this.findValuesField(typeDeclaration);
            this._valueFields = valueFields;
            this._valueInitializers = valueInitializers;
            try {
                super.visitTypeDeclarationOverride(typeDeclaration, p);
            }
            finally {
                this._valuesField = oldValuesField;
                this._valueFields = oldValueFields;
                this._valueInitializers = oldValueInitializers;
            }
            this.rewrite(valueFields, valueInitializers);
            return null;
        }

        private MemberReference findValuesField(TypeDeclaration declaration) {
            TypeDefinition definition = declaration.getUserData(Keys.TYPE_DEFINITION);
            if (definition == null || !definition.isEnum()) {
                return null;
            }
            AstBuilder astBuilder = this.context.getUserData(Keys.AST_BUILDER);
            if (astBuilder == null) {
                return null;
            }
            MethodDeclaration pattern = new MethodDeclaration();
            pattern.setName("values");
            pattern.setReturnType(astBuilder.convertType(definition.makeArrayType()));
            pattern.getModifiers().add(new JavaModifierToken(Flags.Flag.PUBLIC));
            pattern.getModifiers().add(new JavaModifierToken(Flags.Flag.STATIC));
            pattern.setBody(new BlockStatement(new ReturnStatement(-34, new Choice(new MemberReferenceExpression(-34, new NamedNode("valuesField", new TypeReferenceExpression(-34, astBuilder.convertType(definition)).member("$any$")).toExpression(), "clone", new AstType[0]).invoke(new Expression[0]), new CastExpression(astBuilder.convertType(definition.makeArrayType()), new MemberReferenceExpression(-34, new NamedNode("valuesField", new TypeReferenceExpression(-34, astBuilder.convertType(definition)).member("$any$")).toExpression(), "clone", new AstType[0]).invoke(new Expression[0]))).toExpression())));
            for (EntityDeclaration d : declaration.getMembers()) {
                Match match;
                if (!(d instanceof MethodDeclaration) || !(match = pattern.match(d)).success()) continue;
                MemberReferenceExpression reference = (MemberReferenceExpression)CollectionUtilities.first(match.get("valuesField"));
                return reference.getUserData(Keys.MEMBER_REFERENCE);
            }
            return null;
        }

        @Override
        public Void visitFieldDeclaration(FieldDeclaration node, Void data) {
            FieldDefinition field;
            TypeDefinition currentType = this.context.getCurrentType();
            if (currentType != null && currentType.isEnum() && (field = node.getUserData(Keys.FIELD_DEFINITION)) != null && field.isEnumConstant()) {
                this._valueFields.put(field.getName(), node);
            }
            return (Void)super.visitFieldDeclaration(node, data);
        }

        @Override
        public Void visitAssignmentExpression(AssignmentExpression node, Void data) {
            TypeDefinition currentType = this.context.getCurrentType();
            MethodDefinition currentMethod = this.context.getCurrentMethod();
            if (currentType != null && currentMethod != null && currentType.isEnum() && currentMethod.isTypeInitializer()) {
                FieldDefinition resolvedField;
                Expression left = node.getLeft();
                Expression right = node.getRight();
                MemberReference member = left.getUserData(Keys.MEMBER_REFERENCE);
                if (member instanceof FieldReference && (resolvedField = ((FieldReference)member).resolve()) != null && (right instanceof ObjectCreationExpression || right instanceof ArrayCreationExpression)) {
                    Statement parentStatement;
                    String fieldName = resolvedField.getName();
                    if (resolvedField.isEnumConstant() && right instanceof ObjectCreationExpression && MetadataResolver.areEquivalent(currentType, resolvedField.getFieldType())) {
                        this._valueInitializers.put(fieldName, (ObjectCreationExpression)right);
                    } else if (resolvedField.isSynthetic() && !this.context.getSettings().getShowSyntheticMembers() && this.matchesValuesField(resolvedField) && MetadataResolver.areEquivalent(currentType.makeArrayType(), resolvedField.getFieldType()) && (parentStatement = this.findStatement(node)) != null) {
                        parentStatement.remove();
                    }
                }
            }
            return (Void)super.visitAssignmentExpression(node, data);
        }

        @Override
        public Void visitConstructorDeclaration(ConstructorDeclaration node, Void p) {
            TypeDefinition currentType = this.context.getCurrentType();
            MethodDefinition constructor = node.getUserData(Keys.METHOD_DEFINITION);
            if (currentType != null && currentType.isEnum()) {
                List<ParameterDefinition> pDefinitions = constructor.getParameters();
                AstNodeCollection<ParameterDeclaration> pDeclarations = node.getParameters();
                for (int i = 0; i < pDefinitions.size() && !pDeclarations.isEmpty() && pDefinitions.get(i).isSynthetic(); ++i) {
                    pDeclarations.firstOrNullObject().remove();
                }
                BlockStatement body = node.getBody();
                Match superCallMatch = SUPER_PATTERN.match(body);
                AstNodeCollection<Statement> statements = body.getStatements();
                if (superCallMatch.success()) {
                    Statement superCall = (Statement)CollectionUtilities.first(superCallMatch.get("superCall"));
                    superCall.remove();
                }
                if (statements.isEmpty()) {
                    if (pDeclarations.isEmpty()) {
                        node.remove();
                    }
                } else if (currentType.isAnonymous()) {
                    InstanceInitializer initializer = new InstanceInitializer();
                    BlockStatement initializerBody = new BlockStatement();
                    for (Statement statement : statements) {
                        statement.remove();
                        initializerBody.add(statement);
                    }
                    initializer.setBody(initializerBody);
                    node.replaceWith(initializer);
                }
            }
            return (Void)super.visitConstructorDeclaration(node, p);
        }

        @Override
        protected Void visitMethodDeclarationOverride(MethodDeclaration node, Void p) {
            MethodDefinition method;
            TypeDefinition currentType = this.context.getCurrentType();
            if (currentType != null && currentType.isEnum() && !this.context.getSettings().getShowSyntheticMembers() && (method = node.getUserData(Keys.METHOD_DEFINITION)) != null && method.isPublic() && method.isStatic()) {
                switch (method.getName()) {
                    case "values": {
                        if (!method.getParameters().isEmpty() || !MetadataResolver.areEquivalent(currentType.makeArrayType(), method.getReturnType())) break;
                        node.remove();
                        break;
                    }
                    case "valueOf": {
                        ParameterDefinition pd;
                        if (!currentType.equals(method.getReturnType().resolve()) || method.getParameters().size() != 1 || !CommonTypeReferences.String.isEquivalentTo((pd = method.getParameters().get(0)).getParameterType())) break;
                        node.remove();
                    }
                }
            }
            return (Void)super.visitMethodDeclarationOverride(node, p);
        }

        private void rewrite(LinkedHashMap<String, FieldDeclaration> valueFields, LinkedHashMap<String, ObjectCreationExpression> valueInitializers) {
            if (valueFields.isEmpty() || valueFields.size() != valueInitializers.size()) {
                return;
            }
            MethodDeclaration typeInitializer = this.findMethodDeclaration(CollectionUtilities.first(valueInitializers.values()));
            for (String name : valueFields.keySet()) {
                FieldDeclaration field = valueFields.get(name);
                ObjectCreationExpression initializer = valueInitializers.get(name);
                assert (field != null && initializer != null);
                MethodReference constructor = (MethodReference)initializer.getUserData(Keys.MEMBER_REFERENCE);
                MethodDefinition resolvedConstructor = constructor.resolve();
                EnumValueDeclaration enumDeclaration = new EnumValueDeclaration();
                Statement initializerStatement = this.findStatement(initializer);
                assert (initializerStatement != null);
                initializerStatement.remove();
                enumDeclaration.setName(name);
                enumDeclaration.putUserData(Keys.FIELD_DEFINITION, field.getUserData(Keys.FIELD_DEFINITION));
                enumDeclaration.putUserData(Keys.MEMBER_REFERENCE, field.getUserData(Keys.MEMBER_REFERENCE));
                for (Annotation annotation : field.getAnnotations()) {
                    annotation.remove();
                    enumDeclaration.getAnnotations().add(annotation);
                }
                if (resolvedConstructor != null) {
                    enumDeclaration.putUserData(Keys.TYPE_DEFINITION, resolvedConstructor.getDeclaringType());
                }
                int i = 0;
                AstNodeCollection<Expression> arguments = initializer.getArguments();
                boolean trimArguments = arguments.size() == constructor.getParameters().size();
                for (Expression argument : arguments) {
                    if (trimArguments && resolvedConstructor != null && resolvedConstructor.isSynthetic() && i++ < 2) continue;
                    argument.remove();
                    enumDeclaration.getArguments().add(argument);
                }
                if (initializer instanceof AnonymousObjectCreationExpression) {
                    AnonymousObjectCreationExpression creation = (AnonymousObjectCreationExpression)initializer;
                    for (EntityDeclaration member : creation.getTypeDeclaration().getMembers()) {
                        member.remove();
                        enumDeclaration.getMembers().add(member);
                    }
                }
                field.replaceWith(enumDeclaration);
            }
            if (typeInitializer != null && typeInitializer.getBody().getStatements().isEmpty()) {
                typeInitializer.remove();
            }
        }

        private Statement findStatement(AstNode node) {
            for (AstNode current = node; current != null; current = current.getParent()) {
                if (!(current instanceof Statement)) continue;
                return (Statement)current;
            }
            return null;
        }

        private MethodDeclaration findMethodDeclaration(AstNode node) {
            for (AstNode current = node; current != null; current = current.getParent()) {
                if (!(current instanceof MethodDeclaration)) continue;
                return (MethodDeclaration)current;
            }
            return null;
        }

        private boolean matchesValuesField(FieldDefinition field) {
            if (field == null) {
                return false;
            }
            if (field.isEquivalentTo(this._valuesField)) {
                return true;
            }
            String fieldName = field.getName();
            return StringUtilities.equals(fieldName, "$VALUES") || StringUtilities.equals(fieldName, "ENUM$VALUES");
        }
    }
}

