# coding: utf-8

"""
    NetHSM
    All endpoints expect exactly the specified JSON. Additional properties will cause a Bad Request Error (400). All HTTP errors contain a JSON structure with an explanation of type string. All [base64](https://tools.ietf.org/html/rfc4648#section-4) encoded values are Big Endian.   # noqa: E501
    The version of the OpenAPI document: v1
    Generated by: https://github.com/openapi-json-schema-tools/openapi-json-schema-generator
"""

from __future__ import annotations
from nethsm.client.shared_imports.schema_imports import *  # pyright: ignore [reportWildcardImportFromLibrary]

IpAddress: typing_extensions.TypeAlias = schemas.StrSchema
Port: typing_extensions.TypeAlias = schemas.IntSchema

from nethsm.client.components.schema import log_level
Properties = typing.TypedDict(
    'Properties',
    {
        "ipAddress": typing.Type[IpAddress],
        "port": typing.Type[Port],
        "logLevel": typing.Type[log_level.LogLevel],
    }
)


class LoggingConfigDict(schemas.immutabledict[str, schemas.OUTPUT_BASE_TYPES]):

    __required_keys__: typing.FrozenSet[str] = frozenset({
        "ipAddress",
        "logLevel",
        "port",
    })
    __optional_keys__: typing.FrozenSet[str] = frozenset({
    })
    
    def __new__(
        cls,
        *,
        ipAddress: str,
        logLevel: typing.Literal[
            "debug",
            "info",
            "warning",
            "error"
        ],
        port: int,
        configuration_: typing.Optional[schema_configuration.SchemaConfiguration] = None,
        **kwargs: schemas.INPUT_TYPES_ALL,
    ):
        arg_: typing.Dict[str, typing.Any] = {
            "ipAddress": ipAddress,
            "logLevel": logLevel,
            "port": port,
        }
        arg_.update(kwargs)
        used_arg_ = typing.cast(LoggingConfigDictInput, arg_)
        return LoggingConfig.validate(used_arg_, configuration=configuration_)
    
    @staticmethod
    def from_dict_(
        arg: typing.Union[
            LoggingConfigDictInput,
            LoggingConfigDict
        ],
        configuration: typing.Optional[schema_configuration.SchemaConfiguration] = None
    ) -> LoggingConfigDict:
        return LoggingConfig.validate(arg, configuration=configuration)
    
    @property
    def ipAddress(self) -> str:
        return typing.cast(
            str,
            self.__getitem__("ipAddress")
        )
    
    @property
    def logLevel(self) -> typing.Literal["debug", "info", "warning", "error"]:
        return typing.cast(
            typing.Literal["debug", "info", "warning", "error"],
            self.__getitem__("logLevel")
        )
    
    @property
    def port(self) -> int:
        return typing.cast(
            int,
            self.__getitem__("port")
        )
    
    def get_additional_property_(self, name: str) -> typing.Union[schemas.OUTPUT_BASE_TYPES, schemas.Unset]:
        schemas.raise_if_key_known(name, self.__required_keys__, self.__optional_keys__)
        return self.get(name, schemas.unset)
LoggingConfigDictInput = typing.Mapping[str, schemas.INPUT_TYPES_ALL]


@dataclasses.dataclass(frozen=True)
class LoggingConfig(
    schemas.Schema[LoggingConfigDict, tuple]
):
    """NOTE: This class is auto generated by OpenAPI JSON Schema Generator.
    Ref: https://github.com/openapi-json-schema-tools/openapi-json-schema-generator

    Do not edit the class manually.
    """
    types: typing.FrozenSet[typing.Type] = frozenset({schemas.immutabledict})
    required: typing.FrozenSet[str] = frozenset({
        "ipAddress",
        "logLevel",
        "port",
    })
    properties: Properties = dataclasses.field(default_factory=lambda: schemas.typed_dict_to_instance(Properties)) # type: ignore
    type_to_output_cls: typing.Mapping[
        typing.Type,
        typing.Type
    ] = dataclasses.field(
        default_factory=lambda: {
            schemas.immutabledict: LoggingConfigDict
        }
    )

    @classmethod
    def validate(
        cls,
        arg: typing.Union[
            LoggingConfigDictInput,
            LoggingConfigDict,
        ],
        configuration: typing.Optional[schema_configuration.SchemaConfiguration] = None
    ) -> LoggingConfigDict:
        return super().validate_base(
            arg,
            configuration=configuration,
        )

