# This file has been autogenerated by the pywayland scanner

# Copyright © 2013-2016 Collabora, Ltd.
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice (including the next
# paragraph) shall be included in all copies or substantial portions of the
# Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.

from __future__ import annotations

import enum

from pywayland.protocol_core import (
    Argument,
    ArgumentType,
    Global,
    Interface,
    Proxy,
    Resource,
)

from ..wayland import WlSurface
from .wp_viewport import WpViewport


class WpViewporter(Interface):
    """Surface cropping and scaling

    The global interface exposing surface cropping and scaling capabilities is
    used to instantiate an interface extension for a
    :class:`~pywayland.protocol.wayland.WlSurface` object. This extended
    interface will then allow cropping and scaling the surface contents,
    effectively disconnecting the direct relationship between the buffer and
    the surface size.
    """

    name = "wp_viewporter"
    version = 1

    class error(enum.IntEnum):
        viewport_exists = 0


class WpViewporterProxy(Proxy[WpViewporter]):
    interface = WpViewporter

    @WpViewporter.request()
    def destroy(self) -> None:
        """Unbind from the cropping and scaling interface

        Informs the server that the client will not be using this protocol
        object anymore. This does not affect any other objects,
        :class:`~pywayland.protocol.viewporter.WpViewport` objects included.
        """
        self._marshal(0)
        self._destroy()

    @WpViewporter.request(
        Argument(ArgumentType.NewId, interface=WpViewport),
        Argument(ArgumentType.Object, interface=WlSurface),
    )
    def get_viewport(self, surface: WlSurface) -> Proxy[WpViewport]:
        """Extend surface interface for crop and scale

        Instantiate an interface extension for the given
        :class:`~pywayland.protocol.wayland.WlSurface` to crop and scale its
        content. If the given :class:`~pywayland.protocol.wayland.WlSurface`
        already has a :class:`~pywayland.protocol.viewporter.WpViewport` object
        associated, the viewport_exists protocol error is raised.

        :param surface:
            the surface
        :type surface:
            :class:`~pywayland.protocol.wayland.WlSurface`
        :returns:
            :class:`~pywayland.protocol.viewporter.WpViewport` -- the new
            viewport interface id
        """
        id = self._marshal_constructor(1, WpViewport, surface)
        return id


class WpViewporterResource(Resource):
    interface = WpViewporter


class WpViewporterGlobal(Global):
    interface = WpViewporter


WpViewporter._gen_c()
WpViewporter.proxy_class = WpViewporterProxy
WpViewporter.resource_class = WpViewporterResource
WpViewporter.global_class = WpViewporterGlobal
