# This file has been autogenerated by the pywayland scanner

# Copyright © 2023-2024 Matthias Klumpp
# Copyright ©      2024 David Edmundson
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice (including the next
# paragraph) shall be included in all copies or substantial portions of the
# Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.

from __future__ import annotations

from pywayland.protocol_core import (
    Argument,
    ArgumentType,
    Global,
    Interface,
    Proxy,
    Resource,
)

from ..xdg_shell import XdgToplevel
from .xdg_toplevel_icon_v1 import XdgToplevelIconV1


class XdgToplevelIconManagerV1(Interface):
    """Interface to manage toplevel icons

    This interface allows clients to create toplevel window icons and set them
    on toplevel windows to be displayed to the user.
    """

    name = "xdg_toplevel_icon_manager_v1"
    version = 1


class XdgToplevelIconManagerV1Proxy(Proxy[XdgToplevelIconManagerV1]):
    interface = XdgToplevelIconManagerV1

    @XdgToplevelIconManagerV1.request()
    def destroy(self) -> None:
        """Destroy the toplevel icon manager

        Destroy the toplevel icon manager. This does not destroy objects
        created with the manager.
        """
        self._marshal(0)
        self._destroy()

    @XdgToplevelIconManagerV1.request(
        Argument(ArgumentType.NewId, interface=XdgToplevelIconV1),
    )
    def create_icon(self) -> Proxy[XdgToplevelIconV1]:
        """Create a new icon instance

        Creates a new icon object. This icon can then be attached to a
        :class:`~pywayland.protocol.xdg_shell.XdgToplevel` via the 'set_icon'
        request.

        :returns:
            :class:`~pywayland.protocol.xdg_toplevel_icon_v1.XdgToplevelIconV1`
        """
        id = self._marshal_constructor(1, XdgToplevelIconV1)
        return id

    @XdgToplevelIconManagerV1.request(
        Argument(ArgumentType.Object, interface=XdgToplevel),
        Argument(ArgumentType.Object, interface=XdgToplevelIconV1, nullable=True),
    )
    def set_icon(self, toplevel: XdgToplevel, icon: XdgToplevelIconV1 | None) -> None:
        """Set an icon on a toplevel window

        This request assigns the icon 'icon' to 'toplevel', or clears the
        toplevel icon if 'icon' was null. This state is double-buffered and is
        applied on the next :func:`WlSurface.commit()
        <pywayland.protocol.wayland.WlSurface.commit>` of the toplevel.

        After making this call, the
        :class:`~pywayland.protocol.xdg_toplevel_icon_v1.XdgToplevelIconV1`
        provided as 'icon' can be destroyed by the client without 'toplevel'
        losing its icon. The
        :class:`~pywayland.protocol.xdg_toplevel_icon_v1.XdgToplevelIconV1` is
        immutable from this point, and any future attempts to change it must
        raise the
        ':class:`~pywayland.protocol.xdg_toplevel_icon_v1.XdgToplevelIconV1`.immutable'
        protocol error.

        The compositor must set the toplevel icon from either the pixel data
        the icon provides, or by loading a stock icon using the icon name. See
        the description of 'xdg_toplevel_icon_v1' for details.

        If 'icon' is set to null, the icon of the respective toplevel is reset
        to its default icon (usually the icon of the application, derived from
        its desktop-entry file, or a placeholder icon). If this request is
        passed an icon with no pixel buffers or icon name assigned, the icon
        must be reset just like if 'icon' was null.

        :param toplevel:
            the toplevel to act on
        :type toplevel:
            :class:`~pywayland.protocol.xdg_shell.XdgToplevel`
        :param icon:
        :type icon:
            :class:`~pywayland.protocol.xdg_toplevel_icon_v1.XdgToplevelIconV1` or `None`
        """
        self._marshal(2, toplevel, icon)


class XdgToplevelIconManagerV1Resource(Resource):
    interface = XdgToplevelIconManagerV1

    @XdgToplevelIconManagerV1.event(
        Argument(ArgumentType.Int),
    )
    def icon_size(self, size: int) -> None:
        """Describes a supported & preferred icon size

        This event indicates an icon size the compositor prefers to be
        available if the client has scalable icons and can render to any size.

        When the 'xdg_toplevel_icon_manager_v1' object is created, the
        compositor may send one or more 'icon_size' events to describe the list
        of preferred icon sizes. If the compositor has no size preference, it
        may not send any 'icon_size' event, and it is up to the client to
        decide a suitable icon size.

        A sequence of 'icon_size' events must be finished with a 'done' event.
        If the compositor has no size preferences, it must still send the
        'done' event, without any preceding 'icon_size' events.

        :param size:
            the edge size of the square icon in surface-local coordinates, e.g.
            64
        :type size:
            `ArgumentType.Int`
        """
        self._post_event(0, size)

    @XdgToplevelIconManagerV1.event()
    def done(self) -> None:
        """All information has been sent

        This event is sent after all 'icon_size' events have been sent.
        """
        self._post_event(1)


class XdgToplevelIconManagerV1Global(Global):
    interface = XdgToplevelIconManagerV1


XdgToplevelIconManagerV1._gen_c()
XdgToplevelIconManagerV1.proxy_class = XdgToplevelIconManagerV1Proxy
XdgToplevelIconManagerV1.resource_class = XdgToplevelIconManagerV1Resource
XdgToplevelIconManagerV1.global_class = XdgToplevelIconManagerV1Global
