\name{BinaryMagnitudeImageFilter}
\alias{BinaryMagnitudeImageFilter}
\title{BinaryMagnitudeImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Computes the square root of the sum of squares of corresponding input
pixels.
BinaryMagnitudeImageFilter}
\details{
This filter is templated over the types of the two input images and
the type of the output image.
Numeric conversions (castings) are done by the C++ defaults.
The filter walks over all of the pixels in the two input images, and
for each pixel does the following:
cast the input 1 pixel value to double
cast the input 2 pixel value to double
compute the sum of squares of the two pixel values
compute the square root of the sum
cast the double value resulting from std::sqrt() to the pixel type of
the output image
store the cast value into the output image.
 The filter expects all images to have the same dimension (e.g. all
2D, or all 3D, or all ND)
See:
BinaryMagnitude for the procedural interface
itk::BinaryMagnitudeImageFilter for the Doxygen on the original ITK class.
BinaryMagnitudeImageFilter}
%C++ includes: sitkBinaryMagnitudeImageFilter.h
\section{Methods}{
\describe{
\item{ BinaryMagnitudeImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Image Execute(const Image &image1, const Image &image2):}{}
\item{Image Execute(Image &&image1, const Image &image2):}{
Execute the filter on the input images
}
\item{std::string GetName() const:}{
Name of this class
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~BinaryMagnitudeImageFilter():}{
Destructor
}
}
}
