\name{ConstantPadImageFilter}
\alias{ConstantPadImageFilter}
\title{ConstantPadImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Increase the image size by padding with a constant value.
ConstantPadImageFilter}
\details{
ConstantPadImageFilter changes the output image region. If the output image region is larger
than the input image region, the extra pixels are filled in by a
constant value. The output image region must be specified.
Visual explanation of padding regions.
This filter is implemented as a multithreaded filter. It provides a
DynamicThreadedGenerateData() method for its implementation.
See:
WrapPadImageFilter , MirrorPadImageFilter
ConstantPad for the procedural interface
itk::ConstantPadImageFilter for the Doxygen on the original ITK class.
ConstantPadImageFilter}
%C++ includes: sitkConstantPadImageFilter.h
\section{Methods}{
\describe{
\item{ ConstantPadImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Image Execute(const Image &image1):}{
Execute the filter on the input image
}
\item{double GetConstant() const:}{
Set/Get the pad value. Default is Zero.
}
\item{std::string GetName() const:}{
Name of this class
}
\item{std::vector< unsigned int > GetPadLowerBound() const:}{}
\item{std::vector< unsigned int > GetPadUpperBound() const:}{}
\item{Self SetConstant(double Constant):}{
Set/Get the pad value. Default is Zero.
}
\item{Self SetPadLowerBound(std::vector< unsigned int > PadLowerBound):}{}
\item{Self SetPadUpperBound(std::vector< unsigned int > PadUpperBound):}{}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~ConstantPadImageFilter():}{
Destructor
}
}
}
