\name{ConvolutionImageFilter}
\alias{ConvolutionImageFilter}
\title{ConvolutionImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Convolve a given image with an arbitrary image kernel.
ConvolutionImageFilter}
\details{
This filter operates by centering the flipped kernel at each pixel in
the image and computing the inner product between pixel values in the
image and pixel values in the kernel. The center of the kernel is
defined as \eqn{ \lfloor (2*i+s-1)/2 \rfloor } where \eqn{i} is the index and \eqn{s} is the size of the largest possible region of the kernel image. For
kernels with odd sizes in all dimensions, this corresponds to the
center pixel. If a dimension of the kernel image has an even size,
then the center index of the kernel in that dimension will be the
largest integral index that is less than the continuous index of the
image center.
The kernel can optionally be normalized to sum to 1 using NormalizeOn() . Normalization is off by default.
WARNING:
This filter ignores the spacing, origin, and orientation of the kernel
image and treats them as identical to those in the input image.
 This code was contributed in the Insight Journal paper:
"Image Kernel Convolution" by Tustison N., Gee J. https://insight-journal.org/browse/publication/208
Nicholas J. Tustison
James C. Gee
See:
Convolution for the procedural interface
itk::ConvolutionImageFilter for the Doxygen on the original ITK class.
ConvolutionImageFilter}
%C++ includes: sitkConvolutionImageFilter.h
\section{Methods}{
\describe{
\item{ ConvolutionImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Image Execute(const Image &image, const Image &kernelImage):}{
Execute the filter on the input image
}
\item{BoundaryConditionType GetBoundaryCondition() const:}{}
\item{std::string GetName() const:}{
Name of this class
}
\item{bool GetNormalize() const:}{}
\item{OutputRegionModeType GetOutputRegionMode() const:}{}
\item{Self NormalizeOff():}{}
\item{Self NormalizeOn():}{
Set the value of Normalize to true or false respectfully.
}
\item{Self SetBoundaryCondition(BoundaryConditionType BoundaryCondition):}{}
\item{Self SetNormalize(bool Normalize):}{
Normalize the output image by the sum of the kernel components
}
\item{Self SetOutputRegionMode(OutputRegionModeType OutputRegionMode):}{}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~ConvolutionImageFilter():}{
Destructor
}
}
}
