\name{DivideFloorImageFilter}
\alias{DivideFloorImageFilter}
\title{DivideFloorImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Implements pixel-wise generic operation of two images, or of an image
and a constant.
DivideFloorImageFilter}
\details{
This class is parameterized over the types of the two input images and
the type of the output image. It is also parameterized by the
operation to be applied. A Functor style is used.
The constant must be of the same type than the pixel type of the
corresponding image. It is wrapped in a SimpleDataObjectDecorator so it can be updated through the pipeline. The SetConstant() and
GetConstant() methods are provided as shortcuts to set or get the
constant value without manipulating the decorator.
See:
BinaryGeneratorImagFilter
UnaryFunctorImageFilter TernaryFunctorImageFilter
DivideFloor for the procedural interface
itk::BinaryFunctorImageFilter for the Doxygen on the original ITK class.
DivideFloorImageFilter}
%C++ includes: sitkDivideFloorImageFilter.h
\section{Methods}{
\describe{
\item{ DivideFloorImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Image Execute(const Image &image1, const Image &image2):}{}
\item{Image Execute(const Image &image1, double constant):}{
Execute the filter with an image and a constant
}
\item{Image Execute(double constant, const Image &image2):}{}
\item{Image Execute(Image &&image1, const Image &image2):}{
Execute the filter on the input images
}
\item{Image Execute(Image &&image1, double constant):}{}
\item{std::string GetName() const:}{
Name of this class
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~DivideFloorImageFilter():}{
Destructor
}
}
}
