# action_row.py
#
# Copyright 2024 Hari Rana (TheEvilSkeleton)
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# SPDX-License-Identifier: GPL-3.0-or-later

import logging
from typing import Any, cast

from gi.repository import Adw, Gio, GObject, Gtk

from refine.widgets.base import BaseInterface


class ActionRow(Adw.ActionRow, BaseInterface):
    """
    Base action row widget implementing the `schema-id` and `key` properties.

    It is assumed to derive from it, rather than using it directly.
    """

    __gtype_name__ = "ActionRow"

    schema = cast(Gio.SettingsSchema, GObject.Property(type=Gio.SettingsSchema))
    schema_id = cast(str, GObject.Property(type=str))
    key = cast(str, GObject.Property(type=str))
    is_valid_setting = cast(bool, GObject.Property(type=bool, default=False))

    restart_required = GObject.Property(type=bool, default=False)

    def value_set(self, value: Any) -> None:
        """Log key-value pair."""
        logging.debug(f"Set key “{self.key}” to “{value}”")

        if not self.restart_required:
            return

        toplevels = Gtk.Window.get_toplevels()

        if not (window := toplevels.get_item(0)):
            return

        window.emit("restart-items-changed", self)
