/*=========================================================================
*
*  Copyright NumFOCUS
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkEdgePotentialImageFilter_h
#define sitkEdgePotentialImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk::simple {

    /**\class EdgePotentialImageFilter
\brief Computes the edge potential of an image from the image gradient.

Input to this filter should be a CovariantVector image representing the image gradient.

The filter expect both the input and output images to have the same number of dimensions, and the output to be of a scalar image type.
\sa itk::simple::EdgePotential for the procedural interface
\sa itk::EdgePotentialImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT EdgePotentialImageFilter : public ImageFilter {
    public:
      using Self = EdgePotentialImageFilter;

      /** Destructor */
      virtual ~EdgePotentialImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      EdgePotentialImageFilter();

      /** Define the pixels types supported by this filter */
      using PixelIDTypeList = VectorPixelIDTypeList;


      /** Name of this class */
      std::string GetName() const { return std::string ("EdgePotentialImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */
#ifndef SWIG
      Image Execute ( Image&& image1 );
#endif
      Image Execute ( const Image& image1 );

    private:

      /** Setup for member function dispatching */

      using MemberFunctionType = Image (Self::*)( const Image& image1 );
      template <class TImageType> Image ExecuteInternal ( const Image& image1 );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      std::unique_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;



      bool m_InPlace{false};
    };

    /**\
     * \brief Computes the edge potential of an image from the image gradient.
     *
     * This function directly calls the execute method of EdgePotentialImageFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::EdgePotentialImageFilter for the object oriented interface
     * @{
     */
#ifndef SWIG
     SITKBasicFilters_EXPORT Image EdgePotential ( Image&& image1 );
#endif
     SITKBasicFilters_EXPORT Image EdgePotential ( const Image& image1 );

     /** @} */
}
#endif
