/*
 * Decompiled with CFR 0.152.
 */
package hughai.mapping;

import com.springrts.ai.oo.clb.Map;
import com.springrts.ai.oo.clb.OOAICallback;
import com.springrts.ai.oo.clb.Unit;
import com.springrts.ai.oo.clb.UnitDef;
import hughai.CSAI;
import hughai.GameAdapter;
import hughai.PlayerObjects;
import hughai.VoiceCommandHandler;
import hughai.basictypes.Int2;
import hughai.basictypes.TerrainPos;
import hughai.ui.MainUI;
import hughai.unitdata.UnitController;
import hughai.unitdata.UnitDefHelp;
import hughai.utils.Config;
import hughai.utils.DrawingUtils;
import hughai.utils.LogFile;
import java.util.HashMap;

public class LosMap {
    public static final int granularity = 2;
    PlayerObjects playerObjects;
    CSAI csai;
    OOAICallback aicallback;
    LogFile logfile;
    DrawingUtils drawingUtils;
    UnitDefHelp unitDefHelp;
    UnitController unitcontroller;
    Config config;
    public HashMap<Unit, Integer> LastLosRefreshFrameCountByUnit = new HashMap();
    public HashMap<Unit, TerrainPos> PosAtLastRefreshByUnit = new HashMap();
    private int[][] LastSeenFrameCount;
    int lasttotalrefresh = -100000;
    static int losmapwidth;
    static int losmapheight;
    int mapwidth;
    int mapheight;

    public int getLosMapWidth() {
        return losmapwidth;
    }

    public int getLosMapHeight() {
        return losmapheight;
    }

    public LosMap(PlayerObjects playerObjects) {
        this.playerObjects = playerObjects;
        this.csai = playerObjects.getCSAI();
        this.aicallback = this.csai.aicallback;
        this.logfile = playerObjects.getLogFile();
        this.unitcontroller = playerObjects.getUnitController();
        this.drawingUtils = playerObjects.getDrawingUtils();
        this.unitDefHelp = playerObjects.getUnitDefHelp();
        this.config = playerObjects.getConfig();
        this.unitcontroller.registerListener(new UnitControllerHandler());
        this.csai.registerGameListener(new GameListenerHandler());
        Map map = this.aicallback.getMap();
        this.mapwidth = map.getWidth();
        this.mapheight = map.getHeight();
        losmapwidth = this.mapwidth / 2;
        losmapheight = this.mapheight / 2;
        this.logfile.WriteLine("LosMap, create losarray");
        this.LastSeenFrameCount = new int[this.mapwidth / 2][this.mapheight / 2];
        this.logfile.WriteLine("losarray created, initializing...");
        for (int i = 0; i < this.mapheight / 2; ++i) {
            for (int j = 0; j < this.mapwidth / 2; ++j) {
                this.LastSeenFrameCount[j][i] = -1000000;
            }
        }
        this.logfile.WriteLine("losarray initialized");
        if (this.csai.DebugOn) {
            // empty if block
        }
        playerObjects.getMainUI().registerButton("Show los map", new ShowLosMapButton());
    }

    public int getLastSeenFrameCount(LosMapPos losMapPos) {
        return this.LastSeenFrameCount[losMapPos.x][losMapPos.y];
    }

    void showLosMap(int n) {
        int n2 = this.config.getMapDrawGranularity() / 2;
        boolean[][] blArray = new boolean[this.mapwidth / 2 / n2][this.mapheight / 2 / n2];
        int n3 = this.playerObjects.getFrameController().getFrame();
        for (int i = 0; i < this.mapheight / 2 / n2; ++i) {
            for (int j = 0; j < this.mapwidth / 2 / n2; ++j) {
                blArray[j][i] = n3 - this.LastSeenFrameCount[j * n2][i * n2] < n * 30;
            }
        }
        this.drawingUtils.DrawMap(blArray);
    }

    void DoIncrementalRefreshes() {
        int n = 0;
        int n2 = this.config.getLosmapdistancethresholdforunitupdate();
        int n3 = n2 * n2;
        for (Unit unit : this.unitcontroller.units) {
            TerrainPos terrainPos;
            UnitDef unitDef = this.unitcontroller.getUnitDef(unit);
            if (this.unitDefHelp.IsMobile(unitDef)) {
                terrainPos = this.unitcontroller.getPos(unit);
                TerrainPos terrainPos2 = this.PosAtLastRefreshByUnit.get(unit);
                boolean bl = false;
                if (terrainPos2 == null) {
                    bl = true;
                } else {
                    float f = terrainPos2.GetSquaredDistance(terrainPos);
                    if (f >= (float)n3) {
                        bl = true;
                    }
                }
                if (!bl) continue;
                this.UpdateLosForUnit(unit);
                ++n;
                continue;
            }
            terrainPos = this.PosAtLastRefreshByUnit.get(unit);
            if (terrainPos != null) continue;
            this.UpdateLosForUnit(unit);
            ++n;
        }
    }

    void UpdateLosForUnit(Unit unit) {
        int n = this.playerObjects.getFrameController().getFrame();
        TerrainPos terrainPos = this.unitcontroller.getPos(unit);
        TerrainPos terrainPos2 = this.PosAtLastRefreshByUnit.get(unit);
        UnitDef unitDef = unit.getDef();
        if (unitDef == null) {
            this.PosAtLastRefreshByUnit.remove(unit);
            this.LastLosRefreshFrameCountByUnit.remove(unit);
            return;
        }
        int n2 = (int)unitDef.getLosRadius();
        if (this.csai.DebugOn) {
            // empty if block
        }
        if (terrainPos2 != null) {
            float f = (float)Math.sqrt(terrainPos.GetSquaredDistance(terrainPos2));
            int n3 = 1 + (int)(f / (float)this.config.getLosMapInterpolationDistance().intValue());
            TerrainPos terrainPos3 = terrainPos.subtract(terrainPos2).divide(n3);
            for (int i = 1; i < n3; ++i) {
                TerrainPos terrainPos4 = terrainPos2.add(terrainPos3.multiply(i));
                this.MarkInCurrentLos(n, terrainPos4, n2);
            }
        } else {
            this.MarkInCurrentLos(n, terrainPos, n2);
        }
        this.LastLosRefreshFrameCountByUnit.put(unit, n);
        this.PosAtLastRefreshByUnit.put(unit, terrainPos);
    }

    void MarkInCurrentLos(int n, TerrainPos terrainPos, int n2) {
        LosMapPos losMapPos = LosMapPos.fromTerrainPos(terrainPos);
        for (int i = -n2; i <= n2; ++i) {
            int n3 = (int)Math.sqrt(n2 * n2 - i * i);
            for (int j = -n3; j <= n3; ++j) {
                int n4 = losMapPos.x + j;
                int n5 = losMapPos.y + i;
                if (n4 < 0 || n4 >= this.mapwidth / 2 || n5 < 0 || n5 >= this.mapheight / 2) continue;
                this.LastSeenFrameCount[n4][n5] = n;
            }
        }
    }

    void TotalRefresh() {
        this.logfile.WriteLine("LosMap start totalrefresh");
        for (Unit unit : this.unitcontroller.units) {
            this.UpdateLosForUnit(unit);
        }
        this.logfile.WriteLine("LosMap end totalrefresh");
    }

    class GameListenerHandler
    extends GameAdapter {
        GameListenerHandler() {
        }

        @Override
        public void Tick(int n) {
            LosMap.this.DoIncrementalRefreshes();
            if (n - LosMap.this.lasttotalrefresh > LosMap.this.config.getLosrefreshallintervalframecount()) {
                LosMap.this.logfile.WriteLine("losmap: doing total refresh");
                LosMap.this.TotalRefresh();
                LosMap.this.lasttotalrefresh = n;
            }
        }
    }

    class UnitControllerHandler
    extends UnitController.UnitAdapter {
        UnitControllerHandler() {
        }

        @Override
        public void UnitAdded(Unit unit) {
            if (!LosMap.this.LastLosRefreshFrameCountByUnit.containsKey(unit)) {
                LosMap.this.UpdateLosForUnit(unit);
            }
        }

        @Override
        public void UnitRemoved(Unit unit) {
            LosMap.this.LastLosRefreshFrameCountByUnit.remove(unit);
            LosMap.this.PosAtLastRefreshByUnit.remove(unit);
        }
    }

    class DumpLosMapHandler
    implements VoiceCommandHandler {
        DumpLosMapHandler() {
        }

        @Override
        public void commandReceived(String string, String[] stringArray, int n) {
            int n2 = 200;
            if (stringArray.length > 2) {
                n2 = Integer.parseInt(stringArray[2]);
            }
            LosMap.this.showLosMap(n2);
        }
    }

    class ShowLosMapButton
    implements MainUI.ButtonHandler {
        ShowLosMapButton() {
        }

        @Override
        public void go() {
            LosMap.this.showLosMap(200);
        }
    }

    public static class LosMapPos
    extends Int2 {
        public LosMapPos() {
        }

        public LosMapPos(Int2 int2) {
            this.x = int2.x;
            this.y = int2.y;
        }

        public LosMapPos(int n, int n2) {
            super(n, n2);
        }

        public TerrainPos toTerrainPos() {
            return new TerrainPos(this.x * 8 * 2, 0.0f, this.y * 8 * 2);
        }

        public static LosMapPos fromTerrainPos(TerrainPos terrainPos) {
            return new LosMapPos((int)terrainPos.x / 8 / 2, (int)terrainPos.z / 8 / 2);
        }

        public LosMapPos add(LosMapPos losMapPos) {
            return new LosMapPos(super.add(losMapPos));
        }

        public boolean validate() {
            return this.x >= 0 && this.y >= 0 && this.x < losmapwidth && this.y < losmapheight;
        }
    }
}

