/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.nativewindow.util;

import com.jogamp.nativewindow.util.DimensionImmutable;

public class Dimension
implements Cloneable,
DimensionImmutable {
    int width;
    int height;

    public Dimension() {
        this(0, 0);
    }

    public Dimension(int[] nArray) {
        this(nArray[0], nArray[1]);
    }

    public Dimension(int n, int n2) {
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException("width and height must be within: [0..2147483647]");
        }
        this.width = n;
        this.height = n2;
    }

    public Object cloneMutable() {
        return this.clone();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    @Override
    public final int getWidth() {
        return this.width;
    }

    @Override
    public final int getHeight() {
        return this.height;
    }

    public final void set(int n, int n2) {
        this.width = n;
        this.height = n2;
    }

    public final void setWidth(int n) {
        this.width = n;
    }

    public final void setHeight(int n) {
        this.height = n;
    }

    public final Dimension scale(int n) {
        this.width *= n;
        this.height *= n;
        return this;
    }

    public final Dimension add(Dimension dimension) {
        this.width += dimension.width;
        this.height += dimension.height;
        return this;
    }

    public String toString() {
        return this.width + " x " + this.height;
    }

    @Override
    public int compareTo(DimensionImmutable dimensionImmutable) {
        int n = this.width * this.height;
        int n2 = dimensionImmutable.getWidth() * dimensionImmutable.getHeight();
        if (n > n2) {
            return 1;
        }
        if (n < n2) {
            return -1;
        }
        return 0;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Dimension) {
            Dimension dimension = (Dimension)object;
            return this.height == dimension.height && this.width == dimension.width;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int n = 31 + this.width;
        return (n << 5) - n + this.height;
    }
}

