// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from ATSAM4SD16C.svd, see https://github.com/posborne/cmsis-svd/tree/master/data/Atmel

//go:build sam && atsam4sd16c

/*
// Atmel ATSAM4SD16C Microcontroller
*/

package sam

import (
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	Device       = "ATSAM4SD16C"
	CPU          = "CM4"
	FPUPresent   = false
	NVICPrioBits = 4
)

// Interrupt numbers.
const (
	// Power Management Controller
	IRQ_PMC = 5

	// Embedded Flash Controller 0
	IRQ_EFC0 = 6

	// Embedded Flash Controller 1
	IRQ_EFC1 = 7

	// Universal Asynchronous Receiver Transmitter 0
	IRQ_UART0 = 8

	// Universal Asynchronous Receiver Transmitter 1
	IRQ_UART1 = 9

	// Parallel Input/Output Controller A
	IRQ_PIOA = 11

	// Parallel Input/Output Controller B
	IRQ_PIOB = 12

	// Parallel Input/Output Controller C
	IRQ_PIOC = 13

	// Universal Synchronous Asynchronous Receiver Transmitter 0
	IRQ_USART0 = 14

	// Universal Synchronous Asynchronous Receiver Transmitter 1
	IRQ_USART1 = 15

	// High Speed MultiMedia Card Interface
	IRQ_HSMCI = 18

	// Two-wire Interface 0
	IRQ_TWI0 = 19

	// Two-wire Interface 1
	IRQ_TWI1 = 20

	// Serial Peripheral Interface
	IRQ_SPI = 21

	// Synchronous Serial Controller
	IRQ_SSC = 22

	// Timer Counter 0
	IRQ_TC0 = 23

	// Timer Counter 0
	IRQ_TC1 = 24

	// Timer Counter 0
	IRQ_TC2 = 25

	// Timer Counter 1
	IRQ_TC3 = 26

	// Timer Counter 1
	IRQ_TC4 = 27

	// Timer Counter 1
	IRQ_TC5 = 28

	// Analog-to-Digital Converter
	IRQ_ADC = 29

	// Digital-to-Analog Converter Controller
	IRQ_DACC = 30

	// Pulse Width Modulation Controller
	IRQ_PWM = 31

	// Cyclic Redundancy Check Calculation Unit
	IRQ_CRCCU = 32

	// Analog Comparator Controller
	IRQ_ACC = 33

	// USB Device Port
	IRQ_UDP = 34

	// Highest interrupt number on this device.
	IRQ_max = 34
)

// Pseudo function call that is replaced by the compiler with the actual
// functions registered through interrupt.New.
//
//go:linkname callHandlers runtime/interrupt.callHandlers
func callHandlers(num int)

//export PMC_IRQHandler
func interruptPMC() {
	callHandlers(IRQ_PMC)
}

//export EFC0_IRQHandler
func interruptEFC0() {
	callHandlers(IRQ_EFC0)
}

//export EFC1_IRQHandler
func interruptEFC1() {
	callHandlers(IRQ_EFC1)
}

//export UART0_IRQHandler
func interruptUART0() {
	callHandlers(IRQ_UART0)
}

//export UART1_IRQHandler
func interruptUART1() {
	callHandlers(IRQ_UART1)
}

//export PIOA_IRQHandler
func interruptPIOA() {
	callHandlers(IRQ_PIOA)
}

//export PIOB_IRQHandler
func interruptPIOB() {
	callHandlers(IRQ_PIOB)
}

//export PIOC_IRQHandler
func interruptPIOC() {
	callHandlers(IRQ_PIOC)
}

//export USART0_IRQHandler
func interruptUSART0() {
	callHandlers(IRQ_USART0)
}

//export USART1_IRQHandler
func interruptUSART1() {
	callHandlers(IRQ_USART1)
}

//export HSMCI_IRQHandler
func interruptHSMCI() {
	callHandlers(IRQ_HSMCI)
}

//export TWI0_IRQHandler
func interruptTWI0() {
	callHandlers(IRQ_TWI0)
}

//export TWI1_IRQHandler
func interruptTWI1() {
	callHandlers(IRQ_TWI1)
}

//export SPI_IRQHandler
func interruptSPI() {
	callHandlers(IRQ_SPI)
}

//export SSC_IRQHandler
func interruptSSC() {
	callHandlers(IRQ_SSC)
}

//export TC0_IRQHandler
func interruptTC0() {
	callHandlers(IRQ_TC0)
}

//export TC1_IRQHandler
func interruptTC1() {
	callHandlers(IRQ_TC1)
}

//export TC2_IRQHandler
func interruptTC2() {
	callHandlers(IRQ_TC2)
}

//export TC3_IRQHandler
func interruptTC3() {
	callHandlers(IRQ_TC3)
}

//export TC4_IRQHandler
func interruptTC4() {
	callHandlers(IRQ_TC4)
}

//export TC5_IRQHandler
func interruptTC5() {
	callHandlers(IRQ_TC5)
}

//export ADC_IRQHandler
func interruptADC() {
	callHandlers(IRQ_ADC)
}

//export DACC_IRQHandler
func interruptDACC() {
	callHandlers(IRQ_DACC)
}

//export PWM_IRQHandler
func interruptPWM() {
	callHandlers(IRQ_PWM)
}

//export CRCCU_IRQHandler
func interruptCRCCU() {
	callHandlers(IRQ_CRCCU)
}

//export ACC_IRQHandler
func interruptACC() {
	callHandlers(IRQ_ACC)
}

//export UDP_IRQHandler
func interruptUDP() {
	callHandlers(IRQ_UDP)
}

// Peripherals.
var (
	// High Speed MultiMedia Card Interface
	HSMCI = (*HSMCI_Type)(unsafe.Pointer(uintptr(0x40000000)))

	// Synchronous Serial Controller
	SSC = (*SSC_Type)(unsafe.Pointer(uintptr(0x40004000)))

	// Serial Peripheral Interface
	SPI = (*SPI_Type)(unsafe.Pointer(uintptr(0x40008000)))

	// Timer Counter 0
	TC0 = (*TC_Type)(unsafe.Pointer(uintptr(0x40010000)))

	// Timer Counter 1
	TC1 = (*TC_Type)(unsafe.Pointer(uintptr(0x40014000)))

	// Two-wire Interface 0
	TWI0 = (*TWI_Type)(unsafe.Pointer(uintptr(0x40018000)))

	// Two-wire Interface 1
	TWI1 = (*TWI_Type)(unsafe.Pointer(uintptr(0x4001c000)))

	// Pulse Width Modulation Controller
	PWM = (*PWM_Type)(unsafe.Pointer(uintptr(0x40020000)))

	// Universal Synchronous Asynchronous Receiver Transmitter 0
	USART0 = (*USART_Type)(unsafe.Pointer(uintptr(0x40024000)))

	// Universal Synchronous Asynchronous Receiver Transmitter 1
	USART1 = (*USART_Type)(unsafe.Pointer(uintptr(0x40028000)))

	// USB Device Port
	UDP = (*UDP_Type)(unsafe.Pointer(uintptr(0x40034000)))

	// Analog-to-Digital Converter
	ADC = (*ADC_Type)(unsafe.Pointer(uintptr(0x40038000)))

	// Digital-to-Analog Converter Controller
	DACC = (*DACC_Type)(unsafe.Pointer(uintptr(0x4003c000)))

	// Analog Comparator Controller
	ACC = (*ACC_Type)(unsafe.Pointer(uintptr(0x40040000)))

	// Cyclic Redundancy Check Calculation Unit
	CRCCU = (*CRCCU_Type)(unsafe.Pointer(uintptr(0x40044000)))

	// Cortex-M Cache Controller
	CMCC = (*CMCC_Type)(unsafe.Pointer(uintptr(0x4007c000)))

	// Static Memory Controller
	SMC = (*EBI_Type)(unsafe.Pointer(uintptr(0x400e0000)))

	// AHB Bus Matrix
	MATRIX = (*MATRIX_Type)(unsafe.Pointer(uintptr(0x400e0200)))

	// Power Management Controller
	PMC = (*PMC_Type)(unsafe.Pointer(uintptr(0x400e0400)))

	// Universal Asynchronous Receiver Transmitter 0
	UART0 = (*UART_Type)(unsafe.Pointer(uintptr(0x400e0600)))

	// Chip Identifier
	CHIPID = (*CHIPID_Type)(unsafe.Pointer(uintptr(0x400e0740)))

	// Universal Asynchronous Receiver Transmitter 1
	UART1 = (*UART_Type)(unsafe.Pointer(uintptr(0x400e0800)))

	// Embedded Flash Controller 0
	EFC0 = (*EFC_Type)(unsafe.Pointer(uintptr(0x400e0a00)))

	// Embedded Flash Controller 1
	EFC1 = (*EFC_Type)(unsafe.Pointer(uintptr(0x400e0c00)))

	// Parallel Input/Output Controller A
	PIOA = (*PIO_Type)(unsafe.Pointer(uintptr(0x400e0e00)))

	// Parallel Input/Output Controller B
	PIOB = (*PIO_Type)(unsafe.Pointer(uintptr(0x400e1000)))

	// Parallel Input/Output Controller C
	PIOC = (*PIO_Type)(unsafe.Pointer(uintptr(0x400e1200)))

	// Reset Controller
	RSTC = (*SYSC_Type)(unsafe.Pointer(uintptr(0x400e1400)))

	// Supply Controller
	SUPC = (*SYSC_Type)(unsafe.Pointer(uintptr(0x400e1410)))

	// Real-time Timer
	RTT = (*SYSC_Type)(unsafe.Pointer(uintptr(0x400e1430)))

	// Watchdog Timer
	WDT = (*SYSC_Type)(unsafe.Pointer(uintptr(0x400e1450)))

	// Real-time Clock
	RTC = (*SYSC_Type)(unsafe.Pointer(uintptr(0x400e1460)))

	// General Purpose Backup Registers
	GPBR = (*SYSC_Type)(unsafe.Pointer(uintptr(0x400e1490)))
)

// High Speed MultiMedia Card Interface
type HSMCI_Type struct {
	CR    volatile.Register32    // 0x0
	MR    volatile.Register32    // 0x4
	DTOR  volatile.Register32    // 0x8
	SDCR  volatile.Register32    // 0xC
	ARGR  volatile.Register32    // 0x10
	CMDR  volatile.Register32    // 0x14
	BLKR  volatile.Register32    // 0x18
	CSTOR volatile.Register32    // 0x1C
	RSPR  [4]volatile.Register32 // 0x20
	RDR   volatile.Register32    // 0x30
	TDR   volatile.Register32    // 0x34
	_     [8]byte
	SR    volatile.Register32 // 0x40
	IER   volatile.Register32 // 0x44
	IDR   volatile.Register32 // 0x48
	IMR   volatile.Register32 // 0x4C
	_     [4]byte
	CFG   volatile.Register32 // 0x54
	_     [140]byte
	WPMR  volatile.Register32 // 0xE4
	WPSR  volatile.Register32 // 0xE8
	_     [20]byte
	RPR   volatile.Register32 // 0x100
	RCR   volatile.Register32 // 0x104
	TPR   volatile.Register32 // 0x108
	TCR   volatile.Register32 // 0x10C
	RNPR  volatile.Register32 // 0x110
	RNCR  volatile.Register32 // 0x114
	TNPR  volatile.Register32 // 0x118
	TNCR  volatile.Register32 // 0x11C
	PTCR  volatile.Register32 // 0x120
	PTSR  volatile.Register32 // 0x124
	_     [216]byte
	FIFO  [256]volatile.Register32 // 0x200
}

// HSMCI.CR: Control Register
func (o *HSMCI_Type) SetCR_MCIEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *HSMCI_Type) GetCR_MCIEN() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *HSMCI_Type) SetCR_MCIDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *HSMCI_Type) GetCR_MCIDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *HSMCI_Type) SetCR_PWSEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *HSMCI_Type) GetCR_PWSEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *HSMCI_Type) SetCR_PWSDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *HSMCI_Type) GetCR_PWSDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *HSMCI_Type) SetCR_SWRST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *HSMCI_Type) GetCR_SWRST() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}

// HSMCI.MR: Mode Register
func (o *HSMCI_Type) SetMR_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xff)|value)
}
func (o *HSMCI_Type) GetMR_CLKDIV() uint32 {
	return volatile.LoadUint32(&o.MR.Reg) & 0xff
}
func (o *HSMCI_Type) SetMR_PWSDIV(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x700)|value<<8)
}
func (o *HSMCI_Type) GetMR_PWSDIV() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x700) >> 8
}
func (o *HSMCI_Type) SetMR_RDPROOF(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x800)|value<<11)
}
func (o *HSMCI_Type) GetMR_RDPROOF() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x800) >> 11
}
func (o *HSMCI_Type) SetMR_WRPROOF(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x1000)|value<<12)
}
func (o *HSMCI_Type) GetMR_WRPROOF() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x1000) >> 12
}
func (o *HSMCI_Type) SetMR_FBYTE(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x2000)|value<<13)
}
func (o *HSMCI_Type) GetMR_FBYTE() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x2000) >> 13
}
func (o *HSMCI_Type) SetMR_PADV(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x4000)|value<<14)
}
func (o *HSMCI_Type) GetMR_PADV() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x4000) >> 14
}
func (o *HSMCI_Type) SetMR_PDCMODE(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x8000)|value<<15)
}
func (o *HSMCI_Type) GetMR_PDCMODE() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x8000) >> 15
}

// HSMCI.DTOR: Data Timeout Register
func (o *HSMCI_Type) SetDTOR_DTOCYC(value uint32) {
	volatile.StoreUint32(&o.DTOR.Reg, volatile.LoadUint32(&o.DTOR.Reg)&^(0xf)|value)
}
func (o *HSMCI_Type) GetDTOR_DTOCYC() uint32 {
	return volatile.LoadUint32(&o.DTOR.Reg) & 0xf
}
func (o *HSMCI_Type) SetDTOR_DTOMUL(value uint32) {
	volatile.StoreUint32(&o.DTOR.Reg, volatile.LoadUint32(&o.DTOR.Reg)&^(0x70)|value<<4)
}
func (o *HSMCI_Type) GetDTOR_DTOMUL() uint32 {
	return (volatile.LoadUint32(&o.DTOR.Reg) & 0x70) >> 4
}

// HSMCI.SDCR: SD/SDIO Card Register
func (o *HSMCI_Type) SetSDCR_SDCSEL(value uint32) {
	volatile.StoreUint32(&o.SDCR.Reg, volatile.LoadUint32(&o.SDCR.Reg)&^(0x3)|value)
}
func (o *HSMCI_Type) GetSDCR_SDCSEL() uint32 {
	return volatile.LoadUint32(&o.SDCR.Reg) & 0x3
}
func (o *HSMCI_Type) SetSDCR_SDCBUS(value uint32) {
	volatile.StoreUint32(&o.SDCR.Reg, volatile.LoadUint32(&o.SDCR.Reg)&^(0xc0)|value<<6)
}
func (o *HSMCI_Type) GetSDCR_SDCBUS() uint32 {
	return (volatile.LoadUint32(&o.SDCR.Reg) & 0xc0) >> 6
}

// HSMCI.ARGR: Argument Register
func (o *HSMCI_Type) SetARGR(value uint32) {
	volatile.StoreUint32(&o.ARGR.Reg, value)
}
func (o *HSMCI_Type) GetARGR() uint32 {
	return volatile.LoadUint32(&o.ARGR.Reg)
}

// HSMCI.CMDR: Command Register
func (o *HSMCI_Type) SetCMDR_CMDNB(value uint32) {
	volatile.StoreUint32(&o.CMDR.Reg, volatile.LoadUint32(&o.CMDR.Reg)&^(0x3f)|value)
}
func (o *HSMCI_Type) GetCMDR_CMDNB() uint32 {
	return volatile.LoadUint32(&o.CMDR.Reg) & 0x3f
}
func (o *HSMCI_Type) SetCMDR_RSPTYP(value uint32) {
	volatile.StoreUint32(&o.CMDR.Reg, volatile.LoadUint32(&o.CMDR.Reg)&^(0xc0)|value<<6)
}
func (o *HSMCI_Type) GetCMDR_RSPTYP() uint32 {
	return (volatile.LoadUint32(&o.CMDR.Reg) & 0xc0) >> 6
}
func (o *HSMCI_Type) SetCMDR_SPCMD(value uint32) {
	volatile.StoreUint32(&o.CMDR.Reg, volatile.LoadUint32(&o.CMDR.Reg)&^(0x700)|value<<8)
}
func (o *HSMCI_Type) GetCMDR_SPCMD() uint32 {
	return (volatile.LoadUint32(&o.CMDR.Reg) & 0x700) >> 8
}
func (o *HSMCI_Type) SetCMDR_OPDCMD(value uint32) {
	volatile.StoreUint32(&o.CMDR.Reg, volatile.LoadUint32(&o.CMDR.Reg)&^(0x800)|value<<11)
}
func (o *HSMCI_Type) GetCMDR_OPDCMD() uint32 {
	return (volatile.LoadUint32(&o.CMDR.Reg) & 0x800) >> 11
}
func (o *HSMCI_Type) SetCMDR_MAXLAT(value uint32) {
	volatile.StoreUint32(&o.CMDR.Reg, volatile.LoadUint32(&o.CMDR.Reg)&^(0x1000)|value<<12)
}
func (o *HSMCI_Type) GetCMDR_MAXLAT() uint32 {
	return (volatile.LoadUint32(&o.CMDR.Reg) & 0x1000) >> 12
}
func (o *HSMCI_Type) SetCMDR_TRCMD(value uint32) {
	volatile.StoreUint32(&o.CMDR.Reg, volatile.LoadUint32(&o.CMDR.Reg)&^(0x30000)|value<<16)
}
func (o *HSMCI_Type) GetCMDR_TRCMD() uint32 {
	return (volatile.LoadUint32(&o.CMDR.Reg) & 0x30000) >> 16
}
func (o *HSMCI_Type) SetCMDR_TRDIR(value uint32) {
	volatile.StoreUint32(&o.CMDR.Reg, volatile.LoadUint32(&o.CMDR.Reg)&^(0x40000)|value<<18)
}
func (o *HSMCI_Type) GetCMDR_TRDIR() uint32 {
	return (volatile.LoadUint32(&o.CMDR.Reg) & 0x40000) >> 18
}
func (o *HSMCI_Type) SetCMDR_TRTYP(value uint32) {
	volatile.StoreUint32(&o.CMDR.Reg, volatile.LoadUint32(&o.CMDR.Reg)&^(0x380000)|value<<19)
}
func (o *HSMCI_Type) GetCMDR_TRTYP() uint32 {
	return (volatile.LoadUint32(&o.CMDR.Reg) & 0x380000) >> 19
}
func (o *HSMCI_Type) SetCMDR_IOSPCMD(value uint32) {
	volatile.StoreUint32(&o.CMDR.Reg, volatile.LoadUint32(&o.CMDR.Reg)&^(0x3000000)|value<<24)
}
func (o *HSMCI_Type) GetCMDR_IOSPCMD() uint32 {
	return (volatile.LoadUint32(&o.CMDR.Reg) & 0x3000000) >> 24
}
func (o *HSMCI_Type) SetCMDR_ATACS(value uint32) {
	volatile.StoreUint32(&o.CMDR.Reg, volatile.LoadUint32(&o.CMDR.Reg)&^(0x4000000)|value<<26)
}
func (o *HSMCI_Type) GetCMDR_ATACS() uint32 {
	return (volatile.LoadUint32(&o.CMDR.Reg) & 0x4000000) >> 26
}
func (o *HSMCI_Type) SetCMDR_BOOT_ACK(value uint32) {
	volatile.StoreUint32(&o.CMDR.Reg, volatile.LoadUint32(&o.CMDR.Reg)&^(0x8000000)|value<<27)
}
func (o *HSMCI_Type) GetCMDR_BOOT_ACK() uint32 {
	return (volatile.LoadUint32(&o.CMDR.Reg) & 0x8000000) >> 27
}

// HSMCI.BLKR: Block Register
func (o *HSMCI_Type) SetBLKR_BCNT(value uint32) {
	volatile.StoreUint32(&o.BLKR.Reg, volatile.LoadUint32(&o.BLKR.Reg)&^(0xffff)|value)
}
func (o *HSMCI_Type) GetBLKR_BCNT() uint32 {
	return volatile.LoadUint32(&o.BLKR.Reg) & 0xffff
}
func (o *HSMCI_Type) SetBLKR_BLKLEN(value uint32) {
	volatile.StoreUint32(&o.BLKR.Reg, volatile.LoadUint32(&o.BLKR.Reg)&^(0xffff0000)|value<<16)
}
func (o *HSMCI_Type) GetBLKR_BLKLEN() uint32 {
	return (volatile.LoadUint32(&o.BLKR.Reg) & 0xffff0000) >> 16
}

// HSMCI.CSTOR: Completion Signal Timeout Register
func (o *HSMCI_Type) SetCSTOR_CSTOCYC(value uint32) {
	volatile.StoreUint32(&o.CSTOR.Reg, volatile.LoadUint32(&o.CSTOR.Reg)&^(0xf)|value)
}
func (o *HSMCI_Type) GetCSTOR_CSTOCYC() uint32 {
	return volatile.LoadUint32(&o.CSTOR.Reg) & 0xf
}
func (o *HSMCI_Type) SetCSTOR_CSTOMUL(value uint32) {
	volatile.StoreUint32(&o.CSTOR.Reg, volatile.LoadUint32(&o.CSTOR.Reg)&^(0x70)|value<<4)
}
func (o *HSMCI_Type) GetCSTOR_CSTOMUL() uint32 {
	return (volatile.LoadUint32(&o.CSTOR.Reg) & 0x70) >> 4
}

// HSMCI.RSPR: Response Register
func (o *HSMCI_Type) SetRSPR(idx int, value uint32) {
	volatile.StoreUint32(&o.RSPR[idx].Reg, value)
}
func (o *HSMCI_Type) GetRSPR(idx int) uint32 {
	return volatile.LoadUint32(&o.RSPR[idx].Reg)
}

// HSMCI.RDR: Receive Data Register
func (o *HSMCI_Type) SetRDR(value uint32) {
	volatile.StoreUint32(&o.RDR.Reg, value)
}
func (o *HSMCI_Type) GetRDR() uint32 {
	return volatile.LoadUint32(&o.RDR.Reg)
}

// HSMCI.TDR: Transmit Data Register
func (o *HSMCI_Type) SetTDR(value uint32) {
	volatile.StoreUint32(&o.TDR.Reg, value)
}
func (o *HSMCI_Type) GetTDR() uint32 {
	return volatile.LoadUint32(&o.TDR.Reg)
}

// HSMCI.SR: Status Register
func (o *HSMCI_Type) SetSR_CMDRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *HSMCI_Type) GetSR_CMDRDY() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *HSMCI_Type) SetSR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *HSMCI_Type) GetSR_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *HSMCI_Type) SetSR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *HSMCI_Type) GetSR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *HSMCI_Type) SetSR_BLKE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *HSMCI_Type) GetSR_BLKE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *HSMCI_Type) SetSR_DTIP(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *HSMCI_Type) GetSR_DTIP() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *HSMCI_Type) SetSR_NOTBUSY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *HSMCI_Type) GetSR_NOTBUSY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *HSMCI_Type) SetSR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *HSMCI_Type) GetSR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *HSMCI_Type) SetSR_ENDTX(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80)|value<<7)
}
func (o *HSMCI_Type) GetSR_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80) >> 7
}
func (o *HSMCI_Type) SetSR_SDIOIRQA(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100)|value<<8)
}
func (o *HSMCI_Type) GetSR_SDIOIRQA() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100) >> 8
}
func (o *HSMCI_Type) SetSR_SDIOWAIT(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1000)|value<<12)
}
func (o *HSMCI_Type) GetSR_SDIOWAIT() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x1000) >> 12
}
func (o *HSMCI_Type) SetSR_CSRCV(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2000)|value<<13)
}
func (o *HSMCI_Type) GetSR_CSRCV() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2000) >> 13
}
func (o *HSMCI_Type) SetSR_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4000)|value<<14)
}
func (o *HSMCI_Type) GetSR_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4000) >> 14
}
func (o *HSMCI_Type) SetSR_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8000)|value<<15)
}
func (o *HSMCI_Type) GetSR_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8000) >> 15
}
func (o *HSMCI_Type) SetSR_RINDE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10000)|value<<16)
}
func (o *HSMCI_Type) GetSR_RINDE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10000) >> 16
}
func (o *HSMCI_Type) SetSR_RDIRE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20000)|value<<17)
}
func (o *HSMCI_Type) GetSR_RDIRE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20000) >> 17
}
func (o *HSMCI_Type) SetSR_RCRCE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40000)|value<<18)
}
func (o *HSMCI_Type) GetSR_RCRCE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40000) >> 18
}
func (o *HSMCI_Type) SetSR_RENDE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80000)|value<<19)
}
func (o *HSMCI_Type) GetSR_RENDE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80000) >> 19
}
func (o *HSMCI_Type) SetSR_RTOE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100000)|value<<20)
}
func (o *HSMCI_Type) GetSR_RTOE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100000) >> 20
}
func (o *HSMCI_Type) SetSR_DCRCE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x200000)|value<<21)
}
func (o *HSMCI_Type) GetSR_DCRCE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x200000) >> 21
}
func (o *HSMCI_Type) SetSR_DTOE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x400000)|value<<22)
}
func (o *HSMCI_Type) GetSR_DTOE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x400000) >> 22
}
func (o *HSMCI_Type) SetSR_CSTOE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x800000)|value<<23)
}
func (o *HSMCI_Type) GetSR_CSTOE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x800000) >> 23
}
func (o *HSMCI_Type) SetSR_FIFOEMPTY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4000000)|value<<26)
}
func (o *HSMCI_Type) GetSR_FIFOEMPTY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4000000) >> 26
}
func (o *HSMCI_Type) SetSR_XFRDONE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8000000)|value<<27)
}
func (o *HSMCI_Type) GetSR_XFRDONE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8000000) >> 27
}
func (o *HSMCI_Type) SetSR_ACKRCV(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10000000)|value<<28)
}
func (o *HSMCI_Type) GetSR_ACKRCV() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10000000) >> 28
}
func (o *HSMCI_Type) SetSR_ACKRCVE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20000000)|value<<29)
}
func (o *HSMCI_Type) GetSR_ACKRCVE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20000000) >> 29
}
func (o *HSMCI_Type) SetSR_OVRE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40000000)|value<<30)
}
func (o *HSMCI_Type) GetSR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40000000) >> 30
}
func (o *HSMCI_Type) SetSR_UNRE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80000000)|value<<31)
}
func (o *HSMCI_Type) GetSR_UNRE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80000000) >> 31
}

// HSMCI.IER: Interrupt Enable Register
func (o *HSMCI_Type) SetIER_CMDRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *HSMCI_Type) GetIER_CMDRDY() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *HSMCI_Type) SetIER_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *HSMCI_Type) GetIER_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *HSMCI_Type) SetIER_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *HSMCI_Type) GetIER_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *HSMCI_Type) SetIER_BLKE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *HSMCI_Type) GetIER_BLKE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *HSMCI_Type) SetIER_DTIP(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *HSMCI_Type) GetIER_DTIP() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *HSMCI_Type) SetIER_NOTBUSY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *HSMCI_Type) GetIER_NOTBUSY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *HSMCI_Type) SetIER_ENDRX(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40)|value<<6)
}
func (o *HSMCI_Type) GetIER_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40) >> 6
}
func (o *HSMCI_Type) SetIER_ENDTX(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80)|value<<7)
}
func (o *HSMCI_Type) GetIER_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80) >> 7
}
func (o *HSMCI_Type) SetIER_SDIOIRQA(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100)|value<<8)
}
func (o *HSMCI_Type) GetIER_SDIOIRQA() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100) >> 8
}
func (o *HSMCI_Type) SetIER_SDIOWAIT(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1000)|value<<12)
}
func (o *HSMCI_Type) GetIER_SDIOWAIT() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x1000) >> 12
}
func (o *HSMCI_Type) SetIER_CSRCV(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2000)|value<<13)
}
func (o *HSMCI_Type) GetIER_CSRCV() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2000) >> 13
}
func (o *HSMCI_Type) SetIER_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4000)|value<<14)
}
func (o *HSMCI_Type) GetIER_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4000) >> 14
}
func (o *HSMCI_Type) SetIER_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8000)|value<<15)
}
func (o *HSMCI_Type) GetIER_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8000) >> 15
}
func (o *HSMCI_Type) SetIER_RINDE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10000)|value<<16)
}
func (o *HSMCI_Type) GetIER_RINDE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10000) >> 16
}
func (o *HSMCI_Type) SetIER_RDIRE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20000)|value<<17)
}
func (o *HSMCI_Type) GetIER_RDIRE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20000) >> 17
}
func (o *HSMCI_Type) SetIER_RCRCE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40000)|value<<18)
}
func (o *HSMCI_Type) GetIER_RCRCE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40000) >> 18
}
func (o *HSMCI_Type) SetIER_RENDE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80000)|value<<19)
}
func (o *HSMCI_Type) GetIER_RENDE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80000) >> 19
}
func (o *HSMCI_Type) SetIER_RTOE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100000)|value<<20)
}
func (o *HSMCI_Type) GetIER_RTOE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100000) >> 20
}
func (o *HSMCI_Type) SetIER_DCRCE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200000)|value<<21)
}
func (o *HSMCI_Type) GetIER_DCRCE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200000) >> 21
}
func (o *HSMCI_Type) SetIER_DTOE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400000)|value<<22)
}
func (o *HSMCI_Type) GetIER_DTOE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400000) >> 22
}
func (o *HSMCI_Type) SetIER_CSTOE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x800000)|value<<23)
}
func (o *HSMCI_Type) GetIER_CSTOE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x800000) >> 23
}
func (o *HSMCI_Type) SetIER_FIFOEMPTY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4000000)|value<<26)
}
func (o *HSMCI_Type) GetIER_FIFOEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4000000) >> 26
}
func (o *HSMCI_Type) SetIER_XFRDONE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8000000)|value<<27)
}
func (o *HSMCI_Type) GetIER_XFRDONE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8000000) >> 27
}
func (o *HSMCI_Type) SetIER_ACKRCV(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10000000)|value<<28)
}
func (o *HSMCI_Type) GetIER_ACKRCV() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10000000) >> 28
}
func (o *HSMCI_Type) SetIER_ACKRCVE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20000000)|value<<29)
}
func (o *HSMCI_Type) GetIER_ACKRCVE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20000000) >> 29
}
func (o *HSMCI_Type) SetIER_OVRE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40000000)|value<<30)
}
func (o *HSMCI_Type) GetIER_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40000000) >> 30
}
func (o *HSMCI_Type) SetIER_UNRE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80000000)|value<<31)
}
func (o *HSMCI_Type) GetIER_UNRE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80000000) >> 31
}

// HSMCI.IDR: Interrupt Disable Register
func (o *HSMCI_Type) SetIDR_CMDRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *HSMCI_Type) GetIDR_CMDRDY() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *HSMCI_Type) SetIDR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *HSMCI_Type) GetIDR_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *HSMCI_Type) SetIDR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4)|value<<2)
}
func (o *HSMCI_Type) GetIDR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4) >> 2
}
func (o *HSMCI_Type) SetIDR_BLKE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8)|value<<3)
}
func (o *HSMCI_Type) GetIDR_BLKE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8) >> 3
}
func (o *HSMCI_Type) SetIDR_DTIP(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10)|value<<4)
}
func (o *HSMCI_Type) GetIDR_DTIP() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10) >> 4
}
func (o *HSMCI_Type) SetIDR_NOTBUSY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20)|value<<5)
}
func (o *HSMCI_Type) GetIDR_NOTBUSY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20) >> 5
}
func (o *HSMCI_Type) SetIDR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40)|value<<6)
}
func (o *HSMCI_Type) GetIDR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40) >> 6
}
func (o *HSMCI_Type) SetIDR_ENDTX(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80)|value<<7)
}
func (o *HSMCI_Type) GetIDR_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80) >> 7
}
func (o *HSMCI_Type) SetIDR_SDIOIRQA(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100)|value<<8)
}
func (o *HSMCI_Type) GetIDR_SDIOIRQA() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100) >> 8
}
func (o *HSMCI_Type) SetIDR_SDIOWAIT(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1000)|value<<12)
}
func (o *HSMCI_Type) GetIDR_SDIOWAIT() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x1000) >> 12
}
func (o *HSMCI_Type) SetIDR_CSRCV(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2000)|value<<13)
}
func (o *HSMCI_Type) GetIDR_CSRCV() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2000) >> 13
}
func (o *HSMCI_Type) SetIDR_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4000)|value<<14)
}
func (o *HSMCI_Type) GetIDR_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4000) >> 14
}
func (o *HSMCI_Type) SetIDR_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8000)|value<<15)
}
func (o *HSMCI_Type) GetIDR_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8000) >> 15
}
func (o *HSMCI_Type) SetIDR_RINDE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10000)|value<<16)
}
func (o *HSMCI_Type) GetIDR_RINDE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10000) >> 16
}
func (o *HSMCI_Type) SetIDR_RDIRE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20000)|value<<17)
}
func (o *HSMCI_Type) GetIDR_RDIRE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20000) >> 17
}
func (o *HSMCI_Type) SetIDR_RCRCE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40000)|value<<18)
}
func (o *HSMCI_Type) GetIDR_RCRCE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40000) >> 18
}
func (o *HSMCI_Type) SetIDR_RENDE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80000)|value<<19)
}
func (o *HSMCI_Type) GetIDR_RENDE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80000) >> 19
}
func (o *HSMCI_Type) SetIDR_RTOE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100000)|value<<20)
}
func (o *HSMCI_Type) GetIDR_RTOE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100000) >> 20
}
func (o *HSMCI_Type) SetIDR_DCRCE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200000)|value<<21)
}
func (o *HSMCI_Type) GetIDR_DCRCE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200000) >> 21
}
func (o *HSMCI_Type) SetIDR_DTOE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400000)|value<<22)
}
func (o *HSMCI_Type) GetIDR_DTOE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400000) >> 22
}
func (o *HSMCI_Type) SetIDR_CSTOE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x800000)|value<<23)
}
func (o *HSMCI_Type) GetIDR_CSTOE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x800000) >> 23
}
func (o *HSMCI_Type) SetIDR_FIFOEMPTY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4000000)|value<<26)
}
func (o *HSMCI_Type) GetIDR_FIFOEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4000000) >> 26
}
func (o *HSMCI_Type) SetIDR_XFRDONE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8000000)|value<<27)
}
func (o *HSMCI_Type) GetIDR_XFRDONE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8000000) >> 27
}
func (o *HSMCI_Type) SetIDR_ACKRCV(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10000000)|value<<28)
}
func (o *HSMCI_Type) GetIDR_ACKRCV() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10000000) >> 28
}
func (o *HSMCI_Type) SetIDR_ACKRCVE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20000000)|value<<29)
}
func (o *HSMCI_Type) GetIDR_ACKRCVE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20000000) >> 29
}
func (o *HSMCI_Type) SetIDR_OVRE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40000000)|value<<30)
}
func (o *HSMCI_Type) GetIDR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40000000) >> 30
}
func (o *HSMCI_Type) SetIDR_UNRE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80000000)|value<<31)
}
func (o *HSMCI_Type) GetIDR_UNRE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80000000) >> 31
}

// HSMCI.IMR: Interrupt Mask Register
func (o *HSMCI_Type) SetIMR_CMDRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *HSMCI_Type) GetIMR_CMDRDY() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *HSMCI_Type) SetIMR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *HSMCI_Type) GetIMR_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *HSMCI_Type) SetIMR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4)|value<<2)
}
func (o *HSMCI_Type) GetIMR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4) >> 2
}
func (o *HSMCI_Type) SetIMR_BLKE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8)|value<<3)
}
func (o *HSMCI_Type) GetIMR_BLKE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8) >> 3
}
func (o *HSMCI_Type) SetIMR_DTIP(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10)|value<<4)
}
func (o *HSMCI_Type) GetIMR_DTIP() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10) >> 4
}
func (o *HSMCI_Type) SetIMR_NOTBUSY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20)|value<<5)
}
func (o *HSMCI_Type) GetIMR_NOTBUSY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20) >> 5
}
func (o *HSMCI_Type) SetIMR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40)|value<<6)
}
func (o *HSMCI_Type) GetIMR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40) >> 6
}
func (o *HSMCI_Type) SetIMR_ENDTX(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80)|value<<7)
}
func (o *HSMCI_Type) GetIMR_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80) >> 7
}
func (o *HSMCI_Type) SetIMR_SDIOIRQA(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100)|value<<8)
}
func (o *HSMCI_Type) GetIMR_SDIOIRQA() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100) >> 8
}
func (o *HSMCI_Type) SetIMR_SDIOWAIT(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1000)|value<<12)
}
func (o *HSMCI_Type) GetIMR_SDIOWAIT() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x1000) >> 12
}
func (o *HSMCI_Type) SetIMR_CSRCV(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2000)|value<<13)
}
func (o *HSMCI_Type) GetIMR_CSRCV() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2000) >> 13
}
func (o *HSMCI_Type) SetIMR_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4000)|value<<14)
}
func (o *HSMCI_Type) GetIMR_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4000) >> 14
}
func (o *HSMCI_Type) SetIMR_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8000)|value<<15)
}
func (o *HSMCI_Type) GetIMR_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8000) >> 15
}
func (o *HSMCI_Type) SetIMR_RINDE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10000)|value<<16)
}
func (o *HSMCI_Type) GetIMR_RINDE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10000) >> 16
}
func (o *HSMCI_Type) SetIMR_RDIRE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20000)|value<<17)
}
func (o *HSMCI_Type) GetIMR_RDIRE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20000) >> 17
}
func (o *HSMCI_Type) SetIMR_RCRCE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40000)|value<<18)
}
func (o *HSMCI_Type) GetIMR_RCRCE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40000) >> 18
}
func (o *HSMCI_Type) SetIMR_RENDE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80000)|value<<19)
}
func (o *HSMCI_Type) GetIMR_RENDE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80000) >> 19
}
func (o *HSMCI_Type) SetIMR_RTOE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100000)|value<<20)
}
func (o *HSMCI_Type) GetIMR_RTOE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100000) >> 20
}
func (o *HSMCI_Type) SetIMR_DCRCE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200000)|value<<21)
}
func (o *HSMCI_Type) GetIMR_DCRCE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200000) >> 21
}
func (o *HSMCI_Type) SetIMR_DTOE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400000)|value<<22)
}
func (o *HSMCI_Type) GetIMR_DTOE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400000) >> 22
}
func (o *HSMCI_Type) SetIMR_CSTOE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x800000)|value<<23)
}
func (o *HSMCI_Type) GetIMR_CSTOE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x800000) >> 23
}
func (o *HSMCI_Type) SetIMR_FIFOEMPTY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4000000)|value<<26)
}
func (o *HSMCI_Type) GetIMR_FIFOEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4000000) >> 26
}
func (o *HSMCI_Type) SetIMR_XFRDONE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8000000)|value<<27)
}
func (o *HSMCI_Type) GetIMR_XFRDONE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8000000) >> 27
}
func (o *HSMCI_Type) SetIMR_ACKRCV(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10000000)|value<<28)
}
func (o *HSMCI_Type) GetIMR_ACKRCV() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10000000) >> 28
}
func (o *HSMCI_Type) SetIMR_ACKRCVE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20000000)|value<<29)
}
func (o *HSMCI_Type) GetIMR_ACKRCVE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20000000) >> 29
}
func (o *HSMCI_Type) SetIMR_OVRE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40000000)|value<<30)
}
func (o *HSMCI_Type) GetIMR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40000000) >> 30
}
func (o *HSMCI_Type) SetIMR_UNRE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80000000)|value<<31)
}
func (o *HSMCI_Type) GetIMR_UNRE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80000000) >> 31
}

// HSMCI.CFG: Configuration Register
func (o *HSMCI_Type) SetCFG_FIFOMODE(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x1)|value)
}
func (o *HSMCI_Type) GetCFG_FIFOMODE() uint32 {
	return volatile.LoadUint32(&o.CFG.Reg) & 0x1
}
func (o *HSMCI_Type) SetCFG_FERRCTRL(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x10)|value<<4)
}
func (o *HSMCI_Type) GetCFG_FERRCTRL() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x10) >> 4
}
func (o *HSMCI_Type) SetCFG_HSMODE(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x100)|value<<8)
}
func (o *HSMCI_Type) GetCFG_HSMODE() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x100) >> 8
}
func (o *HSMCI_Type) SetCFG_LSYNC(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x1000)|value<<12)
}
func (o *HSMCI_Type) GetCFG_LSYNC() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x1000) >> 12
}

// HSMCI.WPMR: Write Protection Mode Register
func (o *HSMCI_Type) SetWPMR_WPEN(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0x1)|value)
}
func (o *HSMCI_Type) GetWPMR_WPEN() uint32 {
	return volatile.LoadUint32(&o.WPMR.Reg) & 0x1
}
func (o *HSMCI_Type) SetWPMR_WPKEY(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0xffffff00)|value<<8)
}
func (o *HSMCI_Type) GetWPMR_WPKEY() uint32 {
	return (volatile.LoadUint32(&o.WPMR.Reg) & 0xffffff00) >> 8
}

// HSMCI.WPSR: Write Protection Status Register
func (o *HSMCI_Type) SetWPSR_WPVS(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x1)|value)
}
func (o *HSMCI_Type) GetWPSR_WPVS() uint32 {
	return volatile.LoadUint32(&o.WPSR.Reg) & 0x1
}
func (o *HSMCI_Type) SetWPSR_WPVSRC(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0xffff00)|value<<8)
}
func (o *HSMCI_Type) GetWPSR_WPVSRC() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0xffff00) >> 8
}

// HSMCI.RPR: Receive Pointer Register
func (o *HSMCI_Type) SetRPR(value uint32) {
	volatile.StoreUint32(&o.RPR.Reg, value)
}
func (o *HSMCI_Type) GetRPR() uint32 {
	return volatile.LoadUint32(&o.RPR.Reg)
}

// HSMCI.RCR: Receive Counter Register
func (o *HSMCI_Type) SetRCR_RXCTR(value uint32) {
	volatile.StoreUint32(&o.RCR.Reg, volatile.LoadUint32(&o.RCR.Reg)&^(0xffff)|value)
}
func (o *HSMCI_Type) GetRCR_RXCTR() uint32 {
	return volatile.LoadUint32(&o.RCR.Reg) & 0xffff
}

// HSMCI.TPR: Transmit Pointer Register
func (o *HSMCI_Type) SetTPR(value uint32) {
	volatile.StoreUint32(&o.TPR.Reg, value)
}
func (o *HSMCI_Type) GetTPR() uint32 {
	return volatile.LoadUint32(&o.TPR.Reg)
}

// HSMCI.TCR: Transmit Counter Register
func (o *HSMCI_Type) SetTCR_TXCTR(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0xffff)|value)
}
func (o *HSMCI_Type) GetTCR_TXCTR() uint32 {
	return volatile.LoadUint32(&o.TCR.Reg) & 0xffff
}

// HSMCI.RNPR: Receive Next Pointer Register
func (o *HSMCI_Type) SetRNPR(value uint32) {
	volatile.StoreUint32(&o.RNPR.Reg, value)
}
func (o *HSMCI_Type) GetRNPR() uint32 {
	return volatile.LoadUint32(&o.RNPR.Reg)
}

// HSMCI.RNCR: Receive Next Counter Register
func (o *HSMCI_Type) SetRNCR_RXNCTR(value uint32) {
	volatile.StoreUint32(&o.RNCR.Reg, volatile.LoadUint32(&o.RNCR.Reg)&^(0xffff)|value)
}
func (o *HSMCI_Type) GetRNCR_RXNCTR() uint32 {
	return volatile.LoadUint32(&o.RNCR.Reg) & 0xffff
}

// HSMCI.TNPR: Transmit Next Pointer Register
func (o *HSMCI_Type) SetTNPR(value uint32) {
	volatile.StoreUint32(&o.TNPR.Reg, value)
}
func (o *HSMCI_Type) GetTNPR() uint32 {
	return volatile.LoadUint32(&o.TNPR.Reg)
}

// HSMCI.TNCR: Transmit Next Counter Register
func (o *HSMCI_Type) SetTNCR_TXNCTR(value uint32) {
	volatile.StoreUint32(&o.TNCR.Reg, volatile.LoadUint32(&o.TNCR.Reg)&^(0xffff)|value)
}
func (o *HSMCI_Type) GetTNCR_TXNCTR() uint32 {
	return volatile.LoadUint32(&o.TNCR.Reg) & 0xffff
}

// HSMCI.PTCR: Transfer Control Register
func (o *HSMCI_Type) SetPTCR_RXTEN(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x1)|value)
}
func (o *HSMCI_Type) GetPTCR_RXTEN() uint32 {
	return volatile.LoadUint32(&o.PTCR.Reg) & 0x1
}
func (o *HSMCI_Type) SetPTCR_RXTDIS(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x2)|value<<1)
}
func (o *HSMCI_Type) GetPTCR_RXTDIS() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x2) >> 1
}
func (o *HSMCI_Type) SetPTCR_TXTEN(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x100)|value<<8)
}
func (o *HSMCI_Type) GetPTCR_TXTEN() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x100) >> 8
}
func (o *HSMCI_Type) SetPTCR_TXTDIS(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x200)|value<<9)
}
func (o *HSMCI_Type) GetPTCR_TXTDIS() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x200) >> 9
}

// HSMCI.PTSR: Transfer Status Register
func (o *HSMCI_Type) SetPTSR_RXTEN(value uint32) {
	volatile.StoreUint32(&o.PTSR.Reg, volatile.LoadUint32(&o.PTSR.Reg)&^(0x1)|value)
}
func (o *HSMCI_Type) GetPTSR_RXTEN() uint32 {
	return volatile.LoadUint32(&o.PTSR.Reg) & 0x1
}
func (o *HSMCI_Type) SetPTSR_TXTEN(value uint32) {
	volatile.StoreUint32(&o.PTSR.Reg, volatile.LoadUint32(&o.PTSR.Reg)&^(0x100)|value<<8)
}
func (o *HSMCI_Type) GetPTSR_TXTEN() uint32 {
	return (volatile.LoadUint32(&o.PTSR.Reg) & 0x100) >> 8
}

// HSMCI.FIFO: FIFO Memory Aperture0
func (o *HSMCI_Type) SetFIFO(idx int, value uint32) {
	volatile.StoreUint32(&o.FIFO[idx].Reg, value)
}
func (o *HSMCI_Type) GetFIFO(idx int) uint32 {
	return volatile.LoadUint32(&o.FIFO[idx].Reg)
}

// Synchronous Serial Controller
type SSC_Type struct {
	CR   volatile.Register32 // 0x0
	CMR  volatile.Register32 // 0x4
	_    [8]byte
	RCMR volatile.Register32 // 0x10
	RFMR volatile.Register32 // 0x14
	TCMR volatile.Register32 // 0x18
	TFMR volatile.Register32 // 0x1C
	RHR  volatile.Register32 // 0x20
	THR  volatile.Register32 // 0x24
	_    [8]byte
	RSHR volatile.Register32 // 0x30
	TSHR volatile.Register32 // 0x34
	RC0R volatile.Register32 // 0x38
	RC1R volatile.Register32 // 0x3C
	SR   volatile.Register32 // 0x40
	IER  volatile.Register32 // 0x44
	IDR  volatile.Register32 // 0x48
	IMR  volatile.Register32 // 0x4C
	_    [148]byte
	WPMR volatile.Register32 // 0xE4
	WPSR volatile.Register32 // 0xE8
	_    [20]byte
	RPR  volatile.Register32 // 0x100
	RCR  volatile.Register32 // 0x104
	TPR  volatile.Register32 // 0x108
	TCR  volatile.Register32 // 0x10C
	RNPR volatile.Register32 // 0x110
	RNCR volatile.Register32 // 0x114
	TNPR volatile.Register32 // 0x118
	TNCR volatile.Register32 // 0x11C
	PTCR volatile.Register32 // 0x120
	PTSR volatile.Register32 // 0x124
}

// SSC.CR: Control Register
func (o *SSC_Type) SetCR_RXEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *SSC_Type) GetCR_RXEN() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *SSC_Type) SetCR_RXDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *SSC_Type) GetCR_RXDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *SSC_Type) SetCR_TXEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100)|value<<8)
}
func (o *SSC_Type) GetCR_TXEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100) >> 8
}
func (o *SSC_Type) SetCR_TXDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x200)|value<<9)
}
func (o *SSC_Type) GetCR_TXDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x200) >> 9
}
func (o *SSC_Type) SetCR_SWRST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8000)|value<<15)
}
func (o *SSC_Type) GetCR_SWRST() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8000) >> 15
}

// SSC.CMR: Clock Mode Register
func (o *SSC_Type) SetCMR_DIV(value uint32) {
	volatile.StoreUint32(&o.CMR.Reg, volatile.LoadUint32(&o.CMR.Reg)&^(0xfff)|value)
}
func (o *SSC_Type) GetCMR_DIV() uint32 {
	return volatile.LoadUint32(&o.CMR.Reg) & 0xfff
}

// SSC.RCMR: Receive Clock Mode Register
func (o *SSC_Type) SetRCMR_CKS(value uint32) {
	volatile.StoreUint32(&o.RCMR.Reg, volatile.LoadUint32(&o.RCMR.Reg)&^(0x3)|value)
}
func (o *SSC_Type) GetRCMR_CKS() uint32 {
	return volatile.LoadUint32(&o.RCMR.Reg) & 0x3
}
func (o *SSC_Type) SetRCMR_CKO(value uint32) {
	volatile.StoreUint32(&o.RCMR.Reg, volatile.LoadUint32(&o.RCMR.Reg)&^(0x1c)|value<<2)
}
func (o *SSC_Type) GetRCMR_CKO() uint32 {
	return (volatile.LoadUint32(&o.RCMR.Reg) & 0x1c) >> 2
}
func (o *SSC_Type) SetRCMR_CKI(value uint32) {
	volatile.StoreUint32(&o.RCMR.Reg, volatile.LoadUint32(&o.RCMR.Reg)&^(0x20)|value<<5)
}
func (o *SSC_Type) GetRCMR_CKI() uint32 {
	return (volatile.LoadUint32(&o.RCMR.Reg) & 0x20) >> 5
}
func (o *SSC_Type) SetRCMR_CKG(value uint32) {
	volatile.StoreUint32(&o.RCMR.Reg, volatile.LoadUint32(&o.RCMR.Reg)&^(0xc0)|value<<6)
}
func (o *SSC_Type) GetRCMR_CKG() uint32 {
	return (volatile.LoadUint32(&o.RCMR.Reg) & 0xc0) >> 6
}
func (o *SSC_Type) SetRCMR_START(value uint32) {
	volatile.StoreUint32(&o.RCMR.Reg, volatile.LoadUint32(&o.RCMR.Reg)&^(0xf00)|value<<8)
}
func (o *SSC_Type) GetRCMR_START() uint32 {
	return (volatile.LoadUint32(&o.RCMR.Reg) & 0xf00) >> 8
}
func (o *SSC_Type) SetRCMR_STOP(value uint32) {
	volatile.StoreUint32(&o.RCMR.Reg, volatile.LoadUint32(&o.RCMR.Reg)&^(0x1000)|value<<12)
}
func (o *SSC_Type) GetRCMR_STOP() uint32 {
	return (volatile.LoadUint32(&o.RCMR.Reg) & 0x1000) >> 12
}
func (o *SSC_Type) SetRCMR_STTDLY(value uint32) {
	volatile.StoreUint32(&o.RCMR.Reg, volatile.LoadUint32(&o.RCMR.Reg)&^(0xff0000)|value<<16)
}
func (o *SSC_Type) GetRCMR_STTDLY() uint32 {
	return (volatile.LoadUint32(&o.RCMR.Reg) & 0xff0000) >> 16
}
func (o *SSC_Type) SetRCMR_PERIOD(value uint32) {
	volatile.StoreUint32(&o.RCMR.Reg, volatile.LoadUint32(&o.RCMR.Reg)&^(0xff000000)|value<<24)
}
func (o *SSC_Type) GetRCMR_PERIOD() uint32 {
	return (volatile.LoadUint32(&o.RCMR.Reg) & 0xff000000) >> 24
}

// SSC.RFMR: Receive Frame Mode Register
func (o *SSC_Type) SetRFMR_DATLEN(value uint32) {
	volatile.StoreUint32(&o.RFMR.Reg, volatile.LoadUint32(&o.RFMR.Reg)&^(0x1f)|value)
}
func (o *SSC_Type) GetRFMR_DATLEN() uint32 {
	return volatile.LoadUint32(&o.RFMR.Reg) & 0x1f
}
func (o *SSC_Type) SetRFMR_LOOP(value uint32) {
	volatile.StoreUint32(&o.RFMR.Reg, volatile.LoadUint32(&o.RFMR.Reg)&^(0x20)|value<<5)
}
func (o *SSC_Type) GetRFMR_LOOP() uint32 {
	return (volatile.LoadUint32(&o.RFMR.Reg) & 0x20) >> 5
}
func (o *SSC_Type) SetRFMR_MSBF(value uint32) {
	volatile.StoreUint32(&o.RFMR.Reg, volatile.LoadUint32(&o.RFMR.Reg)&^(0x80)|value<<7)
}
func (o *SSC_Type) GetRFMR_MSBF() uint32 {
	return (volatile.LoadUint32(&o.RFMR.Reg) & 0x80) >> 7
}
func (o *SSC_Type) SetRFMR_DATNB(value uint32) {
	volatile.StoreUint32(&o.RFMR.Reg, volatile.LoadUint32(&o.RFMR.Reg)&^(0xf00)|value<<8)
}
func (o *SSC_Type) GetRFMR_DATNB() uint32 {
	return (volatile.LoadUint32(&o.RFMR.Reg) & 0xf00) >> 8
}
func (o *SSC_Type) SetRFMR_FSLEN(value uint32) {
	volatile.StoreUint32(&o.RFMR.Reg, volatile.LoadUint32(&o.RFMR.Reg)&^(0xf0000)|value<<16)
}
func (o *SSC_Type) GetRFMR_FSLEN() uint32 {
	return (volatile.LoadUint32(&o.RFMR.Reg) & 0xf0000) >> 16
}
func (o *SSC_Type) SetRFMR_FSOS(value uint32) {
	volatile.StoreUint32(&o.RFMR.Reg, volatile.LoadUint32(&o.RFMR.Reg)&^(0x700000)|value<<20)
}
func (o *SSC_Type) GetRFMR_FSOS() uint32 {
	return (volatile.LoadUint32(&o.RFMR.Reg) & 0x700000) >> 20
}
func (o *SSC_Type) SetRFMR_FSEDGE(value uint32) {
	volatile.StoreUint32(&o.RFMR.Reg, volatile.LoadUint32(&o.RFMR.Reg)&^(0x1000000)|value<<24)
}
func (o *SSC_Type) GetRFMR_FSEDGE() uint32 {
	return (volatile.LoadUint32(&o.RFMR.Reg) & 0x1000000) >> 24
}
func (o *SSC_Type) SetRFMR_FSLEN_EXT(value uint32) {
	volatile.StoreUint32(&o.RFMR.Reg, volatile.LoadUint32(&o.RFMR.Reg)&^(0xf0000000)|value<<28)
}
func (o *SSC_Type) GetRFMR_FSLEN_EXT() uint32 {
	return (volatile.LoadUint32(&o.RFMR.Reg) & 0xf0000000) >> 28
}

// SSC.TCMR: Transmit Clock Mode Register
func (o *SSC_Type) SetTCMR_CKS(value uint32) {
	volatile.StoreUint32(&o.TCMR.Reg, volatile.LoadUint32(&o.TCMR.Reg)&^(0x3)|value)
}
func (o *SSC_Type) GetTCMR_CKS() uint32 {
	return volatile.LoadUint32(&o.TCMR.Reg) & 0x3
}
func (o *SSC_Type) SetTCMR_CKO(value uint32) {
	volatile.StoreUint32(&o.TCMR.Reg, volatile.LoadUint32(&o.TCMR.Reg)&^(0x1c)|value<<2)
}
func (o *SSC_Type) GetTCMR_CKO() uint32 {
	return (volatile.LoadUint32(&o.TCMR.Reg) & 0x1c) >> 2
}
func (o *SSC_Type) SetTCMR_CKI(value uint32) {
	volatile.StoreUint32(&o.TCMR.Reg, volatile.LoadUint32(&o.TCMR.Reg)&^(0x20)|value<<5)
}
func (o *SSC_Type) GetTCMR_CKI() uint32 {
	return (volatile.LoadUint32(&o.TCMR.Reg) & 0x20) >> 5
}
func (o *SSC_Type) SetTCMR_CKG(value uint32) {
	volatile.StoreUint32(&o.TCMR.Reg, volatile.LoadUint32(&o.TCMR.Reg)&^(0xc0)|value<<6)
}
func (o *SSC_Type) GetTCMR_CKG() uint32 {
	return (volatile.LoadUint32(&o.TCMR.Reg) & 0xc0) >> 6
}
func (o *SSC_Type) SetTCMR_START(value uint32) {
	volatile.StoreUint32(&o.TCMR.Reg, volatile.LoadUint32(&o.TCMR.Reg)&^(0xf00)|value<<8)
}
func (o *SSC_Type) GetTCMR_START() uint32 {
	return (volatile.LoadUint32(&o.TCMR.Reg) & 0xf00) >> 8
}
func (o *SSC_Type) SetTCMR_STTDLY(value uint32) {
	volatile.StoreUint32(&o.TCMR.Reg, volatile.LoadUint32(&o.TCMR.Reg)&^(0xff0000)|value<<16)
}
func (o *SSC_Type) GetTCMR_STTDLY() uint32 {
	return (volatile.LoadUint32(&o.TCMR.Reg) & 0xff0000) >> 16
}
func (o *SSC_Type) SetTCMR_PERIOD(value uint32) {
	volatile.StoreUint32(&o.TCMR.Reg, volatile.LoadUint32(&o.TCMR.Reg)&^(0xff000000)|value<<24)
}
func (o *SSC_Type) GetTCMR_PERIOD() uint32 {
	return (volatile.LoadUint32(&o.TCMR.Reg) & 0xff000000) >> 24
}

// SSC.TFMR: Transmit Frame Mode Register
func (o *SSC_Type) SetTFMR_DATLEN(value uint32) {
	volatile.StoreUint32(&o.TFMR.Reg, volatile.LoadUint32(&o.TFMR.Reg)&^(0x1f)|value)
}
func (o *SSC_Type) GetTFMR_DATLEN() uint32 {
	return volatile.LoadUint32(&o.TFMR.Reg) & 0x1f
}
func (o *SSC_Type) SetTFMR_DATDEF(value uint32) {
	volatile.StoreUint32(&o.TFMR.Reg, volatile.LoadUint32(&o.TFMR.Reg)&^(0x20)|value<<5)
}
func (o *SSC_Type) GetTFMR_DATDEF() uint32 {
	return (volatile.LoadUint32(&o.TFMR.Reg) & 0x20) >> 5
}
func (o *SSC_Type) SetTFMR_MSBF(value uint32) {
	volatile.StoreUint32(&o.TFMR.Reg, volatile.LoadUint32(&o.TFMR.Reg)&^(0x80)|value<<7)
}
func (o *SSC_Type) GetTFMR_MSBF() uint32 {
	return (volatile.LoadUint32(&o.TFMR.Reg) & 0x80) >> 7
}
func (o *SSC_Type) SetTFMR_DATNB(value uint32) {
	volatile.StoreUint32(&o.TFMR.Reg, volatile.LoadUint32(&o.TFMR.Reg)&^(0xf00)|value<<8)
}
func (o *SSC_Type) GetTFMR_DATNB() uint32 {
	return (volatile.LoadUint32(&o.TFMR.Reg) & 0xf00) >> 8
}
func (o *SSC_Type) SetTFMR_FSLEN(value uint32) {
	volatile.StoreUint32(&o.TFMR.Reg, volatile.LoadUint32(&o.TFMR.Reg)&^(0xf0000)|value<<16)
}
func (o *SSC_Type) GetTFMR_FSLEN() uint32 {
	return (volatile.LoadUint32(&o.TFMR.Reg) & 0xf0000) >> 16
}
func (o *SSC_Type) SetTFMR_FSOS(value uint32) {
	volatile.StoreUint32(&o.TFMR.Reg, volatile.LoadUint32(&o.TFMR.Reg)&^(0x700000)|value<<20)
}
func (o *SSC_Type) GetTFMR_FSOS() uint32 {
	return (volatile.LoadUint32(&o.TFMR.Reg) & 0x700000) >> 20
}
func (o *SSC_Type) SetTFMR_FSDEN(value uint32) {
	volatile.StoreUint32(&o.TFMR.Reg, volatile.LoadUint32(&o.TFMR.Reg)&^(0x800000)|value<<23)
}
func (o *SSC_Type) GetTFMR_FSDEN() uint32 {
	return (volatile.LoadUint32(&o.TFMR.Reg) & 0x800000) >> 23
}
func (o *SSC_Type) SetTFMR_FSEDGE(value uint32) {
	volatile.StoreUint32(&o.TFMR.Reg, volatile.LoadUint32(&o.TFMR.Reg)&^(0x1000000)|value<<24)
}
func (o *SSC_Type) GetTFMR_FSEDGE() uint32 {
	return (volatile.LoadUint32(&o.TFMR.Reg) & 0x1000000) >> 24
}
func (o *SSC_Type) SetTFMR_FSLEN_EXT(value uint32) {
	volatile.StoreUint32(&o.TFMR.Reg, volatile.LoadUint32(&o.TFMR.Reg)&^(0xf0000000)|value<<28)
}
func (o *SSC_Type) GetTFMR_FSLEN_EXT() uint32 {
	return (volatile.LoadUint32(&o.TFMR.Reg) & 0xf0000000) >> 28
}

// SSC.RHR: Receive Holding Register
func (o *SSC_Type) SetRHR(value uint32) {
	volatile.StoreUint32(&o.RHR.Reg, value)
}
func (o *SSC_Type) GetRHR() uint32 {
	return volatile.LoadUint32(&o.RHR.Reg)
}

// SSC.THR: Transmit Holding Register
func (o *SSC_Type) SetTHR(value uint32) {
	volatile.StoreUint32(&o.THR.Reg, value)
}
func (o *SSC_Type) GetTHR() uint32 {
	return volatile.LoadUint32(&o.THR.Reg)
}

// SSC.RSHR: Receive Sync. Holding Register
func (o *SSC_Type) SetRSHR_RSDAT(value uint32) {
	volatile.StoreUint32(&o.RSHR.Reg, volatile.LoadUint32(&o.RSHR.Reg)&^(0xffff)|value)
}
func (o *SSC_Type) GetRSHR_RSDAT() uint32 {
	return volatile.LoadUint32(&o.RSHR.Reg) & 0xffff
}

// SSC.TSHR: Transmit Sync. Holding Register
func (o *SSC_Type) SetTSHR_TSDAT(value uint32) {
	volatile.StoreUint32(&o.TSHR.Reg, volatile.LoadUint32(&o.TSHR.Reg)&^(0xffff)|value)
}
func (o *SSC_Type) GetTSHR_TSDAT() uint32 {
	return volatile.LoadUint32(&o.TSHR.Reg) & 0xffff
}

// SSC.RC0R: Receive Compare 0 Register
func (o *SSC_Type) SetRC0R_CP0(value uint32) {
	volatile.StoreUint32(&o.RC0R.Reg, volatile.LoadUint32(&o.RC0R.Reg)&^(0xffff)|value)
}
func (o *SSC_Type) GetRC0R_CP0() uint32 {
	return volatile.LoadUint32(&o.RC0R.Reg) & 0xffff
}

// SSC.RC1R: Receive Compare 1 Register
func (o *SSC_Type) SetRC1R_CP1(value uint32) {
	volatile.StoreUint32(&o.RC1R.Reg, volatile.LoadUint32(&o.RC1R.Reg)&^(0xffff)|value)
}
func (o *SSC_Type) GetRC1R_CP1() uint32 {
	return volatile.LoadUint32(&o.RC1R.Reg) & 0xffff
}

// SSC.SR: Status Register
func (o *SSC_Type) SetSR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *SSC_Type) GetSR_TXRDY() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *SSC_Type) SetSR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *SSC_Type) GetSR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *SSC_Type) SetSR_ENDTX(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *SSC_Type) GetSR_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *SSC_Type) SetSR_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *SSC_Type) GetSR_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *SSC_Type) SetSR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *SSC_Type) GetSR_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *SSC_Type) SetSR_OVRUN(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *SSC_Type) GetSR_OVRUN() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *SSC_Type) SetSR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *SSC_Type) GetSR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *SSC_Type) SetSR_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80)|value<<7)
}
func (o *SSC_Type) GetSR_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80) >> 7
}
func (o *SSC_Type) SetSR_CP0(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100)|value<<8)
}
func (o *SSC_Type) GetSR_CP0() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100) >> 8
}
func (o *SSC_Type) SetSR_CP1(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x200)|value<<9)
}
func (o *SSC_Type) GetSR_CP1() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x200) >> 9
}
func (o *SSC_Type) SetSR_TXSYN(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x400)|value<<10)
}
func (o *SSC_Type) GetSR_TXSYN() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x400) >> 10
}
func (o *SSC_Type) SetSR_RXSYN(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x800)|value<<11)
}
func (o *SSC_Type) GetSR_RXSYN() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x800) >> 11
}
func (o *SSC_Type) SetSR_TXEN(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10000)|value<<16)
}
func (o *SSC_Type) GetSR_TXEN() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10000) >> 16
}
func (o *SSC_Type) SetSR_RXEN(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20000)|value<<17)
}
func (o *SSC_Type) GetSR_RXEN() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20000) >> 17
}

// SSC.IER: Interrupt Enable Register
func (o *SSC_Type) SetIER_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *SSC_Type) GetIER_TXRDY() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *SSC_Type) SetIER_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *SSC_Type) GetIER_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *SSC_Type) SetIER_ENDTX(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *SSC_Type) GetIER_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *SSC_Type) SetIER_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *SSC_Type) GetIER_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *SSC_Type) SetIER_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *SSC_Type) GetIER_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *SSC_Type) SetIER_OVRUN(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *SSC_Type) GetIER_OVRUN() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *SSC_Type) SetIER_ENDRX(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40)|value<<6)
}
func (o *SSC_Type) GetIER_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40) >> 6
}
func (o *SSC_Type) SetIER_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80)|value<<7)
}
func (o *SSC_Type) GetIER_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80) >> 7
}
func (o *SSC_Type) SetIER_CP0(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100)|value<<8)
}
func (o *SSC_Type) GetIER_CP0() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100) >> 8
}
func (o *SSC_Type) SetIER_CP1(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200)|value<<9)
}
func (o *SSC_Type) GetIER_CP1() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200) >> 9
}
func (o *SSC_Type) SetIER_TXSYN(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400)|value<<10)
}
func (o *SSC_Type) GetIER_TXSYN() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400) >> 10
}
func (o *SSC_Type) SetIER_RXSYN(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x800)|value<<11)
}
func (o *SSC_Type) GetIER_RXSYN() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x800) >> 11
}

// SSC.IDR: Interrupt Disable Register
func (o *SSC_Type) SetIDR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *SSC_Type) GetIDR_TXRDY() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *SSC_Type) SetIDR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *SSC_Type) GetIDR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *SSC_Type) SetIDR_ENDTX(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4)|value<<2)
}
func (o *SSC_Type) GetIDR_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4) >> 2
}
func (o *SSC_Type) SetIDR_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8)|value<<3)
}
func (o *SSC_Type) GetIDR_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8) >> 3
}
func (o *SSC_Type) SetIDR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10)|value<<4)
}
func (o *SSC_Type) GetIDR_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10) >> 4
}
func (o *SSC_Type) SetIDR_OVRUN(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20)|value<<5)
}
func (o *SSC_Type) GetIDR_OVRUN() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20) >> 5
}
func (o *SSC_Type) SetIDR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40)|value<<6)
}
func (o *SSC_Type) GetIDR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40) >> 6
}
func (o *SSC_Type) SetIDR_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80)|value<<7)
}
func (o *SSC_Type) GetIDR_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80) >> 7
}
func (o *SSC_Type) SetIDR_CP0(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100)|value<<8)
}
func (o *SSC_Type) GetIDR_CP0() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100) >> 8
}
func (o *SSC_Type) SetIDR_CP1(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200)|value<<9)
}
func (o *SSC_Type) GetIDR_CP1() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200) >> 9
}
func (o *SSC_Type) SetIDR_TXSYN(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400)|value<<10)
}
func (o *SSC_Type) GetIDR_TXSYN() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400) >> 10
}
func (o *SSC_Type) SetIDR_RXSYN(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x800)|value<<11)
}
func (o *SSC_Type) GetIDR_RXSYN() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x800) >> 11
}

// SSC.IMR: Interrupt Mask Register
func (o *SSC_Type) SetIMR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *SSC_Type) GetIMR_TXRDY() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *SSC_Type) SetIMR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *SSC_Type) GetIMR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *SSC_Type) SetIMR_ENDTX(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4)|value<<2)
}
func (o *SSC_Type) GetIMR_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4) >> 2
}
func (o *SSC_Type) SetIMR_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8)|value<<3)
}
func (o *SSC_Type) GetIMR_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8) >> 3
}
func (o *SSC_Type) SetIMR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10)|value<<4)
}
func (o *SSC_Type) GetIMR_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10) >> 4
}
func (o *SSC_Type) SetIMR_OVRUN(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20)|value<<5)
}
func (o *SSC_Type) GetIMR_OVRUN() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20) >> 5
}
func (o *SSC_Type) SetIMR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40)|value<<6)
}
func (o *SSC_Type) GetIMR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40) >> 6
}
func (o *SSC_Type) SetIMR_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80)|value<<7)
}
func (o *SSC_Type) GetIMR_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80) >> 7
}
func (o *SSC_Type) SetIMR_CP0(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100)|value<<8)
}
func (o *SSC_Type) GetIMR_CP0() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100) >> 8
}
func (o *SSC_Type) SetIMR_CP1(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200)|value<<9)
}
func (o *SSC_Type) GetIMR_CP1() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200) >> 9
}
func (o *SSC_Type) SetIMR_TXSYN(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400)|value<<10)
}
func (o *SSC_Type) GetIMR_TXSYN() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400) >> 10
}
func (o *SSC_Type) SetIMR_RXSYN(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x800)|value<<11)
}
func (o *SSC_Type) GetIMR_RXSYN() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x800) >> 11
}

// SSC.WPMR: Write Protection Mode Register
func (o *SSC_Type) SetWPMR_WPEN(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0x1)|value)
}
func (o *SSC_Type) GetWPMR_WPEN() uint32 {
	return volatile.LoadUint32(&o.WPMR.Reg) & 0x1
}
func (o *SSC_Type) SetWPMR_WPKEY(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0xffffff00)|value<<8)
}
func (o *SSC_Type) GetWPMR_WPKEY() uint32 {
	return (volatile.LoadUint32(&o.WPMR.Reg) & 0xffffff00) >> 8
}

// SSC.WPSR: Write Protection Status Register
func (o *SSC_Type) SetWPSR_WPVS(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x1)|value)
}
func (o *SSC_Type) GetWPSR_WPVS() uint32 {
	return volatile.LoadUint32(&o.WPSR.Reg) & 0x1
}
func (o *SSC_Type) SetWPSR_WPVSRC(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0xffff00)|value<<8)
}
func (o *SSC_Type) GetWPSR_WPVSRC() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0xffff00) >> 8
}

// SSC.RPR: Receive Pointer Register
func (o *SSC_Type) SetRPR(value uint32) {
	volatile.StoreUint32(&o.RPR.Reg, value)
}
func (o *SSC_Type) GetRPR() uint32 {
	return volatile.LoadUint32(&o.RPR.Reg)
}

// SSC.RCR: Receive Counter Register
func (o *SSC_Type) SetRCR_RXCTR(value uint32) {
	volatile.StoreUint32(&o.RCR.Reg, volatile.LoadUint32(&o.RCR.Reg)&^(0xffff)|value)
}
func (o *SSC_Type) GetRCR_RXCTR() uint32 {
	return volatile.LoadUint32(&o.RCR.Reg) & 0xffff
}

// SSC.TPR: Transmit Pointer Register
func (o *SSC_Type) SetTPR(value uint32) {
	volatile.StoreUint32(&o.TPR.Reg, value)
}
func (o *SSC_Type) GetTPR() uint32 {
	return volatile.LoadUint32(&o.TPR.Reg)
}

// SSC.TCR: Transmit Counter Register
func (o *SSC_Type) SetTCR_TXCTR(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0xffff)|value)
}
func (o *SSC_Type) GetTCR_TXCTR() uint32 {
	return volatile.LoadUint32(&o.TCR.Reg) & 0xffff
}

// SSC.RNPR: Receive Next Pointer Register
func (o *SSC_Type) SetRNPR(value uint32) {
	volatile.StoreUint32(&o.RNPR.Reg, value)
}
func (o *SSC_Type) GetRNPR() uint32 {
	return volatile.LoadUint32(&o.RNPR.Reg)
}

// SSC.RNCR: Receive Next Counter Register
func (o *SSC_Type) SetRNCR_RXNCTR(value uint32) {
	volatile.StoreUint32(&o.RNCR.Reg, volatile.LoadUint32(&o.RNCR.Reg)&^(0xffff)|value)
}
func (o *SSC_Type) GetRNCR_RXNCTR() uint32 {
	return volatile.LoadUint32(&o.RNCR.Reg) & 0xffff
}

// SSC.TNPR: Transmit Next Pointer Register
func (o *SSC_Type) SetTNPR(value uint32) {
	volatile.StoreUint32(&o.TNPR.Reg, value)
}
func (o *SSC_Type) GetTNPR() uint32 {
	return volatile.LoadUint32(&o.TNPR.Reg)
}

// SSC.TNCR: Transmit Next Counter Register
func (o *SSC_Type) SetTNCR_TXNCTR(value uint32) {
	volatile.StoreUint32(&o.TNCR.Reg, volatile.LoadUint32(&o.TNCR.Reg)&^(0xffff)|value)
}
func (o *SSC_Type) GetTNCR_TXNCTR() uint32 {
	return volatile.LoadUint32(&o.TNCR.Reg) & 0xffff
}

// SSC.PTCR: Transfer Control Register
func (o *SSC_Type) SetPTCR_RXTEN(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x1)|value)
}
func (o *SSC_Type) GetPTCR_RXTEN() uint32 {
	return volatile.LoadUint32(&o.PTCR.Reg) & 0x1
}
func (o *SSC_Type) SetPTCR_RXTDIS(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x2)|value<<1)
}
func (o *SSC_Type) GetPTCR_RXTDIS() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x2) >> 1
}
func (o *SSC_Type) SetPTCR_TXTEN(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x100)|value<<8)
}
func (o *SSC_Type) GetPTCR_TXTEN() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x100) >> 8
}
func (o *SSC_Type) SetPTCR_TXTDIS(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x200)|value<<9)
}
func (o *SSC_Type) GetPTCR_TXTDIS() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x200) >> 9
}

// SSC.PTSR: Transfer Status Register
func (o *SSC_Type) SetPTSR_RXTEN(value uint32) {
	volatile.StoreUint32(&o.PTSR.Reg, volatile.LoadUint32(&o.PTSR.Reg)&^(0x1)|value)
}
func (o *SSC_Type) GetPTSR_RXTEN() uint32 {
	return volatile.LoadUint32(&o.PTSR.Reg) & 0x1
}
func (o *SSC_Type) SetPTSR_TXTEN(value uint32) {
	volatile.StoreUint32(&o.PTSR.Reg, volatile.LoadUint32(&o.PTSR.Reg)&^(0x100)|value<<8)
}
func (o *SSC_Type) GetPTSR_TXTEN() uint32 {
	return (volatile.LoadUint32(&o.PTSR.Reg) & 0x100) >> 8
}

// Serial Peripheral Interface
type SPI_Type struct {
	CR   volatile.Register32 // 0x0
	MR   volatile.Register32 // 0x4
	RDR  volatile.Register32 // 0x8
	TDR  volatile.Register32 // 0xC
	SR   volatile.Register32 // 0x10
	IER  volatile.Register32 // 0x14
	IDR  volatile.Register32 // 0x18
	IMR  volatile.Register32 // 0x1C
	_    [16]byte
	CSR  [4]volatile.Register32 // 0x30
	_    [164]byte
	WPMR volatile.Register32 // 0xE4
	WPSR volatile.Register32 // 0xE8
	_    [20]byte
	RPR  volatile.Register32 // 0x100
	RCR  volatile.Register32 // 0x104
	TPR  volatile.Register32 // 0x108
	TCR  volatile.Register32 // 0x10C
	RNPR volatile.Register32 // 0x110
	RNCR volatile.Register32 // 0x114
	TNPR volatile.Register32 // 0x118
	TNCR volatile.Register32 // 0x11C
	PTCR volatile.Register32 // 0x120
	PTSR volatile.Register32 // 0x124
}

// SPI.CR: Control Register
func (o *SPI_Type) SetCR_SPIEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetCR_SPIEN() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *SPI_Type) SetCR_SPIDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetCR_SPIDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetCR_SWRST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *SPI_Type) GetCR_SWRST() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *SPI_Type) SetCR_LASTXFER(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000000)|value<<24)
}
func (o *SPI_Type) GetCR_LASTXFER() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000000) >> 24
}

// SPI.MR: Mode Register
func (o *SPI_Type) SetMR_MSTR(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetMR_MSTR() uint32 {
	return volatile.LoadUint32(&o.MR.Reg) & 0x1
}
func (o *SPI_Type) SetMR_PS(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetMR_PS() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetMR_PCSDEC(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x4)|value<<2)
}
func (o *SPI_Type) GetMR_PCSDEC() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x4) >> 2
}
func (o *SPI_Type) SetMR_MODFDIS(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x10)|value<<4)
}
func (o *SPI_Type) GetMR_MODFDIS() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x10) >> 4
}
func (o *SPI_Type) SetMR_WDRBT(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x20)|value<<5)
}
func (o *SPI_Type) GetMR_WDRBT() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x20) >> 5
}
func (o *SPI_Type) SetMR_LLB(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x80)|value<<7)
}
func (o *SPI_Type) GetMR_LLB() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x80) >> 7
}
func (o *SPI_Type) SetMR_PCS(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xf0000)|value<<16)
}
func (o *SPI_Type) GetMR_PCS() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xf0000) >> 16
}
func (o *SPI_Type) SetMR_DLYBCS(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xff000000)|value<<24)
}
func (o *SPI_Type) GetMR_DLYBCS() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xff000000) >> 24
}

// SPI.RDR: Receive Data Register
func (o *SPI_Type) SetRDR_RD(value uint32) {
	volatile.StoreUint32(&o.RDR.Reg, volatile.LoadUint32(&o.RDR.Reg)&^(0xffff)|value)
}
func (o *SPI_Type) GetRDR_RD() uint32 {
	return volatile.LoadUint32(&o.RDR.Reg) & 0xffff
}
func (o *SPI_Type) SetRDR_PCS(value uint32) {
	volatile.StoreUint32(&o.RDR.Reg, volatile.LoadUint32(&o.RDR.Reg)&^(0xf0000)|value<<16)
}
func (o *SPI_Type) GetRDR_PCS() uint32 {
	return (volatile.LoadUint32(&o.RDR.Reg) & 0xf0000) >> 16
}

// SPI.TDR: Transmit Data Register
func (o *SPI_Type) SetTDR_TD(value uint32) {
	volatile.StoreUint32(&o.TDR.Reg, volatile.LoadUint32(&o.TDR.Reg)&^(0xffff)|value)
}
func (o *SPI_Type) GetTDR_TD() uint32 {
	return volatile.LoadUint32(&o.TDR.Reg) & 0xffff
}
func (o *SPI_Type) SetTDR_PCS(value uint32) {
	volatile.StoreUint32(&o.TDR.Reg, volatile.LoadUint32(&o.TDR.Reg)&^(0xf0000)|value<<16)
}
func (o *SPI_Type) GetTDR_PCS() uint32 {
	return (volatile.LoadUint32(&o.TDR.Reg) & 0xf0000) >> 16
}
func (o *SPI_Type) SetTDR_LASTXFER(value uint32) {
	volatile.StoreUint32(&o.TDR.Reg, volatile.LoadUint32(&o.TDR.Reg)&^(0x1000000)|value<<24)
}
func (o *SPI_Type) GetTDR_LASTXFER() uint32 {
	return (volatile.LoadUint32(&o.TDR.Reg) & 0x1000000) >> 24
}

// SPI.SR: Status Register
func (o *SPI_Type) SetSR_RDRF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetSR_RDRF() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *SPI_Type) SetSR_TDRE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetSR_TDRE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetSR_MODF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *SPI_Type) GetSR_MODF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *SPI_Type) SetSR_OVRES(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *SPI_Type) GetSR_OVRES() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *SPI_Type) SetSR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *SPI_Type) GetSR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *SPI_Type) SetSR_ENDTX(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *SPI_Type) GetSR_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *SPI_Type) SetSR_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *SPI_Type) GetSR_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *SPI_Type) SetSR_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80)|value<<7)
}
func (o *SPI_Type) GetSR_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80) >> 7
}
func (o *SPI_Type) SetSR_NSSR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100)|value<<8)
}
func (o *SPI_Type) GetSR_NSSR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100) >> 8
}
func (o *SPI_Type) SetSR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x200)|value<<9)
}
func (o *SPI_Type) GetSR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x200) >> 9
}
func (o *SPI_Type) SetSR_UNDES(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x400)|value<<10)
}
func (o *SPI_Type) GetSR_UNDES() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x400) >> 10
}
func (o *SPI_Type) SetSR_SPIENS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10000)|value<<16)
}
func (o *SPI_Type) GetSR_SPIENS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10000) >> 16
}

// SPI.IER: Interrupt Enable Register
func (o *SPI_Type) SetIER_RDRF(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetIER_RDRF() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *SPI_Type) SetIER_TDRE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetIER_TDRE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetIER_MODF(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *SPI_Type) GetIER_MODF() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *SPI_Type) SetIER_OVRES(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *SPI_Type) GetIER_OVRES() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *SPI_Type) SetIER_ENDRX(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *SPI_Type) GetIER_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *SPI_Type) SetIER_ENDTX(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *SPI_Type) GetIER_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *SPI_Type) SetIER_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40)|value<<6)
}
func (o *SPI_Type) GetIER_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40) >> 6
}
func (o *SPI_Type) SetIER_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80)|value<<7)
}
func (o *SPI_Type) GetIER_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80) >> 7
}
func (o *SPI_Type) SetIER_NSSR(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100)|value<<8)
}
func (o *SPI_Type) GetIER_NSSR() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100) >> 8
}
func (o *SPI_Type) SetIER_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200)|value<<9)
}
func (o *SPI_Type) GetIER_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200) >> 9
}
func (o *SPI_Type) SetIER_UNDES(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400)|value<<10)
}
func (o *SPI_Type) GetIER_UNDES() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400) >> 10
}

// SPI.IDR: Interrupt Disable Register
func (o *SPI_Type) SetIDR_RDRF(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetIDR_RDRF() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *SPI_Type) SetIDR_TDRE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetIDR_TDRE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetIDR_MODF(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4)|value<<2)
}
func (o *SPI_Type) GetIDR_MODF() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4) >> 2
}
func (o *SPI_Type) SetIDR_OVRES(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8)|value<<3)
}
func (o *SPI_Type) GetIDR_OVRES() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8) >> 3
}
func (o *SPI_Type) SetIDR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10)|value<<4)
}
func (o *SPI_Type) GetIDR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10) >> 4
}
func (o *SPI_Type) SetIDR_ENDTX(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20)|value<<5)
}
func (o *SPI_Type) GetIDR_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20) >> 5
}
func (o *SPI_Type) SetIDR_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40)|value<<6)
}
func (o *SPI_Type) GetIDR_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40) >> 6
}
func (o *SPI_Type) SetIDR_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80)|value<<7)
}
func (o *SPI_Type) GetIDR_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80) >> 7
}
func (o *SPI_Type) SetIDR_NSSR(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100)|value<<8)
}
func (o *SPI_Type) GetIDR_NSSR() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100) >> 8
}
func (o *SPI_Type) SetIDR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200)|value<<9)
}
func (o *SPI_Type) GetIDR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200) >> 9
}
func (o *SPI_Type) SetIDR_UNDES(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400)|value<<10)
}
func (o *SPI_Type) GetIDR_UNDES() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400) >> 10
}

// SPI.IMR: Interrupt Mask Register
func (o *SPI_Type) SetIMR_RDRF(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetIMR_RDRF() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *SPI_Type) SetIMR_TDRE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetIMR_TDRE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetIMR_MODF(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4)|value<<2)
}
func (o *SPI_Type) GetIMR_MODF() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4) >> 2
}
func (o *SPI_Type) SetIMR_OVRES(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8)|value<<3)
}
func (o *SPI_Type) GetIMR_OVRES() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8) >> 3
}
func (o *SPI_Type) SetIMR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10)|value<<4)
}
func (o *SPI_Type) GetIMR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10) >> 4
}
func (o *SPI_Type) SetIMR_ENDTX(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20)|value<<5)
}
func (o *SPI_Type) GetIMR_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20) >> 5
}
func (o *SPI_Type) SetIMR_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40)|value<<6)
}
func (o *SPI_Type) GetIMR_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40) >> 6
}
func (o *SPI_Type) SetIMR_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80)|value<<7)
}
func (o *SPI_Type) GetIMR_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80) >> 7
}
func (o *SPI_Type) SetIMR_NSSR(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100)|value<<8)
}
func (o *SPI_Type) GetIMR_NSSR() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100) >> 8
}
func (o *SPI_Type) SetIMR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200)|value<<9)
}
func (o *SPI_Type) GetIMR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200) >> 9
}
func (o *SPI_Type) SetIMR_UNDES(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400)|value<<10)
}
func (o *SPI_Type) GetIMR_UNDES() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400) >> 10
}

// SPI.CSR: Chip Select Register
func (o *SPI_Type) SetCSR_CPOL(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetCSR_CPOL(idx int) uint32 {
	return volatile.LoadUint32(&o.CSR[idx].Reg) & 0x1
}
func (o *SPI_Type) SetCSR_NCPHA(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetCSR_NCPHA(idx int) uint32 {
	return (volatile.LoadUint32(&o.CSR[idx].Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetCSR_CSNAAT(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0x4)|value<<2)
}
func (o *SPI_Type) GetCSR_CSNAAT(idx int) uint32 {
	return (volatile.LoadUint32(&o.CSR[idx].Reg) & 0x4) >> 2
}
func (o *SPI_Type) SetCSR_CSAAT(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0x8)|value<<3)
}
func (o *SPI_Type) GetCSR_CSAAT(idx int) uint32 {
	return (volatile.LoadUint32(&o.CSR[idx].Reg) & 0x8) >> 3
}
func (o *SPI_Type) SetCSR_BITS(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0xf0)|value<<4)
}
func (o *SPI_Type) GetCSR_BITS(idx int) uint32 {
	return (volatile.LoadUint32(&o.CSR[idx].Reg) & 0xf0) >> 4
}
func (o *SPI_Type) SetCSR_SCBR(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0xff00)|value<<8)
}
func (o *SPI_Type) GetCSR_SCBR(idx int) uint32 {
	return (volatile.LoadUint32(&o.CSR[idx].Reg) & 0xff00) >> 8
}
func (o *SPI_Type) SetCSR_DLYBS(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0xff0000)|value<<16)
}
func (o *SPI_Type) GetCSR_DLYBS(idx int) uint32 {
	return (volatile.LoadUint32(&o.CSR[idx].Reg) & 0xff0000) >> 16
}
func (o *SPI_Type) SetCSR_DLYBCT(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0xff000000)|value<<24)
}
func (o *SPI_Type) GetCSR_DLYBCT(idx int) uint32 {
	return (volatile.LoadUint32(&o.CSR[idx].Reg) & 0xff000000) >> 24
}

// SPI.WPMR: Write Protection Mode Register
func (o *SPI_Type) SetWPMR_WPEN(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetWPMR_WPEN() uint32 {
	return volatile.LoadUint32(&o.WPMR.Reg) & 0x1
}
func (o *SPI_Type) SetWPMR_WPKEY(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0xffffff00)|value<<8)
}
func (o *SPI_Type) GetWPMR_WPKEY() uint32 {
	return (volatile.LoadUint32(&o.WPMR.Reg) & 0xffffff00) >> 8
}

// SPI.WPSR: Write Protection Status Register
func (o *SPI_Type) SetWPSR_WPVS(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetWPSR_WPVS() uint32 {
	return volatile.LoadUint32(&o.WPSR.Reg) & 0x1
}
func (o *SPI_Type) SetWPSR_WPVSRC(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0xff00)|value<<8)
}
func (o *SPI_Type) GetWPSR_WPVSRC() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0xff00) >> 8
}

// SPI.RPR: Receive Pointer Register
func (o *SPI_Type) SetRPR(value uint32) {
	volatile.StoreUint32(&o.RPR.Reg, value)
}
func (o *SPI_Type) GetRPR() uint32 {
	return volatile.LoadUint32(&o.RPR.Reg)
}

// SPI.RCR: Receive Counter Register
func (o *SPI_Type) SetRCR_RXCTR(value uint32) {
	volatile.StoreUint32(&o.RCR.Reg, volatile.LoadUint32(&o.RCR.Reg)&^(0xffff)|value)
}
func (o *SPI_Type) GetRCR_RXCTR() uint32 {
	return volatile.LoadUint32(&o.RCR.Reg) & 0xffff
}

// SPI.TPR: Transmit Pointer Register
func (o *SPI_Type) SetTPR(value uint32) {
	volatile.StoreUint32(&o.TPR.Reg, value)
}
func (o *SPI_Type) GetTPR() uint32 {
	return volatile.LoadUint32(&o.TPR.Reg)
}

// SPI.TCR: Transmit Counter Register
func (o *SPI_Type) SetTCR_TXCTR(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0xffff)|value)
}
func (o *SPI_Type) GetTCR_TXCTR() uint32 {
	return volatile.LoadUint32(&o.TCR.Reg) & 0xffff
}

// SPI.RNPR: Receive Next Pointer Register
func (o *SPI_Type) SetRNPR(value uint32) {
	volatile.StoreUint32(&o.RNPR.Reg, value)
}
func (o *SPI_Type) GetRNPR() uint32 {
	return volatile.LoadUint32(&o.RNPR.Reg)
}

// SPI.RNCR: Receive Next Counter Register
func (o *SPI_Type) SetRNCR_RXNCTR(value uint32) {
	volatile.StoreUint32(&o.RNCR.Reg, volatile.LoadUint32(&o.RNCR.Reg)&^(0xffff)|value)
}
func (o *SPI_Type) GetRNCR_RXNCTR() uint32 {
	return volatile.LoadUint32(&o.RNCR.Reg) & 0xffff
}

// SPI.TNPR: Transmit Next Pointer Register
func (o *SPI_Type) SetTNPR(value uint32) {
	volatile.StoreUint32(&o.TNPR.Reg, value)
}
func (o *SPI_Type) GetTNPR() uint32 {
	return volatile.LoadUint32(&o.TNPR.Reg)
}

// SPI.TNCR: Transmit Next Counter Register
func (o *SPI_Type) SetTNCR_TXNCTR(value uint32) {
	volatile.StoreUint32(&o.TNCR.Reg, volatile.LoadUint32(&o.TNCR.Reg)&^(0xffff)|value)
}
func (o *SPI_Type) GetTNCR_TXNCTR() uint32 {
	return volatile.LoadUint32(&o.TNCR.Reg) & 0xffff
}

// SPI.PTCR: Transfer Control Register
func (o *SPI_Type) SetPTCR_RXTEN(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetPTCR_RXTEN() uint32 {
	return volatile.LoadUint32(&o.PTCR.Reg) & 0x1
}
func (o *SPI_Type) SetPTCR_RXTDIS(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetPTCR_RXTDIS() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetPTCR_TXTEN(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x100)|value<<8)
}
func (o *SPI_Type) GetPTCR_TXTEN() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x100) >> 8
}
func (o *SPI_Type) SetPTCR_TXTDIS(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x200)|value<<9)
}
func (o *SPI_Type) GetPTCR_TXTDIS() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x200) >> 9
}

// SPI.PTSR: Transfer Status Register
func (o *SPI_Type) SetPTSR_RXTEN(value uint32) {
	volatile.StoreUint32(&o.PTSR.Reg, volatile.LoadUint32(&o.PTSR.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetPTSR_RXTEN() uint32 {
	return volatile.LoadUint32(&o.PTSR.Reg) & 0x1
}
func (o *SPI_Type) SetPTSR_TXTEN(value uint32) {
	volatile.StoreUint32(&o.PTSR.Reg, volatile.LoadUint32(&o.PTSR.Reg)&^(0x100)|value<<8)
}
func (o *SPI_Type) GetPTSR_TXTEN() uint32 {
	return (volatile.LoadUint32(&o.PTSR.Reg) & 0x100) >> 8
}

// Timer Counter 0
type TC_Type struct {
	CCR0  volatile.Register32 // 0x0
	CMR0  volatile.Register32 // 0x4
	SMMR0 volatile.Register32 // 0x8
	_     [4]byte
	CV0   volatile.Register32 // 0x10
	RA0   volatile.Register32 // 0x14
	RB0   volatile.Register32 // 0x18
	RC0   volatile.Register32 // 0x1C
	SR0   volatile.Register32 // 0x20
	IER0  volatile.Register32 // 0x24
	IDR0  volatile.Register32 // 0x28
	IMR0  volatile.Register32 // 0x2C
	_     [16]byte
	CCR1  volatile.Register32 // 0x40
	CMR1  volatile.Register32 // 0x44
	SMMR1 volatile.Register32 // 0x48
	_     [4]byte
	CV1   volatile.Register32 // 0x50
	RA1   volatile.Register32 // 0x54
	RB1   volatile.Register32 // 0x58
	RC1   volatile.Register32 // 0x5C
	SR1   volatile.Register32 // 0x60
	IER1  volatile.Register32 // 0x64
	IDR1  volatile.Register32 // 0x68
	IMR1  volatile.Register32 // 0x6C
	_     [16]byte
	CCR2  volatile.Register32 // 0x80
	CMR2  volatile.Register32 // 0x84
	SMMR2 volatile.Register32 // 0x88
	_     [4]byte
	CV2   volatile.Register32 // 0x90
	RA2   volatile.Register32 // 0x94
	RB2   volatile.Register32 // 0x98
	RC2   volatile.Register32 // 0x9C
	SR2   volatile.Register32 // 0xA0
	IER2  volatile.Register32 // 0xA4
	IDR2  volatile.Register32 // 0xA8
	IMR2  volatile.Register32 // 0xAC
	_     [16]byte
	BCR   volatile.Register32 // 0xC0
	BMR   volatile.Register32 // 0xC4
	QIER  volatile.Register32 // 0xC8
	QIDR  volatile.Register32 // 0xCC
	QIMR  volatile.Register32 // 0xD0
	QISR  volatile.Register32 // 0xD4
	FMR   volatile.Register32 // 0xD8
	_     [8]byte
	WPMR  volatile.Register32 // 0xE4
}

// TC.CCR0: Channel Control Register (channel = 0)
func (o *TC_Type) SetCCR0_CLKEN(value uint32) {
	volatile.StoreUint32(&o.CCR0.Reg, volatile.LoadUint32(&o.CCR0.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetCCR0_CLKEN() uint32 {
	return volatile.LoadUint32(&o.CCR0.Reg) & 0x1
}
func (o *TC_Type) SetCCR0_CLKDIS(value uint32) {
	volatile.StoreUint32(&o.CCR0.Reg, volatile.LoadUint32(&o.CCR0.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetCCR0_CLKDIS() uint32 {
	return (volatile.LoadUint32(&o.CCR0.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetCCR0_SWTRG(value uint32) {
	volatile.StoreUint32(&o.CCR0.Reg, volatile.LoadUint32(&o.CCR0.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetCCR0_SWTRG() uint32 {
	return (volatile.LoadUint32(&o.CCR0.Reg) & 0x4) >> 2
}

// TC.CMR0: Channel Mode Register (channel = 0)
func (o *TC_Type) SetCMR0_TCCLKS(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x7)|value)
}
func (o *TC_Type) GetCMR0_TCCLKS() uint32 {
	return volatile.LoadUint32(&o.CMR0.Reg) & 0x7
}
func (o *TC_Type) SetCMR0_CLKI(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetCMR0_CLKI() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetCMR0_BURST(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x30)|value<<4)
}
func (o *TC_Type) GetCMR0_BURST() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x30) >> 4
}
func (o *TC_Type) SetCMR0_LDBSTOP(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetCMR0_LDBSTOP() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetCMR0_LDBDIS(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetCMR0_LDBDIS() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x80) >> 7
}
func (o *TC_Type) SetCMR0_ETRGEDG(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x300)|value<<8)
}
func (o *TC_Type) GetCMR0_ETRGEDG() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x300) >> 8
}
func (o *TC_Type) SetCMR0_ABETRG(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x400)|value<<10)
}
func (o *TC_Type) GetCMR0_ABETRG() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x400) >> 10
}
func (o *TC_Type) SetCMR0_CPCTRG(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x4000)|value<<14)
}
func (o *TC_Type) GetCMR0_CPCTRG() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x4000) >> 14
}
func (o *TC_Type) SetCMR0_WAVE(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x8000)|value<<15)
}
func (o *TC_Type) GetCMR0_WAVE() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x8000) >> 15
}
func (o *TC_Type) SetCMR0_LDRA(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x30000)|value<<16)
}
func (o *TC_Type) GetCMR0_LDRA() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x30000) >> 16
}
func (o *TC_Type) SetCMR0_LDRB(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0xc0000)|value<<18)
}
func (o *TC_Type) GetCMR0_LDRB() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0xc0000) >> 18
}

// TC.SMMR0: Stepper Motor Mode Register (channel = 0)
func (o *TC_Type) SetSMMR0_GCEN(value uint32) {
	volatile.StoreUint32(&o.SMMR0.Reg, volatile.LoadUint32(&o.SMMR0.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetSMMR0_GCEN() uint32 {
	return volatile.LoadUint32(&o.SMMR0.Reg) & 0x1
}
func (o *TC_Type) SetSMMR0_DOWN(value uint32) {
	volatile.StoreUint32(&o.SMMR0.Reg, volatile.LoadUint32(&o.SMMR0.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetSMMR0_DOWN() uint32 {
	return (volatile.LoadUint32(&o.SMMR0.Reg) & 0x2) >> 1
}

// TC.CV0: Counter Value (channel = 0)
func (o *TC_Type) SetCV0(value uint32) {
	volatile.StoreUint32(&o.CV0.Reg, value)
}
func (o *TC_Type) GetCV0() uint32 {
	return volatile.LoadUint32(&o.CV0.Reg)
}

// TC.RA0: Register A (channel = 0)
func (o *TC_Type) SetRA0(value uint32) {
	volatile.StoreUint32(&o.RA0.Reg, value)
}
func (o *TC_Type) GetRA0() uint32 {
	return volatile.LoadUint32(&o.RA0.Reg)
}

// TC.RB0: Register B (channel = 0)
func (o *TC_Type) SetRB0(value uint32) {
	volatile.StoreUint32(&o.RB0.Reg, value)
}
func (o *TC_Type) GetRB0() uint32 {
	return volatile.LoadUint32(&o.RB0.Reg)
}

// TC.RC0: Register C (channel = 0)
func (o *TC_Type) SetRC0(value uint32) {
	volatile.StoreUint32(&o.RC0.Reg, value)
}
func (o *TC_Type) GetRC0() uint32 {
	return volatile.LoadUint32(&o.RC0.Reg)
}

// TC.SR0: Status Register (channel = 0)
func (o *TC_Type) SetSR0_COVFS(value uint32) {
	volatile.StoreUint32(&o.SR0.Reg, volatile.LoadUint32(&o.SR0.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetSR0_COVFS() uint32 {
	return volatile.LoadUint32(&o.SR0.Reg) & 0x1
}
func (o *TC_Type) SetSR0_LOVRS(value uint32) {
	volatile.StoreUint32(&o.SR0.Reg, volatile.LoadUint32(&o.SR0.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetSR0_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.SR0.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetSR0_CPAS(value uint32) {
	volatile.StoreUint32(&o.SR0.Reg, volatile.LoadUint32(&o.SR0.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetSR0_CPAS() uint32 {
	return (volatile.LoadUint32(&o.SR0.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetSR0_CPBS(value uint32) {
	volatile.StoreUint32(&o.SR0.Reg, volatile.LoadUint32(&o.SR0.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetSR0_CPBS() uint32 {
	return (volatile.LoadUint32(&o.SR0.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetSR0_CPCS(value uint32) {
	volatile.StoreUint32(&o.SR0.Reg, volatile.LoadUint32(&o.SR0.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetSR0_CPCS() uint32 {
	return (volatile.LoadUint32(&o.SR0.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetSR0_LDRAS(value uint32) {
	volatile.StoreUint32(&o.SR0.Reg, volatile.LoadUint32(&o.SR0.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetSR0_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.SR0.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetSR0_LDRBS(value uint32) {
	volatile.StoreUint32(&o.SR0.Reg, volatile.LoadUint32(&o.SR0.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetSR0_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.SR0.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetSR0_ETRGS(value uint32) {
	volatile.StoreUint32(&o.SR0.Reg, volatile.LoadUint32(&o.SR0.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetSR0_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.SR0.Reg) & 0x80) >> 7
}
func (o *TC_Type) SetSR0_CLKSTA(value uint32) {
	volatile.StoreUint32(&o.SR0.Reg, volatile.LoadUint32(&o.SR0.Reg)&^(0x10000)|value<<16)
}
func (o *TC_Type) GetSR0_CLKSTA() uint32 {
	return (volatile.LoadUint32(&o.SR0.Reg) & 0x10000) >> 16
}
func (o *TC_Type) SetSR0_MTIOA(value uint32) {
	volatile.StoreUint32(&o.SR0.Reg, volatile.LoadUint32(&o.SR0.Reg)&^(0x20000)|value<<17)
}
func (o *TC_Type) GetSR0_MTIOA() uint32 {
	return (volatile.LoadUint32(&o.SR0.Reg) & 0x20000) >> 17
}
func (o *TC_Type) SetSR0_MTIOB(value uint32) {
	volatile.StoreUint32(&o.SR0.Reg, volatile.LoadUint32(&o.SR0.Reg)&^(0x40000)|value<<18)
}
func (o *TC_Type) GetSR0_MTIOB() uint32 {
	return (volatile.LoadUint32(&o.SR0.Reg) & 0x40000) >> 18
}

// TC.IER0: Interrupt Enable Register (channel = 0)
func (o *TC_Type) SetIER0_COVFS(value uint32) {
	volatile.StoreUint32(&o.IER0.Reg, volatile.LoadUint32(&o.IER0.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetIER0_COVFS() uint32 {
	return volatile.LoadUint32(&o.IER0.Reg) & 0x1
}
func (o *TC_Type) SetIER0_LOVRS(value uint32) {
	volatile.StoreUint32(&o.IER0.Reg, volatile.LoadUint32(&o.IER0.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetIER0_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.IER0.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetIER0_CPAS(value uint32) {
	volatile.StoreUint32(&o.IER0.Reg, volatile.LoadUint32(&o.IER0.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetIER0_CPAS() uint32 {
	return (volatile.LoadUint32(&o.IER0.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetIER0_CPBS(value uint32) {
	volatile.StoreUint32(&o.IER0.Reg, volatile.LoadUint32(&o.IER0.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetIER0_CPBS() uint32 {
	return (volatile.LoadUint32(&o.IER0.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetIER0_CPCS(value uint32) {
	volatile.StoreUint32(&o.IER0.Reg, volatile.LoadUint32(&o.IER0.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetIER0_CPCS() uint32 {
	return (volatile.LoadUint32(&o.IER0.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetIER0_LDRAS(value uint32) {
	volatile.StoreUint32(&o.IER0.Reg, volatile.LoadUint32(&o.IER0.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetIER0_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.IER0.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetIER0_LDRBS(value uint32) {
	volatile.StoreUint32(&o.IER0.Reg, volatile.LoadUint32(&o.IER0.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetIER0_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.IER0.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetIER0_ETRGS(value uint32) {
	volatile.StoreUint32(&o.IER0.Reg, volatile.LoadUint32(&o.IER0.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetIER0_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.IER0.Reg) & 0x80) >> 7
}

// TC.IDR0: Interrupt Disable Register (channel = 0)
func (o *TC_Type) SetIDR0_COVFS(value uint32) {
	volatile.StoreUint32(&o.IDR0.Reg, volatile.LoadUint32(&o.IDR0.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetIDR0_COVFS() uint32 {
	return volatile.LoadUint32(&o.IDR0.Reg) & 0x1
}
func (o *TC_Type) SetIDR0_LOVRS(value uint32) {
	volatile.StoreUint32(&o.IDR0.Reg, volatile.LoadUint32(&o.IDR0.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetIDR0_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.IDR0.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetIDR0_CPAS(value uint32) {
	volatile.StoreUint32(&o.IDR0.Reg, volatile.LoadUint32(&o.IDR0.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetIDR0_CPAS() uint32 {
	return (volatile.LoadUint32(&o.IDR0.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetIDR0_CPBS(value uint32) {
	volatile.StoreUint32(&o.IDR0.Reg, volatile.LoadUint32(&o.IDR0.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetIDR0_CPBS() uint32 {
	return (volatile.LoadUint32(&o.IDR0.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetIDR0_CPCS(value uint32) {
	volatile.StoreUint32(&o.IDR0.Reg, volatile.LoadUint32(&o.IDR0.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetIDR0_CPCS() uint32 {
	return (volatile.LoadUint32(&o.IDR0.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetIDR0_LDRAS(value uint32) {
	volatile.StoreUint32(&o.IDR0.Reg, volatile.LoadUint32(&o.IDR0.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetIDR0_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.IDR0.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetIDR0_LDRBS(value uint32) {
	volatile.StoreUint32(&o.IDR0.Reg, volatile.LoadUint32(&o.IDR0.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetIDR0_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.IDR0.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetIDR0_ETRGS(value uint32) {
	volatile.StoreUint32(&o.IDR0.Reg, volatile.LoadUint32(&o.IDR0.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetIDR0_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.IDR0.Reg) & 0x80) >> 7
}

// TC.IMR0: Interrupt Mask Register (channel = 0)
func (o *TC_Type) SetIMR0_COVFS(value uint32) {
	volatile.StoreUint32(&o.IMR0.Reg, volatile.LoadUint32(&o.IMR0.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetIMR0_COVFS() uint32 {
	return volatile.LoadUint32(&o.IMR0.Reg) & 0x1
}
func (o *TC_Type) SetIMR0_LOVRS(value uint32) {
	volatile.StoreUint32(&o.IMR0.Reg, volatile.LoadUint32(&o.IMR0.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetIMR0_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.IMR0.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetIMR0_CPAS(value uint32) {
	volatile.StoreUint32(&o.IMR0.Reg, volatile.LoadUint32(&o.IMR0.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetIMR0_CPAS() uint32 {
	return (volatile.LoadUint32(&o.IMR0.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetIMR0_CPBS(value uint32) {
	volatile.StoreUint32(&o.IMR0.Reg, volatile.LoadUint32(&o.IMR0.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetIMR0_CPBS() uint32 {
	return (volatile.LoadUint32(&o.IMR0.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetIMR0_CPCS(value uint32) {
	volatile.StoreUint32(&o.IMR0.Reg, volatile.LoadUint32(&o.IMR0.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetIMR0_CPCS() uint32 {
	return (volatile.LoadUint32(&o.IMR0.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetIMR0_LDRAS(value uint32) {
	volatile.StoreUint32(&o.IMR0.Reg, volatile.LoadUint32(&o.IMR0.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetIMR0_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.IMR0.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetIMR0_LDRBS(value uint32) {
	volatile.StoreUint32(&o.IMR0.Reg, volatile.LoadUint32(&o.IMR0.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetIMR0_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.IMR0.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetIMR0_ETRGS(value uint32) {
	volatile.StoreUint32(&o.IMR0.Reg, volatile.LoadUint32(&o.IMR0.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetIMR0_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.IMR0.Reg) & 0x80) >> 7
}

// TC.CCR1: Channel Control Register (channel = 1)
func (o *TC_Type) SetCCR1_CLKEN(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetCCR1_CLKEN() uint32 {
	return volatile.LoadUint32(&o.CCR1.Reg) & 0x1
}
func (o *TC_Type) SetCCR1_CLKDIS(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetCCR1_CLKDIS() uint32 {
	return (volatile.LoadUint32(&o.CCR1.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetCCR1_SWTRG(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetCCR1_SWTRG() uint32 {
	return (volatile.LoadUint32(&o.CCR1.Reg) & 0x4) >> 2
}

// TC.CMR1: Channel Mode Register (channel = 1)
func (o *TC_Type) SetCMR1_TCCLKS(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x7)|value)
}
func (o *TC_Type) GetCMR1_TCCLKS() uint32 {
	return volatile.LoadUint32(&o.CMR1.Reg) & 0x7
}
func (o *TC_Type) SetCMR1_CLKI(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetCMR1_CLKI() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetCMR1_BURST(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x30)|value<<4)
}
func (o *TC_Type) GetCMR1_BURST() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x30) >> 4
}
func (o *TC_Type) SetCMR1_LDBSTOP(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetCMR1_LDBSTOP() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetCMR1_LDBDIS(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetCMR1_LDBDIS() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x80) >> 7
}
func (o *TC_Type) SetCMR1_ETRGEDG(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x300)|value<<8)
}
func (o *TC_Type) GetCMR1_ETRGEDG() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x300) >> 8
}
func (o *TC_Type) SetCMR1_ABETRG(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x400)|value<<10)
}
func (o *TC_Type) GetCMR1_ABETRG() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x400) >> 10
}
func (o *TC_Type) SetCMR1_CPCTRG(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x4000)|value<<14)
}
func (o *TC_Type) GetCMR1_CPCTRG() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x4000) >> 14
}
func (o *TC_Type) SetCMR1_WAVE(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x8000)|value<<15)
}
func (o *TC_Type) GetCMR1_WAVE() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x8000) >> 15
}
func (o *TC_Type) SetCMR1_LDRA(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x30000)|value<<16)
}
func (o *TC_Type) GetCMR1_LDRA() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x30000) >> 16
}
func (o *TC_Type) SetCMR1_LDRB(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0xc0000)|value<<18)
}
func (o *TC_Type) GetCMR1_LDRB() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0xc0000) >> 18
}

// TC.SMMR1: Stepper Motor Mode Register (channel = 1)
func (o *TC_Type) SetSMMR1_GCEN(value uint32) {
	volatile.StoreUint32(&o.SMMR1.Reg, volatile.LoadUint32(&o.SMMR1.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetSMMR1_GCEN() uint32 {
	return volatile.LoadUint32(&o.SMMR1.Reg) & 0x1
}
func (o *TC_Type) SetSMMR1_DOWN(value uint32) {
	volatile.StoreUint32(&o.SMMR1.Reg, volatile.LoadUint32(&o.SMMR1.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetSMMR1_DOWN() uint32 {
	return (volatile.LoadUint32(&o.SMMR1.Reg) & 0x2) >> 1
}

// TC.CV1: Counter Value (channel = 1)
func (o *TC_Type) SetCV1(value uint32) {
	volatile.StoreUint32(&o.CV1.Reg, value)
}
func (o *TC_Type) GetCV1() uint32 {
	return volatile.LoadUint32(&o.CV1.Reg)
}

// TC.RA1: Register A (channel = 1)
func (o *TC_Type) SetRA1(value uint32) {
	volatile.StoreUint32(&o.RA1.Reg, value)
}
func (o *TC_Type) GetRA1() uint32 {
	return volatile.LoadUint32(&o.RA1.Reg)
}

// TC.RB1: Register B (channel = 1)
func (o *TC_Type) SetRB1(value uint32) {
	volatile.StoreUint32(&o.RB1.Reg, value)
}
func (o *TC_Type) GetRB1() uint32 {
	return volatile.LoadUint32(&o.RB1.Reg)
}

// TC.RC1: Register C (channel = 1)
func (o *TC_Type) SetRC1(value uint32) {
	volatile.StoreUint32(&o.RC1.Reg, value)
}
func (o *TC_Type) GetRC1() uint32 {
	return volatile.LoadUint32(&o.RC1.Reg)
}

// TC.SR1: Status Register (channel = 1)
func (o *TC_Type) SetSR1_COVFS(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetSR1_COVFS() uint32 {
	return volatile.LoadUint32(&o.SR1.Reg) & 0x1
}
func (o *TC_Type) SetSR1_LOVRS(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetSR1_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetSR1_CPAS(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetSR1_CPAS() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetSR1_CPBS(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetSR1_CPBS() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetSR1_CPCS(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetSR1_CPCS() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetSR1_LDRAS(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetSR1_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetSR1_LDRBS(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetSR1_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetSR1_ETRGS(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetSR1_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x80) >> 7
}
func (o *TC_Type) SetSR1_CLKSTA(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x10000)|value<<16)
}
func (o *TC_Type) GetSR1_CLKSTA() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x10000) >> 16
}
func (o *TC_Type) SetSR1_MTIOA(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x20000)|value<<17)
}
func (o *TC_Type) GetSR1_MTIOA() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x20000) >> 17
}
func (o *TC_Type) SetSR1_MTIOB(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x40000)|value<<18)
}
func (o *TC_Type) GetSR1_MTIOB() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x40000) >> 18
}

// TC.IER1: Interrupt Enable Register (channel = 1)
func (o *TC_Type) SetIER1_COVFS(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetIER1_COVFS() uint32 {
	return volatile.LoadUint32(&o.IER1.Reg) & 0x1
}
func (o *TC_Type) SetIER1_LOVRS(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetIER1_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetIER1_CPAS(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetIER1_CPAS() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetIER1_CPBS(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetIER1_CPBS() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetIER1_CPCS(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetIER1_CPCS() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetIER1_LDRAS(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetIER1_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetIER1_LDRBS(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetIER1_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetIER1_ETRGS(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetIER1_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x80) >> 7
}

// TC.IDR1: Interrupt Disable Register (channel = 1)
func (o *TC_Type) SetIDR1_COVFS(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetIDR1_COVFS() uint32 {
	return volatile.LoadUint32(&o.IDR1.Reg) & 0x1
}
func (o *TC_Type) SetIDR1_LOVRS(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetIDR1_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetIDR1_CPAS(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetIDR1_CPAS() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetIDR1_CPBS(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetIDR1_CPBS() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetIDR1_CPCS(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetIDR1_CPCS() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetIDR1_LDRAS(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetIDR1_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetIDR1_LDRBS(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetIDR1_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetIDR1_ETRGS(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetIDR1_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x80) >> 7
}

// TC.IMR1: Interrupt Mask Register (channel = 1)
func (o *TC_Type) SetIMR1_COVFS(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetIMR1_COVFS() uint32 {
	return volatile.LoadUint32(&o.IMR1.Reg) & 0x1
}
func (o *TC_Type) SetIMR1_LOVRS(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetIMR1_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetIMR1_CPAS(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetIMR1_CPAS() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetIMR1_CPBS(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetIMR1_CPBS() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetIMR1_CPCS(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetIMR1_CPCS() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetIMR1_LDRAS(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetIMR1_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetIMR1_LDRBS(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetIMR1_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetIMR1_ETRGS(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetIMR1_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x80) >> 7
}

// TC.CCR2: Channel Control Register (channel = 2)
func (o *TC_Type) SetCCR2_CLKEN(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetCCR2_CLKEN() uint32 {
	return volatile.LoadUint32(&o.CCR2.Reg) & 0x1
}
func (o *TC_Type) SetCCR2_CLKDIS(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetCCR2_CLKDIS() uint32 {
	return (volatile.LoadUint32(&o.CCR2.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetCCR2_SWTRG(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetCCR2_SWTRG() uint32 {
	return (volatile.LoadUint32(&o.CCR2.Reg) & 0x4) >> 2
}

// TC.CMR2: Channel Mode Register (channel = 2)
func (o *TC_Type) SetCMR2_TCCLKS(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x7)|value)
}
func (o *TC_Type) GetCMR2_TCCLKS() uint32 {
	return volatile.LoadUint32(&o.CMR2.Reg) & 0x7
}
func (o *TC_Type) SetCMR2_CLKI(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetCMR2_CLKI() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetCMR2_BURST(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x30)|value<<4)
}
func (o *TC_Type) GetCMR2_BURST() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x30) >> 4
}
func (o *TC_Type) SetCMR2_LDBSTOP(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetCMR2_LDBSTOP() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetCMR2_LDBDIS(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetCMR2_LDBDIS() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x80) >> 7
}
func (o *TC_Type) SetCMR2_ETRGEDG(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x300)|value<<8)
}
func (o *TC_Type) GetCMR2_ETRGEDG() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x300) >> 8
}
func (o *TC_Type) SetCMR2_ABETRG(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x400)|value<<10)
}
func (o *TC_Type) GetCMR2_ABETRG() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x400) >> 10
}
func (o *TC_Type) SetCMR2_CPCTRG(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x4000)|value<<14)
}
func (o *TC_Type) GetCMR2_CPCTRG() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x4000) >> 14
}
func (o *TC_Type) SetCMR2_WAVE(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x8000)|value<<15)
}
func (o *TC_Type) GetCMR2_WAVE() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x8000) >> 15
}
func (o *TC_Type) SetCMR2_LDRA(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x30000)|value<<16)
}
func (o *TC_Type) GetCMR2_LDRA() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x30000) >> 16
}
func (o *TC_Type) SetCMR2_LDRB(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0xc0000)|value<<18)
}
func (o *TC_Type) GetCMR2_LDRB() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0xc0000) >> 18
}

// TC.SMMR2: Stepper Motor Mode Register (channel = 2)
func (o *TC_Type) SetSMMR2_GCEN(value uint32) {
	volatile.StoreUint32(&o.SMMR2.Reg, volatile.LoadUint32(&o.SMMR2.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetSMMR2_GCEN() uint32 {
	return volatile.LoadUint32(&o.SMMR2.Reg) & 0x1
}
func (o *TC_Type) SetSMMR2_DOWN(value uint32) {
	volatile.StoreUint32(&o.SMMR2.Reg, volatile.LoadUint32(&o.SMMR2.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetSMMR2_DOWN() uint32 {
	return (volatile.LoadUint32(&o.SMMR2.Reg) & 0x2) >> 1
}

// TC.CV2: Counter Value (channel = 2)
func (o *TC_Type) SetCV2(value uint32) {
	volatile.StoreUint32(&o.CV2.Reg, value)
}
func (o *TC_Type) GetCV2() uint32 {
	return volatile.LoadUint32(&o.CV2.Reg)
}

// TC.RA2: Register A (channel = 2)
func (o *TC_Type) SetRA2(value uint32) {
	volatile.StoreUint32(&o.RA2.Reg, value)
}
func (o *TC_Type) GetRA2() uint32 {
	return volatile.LoadUint32(&o.RA2.Reg)
}

// TC.RB2: Register B (channel = 2)
func (o *TC_Type) SetRB2(value uint32) {
	volatile.StoreUint32(&o.RB2.Reg, value)
}
func (o *TC_Type) GetRB2() uint32 {
	return volatile.LoadUint32(&o.RB2.Reg)
}

// TC.RC2: Register C (channel = 2)
func (o *TC_Type) SetRC2(value uint32) {
	volatile.StoreUint32(&o.RC2.Reg, value)
}
func (o *TC_Type) GetRC2() uint32 {
	return volatile.LoadUint32(&o.RC2.Reg)
}

// TC.SR2: Status Register (channel = 2)
func (o *TC_Type) SetSR2_COVFS(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetSR2_COVFS() uint32 {
	return volatile.LoadUint32(&o.SR2.Reg) & 0x1
}
func (o *TC_Type) SetSR2_LOVRS(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetSR2_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetSR2_CPAS(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetSR2_CPAS() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetSR2_CPBS(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetSR2_CPBS() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetSR2_CPCS(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetSR2_CPCS() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetSR2_LDRAS(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetSR2_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetSR2_LDRBS(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetSR2_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetSR2_ETRGS(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetSR2_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x80) >> 7
}
func (o *TC_Type) SetSR2_CLKSTA(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x10000)|value<<16)
}
func (o *TC_Type) GetSR2_CLKSTA() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x10000) >> 16
}
func (o *TC_Type) SetSR2_MTIOA(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x20000)|value<<17)
}
func (o *TC_Type) GetSR2_MTIOA() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x20000) >> 17
}
func (o *TC_Type) SetSR2_MTIOB(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x40000)|value<<18)
}
func (o *TC_Type) GetSR2_MTIOB() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x40000) >> 18
}

// TC.IER2: Interrupt Enable Register (channel = 2)
func (o *TC_Type) SetIER2_COVFS(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetIER2_COVFS() uint32 {
	return volatile.LoadUint32(&o.IER2.Reg) & 0x1
}
func (o *TC_Type) SetIER2_LOVRS(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetIER2_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetIER2_CPAS(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetIER2_CPAS() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetIER2_CPBS(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetIER2_CPBS() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetIER2_CPCS(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetIER2_CPCS() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetIER2_LDRAS(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetIER2_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetIER2_LDRBS(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetIER2_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetIER2_ETRGS(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetIER2_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x80) >> 7
}

// TC.IDR2: Interrupt Disable Register (channel = 2)
func (o *TC_Type) SetIDR2_COVFS(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetIDR2_COVFS() uint32 {
	return volatile.LoadUint32(&o.IDR2.Reg) & 0x1
}
func (o *TC_Type) SetIDR2_LOVRS(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetIDR2_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetIDR2_CPAS(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetIDR2_CPAS() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetIDR2_CPBS(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetIDR2_CPBS() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetIDR2_CPCS(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetIDR2_CPCS() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetIDR2_LDRAS(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetIDR2_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetIDR2_LDRBS(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetIDR2_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetIDR2_ETRGS(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetIDR2_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x80) >> 7
}

// TC.IMR2: Interrupt Mask Register (channel = 2)
func (o *TC_Type) SetIMR2_COVFS(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetIMR2_COVFS() uint32 {
	return volatile.LoadUint32(&o.IMR2.Reg) & 0x1
}
func (o *TC_Type) SetIMR2_LOVRS(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetIMR2_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetIMR2_CPAS(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetIMR2_CPAS() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetIMR2_CPBS(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetIMR2_CPBS() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetIMR2_CPCS(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetIMR2_CPCS() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetIMR2_LDRAS(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetIMR2_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetIMR2_LDRBS(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetIMR2_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetIMR2_ETRGS(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetIMR2_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x80) >> 7
}

// TC.BCR: Block Control Register
func (o *TC_Type) SetBCR_SYNC(value uint32) {
	volatile.StoreUint32(&o.BCR.Reg, volatile.LoadUint32(&o.BCR.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetBCR_SYNC() uint32 {
	return volatile.LoadUint32(&o.BCR.Reg) & 0x1
}

// TC.BMR: Block Mode Register
func (o *TC_Type) SetBMR_TC0XC0S(value uint32) {
	volatile.StoreUint32(&o.BMR.Reg, volatile.LoadUint32(&o.BMR.Reg)&^(0x3)|value)
}
func (o *TC_Type) GetBMR_TC0XC0S() uint32 {
	return volatile.LoadUint32(&o.BMR.Reg) & 0x3
}
func (o *TC_Type) SetBMR_TC1XC1S(value uint32) {
	volatile.StoreUint32(&o.BMR.Reg, volatile.LoadUint32(&o.BMR.Reg)&^(0xc)|value<<2)
}
func (o *TC_Type) GetBMR_TC1XC1S() uint32 {
	return (volatile.LoadUint32(&o.BMR.Reg) & 0xc) >> 2
}
func (o *TC_Type) SetBMR_TC2XC2S(value uint32) {
	volatile.StoreUint32(&o.BMR.Reg, volatile.LoadUint32(&o.BMR.Reg)&^(0x30)|value<<4)
}
func (o *TC_Type) GetBMR_TC2XC2S() uint32 {
	return (volatile.LoadUint32(&o.BMR.Reg) & 0x30) >> 4
}
func (o *TC_Type) SetBMR_QDEN(value uint32) {
	volatile.StoreUint32(&o.BMR.Reg, volatile.LoadUint32(&o.BMR.Reg)&^(0x100)|value<<8)
}
func (o *TC_Type) GetBMR_QDEN() uint32 {
	return (volatile.LoadUint32(&o.BMR.Reg) & 0x100) >> 8
}
func (o *TC_Type) SetBMR_POSEN(value uint32) {
	volatile.StoreUint32(&o.BMR.Reg, volatile.LoadUint32(&o.BMR.Reg)&^(0x200)|value<<9)
}
func (o *TC_Type) GetBMR_POSEN() uint32 {
	return (volatile.LoadUint32(&o.BMR.Reg) & 0x200) >> 9
}
func (o *TC_Type) SetBMR_SPEEDEN(value uint32) {
	volatile.StoreUint32(&o.BMR.Reg, volatile.LoadUint32(&o.BMR.Reg)&^(0x400)|value<<10)
}
func (o *TC_Type) GetBMR_SPEEDEN() uint32 {
	return (volatile.LoadUint32(&o.BMR.Reg) & 0x400) >> 10
}
func (o *TC_Type) SetBMR_QDTRANS(value uint32) {
	volatile.StoreUint32(&o.BMR.Reg, volatile.LoadUint32(&o.BMR.Reg)&^(0x800)|value<<11)
}
func (o *TC_Type) GetBMR_QDTRANS() uint32 {
	return (volatile.LoadUint32(&o.BMR.Reg) & 0x800) >> 11
}
func (o *TC_Type) SetBMR_EDGPHA(value uint32) {
	volatile.StoreUint32(&o.BMR.Reg, volatile.LoadUint32(&o.BMR.Reg)&^(0x1000)|value<<12)
}
func (o *TC_Type) GetBMR_EDGPHA() uint32 {
	return (volatile.LoadUint32(&o.BMR.Reg) & 0x1000) >> 12
}
func (o *TC_Type) SetBMR_INVA(value uint32) {
	volatile.StoreUint32(&o.BMR.Reg, volatile.LoadUint32(&o.BMR.Reg)&^(0x2000)|value<<13)
}
func (o *TC_Type) GetBMR_INVA() uint32 {
	return (volatile.LoadUint32(&o.BMR.Reg) & 0x2000) >> 13
}
func (o *TC_Type) SetBMR_INVB(value uint32) {
	volatile.StoreUint32(&o.BMR.Reg, volatile.LoadUint32(&o.BMR.Reg)&^(0x4000)|value<<14)
}
func (o *TC_Type) GetBMR_INVB() uint32 {
	return (volatile.LoadUint32(&o.BMR.Reg) & 0x4000) >> 14
}
func (o *TC_Type) SetBMR_INVIDX(value uint32) {
	volatile.StoreUint32(&o.BMR.Reg, volatile.LoadUint32(&o.BMR.Reg)&^(0x8000)|value<<15)
}
func (o *TC_Type) GetBMR_INVIDX() uint32 {
	return (volatile.LoadUint32(&o.BMR.Reg) & 0x8000) >> 15
}
func (o *TC_Type) SetBMR_SWAP(value uint32) {
	volatile.StoreUint32(&o.BMR.Reg, volatile.LoadUint32(&o.BMR.Reg)&^(0x10000)|value<<16)
}
func (o *TC_Type) GetBMR_SWAP() uint32 {
	return (volatile.LoadUint32(&o.BMR.Reg) & 0x10000) >> 16
}
func (o *TC_Type) SetBMR_IDXPHB(value uint32) {
	volatile.StoreUint32(&o.BMR.Reg, volatile.LoadUint32(&o.BMR.Reg)&^(0x20000)|value<<17)
}
func (o *TC_Type) GetBMR_IDXPHB() uint32 {
	return (volatile.LoadUint32(&o.BMR.Reg) & 0x20000) >> 17
}
func (o *TC_Type) SetBMR_MAXFILT(value uint32) {
	volatile.StoreUint32(&o.BMR.Reg, volatile.LoadUint32(&o.BMR.Reg)&^(0x3f00000)|value<<20)
}
func (o *TC_Type) GetBMR_MAXFILT() uint32 {
	return (volatile.LoadUint32(&o.BMR.Reg) & 0x3f00000) >> 20
}

// TC.QIER: QDEC Interrupt Enable Register
func (o *TC_Type) SetQIER_IDX(value uint32) {
	volatile.StoreUint32(&o.QIER.Reg, volatile.LoadUint32(&o.QIER.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetQIER_IDX() uint32 {
	return volatile.LoadUint32(&o.QIER.Reg) & 0x1
}
func (o *TC_Type) SetQIER_DIRCHG(value uint32) {
	volatile.StoreUint32(&o.QIER.Reg, volatile.LoadUint32(&o.QIER.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetQIER_DIRCHG() uint32 {
	return (volatile.LoadUint32(&o.QIER.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetQIER_QERR(value uint32) {
	volatile.StoreUint32(&o.QIER.Reg, volatile.LoadUint32(&o.QIER.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetQIER_QERR() uint32 {
	return (volatile.LoadUint32(&o.QIER.Reg) & 0x4) >> 2
}

// TC.QIDR: QDEC Interrupt Disable Register
func (o *TC_Type) SetQIDR_IDX(value uint32) {
	volatile.StoreUint32(&o.QIDR.Reg, volatile.LoadUint32(&o.QIDR.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetQIDR_IDX() uint32 {
	return volatile.LoadUint32(&o.QIDR.Reg) & 0x1
}
func (o *TC_Type) SetQIDR_DIRCHG(value uint32) {
	volatile.StoreUint32(&o.QIDR.Reg, volatile.LoadUint32(&o.QIDR.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetQIDR_DIRCHG() uint32 {
	return (volatile.LoadUint32(&o.QIDR.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetQIDR_QERR(value uint32) {
	volatile.StoreUint32(&o.QIDR.Reg, volatile.LoadUint32(&o.QIDR.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetQIDR_QERR() uint32 {
	return (volatile.LoadUint32(&o.QIDR.Reg) & 0x4) >> 2
}

// TC.QIMR: QDEC Interrupt Mask Register
func (o *TC_Type) SetQIMR_IDX(value uint32) {
	volatile.StoreUint32(&o.QIMR.Reg, volatile.LoadUint32(&o.QIMR.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetQIMR_IDX() uint32 {
	return volatile.LoadUint32(&o.QIMR.Reg) & 0x1
}
func (o *TC_Type) SetQIMR_DIRCHG(value uint32) {
	volatile.StoreUint32(&o.QIMR.Reg, volatile.LoadUint32(&o.QIMR.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetQIMR_DIRCHG() uint32 {
	return (volatile.LoadUint32(&o.QIMR.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetQIMR_QERR(value uint32) {
	volatile.StoreUint32(&o.QIMR.Reg, volatile.LoadUint32(&o.QIMR.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetQIMR_QERR() uint32 {
	return (volatile.LoadUint32(&o.QIMR.Reg) & 0x4) >> 2
}

// TC.QISR: QDEC Interrupt Status Register
func (o *TC_Type) SetQISR_IDX(value uint32) {
	volatile.StoreUint32(&o.QISR.Reg, volatile.LoadUint32(&o.QISR.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetQISR_IDX() uint32 {
	return volatile.LoadUint32(&o.QISR.Reg) & 0x1
}
func (o *TC_Type) SetQISR_DIRCHG(value uint32) {
	volatile.StoreUint32(&o.QISR.Reg, volatile.LoadUint32(&o.QISR.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetQISR_DIRCHG() uint32 {
	return (volatile.LoadUint32(&o.QISR.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetQISR_QERR(value uint32) {
	volatile.StoreUint32(&o.QISR.Reg, volatile.LoadUint32(&o.QISR.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetQISR_QERR() uint32 {
	return (volatile.LoadUint32(&o.QISR.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetQISR_DIR(value uint32) {
	volatile.StoreUint32(&o.QISR.Reg, volatile.LoadUint32(&o.QISR.Reg)&^(0x100)|value<<8)
}
func (o *TC_Type) GetQISR_DIR() uint32 {
	return (volatile.LoadUint32(&o.QISR.Reg) & 0x100) >> 8
}

// TC.FMR: Fault Mode Register
func (o *TC_Type) SetFMR_ENCF0(value uint32) {
	volatile.StoreUint32(&o.FMR.Reg, volatile.LoadUint32(&o.FMR.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetFMR_ENCF0() uint32 {
	return volatile.LoadUint32(&o.FMR.Reg) & 0x1
}
func (o *TC_Type) SetFMR_ENCF1(value uint32) {
	volatile.StoreUint32(&o.FMR.Reg, volatile.LoadUint32(&o.FMR.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetFMR_ENCF1() uint32 {
	return (volatile.LoadUint32(&o.FMR.Reg) & 0x2) >> 1
}

// TC.WPMR: Write Protection Mode Register
func (o *TC_Type) SetWPMR_WPEN(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetWPMR_WPEN() uint32 {
	return volatile.LoadUint32(&o.WPMR.Reg) & 0x1
}
func (o *TC_Type) SetWPMR_WPKEY(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0xffffff00)|value<<8)
}
func (o *TC_Type) GetWPMR_WPKEY() uint32 {
	return (volatile.LoadUint32(&o.WPMR.Reg) & 0xffffff00) >> 8
}

// Two-wire Interface 0
type TWI_Type struct {
	CR   volatile.Register32 // 0x0
	MMR  volatile.Register32 // 0x4
	SMR  volatile.Register32 // 0x8
	IADR volatile.Register32 // 0xC
	CWGR volatile.Register32 // 0x10
	_    [12]byte
	SR   volatile.Register32 // 0x20
	IER  volatile.Register32 // 0x24
	IDR  volatile.Register32 // 0x28
	IMR  volatile.Register32 // 0x2C
	RHR  volatile.Register32 // 0x30
	THR  volatile.Register32 // 0x34
	_    [200]byte
	RPR  volatile.Register32 // 0x100
	RCR  volatile.Register32 // 0x104
	TPR  volatile.Register32 // 0x108
	TCR  volatile.Register32 // 0x10C
	RNPR volatile.Register32 // 0x110
	RNCR volatile.Register32 // 0x114
	TNPR volatile.Register32 // 0x118
	TNCR volatile.Register32 // 0x11C
	PTCR volatile.Register32 // 0x120
	PTSR volatile.Register32 // 0x124
}

// TWI.CR: Control Register
func (o *TWI_Type) SetCR_START(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *TWI_Type) GetCR_START() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *TWI_Type) SetCR_STOP(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *TWI_Type) GetCR_STOP() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *TWI_Type) SetCR_MSEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *TWI_Type) GetCR_MSEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *TWI_Type) SetCR_MSDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *TWI_Type) GetCR_MSDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *TWI_Type) SetCR_SVEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *TWI_Type) GetCR_SVEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *TWI_Type) SetCR_SVDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20)|value<<5)
}
func (o *TWI_Type) GetCR_SVDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20) >> 5
}
func (o *TWI_Type) SetCR_QUICK(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40)|value<<6)
}
func (o *TWI_Type) GetCR_QUICK() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40) >> 6
}
func (o *TWI_Type) SetCR_SWRST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *TWI_Type) GetCR_SWRST() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}

// TWI.MMR: Master Mode Register
func (o *TWI_Type) SetMMR_IADRSZ(value uint32) {
	volatile.StoreUint32(&o.MMR.Reg, volatile.LoadUint32(&o.MMR.Reg)&^(0x300)|value<<8)
}
func (o *TWI_Type) GetMMR_IADRSZ() uint32 {
	return (volatile.LoadUint32(&o.MMR.Reg) & 0x300) >> 8
}
func (o *TWI_Type) SetMMR_MREAD(value uint32) {
	volatile.StoreUint32(&o.MMR.Reg, volatile.LoadUint32(&o.MMR.Reg)&^(0x1000)|value<<12)
}
func (o *TWI_Type) GetMMR_MREAD() uint32 {
	return (volatile.LoadUint32(&o.MMR.Reg) & 0x1000) >> 12
}
func (o *TWI_Type) SetMMR_DADR(value uint32) {
	volatile.StoreUint32(&o.MMR.Reg, volatile.LoadUint32(&o.MMR.Reg)&^(0x7f0000)|value<<16)
}
func (o *TWI_Type) GetMMR_DADR() uint32 {
	return (volatile.LoadUint32(&o.MMR.Reg) & 0x7f0000) >> 16
}

// TWI.SMR: Slave Mode Register
func (o *TWI_Type) SetSMR_SADR(value uint32) {
	volatile.StoreUint32(&o.SMR.Reg, volatile.LoadUint32(&o.SMR.Reg)&^(0x7f0000)|value<<16)
}
func (o *TWI_Type) GetSMR_SADR() uint32 {
	return (volatile.LoadUint32(&o.SMR.Reg) & 0x7f0000) >> 16
}

// TWI.IADR: Internal Address Register
func (o *TWI_Type) SetIADR(value uint32) {
	volatile.StoreUint32(&o.IADR.Reg, volatile.LoadUint32(&o.IADR.Reg)&^(0xffffff)|value)
}
func (o *TWI_Type) GetIADR() uint32 {
	return volatile.LoadUint32(&o.IADR.Reg) & 0xffffff
}

// TWI.CWGR: Clock Waveform Generator Register
func (o *TWI_Type) SetCWGR_CLDIV(value uint32) {
	volatile.StoreUint32(&o.CWGR.Reg, volatile.LoadUint32(&o.CWGR.Reg)&^(0xff)|value)
}
func (o *TWI_Type) GetCWGR_CLDIV() uint32 {
	return volatile.LoadUint32(&o.CWGR.Reg) & 0xff
}
func (o *TWI_Type) SetCWGR_CHDIV(value uint32) {
	volatile.StoreUint32(&o.CWGR.Reg, volatile.LoadUint32(&o.CWGR.Reg)&^(0xff00)|value<<8)
}
func (o *TWI_Type) GetCWGR_CHDIV() uint32 {
	return (volatile.LoadUint32(&o.CWGR.Reg) & 0xff00) >> 8
}
func (o *TWI_Type) SetCWGR_CKDIV(value uint32) {
	volatile.StoreUint32(&o.CWGR.Reg, volatile.LoadUint32(&o.CWGR.Reg)&^(0x70000)|value<<16)
}
func (o *TWI_Type) GetCWGR_CKDIV() uint32 {
	return (volatile.LoadUint32(&o.CWGR.Reg) & 0x70000) >> 16
}

// TWI.SR: Status Register
func (o *TWI_Type) SetSR_TXCOMP(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *TWI_Type) GetSR_TXCOMP() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *TWI_Type) SetSR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *TWI_Type) GetSR_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *TWI_Type) SetSR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *TWI_Type) GetSR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *TWI_Type) SetSR_SVREAD(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *TWI_Type) GetSR_SVREAD() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *TWI_Type) SetSR_SVACC(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *TWI_Type) GetSR_SVACC() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *TWI_Type) SetSR_GACC(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *TWI_Type) GetSR_GACC() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *TWI_Type) SetSR_OVRE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *TWI_Type) GetSR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *TWI_Type) SetSR_NACK(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100)|value<<8)
}
func (o *TWI_Type) GetSR_NACK() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100) >> 8
}
func (o *TWI_Type) SetSR_ARBLST(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x200)|value<<9)
}
func (o *TWI_Type) GetSR_ARBLST() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x200) >> 9
}
func (o *TWI_Type) SetSR_SCLWS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x400)|value<<10)
}
func (o *TWI_Type) GetSR_SCLWS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x400) >> 10
}
func (o *TWI_Type) SetSR_EOSACC(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x800)|value<<11)
}
func (o *TWI_Type) GetSR_EOSACC() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x800) >> 11
}
func (o *TWI_Type) SetSR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1000)|value<<12)
}
func (o *TWI_Type) GetSR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x1000) >> 12
}
func (o *TWI_Type) SetSR_ENDTX(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2000)|value<<13)
}
func (o *TWI_Type) GetSR_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2000) >> 13
}
func (o *TWI_Type) SetSR_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4000)|value<<14)
}
func (o *TWI_Type) GetSR_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4000) >> 14
}
func (o *TWI_Type) SetSR_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8000)|value<<15)
}
func (o *TWI_Type) GetSR_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8000) >> 15
}

// TWI.IER: Interrupt Enable Register
func (o *TWI_Type) SetIER_TXCOMP(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *TWI_Type) GetIER_TXCOMP() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *TWI_Type) SetIER_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *TWI_Type) GetIER_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *TWI_Type) SetIER_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *TWI_Type) GetIER_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *TWI_Type) SetIER_SVACC(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *TWI_Type) GetIER_SVACC() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *TWI_Type) SetIER_GACC(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *TWI_Type) GetIER_GACC() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *TWI_Type) SetIER_OVRE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40)|value<<6)
}
func (o *TWI_Type) GetIER_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40) >> 6
}
func (o *TWI_Type) SetIER_NACK(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100)|value<<8)
}
func (o *TWI_Type) GetIER_NACK() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100) >> 8
}
func (o *TWI_Type) SetIER_ARBLST(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200)|value<<9)
}
func (o *TWI_Type) GetIER_ARBLST() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200) >> 9
}
func (o *TWI_Type) SetIER_SCL_WS(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400)|value<<10)
}
func (o *TWI_Type) GetIER_SCL_WS() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400) >> 10
}
func (o *TWI_Type) SetIER_EOSACC(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x800)|value<<11)
}
func (o *TWI_Type) GetIER_EOSACC() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x800) >> 11
}
func (o *TWI_Type) SetIER_ENDRX(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1000)|value<<12)
}
func (o *TWI_Type) GetIER_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x1000) >> 12
}
func (o *TWI_Type) SetIER_ENDTX(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2000)|value<<13)
}
func (o *TWI_Type) GetIER_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2000) >> 13
}
func (o *TWI_Type) SetIER_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4000)|value<<14)
}
func (o *TWI_Type) GetIER_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4000) >> 14
}
func (o *TWI_Type) SetIER_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8000)|value<<15)
}
func (o *TWI_Type) GetIER_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8000) >> 15
}

// TWI.IDR: Interrupt Disable Register
func (o *TWI_Type) SetIDR_TXCOMP(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *TWI_Type) GetIDR_TXCOMP() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *TWI_Type) SetIDR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *TWI_Type) GetIDR_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *TWI_Type) SetIDR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4)|value<<2)
}
func (o *TWI_Type) GetIDR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4) >> 2
}
func (o *TWI_Type) SetIDR_SVACC(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10)|value<<4)
}
func (o *TWI_Type) GetIDR_SVACC() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10) >> 4
}
func (o *TWI_Type) SetIDR_GACC(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20)|value<<5)
}
func (o *TWI_Type) GetIDR_GACC() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20) >> 5
}
func (o *TWI_Type) SetIDR_OVRE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40)|value<<6)
}
func (o *TWI_Type) GetIDR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40) >> 6
}
func (o *TWI_Type) SetIDR_NACK(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100)|value<<8)
}
func (o *TWI_Type) GetIDR_NACK() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100) >> 8
}
func (o *TWI_Type) SetIDR_ARBLST(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200)|value<<9)
}
func (o *TWI_Type) GetIDR_ARBLST() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200) >> 9
}
func (o *TWI_Type) SetIDR_SCL_WS(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400)|value<<10)
}
func (o *TWI_Type) GetIDR_SCL_WS() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400) >> 10
}
func (o *TWI_Type) SetIDR_EOSACC(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x800)|value<<11)
}
func (o *TWI_Type) GetIDR_EOSACC() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x800) >> 11
}
func (o *TWI_Type) SetIDR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1000)|value<<12)
}
func (o *TWI_Type) GetIDR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x1000) >> 12
}
func (o *TWI_Type) SetIDR_ENDTX(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2000)|value<<13)
}
func (o *TWI_Type) GetIDR_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2000) >> 13
}
func (o *TWI_Type) SetIDR_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4000)|value<<14)
}
func (o *TWI_Type) GetIDR_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4000) >> 14
}
func (o *TWI_Type) SetIDR_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8000)|value<<15)
}
func (o *TWI_Type) GetIDR_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8000) >> 15
}

// TWI.IMR: Interrupt Mask Register
func (o *TWI_Type) SetIMR_TXCOMP(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *TWI_Type) GetIMR_TXCOMP() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *TWI_Type) SetIMR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *TWI_Type) GetIMR_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *TWI_Type) SetIMR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4)|value<<2)
}
func (o *TWI_Type) GetIMR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4) >> 2
}
func (o *TWI_Type) SetIMR_SVACC(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10)|value<<4)
}
func (o *TWI_Type) GetIMR_SVACC() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10) >> 4
}
func (o *TWI_Type) SetIMR_GACC(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20)|value<<5)
}
func (o *TWI_Type) GetIMR_GACC() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20) >> 5
}
func (o *TWI_Type) SetIMR_OVRE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40)|value<<6)
}
func (o *TWI_Type) GetIMR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40) >> 6
}
func (o *TWI_Type) SetIMR_NACK(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100)|value<<8)
}
func (o *TWI_Type) GetIMR_NACK() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100) >> 8
}
func (o *TWI_Type) SetIMR_ARBLST(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200)|value<<9)
}
func (o *TWI_Type) GetIMR_ARBLST() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200) >> 9
}
func (o *TWI_Type) SetIMR_SCL_WS(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400)|value<<10)
}
func (o *TWI_Type) GetIMR_SCL_WS() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400) >> 10
}
func (o *TWI_Type) SetIMR_EOSACC(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x800)|value<<11)
}
func (o *TWI_Type) GetIMR_EOSACC() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x800) >> 11
}
func (o *TWI_Type) SetIMR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1000)|value<<12)
}
func (o *TWI_Type) GetIMR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x1000) >> 12
}
func (o *TWI_Type) SetIMR_ENDTX(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2000)|value<<13)
}
func (o *TWI_Type) GetIMR_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2000) >> 13
}
func (o *TWI_Type) SetIMR_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4000)|value<<14)
}
func (o *TWI_Type) GetIMR_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4000) >> 14
}
func (o *TWI_Type) SetIMR_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8000)|value<<15)
}
func (o *TWI_Type) GetIMR_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8000) >> 15
}

// TWI.RHR: Receive Holding Register
func (o *TWI_Type) SetRHR_RXDATA(value uint32) {
	volatile.StoreUint32(&o.RHR.Reg, volatile.LoadUint32(&o.RHR.Reg)&^(0xff)|value)
}
func (o *TWI_Type) GetRHR_RXDATA() uint32 {
	return volatile.LoadUint32(&o.RHR.Reg) & 0xff
}

// TWI.THR: Transmit Holding Register
func (o *TWI_Type) SetTHR_TXDATA(value uint32) {
	volatile.StoreUint32(&o.THR.Reg, volatile.LoadUint32(&o.THR.Reg)&^(0xff)|value)
}
func (o *TWI_Type) GetTHR_TXDATA() uint32 {
	return volatile.LoadUint32(&o.THR.Reg) & 0xff
}

// TWI.RPR: Receive Pointer Register
func (o *TWI_Type) SetRPR(value uint32) {
	volatile.StoreUint32(&o.RPR.Reg, value)
}
func (o *TWI_Type) GetRPR() uint32 {
	return volatile.LoadUint32(&o.RPR.Reg)
}

// TWI.RCR: Receive Counter Register
func (o *TWI_Type) SetRCR_RXCTR(value uint32) {
	volatile.StoreUint32(&o.RCR.Reg, volatile.LoadUint32(&o.RCR.Reg)&^(0xffff)|value)
}
func (o *TWI_Type) GetRCR_RXCTR() uint32 {
	return volatile.LoadUint32(&o.RCR.Reg) & 0xffff
}

// TWI.TPR: Transmit Pointer Register
func (o *TWI_Type) SetTPR(value uint32) {
	volatile.StoreUint32(&o.TPR.Reg, value)
}
func (o *TWI_Type) GetTPR() uint32 {
	return volatile.LoadUint32(&o.TPR.Reg)
}

// TWI.TCR: Transmit Counter Register
func (o *TWI_Type) SetTCR_TXCTR(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0xffff)|value)
}
func (o *TWI_Type) GetTCR_TXCTR() uint32 {
	return volatile.LoadUint32(&o.TCR.Reg) & 0xffff
}

// TWI.RNPR: Receive Next Pointer Register
func (o *TWI_Type) SetRNPR(value uint32) {
	volatile.StoreUint32(&o.RNPR.Reg, value)
}
func (o *TWI_Type) GetRNPR() uint32 {
	return volatile.LoadUint32(&o.RNPR.Reg)
}

// TWI.RNCR: Receive Next Counter Register
func (o *TWI_Type) SetRNCR_RXNCTR(value uint32) {
	volatile.StoreUint32(&o.RNCR.Reg, volatile.LoadUint32(&o.RNCR.Reg)&^(0xffff)|value)
}
func (o *TWI_Type) GetRNCR_RXNCTR() uint32 {
	return volatile.LoadUint32(&o.RNCR.Reg) & 0xffff
}

// TWI.TNPR: Transmit Next Pointer Register
func (o *TWI_Type) SetTNPR(value uint32) {
	volatile.StoreUint32(&o.TNPR.Reg, value)
}
func (o *TWI_Type) GetTNPR() uint32 {
	return volatile.LoadUint32(&o.TNPR.Reg)
}

// TWI.TNCR: Transmit Next Counter Register
func (o *TWI_Type) SetTNCR_TXNCTR(value uint32) {
	volatile.StoreUint32(&o.TNCR.Reg, volatile.LoadUint32(&o.TNCR.Reg)&^(0xffff)|value)
}
func (o *TWI_Type) GetTNCR_TXNCTR() uint32 {
	return volatile.LoadUint32(&o.TNCR.Reg) & 0xffff
}

// TWI.PTCR: Transfer Control Register
func (o *TWI_Type) SetPTCR_RXTEN(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x1)|value)
}
func (o *TWI_Type) GetPTCR_RXTEN() uint32 {
	return volatile.LoadUint32(&o.PTCR.Reg) & 0x1
}
func (o *TWI_Type) SetPTCR_RXTDIS(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x2)|value<<1)
}
func (o *TWI_Type) GetPTCR_RXTDIS() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x2) >> 1
}
func (o *TWI_Type) SetPTCR_TXTEN(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x100)|value<<8)
}
func (o *TWI_Type) GetPTCR_TXTEN() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x100) >> 8
}
func (o *TWI_Type) SetPTCR_TXTDIS(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x200)|value<<9)
}
func (o *TWI_Type) GetPTCR_TXTDIS() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x200) >> 9
}

// TWI.PTSR: Transfer Status Register
func (o *TWI_Type) SetPTSR_RXTEN(value uint32) {
	volatile.StoreUint32(&o.PTSR.Reg, volatile.LoadUint32(&o.PTSR.Reg)&^(0x1)|value)
}
func (o *TWI_Type) GetPTSR_RXTEN() uint32 {
	return volatile.LoadUint32(&o.PTSR.Reg) & 0x1
}
func (o *TWI_Type) SetPTSR_TXTEN(value uint32) {
	volatile.StoreUint32(&o.PTSR.Reg, volatile.LoadUint32(&o.PTSR.Reg)&^(0x100)|value<<8)
}
func (o *TWI_Type) GetPTSR_TXTEN() uint32 {
	return (volatile.LoadUint32(&o.PTSR.Reg) & 0x100) >> 8
}

// Pulse Width Modulation Controller
type PWM_Type struct {
	CLK      volatile.Register32 // 0x0
	ENA      volatile.Register32 // 0x4
	DIS      volatile.Register32 // 0x8
	SR       volatile.Register32 // 0xC
	IER1     volatile.Register32 // 0x10
	IDR1     volatile.Register32 // 0x14
	IMR1     volatile.Register32 // 0x18
	ISR1     volatile.Register32 // 0x1C
	SCM      volatile.Register32 // 0x20
	_        [4]byte
	SCUC     volatile.Register32 // 0x28
	SCUP     volatile.Register32 // 0x2C
	SCUPUPD  volatile.Register32 // 0x30
	IER2     volatile.Register32 // 0x34
	IDR2     volatile.Register32 // 0x38
	IMR2     volatile.Register32 // 0x3C
	ISR2     volatile.Register32 // 0x40
	OOV      volatile.Register32 // 0x44
	OS       volatile.Register32 // 0x48
	OSS      volatile.Register32 // 0x4C
	OSC      volatile.Register32 // 0x50
	OSSUPD   volatile.Register32 // 0x54
	OSCUPD   volatile.Register32 // 0x58
	FMR      volatile.Register32 // 0x5C
	FSR      volatile.Register32 // 0x60
	FCR      volatile.Register32 // 0x64
	FPV      volatile.Register32 // 0x68
	FPE      volatile.Register32 // 0x6C
	_        [12]byte
	ELMR     [2]volatile.Register32 // 0x7C
	_        [44]byte
	SMMR     volatile.Register32 // 0xB0
	_        [48]byte
	WPCR     volatile.Register32 // 0xE4
	WPSR     volatile.Register32 // 0xE8
	_        [28]byte
	TPR      volatile.Register32 // 0x108
	TCR      volatile.Register32 // 0x10C
	_        [8]byte
	TNPR     volatile.Register32 // 0x118
	TNCR     volatile.Register32 // 0x11C
	PTCR     volatile.Register32 // 0x120
	PTSR     volatile.Register32 // 0x124
	_        [8]byte
	CMPV0    volatile.Register32 // 0x130
	CMPVUPD0 volatile.Register32 // 0x134
	CMPM0    volatile.Register32 // 0x138
	CMPMUPD0 volatile.Register32 // 0x13C
	CMPV1    volatile.Register32 // 0x140
	CMPVUPD1 volatile.Register32 // 0x144
	CMPM1    volatile.Register32 // 0x148
	CMPMUPD1 volatile.Register32 // 0x14C
	CMPV2    volatile.Register32 // 0x150
	CMPVUPD2 volatile.Register32 // 0x154
	CMPM2    volatile.Register32 // 0x158
	CMPMUPD2 volatile.Register32 // 0x15C
	CMPV3    volatile.Register32 // 0x160
	CMPVUPD3 volatile.Register32 // 0x164
	CMPM3    volatile.Register32 // 0x168
	CMPMUPD3 volatile.Register32 // 0x16C
	CMPV4    volatile.Register32 // 0x170
	CMPVUPD4 volatile.Register32 // 0x174
	CMPM4    volatile.Register32 // 0x178
	CMPMUPD4 volatile.Register32 // 0x17C
	CMPV5    volatile.Register32 // 0x180
	CMPVUPD5 volatile.Register32 // 0x184
	CMPM5    volatile.Register32 // 0x188
	CMPMUPD5 volatile.Register32 // 0x18C
	CMPV6    volatile.Register32 // 0x190
	CMPVUPD6 volatile.Register32 // 0x194
	CMPM6    volatile.Register32 // 0x198
	CMPMUPD6 volatile.Register32 // 0x19C
	CMPV7    volatile.Register32 // 0x1A0
	CMPVUPD7 volatile.Register32 // 0x1A4
	CMPM7    volatile.Register32 // 0x1A8
	CMPMUPD7 volatile.Register32 // 0x1AC
	_        [80]byte
	CMR0     volatile.Register32 // 0x200
	CDTY0    volatile.Register32 // 0x204
	CDTYUPD0 volatile.Register32 // 0x208
	CPRD0    volatile.Register32 // 0x20C
	CPRDUPD0 volatile.Register32 // 0x210
	CCNT0    volatile.Register32 // 0x214
	DT0      volatile.Register32 // 0x218
	DTUPD0   volatile.Register32 // 0x21C
	CMR1     volatile.Register32 // 0x220
	CDTY1    volatile.Register32 // 0x224
	CDTYUPD1 volatile.Register32 // 0x228
	CPRD1    volatile.Register32 // 0x22C
	CPRDUPD1 volatile.Register32 // 0x230
	CCNT1    volatile.Register32 // 0x234
	DT1      volatile.Register32 // 0x238
	DTUPD1   volatile.Register32 // 0x23C
	CMR2     volatile.Register32 // 0x240
	CDTY2    volatile.Register32 // 0x244
	CDTYUPD2 volatile.Register32 // 0x248
	CPRD2    volatile.Register32 // 0x24C
	CPRDUPD2 volatile.Register32 // 0x250
	CCNT2    volatile.Register32 // 0x254
	DT2      volatile.Register32 // 0x258
	DTUPD2   volatile.Register32 // 0x25C
	CMR3     volatile.Register32 // 0x260
	CDTY3    volatile.Register32 // 0x264
	CDTYUPD3 volatile.Register32 // 0x268
	CPRD3    volatile.Register32 // 0x26C
	CPRDUPD3 volatile.Register32 // 0x270
	CCNT3    volatile.Register32 // 0x274
	DT3      volatile.Register32 // 0x278
	DTUPD3   volatile.Register32 // 0x27C
}

// PWM.CLK: PWM Clock Register
func (o *PWM_Type) SetCLK_DIVA(value uint32) {
	volatile.StoreUint32(&o.CLK.Reg, volatile.LoadUint32(&o.CLK.Reg)&^(0xff)|value)
}
func (o *PWM_Type) GetCLK_DIVA() uint32 {
	return volatile.LoadUint32(&o.CLK.Reg) & 0xff
}
func (o *PWM_Type) SetCLK_PREA(value uint32) {
	volatile.StoreUint32(&o.CLK.Reg, volatile.LoadUint32(&o.CLK.Reg)&^(0xf00)|value<<8)
}
func (o *PWM_Type) GetCLK_PREA() uint32 {
	return (volatile.LoadUint32(&o.CLK.Reg) & 0xf00) >> 8
}
func (o *PWM_Type) SetCLK_DIVB(value uint32) {
	volatile.StoreUint32(&o.CLK.Reg, volatile.LoadUint32(&o.CLK.Reg)&^(0xff0000)|value<<16)
}
func (o *PWM_Type) GetCLK_DIVB() uint32 {
	return (volatile.LoadUint32(&o.CLK.Reg) & 0xff0000) >> 16
}
func (o *PWM_Type) SetCLK_PREB(value uint32) {
	volatile.StoreUint32(&o.CLK.Reg, volatile.LoadUint32(&o.CLK.Reg)&^(0xf000000)|value<<24)
}
func (o *PWM_Type) GetCLK_PREB() uint32 {
	return (volatile.LoadUint32(&o.CLK.Reg) & 0xf000000) >> 24
}

// PWM.ENA: PWM Enable Register
func (o *PWM_Type) SetENA_CHID0(value uint32) {
	volatile.StoreUint32(&o.ENA.Reg, volatile.LoadUint32(&o.ENA.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetENA_CHID0() uint32 {
	return volatile.LoadUint32(&o.ENA.Reg) & 0x1
}
func (o *PWM_Type) SetENA_CHID1(value uint32) {
	volatile.StoreUint32(&o.ENA.Reg, volatile.LoadUint32(&o.ENA.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetENA_CHID1() uint32 {
	return (volatile.LoadUint32(&o.ENA.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetENA_CHID2(value uint32) {
	volatile.StoreUint32(&o.ENA.Reg, volatile.LoadUint32(&o.ENA.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetENA_CHID2() uint32 {
	return (volatile.LoadUint32(&o.ENA.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetENA_CHID3(value uint32) {
	volatile.StoreUint32(&o.ENA.Reg, volatile.LoadUint32(&o.ENA.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetENA_CHID3() uint32 {
	return (volatile.LoadUint32(&o.ENA.Reg) & 0x8) >> 3
}

// PWM.DIS: PWM Disable Register
func (o *PWM_Type) SetDIS_CHID0(value uint32) {
	volatile.StoreUint32(&o.DIS.Reg, volatile.LoadUint32(&o.DIS.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetDIS_CHID0() uint32 {
	return volatile.LoadUint32(&o.DIS.Reg) & 0x1
}
func (o *PWM_Type) SetDIS_CHID1(value uint32) {
	volatile.StoreUint32(&o.DIS.Reg, volatile.LoadUint32(&o.DIS.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetDIS_CHID1() uint32 {
	return (volatile.LoadUint32(&o.DIS.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetDIS_CHID2(value uint32) {
	volatile.StoreUint32(&o.DIS.Reg, volatile.LoadUint32(&o.DIS.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetDIS_CHID2() uint32 {
	return (volatile.LoadUint32(&o.DIS.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetDIS_CHID3(value uint32) {
	volatile.StoreUint32(&o.DIS.Reg, volatile.LoadUint32(&o.DIS.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetDIS_CHID3() uint32 {
	return (volatile.LoadUint32(&o.DIS.Reg) & 0x8) >> 3
}

// PWM.SR: PWM Status Register
func (o *PWM_Type) SetSR_CHID0(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetSR_CHID0() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *PWM_Type) SetSR_CHID1(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetSR_CHID1() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetSR_CHID2(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetSR_CHID2() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetSR_CHID3(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetSR_CHID3() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}

// PWM.IER1: PWM Interrupt Enable Register 1
func (o *PWM_Type) SetIER1_CHID0(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetIER1_CHID0() uint32 {
	return volatile.LoadUint32(&o.IER1.Reg) & 0x1
}
func (o *PWM_Type) SetIER1_CHID1(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetIER1_CHID1() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetIER1_CHID2(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetIER1_CHID2() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetIER1_CHID3(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetIER1_CHID3() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetIER1_FCHID0(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetIER1_FCHID0() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetIER1_FCHID1(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetIER1_FCHID1() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetIER1_FCHID2(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetIER1_FCHID2() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x40000) >> 18
}
func (o *PWM_Type) SetIER1_FCHID3(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x80000)|value<<19)
}
func (o *PWM_Type) GetIER1_FCHID3() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x80000) >> 19
}

// PWM.IDR1: PWM Interrupt Disable Register 1
func (o *PWM_Type) SetIDR1_CHID0(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetIDR1_CHID0() uint32 {
	return volatile.LoadUint32(&o.IDR1.Reg) & 0x1
}
func (o *PWM_Type) SetIDR1_CHID1(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetIDR1_CHID1() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetIDR1_CHID2(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetIDR1_CHID2() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetIDR1_CHID3(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetIDR1_CHID3() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetIDR1_FCHID0(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetIDR1_FCHID0() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetIDR1_FCHID1(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetIDR1_FCHID1() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetIDR1_FCHID2(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetIDR1_FCHID2() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x40000) >> 18
}
func (o *PWM_Type) SetIDR1_FCHID3(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x80000)|value<<19)
}
func (o *PWM_Type) GetIDR1_FCHID3() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x80000) >> 19
}

// PWM.IMR1: PWM Interrupt Mask Register 1
func (o *PWM_Type) SetIMR1_CHID0(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetIMR1_CHID0() uint32 {
	return volatile.LoadUint32(&o.IMR1.Reg) & 0x1
}
func (o *PWM_Type) SetIMR1_CHID1(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetIMR1_CHID1() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetIMR1_CHID2(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetIMR1_CHID2() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetIMR1_CHID3(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetIMR1_CHID3() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetIMR1_FCHID0(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetIMR1_FCHID0() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetIMR1_FCHID1(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetIMR1_FCHID1() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetIMR1_FCHID2(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetIMR1_FCHID2() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x40000) >> 18
}
func (o *PWM_Type) SetIMR1_FCHID3(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x80000)|value<<19)
}
func (o *PWM_Type) GetIMR1_FCHID3() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x80000) >> 19
}

// PWM.ISR1: PWM Interrupt Status Register 1
func (o *PWM_Type) SetISR1_CHID0(value uint32) {
	volatile.StoreUint32(&o.ISR1.Reg, volatile.LoadUint32(&o.ISR1.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetISR1_CHID0() uint32 {
	return volatile.LoadUint32(&o.ISR1.Reg) & 0x1
}
func (o *PWM_Type) SetISR1_CHID1(value uint32) {
	volatile.StoreUint32(&o.ISR1.Reg, volatile.LoadUint32(&o.ISR1.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetISR1_CHID1() uint32 {
	return (volatile.LoadUint32(&o.ISR1.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetISR1_CHID2(value uint32) {
	volatile.StoreUint32(&o.ISR1.Reg, volatile.LoadUint32(&o.ISR1.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetISR1_CHID2() uint32 {
	return (volatile.LoadUint32(&o.ISR1.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetISR1_CHID3(value uint32) {
	volatile.StoreUint32(&o.ISR1.Reg, volatile.LoadUint32(&o.ISR1.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetISR1_CHID3() uint32 {
	return (volatile.LoadUint32(&o.ISR1.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetISR1_FCHID0(value uint32) {
	volatile.StoreUint32(&o.ISR1.Reg, volatile.LoadUint32(&o.ISR1.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetISR1_FCHID0() uint32 {
	return (volatile.LoadUint32(&o.ISR1.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetISR1_FCHID1(value uint32) {
	volatile.StoreUint32(&o.ISR1.Reg, volatile.LoadUint32(&o.ISR1.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetISR1_FCHID1() uint32 {
	return (volatile.LoadUint32(&o.ISR1.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetISR1_FCHID2(value uint32) {
	volatile.StoreUint32(&o.ISR1.Reg, volatile.LoadUint32(&o.ISR1.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetISR1_FCHID2() uint32 {
	return (volatile.LoadUint32(&o.ISR1.Reg) & 0x40000) >> 18
}
func (o *PWM_Type) SetISR1_FCHID3(value uint32) {
	volatile.StoreUint32(&o.ISR1.Reg, volatile.LoadUint32(&o.ISR1.Reg)&^(0x80000)|value<<19)
}
func (o *PWM_Type) GetISR1_FCHID3() uint32 {
	return (volatile.LoadUint32(&o.ISR1.Reg) & 0x80000) >> 19
}

// PWM.SCM: PWM Sync Channels Mode Register
func (o *PWM_Type) SetSCM_SYNC0(value uint32) {
	volatile.StoreUint32(&o.SCM.Reg, volatile.LoadUint32(&o.SCM.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetSCM_SYNC0() uint32 {
	return volatile.LoadUint32(&o.SCM.Reg) & 0x1
}
func (o *PWM_Type) SetSCM_SYNC1(value uint32) {
	volatile.StoreUint32(&o.SCM.Reg, volatile.LoadUint32(&o.SCM.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetSCM_SYNC1() uint32 {
	return (volatile.LoadUint32(&o.SCM.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetSCM_SYNC2(value uint32) {
	volatile.StoreUint32(&o.SCM.Reg, volatile.LoadUint32(&o.SCM.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetSCM_SYNC2() uint32 {
	return (volatile.LoadUint32(&o.SCM.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetSCM_SYNC3(value uint32) {
	volatile.StoreUint32(&o.SCM.Reg, volatile.LoadUint32(&o.SCM.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetSCM_SYNC3() uint32 {
	return (volatile.LoadUint32(&o.SCM.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetSCM_UPDM(value uint32) {
	volatile.StoreUint32(&o.SCM.Reg, volatile.LoadUint32(&o.SCM.Reg)&^(0x30000)|value<<16)
}
func (o *PWM_Type) GetSCM_UPDM() uint32 {
	return (volatile.LoadUint32(&o.SCM.Reg) & 0x30000) >> 16
}
func (o *PWM_Type) SetSCM_PTRM(value uint32) {
	volatile.StoreUint32(&o.SCM.Reg, volatile.LoadUint32(&o.SCM.Reg)&^(0x100000)|value<<20)
}
func (o *PWM_Type) GetSCM_PTRM() uint32 {
	return (volatile.LoadUint32(&o.SCM.Reg) & 0x100000) >> 20
}
func (o *PWM_Type) SetSCM_PTRCS(value uint32) {
	volatile.StoreUint32(&o.SCM.Reg, volatile.LoadUint32(&o.SCM.Reg)&^(0xe00000)|value<<21)
}
func (o *PWM_Type) GetSCM_PTRCS() uint32 {
	return (volatile.LoadUint32(&o.SCM.Reg) & 0xe00000) >> 21
}

// PWM.SCUC: PWM Sync Channels Update Control Register
func (o *PWM_Type) SetSCUC_UPDULOCK(value uint32) {
	volatile.StoreUint32(&o.SCUC.Reg, volatile.LoadUint32(&o.SCUC.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetSCUC_UPDULOCK() uint32 {
	return volatile.LoadUint32(&o.SCUC.Reg) & 0x1
}

// PWM.SCUP: PWM Sync Channels Update Period Register
func (o *PWM_Type) SetSCUP_UPR(value uint32) {
	volatile.StoreUint32(&o.SCUP.Reg, volatile.LoadUint32(&o.SCUP.Reg)&^(0xf)|value)
}
func (o *PWM_Type) GetSCUP_UPR() uint32 {
	return volatile.LoadUint32(&o.SCUP.Reg) & 0xf
}
func (o *PWM_Type) SetSCUP_UPRCNT(value uint32) {
	volatile.StoreUint32(&o.SCUP.Reg, volatile.LoadUint32(&o.SCUP.Reg)&^(0xf0)|value<<4)
}
func (o *PWM_Type) GetSCUP_UPRCNT() uint32 {
	return (volatile.LoadUint32(&o.SCUP.Reg) & 0xf0) >> 4
}

// PWM.SCUPUPD: PWM Sync Channels Update Period Update Register
func (o *PWM_Type) SetSCUPUPD_UPRUPD(value uint32) {
	volatile.StoreUint32(&o.SCUPUPD.Reg, volatile.LoadUint32(&o.SCUPUPD.Reg)&^(0xf)|value)
}
func (o *PWM_Type) GetSCUPUPD_UPRUPD() uint32 {
	return volatile.LoadUint32(&o.SCUPUPD.Reg) & 0xf
}

// PWM.IER2: PWM Interrupt Enable Register 2
func (o *PWM_Type) SetIER2_WRDY(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetIER2_WRDY() uint32 {
	return volatile.LoadUint32(&o.IER2.Reg) & 0x1
}
func (o *PWM_Type) SetIER2_ENDTX(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetIER2_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetIER2_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetIER2_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetIER2_UNRE(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetIER2_UNRE() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetIER2_CMPM0(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x100)|value<<8)
}
func (o *PWM_Type) GetIER2_CMPM0() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x100) >> 8
}
func (o *PWM_Type) SetIER2_CMPM1(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x200)|value<<9)
}
func (o *PWM_Type) GetIER2_CMPM1() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x200) >> 9
}
func (o *PWM_Type) SetIER2_CMPM2(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x400)|value<<10)
}
func (o *PWM_Type) GetIER2_CMPM2() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x400) >> 10
}
func (o *PWM_Type) SetIER2_CMPM3(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x800)|value<<11)
}
func (o *PWM_Type) GetIER2_CMPM3() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x800) >> 11
}
func (o *PWM_Type) SetIER2_CMPM4(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x1000)|value<<12)
}
func (o *PWM_Type) GetIER2_CMPM4() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x1000) >> 12
}
func (o *PWM_Type) SetIER2_CMPM5(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x2000)|value<<13)
}
func (o *PWM_Type) GetIER2_CMPM5() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x2000) >> 13
}
func (o *PWM_Type) SetIER2_CMPM6(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x4000)|value<<14)
}
func (o *PWM_Type) GetIER2_CMPM6() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x4000) >> 14
}
func (o *PWM_Type) SetIER2_CMPM7(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x8000)|value<<15)
}
func (o *PWM_Type) GetIER2_CMPM7() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x8000) >> 15
}
func (o *PWM_Type) SetIER2_CMPU0(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetIER2_CMPU0() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetIER2_CMPU1(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetIER2_CMPU1() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetIER2_CMPU2(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetIER2_CMPU2() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x40000) >> 18
}
func (o *PWM_Type) SetIER2_CMPU3(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x80000)|value<<19)
}
func (o *PWM_Type) GetIER2_CMPU3() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x80000) >> 19
}
func (o *PWM_Type) SetIER2_CMPU4(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x100000)|value<<20)
}
func (o *PWM_Type) GetIER2_CMPU4() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x100000) >> 20
}
func (o *PWM_Type) SetIER2_CMPU5(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x200000)|value<<21)
}
func (o *PWM_Type) GetIER2_CMPU5() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x200000) >> 21
}
func (o *PWM_Type) SetIER2_CMPU6(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x400000)|value<<22)
}
func (o *PWM_Type) GetIER2_CMPU6() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x400000) >> 22
}
func (o *PWM_Type) SetIER2_CMPU7(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x800000)|value<<23)
}
func (o *PWM_Type) GetIER2_CMPU7() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x800000) >> 23
}

// PWM.IDR2: PWM Interrupt Disable Register 2
func (o *PWM_Type) SetIDR2_WRDY(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetIDR2_WRDY() uint32 {
	return volatile.LoadUint32(&o.IDR2.Reg) & 0x1
}
func (o *PWM_Type) SetIDR2_ENDTX(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetIDR2_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetIDR2_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetIDR2_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetIDR2_UNRE(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetIDR2_UNRE() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetIDR2_CMPM0(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x100)|value<<8)
}
func (o *PWM_Type) GetIDR2_CMPM0() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x100) >> 8
}
func (o *PWM_Type) SetIDR2_CMPM1(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x200)|value<<9)
}
func (o *PWM_Type) GetIDR2_CMPM1() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x200) >> 9
}
func (o *PWM_Type) SetIDR2_CMPM2(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x400)|value<<10)
}
func (o *PWM_Type) GetIDR2_CMPM2() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x400) >> 10
}
func (o *PWM_Type) SetIDR2_CMPM3(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x800)|value<<11)
}
func (o *PWM_Type) GetIDR2_CMPM3() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x800) >> 11
}
func (o *PWM_Type) SetIDR2_CMPM4(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x1000)|value<<12)
}
func (o *PWM_Type) GetIDR2_CMPM4() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x1000) >> 12
}
func (o *PWM_Type) SetIDR2_CMPM5(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x2000)|value<<13)
}
func (o *PWM_Type) GetIDR2_CMPM5() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x2000) >> 13
}
func (o *PWM_Type) SetIDR2_CMPM6(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x4000)|value<<14)
}
func (o *PWM_Type) GetIDR2_CMPM6() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x4000) >> 14
}
func (o *PWM_Type) SetIDR2_CMPM7(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x8000)|value<<15)
}
func (o *PWM_Type) GetIDR2_CMPM7() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x8000) >> 15
}
func (o *PWM_Type) SetIDR2_CMPU0(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetIDR2_CMPU0() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetIDR2_CMPU1(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetIDR2_CMPU1() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetIDR2_CMPU2(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetIDR2_CMPU2() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x40000) >> 18
}
func (o *PWM_Type) SetIDR2_CMPU3(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x80000)|value<<19)
}
func (o *PWM_Type) GetIDR2_CMPU3() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x80000) >> 19
}
func (o *PWM_Type) SetIDR2_CMPU4(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x100000)|value<<20)
}
func (o *PWM_Type) GetIDR2_CMPU4() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x100000) >> 20
}
func (o *PWM_Type) SetIDR2_CMPU5(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x200000)|value<<21)
}
func (o *PWM_Type) GetIDR2_CMPU5() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x200000) >> 21
}
func (o *PWM_Type) SetIDR2_CMPU6(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x400000)|value<<22)
}
func (o *PWM_Type) GetIDR2_CMPU6() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x400000) >> 22
}
func (o *PWM_Type) SetIDR2_CMPU7(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x800000)|value<<23)
}
func (o *PWM_Type) GetIDR2_CMPU7() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x800000) >> 23
}

// PWM.IMR2: PWM Interrupt Mask Register 2
func (o *PWM_Type) SetIMR2_WRDY(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetIMR2_WRDY() uint32 {
	return volatile.LoadUint32(&o.IMR2.Reg) & 0x1
}
func (o *PWM_Type) SetIMR2_ENDTX(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetIMR2_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetIMR2_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetIMR2_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetIMR2_UNRE(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetIMR2_UNRE() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetIMR2_CMPM0(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x100)|value<<8)
}
func (o *PWM_Type) GetIMR2_CMPM0() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x100) >> 8
}
func (o *PWM_Type) SetIMR2_CMPM1(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x200)|value<<9)
}
func (o *PWM_Type) GetIMR2_CMPM1() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x200) >> 9
}
func (o *PWM_Type) SetIMR2_CMPM2(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x400)|value<<10)
}
func (o *PWM_Type) GetIMR2_CMPM2() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x400) >> 10
}
func (o *PWM_Type) SetIMR2_CMPM3(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x800)|value<<11)
}
func (o *PWM_Type) GetIMR2_CMPM3() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x800) >> 11
}
func (o *PWM_Type) SetIMR2_CMPM4(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x1000)|value<<12)
}
func (o *PWM_Type) GetIMR2_CMPM4() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x1000) >> 12
}
func (o *PWM_Type) SetIMR2_CMPM5(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x2000)|value<<13)
}
func (o *PWM_Type) GetIMR2_CMPM5() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x2000) >> 13
}
func (o *PWM_Type) SetIMR2_CMPM6(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x4000)|value<<14)
}
func (o *PWM_Type) GetIMR2_CMPM6() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x4000) >> 14
}
func (o *PWM_Type) SetIMR2_CMPM7(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x8000)|value<<15)
}
func (o *PWM_Type) GetIMR2_CMPM7() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x8000) >> 15
}
func (o *PWM_Type) SetIMR2_CMPU0(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetIMR2_CMPU0() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetIMR2_CMPU1(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetIMR2_CMPU1() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetIMR2_CMPU2(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetIMR2_CMPU2() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x40000) >> 18
}
func (o *PWM_Type) SetIMR2_CMPU3(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x80000)|value<<19)
}
func (o *PWM_Type) GetIMR2_CMPU3() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x80000) >> 19
}
func (o *PWM_Type) SetIMR2_CMPU4(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x100000)|value<<20)
}
func (o *PWM_Type) GetIMR2_CMPU4() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x100000) >> 20
}
func (o *PWM_Type) SetIMR2_CMPU5(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x200000)|value<<21)
}
func (o *PWM_Type) GetIMR2_CMPU5() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x200000) >> 21
}
func (o *PWM_Type) SetIMR2_CMPU6(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x400000)|value<<22)
}
func (o *PWM_Type) GetIMR2_CMPU6() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x400000) >> 22
}
func (o *PWM_Type) SetIMR2_CMPU7(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x800000)|value<<23)
}
func (o *PWM_Type) GetIMR2_CMPU7() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x800000) >> 23
}

// PWM.ISR2: PWM Interrupt Status Register 2
func (o *PWM_Type) SetISR2_WRDY(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetISR2_WRDY() uint32 {
	return volatile.LoadUint32(&o.ISR2.Reg) & 0x1
}
func (o *PWM_Type) SetISR2_ENDTX(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetISR2_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetISR2_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetISR2_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetISR2_UNRE(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetISR2_UNRE() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetISR2_CMPM0(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x100)|value<<8)
}
func (o *PWM_Type) GetISR2_CMPM0() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x100) >> 8
}
func (o *PWM_Type) SetISR2_CMPM1(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x200)|value<<9)
}
func (o *PWM_Type) GetISR2_CMPM1() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x200) >> 9
}
func (o *PWM_Type) SetISR2_CMPM2(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x400)|value<<10)
}
func (o *PWM_Type) GetISR2_CMPM2() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x400) >> 10
}
func (o *PWM_Type) SetISR2_CMPM3(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x800)|value<<11)
}
func (o *PWM_Type) GetISR2_CMPM3() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x800) >> 11
}
func (o *PWM_Type) SetISR2_CMPM4(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x1000)|value<<12)
}
func (o *PWM_Type) GetISR2_CMPM4() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x1000) >> 12
}
func (o *PWM_Type) SetISR2_CMPM5(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x2000)|value<<13)
}
func (o *PWM_Type) GetISR2_CMPM5() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x2000) >> 13
}
func (o *PWM_Type) SetISR2_CMPM6(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x4000)|value<<14)
}
func (o *PWM_Type) GetISR2_CMPM6() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x4000) >> 14
}
func (o *PWM_Type) SetISR2_CMPM7(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x8000)|value<<15)
}
func (o *PWM_Type) GetISR2_CMPM7() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x8000) >> 15
}
func (o *PWM_Type) SetISR2_CMPU0(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetISR2_CMPU0() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetISR2_CMPU1(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetISR2_CMPU1() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetISR2_CMPU2(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetISR2_CMPU2() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x40000) >> 18
}
func (o *PWM_Type) SetISR2_CMPU3(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x80000)|value<<19)
}
func (o *PWM_Type) GetISR2_CMPU3() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x80000) >> 19
}
func (o *PWM_Type) SetISR2_CMPU4(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x100000)|value<<20)
}
func (o *PWM_Type) GetISR2_CMPU4() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x100000) >> 20
}
func (o *PWM_Type) SetISR2_CMPU5(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x200000)|value<<21)
}
func (o *PWM_Type) GetISR2_CMPU5() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x200000) >> 21
}
func (o *PWM_Type) SetISR2_CMPU6(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x400000)|value<<22)
}
func (o *PWM_Type) GetISR2_CMPU6() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x400000) >> 22
}
func (o *PWM_Type) SetISR2_CMPU7(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x800000)|value<<23)
}
func (o *PWM_Type) GetISR2_CMPU7() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x800000) >> 23
}

// PWM.OOV: PWM Output Override Value Register
func (o *PWM_Type) SetOOV_OOVH0(value uint32) {
	volatile.StoreUint32(&o.OOV.Reg, volatile.LoadUint32(&o.OOV.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetOOV_OOVH0() uint32 {
	return volatile.LoadUint32(&o.OOV.Reg) & 0x1
}
func (o *PWM_Type) SetOOV_OOVH1(value uint32) {
	volatile.StoreUint32(&o.OOV.Reg, volatile.LoadUint32(&o.OOV.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetOOV_OOVH1() uint32 {
	return (volatile.LoadUint32(&o.OOV.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetOOV_OOVH2(value uint32) {
	volatile.StoreUint32(&o.OOV.Reg, volatile.LoadUint32(&o.OOV.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetOOV_OOVH2() uint32 {
	return (volatile.LoadUint32(&o.OOV.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetOOV_OOVH3(value uint32) {
	volatile.StoreUint32(&o.OOV.Reg, volatile.LoadUint32(&o.OOV.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetOOV_OOVH3() uint32 {
	return (volatile.LoadUint32(&o.OOV.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetOOV_OOVL0(value uint32) {
	volatile.StoreUint32(&o.OOV.Reg, volatile.LoadUint32(&o.OOV.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetOOV_OOVL0() uint32 {
	return (volatile.LoadUint32(&o.OOV.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetOOV_OOVL1(value uint32) {
	volatile.StoreUint32(&o.OOV.Reg, volatile.LoadUint32(&o.OOV.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetOOV_OOVL1() uint32 {
	return (volatile.LoadUint32(&o.OOV.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetOOV_OOVL2(value uint32) {
	volatile.StoreUint32(&o.OOV.Reg, volatile.LoadUint32(&o.OOV.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetOOV_OOVL2() uint32 {
	return (volatile.LoadUint32(&o.OOV.Reg) & 0x40000) >> 18
}
func (o *PWM_Type) SetOOV_OOVL3(value uint32) {
	volatile.StoreUint32(&o.OOV.Reg, volatile.LoadUint32(&o.OOV.Reg)&^(0x80000)|value<<19)
}
func (o *PWM_Type) GetOOV_OOVL3() uint32 {
	return (volatile.LoadUint32(&o.OOV.Reg) & 0x80000) >> 19
}

// PWM.OS: PWM Output Selection Register
func (o *PWM_Type) SetOS_OSH0(value uint32) {
	volatile.StoreUint32(&o.OS.Reg, volatile.LoadUint32(&o.OS.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetOS_OSH0() uint32 {
	return volatile.LoadUint32(&o.OS.Reg) & 0x1
}
func (o *PWM_Type) SetOS_OSH1(value uint32) {
	volatile.StoreUint32(&o.OS.Reg, volatile.LoadUint32(&o.OS.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetOS_OSH1() uint32 {
	return (volatile.LoadUint32(&o.OS.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetOS_OSH2(value uint32) {
	volatile.StoreUint32(&o.OS.Reg, volatile.LoadUint32(&o.OS.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetOS_OSH2() uint32 {
	return (volatile.LoadUint32(&o.OS.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetOS_OSH3(value uint32) {
	volatile.StoreUint32(&o.OS.Reg, volatile.LoadUint32(&o.OS.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetOS_OSH3() uint32 {
	return (volatile.LoadUint32(&o.OS.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetOS_OSL0(value uint32) {
	volatile.StoreUint32(&o.OS.Reg, volatile.LoadUint32(&o.OS.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetOS_OSL0() uint32 {
	return (volatile.LoadUint32(&o.OS.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetOS_OSL1(value uint32) {
	volatile.StoreUint32(&o.OS.Reg, volatile.LoadUint32(&o.OS.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetOS_OSL1() uint32 {
	return (volatile.LoadUint32(&o.OS.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetOS_OSL2(value uint32) {
	volatile.StoreUint32(&o.OS.Reg, volatile.LoadUint32(&o.OS.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetOS_OSL2() uint32 {
	return (volatile.LoadUint32(&o.OS.Reg) & 0x40000) >> 18
}
func (o *PWM_Type) SetOS_OSL3(value uint32) {
	volatile.StoreUint32(&o.OS.Reg, volatile.LoadUint32(&o.OS.Reg)&^(0x80000)|value<<19)
}
func (o *PWM_Type) GetOS_OSL3() uint32 {
	return (volatile.LoadUint32(&o.OS.Reg) & 0x80000) >> 19
}

// PWM.OSS: PWM Output Selection Set Register
func (o *PWM_Type) SetOSS_OSSH0(value uint32) {
	volatile.StoreUint32(&o.OSS.Reg, volatile.LoadUint32(&o.OSS.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetOSS_OSSH0() uint32 {
	return volatile.LoadUint32(&o.OSS.Reg) & 0x1
}
func (o *PWM_Type) SetOSS_OSSH1(value uint32) {
	volatile.StoreUint32(&o.OSS.Reg, volatile.LoadUint32(&o.OSS.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetOSS_OSSH1() uint32 {
	return (volatile.LoadUint32(&o.OSS.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetOSS_OSSH2(value uint32) {
	volatile.StoreUint32(&o.OSS.Reg, volatile.LoadUint32(&o.OSS.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetOSS_OSSH2() uint32 {
	return (volatile.LoadUint32(&o.OSS.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetOSS_OSSH3(value uint32) {
	volatile.StoreUint32(&o.OSS.Reg, volatile.LoadUint32(&o.OSS.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetOSS_OSSH3() uint32 {
	return (volatile.LoadUint32(&o.OSS.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetOSS_OSSL0(value uint32) {
	volatile.StoreUint32(&o.OSS.Reg, volatile.LoadUint32(&o.OSS.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetOSS_OSSL0() uint32 {
	return (volatile.LoadUint32(&o.OSS.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetOSS_OSSL1(value uint32) {
	volatile.StoreUint32(&o.OSS.Reg, volatile.LoadUint32(&o.OSS.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetOSS_OSSL1() uint32 {
	return (volatile.LoadUint32(&o.OSS.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetOSS_OSSL2(value uint32) {
	volatile.StoreUint32(&o.OSS.Reg, volatile.LoadUint32(&o.OSS.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetOSS_OSSL2() uint32 {
	return (volatile.LoadUint32(&o.OSS.Reg) & 0x40000) >> 18
}
func (o *PWM_Type) SetOSS_OSSL3(value uint32) {
	volatile.StoreUint32(&o.OSS.Reg, volatile.LoadUint32(&o.OSS.Reg)&^(0x80000)|value<<19)
}
func (o *PWM_Type) GetOSS_OSSL3() uint32 {
	return (volatile.LoadUint32(&o.OSS.Reg) & 0x80000) >> 19
}

// PWM.OSC: PWM Output Selection Clear Register
func (o *PWM_Type) SetOSC_OSCH0(value uint32) {
	volatile.StoreUint32(&o.OSC.Reg, volatile.LoadUint32(&o.OSC.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetOSC_OSCH0() uint32 {
	return volatile.LoadUint32(&o.OSC.Reg) & 0x1
}
func (o *PWM_Type) SetOSC_OSCH1(value uint32) {
	volatile.StoreUint32(&o.OSC.Reg, volatile.LoadUint32(&o.OSC.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetOSC_OSCH1() uint32 {
	return (volatile.LoadUint32(&o.OSC.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetOSC_OSCH2(value uint32) {
	volatile.StoreUint32(&o.OSC.Reg, volatile.LoadUint32(&o.OSC.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetOSC_OSCH2() uint32 {
	return (volatile.LoadUint32(&o.OSC.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetOSC_OSCH3(value uint32) {
	volatile.StoreUint32(&o.OSC.Reg, volatile.LoadUint32(&o.OSC.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetOSC_OSCH3() uint32 {
	return (volatile.LoadUint32(&o.OSC.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetOSC_OSCL0(value uint32) {
	volatile.StoreUint32(&o.OSC.Reg, volatile.LoadUint32(&o.OSC.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetOSC_OSCL0() uint32 {
	return (volatile.LoadUint32(&o.OSC.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetOSC_OSCL1(value uint32) {
	volatile.StoreUint32(&o.OSC.Reg, volatile.LoadUint32(&o.OSC.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetOSC_OSCL1() uint32 {
	return (volatile.LoadUint32(&o.OSC.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetOSC_OSCL2(value uint32) {
	volatile.StoreUint32(&o.OSC.Reg, volatile.LoadUint32(&o.OSC.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetOSC_OSCL2() uint32 {
	return (volatile.LoadUint32(&o.OSC.Reg) & 0x40000) >> 18
}
func (o *PWM_Type) SetOSC_OSCL3(value uint32) {
	volatile.StoreUint32(&o.OSC.Reg, volatile.LoadUint32(&o.OSC.Reg)&^(0x80000)|value<<19)
}
func (o *PWM_Type) GetOSC_OSCL3() uint32 {
	return (volatile.LoadUint32(&o.OSC.Reg) & 0x80000) >> 19
}

// PWM.OSSUPD: PWM Output Selection Set Update Register
func (o *PWM_Type) SetOSSUPD_OSSUPH0(value uint32) {
	volatile.StoreUint32(&o.OSSUPD.Reg, volatile.LoadUint32(&o.OSSUPD.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetOSSUPD_OSSUPH0() uint32 {
	return volatile.LoadUint32(&o.OSSUPD.Reg) & 0x1
}
func (o *PWM_Type) SetOSSUPD_OSSUPH1(value uint32) {
	volatile.StoreUint32(&o.OSSUPD.Reg, volatile.LoadUint32(&o.OSSUPD.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetOSSUPD_OSSUPH1() uint32 {
	return (volatile.LoadUint32(&o.OSSUPD.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetOSSUPD_OSSUPH2(value uint32) {
	volatile.StoreUint32(&o.OSSUPD.Reg, volatile.LoadUint32(&o.OSSUPD.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetOSSUPD_OSSUPH2() uint32 {
	return (volatile.LoadUint32(&o.OSSUPD.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetOSSUPD_OSSUPH3(value uint32) {
	volatile.StoreUint32(&o.OSSUPD.Reg, volatile.LoadUint32(&o.OSSUPD.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetOSSUPD_OSSUPH3() uint32 {
	return (volatile.LoadUint32(&o.OSSUPD.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetOSSUPD_OSSUPL0(value uint32) {
	volatile.StoreUint32(&o.OSSUPD.Reg, volatile.LoadUint32(&o.OSSUPD.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetOSSUPD_OSSUPL0() uint32 {
	return (volatile.LoadUint32(&o.OSSUPD.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetOSSUPD_OSSUPL1(value uint32) {
	volatile.StoreUint32(&o.OSSUPD.Reg, volatile.LoadUint32(&o.OSSUPD.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetOSSUPD_OSSUPL1() uint32 {
	return (volatile.LoadUint32(&o.OSSUPD.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetOSSUPD_OSSUPL2(value uint32) {
	volatile.StoreUint32(&o.OSSUPD.Reg, volatile.LoadUint32(&o.OSSUPD.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetOSSUPD_OSSUPL2() uint32 {
	return (volatile.LoadUint32(&o.OSSUPD.Reg) & 0x40000) >> 18
}
func (o *PWM_Type) SetOSSUPD_OSSUPL3(value uint32) {
	volatile.StoreUint32(&o.OSSUPD.Reg, volatile.LoadUint32(&o.OSSUPD.Reg)&^(0x80000)|value<<19)
}
func (o *PWM_Type) GetOSSUPD_OSSUPL3() uint32 {
	return (volatile.LoadUint32(&o.OSSUPD.Reg) & 0x80000) >> 19
}

// PWM.OSCUPD: PWM Output Selection Clear Update Register
func (o *PWM_Type) SetOSCUPD_OSCUPH0(value uint32) {
	volatile.StoreUint32(&o.OSCUPD.Reg, volatile.LoadUint32(&o.OSCUPD.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetOSCUPD_OSCUPH0() uint32 {
	return volatile.LoadUint32(&o.OSCUPD.Reg) & 0x1
}
func (o *PWM_Type) SetOSCUPD_OSCUPH1(value uint32) {
	volatile.StoreUint32(&o.OSCUPD.Reg, volatile.LoadUint32(&o.OSCUPD.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetOSCUPD_OSCUPH1() uint32 {
	return (volatile.LoadUint32(&o.OSCUPD.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetOSCUPD_OSCUPH2(value uint32) {
	volatile.StoreUint32(&o.OSCUPD.Reg, volatile.LoadUint32(&o.OSCUPD.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetOSCUPD_OSCUPH2() uint32 {
	return (volatile.LoadUint32(&o.OSCUPD.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetOSCUPD_OSCUPH3(value uint32) {
	volatile.StoreUint32(&o.OSCUPD.Reg, volatile.LoadUint32(&o.OSCUPD.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetOSCUPD_OSCUPH3() uint32 {
	return (volatile.LoadUint32(&o.OSCUPD.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetOSCUPD_OSCUPL0(value uint32) {
	volatile.StoreUint32(&o.OSCUPD.Reg, volatile.LoadUint32(&o.OSCUPD.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetOSCUPD_OSCUPL0() uint32 {
	return (volatile.LoadUint32(&o.OSCUPD.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetOSCUPD_OSCUPL1(value uint32) {
	volatile.StoreUint32(&o.OSCUPD.Reg, volatile.LoadUint32(&o.OSCUPD.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetOSCUPD_OSCUPL1() uint32 {
	return (volatile.LoadUint32(&o.OSCUPD.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetOSCUPD_OSCUPL2(value uint32) {
	volatile.StoreUint32(&o.OSCUPD.Reg, volatile.LoadUint32(&o.OSCUPD.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetOSCUPD_OSCUPL2() uint32 {
	return (volatile.LoadUint32(&o.OSCUPD.Reg) & 0x40000) >> 18
}
func (o *PWM_Type) SetOSCUPD_OSCUPL3(value uint32) {
	volatile.StoreUint32(&o.OSCUPD.Reg, volatile.LoadUint32(&o.OSCUPD.Reg)&^(0x80000)|value<<19)
}
func (o *PWM_Type) GetOSCUPD_OSCUPL3() uint32 {
	return (volatile.LoadUint32(&o.OSCUPD.Reg) & 0x80000) >> 19
}

// PWM.FMR: PWM Fault Mode Register
func (o *PWM_Type) SetFMR_FPOL(value uint32) {
	volatile.StoreUint32(&o.FMR.Reg, volatile.LoadUint32(&o.FMR.Reg)&^(0xff)|value)
}
func (o *PWM_Type) GetFMR_FPOL() uint32 {
	return volatile.LoadUint32(&o.FMR.Reg) & 0xff
}
func (o *PWM_Type) SetFMR_FMOD(value uint32) {
	volatile.StoreUint32(&o.FMR.Reg, volatile.LoadUint32(&o.FMR.Reg)&^(0xff00)|value<<8)
}
func (o *PWM_Type) GetFMR_FMOD() uint32 {
	return (volatile.LoadUint32(&o.FMR.Reg) & 0xff00) >> 8
}
func (o *PWM_Type) SetFMR_FFIL(value uint32) {
	volatile.StoreUint32(&o.FMR.Reg, volatile.LoadUint32(&o.FMR.Reg)&^(0xff0000)|value<<16)
}
func (o *PWM_Type) GetFMR_FFIL() uint32 {
	return (volatile.LoadUint32(&o.FMR.Reg) & 0xff0000) >> 16
}

// PWM.FSR: PWM Fault Status Register
func (o *PWM_Type) SetFSR_FIV(value uint32) {
	volatile.StoreUint32(&o.FSR.Reg, volatile.LoadUint32(&o.FSR.Reg)&^(0xff)|value)
}
func (o *PWM_Type) GetFSR_FIV() uint32 {
	return volatile.LoadUint32(&o.FSR.Reg) & 0xff
}
func (o *PWM_Type) SetFSR_FS(value uint32) {
	volatile.StoreUint32(&o.FSR.Reg, volatile.LoadUint32(&o.FSR.Reg)&^(0xff00)|value<<8)
}
func (o *PWM_Type) GetFSR_FS() uint32 {
	return (volatile.LoadUint32(&o.FSR.Reg) & 0xff00) >> 8
}

// PWM.FCR: PWM Fault Clear Register
func (o *PWM_Type) SetFCR_FCLR(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0xff)|value)
}
func (o *PWM_Type) GetFCR_FCLR() uint32 {
	return volatile.LoadUint32(&o.FCR.Reg) & 0xff
}

// PWM.FPV: PWM Fault Protection Value Register
func (o *PWM_Type) SetFPV_FPVH0(value uint32) {
	volatile.StoreUint32(&o.FPV.Reg, volatile.LoadUint32(&o.FPV.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetFPV_FPVH0() uint32 {
	return volatile.LoadUint32(&o.FPV.Reg) & 0x1
}
func (o *PWM_Type) SetFPV_FPVH1(value uint32) {
	volatile.StoreUint32(&o.FPV.Reg, volatile.LoadUint32(&o.FPV.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetFPV_FPVH1() uint32 {
	return (volatile.LoadUint32(&o.FPV.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetFPV_FPVH2(value uint32) {
	volatile.StoreUint32(&o.FPV.Reg, volatile.LoadUint32(&o.FPV.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetFPV_FPVH2() uint32 {
	return (volatile.LoadUint32(&o.FPV.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetFPV_FPVH3(value uint32) {
	volatile.StoreUint32(&o.FPV.Reg, volatile.LoadUint32(&o.FPV.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetFPV_FPVH3() uint32 {
	return (volatile.LoadUint32(&o.FPV.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetFPV_FPVL0(value uint32) {
	volatile.StoreUint32(&o.FPV.Reg, volatile.LoadUint32(&o.FPV.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetFPV_FPVL0() uint32 {
	return (volatile.LoadUint32(&o.FPV.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetFPV_FPVL1(value uint32) {
	volatile.StoreUint32(&o.FPV.Reg, volatile.LoadUint32(&o.FPV.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetFPV_FPVL1() uint32 {
	return (volatile.LoadUint32(&o.FPV.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetFPV_FPVL2(value uint32) {
	volatile.StoreUint32(&o.FPV.Reg, volatile.LoadUint32(&o.FPV.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetFPV_FPVL2() uint32 {
	return (volatile.LoadUint32(&o.FPV.Reg) & 0x40000) >> 18
}
func (o *PWM_Type) SetFPV_FPVL3(value uint32) {
	volatile.StoreUint32(&o.FPV.Reg, volatile.LoadUint32(&o.FPV.Reg)&^(0x80000)|value<<19)
}
func (o *PWM_Type) GetFPV_FPVL3() uint32 {
	return (volatile.LoadUint32(&o.FPV.Reg) & 0x80000) >> 19
}

// PWM.FPE: PWM Fault Protection Enable Register
func (o *PWM_Type) SetFPE_FPE0(value uint32) {
	volatile.StoreUint32(&o.FPE.Reg, volatile.LoadUint32(&o.FPE.Reg)&^(0xff)|value)
}
func (o *PWM_Type) GetFPE_FPE0() uint32 {
	return volatile.LoadUint32(&o.FPE.Reg) & 0xff
}
func (o *PWM_Type) SetFPE_FPE1(value uint32) {
	volatile.StoreUint32(&o.FPE.Reg, volatile.LoadUint32(&o.FPE.Reg)&^(0xff00)|value<<8)
}
func (o *PWM_Type) GetFPE_FPE1() uint32 {
	return (volatile.LoadUint32(&o.FPE.Reg) & 0xff00) >> 8
}
func (o *PWM_Type) SetFPE_FPE2(value uint32) {
	volatile.StoreUint32(&o.FPE.Reg, volatile.LoadUint32(&o.FPE.Reg)&^(0xff0000)|value<<16)
}
func (o *PWM_Type) GetFPE_FPE2() uint32 {
	return (volatile.LoadUint32(&o.FPE.Reg) & 0xff0000) >> 16
}
func (o *PWM_Type) SetFPE_FPE3(value uint32) {
	volatile.StoreUint32(&o.FPE.Reg, volatile.LoadUint32(&o.FPE.Reg)&^(0xff000000)|value<<24)
}
func (o *PWM_Type) GetFPE_FPE3() uint32 {
	return (volatile.LoadUint32(&o.FPE.Reg) & 0xff000000) >> 24
}

// PWM.ELMR: PWM Event Line 0 Mode Register
func (o *PWM_Type) SetELMR_CSEL0(idx int, value uint32) {
	volatile.StoreUint32(&o.ELMR[idx].Reg, volatile.LoadUint32(&o.ELMR[idx].Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetELMR_CSEL0(idx int) uint32 {
	return volatile.LoadUint32(&o.ELMR[idx].Reg) & 0x1
}
func (o *PWM_Type) SetELMR_CSEL1(idx int, value uint32) {
	volatile.StoreUint32(&o.ELMR[idx].Reg, volatile.LoadUint32(&o.ELMR[idx].Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetELMR_CSEL1(idx int) uint32 {
	return (volatile.LoadUint32(&o.ELMR[idx].Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetELMR_CSEL2(idx int, value uint32) {
	volatile.StoreUint32(&o.ELMR[idx].Reg, volatile.LoadUint32(&o.ELMR[idx].Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetELMR_CSEL2(idx int) uint32 {
	return (volatile.LoadUint32(&o.ELMR[idx].Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetELMR_CSEL3(idx int, value uint32) {
	volatile.StoreUint32(&o.ELMR[idx].Reg, volatile.LoadUint32(&o.ELMR[idx].Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetELMR_CSEL3(idx int) uint32 {
	return (volatile.LoadUint32(&o.ELMR[idx].Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetELMR_CSEL4(idx int, value uint32) {
	volatile.StoreUint32(&o.ELMR[idx].Reg, volatile.LoadUint32(&o.ELMR[idx].Reg)&^(0x10)|value<<4)
}
func (o *PWM_Type) GetELMR_CSEL4(idx int) uint32 {
	return (volatile.LoadUint32(&o.ELMR[idx].Reg) & 0x10) >> 4
}
func (o *PWM_Type) SetELMR_CSEL5(idx int, value uint32) {
	volatile.StoreUint32(&o.ELMR[idx].Reg, volatile.LoadUint32(&o.ELMR[idx].Reg)&^(0x20)|value<<5)
}
func (o *PWM_Type) GetELMR_CSEL5(idx int) uint32 {
	return (volatile.LoadUint32(&o.ELMR[idx].Reg) & 0x20) >> 5
}
func (o *PWM_Type) SetELMR_CSEL6(idx int, value uint32) {
	volatile.StoreUint32(&o.ELMR[idx].Reg, volatile.LoadUint32(&o.ELMR[idx].Reg)&^(0x40)|value<<6)
}
func (o *PWM_Type) GetELMR_CSEL6(idx int) uint32 {
	return (volatile.LoadUint32(&o.ELMR[idx].Reg) & 0x40) >> 6
}
func (o *PWM_Type) SetELMR_CSEL7(idx int, value uint32) {
	volatile.StoreUint32(&o.ELMR[idx].Reg, volatile.LoadUint32(&o.ELMR[idx].Reg)&^(0x80)|value<<7)
}
func (o *PWM_Type) GetELMR_CSEL7(idx int) uint32 {
	return (volatile.LoadUint32(&o.ELMR[idx].Reg) & 0x80) >> 7
}

// PWM.SMMR: PWM Stepper Motor Mode Register
func (o *PWM_Type) SetSMMR_GCEN0(value uint32) {
	volatile.StoreUint32(&o.SMMR.Reg, volatile.LoadUint32(&o.SMMR.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetSMMR_GCEN0() uint32 {
	return volatile.LoadUint32(&o.SMMR.Reg) & 0x1
}
func (o *PWM_Type) SetSMMR_GCEN1(value uint32) {
	volatile.StoreUint32(&o.SMMR.Reg, volatile.LoadUint32(&o.SMMR.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetSMMR_GCEN1() uint32 {
	return (volatile.LoadUint32(&o.SMMR.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetSMMR_DOWN0(value uint32) {
	volatile.StoreUint32(&o.SMMR.Reg, volatile.LoadUint32(&o.SMMR.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetSMMR_DOWN0() uint32 {
	return (volatile.LoadUint32(&o.SMMR.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetSMMR_DOWN1(value uint32) {
	volatile.StoreUint32(&o.SMMR.Reg, volatile.LoadUint32(&o.SMMR.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetSMMR_DOWN1() uint32 {
	return (volatile.LoadUint32(&o.SMMR.Reg) & 0x20000) >> 17
}

// PWM.WPCR: PWM Write Protection Control Register
func (o *PWM_Type) SetWPCR_WPCMD(value uint32) {
	volatile.StoreUint32(&o.WPCR.Reg, volatile.LoadUint32(&o.WPCR.Reg)&^(0x3)|value)
}
func (o *PWM_Type) GetWPCR_WPCMD() uint32 {
	return volatile.LoadUint32(&o.WPCR.Reg) & 0x3
}
func (o *PWM_Type) SetWPCR_WPRG0(value uint32) {
	volatile.StoreUint32(&o.WPCR.Reg, volatile.LoadUint32(&o.WPCR.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetWPCR_WPRG0() uint32 {
	return (volatile.LoadUint32(&o.WPCR.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetWPCR_WPRG1(value uint32) {
	volatile.StoreUint32(&o.WPCR.Reg, volatile.LoadUint32(&o.WPCR.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetWPCR_WPRG1() uint32 {
	return (volatile.LoadUint32(&o.WPCR.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetWPCR_WPRG2(value uint32) {
	volatile.StoreUint32(&o.WPCR.Reg, volatile.LoadUint32(&o.WPCR.Reg)&^(0x10)|value<<4)
}
func (o *PWM_Type) GetWPCR_WPRG2() uint32 {
	return (volatile.LoadUint32(&o.WPCR.Reg) & 0x10) >> 4
}
func (o *PWM_Type) SetWPCR_WPRG3(value uint32) {
	volatile.StoreUint32(&o.WPCR.Reg, volatile.LoadUint32(&o.WPCR.Reg)&^(0x20)|value<<5)
}
func (o *PWM_Type) GetWPCR_WPRG3() uint32 {
	return (volatile.LoadUint32(&o.WPCR.Reg) & 0x20) >> 5
}
func (o *PWM_Type) SetWPCR_WPRG4(value uint32) {
	volatile.StoreUint32(&o.WPCR.Reg, volatile.LoadUint32(&o.WPCR.Reg)&^(0x40)|value<<6)
}
func (o *PWM_Type) GetWPCR_WPRG4() uint32 {
	return (volatile.LoadUint32(&o.WPCR.Reg) & 0x40) >> 6
}
func (o *PWM_Type) SetWPCR_WPRG5(value uint32) {
	volatile.StoreUint32(&o.WPCR.Reg, volatile.LoadUint32(&o.WPCR.Reg)&^(0x80)|value<<7)
}
func (o *PWM_Type) GetWPCR_WPRG5() uint32 {
	return (volatile.LoadUint32(&o.WPCR.Reg) & 0x80) >> 7
}
func (o *PWM_Type) SetWPCR_WPKEY(value uint32) {
	volatile.StoreUint32(&o.WPCR.Reg, volatile.LoadUint32(&o.WPCR.Reg)&^(0xffffff00)|value<<8)
}
func (o *PWM_Type) GetWPCR_WPKEY() uint32 {
	return (volatile.LoadUint32(&o.WPCR.Reg) & 0xffffff00) >> 8
}

// PWM.WPSR: PWM Write Protection Status Register
func (o *PWM_Type) SetWPSR_WPSWS0(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetWPSR_WPSWS0() uint32 {
	return volatile.LoadUint32(&o.WPSR.Reg) & 0x1
}
func (o *PWM_Type) SetWPSR_WPSWS1(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetWPSR_WPSWS1() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetWPSR_WPSWS2(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetWPSR_WPSWS2() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetWPSR_WPSWS3(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetWPSR_WPSWS3() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetWPSR_WPSWS4(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x10)|value<<4)
}
func (o *PWM_Type) GetWPSR_WPSWS4() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0x10) >> 4
}
func (o *PWM_Type) SetWPSR_WPSWS5(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x20)|value<<5)
}
func (o *PWM_Type) GetWPSR_WPSWS5() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0x20) >> 5
}
func (o *PWM_Type) SetWPSR_WPVS(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x80)|value<<7)
}
func (o *PWM_Type) GetWPSR_WPVS() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0x80) >> 7
}
func (o *PWM_Type) SetWPSR_WPHWS0(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x100)|value<<8)
}
func (o *PWM_Type) GetWPSR_WPHWS0() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0x100) >> 8
}
func (o *PWM_Type) SetWPSR_WPHWS1(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x200)|value<<9)
}
func (o *PWM_Type) GetWPSR_WPHWS1() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0x200) >> 9
}
func (o *PWM_Type) SetWPSR_WPHWS2(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x400)|value<<10)
}
func (o *PWM_Type) GetWPSR_WPHWS2() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0x400) >> 10
}
func (o *PWM_Type) SetWPSR_WPHWS3(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x800)|value<<11)
}
func (o *PWM_Type) GetWPSR_WPHWS3() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0x800) >> 11
}
func (o *PWM_Type) SetWPSR_WPHWS4(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x1000)|value<<12)
}
func (o *PWM_Type) GetWPSR_WPHWS4() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0x1000) >> 12
}
func (o *PWM_Type) SetWPSR_WPHWS5(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x2000)|value<<13)
}
func (o *PWM_Type) GetWPSR_WPHWS5() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0x2000) >> 13
}
func (o *PWM_Type) SetWPSR_WPVSRC(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0xffff0000)|value<<16)
}
func (o *PWM_Type) GetWPSR_WPVSRC() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0xffff0000) >> 16
}

// PWM.TPR: Transmit Pointer Register
func (o *PWM_Type) SetTPR(value uint32) {
	volatile.StoreUint32(&o.TPR.Reg, value)
}
func (o *PWM_Type) GetTPR() uint32 {
	return volatile.LoadUint32(&o.TPR.Reg)
}

// PWM.TCR: Transmit Counter Register
func (o *PWM_Type) SetTCR_TXCTR(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0xffff)|value)
}
func (o *PWM_Type) GetTCR_TXCTR() uint32 {
	return volatile.LoadUint32(&o.TCR.Reg) & 0xffff
}

// PWM.TNPR: Transmit Next Pointer Register
func (o *PWM_Type) SetTNPR(value uint32) {
	volatile.StoreUint32(&o.TNPR.Reg, value)
}
func (o *PWM_Type) GetTNPR() uint32 {
	return volatile.LoadUint32(&o.TNPR.Reg)
}

// PWM.TNCR: Transmit Next Counter Register
func (o *PWM_Type) SetTNCR_TXNCTR(value uint32) {
	volatile.StoreUint32(&o.TNCR.Reg, volatile.LoadUint32(&o.TNCR.Reg)&^(0xffff)|value)
}
func (o *PWM_Type) GetTNCR_TXNCTR() uint32 {
	return volatile.LoadUint32(&o.TNCR.Reg) & 0xffff
}

// PWM.PTCR: Transfer Control Register
func (o *PWM_Type) SetPTCR_RXTEN(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetPTCR_RXTEN() uint32 {
	return volatile.LoadUint32(&o.PTCR.Reg) & 0x1
}
func (o *PWM_Type) SetPTCR_RXTDIS(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetPTCR_RXTDIS() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetPTCR_TXTEN(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x100)|value<<8)
}
func (o *PWM_Type) GetPTCR_TXTEN() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x100) >> 8
}
func (o *PWM_Type) SetPTCR_TXTDIS(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x200)|value<<9)
}
func (o *PWM_Type) GetPTCR_TXTDIS() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x200) >> 9
}

// PWM.PTSR: Transfer Status Register
func (o *PWM_Type) SetPTSR_RXTEN(value uint32) {
	volatile.StoreUint32(&o.PTSR.Reg, volatile.LoadUint32(&o.PTSR.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetPTSR_RXTEN() uint32 {
	return volatile.LoadUint32(&o.PTSR.Reg) & 0x1
}
func (o *PWM_Type) SetPTSR_TXTEN(value uint32) {
	volatile.StoreUint32(&o.PTSR.Reg, volatile.LoadUint32(&o.PTSR.Reg)&^(0x100)|value<<8)
}
func (o *PWM_Type) GetPTSR_TXTEN() uint32 {
	return (volatile.LoadUint32(&o.PTSR.Reg) & 0x100) >> 8
}

// PWM.CMPV0: PWM Comparison 0 Value Register
func (o *PWM_Type) SetCMPV0_CV(value uint32) {
	volatile.StoreUint32(&o.CMPV0.Reg, volatile.LoadUint32(&o.CMPV0.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCMPV0_CV() uint32 {
	return volatile.LoadUint32(&o.CMPV0.Reg) & 0xffffff
}
func (o *PWM_Type) SetCMPV0_CVM(value uint32) {
	volatile.StoreUint32(&o.CMPV0.Reg, volatile.LoadUint32(&o.CMPV0.Reg)&^(0x1000000)|value<<24)
}
func (o *PWM_Type) GetCMPV0_CVM() uint32 {
	return (volatile.LoadUint32(&o.CMPV0.Reg) & 0x1000000) >> 24
}

// PWM.CMPVUPD0: PWM Comparison 0 Value Update Register
func (o *PWM_Type) SetCMPVUPD0_CVUPD(value uint32) {
	volatile.StoreUint32(&o.CMPVUPD0.Reg, volatile.LoadUint32(&o.CMPVUPD0.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCMPVUPD0_CVUPD() uint32 {
	return volatile.LoadUint32(&o.CMPVUPD0.Reg) & 0xffffff
}
func (o *PWM_Type) SetCMPVUPD0_CVMUPD(value uint32) {
	volatile.StoreUint32(&o.CMPVUPD0.Reg, volatile.LoadUint32(&o.CMPVUPD0.Reg)&^(0x1000000)|value<<24)
}
func (o *PWM_Type) GetCMPVUPD0_CVMUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPVUPD0.Reg) & 0x1000000) >> 24
}

// PWM.CMPM0: PWM Comparison 0 Mode Register
func (o *PWM_Type) SetCMPM0_CEN(value uint32) {
	volatile.StoreUint32(&o.CMPM0.Reg, volatile.LoadUint32(&o.CMPM0.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetCMPM0_CEN() uint32 {
	return volatile.LoadUint32(&o.CMPM0.Reg) & 0x1
}
func (o *PWM_Type) SetCMPM0_CTR(value uint32) {
	volatile.StoreUint32(&o.CMPM0.Reg, volatile.LoadUint32(&o.CMPM0.Reg)&^(0xf0)|value<<4)
}
func (o *PWM_Type) GetCMPM0_CTR() uint32 {
	return (volatile.LoadUint32(&o.CMPM0.Reg) & 0xf0) >> 4
}
func (o *PWM_Type) SetCMPM0_CPR(value uint32) {
	volatile.StoreUint32(&o.CMPM0.Reg, volatile.LoadUint32(&o.CMPM0.Reg)&^(0xf00)|value<<8)
}
func (o *PWM_Type) GetCMPM0_CPR() uint32 {
	return (volatile.LoadUint32(&o.CMPM0.Reg) & 0xf00) >> 8
}
func (o *PWM_Type) SetCMPM0_CPRCNT(value uint32) {
	volatile.StoreUint32(&o.CMPM0.Reg, volatile.LoadUint32(&o.CMPM0.Reg)&^(0xf000)|value<<12)
}
func (o *PWM_Type) GetCMPM0_CPRCNT() uint32 {
	return (volatile.LoadUint32(&o.CMPM0.Reg) & 0xf000) >> 12
}
func (o *PWM_Type) SetCMPM0_CUPR(value uint32) {
	volatile.StoreUint32(&o.CMPM0.Reg, volatile.LoadUint32(&o.CMPM0.Reg)&^(0xf0000)|value<<16)
}
func (o *PWM_Type) GetCMPM0_CUPR() uint32 {
	return (volatile.LoadUint32(&o.CMPM0.Reg) & 0xf0000) >> 16
}
func (o *PWM_Type) SetCMPM0_CUPRCNT(value uint32) {
	volatile.StoreUint32(&o.CMPM0.Reg, volatile.LoadUint32(&o.CMPM0.Reg)&^(0xf00000)|value<<20)
}
func (o *PWM_Type) GetCMPM0_CUPRCNT() uint32 {
	return (volatile.LoadUint32(&o.CMPM0.Reg) & 0xf00000) >> 20
}

// PWM.CMPMUPD0: PWM Comparison 0 Mode Update Register
func (o *PWM_Type) SetCMPMUPD0_CENUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD0.Reg, volatile.LoadUint32(&o.CMPMUPD0.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetCMPMUPD0_CENUPD() uint32 {
	return volatile.LoadUint32(&o.CMPMUPD0.Reg) & 0x1
}
func (o *PWM_Type) SetCMPMUPD0_CTRUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD0.Reg, volatile.LoadUint32(&o.CMPMUPD0.Reg)&^(0xf0)|value<<4)
}
func (o *PWM_Type) GetCMPMUPD0_CTRUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPMUPD0.Reg) & 0xf0) >> 4
}
func (o *PWM_Type) SetCMPMUPD0_CPRUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD0.Reg, volatile.LoadUint32(&o.CMPMUPD0.Reg)&^(0xf00)|value<<8)
}
func (o *PWM_Type) GetCMPMUPD0_CPRUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPMUPD0.Reg) & 0xf00) >> 8
}
func (o *PWM_Type) SetCMPMUPD0_CUPRUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD0.Reg, volatile.LoadUint32(&o.CMPMUPD0.Reg)&^(0xf0000)|value<<16)
}
func (o *PWM_Type) GetCMPMUPD0_CUPRUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPMUPD0.Reg) & 0xf0000) >> 16
}

// PWM.CMPV1: PWM Comparison 1 Value Register
func (o *PWM_Type) SetCMPV1_CV(value uint32) {
	volatile.StoreUint32(&o.CMPV1.Reg, volatile.LoadUint32(&o.CMPV1.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCMPV1_CV() uint32 {
	return volatile.LoadUint32(&o.CMPV1.Reg) & 0xffffff
}
func (o *PWM_Type) SetCMPV1_CVM(value uint32) {
	volatile.StoreUint32(&o.CMPV1.Reg, volatile.LoadUint32(&o.CMPV1.Reg)&^(0x1000000)|value<<24)
}
func (o *PWM_Type) GetCMPV1_CVM() uint32 {
	return (volatile.LoadUint32(&o.CMPV1.Reg) & 0x1000000) >> 24
}

// PWM.CMPVUPD1: PWM Comparison 1 Value Update Register
func (o *PWM_Type) SetCMPVUPD1_CVUPD(value uint32) {
	volatile.StoreUint32(&o.CMPVUPD1.Reg, volatile.LoadUint32(&o.CMPVUPD1.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCMPVUPD1_CVUPD() uint32 {
	return volatile.LoadUint32(&o.CMPVUPD1.Reg) & 0xffffff
}
func (o *PWM_Type) SetCMPVUPD1_CVMUPD(value uint32) {
	volatile.StoreUint32(&o.CMPVUPD1.Reg, volatile.LoadUint32(&o.CMPVUPD1.Reg)&^(0x1000000)|value<<24)
}
func (o *PWM_Type) GetCMPVUPD1_CVMUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPVUPD1.Reg) & 0x1000000) >> 24
}

// PWM.CMPM1: PWM Comparison 1 Mode Register
func (o *PWM_Type) SetCMPM1_CEN(value uint32) {
	volatile.StoreUint32(&o.CMPM1.Reg, volatile.LoadUint32(&o.CMPM1.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetCMPM1_CEN() uint32 {
	return volatile.LoadUint32(&o.CMPM1.Reg) & 0x1
}
func (o *PWM_Type) SetCMPM1_CTR(value uint32) {
	volatile.StoreUint32(&o.CMPM1.Reg, volatile.LoadUint32(&o.CMPM1.Reg)&^(0xf0)|value<<4)
}
func (o *PWM_Type) GetCMPM1_CTR() uint32 {
	return (volatile.LoadUint32(&o.CMPM1.Reg) & 0xf0) >> 4
}
func (o *PWM_Type) SetCMPM1_CPR(value uint32) {
	volatile.StoreUint32(&o.CMPM1.Reg, volatile.LoadUint32(&o.CMPM1.Reg)&^(0xf00)|value<<8)
}
func (o *PWM_Type) GetCMPM1_CPR() uint32 {
	return (volatile.LoadUint32(&o.CMPM1.Reg) & 0xf00) >> 8
}
func (o *PWM_Type) SetCMPM1_CPRCNT(value uint32) {
	volatile.StoreUint32(&o.CMPM1.Reg, volatile.LoadUint32(&o.CMPM1.Reg)&^(0xf000)|value<<12)
}
func (o *PWM_Type) GetCMPM1_CPRCNT() uint32 {
	return (volatile.LoadUint32(&o.CMPM1.Reg) & 0xf000) >> 12
}
func (o *PWM_Type) SetCMPM1_CUPR(value uint32) {
	volatile.StoreUint32(&o.CMPM1.Reg, volatile.LoadUint32(&o.CMPM1.Reg)&^(0xf0000)|value<<16)
}
func (o *PWM_Type) GetCMPM1_CUPR() uint32 {
	return (volatile.LoadUint32(&o.CMPM1.Reg) & 0xf0000) >> 16
}
func (o *PWM_Type) SetCMPM1_CUPRCNT(value uint32) {
	volatile.StoreUint32(&o.CMPM1.Reg, volatile.LoadUint32(&o.CMPM1.Reg)&^(0xf00000)|value<<20)
}
func (o *PWM_Type) GetCMPM1_CUPRCNT() uint32 {
	return (volatile.LoadUint32(&o.CMPM1.Reg) & 0xf00000) >> 20
}

// PWM.CMPMUPD1: PWM Comparison 1 Mode Update Register
func (o *PWM_Type) SetCMPMUPD1_CENUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD1.Reg, volatile.LoadUint32(&o.CMPMUPD1.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetCMPMUPD1_CENUPD() uint32 {
	return volatile.LoadUint32(&o.CMPMUPD1.Reg) & 0x1
}
func (o *PWM_Type) SetCMPMUPD1_CTRUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD1.Reg, volatile.LoadUint32(&o.CMPMUPD1.Reg)&^(0xf0)|value<<4)
}
func (o *PWM_Type) GetCMPMUPD1_CTRUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPMUPD1.Reg) & 0xf0) >> 4
}
func (o *PWM_Type) SetCMPMUPD1_CPRUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD1.Reg, volatile.LoadUint32(&o.CMPMUPD1.Reg)&^(0xf00)|value<<8)
}
func (o *PWM_Type) GetCMPMUPD1_CPRUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPMUPD1.Reg) & 0xf00) >> 8
}
func (o *PWM_Type) SetCMPMUPD1_CUPRUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD1.Reg, volatile.LoadUint32(&o.CMPMUPD1.Reg)&^(0xf0000)|value<<16)
}
func (o *PWM_Type) GetCMPMUPD1_CUPRUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPMUPD1.Reg) & 0xf0000) >> 16
}

// PWM.CMPV2: PWM Comparison 2 Value Register
func (o *PWM_Type) SetCMPV2_CV(value uint32) {
	volatile.StoreUint32(&o.CMPV2.Reg, volatile.LoadUint32(&o.CMPV2.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCMPV2_CV() uint32 {
	return volatile.LoadUint32(&o.CMPV2.Reg) & 0xffffff
}
func (o *PWM_Type) SetCMPV2_CVM(value uint32) {
	volatile.StoreUint32(&o.CMPV2.Reg, volatile.LoadUint32(&o.CMPV2.Reg)&^(0x1000000)|value<<24)
}
func (o *PWM_Type) GetCMPV2_CVM() uint32 {
	return (volatile.LoadUint32(&o.CMPV2.Reg) & 0x1000000) >> 24
}

// PWM.CMPVUPD2: PWM Comparison 2 Value Update Register
func (o *PWM_Type) SetCMPVUPD2_CVUPD(value uint32) {
	volatile.StoreUint32(&o.CMPVUPD2.Reg, volatile.LoadUint32(&o.CMPVUPD2.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCMPVUPD2_CVUPD() uint32 {
	return volatile.LoadUint32(&o.CMPVUPD2.Reg) & 0xffffff
}
func (o *PWM_Type) SetCMPVUPD2_CVMUPD(value uint32) {
	volatile.StoreUint32(&o.CMPVUPD2.Reg, volatile.LoadUint32(&o.CMPVUPD2.Reg)&^(0x1000000)|value<<24)
}
func (o *PWM_Type) GetCMPVUPD2_CVMUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPVUPD2.Reg) & 0x1000000) >> 24
}

// PWM.CMPM2: PWM Comparison 2 Mode Register
func (o *PWM_Type) SetCMPM2_CEN(value uint32) {
	volatile.StoreUint32(&o.CMPM2.Reg, volatile.LoadUint32(&o.CMPM2.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetCMPM2_CEN() uint32 {
	return volatile.LoadUint32(&o.CMPM2.Reg) & 0x1
}
func (o *PWM_Type) SetCMPM2_CTR(value uint32) {
	volatile.StoreUint32(&o.CMPM2.Reg, volatile.LoadUint32(&o.CMPM2.Reg)&^(0xf0)|value<<4)
}
func (o *PWM_Type) GetCMPM2_CTR() uint32 {
	return (volatile.LoadUint32(&o.CMPM2.Reg) & 0xf0) >> 4
}
func (o *PWM_Type) SetCMPM2_CPR(value uint32) {
	volatile.StoreUint32(&o.CMPM2.Reg, volatile.LoadUint32(&o.CMPM2.Reg)&^(0xf00)|value<<8)
}
func (o *PWM_Type) GetCMPM2_CPR() uint32 {
	return (volatile.LoadUint32(&o.CMPM2.Reg) & 0xf00) >> 8
}
func (o *PWM_Type) SetCMPM2_CPRCNT(value uint32) {
	volatile.StoreUint32(&o.CMPM2.Reg, volatile.LoadUint32(&o.CMPM2.Reg)&^(0xf000)|value<<12)
}
func (o *PWM_Type) GetCMPM2_CPRCNT() uint32 {
	return (volatile.LoadUint32(&o.CMPM2.Reg) & 0xf000) >> 12
}
func (o *PWM_Type) SetCMPM2_CUPR(value uint32) {
	volatile.StoreUint32(&o.CMPM2.Reg, volatile.LoadUint32(&o.CMPM2.Reg)&^(0xf0000)|value<<16)
}
func (o *PWM_Type) GetCMPM2_CUPR() uint32 {
	return (volatile.LoadUint32(&o.CMPM2.Reg) & 0xf0000) >> 16
}
func (o *PWM_Type) SetCMPM2_CUPRCNT(value uint32) {
	volatile.StoreUint32(&o.CMPM2.Reg, volatile.LoadUint32(&o.CMPM2.Reg)&^(0xf00000)|value<<20)
}
func (o *PWM_Type) GetCMPM2_CUPRCNT() uint32 {
	return (volatile.LoadUint32(&o.CMPM2.Reg) & 0xf00000) >> 20
}

// PWM.CMPMUPD2: PWM Comparison 2 Mode Update Register
func (o *PWM_Type) SetCMPMUPD2_CENUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD2.Reg, volatile.LoadUint32(&o.CMPMUPD2.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetCMPMUPD2_CENUPD() uint32 {
	return volatile.LoadUint32(&o.CMPMUPD2.Reg) & 0x1
}
func (o *PWM_Type) SetCMPMUPD2_CTRUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD2.Reg, volatile.LoadUint32(&o.CMPMUPD2.Reg)&^(0xf0)|value<<4)
}
func (o *PWM_Type) GetCMPMUPD2_CTRUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPMUPD2.Reg) & 0xf0) >> 4
}
func (o *PWM_Type) SetCMPMUPD2_CPRUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD2.Reg, volatile.LoadUint32(&o.CMPMUPD2.Reg)&^(0xf00)|value<<8)
}
func (o *PWM_Type) GetCMPMUPD2_CPRUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPMUPD2.Reg) & 0xf00) >> 8
}
func (o *PWM_Type) SetCMPMUPD2_CUPRUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD2.Reg, volatile.LoadUint32(&o.CMPMUPD2.Reg)&^(0xf0000)|value<<16)
}
func (o *PWM_Type) GetCMPMUPD2_CUPRUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPMUPD2.Reg) & 0xf0000) >> 16
}

// PWM.CMPV3: PWM Comparison 3 Value Register
func (o *PWM_Type) SetCMPV3_CV(value uint32) {
	volatile.StoreUint32(&o.CMPV3.Reg, volatile.LoadUint32(&o.CMPV3.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCMPV3_CV() uint32 {
	return volatile.LoadUint32(&o.CMPV3.Reg) & 0xffffff
}
func (o *PWM_Type) SetCMPV3_CVM(value uint32) {
	volatile.StoreUint32(&o.CMPV3.Reg, volatile.LoadUint32(&o.CMPV3.Reg)&^(0x1000000)|value<<24)
}
func (o *PWM_Type) GetCMPV3_CVM() uint32 {
	return (volatile.LoadUint32(&o.CMPV3.Reg) & 0x1000000) >> 24
}

// PWM.CMPVUPD3: PWM Comparison 3 Value Update Register
func (o *PWM_Type) SetCMPVUPD3_CVUPD(value uint32) {
	volatile.StoreUint32(&o.CMPVUPD3.Reg, volatile.LoadUint32(&o.CMPVUPD3.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCMPVUPD3_CVUPD() uint32 {
	return volatile.LoadUint32(&o.CMPVUPD3.Reg) & 0xffffff
}
func (o *PWM_Type) SetCMPVUPD3_CVMUPD(value uint32) {
	volatile.StoreUint32(&o.CMPVUPD3.Reg, volatile.LoadUint32(&o.CMPVUPD3.Reg)&^(0x1000000)|value<<24)
}
func (o *PWM_Type) GetCMPVUPD3_CVMUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPVUPD3.Reg) & 0x1000000) >> 24
}

// PWM.CMPM3: PWM Comparison 3 Mode Register
func (o *PWM_Type) SetCMPM3_CEN(value uint32) {
	volatile.StoreUint32(&o.CMPM3.Reg, volatile.LoadUint32(&o.CMPM3.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetCMPM3_CEN() uint32 {
	return volatile.LoadUint32(&o.CMPM3.Reg) & 0x1
}
func (o *PWM_Type) SetCMPM3_CTR(value uint32) {
	volatile.StoreUint32(&o.CMPM3.Reg, volatile.LoadUint32(&o.CMPM3.Reg)&^(0xf0)|value<<4)
}
func (o *PWM_Type) GetCMPM3_CTR() uint32 {
	return (volatile.LoadUint32(&o.CMPM3.Reg) & 0xf0) >> 4
}
func (o *PWM_Type) SetCMPM3_CPR(value uint32) {
	volatile.StoreUint32(&o.CMPM3.Reg, volatile.LoadUint32(&o.CMPM3.Reg)&^(0xf00)|value<<8)
}
func (o *PWM_Type) GetCMPM3_CPR() uint32 {
	return (volatile.LoadUint32(&o.CMPM3.Reg) & 0xf00) >> 8
}
func (o *PWM_Type) SetCMPM3_CPRCNT(value uint32) {
	volatile.StoreUint32(&o.CMPM3.Reg, volatile.LoadUint32(&o.CMPM3.Reg)&^(0xf000)|value<<12)
}
func (o *PWM_Type) GetCMPM3_CPRCNT() uint32 {
	return (volatile.LoadUint32(&o.CMPM3.Reg) & 0xf000) >> 12
}
func (o *PWM_Type) SetCMPM3_CUPR(value uint32) {
	volatile.StoreUint32(&o.CMPM3.Reg, volatile.LoadUint32(&o.CMPM3.Reg)&^(0xf0000)|value<<16)
}
func (o *PWM_Type) GetCMPM3_CUPR() uint32 {
	return (volatile.LoadUint32(&o.CMPM3.Reg) & 0xf0000) >> 16
}
func (o *PWM_Type) SetCMPM3_CUPRCNT(value uint32) {
	volatile.StoreUint32(&o.CMPM3.Reg, volatile.LoadUint32(&o.CMPM3.Reg)&^(0xf00000)|value<<20)
}
func (o *PWM_Type) GetCMPM3_CUPRCNT() uint32 {
	return (volatile.LoadUint32(&o.CMPM3.Reg) & 0xf00000) >> 20
}

// PWM.CMPMUPD3: PWM Comparison 3 Mode Update Register
func (o *PWM_Type) SetCMPMUPD3_CENUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD3.Reg, volatile.LoadUint32(&o.CMPMUPD3.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetCMPMUPD3_CENUPD() uint32 {
	return volatile.LoadUint32(&o.CMPMUPD3.Reg) & 0x1
}
func (o *PWM_Type) SetCMPMUPD3_CTRUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD3.Reg, volatile.LoadUint32(&o.CMPMUPD3.Reg)&^(0xf0)|value<<4)
}
func (o *PWM_Type) GetCMPMUPD3_CTRUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPMUPD3.Reg) & 0xf0) >> 4
}
func (o *PWM_Type) SetCMPMUPD3_CPRUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD3.Reg, volatile.LoadUint32(&o.CMPMUPD3.Reg)&^(0xf00)|value<<8)
}
func (o *PWM_Type) GetCMPMUPD3_CPRUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPMUPD3.Reg) & 0xf00) >> 8
}
func (o *PWM_Type) SetCMPMUPD3_CUPRUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD3.Reg, volatile.LoadUint32(&o.CMPMUPD3.Reg)&^(0xf0000)|value<<16)
}
func (o *PWM_Type) GetCMPMUPD3_CUPRUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPMUPD3.Reg) & 0xf0000) >> 16
}

// PWM.CMPV4: PWM Comparison 4 Value Register
func (o *PWM_Type) SetCMPV4_CV(value uint32) {
	volatile.StoreUint32(&o.CMPV4.Reg, volatile.LoadUint32(&o.CMPV4.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCMPV4_CV() uint32 {
	return volatile.LoadUint32(&o.CMPV4.Reg) & 0xffffff
}
func (o *PWM_Type) SetCMPV4_CVM(value uint32) {
	volatile.StoreUint32(&o.CMPV4.Reg, volatile.LoadUint32(&o.CMPV4.Reg)&^(0x1000000)|value<<24)
}
func (o *PWM_Type) GetCMPV4_CVM() uint32 {
	return (volatile.LoadUint32(&o.CMPV4.Reg) & 0x1000000) >> 24
}

// PWM.CMPVUPD4: PWM Comparison 4 Value Update Register
func (o *PWM_Type) SetCMPVUPD4_CVUPD(value uint32) {
	volatile.StoreUint32(&o.CMPVUPD4.Reg, volatile.LoadUint32(&o.CMPVUPD4.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCMPVUPD4_CVUPD() uint32 {
	return volatile.LoadUint32(&o.CMPVUPD4.Reg) & 0xffffff
}
func (o *PWM_Type) SetCMPVUPD4_CVMUPD(value uint32) {
	volatile.StoreUint32(&o.CMPVUPD4.Reg, volatile.LoadUint32(&o.CMPVUPD4.Reg)&^(0x1000000)|value<<24)
}
func (o *PWM_Type) GetCMPVUPD4_CVMUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPVUPD4.Reg) & 0x1000000) >> 24
}

// PWM.CMPM4: PWM Comparison 4 Mode Register
func (o *PWM_Type) SetCMPM4_CEN(value uint32) {
	volatile.StoreUint32(&o.CMPM4.Reg, volatile.LoadUint32(&o.CMPM4.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetCMPM4_CEN() uint32 {
	return volatile.LoadUint32(&o.CMPM4.Reg) & 0x1
}
func (o *PWM_Type) SetCMPM4_CTR(value uint32) {
	volatile.StoreUint32(&o.CMPM4.Reg, volatile.LoadUint32(&o.CMPM4.Reg)&^(0xf0)|value<<4)
}
func (o *PWM_Type) GetCMPM4_CTR() uint32 {
	return (volatile.LoadUint32(&o.CMPM4.Reg) & 0xf0) >> 4
}
func (o *PWM_Type) SetCMPM4_CPR(value uint32) {
	volatile.StoreUint32(&o.CMPM4.Reg, volatile.LoadUint32(&o.CMPM4.Reg)&^(0xf00)|value<<8)
}
func (o *PWM_Type) GetCMPM4_CPR() uint32 {
	return (volatile.LoadUint32(&o.CMPM4.Reg) & 0xf00) >> 8
}
func (o *PWM_Type) SetCMPM4_CPRCNT(value uint32) {
	volatile.StoreUint32(&o.CMPM4.Reg, volatile.LoadUint32(&o.CMPM4.Reg)&^(0xf000)|value<<12)
}
func (o *PWM_Type) GetCMPM4_CPRCNT() uint32 {
	return (volatile.LoadUint32(&o.CMPM4.Reg) & 0xf000) >> 12
}
func (o *PWM_Type) SetCMPM4_CUPR(value uint32) {
	volatile.StoreUint32(&o.CMPM4.Reg, volatile.LoadUint32(&o.CMPM4.Reg)&^(0xf0000)|value<<16)
}
func (o *PWM_Type) GetCMPM4_CUPR() uint32 {
	return (volatile.LoadUint32(&o.CMPM4.Reg) & 0xf0000) >> 16
}
func (o *PWM_Type) SetCMPM4_CUPRCNT(value uint32) {
	volatile.StoreUint32(&o.CMPM4.Reg, volatile.LoadUint32(&o.CMPM4.Reg)&^(0xf00000)|value<<20)
}
func (o *PWM_Type) GetCMPM4_CUPRCNT() uint32 {
	return (volatile.LoadUint32(&o.CMPM4.Reg) & 0xf00000) >> 20
}

// PWM.CMPMUPD4: PWM Comparison 4 Mode Update Register
func (o *PWM_Type) SetCMPMUPD4_CENUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD4.Reg, volatile.LoadUint32(&o.CMPMUPD4.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetCMPMUPD4_CENUPD() uint32 {
	return volatile.LoadUint32(&o.CMPMUPD4.Reg) & 0x1
}
func (o *PWM_Type) SetCMPMUPD4_CTRUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD4.Reg, volatile.LoadUint32(&o.CMPMUPD4.Reg)&^(0xf0)|value<<4)
}
func (o *PWM_Type) GetCMPMUPD4_CTRUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPMUPD4.Reg) & 0xf0) >> 4
}
func (o *PWM_Type) SetCMPMUPD4_CPRUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD4.Reg, volatile.LoadUint32(&o.CMPMUPD4.Reg)&^(0xf00)|value<<8)
}
func (o *PWM_Type) GetCMPMUPD4_CPRUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPMUPD4.Reg) & 0xf00) >> 8
}
func (o *PWM_Type) SetCMPMUPD4_CUPRUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD4.Reg, volatile.LoadUint32(&o.CMPMUPD4.Reg)&^(0xf0000)|value<<16)
}
func (o *PWM_Type) GetCMPMUPD4_CUPRUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPMUPD4.Reg) & 0xf0000) >> 16
}

// PWM.CMPV5: PWM Comparison 5 Value Register
func (o *PWM_Type) SetCMPV5_CV(value uint32) {
	volatile.StoreUint32(&o.CMPV5.Reg, volatile.LoadUint32(&o.CMPV5.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCMPV5_CV() uint32 {
	return volatile.LoadUint32(&o.CMPV5.Reg) & 0xffffff
}
func (o *PWM_Type) SetCMPV5_CVM(value uint32) {
	volatile.StoreUint32(&o.CMPV5.Reg, volatile.LoadUint32(&o.CMPV5.Reg)&^(0x1000000)|value<<24)
}
func (o *PWM_Type) GetCMPV5_CVM() uint32 {
	return (volatile.LoadUint32(&o.CMPV5.Reg) & 0x1000000) >> 24
}

// PWM.CMPVUPD5: PWM Comparison 5 Value Update Register
func (o *PWM_Type) SetCMPVUPD5_CVUPD(value uint32) {
	volatile.StoreUint32(&o.CMPVUPD5.Reg, volatile.LoadUint32(&o.CMPVUPD5.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCMPVUPD5_CVUPD() uint32 {
	return volatile.LoadUint32(&o.CMPVUPD5.Reg) & 0xffffff
}
func (o *PWM_Type) SetCMPVUPD5_CVMUPD(value uint32) {
	volatile.StoreUint32(&o.CMPVUPD5.Reg, volatile.LoadUint32(&o.CMPVUPD5.Reg)&^(0x1000000)|value<<24)
}
func (o *PWM_Type) GetCMPVUPD5_CVMUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPVUPD5.Reg) & 0x1000000) >> 24
}

// PWM.CMPM5: PWM Comparison 5 Mode Register
func (o *PWM_Type) SetCMPM5_CEN(value uint32) {
	volatile.StoreUint32(&o.CMPM5.Reg, volatile.LoadUint32(&o.CMPM5.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetCMPM5_CEN() uint32 {
	return volatile.LoadUint32(&o.CMPM5.Reg) & 0x1
}
func (o *PWM_Type) SetCMPM5_CTR(value uint32) {
	volatile.StoreUint32(&o.CMPM5.Reg, volatile.LoadUint32(&o.CMPM5.Reg)&^(0xf0)|value<<4)
}
func (o *PWM_Type) GetCMPM5_CTR() uint32 {
	return (volatile.LoadUint32(&o.CMPM5.Reg) & 0xf0) >> 4
}
func (o *PWM_Type) SetCMPM5_CPR(value uint32) {
	volatile.StoreUint32(&o.CMPM5.Reg, volatile.LoadUint32(&o.CMPM5.Reg)&^(0xf00)|value<<8)
}
func (o *PWM_Type) GetCMPM5_CPR() uint32 {
	return (volatile.LoadUint32(&o.CMPM5.Reg) & 0xf00) >> 8
}
func (o *PWM_Type) SetCMPM5_CPRCNT(value uint32) {
	volatile.StoreUint32(&o.CMPM5.Reg, volatile.LoadUint32(&o.CMPM5.Reg)&^(0xf000)|value<<12)
}
func (o *PWM_Type) GetCMPM5_CPRCNT() uint32 {
	return (volatile.LoadUint32(&o.CMPM5.Reg) & 0xf000) >> 12
}
func (o *PWM_Type) SetCMPM5_CUPR(value uint32) {
	volatile.StoreUint32(&o.CMPM5.Reg, volatile.LoadUint32(&o.CMPM5.Reg)&^(0xf0000)|value<<16)
}
func (o *PWM_Type) GetCMPM5_CUPR() uint32 {
	return (volatile.LoadUint32(&o.CMPM5.Reg) & 0xf0000) >> 16
}
func (o *PWM_Type) SetCMPM5_CUPRCNT(value uint32) {
	volatile.StoreUint32(&o.CMPM5.Reg, volatile.LoadUint32(&o.CMPM5.Reg)&^(0xf00000)|value<<20)
}
func (o *PWM_Type) GetCMPM5_CUPRCNT() uint32 {
	return (volatile.LoadUint32(&o.CMPM5.Reg) & 0xf00000) >> 20
}

// PWM.CMPMUPD5: PWM Comparison 5 Mode Update Register
func (o *PWM_Type) SetCMPMUPD5_CENUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD5.Reg, volatile.LoadUint32(&o.CMPMUPD5.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetCMPMUPD5_CENUPD() uint32 {
	return volatile.LoadUint32(&o.CMPMUPD5.Reg) & 0x1
}
func (o *PWM_Type) SetCMPMUPD5_CTRUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD5.Reg, volatile.LoadUint32(&o.CMPMUPD5.Reg)&^(0xf0)|value<<4)
}
func (o *PWM_Type) GetCMPMUPD5_CTRUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPMUPD5.Reg) & 0xf0) >> 4
}
func (o *PWM_Type) SetCMPMUPD5_CPRUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD5.Reg, volatile.LoadUint32(&o.CMPMUPD5.Reg)&^(0xf00)|value<<8)
}
func (o *PWM_Type) GetCMPMUPD5_CPRUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPMUPD5.Reg) & 0xf00) >> 8
}
func (o *PWM_Type) SetCMPMUPD5_CUPRUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD5.Reg, volatile.LoadUint32(&o.CMPMUPD5.Reg)&^(0xf0000)|value<<16)
}
func (o *PWM_Type) GetCMPMUPD5_CUPRUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPMUPD5.Reg) & 0xf0000) >> 16
}

// PWM.CMPV6: PWM Comparison 6 Value Register
func (o *PWM_Type) SetCMPV6_CV(value uint32) {
	volatile.StoreUint32(&o.CMPV6.Reg, volatile.LoadUint32(&o.CMPV6.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCMPV6_CV() uint32 {
	return volatile.LoadUint32(&o.CMPV6.Reg) & 0xffffff
}
func (o *PWM_Type) SetCMPV6_CVM(value uint32) {
	volatile.StoreUint32(&o.CMPV6.Reg, volatile.LoadUint32(&o.CMPV6.Reg)&^(0x1000000)|value<<24)
}
func (o *PWM_Type) GetCMPV6_CVM() uint32 {
	return (volatile.LoadUint32(&o.CMPV6.Reg) & 0x1000000) >> 24
}

// PWM.CMPVUPD6: PWM Comparison 6 Value Update Register
func (o *PWM_Type) SetCMPVUPD6_CVUPD(value uint32) {
	volatile.StoreUint32(&o.CMPVUPD6.Reg, volatile.LoadUint32(&o.CMPVUPD6.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCMPVUPD6_CVUPD() uint32 {
	return volatile.LoadUint32(&o.CMPVUPD6.Reg) & 0xffffff
}
func (o *PWM_Type) SetCMPVUPD6_CVMUPD(value uint32) {
	volatile.StoreUint32(&o.CMPVUPD6.Reg, volatile.LoadUint32(&o.CMPVUPD6.Reg)&^(0x1000000)|value<<24)
}
func (o *PWM_Type) GetCMPVUPD6_CVMUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPVUPD6.Reg) & 0x1000000) >> 24
}

// PWM.CMPM6: PWM Comparison 6 Mode Register
func (o *PWM_Type) SetCMPM6_CEN(value uint32) {
	volatile.StoreUint32(&o.CMPM6.Reg, volatile.LoadUint32(&o.CMPM6.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetCMPM6_CEN() uint32 {
	return volatile.LoadUint32(&o.CMPM6.Reg) & 0x1
}
func (o *PWM_Type) SetCMPM6_CTR(value uint32) {
	volatile.StoreUint32(&o.CMPM6.Reg, volatile.LoadUint32(&o.CMPM6.Reg)&^(0xf0)|value<<4)
}
func (o *PWM_Type) GetCMPM6_CTR() uint32 {
	return (volatile.LoadUint32(&o.CMPM6.Reg) & 0xf0) >> 4
}
func (o *PWM_Type) SetCMPM6_CPR(value uint32) {
	volatile.StoreUint32(&o.CMPM6.Reg, volatile.LoadUint32(&o.CMPM6.Reg)&^(0xf00)|value<<8)
}
func (o *PWM_Type) GetCMPM6_CPR() uint32 {
	return (volatile.LoadUint32(&o.CMPM6.Reg) & 0xf00) >> 8
}
func (o *PWM_Type) SetCMPM6_CPRCNT(value uint32) {
	volatile.StoreUint32(&o.CMPM6.Reg, volatile.LoadUint32(&o.CMPM6.Reg)&^(0xf000)|value<<12)
}
func (o *PWM_Type) GetCMPM6_CPRCNT() uint32 {
	return (volatile.LoadUint32(&o.CMPM6.Reg) & 0xf000) >> 12
}
func (o *PWM_Type) SetCMPM6_CUPR(value uint32) {
	volatile.StoreUint32(&o.CMPM6.Reg, volatile.LoadUint32(&o.CMPM6.Reg)&^(0xf0000)|value<<16)
}
func (o *PWM_Type) GetCMPM6_CUPR() uint32 {
	return (volatile.LoadUint32(&o.CMPM6.Reg) & 0xf0000) >> 16
}
func (o *PWM_Type) SetCMPM6_CUPRCNT(value uint32) {
	volatile.StoreUint32(&o.CMPM6.Reg, volatile.LoadUint32(&o.CMPM6.Reg)&^(0xf00000)|value<<20)
}
func (o *PWM_Type) GetCMPM6_CUPRCNT() uint32 {
	return (volatile.LoadUint32(&o.CMPM6.Reg) & 0xf00000) >> 20
}

// PWM.CMPMUPD6: PWM Comparison 6 Mode Update Register
func (o *PWM_Type) SetCMPMUPD6_CENUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD6.Reg, volatile.LoadUint32(&o.CMPMUPD6.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetCMPMUPD6_CENUPD() uint32 {
	return volatile.LoadUint32(&o.CMPMUPD6.Reg) & 0x1
}
func (o *PWM_Type) SetCMPMUPD6_CTRUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD6.Reg, volatile.LoadUint32(&o.CMPMUPD6.Reg)&^(0xf0)|value<<4)
}
func (o *PWM_Type) GetCMPMUPD6_CTRUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPMUPD6.Reg) & 0xf0) >> 4
}
func (o *PWM_Type) SetCMPMUPD6_CPRUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD6.Reg, volatile.LoadUint32(&o.CMPMUPD6.Reg)&^(0xf00)|value<<8)
}
func (o *PWM_Type) GetCMPMUPD6_CPRUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPMUPD6.Reg) & 0xf00) >> 8
}
func (o *PWM_Type) SetCMPMUPD6_CUPRUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD6.Reg, volatile.LoadUint32(&o.CMPMUPD6.Reg)&^(0xf0000)|value<<16)
}
func (o *PWM_Type) GetCMPMUPD6_CUPRUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPMUPD6.Reg) & 0xf0000) >> 16
}

// PWM.CMPV7: PWM Comparison 7 Value Register
func (o *PWM_Type) SetCMPV7_CV(value uint32) {
	volatile.StoreUint32(&o.CMPV7.Reg, volatile.LoadUint32(&o.CMPV7.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCMPV7_CV() uint32 {
	return volatile.LoadUint32(&o.CMPV7.Reg) & 0xffffff
}
func (o *PWM_Type) SetCMPV7_CVM(value uint32) {
	volatile.StoreUint32(&o.CMPV7.Reg, volatile.LoadUint32(&o.CMPV7.Reg)&^(0x1000000)|value<<24)
}
func (o *PWM_Type) GetCMPV7_CVM() uint32 {
	return (volatile.LoadUint32(&o.CMPV7.Reg) & 0x1000000) >> 24
}

// PWM.CMPVUPD7: PWM Comparison 7 Value Update Register
func (o *PWM_Type) SetCMPVUPD7_CVUPD(value uint32) {
	volatile.StoreUint32(&o.CMPVUPD7.Reg, volatile.LoadUint32(&o.CMPVUPD7.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCMPVUPD7_CVUPD() uint32 {
	return volatile.LoadUint32(&o.CMPVUPD7.Reg) & 0xffffff
}
func (o *PWM_Type) SetCMPVUPD7_CVMUPD(value uint32) {
	volatile.StoreUint32(&o.CMPVUPD7.Reg, volatile.LoadUint32(&o.CMPVUPD7.Reg)&^(0x1000000)|value<<24)
}
func (o *PWM_Type) GetCMPVUPD7_CVMUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPVUPD7.Reg) & 0x1000000) >> 24
}

// PWM.CMPM7: PWM Comparison 7 Mode Register
func (o *PWM_Type) SetCMPM7_CEN(value uint32) {
	volatile.StoreUint32(&o.CMPM7.Reg, volatile.LoadUint32(&o.CMPM7.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetCMPM7_CEN() uint32 {
	return volatile.LoadUint32(&o.CMPM7.Reg) & 0x1
}
func (o *PWM_Type) SetCMPM7_CTR(value uint32) {
	volatile.StoreUint32(&o.CMPM7.Reg, volatile.LoadUint32(&o.CMPM7.Reg)&^(0xf0)|value<<4)
}
func (o *PWM_Type) GetCMPM7_CTR() uint32 {
	return (volatile.LoadUint32(&o.CMPM7.Reg) & 0xf0) >> 4
}
func (o *PWM_Type) SetCMPM7_CPR(value uint32) {
	volatile.StoreUint32(&o.CMPM7.Reg, volatile.LoadUint32(&o.CMPM7.Reg)&^(0xf00)|value<<8)
}
func (o *PWM_Type) GetCMPM7_CPR() uint32 {
	return (volatile.LoadUint32(&o.CMPM7.Reg) & 0xf00) >> 8
}
func (o *PWM_Type) SetCMPM7_CPRCNT(value uint32) {
	volatile.StoreUint32(&o.CMPM7.Reg, volatile.LoadUint32(&o.CMPM7.Reg)&^(0xf000)|value<<12)
}
func (o *PWM_Type) GetCMPM7_CPRCNT() uint32 {
	return (volatile.LoadUint32(&o.CMPM7.Reg) & 0xf000) >> 12
}
func (o *PWM_Type) SetCMPM7_CUPR(value uint32) {
	volatile.StoreUint32(&o.CMPM7.Reg, volatile.LoadUint32(&o.CMPM7.Reg)&^(0xf0000)|value<<16)
}
func (o *PWM_Type) GetCMPM7_CUPR() uint32 {
	return (volatile.LoadUint32(&o.CMPM7.Reg) & 0xf0000) >> 16
}
func (o *PWM_Type) SetCMPM7_CUPRCNT(value uint32) {
	volatile.StoreUint32(&o.CMPM7.Reg, volatile.LoadUint32(&o.CMPM7.Reg)&^(0xf00000)|value<<20)
}
func (o *PWM_Type) GetCMPM7_CUPRCNT() uint32 {
	return (volatile.LoadUint32(&o.CMPM7.Reg) & 0xf00000) >> 20
}

// PWM.CMPMUPD7: PWM Comparison 7 Mode Update Register
func (o *PWM_Type) SetCMPMUPD7_CENUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD7.Reg, volatile.LoadUint32(&o.CMPMUPD7.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetCMPMUPD7_CENUPD() uint32 {
	return volatile.LoadUint32(&o.CMPMUPD7.Reg) & 0x1
}
func (o *PWM_Type) SetCMPMUPD7_CTRUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD7.Reg, volatile.LoadUint32(&o.CMPMUPD7.Reg)&^(0xf0)|value<<4)
}
func (o *PWM_Type) GetCMPMUPD7_CTRUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPMUPD7.Reg) & 0xf0) >> 4
}
func (o *PWM_Type) SetCMPMUPD7_CPRUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD7.Reg, volatile.LoadUint32(&o.CMPMUPD7.Reg)&^(0xf00)|value<<8)
}
func (o *PWM_Type) GetCMPMUPD7_CPRUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPMUPD7.Reg) & 0xf00) >> 8
}
func (o *PWM_Type) SetCMPMUPD7_CUPRUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD7.Reg, volatile.LoadUint32(&o.CMPMUPD7.Reg)&^(0xf0000)|value<<16)
}
func (o *PWM_Type) GetCMPMUPD7_CUPRUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPMUPD7.Reg) & 0xf0000) >> 16
}

// PWM.CMR0: PWM Channel Mode Register (ch_num = 0)
func (o *PWM_Type) SetCMR0_CPRE(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0xf)|value)
}
func (o *PWM_Type) GetCMR0_CPRE() uint32 {
	return volatile.LoadUint32(&o.CMR0.Reg) & 0xf
}
func (o *PWM_Type) SetCMR0_CALG(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x100)|value<<8)
}
func (o *PWM_Type) GetCMR0_CALG() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x100) >> 8
}
func (o *PWM_Type) SetCMR0_CPOL(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x200)|value<<9)
}
func (o *PWM_Type) GetCMR0_CPOL() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x200) >> 9
}
func (o *PWM_Type) SetCMR0_CES(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x400)|value<<10)
}
func (o *PWM_Type) GetCMR0_CES() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x400) >> 10
}
func (o *PWM_Type) SetCMR0_DTE(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetCMR0_DTE() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetCMR0_DTHI(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetCMR0_DTHI() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetCMR0_DTLI(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetCMR0_DTLI() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x40000) >> 18
}

// PWM.CDTY0: PWM Channel Duty Cycle Register (ch_num = 0)
func (o *PWM_Type) SetCDTY0_CDTY(value uint32) {
	volatile.StoreUint32(&o.CDTY0.Reg, volatile.LoadUint32(&o.CDTY0.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCDTY0_CDTY() uint32 {
	return volatile.LoadUint32(&o.CDTY0.Reg) & 0xffffff
}

// PWM.CDTYUPD0: PWM Channel Duty Cycle Update Register (ch_num = 0)
func (o *PWM_Type) SetCDTYUPD0_CDTYUPD(value uint32) {
	volatile.StoreUint32(&o.CDTYUPD0.Reg, volatile.LoadUint32(&o.CDTYUPD0.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCDTYUPD0_CDTYUPD() uint32 {
	return volatile.LoadUint32(&o.CDTYUPD0.Reg) & 0xffffff
}

// PWM.CPRD0: PWM Channel Period Register (ch_num = 0)
func (o *PWM_Type) SetCPRD0_CPRD(value uint32) {
	volatile.StoreUint32(&o.CPRD0.Reg, volatile.LoadUint32(&o.CPRD0.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCPRD0_CPRD() uint32 {
	return volatile.LoadUint32(&o.CPRD0.Reg) & 0xffffff
}

// PWM.CPRDUPD0: PWM Channel Period Update Register (ch_num = 0)
func (o *PWM_Type) SetCPRDUPD0_CPRDUPD(value uint32) {
	volatile.StoreUint32(&o.CPRDUPD0.Reg, volatile.LoadUint32(&o.CPRDUPD0.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCPRDUPD0_CPRDUPD() uint32 {
	return volatile.LoadUint32(&o.CPRDUPD0.Reg) & 0xffffff
}

// PWM.CCNT0: PWM Channel Counter Register (ch_num = 0)
func (o *PWM_Type) SetCCNT0_CNT(value uint32) {
	volatile.StoreUint32(&o.CCNT0.Reg, volatile.LoadUint32(&o.CCNT0.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCCNT0_CNT() uint32 {
	return volatile.LoadUint32(&o.CCNT0.Reg) & 0xffffff
}

// PWM.DT0: PWM Channel Dead Time Register (ch_num = 0)
func (o *PWM_Type) SetDT0_DTH(value uint32) {
	volatile.StoreUint32(&o.DT0.Reg, volatile.LoadUint32(&o.DT0.Reg)&^(0xffff)|value)
}
func (o *PWM_Type) GetDT0_DTH() uint32 {
	return volatile.LoadUint32(&o.DT0.Reg) & 0xffff
}
func (o *PWM_Type) SetDT0_DTL(value uint32) {
	volatile.StoreUint32(&o.DT0.Reg, volatile.LoadUint32(&o.DT0.Reg)&^(0xffff0000)|value<<16)
}
func (o *PWM_Type) GetDT0_DTL() uint32 {
	return (volatile.LoadUint32(&o.DT0.Reg) & 0xffff0000) >> 16
}

// PWM.DTUPD0: PWM Channel Dead Time Update Register (ch_num = 0)
func (o *PWM_Type) SetDTUPD0_DTHUPD(value uint32) {
	volatile.StoreUint32(&o.DTUPD0.Reg, volatile.LoadUint32(&o.DTUPD0.Reg)&^(0xffff)|value)
}
func (o *PWM_Type) GetDTUPD0_DTHUPD() uint32 {
	return volatile.LoadUint32(&o.DTUPD0.Reg) & 0xffff
}
func (o *PWM_Type) SetDTUPD0_DTLUPD(value uint32) {
	volatile.StoreUint32(&o.DTUPD0.Reg, volatile.LoadUint32(&o.DTUPD0.Reg)&^(0xffff0000)|value<<16)
}
func (o *PWM_Type) GetDTUPD0_DTLUPD() uint32 {
	return (volatile.LoadUint32(&o.DTUPD0.Reg) & 0xffff0000) >> 16
}

// PWM.CMR1: PWM Channel Mode Register (ch_num = 1)
func (o *PWM_Type) SetCMR1_CPRE(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0xf)|value)
}
func (o *PWM_Type) GetCMR1_CPRE() uint32 {
	return volatile.LoadUint32(&o.CMR1.Reg) & 0xf
}
func (o *PWM_Type) SetCMR1_CALG(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x100)|value<<8)
}
func (o *PWM_Type) GetCMR1_CALG() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x100) >> 8
}
func (o *PWM_Type) SetCMR1_CPOL(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x200)|value<<9)
}
func (o *PWM_Type) GetCMR1_CPOL() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x200) >> 9
}
func (o *PWM_Type) SetCMR1_CES(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x400)|value<<10)
}
func (o *PWM_Type) GetCMR1_CES() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x400) >> 10
}
func (o *PWM_Type) SetCMR1_DTE(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetCMR1_DTE() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetCMR1_DTHI(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetCMR1_DTHI() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetCMR1_DTLI(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetCMR1_DTLI() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x40000) >> 18
}

// PWM.CDTY1: PWM Channel Duty Cycle Register (ch_num = 1)
func (o *PWM_Type) SetCDTY1_CDTY(value uint32) {
	volatile.StoreUint32(&o.CDTY1.Reg, volatile.LoadUint32(&o.CDTY1.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCDTY1_CDTY() uint32 {
	return volatile.LoadUint32(&o.CDTY1.Reg) & 0xffffff
}

// PWM.CDTYUPD1: PWM Channel Duty Cycle Update Register (ch_num = 1)
func (o *PWM_Type) SetCDTYUPD1_CDTYUPD(value uint32) {
	volatile.StoreUint32(&o.CDTYUPD1.Reg, volatile.LoadUint32(&o.CDTYUPD1.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCDTYUPD1_CDTYUPD() uint32 {
	return volatile.LoadUint32(&o.CDTYUPD1.Reg) & 0xffffff
}

// PWM.CPRD1: PWM Channel Period Register (ch_num = 1)
func (o *PWM_Type) SetCPRD1_CPRD(value uint32) {
	volatile.StoreUint32(&o.CPRD1.Reg, volatile.LoadUint32(&o.CPRD1.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCPRD1_CPRD() uint32 {
	return volatile.LoadUint32(&o.CPRD1.Reg) & 0xffffff
}

// PWM.CPRDUPD1: PWM Channel Period Update Register (ch_num = 1)
func (o *PWM_Type) SetCPRDUPD1_CPRDUPD(value uint32) {
	volatile.StoreUint32(&o.CPRDUPD1.Reg, volatile.LoadUint32(&o.CPRDUPD1.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCPRDUPD1_CPRDUPD() uint32 {
	return volatile.LoadUint32(&o.CPRDUPD1.Reg) & 0xffffff
}

// PWM.CCNT1: PWM Channel Counter Register (ch_num = 1)
func (o *PWM_Type) SetCCNT1_CNT(value uint32) {
	volatile.StoreUint32(&o.CCNT1.Reg, volatile.LoadUint32(&o.CCNT1.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCCNT1_CNT() uint32 {
	return volatile.LoadUint32(&o.CCNT1.Reg) & 0xffffff
}

// PWM.DT1: PWM Channel Dead Time Register (ch_num = 1)
func (o *PWM_Type) SetDT1_DTH(value uint32) {
	volatile.StoreUint32(&o.DT1.Reg, volatile.LoadUint32(&o.DT1.Reg)&^(0xffff)|value)
}
func (o *PWM_Type) GetDT1_DTH() uint32 {
	return volatile.LoadUint32(&o.DT1.Reg) & 0xffff
}
func (o *PWM_Type) SetDT1_DTL(value uint32) {
	volatile.StoreUint32(&o.DT1.Reg, volatile.LoadUint32(&o.DT1.Reg)&^(0xffff0000)|value<<16)
}
func (o *PWM_Type) GetDT1_DTL() uint32 {
	return (volatile.LoadUint32(&o.DT1.Reg) & 0xffff0000) >> 16
}

// PWM.DTUPD1: PWM Channel Dead Time Update Register (ch_num = 1)
func (o *PWM_Type) SetDTUPD1_DTHUPD(value uint32) {
	volatile.StoreUint32(&o.DTUPD1.Reg, volatile.LoadUint32(&o.DTUPD1.Reg)&^(0xffff)|value)
}
func (o *PWM_Type) GetDTUPD1_DTHUPD() uint32 {
	return volatile.LoadUint32(&o.DTUPD1.Reg) & 0xffff
}
func (o *PWM_Type) SetDTUPD1_DTLUPD(value uint32) {
	volatile.StoreUint32(&o.DTUPD1.Reg, volatile.LoadUint32(&o.DTUPD1.Reg)&^(0xffff0000)|value<<16)
}
func (o *PWM_Type) GetDTUPD1_DTLUPD() uint32 {
	return (volatile.LoadUint32(&o.DTUPD1.Reg) & 0xffff0000) >> 16
}

// PWM.CMR2: PWM Channel Mode Register (ch_num = 2)
func (o *PWM_Type) SetCMR2_CPRE(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0xf)|value)
}
func (o *PWM_Type) GetCMR2_CPRE() uint32 {
	return volatile.LoadUint32(&o.CMR2.Reg) & 0xf
}
func (o *PWM_Type) SetCMR2_CALG(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x100)|value<<8)
}
func (o *PWM_Type) GetCMR2_CALG() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x100) >> 8
}
func (o *PWM_Type) SetCMR2_CPOL(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x200)|value<<9)
}
func (o *PWM_Type) GetCMR2_CPOL() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x200) >> 9
}
func (o *PWM_Type) SetCMR2_CES(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x400)|value<<10)
}
func (o *PWM_Type) GetCMR2_CES() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x400) >> 10
}
func (o *PWM_Type) SetCMR2_DTE(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetCMR2_DTE() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetCMR2_DTHI(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetCMR2_DTHI() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetCMR2_DTLI(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetCMR2_DTLI() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x40000) >> 18
}

// PWM.CDTY2: PWM Channel Duty Cycle Register (ch_num = 2)
func (o *PWM_Type) SetCDTY2_CDTY(value uint32) {
	volatile.StoreUint32(&o.CDTY2.Reg, volatile.LoadUint32(&o.CDTY2.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCDTY2_CDTY() uint32 {
	return volatile.LoadUint32(&o.CDTY2.Reg) & 0xffffff
}

// PWM.CDTYUPD2: PWM Channel Duty Cycle Update Register (ch_num = 2)
func (o *PWM_Type) SetCDTYUPD2_CDTYUPD(value uint32) {
	volatile.StoreUint32(&o.CDTYUPD2.Reg, volatile.LoadUint32(&o.CDTYUPD2.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCDTYUPD2_CDTYUPD() uint32 {
	return volatile.LoadUint32(&o.CDTYUPD2.Reg) & 0xffffff
}

// PWM.CPRD2: PWM Channel Period Register (ch_num = 2)
func (o *PWM_Type) SetCPRD2_CPRD(value uint32) {
	volatile.StoreUint32(&o.CPRD2.Reg, volatile.LoadUint32(&o.CPRD2.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCPRD2_CPRD() uint32 {
	return volatile.LoadUint32(&o.CPRD2.Reg) & 0xffffff
}

// PWM.CPRDUPD2: PWM Channel Period Update Register (ch_num = 2)
func (o *PWM_Type) SetCPRDUPD2_CPRDUPD(value uint32) {
	volatile.StoreUint32(&o.CPRDUPD2.Reg, volatile.LoadUint32(&o.CPRDUPD2.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCPRDUPD2_CPRDUPD() uint32 {
	return volatile.LoadUint32(&o.CPRDUPD2.Reg) & 0xffffff
}

// PWM.CCNT2: PWM Channel Counter Register (ch_num = 2)
func (o *PWM_Type) SetCCNT2_CNT(value uint32) {
	volatile.StoreUint32(&o.CCNT2.Reg, volatile.LoadUint32(&o.CCNT2.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCCNT2_CNT() uint32 {
	return volatile.LoadUint32(&o.CCNT2.Reg) & 0xffffff
}

// PWM.DT2: PWM Channel Dead Time Register (ch_num = 2)
func (o *PWM_Type) SetDT2_DTH(value uint32) {
	volatile.StoreUint32(&o.DT2.Reg, volatile.LoadUint32(&o.DT2.Reg)&^(0xffff)|value)
}
func (o *PWM_Type) GetDT2_DTH() uint32 {
	return volatile.LoadUint32(&o.DT2.Reg) & 0xffff
}
func (o *PWM_Type) SetDT2_DTL(value uint32) {
	volatile.StoreUint32(&o.DT2.Reg, volatile.LoadUint32(&o.DT2.Reg)&^(0xffff0000)|value<<16)
}
func (o *PWM_Type) GetDT2_DTL() uint32 {
	return (volatile.LoadUint32(&o.DT2.Reg) & 0xffff0000) >> 16
}

// PWM.DTUPD2: PWM Channel Dead Time Update Register (ch_num = 2)
func (o *PWM_Type) SetDTUPD2_DTHUPD(value uint32) {
	volatile.StoreUint32(&o.DTUPD2.Reg, volatile.LoadUint32(&o.DTUPD2.Reg)&^(0xffff)|value)
}
func (o *PWM_Type) GetDTUPD2_DTHUPD() uint32 {
	return volatile.LoadUint32(&o.DTUPD2.Reg) & 0xffff
}
func (o *PWM_Type) SetDTUPD2_DTLUPD(value uint32) {
	volatile.StoreUint32(&o.DTUPD2.Reg, volatile.LoadUint32(&o.DTUPD2.Reg)&^(0xffff0000)|value<<16)
}
func (o *PWM_Type) GetDTUPD2_DTLUPD() uint32 {
	return (volatile.LoadUint32(&o.DTUPD2.Reg) & 0xffff0000) >> 16
}

// PWM.CMR3: PWM Channel Mode Register (ch_num = 3)
func (o *PWM_Type) SetCMR3_CPRE(value uint32) {
	volatile.StoreUint32(&o.CMR3.Reg, volatile.LoadUint32(&o.CMR3.Reg)&^(0xf)|value)
}
func (o *PWM_Type) GetCMR3_CPRE() uint32 {
	return volatile.LoadUint32(&o.CMR3.Reg) & 0xf
}
func (o *PWM_Type) SetCMR3_CALG(value uint32) {
	volatile.StoreUint32(&o.CMR3.Reg, volatile.LoadUint32(&o.CMR3.Reg)&^(0x100)|value<<8)
}
func (o *PWM_Type) GetCMR3_CALG() uint32 {
	return (volatile.LoadUint32(&o.CMR3.Reg) & 0x100) >> 8
}
func (o *PWM_Type) SetCMR3_CPOL(value uint32) {
	volatile.StoreUint32(&o.CMR3.Reg, volatile.LoadUint32(&o.CMR3.Reg)&^(0x200)|value<<9)
}
func (o *PWM_Type) GetCMR3_CPOL() uint32 {
	return (volatile.LoadUint32(&o.CMR3.Reg) & 0x200) >> 9
}
func (o *PWM_Type) SetCMR3_CES(value uint32) {
	volatile.StoreUint32(&o.CMR3.Reg, volatile.LoadUint32(&o.CMR3.Reg)&^(0x400)|value<<10)
}
func (o *PWM_Type) GetCMR3_CES() uint32 {
	return (volatile.LoadUint32(&o.CMR3.Reg) & 0x400) >> 10
}
func (o *PWM_Type) SetCMR3_DTE(value uint32) {
	volatile.StoreUint32(&o.CMR3.Reg, volatile.LoadUint32(&o.CMR3.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetCMR3_DTE() uint32 {
	return (volatile.LoadUint32(&o.CMR3.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetCMR3_DTHI(value uint32) {
	volatile.StoreUint32(&o.CMR3.Reg, volatile.LoadUint32(&o.CMR3.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetCMR3_DTHI() uint32 {
	return (volatile.LoadUint32(&o.CMR3.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetCMR3_DTLI(value uint32) {
	volatile.StoreUint32(&o.CMR3.Reg, volatile.LoadUint32(&o.CMR3.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetCMR3_DTLI() uint32 {
	return (volatile.LoadUint32(&o.CMR3.Reg) & 0x40000) >> 18
}

// PWM.CDTY3: PWM Channel Duty Cycle Register (ch_num = 3)
func (o *PWM_Type) SetCDTY3_CDTY(value uint32) {
	volatile.StoreUint32(&o.CDTY3.Reg, volatile.LoadUint32(&o.CDTY3.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCDTY3_CDTY() uint32 {
	return volatile.LoadUint32(&o.CDTY3.Reg) & 0xffffff
}

// PWM.CDTYUPD3: PWM Channel Duty Cycle Update Register (ch_num = 3)
func (o *PWM_Type) SetCDTYUPD3_CDTYUPD(value uint32) {
	volatile.StoreUint32(&o.CDTYUPD3.Reg, volatile.LoadUint32(&o.CDTYUPD3.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCDTYUPD3_CDTYUPD() uint32 {
	return volatile.LoadUint32(&o.CDTYUPD3.Reg) & 0xffffff
}

// PWM.CPRD3: PWM Channel Period Register (ch_num = 3)
func (o *PWM_Type) SetCPRD3_CPRD(value uint32) {
	volatile.StoreUint32(&o.CPRD3.Reg, volatile.LoadUint32(&o.CPRD3.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCPRD3_CPRD() uint32 {
	return volatile.LoadUint32(&o.CPRD3.Reg) & 0xffffff
}

// PWM.CPRDUPD3: PWM Channel Period Update Register (ch_num = 3)
func (o *PWM_Type) SetCPRDUPD3_CPRDUPD(value uint32) {
	volatile.StoreUint32(&o.CPRDUPD3.Reg, volatile.LoadUint32(&o.CPRDUPD3.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCPRDUPD3_CPRDUPD() uint32 {
	return volatile.LoadUint32(&o.CPRDUPD3.Reg) & 0xffffff
}

// PWM.CCNT3: PWM Channel Counter Register (ch_num = 3)
func (o *PWM_Type) SetCCNT3_CNT(value uint32) {
	volatile.StoreUint32(&o.CCNT3.Reg, volatile.LoadUint32(&o.CCNT3.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCCNT3_CNT() uint32 {
	return volatile.LoadUint32(&o.CCNT3.Reg) & 0xffffff
}

// PWM.DT3: PWM Channel Dead Time Register (ch_num = 3)
func (o *PWM_Type) SetDT3_DTH(value uint32) {
	volatile.StoreUint32(&o.DT3.Reg, volatile.LoadUint32(&o.DT3.Reg)&^(0xffff)|value)
}
func (o *PWM_Type) GetDT3_DTH() uint32 {
	return volatile.LoadUint32(&o.DT3.Reg) & 0xffff
}
func (o *PWM_Type) SetDT3_DTL(value uint32) {
	volatile.StoreUint32(&o.DT3.Reg, volatile.LoadUint32(&o.DT3.Reg)&^(0xffff0000)|value<<16)
}
func (o *PWM_Type) GetDT3_DTL() uint32 {
	return (volatile.LoadUint32(&o.DT3.Reg) & 0xffff0000) >> 16
}

// PWM.DTUPD3: PWM Channel Dead Time Update Register (ch_num = 3)
func (o *PWM_Type) SetDTUPD3_DTHUPD(value uint32) {
	volatile.StoreUint32(&o.DTUPD3.Reg, volatile.LoadUint32(&o.DTUPD3.Reg)&^(0xffff)|value)
}
func (o *PWM_Type) GetDTUPD3_DTHUPD() uint32 {
	return volatile.LoadUint32(&o.DTUPD3.Reg) & 0xffff
}
func (o *PWM_Type) SetDTUPD3_DTLUPD(value uint32) {
	volatile.StoreUint32(&o.DTUPD3.Reg, volatile.LoadUint32(&o.DTUPD3.Reg)&^(0xffff0000)|value<<16)
}
func (o *PWM_Type) GetDTUPD3_DTLUPD() uint32 {
	return (volatile.LoadUint32(&o.DTUPD3.Reg) & 0xffff0000) >> 16
}

// Universal Synchronous Asynchronous Receiver Transmitter 0
type USART_Type struct {
	CR   volatile.Register32 // 0x0
	MR   volatile.Register32 // 0x4
	IER  volatile.Register32 // 0x8
	IDR  volatile.Register32 // 0xC
	IMR  volatile.Register32 // 0x10
	CSR  volatile.Register32 // 0x14
	RHR  volatile.Register32 // 0x18
	THR  volatile.Register32 // 0x1C
	BRGR volatile.Register32 // 0x20
	RTOR volatile.Register32 // 0x24
	TTGR volatile.Register32 // 0x28
	_    [20]byte
	FIDI volatile.Register32 // 0x40
	NER  volatile.Register32 // 0x44
	_    [4]byte
	IF   volatile.Register32 // 0x4C
	MAN  volatile.Register32 // 0x50
	_    [144]byte
	WPMR volatile.Register32 // 0xE4
	WPSR volatile.Register32 // 0xE8
	_    [20]byte
	RPR  volatile.Register32 // 0x100
	RCR  volatile.Register32 // 0x104
	TPR  volatile.Register32 // 0x108
	TCR  volatile.Register32 // 0x10C
	RNPR volatile.Register32 // 0x110
	RNCR volatile.Register32 // 0x114
	TNPR volatile.Register32 // 0x118
	TNCR volatile.Register32 // 0x11C
	PTCR volatile.Register32 // 0x120
	PTSR volatile.Register32 // 0x124
}

// USART.CR: Control Register
func (o *USART_Type) SetCR_RSTRX(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetCR_RSTRX() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetCR_RSTTX(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetCR_RSTTX() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetCR_RXEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetCR_RXEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetCR_RXDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetCR_RXDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetCR_TXEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetCR_TXEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetCR_TXDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetCR_TXDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetCR_RSTSTA(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetCR_RSTSTA() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetCR_STTBRK(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetCR_STTBRK() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetCR_STPBRK(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x400)|value<<10)
}
func (o *USART_Type) GetCR_STPBRK() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x400) >> 10
}
func (o *USART_Type) SetCR_STTTO(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x800)|value<<11)
}
func (o *USART_Type) GetCR_STTTO() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x800) >> 11
}
func (o *USART_Type) SetCR_SENDA(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000)|value<<12)
}
func (o *USART_Type) GetCR_SENDA() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000) >> 12
}
func (o *USART_Type) SetCR_RSTIT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2000)|value<<13)
}
func (o *USART_Type) GetCR_RSTIT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2000) >> 13
}
func (o *USART_Type) SetCR_RSTNACK(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4000)|value<<14)
}
func (o *USART_Type) GetCR_RSTNACK() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4000) >> 14
}
func (o *USART_Type) SetCR_RETTO(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8000)|value<<15)
}
func (o *USART_Type) GetCR_RETTO() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8000) >> 15
}
func (o *USART_Type) SetCR_DTREN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000)|value<<16)
}
func (o *USART_Type) GetCR_DTREN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000) >> 16
}
func (o *USART_Type) SetCR_DTRDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20000)|value<<17)
}
func (o *USART_Type) GetCR_DTRDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20000) >> 17
}
func (o *USART_Type) SetCR_RTSEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40000)|value<<18)
}
func (o *USART_Type) GetCR_RTSEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40000) >> 18
}
func (o *USART_Type) SetCR_RTSDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80000)|value<<19)
}
func (o *USART_Type) GetCR_RTSDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80000) >> 19
}

// USART.MR: Mode Register
func (o *USART_Type) SetMR_USART_MODE(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xf)|value)
}
func (o *USART_Type) GetMR_USART_MODE() uint32 {
	return volatile.LoadUint32(&o.MR.Reg) & 0xf
}
func (o *USART_Type) SetMR_USCLKS(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x30)|value<<4)
}
func (o *USART_Type) GetMR_USCLKS() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x30) >> 4
}
func (o *USART_Type) SetMR_CHRL(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xc0)|value<<6)
}
func (o *USART_Type) GetMR_CHRL() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xc0) >> 6
}
func (o *USART_Type) SetMR_SYNC(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetMR_SYNC() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetMR_PAR(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xe00)|value<<9)
}
func (o *USART_Type) GetMR_PAR() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xe00) >> 9
}
func (o *USART_Type) SetMR_NBSTOP(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x3000)|value<<12)
}
func (o *USART_Type) GetMR_NBSTOP() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x3000) >> 12
}
func (o *USART_Type) SetMR_CHMODE(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xc000)|value<<14)
}
func (o *USART_Type) GetMR_CHMODE() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xc000) >> 14
}
func (o *USART_Type) SetMR_MSBF(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x10000)|value<<16)
}
func (o *USART_Type) GetMR_MSBF() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x10000) >> 16
}
func (o *USART_Type) SetMR_MODE9(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x20000)|value<<17)
}
func (o *USART_Type) GetMR_MODE9() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x20000) >> 17
}
func (o *USART_Type) SetMR_CLKO(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x40000)|value<<18)
}
func (o *USART_Type) GetMR_CLKO() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x40000) >> 18
}
func (o *USART_Type) SetMR_OVER(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x80000)|value<<19)
}
func (o *USART_Type) GetMR_OVER() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x80000) >> 19
}
func (o *USART_Type) SetMR_INACK(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x100000)|value<<20)
}
func (o *USART_Type) GetMR_INACK() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x100000) >> 20
}
func (o *USART_Type) SetMR_DSNACK(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x200000)|value<<21)
}
func (o *USART_Type) GetMR_DSNACK() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x200000) >> 21
}
func (o *USART_Type) SetMR_VAR_SYNC(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x400000)|value<<22)
}
func (o *USART_Type) GetMR_VAR_SYNC() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x400000) >> 22
}
func (o *USART_Type) SetMR_INVDATA(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x800000)|value<<23)
}
func (o *USART_Type) GetMR_INVDATA() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x800000) >> 23
}
func (o *USART_Type) SetMR_MAX_ITERATION(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x7000000)|value<<24)
}
func (o *USART_Type) GetMR_MAX_ITERATION() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x7000000) >> 24
}
func (o *USART_Type) SetMR_FILTER(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x10000000)|value<<28)
}
func (o *USART_Type) GetMR_FILTER() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x10000000) >> 28
}
func (o *USART_Type) SetMR_MAN(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x20000000)|value<<29)
}
func (o *USART_Type) GetMR_MAN() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x20000000) >> 29
}
func (o *USART_Type) SetMR_MODSYNC(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x40000000)|value<<30)
}
func (o *USART_Type) GetMR_MODSYNC() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x40000000) >> 30
}
func (o *USART_Type) SetMR_ONEBIT(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x80000000)|value<<31)
}
func (o *USART_Type) GetMR_ONEBIT() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x80000000) >> 31
}

// USART.IER: Interrupt Enable Register
func (o *USART_Type) SetIER_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetIER_RXRDY() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *USART_Type) SetIER_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetIER_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetIER_RXBRK(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetIER_RXBRK() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetIER_ENDRX(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetIER_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetIER_ENDTX(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetIER_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetIER_OVRE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetIER_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetIER_FRAME(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetIER_FRAME() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetIER_PARE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetIER_PARE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetIER_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetIER_TIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetIER_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetIER_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetIER_ITER(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400)|value<<10)
}
func (o *USART_Type) GetIER_ITER() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400) >> 10
}
func (o *USART_Type) SetIER_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x800)|value<<11)
}
func (o *USART_Type) GetIER_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x800) >> 11
}
func (o *USART_Type) SetIER_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1000)|value<<12)
}
func (o *USART_Type) GetIER_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x1000) >> 12
}
func (o *USART_Type) SetIER_NACK(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2000)|value<<13)
}
func (o *USART_Type) GetIER_NACK() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2000) >> 13
}
func (o *USART_Type) SetIER_RIIC(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10000)|value<<16)
}
func (o *USART_Type) GetIER_RIIC() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10000) >> 16
}
func (o *USART_Type) SetIER_DSRIC(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20000)|value<<17)
}
func (o *USART_Type) GetIER_DSRIC() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20000) >> 17
}
func (o *USART_Type) SetIER_DCDIC(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40000)|value<<18)
}
func (o *USART_Type) GetIER_DCDIC() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40000) >> 18
}
func (o *USART_Type) SetIER_CTSIC(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80000)|value<<19)
}
func (o *USART_Type) GetIER_CTSIC() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80000) >> 19
}
func (o *USART_Type) SetIER_MANE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1000000)|value<<24)
}
func (o *USART_Type) GetIER_MANE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x1000000) >> 24
}

// USART.IDR: Interrupt Disable Register
func (o *USART_Type) SetIDR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetIDR_RXRDY() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *USART_Type) SetIDR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetIDR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetIDR_RXBRK(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetIDR_RXBRK() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetIDR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetIDR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetIDR_ENDTX(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetIDR_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetIDR_OVRE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetIDR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetIDR_FRAME(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetIDR_FRAME() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetIDR_PARE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetIDR_PARE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetIDR_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetIDR_TIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetIDR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetIDR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetIDR_ITER(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400)|value<<10)
}
func (o *USART_Type) GetIDR_ITER() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400) >> 10
}
func (o *USART_Type) SetIDR_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x800)|value<<11)
}
func (o *USART_Type) GetIDR_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x800) >> 11
}
func (o *USART_Type) SetIDR_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1000)|value<<12)
}
func (o *USART_Type) GetIDR_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x1000) >> 12
}
func (o *USART_Type) SetIDR_NACK(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2000)|value<<13)
}
func (o *USART_Type) GetIDR_NACK() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2000) >> 13
}
func (o *USART_Type) SetIDR_RIIC(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10000)|value<<16)
}
func (o *USART_Type) GetIDR_RIIC() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10000) >> 16
}
func (o *USART_Type) SetIDR_DSRIC(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20000)|value<<17)
}
func (o *USART_Type) GetIDR_DSRIC() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20000) >> 17
}
func (o *USART_Type) SetIDR_DCDIC(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40000)|value<<18)
}
func (o *USART_Type) GetIDR_DCDIC() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40000) >> 18
}
func (o *USART_Type) SetIDR_CTSIC(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80000)|value<<19)
}
func (o *USART_Type) GetIDR_CTSIC() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80000) >> 19
}
func (o *USART_Type) SetIDR_MANE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1000000)|value<<24)
}
func (o *USART_Type) GetIDR_MANE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x1000000) >> 24
}

// USART.IMR: Interrupt Mask Register
func (o *USART_Type) SetIMR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetIMR_RXRDY() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *USART_Type) SetIMR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetIMR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetIMR_RXBRK(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetIMR_RXBRK() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetIMR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetIMR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetIMR_ENDTX(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetIMR_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetIMR_OVRE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetIMR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetIMR_FRAME(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetIMR_FRAME() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetIMR_PARE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetIMR_PARE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetIMR_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetIMR_TIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetIMR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetIMR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetIMR_ITER(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400)|value<<10)
}
func (o *USART_Type) GetIMR_ITER() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400) >> 10
}
func (o *USART_Type) SetIMR_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x800)|value<<11)
}
func (o *USART_Type) GetIMR_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x800) >> 11
}
func (o *USART_Type) SetIMR_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1000)|value<<12)
}
func (o *USART_Type) GetIMR_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x1000) >> 12
}
func (o *USART_Type) SetIMR_NACK(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2000)|value<<13)
}
func (o *USART_Type) GetIMR_NACK() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2000) >> 13
}
func (o *USART_Type) SetIMR_RIIC(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10000)|value<<16)
}
func (o *USART_Type) GetIMR_RIIC() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10000) >> 16
}
func (o *USART_Type) SetIMR_DSRIC(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20000)|value<<17)
}
func (o *USART_Type) GetIMR_DSRIC() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20000) >> 17
}
func (o *USART_Type) SetIMR_DCDIC(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40000)|value<<18)
}
func (o *USART_Type) GetIMR_DCDIC() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40000) >> 18
}
func (o *USART_Type) SetIMR_CTSIC(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80000)|value<<19)
}
func (o *USART_Type) GetIMR_CTSIC() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80000) >> 19
}
func (o *USART_Type) SetIMR_MANE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1000000)|value<<24)
}
func (o *USART_Type) GetIMR_MANE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x1000000) >> 24
}

// USART.CSR: Channel Status Register
func (o *USART_Type) SetCSR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetCSR_RXRDY() uint32 {
	return volatile.LoadUint32(&o.CSR.Reg) & 0x1
}
func (o *USART_Type) SetCSR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetCSR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetCSR_RXBRK(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetCSR_RXBRK() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetCSR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetCSR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetCSR_ENDTX(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetCSR_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetCSR_OVRE(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetCSR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetCSR_FRAME(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetCSR_FRAME() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetCSR_PARE(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetCSR_PARE() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetCSR_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetCSR_TIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetCSR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetCSR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetCSR_ITER(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x400)|value<<10)
}
func (o *USART_Type) GetCSR_ITER() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x400) >> 10
}
func (o *USART_Type) SetCSR_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x800)|value<<11)
}
func (o *USART_Type) GetCSR_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x800) >> 11
}
func (o *USART_Type) SetCSR_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x1000)|value<<12)
}
func (o *USART_Type) GetCSR_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x1000) >> 12
}
func (o *USART_Type) SetCSR_NACK(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x2000)|value<<13)
}
func (o *USART_Type) GetCSR_NACK() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x2000) >> 13
}
func (o *USART_Type) SetCSR_RIIC(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x10000)|value<<16)
}
func (o *USART_Type) GetCSR_RIIC() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x10000) >> 16
}
func (o *USART_Type) SetCSR_DSRIC(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x20000)|value<<17)
}
func (o *USART_Type) GetCSR_DSRIC() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x20000) >> 17
}
func (o *USART_Type) SetCSR_DCDIC(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x40000)|value<<18)
}
func (o *USART_Type) GetCSR_DCDIC() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x40000) >> 18
}
func (o *USART_Type) SetCSR_CTSIC(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x80000)|value<<19)
}
func (o *USART_Type) GetCSR_CTSIC() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x80000) >> 19
}
func (o *USART_Type) SetCSR_RI(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x100000)|value<<20)
}
func (o *USART_Type) GetCSR_RI() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x100000) >> 20
}
func (o *USART_Type) SetCSR_DSR(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x200000)|value<<21)
}
func (o *USART_Type) GetCSR_DSR() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x200000) >> 21
}
func (o *USART_Type) SetCSR_DCD(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x400000)|value<<22)
}
func (o *USART_Type) GetCSR_DCD() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x400000) >> 22
}
func (o *USART_Type) SetCSR_CTS(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x800000)|value<<23)
}
func (o *USART_Type) GetCSR_CTS() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x800000) >> 23
}
func (o *USART_Type) SetCSR_MANERR(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x1000000)|value<<24)
}
func (o *USART_Type) GetCSR_MANERR() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x1000000) >> 24
}

// USART.RHR: Receive Holding Register
func (o *USART_Type) SetRHR_RXCHR(value uint32) {
	volatile.StoreUint32(&o.RHR.Reg, volatile.LoadUint32(&o.RHR.Reg)&^(0x1ff)|value)
}
func (o *USART_Type) GetRHR_RXCHR() uint32 {
	return volatile.LoadUint32(&o.RHR.Reg) & 0x1ff
}
func (o *USART_Type) SetRHR_RXSYNH(value uint32) {
	volatile.StoreUint32(&o.RHR.Reg, volatile.LoadUint32(&o.RHR.Reg)&^(0x8000)|value<<15)
}
func (o *USART_Type) GetRHR_RXSYNH() uint32 {
	return (volatile.LoadUint32(&o.RHR.Reg) & 0x8000) >> 15
}

// USART.THR: Transmit Holding Register
func (o *USART_Type) SetTHR_TXCHR(value uint32) {
	volatile.StoreUint32(&o.THR.Reg, volatile.LoadUint32(&o.THR.Reg)&^(0x1ff)|value)
}
func (o *USART_Type) GetTHR_TXCHR() uint32 {
	return volatile.LoadUint32(&o.THR.Reg) & 0x1ff
}
func (o *USART_Type) SetTHR_TXSYNH(value uint32) {
	volatile.StoreUint32(&o.THR.Reg, volatile.LoadUint32(&o.THR.Reg)&^(0x8000)|value<<15)
}
func (o *USART_Type) GetTHR_TXSYNH() uint32 {
	return (volatile.LoadUint32(&o.THR.Reg) & 0x8000) >> 15
}

// USART.BRGR: Baud Rate Generator Register
func (o *USART_Type) SetBRGR_CD(value uint32) {
	volatile.StoreUint32(&o.BRGR.Reg, volatile.LoadUint32(&o.BRGR.Reg)&^(0xffff)|value)
}
func (o *USART_Type) GetBRGR_CD() uint32 {
	return volatile.LoadUint32(&o.BRGR.Reg) & 0xffff
}
func (o *USART_Type) SetBRGR_FP(value uint32) {
	volatile.StoreUint32(&o.BRGR.Reg, volatile.LoadUint32(&o.BRGR.Reg)&^(0x70000)|value<<16)
}
func (o *USART_Type) GetBRGR_FP() uint32 {
	return (volatile.LoadUint32(&o.BRGR.Reg) & 0x70000) >> 16
}

// USART.RTOR: Receiver Time-out Register
func (o *USART_Type) SetRTOR_TO(value uint32) {
	volatile.StoreUint32(&o.RTOR.Reg, volatile.LoadUint32(&o.RTOR.Reg)&^(0xffff)|value)
}
func (o *USART_Type) GetRTOR_TO() uint32 {
	return volatile.LoadUint32(&o.RTOR.Reg) & 0xffff
}

// USART.TTGR: Transmitter Timeguard Register
func (o *USART_Type) SetTTGR_TG(value uint32) {
	volatile.StoreUint32(&o.TTGR.Reg, volatile.LoadUint32(&o.TTGR.Reg)&^(0xff)|value)
}
func (o *USART_Type) GetTTGR_TG() uint32 {
	return volatile.LoadUint32(&o.TTGR.Reg) & 0xff
}

// USART.FIDI: FI DI Ratio Register
func (o *USART_Type) SetFIDI_FI_DI_RATIO(value uint32) {
	volatile.StoreUint32(&o.FIDI.Reg, volatile.LoadUint32(&o.FIDI.Reg)&^(0x7ff)|value)
}
func (o *USART_Type) GetFIDI_FI_DI_RATIO() uint32 {
	return volatile.LoadUint32(&o.FIDI.Reg) & 0x7ff
}

// USART.NER: Number of Errors Register
func (o *USART_Type) SetNER_NB_ERRORS(value uint32) {
	volatile.StoreUint32(&o.NER.Reg, volatile.LoadUint32(&o.NER.Reg)&^(0xff)|value)
}
func (o *USART_Type) GetNER_NB_ERRORS() uint32 {
	return volatile.LoadUint32(&o.NER.Reg) & 0xff
}

// USART.IF: IrDA Filter Register
func (o *USART_Type) SetIF_IRDA_FILTER(value uint32) {
	volatile.StoreUint32(&o.IF.Reg, volatile.LoadUint32(&o.IF.Reg)&^(0xff)|value)
}
func (o *USART_Type) GetIF_IRDA_FILTER() uint32 {
	return volatile.LoadUint32(&o.IF.Reg) & 0xff
}

// USART.MAN: Manchester Configuration Register
func (o *USART_Type) SetMAN_TX_PL(value uint32) {
	volatile.StoreUint32(&o.MAN.Reg, volatile.LoadUint32(&o.MAN.Reg)&^(0xf)|value)
}
func (o *USART_Type) GetMAN_TX_PL() uint32 {
	return volatile.LoadUint32(&o.MAN.Reg) & 0xf
}
func (o *USART_Type) SetMAN_TX_PP(value uint32) {
	volatile.StoreUint32(&o.MAN.Reg, volatile.LoadUint32(&o.MAN.Reg)&^(0x300)|value<<8)
}
func (o *USART_Type) GetMAN_TX_PP() uint32 {
	return (volatile.LoadUint32(&o.MAN.Reg) & 0x300) >> 8
}
func (o *USART_Type) SetMAN_TX_MPOL(value uint32) {
	volatile.StoreUint32(&o.MAN.Reg, volatile.LoadUint32(&o.MAN.Reg)&^(0x1000)|value<<12)
}
func (o *USART_Type) GetMAN_TX_MPOL() uint32 {
	return (volatile.LoadUint32(&o.MAN.Reg) & 0x1000) >> 12
}
func (o *USART_Type) SetMAN_RX_PL(value uint32) {
	volatile.StoreUint32(&o.MAN.Reg, volatile.LoadUint32(&o.MAN.Reg)&^(0xf0000)|value<<16)
}
func (o *USART_Type) GetMAN_RX_PL() uint32 {
	return (volatile.LoadUint32(&o.MAN.Reg) & 0xf0000) >> 16
}
func (o *USART_Type) SetMAN_RX_PP(value uint32) {
	volatile.StoreUint32(&o.MAN.Reg, volatile.LoadUint32(&o.MAN.Reg)&^(0x3000000)|value<<24)
}
func (o *USART_Type) GetMAN_RX_PP() uint32 {
	return (volatile.LoadUint32(&o.MAN.Reg) & 0x3000000) >> 24
}
func (o *USART_Type) SetMAN_RX_MPOL(value uint32) {
	volatile.StoreUint32(&o.MAN.Reg, volatile.LoadUint32(&o.MAN.Reg)&^(0x10000000)|value<<28)
}
func (o *USART_Type) GetMAN_RX_MPOL() uint32 {
	return (volatile.LoadUint32(&o.MAN.Reg) & 0x10000000) >> 28
}
func (o *USART_Type) SetMAN_ONE(value uint32) {
	volatile.StoreUint32(&o.MAN.Reg, volatile.LoadUint32(&o.MAN.Reg)&^(0x20000000)|value<<29)
}
func (o *USART_Type) GetMAN_ONE() uint32 {
	return (volatile.LoadUint32(&o.MAN.Reg) & 0x20000000) >> 29
}
func (o *USART_Type) SetMAN_DRIFT(value uint32) {
	volatile.StoreUint32(&o.MAN.Reg, volatile.LoadUint32(&o.MAN.Reg)&^(0x40000000)|value<<30)
}
func (o *USART_Type) GetMAN_DRIFT() uint32 {
	return (volatile.LoadUint32(&o.MAN.Reg) & 0x40000000) >> 30
}

// USART.WPMR: Write Protection Mode Register
func (o *USART_Type) SetWPMR_WPEN(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetWPMR_WPEN() uint32 {
	return volatile.LoadUint32(&o.WPMR.Reg) & 0x1
}
func (o *USART_Type) SetWPMR_WPKEY(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0xffffff00)|value<<8)
}
func (o *USART_Type) GetWPMR_WPKEY() uint32 {
	return (volatile.LoadUint32(&o.WPMR.Reg) & 0xffffff00) >> 8
}

// USART.WPSR: Write Protection Status Register
func (o *USART_Type) SetWPSR_WPVS(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetWPSR_WPVS() uint32 {
	return volatile.LoadUint32(&o.WPSR.Reg) & 0x1
}
func (o *USART_Type) SetWPSR_WPVSRC(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0xffff00)|value<<8)
}
func (o *USART_Type) GetWPSR_WPVSRC() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0xffff00) >> 8
}

// USART.RPR: Receive Pointer Register
func (o *USART_Type) SetRPR(value uint32) {
	volatile.StoreUint32(&o.RPR.Reg, value)
}
func (o *USART_Type) GetRPR() uint32 {
	return volatile.LoadUint32(&o.RPR.Reg)
}

// USART.RCR: Receive Counter Register
func (o *USART_Type) SetRCR_RXCTR(value uint32) {
	volatile.StoreUint32(&o.RCR.Reg, volatile.LoadUint32(&o.RCR.Reg)&^(0xffff)|value)
}
func (o *USART_Type) GetRCR_RXCTR() uint32 {
	return volatile.LoadUint32(&o.RCR.Reg) & 0xffff
}

// USART.TPR: Transmit Pointer Register
func (o *USART_Type) SetTPR(value uint32) {
	volatile.StoreUint32(&o.TPR.Reg, value)
}
func (o *USART_Type) GetTPR() uint32 {
	return volatile.LoadUint32(&o.TPR.Reg)
}

// USART.TCR: Transmit Counter Register
func (o *USART_Type) SetTCR_TXCTR(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0xffff)|value)
}
func (o *USART_Type) GetTCR_TXCTR() uint32 {
	return volatile.LoadUint32(&o.TCR.Reg) & 0xffff
}

// USART.RNPR: Receive Next Pointer Register
func (o *USART_Type) SetRNPR(value uint32) {
	volatile.StoreUint32(&o.RNPR.Reg, value)
}
func (o *USART_Type) GetRNPR() uint32 {
	return volatile.LoadUint32(&o.RNPR.Reg)
}

// USART.RNCR: Receive Next Counter Register
func (o *USART_Type) SetRNCR_RXNCTR(value uint32) {
	volatile.StoreUint32(&o.RNCR.Reg, volatile.LoadUint32(&o.RNCR.Reg)&^(0xffff)|value)
}
func (o *USART_Type) GetRNCR_RXNCTR() uint32 {
	return volatile.LoadUint32(&o.RNCR.Reg) & 0xffff
}

// USART.TNPR: Transmit Next Pointer Register
func (o *USART_Type) SetTNPR(value uint32) {
	volatile.StoreUint32(&o.TNPR.Reg, value)
}
func (o *USART_Type) GetTNPR() uint32 {
	return volatile.LoadUint32(&o.TNPR.Reg)
}

// USART.TNCR: Transmit Next Counter Register
func (o *USART_Type) SetTNCR_TXNCTR(value uint32) {
	volatile.StoreUint32(&o.TNCR.Reg, volatile.LoadUint32(&o.TNCR.Reg)&^(0xffff)|value)
}
func (o *USART_Type) GetTNCR_TXNCTR() uint32 {
	return volatile.LoadUint32(&o.TNCR.Reg) & 0xffff
}

// USART.PTCR: Transfer Control Register
func (o *USART_Type) SetPTCR_RXTEN(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetPTCR_RXTEN() uint32 {
	return volatile.LoadUint32(&o.PTCR.Reg) & 0x1
}
func (o *USART_Type) SetPTCR_RXTDIS(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetPTCR_RXTDIS() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetPTCR_TXTEN(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetPTCR_TXTEN() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetPTCR_TXTDIS(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetPTCR_TXTDIS() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x200) >> 9
}

// USART.PTSR: Transfer Status Register
func (o *USART_Type) SetPTSR_RXTEN(value uint32) {
	volatile.StoreUint32(&o.PTSR.Reg, volatile.LoadUint32(&o.PTSR.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetPTSR_RXTEN() uint32 {
	return volatile.LoadUint32(&o.PTSR.Reg) & 0x1
}
func (o *USART_Type) SetPTSR_TXTEN(value uint32) {
	volatile.StoreUint32(&o.PTSR.Reg, volatile.LoadUint32(&o.PTSR.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetPTSR_TXTEN() uint32 {
	return (volatile.LoadUint32(&o.PTSR.Reg) & 0x100) >> 8
}

// USB Device Port
type UDP_Type struct {
	FRM_NUM  volatile.Register32 // 0x0
	GLB_STAT volatile.Register32 // 0x4
	FADDR    volatile.Register32 // 0x8
	_        [4]byte
	IER      volatile.Register32 // 0x10
	IDR      volatile.Register32 // 0x14
	IMR      volatile.Register32 // 0x18
	ISR      volatile.Register32 // 0x1C
	ICR      volatile.Register32 // 0x20
	_        [4]byte
	RST_EP   volatile.Register32 // 0x28
	_        [4]byte
	CSR      [8]volatile.Register32 // 0x30
	FDR      [8]volatile.Register32 // 0x50
	_        [4]byte
	TXVC     volatile.Register32 // 0x74
}

// UDP.FRM_NUM: Frame Number Register
func (o *UDP_Type) SetFRM_NUM(value uint32) {
	volatile.StoreUint32(&o.FRM_NUM.Reg, volatile.LoadUint32(&o.FRM_NUM.Reg)&^(0x7ff)|value)
}
func (o *UDP_Type) GetFRM_NUM() uint32 {
	return volatile.LoadUint32(&o.FRM_NUM.Reg) & 0x7ff
}
func (o *UDP_Type) SetFRM_NUM_FRM_ERR(value uint32) {
	volatile.StoreUint32(&o.FRM_NUM.Reg, volatile.LoadUint32(&o.FRM_NUM.Reg)&^(0x10000)|value<<16)
}
func (o *UDP_Type) GetFRM_NUM_FRM_ERR() uint32 {
	return (volatile.LoadUint32(&o.FRM_NUM.Reg) & 0x10000) >> 16
}
func (o *UDP_Type) SetFRM_NUM_FRM_OK(value uint32) {
	volatile.StoreUint32(&o.FRM_NUM.Reg, volatile.LoadUint32(&o.FRM_NUM.Reg)&^(0x20000)|value<<17)
}
func (o *UDP_Type) GetFRM_NUM_FRM_OK() uint32 {
	return (volatile.LoadUint32(&o.FRM_NUM.Reg) & 0x20000) >> 17
}

// UDP.GLB_STAT: Global State Register
func (o *UDP_Type) SetGLB_STAT_FADDEN(value uint32) {
	volatile.StoreUint32(&o.GLB_STAT.Reg, volatile.LoadUint32(&o.GLB_STAT.Reg)&^(0x1)|value)
}
func (o *UDP_Type) GetGLB_STAT_FADDEN() uint32 {
	return volatile.LoadUint32(&o.GLB_STAT.Reg) & 0x1
}
func (o *UDP_Type) SetGLB_STAT_CONFG(value uint32) {
	volatile.StoreUint32(&o.GLB_STAT.Reg, volatile.LoadUint32(&o.GLB_STAT.Reg)&^(0x2)|value<<1)
}
func (o *UDP_Type) GetGLB_STAT_CONFG() uint32 {
	return (volatile.LoadUint32(&o.GLB_STAT.Reg) & 0x2) >> 1
}
func (o *UDP_Type) SetGLB_STAT_ESR(value uint32) {
	volatile.StoreUint32(&o.GLB_STAT.Reg, volatile.LoadUint32(&o.GLB_STAT.Reg)&^(0x4)|value<<2)
}
func (o *UDP_Type) GetGLB_STAT_ESR() uint32 {
	return (volatile.LoadUint32(&o.GLB_STAT.Reg) & 0x4) >> 2
}
func (o *UDP_Type) SetGLB_STAT_RSMINPR(value uint32) {
	volatile.StoreUint32(&o.GLB_STAT.Reg, volatile.LoadUint32(&o.GLB_STAT.Reg)&^(0x8)|value<<3)
}
func (o *UDP_Type) GetGLB_STAT_RSMINPR() uint32 {
	return (volatile.LoadUint32(&o.GLB_STAT.Reg) & 0x8) >> 3
}
func (o *UDP_Type) SetGLB_STAT_RMWUPE(value uint32) {
	volatile.StoreUint32(&o.GLB_STAT.Reg, volatile.LoadUint32(&o.GLB_STAT.Reg)&^(0x10)|value<<4)
}
func (o *UDP_Type) GetGLB_STAT_RMWUPE() uint32 {
	return (volatile.LoadUint32(&o.GLB_STAT.Reg) & 0x10) >> 4
}

// UDP.FADDR: Function Address Register
func (o *UDP_Type) SetFADDR_FADD(value uint32) {
	volatile.StoreUint32(&o.FADDR.Reg, volatile.LoadUint32(&o.FADDR.Reg)&^(0x7f)|value)
}
func (o *UDP_Type) GetFADDR_FADD() uint32 {
	return volatile.LoadUint32(&o.FADDR.Reg) & 0x7f
}
func (o *UDP_Type) SetFADDR_FEN(value uint32) {
	volatile.StoreUint32(&o.FADDR.Reg, volatile.LoadUint32(&o.FADDR.Reg)&^(0x100)|value<<8)
}
func (o *UDP_Type) GetFADDR_FEN() uint32 {
	return (volatile.LoadUint32(&o.FADDR.Reg) & 0x100) >> 8
}

// UDP.IER: Interrupt Enable Register
func (o *UDP_Type) SetIER_EP0INT(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *UDP_Type) GetIER_EP0INT() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *UDP_Type) SetIER_EP1INT(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *UDP_Type) GetIER_EP1INT() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *UDP_Type) SetIER_EP2INT(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *UDP_Type) GetIER_EP2INT() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *UDP_Type) SetIER_EP3INT(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *UDP_Type) GetIER_EP3INT() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *UDP_Type) SetIER_EP4INT(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *UDP_Type) GetIER_EP4INT() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *UDP_Type) SetIER_EP5INT(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *UDP_Type) GetIER_EP5INT() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *UDP_Type) SetIER_EP6INT(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40)|value<<6)
}
func (o *UDP_Type) GetIER_EP6INT() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40) >> 6
}
func (o *UDP_Type) SetIER_EP7INT(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80)|value<<7)
}
func (o *UDP_Type) GetIER_EP7INT() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80) >> 7
}
func (o *UDP_Type) SetIER_RXSUSP(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100)|value<<8)
}
func (o *UDP_Type) GetIER_RXSUSP() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100) >> 8
}
func (o *UDP_Type) SetIER_RXRSM(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200)|value<<9)
}
func (o *UDP_Type) GetIER_RXRSM() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200) >> 9
}
func (o *UDP_Type) SetIER_EXTRSM(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400)|value<<10)
}
func (o *UDP_Type) GetIER_EXTRSM() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400) >> 10
}
func (o *UDP_Type) SetIER_SOFINT(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x800)|value<<11)
}
func (o *UDP_Type) GetIER_SOFINT() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x800) >> 11
}
func (o *UDP_Type) SetIER_WAKEUP(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2000)|value<<13)
}
func (o *UDP_Type) GetIER_WAKEUP() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2000) >> 13
}

// UDP.IDR: Interrupt Disable Register
func (o *UDP_Type) SetIDR_EP0INT(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *UDP_Type) GetIDR_EP0INT() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *UDP_Type) SetIDR_EP1INT(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *UDP_Type) GetIDR_EP1INT() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *UDP_Type) SetIDR_EP2INT(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4)|value<<2)
}
func (o *UDP_Type) GetIDR_EP2INT() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4) >> 2
}
func (o *UDP_Type) SetIDR_EP3INT(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8)|value<<3)
}
func (o *UDP_Type) GetIDR_EP3INT() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8) >> 3
}
func (o *UDP_Type) SetIDR_EP4INT(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10)|value<<4)
}
func (o *UDP_Type) GetIDR_EP4INT() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10) >> 4
}
func (o *UDP_Type) SetIDR_EP5INT(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20)|value<<5)
}
func (o *UDP_Type) GetIDR_EP5INT() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20) >> 5
}
func (o *UDP_Type) SetIDR_EP6INT(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40)|value<<6)
}
func (o *UDP_Type) GetIDR_EP6INT() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40) >> 6
}
func (o *UDP_Type) SetIDR_EP7INT(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80)|value<<7)
}
func (o *UDP_Type) GetIDR_EP7INT() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80) >> 7
}
func (o *UDP_Type) SetIDR_RXSUSP(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100)|value<<8)
}
func (o *UDP_Type) GetIDR_RXSUSP() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100) >> 8
}
func (o *UDP_Type) SetIDR_RXRSM(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200)|value<<9)
}
func (o *UDP_Type) GetIDR_RXRSM() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200) >> 9
}
func (o *UDP_Type) SetIDR_EXTRSM(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400)|value<<10)
}
func (o *UDP_Type) GetIDR_EXTRSM() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400) >> 10
}
func (o *UDP_Type) SetIDR_SOFINT(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x800)|value<<11)
}
func (o *UDP_Type) GetIDR_SOFINT() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x800) >> 11
}
func (o *UDP_Type) SetIDR_WAKEUP(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2000)|value<<13)
}
func (o *UDP_Type) GetIDR_WAKEUP() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2000) >> 13
}

// UDP.IMR: Interrupt Mask Register
func (o *UDP_Type) SetIMR_EP0INT(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *UDP_Type) GetIMR_EP0INT() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *UDP_Type) SetIMR_EP1INT(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *UDP_Type) GetIMR_EP1INT() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *UDP_Type) SetIMR_EP2INT(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4)|value<<2)
}
func (o *UDP_Type) GetIMR_EP2INT() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4) >> 2
}
func (o *UDP_Type) SetIMR_EP3INT(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8)|value<<3)
}
func (o *UDP_Type) GetIMR_EP3INT() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8) >> 3
}
func (o *UDP_Type) SetIMR_EP4INT(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10)|value<<4)
}
func (o *UDP_Type) GetIMR_EP4INT() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10) >> 4
}
func (o *UDP_Type) SetIMR_EP5INT(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20)|value<<5)
}
func (o *UDP_Type) GetIMR_EP5INT() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20) >> 5
}
func (o *UDP_Type) SetIMR_EP6INT(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40)|value<<6)
}
func (o *UDP_Type) GetIMR_EP6INT() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40) >> 6
}
func (o *UDP_Type) SetIMR_EP7INT(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80)|value<<7)
}
func (o *UDP_Type) GetIMR_EP7INT() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80) >> 7
}
func (o *UDP_Type) SetIMR_RXSUSP(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100)|value<<8)
}
func (o *UDP_Type) GetIMR_RXSUSP() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100) >> 8
}
func (o *UDP_Type) SetIMR_RXRSM(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200)|value<<9)
}
func (o *UDP_Type) GetIMR_RXRSM() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200) >> 9
}
func (o *UDP_Type) SetIMR_EXTRSM(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400)|value<<10)
}
func (o *UDP_Type) GetIMR_EXTRSM() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400) >> 10
}
func (o *UDP_Type) SetIMR_SOFINT(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x800)|value<<11)
}
func (o *UDP_Type) GetIMR_SOFINT() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x800) >> 11
}
func (o *UDP_Type) SetIMR_BIT12(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1000)|value<<12)
}
func (o *UDP_Type) GetIMR_BIT12() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x1000) >> 12
}
func (o *UDP_Type) SetIMR_WAKEUP(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2000)|value<<13)
}
func (o *UDP_Type) GetIMR_WAKEUP() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2000) >> 13
}

// UDP.ISR: Interrupt Status Register
func (o *UDP_Type) SetISR_EP0INT(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *UDP_Type) GetISR_EP0INT() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}
func (o *UDP_Type) SetISR_EP1INT(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *UDP_Type) GetISR_EP1INT() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *UDP_Type) SetISR_EP2INT(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *UDP_Type) GetISR_EP2INT() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *UDP_Type) SetISR_EP3INT(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *UDP_Type) GetISR_EP3INT() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *UDP_Type) SetISR_EP4INT(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *UDP_Type) GetISR_EP4INT() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *UDP_Type) SetISR_EP5INT(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20)|value<<5)
}
func (o *UDP_Type) GetISR_EP5INT() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20) >> 5
}
func (o *UDP_Type) SetISR_EP6INT(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40)|value<<6)
}
func (o *UDP_Type) GetISR_EP6INT() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40) >> 6
}
func (o *UDP_Type) SetISR_EP7INT(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80)|value<<7)
}
func (o *UDP_Type) GetISR_EP7INT() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80) >> 7
}
func (o *UDP_Type) SetISR_RXSUSP(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100)|value<<8)
}
func (o *UDP_Type) GetISR_RXSUSP() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100) >> 8
}
func (o *UDP_Type) SetISR_RXRSM(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200)|value<<9)
}
func (o *UDP_Type) GetISR_RXRSM() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200) >> 9
}
func (o *UDP_Type) SetISR_EXTRSM(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400)|value<<10)
}
func (o *UDP_Type) GetISR_EXTRSM() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400) >> 10
}
func (o *UDP_Type) SetISR_SOFINT(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x800)|value<<11)
}
func (o *UDP_Type) GetISR_SOFINT() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x800) >> 11
}
func (o *UDP_Type) SetISR_ENDBUSRES(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1000)|value<<12)
}
func (o *UDP_Type) GetISR_ENDBUSRES() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x1000) >> 12
}
func (o *UDP_Type) SetISR_WAKEUP(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2000)|value<<13)
}
func (o *UDP_Type) GetISR_WAKEUP() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2000) >> 13
}

// UDP.ICR: Interrupt Clear Register
func (o *UDP_Type) SetICR_RXSUSP(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x100)|value<<8)
}
func (o *UDP_Type) GetICR_RXSUSP() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x100) >> 8
}
func (o *UDP_Type) SetICR_RXRSM(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x200)|value<<9)
}
func (o *UDP_Type) GetICR_RXRSM() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x200) >> 9
}
func (o *UDP_Type) SetICR_EXTRSM(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x400)|value<<10)
}
func (o *UDP_Type) GetICR_EXTRSM() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x400) >> 10
}
func (o *UDP_Type) SetICR_SOFINT(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x800)|value<<11)
}
func (o *UDP_Type) GetICR_SOFINT() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x800) >> 11
}
func (o *UDP_Type) SetICR_ENDBUSRES(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x1000)|value<<12)
}
func (o *UDP_Type) GetICR_ENDBUSRES() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x1000) >> 12
}
func (o *UDP_Type) SetICR_WAKEUP(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x2000)|value<<13)
}
func (o *UDP_Type) GetICR_WAKEUP() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x2000) >> 13
}

// UDP.RST_EP: Reset Endpoint Register
func (o *UDP_Type) SetRST_EP_EP0(value uint32) {
	volatile.StoreUint32(&o.RST_EP.Reg, volatile.LoadUint32(&o.RST_EP.Reg)&^(0x1)|value)
}
func (o *UDP_Type) GetRST_EP_EP0() uint32 {
	return volatile.LoadUint32(&o.RST_EP.Reg) & 0x1
}
func (o *UDP_Type) SetRST_EP_EP1(value uint32) {
	volatile.StoreUint32(&o.RST_EP.Reg, volatile.LoadUint32(&o.RST_EP.Reg)&^(0x2)|value<<1)
}
func (o *UDP_Type) GetRST_EP_EP1() uint32 {
	return (volatile.LoadUint32(&o.RST_EP.Reg) & 0x2) >> 1
}
func (o *UDP_Type) SetRST_EP_EP2(value uint32) {
	volatile.StoreUint32(&o.RST_EP.Reg, volatile.LoadUint32(&o.RST_EP.Reg)&^(0x4)|value<<2)
}
func (o *UDP_Type) GetRST_EP_EP2() uint32 {
	return (volatile.LoadUint32(&o.RST_EP.Reg) & 0x4) >> 2
}
func (o *UDP_Type) SetRST_EP_EP3(value uint32) {
	volatile.StoreUint32(&o.RST_EP.Reg, volatile.LoadUint32(&o.RST_EP.Reg)&^(0x8)|value<<3)
}
func (o *UDP_Type) GetRST_EP_EP3() uint32 {
	return (volatile.LoadUint32(&o.RST_EP.Reg) & 0x8) >> 3
}
func (o *UDP_Type) SetRST_EP_EP4(value uint32) {
	volatile.StoreUint32(&o.RST_EP.Reg, volatile.LoadUint32(&o.RST_EP.Reg)&^(0x10)|value<<4)
}
func (o *UDP_Type) GetRST_EP_EP4() uint32 {
	return (volatile.LoadUint32(&o.RST_EP.Reg) & 0x10) >> 4
}
func (o *UDP_Type) SetRST_EP_EP5(value uint32) {
	volatile.StoreUint32(&o.RST_EP.Reg, volatile.LoadUint32(&o.RST_EP.Reg)&^(0x20)|value<<5)
}
func (o *UDP_Type) GetRST_EP_EP5() uint32 {
	return (volatile.LoadUint32(&o.RST_EP.Reg) & 0x20) >> 5
}
func (o *UDP_Type) SetRST_EP_EP6(value uint32) {
	volatile.StoreUint32(&o.RST_EP.Reg, volatile.LoadUint32(&o.RST_EP.Reg)&^(0x40)|value<<6)
}
func (o *UDP_Type) GetRST_EP_EP6() uint32 {
	return (volatile.LoadUint32(&o.RST_EP.Reg) & 0x40) >> 6
}
func (o *UDP_Type) SetRST_EP_EP7(value uint32) {
	volatile.StoreUint32(&o.RST_EP.Reg, volatile.LoadUint32(&o.RST_EP.Reg)&^(0x80)|value<<7)
}
func (o *UDP_Type) GetRST_EP_EP7() uint32 {
	return (volatile.LoadUint32(&o.RST_EP.Reg) & 0x80) >> 7
}

// UDP.CSR: Endpoint Control and Status Register
func (o *UDP_Type) SetCSR_TXCOMP(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0x1)|value)
}
func (o *UDP_Type) GetCSR_TXCOMP(idx int) uint32 {
	return volatile.LoadUint32(&o.CSR[idx].Reg) & 0x1
}
func (o *UDP_Type) SetCSR_RX_DATA_BK0(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0x2)|value<<1)
}
func (o *UDP_Type) GetCSR_RX_DATA_BK0(idx int) uint32 {
	return (volatile.LoadUint32(&o.CSR[idx].Reg) & 0x2) >> 1
}
func (o *UDP_Type) SetCSR_RXSETUP(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0x4)|value<<2)
}
func (o *UDP_Type) GetCSR_RXSETUP(idx int) uint32 {
	return (volatile.LoadUint32(&o.CSR[idx].Reg) & 0x4) >> 2
}
func (o *UDP_Type) SetCSR_STALLSENT(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0x8)|value<<3)
}
func (o *UDP_Type) GetCSR_STALLSENT(idx int) uint32 {
	return (volatile.LoadUint32(&o.CSR[idx].Reg) & 0x8) >> 3
}
func (o *UDP_Type) SetCSR_TXPKTRDY(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0x10)|value<<4)
}
func (o *UDP_Type) GetCSR_TXPKTRDY(idx int) uint32 {
	return (volatile.LoadUint32(&o.CSR[idx].Reg) & 0x10) >> 4
}
func (o *UDP_Type) SetCSR_FORCESTALL(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0x20)|value<<5)
}
func (o *UDP_Type) GetCSR_FORCESTALL(idx int) uint32 {
	return (volatile.LoadUint32(&o.CSR[idx].Reg) & 0x20) >> 5
}
func (o *UDP_Type) SetCSR_RX_DATA_BK1(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0x40)|value<<6)
}
func (o *UDP_Type) GetCSR_RX_DATA_BK1(idx int) uint32 {
	return (volatile.LoadUint32(&o.CSR[idx].Reg) & 0x40) >> 6
}
func (o *UDP_Type) SetCSR_DIR(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0x80)|value<<7)
}
func (o *UDP_Type) GetCSR_DIR(idx int) uint32 {
	return (volatile.LoadUint32(&o.CSR[idx].Reg) & 0x80) >> 7
}
func (o *UDP_Type) SetCSR_EPTYPE(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0x700)|value<<8)
}
func (o *UDP_Type) GetCSR_EPTYPE(idx int) uint32 {
	return (volatile.LoadUint32(&o.CSR[idx].Reg) & 0x700) >> 8
}
func (o *UDP_Type) SetCSR_DTGLE(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0x800)|value<<11)
}
func (o *UDP_Type) GetCSR_DTGLE(idx int) uint32 {
	return (volatile.LoadUint32(&o.CSR[idx].Reg) & 0x800) >> 11
}
func (o *UDP_Type) SetCSR_EPEDS(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0x8000)|value<<15)
}
func (o *UDP_Type) GetCSR_EPEDS(idx int) uint32 {
	return (volatile.LoadUint32(&o.CSR[idx].Reg) & 0x8000) >> 15
}
func (o *UDP_Type) SetCSR_RXBYTECNT(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0x7ff0000)|value<<16)
}
func (o *UDP_Type) GetCSR_RXBYTECNT(idx int) uint32 {
	return (volatile.LoadUint32(&o.CSR[idx].Reg) & 0x7ff0000) >> 16
}

// UDP.FDR: Endpoint FIFO Data Register
func (o *UDP_Type) SetFDR_FIFO_DATA(idx int, value uint32) {
	volatile.StoreUint32(&o.FDR[idx].Reg, volatile.LoadUint32(&o.FDR[idx].Reg)&^(0xff)|value)
}
func (o *UDP_Type) GetFDR_FIFO_DATA(idx int) uint32 {
	return volatile.LoadUint32(&o.FDR[idx].Reg) & 0xff
}

// UDP.TXVC: Transceiver Control Register
func (o *UDP_Type) SetTXVC_TXVDIS(value uint32) {
	volatile.StoreUint32(&o.TXVC.Reg, volatile.LoadUint32(&o.TXVC.Reg)&^(0x100)|value<<8)
}
func (o *UDP_Type) GetTXVC_TXVDIS() uint32 {
	return (volatile.LoadUint32(&o.TXVC.Reg) & 0x100) >> 8
}
func (o *UDP_Type) SetTXVC_PUON(value uint32) {
	volatile.StoreUint32(&o.TXVC.Reg, volatile.LoadUint32(&o.TXVC.Reg)&^(0x200)|value<<9)
}
func (o *UDP_Type) GetTXVC_PUON() uint32 {
	return (volatile.LoadUint32(&o.TXVC.Reg) & 0x200) >> 9
}

// Analog-to-Digital Converter
type ADC_Type struct {
	CR    volatile.Register32 // 0x0
	MR    volatile.Register32 // 0x4
	SEQR1 volatile.Register32 // 0x8
	SEQR2 volatile.Register32 // 0xC
	CHER  volatile.Register32 // 0x10
	CHDR  volatile.Register32 // 0x14
	CHSR  volatile.Register32 // 0x18
	_     [4]byte
	LCDR  volatile.Register32 // 0x20
	IER   volatile.Register32 // 0x24
	IDR   volatile.Register32 // 0x28
	IMR   volatile.Register32 // 0x2C
	ISR   volatile.Register32 // 0x30
	_     [8]byte
	OVER  volatile.Register32     // 0x3C
	EMR   volatile.Register32     // 0x40
	CWR   volatile.Register32     // 0x44
	CGR   volatile.Register32     // 0x48
	COR   volatile.Register32     // 0x4C
	CDR   [16]volatile.Register32 // 0x50
	_     [4]byte
	ACR   volatile.Register32 // 0x94
	_     [76]byte
	WPMR  volatile.Register32 // 0xE4
	WPSR  volatile.Register32 // 0xE8
	_     [20]byte
	RPR   volatile.Register32 // 0x100
	RCR   volatile.Register32 // 0x104
	_     [8]byte
	RNPR  volatile.Register32 // 0x110
	RNCR  volatile.Register32 // 0x114
	_     [8]byte
	PTCR  volatile.Register32 // 0x120
	PTSR  volatile.Register32 // 0x124
}

// ADC.CR: Control Register
func (o *ADC_Type) SetCR_SWRST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetCR_SWRST() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *ADC_Type) SetCR_START(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetCR_START() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetCR_AUTOCAL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetCR_AUTOCAL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}

// ADC.MR: Mode Register
func (o *ADC_Type) SetMR_TRGEN(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetMR_TRGEN() uint32 {
	return volatile.LoadUint32(&o.MR.Reg) & 0x1
}
func (o *ADC_Type) SetMR_TRGSEL(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xe)|value<<1)
}
func (o *ADC_Type) GetMR_TRGSEL() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xe) >> 1
}
func (o *ADC_Type) SetMR_SLEEP(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetMR_SLEEP() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetMR_FWUP(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetMR_FWUP() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetMR_FREERUN(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetMR_FREERUN() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetMR_PRESCAL(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xff00)|value<<8)
}
func (o *ADC_Type) GetMR_PRESCAL() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xff00) >> 8
}
func (o *ADC_Type) SetMR_STARTUP(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xf0000)|value<<16)
}
func (o *ADC_Type) GetMR_STARTUP() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xf0000) >> 16
}
func (o *ADC_Type) SetMR_SETTLING(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x300000)|value<<20)
}
func (o *ADC_Type) GetMR_SETTLING() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x300000) >> 20
}
func (o *ADC_Type) SetMR_ANACH(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x800000)|value<<23)
}
func (o *ADC_Type) GetMR_ANACH() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x800000) >> 23
}
func (o *ADC_Type) SetMR_TRACKTIM(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xf000000)|value<<24)
}
func (o *ADC_Type) GetMR_TRACKTIM() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xf000000) >> 24
}
func (o *ADC_Type) SetMR_TRANSFER(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x30000000)|value<<28)
}
func (o *ADC_Type) GetMR_TRANSFER() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x30000000) >> 28
}
func (o *ADC_Type) SetMR_USEQ(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x80000000)|value<<31)
}
func (o *ADC_Type) GetMR_USEQ() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x80000000) >> 31
}

// ADC.SEQR1: Channel Sequence Register 1
func (o *ADC_Type) SetSEQR1_USCH1(value uint32) {
	volatile.StoreUint32(&o.SEQR1.Reg, volatile.LoadUint32(&o.SEQR1.Reg)&^(0xf)|value)
}
func (o *ADC_Type) GetSEQR1_USCH1() uint32 {
	return volatile.LoadUint32(&o.SEQR1.Reg) & 0xf
}
func (o *ADC_Type) SetSEQR1_USCH2(value uint32) {
	volatile.StoreUint32(&o.SEQR1.Reg, volatile.LoadUint32(&o.SEQR1.Reg)&^(0xf0)|value<<4)
}
func (o *ADC_Type) GetSEQR1_USCH2() uint32 {
	return (volatile.LoadUint32(&o.SEQR1.Reg) & 0xf0) >> 4
}
func (o *ADC_Type) SetSEQR1_USCH3(value uint32) {
	volatile.StoreUint32(&o.SEQR1.Reg, volatile.LoadUint32(&o.SEQR1.Reg)&^(0xf00)|value<<8)
}
func (o *ADC_Type) GetSEQR1_USCH3() uint32 {
	return (volatile.LoadUint32(&o.SEQR1.Reg) & 0xf00) >> 8
}
func (o *ADC_Type) SetSEQR1_USCH4(value uint32) {
	volatile.StoreUint32(&o.SEQR1.Reg, volatile.LoadUint32(&o.SEQR1.Reg)&^(0xf000)|value<<12)
}
func (o *ADC_Type) GetSEQR1_USCH4() uint32 {
	return (volatile.LoadUint32(&o.SEQR1.Reg) & 0xf000) >> 12
}
func (o *ADC_Type) SetSEQR1_USCH5(value uint32) {
	volatile.StoreUint32(&o.SEQR1.Reg, volatile.LoadUint32(&o.SEQR1.Reg)&^(0xf0000)|value<<16)
}
func (o *ADC_Type) GetSEQR1_USCH5() uint32 {
	return (volatile.LoadUint32(&o.SEQR1.Reg) & 0xf0000) >> 16
}
func (o *ADC_Type) SetSEQR1_USCH6(value uint32) {
	volatile.StoreUint32(&o.SEQR1.Reg, volatile.LoadUint32(&o.SEQR1.Reg)&^(0xf00000)|value<<20)
}
func (o *ADC_Type) GetSEQR1_USCH6() uint32 {
	return (volatile.LoadUint32(&o.SEQR1.Reg) & 0xf00000) >> 20
}
func (o *ADC_Type) SetSEQR1_USCH7(value uint32) {
	volatile.StoreUint32(&o.SEQR1.Reg, volatile.LoadUint32(&o.SEQR1.Reg)&^(0xf000000)|value<<24)
}
func (o *ADC_Type) GetSEQR1_USCH7() uint32 {
	return (volatile.LoadUint32(&o.SEQR1.Reg) & 0xf000000) >> 24
}
func (o *ADC_Type) SetSEQR1_USCH8(value uint32) {
	volatile.StoreUint32(&o.SEQR1.Reg, volatile.LoadUint32(&o.SEQR1.Reg)&^(0xf0000000)|value<<28)
}
func (o *ADC_Type) GetSEQR1_USCH8() uint32 {
	return (volatile.LoadUint32(&o.SEQR1.Reg) & 0xf0000000) >> 28
}

// ADC.SEQR2: Channel Sequence Register 2
func (o *ADC_Type) SetSEQR2_USCH9(value uint32) {
	volatile.StoreUint32(&o.SEQR2.Reg, volatile.LoadUint32(&o.SEQR2.Reg)&^(0xf)|value)
}
func (o *ADC_Type) GetSEQR2_USCH9() uint32 {
	return volatile.LoadUint32(&o.SEQR2.Reg) & 0xf
}
func (o *ADC_Type) SetSEQR2_USCH10(value uint32) {
	volatile.StoreUint32(&o.SEQR2.Reg, volatile.LoadUint32(&o.SEQR2.Reg)&^(0xf0)|value<<4)
}
func (o *ADC_Type) GetSEQR2_USCH10() uint32 {
	return (volatile.LoadUint32(&o.SEQR2.Reg) & 0xf0) >> 4
}
func (o *ADC_Type) SetSEQR2_USCH11(value uint32) {
	volatile.StoreUint32(&o.SEQR2.Reg, volatile.LoadUint32(&o.SEQR2.Reg)&^(0xf00)|value<<8)
}
func (o *ADC_Type) GetSEQR2_USCH11() uint32 {
	return (volatile.LoadUint32(&o.SEQR2.Reg) & 0xf00) >> 8
}
func (o *ADC_Type) SetSEQR2_USCH12(value uint32) {
	volatile.StoreUint32(&o.SEQR2.Reg, volatile.LoadUint32(&o.SEQR2.Reg)&^(0xf000)|value<<12)
}
func (o *ADC_Type) GetSEQR2_USCH12() uint32 {
	return (volatile.LoadUint32(&o.SEQR2.Reg) & 0xf000) >> 12
}
func (o *ADC_Type) SetSEQR2_USCH13(value uint32) {
	volatile.StoreUint32(&o.SEQR2.Reg, volatile.LoadUint32(&o.SEQR2.Reg)&^(0xf0000)|value<<16)
}
func (o *ADC_Type) GetSEQR2_USCH13() uint32 {
	return (volatile.LoadUint32(&o.SEQR2.Reg) & 0xf0000) >> 16
}
func (o *ADC_Type) SetSEQR2_USCH14(value uint32) {
	volatile.StoreUint32(&o.SEQR2.Reg, volatile.LoadUint32(&o.SEQR2.Reg)&^(0xf00000)|value<<20)
}
func (o *ADC_Type) GetSEQR2_USCH14() uint32 {
	return (volatile.LoadUint32(&o.SEQR2.Reg) & 0xf00000) >> 20
}
func (o *ADC_Type) SetSEQR2_USCH15(value uint32) {
	volatile.StoreUint32(&o.SEQR2.Reg, volatile.LoadUint32(&o.SEQR2.Reg)&^(0xf000000)|value<<24)
}
func (o *ADC_Type) GetSEQR2_USCH15() uint32 {
	return (volatile.LoadUint32(&o.SEQR2.Reg) & 0xf000000) >> 24
}

// ADC.CHER: Channel Enable Register
func (o *ADC_Type) SetCHER_CH0(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetCHER_CH0() uint32 {
	return volatile.LoadUint32(&o.CHER.Reg) & 0x1
}
func (o *ADC_Type) SetCHER_CH1(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetCHER_CH1() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetCHER_CH2(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetCHER_CH2() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetCHER_CH3(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetCHER_CH3() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetCHER_CH4(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetCHER_CH4() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetCHER_CH5(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetCHER_CH5() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetCHER_CH6(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetCHER_CH6() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetCHER_CH7(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetCHER_CH7() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetCHER_CH8(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetCHER_CH8() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetCHER_CH9(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetCHER_CH9() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetCHER_CH10(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetCHER_CH10() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetCHER_CH11(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x800)|value<<11)
}
func (o *ADC_Type) GetCHER_CH11() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x800) >> 11
}
func (o *ADC_Type) SetCHER_CH12(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x1000)|value<<12)
}
func (o *ADC_Type) GetCHER_CH12() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x1000) >> 12
}
func (o *ADC_Type) SetCHER_CH13(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x2000)|value<<13)
}
func (o *ADC_Type) GetCHER_CH13() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x2000) >> 13
}
func (o *ADC_Type) SetCHER_CH14(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x4000)|value<<14)
}
func (o *ADC_Type) GetCHER_CH14() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x4000) >> 14
}
func (o *ADC_Type) SetCHER_CH15(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x8000)|value<<15)
}
func (o *ADC_Type) GetCHER_CH15() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x8000) >> 15
}

// ADC.CHDR: Channel Disable Register
func (o *ADC_Type) SetCHDR_CH0(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetCHDR_CH0() uint32 {
	return volatile.LoadUint32(&o.CHDR.Reg) & 0x1
}
func (o *ADC_Type) SetCHDR_CH1(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetCHDR_CH1() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetCHDR_CH2(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetCHDR_CH2() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetCHDR_CH3(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetCHDR_CH3() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetCHDR_CH4(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetCHDR_CH4() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetCHDR_CH5(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetCHDR_CH5() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetCHDR_CH6(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetCHDR_CH6() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetCHDR_CH7(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetCHDR_CH7() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetCHDR_CH8(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetCHDR_CH8() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetCHDR_CH9(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetCHDR_CH9() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetCHDR_CH10(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetCHDR_CH10() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetCHDR_CH11(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x800)|value<<11)
}
func (o *ADC_Type) GetCHDR_CH11() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x800) >> 11
}
func (o *ADC_Type) SetCHDR_CH12(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x1000)|value<<12)
}
func (o *ADC_Type) GetCHDR_CH12() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x1000) >> 12
}
func (o *ADC_Type) SetCHDR_CH13(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x2000)|value<<13)
}
func (o *ADC_Type) GetCHDR_CH13() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x2000) >> 13
}
func (o *ADC_Type) SetCHDR_CH14(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x4000)|value<<14)
}
func (o *ADC_Type) GetCHDR_CH14() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x4000) >> 14
}
func (o *ADC_Type) SetCHDR_CH15(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x8000)|value<<15)
}
func (o *ADC_Type) GetCHDR_CH15() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x8000) >> 15
}

// ADC.CHSR: Channel Status Register
func (o *ADC_Type) SetCHSR_CH0(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetCHSR_CH0() uint32 {
	return volatile.LoadUint32(&o.CHSR.Reg) & 0x1
}
func (o *ADC_Type) SetCHSR_CH1(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetCHSR_CH1() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetCHSR_CH2(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetCHSR_CH2() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetCHSR_CH3(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetCHSR_CH3() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetCHSR_CH4(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetCHSR_CH4() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetCHSR_CH5(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetCHSR_CH5() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetCHSR_CH6(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetCHSR_CH6() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetCHSR_CH7(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetCHSR_CH7() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetCHSR_CH8(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetCHSR_CH8() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetCHSR_CH9(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetCHSR_CH9() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetCHSR_CH10(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetCHSR_CH10() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetCHSR_CH11(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x800)|value<<11)
}
func (o *ADC_Type) GetCHSR_CH11() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x800) >> 11
}
func (o *ADC_Type) SetCHSR_CH12(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x1000)|value<<12)
}
func (o *ADC_Type) GetCHSR_CH12() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x1000) >> 12
}
func (o *ADC_Type) SetCHSR_CH13(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x2000)|value<<13)
}
func (o *ADC_Type) GetCHSR_CH13() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x2000) >> 13
}
func (o *ADC_Type) SetCHSR_CH14(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x4000)|value<<14)
}
func (o *ADC_Type) GetCHSR_CH14() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x4000) >> 14
}
func (o *ADC_Type) SetCHSR_CH15(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x8000)|value<<15)
}
func (o *ADC_Type) GetCHSR_CH15() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x8000) >> 15
}

// ADC.LCDR: Last Converted Data Register
func (o *ADC_Type) SetLCDR_LDATA(value uint32) {
	volatile.StoreUint32(&o.LCDR.Reg, volatile.LoadUint32(&o.LCDR.Reg)&^(0xfff)|value)
}
func (o *ADC_Type) GetLCDR_LDATA() uint32 {
	return volatile.LoadUint32(&o.LCDR.Reg) & 0xfff
}
func (o *ADC_Type) SetLCDR_CHNB(value uint32) {
	volatile.StoreUint32(&o.LCDR.Reg, volatile.LoadUint32(&o.LCDR.Reg)&^(0xf000)|value<<12)
}
func (o *ADC_Type) GetLCDR_CHNB() uint32 {
	return (volatile.LoadUint32(&o.LCDR.Reg) & 0xf000) >> 12
}

// ADC.IER: Interrupt Enable Register
func (o *ADC_Type) SetIER_EOC0(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetIER_EOC0() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *ADC_Type) SetIER_EOC1(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetIER_EOC1() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetIER_EOC2(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetIER_EOC2() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetIER_EOC3(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetIER_EOC3() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetIER_EOC4(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetIER_EOC4() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetIER_EOC5(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetIER_EOC5() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetIER_EOC6(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetIER_EOC6() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetIER_EOC7(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetIER_EOC7() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetIER_EOC8(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetIER_EOC8() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetIER_EOC9(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetIER_EOC9() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetIER_EOC10(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetIER_EOC10() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetIER_EOC11(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x800)|value<<11)
}
func (o *ADC_Type) GetIER_EOC11() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x800) >> 11
}
func (o *ADC_Type) SetIER_EOC12(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1000)|value<<12)
}
func (o *ADC_Type) GetIER_EOC12() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x1000) >> 12
}
func (o *ADC_Type) SetIER_EOC13(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2000)|value<<13)
}
func (o *ADC_Type) GetIER_EOC13() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2000) >> 13
}
func (o *ADC_Type) SetIER_EOC14(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4000)|value<<14)
}
func (o *ADC_Type) GetIER_EOC14() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4000) >> 14
}
func (o *ADC_Type) SetIER_EOC15(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8000)|value<<15)
}
func (o *ADC_Type) GetIER_EOC15() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8000) >> 15
}
func (o *ADC_Type) SetIER_EOCAL(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x800000)|value<<23)
}
func (o *ADC_Type) GetIER_EOCAL() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x800000) >> 23
}
func (o *ADC_Type) SetIER_DRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1000000)|value<<24)
}
func (o *ADC_Type) GetIER_DRDY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x1000000) >> 24
}
func (o *ADC_Type) SetIER_GOVRE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2000000)|value<<25)
}
func (o *ADC_Type) GetIER_GOVRE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2000000) >> 25
}
func (o *ADC_Type) SetIER_COMPE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4000000)|value<<26)
}
func (o *ADC_Type) GetIER_COMPE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4000000) >> 26
}
func (o *ADC_Type) SetIER_ENDRX(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8000000)|value<<27)
}
func (o *ADC_Type) GetIER_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8000000) >> 27
}
func (o *ADC_Type) SetIER_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10000000)|value<<28)
}
func (o *ADC_Type) GetIER_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10000000) >> 28
}

// ADC.IDR: Interrupt Disable Register
func (o *ADC_Type) SetIDR_EOC0(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetIDR_EOC0() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *ADC_Type) SetIDR_EOC1(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetIDR_EOC1() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetIDR_EOC2(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetIDR_EOC2() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetIDR_EOC3(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetIDR_EOC3() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetIDR_EOC4(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetIDR_EOC4() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetIDR_EOC5(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetIDR_EOC5() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetIDR_EOC6(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetIDR_EOC6() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetIDR_EOC7(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetIDR_EOC7() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetIDR_EOC8(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetIDR_EOC8() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetIDR_EOC9(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetIDR_EOC9() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetIDR_EOC10(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetIDR_EOC10() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetIDR_EOC11(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x800)|value<<11)
}
func (o *ADC_Type) GetIDR_EOC11() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x800) >> 11
}
func (o *ADC_Type) SetIDR_EOC12(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1000)|value<<12)
}
func (o *ADC_Type) GetIDR_EOC12() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x1000) >> 12
}
func (o *ADC_Type) SetIDR_EOC13(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2000)|value<<13)
}
func (o *ADC_Type) GetIDR_EOC13() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2000) >> 13
}
func (o *ADC_Type) SetIDR_EOC14(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4000)|value<<14)
}
func (o *ADC_Type) GetIDR_EOC14() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4000) >> 14
}
func (o *ADC_Type) SetIDR_EOC15(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8000)|value<<15)
}
func (o *ADC_Type) GetIDR_EOC15() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8000) >> 15
}
func (o *ADC_Type) SetIDR_EOCAL(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x800000)|value<<23)
}
func (o *ADC_Type) GetIDR_EOCAL() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x800000) >> 23
}
func (o *ADC_Type) SetIDR_DRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1000000)|value<<24)
}
func (o *ADC_Type) GetIDR_DRDY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x1000000) >> 24
}
func (o *ADC_Type) SetIDR_GOVRE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2000000)|value<<25)
}
func (o *ADC_Type) GetIDR_GOVRE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2000000) >> 25
}
func (o *ADC_Type) SetIDR_COMPE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4000000)|value<<26)
}
func (o *ADC_Type) GetIDR_COMPE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4000000) >> 26
}
func (o *ADC_Type) SetIDR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8000000)|value<<27)
}
func (o *ADC_Type) GetIDR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8000000) >> 27
}
func (o *ADC_Type) SetIDR_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10000000)|value<<28)
}
func (o *ADC_Type) GetIDR_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10000000) >> 28
}

// ADC.IMR: Interrupt Mask Register
func (o *ADC_Type) SetIMR_EOC0(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetIMR_EOC0() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *ADC_Type) SetIMR_EOC1(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetIMR_EOC1() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetIMR_EOC2(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetIMR_EOC2() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetIMR_EOC3(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetIMR_EOC3() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetIMR_EOC4(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetIMR_EOC4() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetIMR_EOC5(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetIMR_EOC5() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetIMR_EOC6(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetIMR_EOC6() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetIMR_EOC7(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetIMR_EOC7() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetIMR_EOC8(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetIMR_EOC8() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetIMR_EOC9(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetIMR_EOC9() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetIMR_EOC10(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetIMR_EOC10() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetIMR_EOC11(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x800)|value<<11)
}
func (o *ADC_Type) GetIMR_EOC11() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x800) >> 11
}
func (o *ADC_Type) SetIMR_EOC12(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1000)|value<<12)
}
func (o *ADC_Type) GetIMR_EOC12() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x1000) >> 12
}
func (o *ADC_Type) SetIMR_EOC13(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2000)|value<<13)
}
func (o *ADC_Type) GetIMR_EOC13() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2000) >> 13
}
func (o *ADC_Type) SetIMR_EOC14(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4000)|value<<14)
}
func (o *ADC_Type) GetIMR_EOC14() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4000) >> 14
}
func (o *ADC_Type) SetIMR_EOC15(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8000)|value<<15)
}
func (o *ADC_Type) GetIMR_EOC15() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8000) >> 15
}
func (o *ADC_Type) SetIMR_EOCAL(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x800000)|value<<23)
}
func (o *ADC_Type) GetIMR_EOCAL() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x800000) >> 23
}
func (o *ADC_Type) SetIMR_DRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1000000)|value<<24)
}
func (o *ADC_Type) GetIMR_DRDY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x1000000) >> 24
}
func (o *ADC_Type) SetIMR_GOVRE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2000000)|value<<25)
}
func (o *ADC_Type) GetIMR_GOVRE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2000000) >> 25
}
func (o *ADC_Type) SetIMR_COMPE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4000000)|value<<26)
}
func (o *ADC_Type) GetIMR_COMPE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4000000) >> 26
}
func (o *ADC_Type) SetIMR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8000000)|value<<27)
}
func (o *ADC_Type) GetIMR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8000000) >> 27
}
func (o *ADC_Type) SetIMR_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10000000)|value<<28)
}
func (o *ADC_Type) GetIMR_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10000000) >> 28
}

// ADC.ISR: Interrupt Status Register
func (o *ADC_Type) SetISR_EOC0(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetISR_EOC0() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}
func (o *ADC_Type) SetISR_EOC1(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetISR_EOC1() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetISR_EOC2(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetISR_EOC2() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetISR_EOC3(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetISR_EOC3() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetISR_EOC4(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetISR_EOC4() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetISR_EOC5(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetISR_EOC5() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetISR_EOC6(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetISR_EOC6() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetISR_EOC7(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetISR_EOC7() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetISR_EOC8(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetISR_EOC8() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetISR_EOC9(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetISR_EOC9() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetISR_EOC10(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetISR_EOC10() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetISR_EOC11(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x800)|value<<11)
}
func (o *ADC_Type) GetISR_EOC11() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x800) >> 11
}
func (o *ADC_Type) SetISR_EOC12(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1000)|value<<12)
}
func (o *ADC_Type) GetISR_EOC12() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x1000) >> 12
}
func (o *ADC_Type) SetISR_EOC13(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2000)|value<<13)
}
func (o *ADC_Type) GetISR_EOC13() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2000) >> 13
}
func (o *ADC_Type) SetISR_EOC14(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4000)|value<<14)
}
func (o *ADC_Type) GetISR_EOC14() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4000) >> 14
}
func (o *ADC_Type) SetISR_EOC15(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8000)|value<<15)
}
func (o *ADC_Type) GetISR_EOC15() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8000) >> 15
}
func (o *ADC_Type) SetISR_EOCAL(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x800000)|value<<23)
}
func (o *ADC_Type) GetISR_EOCAL() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x800000) >> 23
}
func (o *ADC_Type) SetISR_DRDY(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1000000)|value<<24)
}
func (o *ADC_Type) GetISR_DRDY() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x1000000) >> 24
}
func (o *ADC_Type) SetISR_GOVRE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2000000)|value<<25)
}
func (o *ADC_Type) GetISR_GOVRE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2000000) >> 25
}
func (o *ADC_Type) SetISR_COMPE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4000000)|value<<26)
}
func (o *ADC_Type) GetISR_COMPE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4000000) >> 26
}
func (o *ADC_Type) SetISR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8000000)|value<<27)
}
func (o *ADC_Type) GetISR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8000000) >> 27
}
func (o *ADC_Type) SetISR_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10000000)|value<<28)
}
func (o *ADC_Type) GetISR_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10000000) >> 28
}

// ADC.OVER: Overrun Status Register
func (o *ADC_Type) SetOVER_OVRE0(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetOVER_OVRE0() uint32 {
	return volatile.LoadUint32(&o.OVER.Reg) & 0x1
}
func (o *ADC_Type) SetOVER_OVRE1(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetOVER_OVRE1() uint32 {
	return (volatile.LoadUint32(&o.OVER.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetOVER_OVRE2(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetOVER_OVRE2() uint32 {
	return (volatile.LoadUint32(&o.OVER.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetOVER_OVRE3(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetOVER_OVRE3() uint32 {
	return (volatile.LoadUint32(&o.OVER.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetOVER_OVRE4(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetOVER_OVRE4() uint32 {
	return (volatile.LoadUint32(&o.OVER.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetOVER_OVRE5(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetOVER_OVRE5() uint32 {
	return (volatile.LoadUint32(&o.OVER.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetOVER_OVRE6(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetOVER_OVRE6() uint32 {
	return (volatile.LoadUint32(&o.OVER.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetOVER_OVRE7(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetOVER_OVRE7() uint32 {
	return (volatile.LoadUint32(&o.OVER.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetOVER_OVRE8(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetOVER_OVRE8() uint32 {
	return (volatile.LoadUint32(&o.OVER.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetOVER_OVRE9(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetOVER_OVRE9() uint32 {
	return (volatile.LoadUint32(&o.OVER.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetOVER_OVRE10(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetOVER_OVRE10() uint32 {
	return (volatile.LoadUint32(&o.OVER.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetOVER_OVRE11(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x800)|value<<11)
}
func (o *ADC_Type) GetOVER_OVRE11() uint32 {
	return (volatile.LoadUint32(&o.OVER.Reg) & 0x800) >> 11
}
func (o *ADC_Type) SetOVER_OVRE12(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x1000)|value<<12)
}
func (o *ADC_Type) GetOVER_OVRE12() uint32 {
	return (volatile.LoadUint32(&o.OVER.Reg) & 0x1000) >> 12
}
func (o *ADC_Type) SetOVER_OVRE13(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x2000)|value<<13)
}
func (o *ADC_Type) GetOVER_OVRE13() uint32 {
	return (volatile.LoadUint32(&o.OVER.Reg) & 0x2000) >> 13
}
func (o *ADC_Type) SetOVER_OVRE14(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x4000)|value<<14)
}
func (o *ADC_Type) GetOVER_OVRE14() uint32 {
	return (volatile.LoadUint32(&o.OVER.Reg) & 0x4000) >> 14
}
func (o *ADC_Type) SetOVER_OVRE15(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x8000)|value<<15)
}
func (o *ADC_Type) GetOVER_OVRE15() uint32 {
	return (volatile.LoadUint32(&o.OVER.Reg) & 0x8000) >> 15
}

// ADC.EMR: Extended Mode Register
func (o *ADC_Type) SetEMR_CMPMODE(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x3)|value)
}
func (o *ADC_Type) GetEMR_CMPMODE() uint32 {
	return volatile.LoadUint32(&o.EMR.Reg) & 0x3
}
func (o *ADC_Type) SetEMR_CMPSEL(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0xf0)|value<<4)
}
func (o *ADC_Type) GetEMR_CMPSEL() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0xf0) >> 4
}
func (o *ADC_Type) SetEMR_CMPALL(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetEMR_CMPALL() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetEMR_TAG(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x1000000)|value<<24)
}
func (o *ADC_Type) GetEMR_TAG() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x1000000) >> 24
}

// ADC.CWR: Compare Window Register
func (o *ADC_Type) SetCWR_LOWTHRES(value uint32) {
	volatile.StoreUint32(&o.CWR.Reg, volatile.LoadUint32(&o.CWR.Reg)&^(0xfff)|value)
}
func (o *ADC_Type) GetCWR_LOWTHRES() uint32 {
	return volatile.LoadUint32(&o.CWR.Reg) & 0xfff
}
func (o *ADC_Type) SetCWR_HIGHTHRES(value uint32) {
	volatile.StoreUint32(&o.CWR.Reg, volatile.LoadUint32(&o.CWR.Reg)&^(0xfff0000)|value<<16)
}
func (o *ADC_Type) GetCWR_HIGHTHRES() uint32 {
	return (volatile.LoadUint32(&o.CWR.Reg) & 0xfff0000) >> 16
}

// ADC.CGR: Channel Gain Register
func (o *ADC_Type) SetCGR_GAIN0(value uint32) {
	volatile.StoreUint32(&o.CGR.Reg, volatile.LoadUint32(&o.CGR.Reg)&^(0x3)|value)
}
func (o *ADC_Type) GetCGR_GAIN0() uint32 {
	return volatile.LoadUint32(&o.CGR.Reg) & 0x3
}
func (o *ADC_Type) SetCGR_GAIN1(value uint32) {
	volatile.StoreUint32(&o.CGR.Reg, volatile.LoadUint32(&o.CGR.Reg)&^(0xc)|value<<2)
}
func (o *ADC_Type) GetCGR_GAIN1() uint32 {
	return (volatile.LoadUint32(&o.CGR.Reg) & 0xc) >> 2
}
func (o *ADC_Type) SetCGR_GAIN2(value uint32) {
	volatile.StoreUint32(&o.CGR.Reg, volatile.LoadUint32(&o.CGR.Reg)&^(0x30)|value<<4)
}
func (o *ADC_Type) GetCGR_GAIN2() uint32 {
	return (volatile.LoadUint32(&o.CGR.Reg) & 0x30) >> 4
}
func (o *ADC_Type) SetCGR_GAIN3(value uint32) {
	volatile.StoreUint32(&o.CGR.Reg, volatile.LoadUint32(&o.CGR.Reg)&^(0xc0)|value<<6)
}
func (o *ADC_Type) GetCGR_GAIN3() uint32 {
	return (volatile.LoadUint32(&o.CGR.Reg) & 0xc0) >> 6
}
func (o *ADC_Type) SetCGR_GAIN4(value uint32) {
	volatile.StoreUint32(&o.CGR.Reg, volatile.LoadUint32(&o.CGR.Reg)&^(0x300)|value<<8)
}
func (o *ADC_Type) GetCGR_GAIN4() uint32 {
	return (volatile.LoadUint32(&o.CGR.Reg) & 0x300) >> 8
}
func (o *ADC_Type) SetCGR_GAIN5(value uint32) {
	volatile.StoreUint32(&o.CGR.Reg, volatile.LoadUint32(&o.CGR.Reg)&^(0xc00)|value<<10)
}
func (o *ADC_Type) GetCGR_GAIN5() uint32 {
	return (volatile.LoadUint32(&o.CGR.Reg) & 0xc00) >> 10
}
func (o *ADC_Type) SetCGR_GAIN6(value uint32) {
	volatile.StoreUint32(&o.CGR.Reg, volatile.LoadUint32(&o.CGR.Reg)&^(0x3000)|value<<12)
}
func (o *ADC_Type) GetCGR_GAIN6() uint32 {
	return (volatile.LoadUint32(&o.CGR.Reg) & 0x3000) >> 12
}
func (o *ADC_Type) SetCGR_GAIN7(value uint32) {
	volatile.StoreUint32(&o.CGR.Reg, volatile.LoadUint32(&o.CGR.Reg)&^(0xc000)|value<<14)
}
func (o *ADC_Type) GetCGR_GAIN7() uint32 {
	return (volatile.LoadUint32(&o.CGR.Reg) & 0xc000) >> 14
}
func (o *ADC_Type) SetCGR_GAIN8(value uint32) {
	volatile.StoreUint32(&o.CGR.Reg, volatile.LoadUint32(&o.CGR.Reg)&^(0x30000)|value<<16)
}
func (o *ADC_Type) GetCGR_GAIN8() uint32 {
	return (volatile.LoadUint32(&o.CGR.Reg) & 0x30000) >> 16
}
func (o *ADC_Type) SetCGR_GAIN9(value uint32) {
	volatile.StoreUint32(&o.CGR.Reg, volatile.LoadUint32(&o.CGR.Reg)&^(0xc0000)|value<<18)
}
func (o *ADC_Type) GetCGR_GAIN9() uint32 {
	return (volatile.LoadUint32(&o.CGR.Reg) & 0xc0000) >> 18
}
func (o *ADC_Type) SetCGR_GAIN10(value uint32) {
	volatile.StoreUint32(&o.CGR.Reg, volatile.LoadUint32(&o.CGR.Reg)&^(0x300000)|value<<20)
}
func (o *ADC_Type) GetCGR_GAIN10() uint32 {
	return (volatile.LoadUint32(&o.CGR.Reg) & 0x300000) >> 20
}
func (o *ADC_Type) SetCGR_GAIN11(value uint32) {
	volatile.StoreUint32(&o.CGR.Reg, volatile.LoadUint32(&o.CGR.Reg)&^(0xc00000)|value<<22)
}
func (o *ADC_Type) GetCGR_GAIN11() uint32 {
	return (volatile.LoadUint32(&o.CGR.Reg) & 0xc00000) >> 22
}
func (o *ADC_Type) SetCGR_GAIN12(value uint32) {
	volatile.StoreUint32(&o.CGR.Reg, volatile.LoadUint32(&o.CGR.Reg)&^(0x3000000)|value<<24)
}
func (o *ADC_Type) GetCGR_GAIN12() uint32 {
	return (volatile.LoadUint32(&o.CGR.Reg) & 0x3000000) >> 24
}
func (o *ADC_Type) SetCGR_GAIN13(value uint32) {
	volatile.StoreUint32(&o.CGR.Reg, volatile.LoadUint32(&o.CGR.Reg)&^(0xc000000)|value<<26)
}
func (o *ADC_Type) GetCGR_GAIN13() uint32 {
	return (volatile.LoadUint32(&o.CGR.Reg) & 0xc000000) >> 26
}
func (o *ADC_Type) SetCGR_GAIN14(value uint32) {
	volatile.StoreUint32(&o.CGR.Reg, volatile.LoadUint32(&o.CGR.Reg)&^(0x30000000)|value<<28)
}
func (o *ADC_Type) GetCGR_GAIN14() uint32 {
	return (volatile.LoadUint32(&o.CGR.Reg) & 0x30000000) >> 28
}
func (o *ADC_Type) SetCGR_GAIN15(value uint32) {
	volatile.StoreUint32(&o.CGR.Reg, volatile.LoadUint32(&o.CGR.Reg)&^(0xc0000000)|value<<30)
}
func (o *ADC_Type) GetCGR_GAIN15() uint32 {
	return (volatile.LoadUint32(&o.CGR.Reg) & 0xc0000000) >> 30
}

// ADC.COR: Channel Offset Register
func (o *ADC_Type) SetCOR_OFF0(value uint32) {
	volatile.StoreUint32(&o.COR.Reg, volatile.LoadUint32(&o.COR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetCOR_OFF0() uint32 {
	return volatile.LoadUint32(&o.COR.Reg) & 0x1
}
func (o *ADC_Type) SetCOR_OFF1(value uint32) {
	volatile.StoreUint32(&o.COR.Reg, volatile.LoadUint32(&o.COR.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetCOR_OFF1() uint32 {
	return (volatile.LoadUint32(&o.COR.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetCOR_OFF2(value uint32) {
	volatile.StoreUint32(&o.COR.Reg, volatile.LoadUint32(&o.COR.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetCOR_OFF2() uint32 {
	return (volatile.LoadUint32(&o.COR.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetCOR_OFF3(value uint32) {
	volatile.StoreUint32(&o.COR.Reg, volatile.LoadUint32(&o.COR.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetCOR_OFF3() uint32 {
	return (volatile.LoadUint32(&o.COR.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetCOR_OFF4(value uint32) {
	volatile.StoreUint32(&o.COR.Reg, volatile.LoadUint32(&o.COR.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetCOR_OFF4() uint32 {
	return (volatile.LoadUint32(&o.COR.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetCOR_OFF5(value uint32) {
	volatile.StoreUint32(&o.COR.Reg, volatile.LoadUint32(&o.COR.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetCOR_OFF5() uint32 {
	return (volatile.LoadUint32(&o.COR.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetCOR_OFF6(value uint32) {
	volatile.StoreUint32(&o.COR.Reg, volatile.LoadUint32(&o.COR.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetCOR_OFF6() uint32 {
	return (volatile.LoadUint32(&o.COR.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetCOR_OFF7(value uint32) {
	volatile.StoreUint32(&o.COR.Reg, volatile.LoadUint32(&o.COR.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetCOR_OFF7() uint32 {
	return (volatile.LoadUint32(&o.COR.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetCOR_OFF8(value uint32) {
	volatile.StoreUint32(&o.COR.Reg, volatile.LoadUint32(&o.COR.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetCOR_OFF8() uint32 {
	return (volatile.LoadUint32(&o.COR.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetCOR_OFF9(value uint32) {
	volatile.StoreUint32(&o.COR.Reg, volatile.LoadUint32(&o.COR.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetCOR_OFF9() uint32 {
	return (volatile.LoadUint32(&o.COR.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetCOR_OFF10(value uint32) {
	volatile.StoreUint32(&o.COR.Reg, volatile.LoadUint32(&o.COR.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetCOR_OFF10() uint32 {
	return (volatile.LoadUint32(&o.COR.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetCOR_OFF11(value uint32) {
	volatile.StoreUint32(&o.COR.Reg, volatile.LoadUint32(&o.COR.Reg)&^(0x800)|value<<11)
}
func (o *ADC_Type) GetCOR_OFF11() uint32 {
	return (volatile.LoadUint32(&o.COR.Reg) & 0x800) >> 11
}
func (o *ADC_Type) SetCOR_OFF12(value uint32) {
	volatile.StoreUint32(&o.COR.Reg, volatile.LoadUint32(&o.COR.Reg)&^(0x1000)|value<<12)
}
func (o *ADC_Type) GetCOR_OFF12() uint32 {
	return (volatile.LoadUint32(&o.COR.Reg) & 0x1000) >> 12
}
func (o *ADC_Type) SetCOR_OFF13(value uint32) {
	volatile.StoreUint32(&o.COR.Reg, volatile.LoadUint32(&o.COR.Reg)&^(0x2000)|value<<13)
}
func (o *ADC_Type) GetCOR_OFF13() uint32 {
	return (volatile.LoadUint32(&o.COR.Reg) & 0x2000) >> 13
}
func (o *ADC_Type) SetCOR_OFF14(value uint32) {
	volatile.StoreUint32(&o.COR.Reg, volatile.LoadUint32(&o.COR.Reg)&^(0x4000)|value<<14)
}
func (o *ADC_Type) GetCOR_OFF14() uint32 {
	return (volatile.LoadUint32(&o.COR.Reg) & 0x4000) >> 14
}
func (o *ADC_Type) SetCOR_OFF15(value uint32) {
	volatile.StoreUint32(&o.COR.Reg, volatile.LoadUint32(&o.COR.Reg)&^(0x8000)|value<<15)
}
func (o *ADC_Type) GetCOR_OFF15() uint32 {
	return (volatile.LoadUint32(&o.COR.Reg) & 0x8000) >> 15
}
func (o *ADC_Type) SetCOR_DIFF0(value uint32) {
	volatile.StoreUint32(&o.COR.Reg, volatile.LoadUint32(&o.COR.Reg)&^(0x10000)|value<<16)
}
func (o *ADC_Type) GetCOR_DIFF0() uint32 {
	return (volatile.LoadUint32(&o.COR.Reg) & 0x10000) >> 16
}
func (o *ADC_Type) SetCOR_DIFF1(value uint32) {
	volatile.StoreUint32(&o.COR.Reg, volatile.LoadUint32(&o.COR.Reg)&^(0x20000)|value<<17)
}
func (o *ADC_Type) GetCOR_DIFF1() uint32 {
	return (volatile.LoadUint32(&o.COR.Reg) & 0x20000) >> 17
}
func (o *ADC_Type) SetCOR_DIFF2(value uint32) {
	volatile.StoreUint32(&o.COR.Reg, volatile.LoadUint32(&o.COR.Reg)&^(0x40000)|value<<18)
}
func (o *ADC_Type) GetCOR_DIFF2() uint32 {
	return (volatile.LoadUint32(&o.COR.Reg) & 0x40000) >> 18
}
func (o *ADC_Type) SetCOR_DIFF3(value uint32) {
	volatile.StoreUint32(&o.COR.Reg, volatile.LoadUint32(&o.COR.Reg)&^(0x80000)|value<<19)
}
func (o *ADC_Type) GetCOR_DIFF3() uint32 {
	return (volatile.LoadUint32(&o.COR.Reg) & 0x80000) >> 19
}
func (o *ADC_Type) SetCOR_DIFF4(value uint32) {
	volatile.StoreUint32(&o.COR.Reg, volatile.LoadUint32(&o.COR.Reg)&^(0x100000)|value<<20)
}
func (o *ADC_Type) GetCOR_DIFF4() uint32 {
	return (volatile.LoadUint32(&o.COR.Reg) & 0x100000) >> 20
}
func (o *ADC_Type) SetCOR_DIFF5(value uint32) {
	volatile.StoreUint32(&o.COR.Reg, volatile.LoadUint32(&o.COR.Reg)&^(0x200000)|value<<21)
}
func (o *ADC_Type) GetCOR_DIFF5() uint32 {
	return (volatile.LoadUint32(&o.COR.Reg) & 0x200000) >> 21
}
func (o *ADC_Type) SetCOR_DIFF6(value uint32) {
	volatile.StoreUint32(&o.COR.Reg, volatile.LoadUint32(&o.COR.Reg)&^(0x400000)|value<<22)
}
func (o *ADC_Type) GetCOR_DIFF6() uint32 {
	return (volatile.LoadUint32(&o.COR.Reg) & 0x400000) >> 22
}
func (o *ADC_Type) SetCOR_DIFF7(value uint32) {
	volatile.StoreUint32(&o.COR.Reg, volatile.LoadUint32(&o.COR.Reg)&^(0x800000)|value<<23)
}
func (o *ADC_Type) GetCOR_DIFF7() uint32 {
	return (volatile.LoadUint32(&o.COR.Reg) & 0x800000) >> 23
}
func (o *ADC_Type) SetCOR_DIFF8(value uint32) {
	volatile.StoreUint32(&o.COR.Reg, volatile.LoadUint32(&o.COR.Reg)&^(0x1000000)|value<<24)
}
func (o *ADC_Type) GetCOR_DIFF8() uint32 {
	return (volatile.LoadUint32(&o.COR.Reg) & 0x1000000) >> 24
}
func (o *ADC_Type) SetCOR_DIFF9(value uint32) {
	volatile.StoreUint32(&o.COR.Reg, volatile.LoadUint32(&o.COR.Reg)&^(0x2000000)|value<<25)
}
func (o *ADC_Type) GetCOR_DIFF9() uint32 {
	return (volatile.LoadUint32(&o.COR.Reg) & 0x2000000) >> 25
}
func (o *ADC_Type) SetCOR_DIFF10(value uint32) {
	volatile.StoreUint32(&o.COR.Reg, volatile.LoadUint32(&o.COR.Reg)&^(0x4000000)|value<<26)
}
func (o *ADC_Type) GetCOR_DIFF10() uint32 {
	return (volatile.LoadUint32(&o.COR.Reg) & 0x4000000) >> 26
}
func (o *ADC_Type) SetCOR_DIFF11(value uint32) {
	volatile.StoreUint32(&o.COR.Reg, volatile.LoadUint32(&o.COR.Reg)&^(0x8000000)|value<<27)
}
func (o *ADC_Type) GetCOR_DIFF11() uint32 {
	return (volatile.LoadUint32(&o.COR.Reg) & 0x8000000) >> 27
}
func (o *ADC_Type) SetCOR_DIFF12(value uint32) {
	volatile.StoreUint32(&o.COR.Reg, volatile.LoadUint32(&o.COR.Reg)&^(0x10000000)|value<<28)
}
func (o *ADC_Type) GetCOR_DIFF12() uint32 {
	return (volatile.LoadUint32(&o.COR.Reg) & 0x10000000) >> 28
}
func (o *ADC_Type) SetCOR_DIFF13(value uint32) {
	volatile.StoreUint32(&o.COR.Reg, volatile.LoadUint32(&o.COR.Reg)&^(0x20000000)|value<<29)
}
func (o *ADC_Type) GetCOR_DIFF13() uint32 {
	return (volatile.LoadUint32(&o.COR.Reg) & 0x20000000) >> 29
}
func (o *ADC_Type) SetCOR_DIFF14(value uint32) {
	volatile.StoreUint32(&o.COR.Reg, volatile.LoadUint32(&o.COR.Reg)&^(0x40000000)|value<<30)
}
func (o *ADC_Type) GetCOR_DIFF14() uint32 {
	return (volatile.LoadUint32(&o.COR.Reg) & 0x40000000) >> 30
}
func (o *ADC_Type) SetCOR_DIFF15(value uint32) {
	volatile.StoreUint32(&o.COR.Reg, volatile.LoadUint32(&o.COR.Reg)&^(0x80000000)|value<<31)
}
func (o *ADC_Type) GetCOR_DIFF15() uint32 {
	return (volatile.LoadUint32(&o.COR.Reg) & 0x80000000) >> 31
}

// ADC.CDR: Channel Data Register
func (o *ADC_Type) SetCDR_DATA(idx int, value uint32) {
	volatile.StoreUint32(&o.CDR[idx].Reg, volatile.LoadUint32(&o.CDR[idx].Reg)&^(0xfff)|value)
}
func (o *ADC_Type) GetCDR_DATA(idx int) uint32 {
	return volatile.LoadUint32(&o.CDR[idx].Reg) & 0xfff
}

// ADC.ACR: Analog Control Register
func (o *ADC_Type) SetACR_TSON(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetACR_TSON() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetACR_IBCTL(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x300)|value<<8)
}
func (o *ADC_Type) GetACR_IBCTL() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x300) >> 8
}

// ADC.WPMR: Write Protection Mode Register
func (o *ADC_Type) SetWPMR_WPEN(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetWPMR_WPEN() uint32 {
	return volatile.LoadUint32(&o.WPMR.Reg) & 0x1
}
func (o *ADC_Type) SetWPMR_WPKEY(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0xffffff00)|value<<8)
}
func (o *ADC_Type) GetWPMR_WPKEY() uint32 {
	return (volatile.LoadUint32(&o.WPMR.Reg) & 0xffffff00) >> 8
}

// ADC.WPSR: Write Protection Status Register
func (o *ADC_Type) SetWPSR_WPVS(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetWPSR_WPVS() uint32 {
	return volatile.LoadUint32(&o.WPSR.Reg) & 0x1
}
func (o *ADC_Type) SetWPSR_WPVSRC(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0xffff00)|value<<8)
}
func (o *ADC_Type) GetWPSR_WPVSRC() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0xffff00) >> 8
}

// ADC.RPR: Receive Pointer Register
func (o *ADC_Type) SetRPR(value uint32) {
	volatile.StoreUint32(&o.RPR.Reg, value)
}
func (o *ADC_Type) GetRPR() uint32 {
	return volatile.LoadUint32(&o.RPR.Reg)
}

// ADC.RCR: Receive Counter Register
func (o *ADC_Type) SetRCR_RXCTR(value uint32) {
	volatile.StoreUint32(&o.RCR.Reg, volatile.LoadUint32(&o.RCR.Reg)&^(0xffff)|value)
}
func (o *ADC_Type) GetRCR_RXCTR() uint32 {
	return volatile.LoadUint32(&o.RCR.Reg) & 0xffff
}

// ADC.RNPR: Receive Next Pointer Register
func (o *ADC_Type) SetRNPR(value uint32) {
	volatile.StoreUint32(&o.RNPR.Reg, value)
}
func (o *ADC_Type) GetRNPR() uint32 {
	return volatile.LoadUint32(&o.RNPR.Reg)
}

// ADC.RNCR: Receive Next Counter Register
func (o *ADC_Type) SetRNCR_RXNCTR(value uint32) {
	volatile.StoreUint32(&o.RNCR.Reg, volatile.LoadUint32(&o.RNCR.Reg)&^(0xffff)|value)
}
func (o *ADC_Type) GetRNCR_RXNCTR() uint32 {
	return volatile.LoadUint32(&o.RNCR.Reg) & 0xffff
}

// ADC.PTCR: Transfer Control Register
func (o *ADC_Type) SetPTCR_RXTEN(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetPTCR_RXTEN() uint32 {
	return volatile.LoadUint32(&o.PTCR.Reg) & 0x1
}
func (o *ADC_Type) SetPTCR_RXTDIS(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetPTCR_RXTDIS() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetPTCR_TXTEN(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetPTCR_TXTEN() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetPTCR_TXTDIS(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetPTCR_TXTDIS() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x200) >> 9
}

// ADC.PTSR: Transfer Status Register
func (o *ADC_Type) SetPTSR_RXTEN(value uint32) {
	volatile.StoreUint32(&o.PTSR.Reg, volatile.LoadUint32(&o.PTSR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetPTSR_RXTEN() uint32 {
	return volatile.LoadUint32(&o.PTSR.Reg) & 0x1
}
func (o *ADC_Type) SetPTSR_TXTEN(value uint32) {
	volatile.StoreUint32(&o.PTSR.Reg, volatile.LoadUint32(&o.PTSR.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetPTSR_TXTEN() uint32 {
	return (volatile.LoadUint32(&o.PTSR.Reg) & 0x100) >> 8
}

// Digital-to-Analog Converter Controller
type DACC_Type struct {
	CR   volatile.Register32 // 0x0
	MR   volatile.Register32 // 0x4
	_    [8]byte
	CHER volatile.Register32 // 0x10
	CHDR volatile.Register32 // 0x14
	CHSR volatile.Register32 // 0x18
	_    [4]byte
	CDR  volatile.Register32 // 0x20
	IER  volatile.Register32 // 0x24
	IDR  volatile.Register32 // 0x28
	IMR  volatile.Register32 // 0x2C
	ISR  volatile.Register32 // 0x30
	_    [96]byte
	ACR  volatile.Register32 // 0x94
	_    [76]byte
	WPMR volatile.Register32 // 0xE4
	WPSR volatile.Register32 // 0xE8
	_    [28]byte
	TPR  volatile.Register32 // 0x108
	TCR  volatile.Register32 // 0x10C
	_    [8]byte
	TNPR volatile.Register32 // 0x118
	TNCR volatile.Register32 // 0x11C
	PTCR volatile.Register32 // 0x120
	PTSR volatile.Register32 // 0x124
}

// DACC.CR: Control Register
func (o *DACC_Type) SetCR_SWRST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *DACC_Type) GetCR_SWRST() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}

// DACC.MR: Mode Register
func (o *DACC_Type) SetMR_TRGEN(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x1)|value)
}
func (o *DACC_Type) GetMR_TRGEN() uint32 {
	return volatile.LoadUint32(&o.MR.Reg) & 0x1
}
func (o *DACC_Type) SetMR_TRGSEL(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xe)|value<<1)
}
func (o *DACC_Type) GetMR_TRGSEL() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xe) >> 1
}
func (o *DACC_Type) SetMR_WORD(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x10)|value<<4)
}
func (o *DACC_Type) GetMR_WORD() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x10) >> 4
}
func (o *DACC_Type) SetMR_ONE(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x100)|value<<8)
}
func (o *DACC_Type) GetMR_ONE() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x100) >> 8
}
func (o *DACC_Type) SetMR_USER_SEL(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x30000)|value<<16)
}
func (o *DACC_Type) GetMR_USER_SEL() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x30000) >> 16
}
func (o *DACC_Type) SetMR_TAG(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x100000)|value<<20)
}
func (o *DACC_Type) GetMR_TAG() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x100000) >> 20
}
func (o *DACC_Type) SetMR_MAXS(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x200000)|value<<21)
}
func (o *DACC_Type) GetMR_MAXS() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x200000) >> 21
}
func (o *DACC_Type) SetMR_STARTUP(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x3f000000)|value<<24)
}
func (o *DACC_Type) GetMR_STARTUP() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x3f000000) >> 24
}

// DACC.CHER: Channel Enable Register
func (o *DACC_Type) SetCHER_CH0(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x1)|value)
}
func (o *DACC_Type) GetCHER_CH0() uint32 {
	return volatile.LoadUint32(&o.CHER.Reg) & 0x1
}
func (o *DACC_Type) SetCHER_CH1(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x2)|value<<1)
}
func (o *DACC_Type) GetCHER_CH1() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x2) >> 1
}

// DACC.CHDR: Channel Disable Register
func (o *DACC_Type) SetCHDR_CH0(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x1)|value)
}
func (o *DACC_Type) GetCHDR_CH0() uint32 {
	return volatile.LoadUint32(&o.CHDR.Reg) & 0x1
}
func (o *DACC_Type) SetCHDR_CH1(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x2)|value<<1)
}
func (o *DACC_Type) GetCHDR_CH1() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x2) >> 1
}

// DACC.CHSR: Channel Status Register
func (o *DACC_Type) SetCHSR_CH0(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x1)|value)
}
func (o *DACC_Type) GetCHSR_CH0() uint32 {
	return volatile.LoadUint32(&o.CHSR.Reg) & 0x1
}
func (o *DACC_Type) SetCHSR_CH1(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x2)|value<<1)
}
func (o *DACC_Type) GetCHSR_CH1() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x2) >> 1
}

// DACC.CDR: Conversion Data Register
func (o *DACC_Type) SetCDR(value uint32) {
	volatile.StoreUint32(&o.CDR.Reg, value)
}
func (o *DACC_Type) GetCDR() uint32 {
	return volatile.LoadUint32(&o.CDR.Reg)
}

// DACC.IER: Interrupt Enable Register
func (o *DACC_Type) SetIER_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *DACC_Type) GetIER_TXRDY() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *DACC_Type) SetIER_EOC(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *DACC_Type) GetIER_EOC() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *DACC_Type) SetIER_ENDTX(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *DACC_Type) GetIER_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *DACC_Type) SetIER_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *DACC_Type) GetIER_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}

// DACC.IDR: Interrupt Disable Register
func (o *DACC_Type) SetIDR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *DACC_Type) GetIDR_TXRDY() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *DACC_Type) SetIDR_EOC(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *DACC_Type) GetIDR_EOC() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *DACC_Type) SetIDR_ENDTX(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4)|value<<2)
}
func (o *DACC_Type) GetIDR_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4) >> 2
}
func (o *DACC_Type) SetIDR_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8)|value<<3)
}
func (o *DACC_Type) GetIDR_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8) >> 3
}

// DACC.IMR: Interrupt Mask Register
func (o *DACC_Type) SetIMR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *DACC_Type) GetIMR_TXRDY() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *DACC_Type) SetIMR_EOC(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *DACC_Type) GetIMR_EOC() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *DACC_Type) SetIMR_ENDTX(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4)|value<<2)
}
func (o *DACC_Type) GetIMR_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4) >> 2
}
func (o *DACC_Type) SetIMR_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8)|value<<3)
}
func (o *DACC_Type) GetIMR_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8) >> 3
}

// DACC.ISR: Interrupt Status Register
func (o *DACC_Type) SetISR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *DACC_Type) GetISR_TXRDY() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}
func (o *DACC_Type) SetISR_EOC(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *DACC_Type) GetISR_EOC() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *DACC_Type) SetISR_ENDTX(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *DACC_Type) GetISR_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *DACC_Type) SetISR_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *DACC_Type) GetISR_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}

// DACC.ACR: Analog Current Register
func (o *DACC_Type) SetACR_IBCTLCH0(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x3)|value)
}
func (o *DACC_Type) GetACR_IBCTLCH0() uint32 {
	return volatile.LoadUint32(&o.ACR.Reg) & 0x3
}
func (o *DACC_Type) SetACR_IBCTLCH1(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0xc)|value<<2)
}
func (o *DACC_Type) GetACR_IBCTLCH1() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0xc) >> 2
}
func (o *DACC_Type) SetACR_IBCTLDACCORE(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x300)|value<<8)
}
func (o *DACC_Type) GetACR_IBCTLDACCORE() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x300) >> 8
}

// DACC.WPMR: Write Protection Mode Register
func (o *DACC_Type) SetWPMR_WPEN(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0x1)|value)
}
func (o *DACC_Type) GetWPMR_WPEN() uint32 {
	return volatile.LoadUint32(&o.WPMR.Reg) & 0x1
}
func (o *DACC_Type) SetWPMR_WPKEY(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0xffffff00)|value<<8)
}
func (o *DACC_Type) GetWPMR_WPKEY() uint32 {
	return (volatile.LoadUint32(&o.WPMR.Reg) & 0xffffff00) >> 8
}

// DACC.WPSR: Write Protection Status Register
func (o *DACC_Type) SetWPSR_WPVS(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x1)|value)
}
func (o *DACC_Type) GetWPSR_WPVS() uint32 {
	return volatile.LoadUint32(&o.WPSR.Reg) & 0x1
}
func (o *DACC_Type) SetWPSR_WPVSRC(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0xff00)|value<<8)
}
func (o *DACC_Type) GetWPSR_WPVSRC() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0xff00) >> 8
}

// DACC.TPR: Transmit Pointer Register
func (o *DACC_Type) SetTPR(value uint32) {
	volatile.StoreUint32(&o.TPR.Reg, value)
}
func (o *DACC_Type) GetTPR() uint32 {
	return volatile.LoadUint32(&o.TPR.Reg)
}

// DACC.TCR: Transmit Counter Register
func (o *DACC_Type) SetTCR_TXCTR(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0xffff)|value)
}
func (o *DACC_Type) GetTCR_TXCTR() uint32 {
	return volatile.LoadUint32(&o.TCR.Reg) & 0xffff
}

// DACC.TNPR: Transmit Next Pointer Register
func (o *DACC_Type) SetTNPR(value uint32) {
	volatile.StoreUint32(&o.TNPR.Reg, value)
}
func (o *DACC_Type) GetTNPR() uint32 {
	return volatile.LoadUint32(&o.TNPR.Reg)
}

// DACC.TNCR: Transmit Next Counter Register
func (o *DACC_Type) SetTNCR_TXNCTR(value uint32) {
	volatile.StoreUint32(&o.TNCR.Reg, volatile.LoadUint32(&o.TNCR.Reg)&^(0xffff)|value)
}
func (o *DACC_Type) GetTNCR_TXNCTR() uint32 {
	return volatile.LoadUint32(&o.TNCR.Reg) & 0xffff
}

// DACC.PTCR: Transfer Control Register
func (o *DACC_Type) SetPTCR_RXTEN(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x1)|value)
}
func (o *DACC_Type) GetPTCR_RXTEN() uint32 {
	return volatile.LoadUint32(&o.PTCR.Reg) & 0x1
}
func (o *DACC_Type) SetPTCR_RXTDIS(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x2)|value<<1)
}
func (o *DACC_Type) GetPTCR_RXTDIS() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x2) >> 1
}
func (o *DACC_Type) SetPTCR_TXTEN(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x100)|value<<8)
}
func (o *DACC_Type) GetPTCR_TXTEN() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x100) >> 8
}
func (o *DACC_Type) SetPTCR_TXTDIS(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x200)|value<<9)
}
func (o *DACC_Type) GetPTCR_TXTDIS() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x200) >> 9
}

// DACC.PTSR: Transfer Status Register
func (o *DACC_Type) SetPTSR_RXTEN(value uint32) {
	volatile.StoreUint32(&o.PTSR.Reg, volatile.LoadUint32(&o.PTSR.Reg)&^(0x1)|value)
}
func (o *DACC_Type) GetPTSR_RXTEN() uint32 {
	return volatile.LoadUint32(&o.PTSR.Reg) & 0x1
}
func (o *DACC_Type) SetPTSR_TXTEN(value uint32) {
	volatile.StoreUint32(&o.PTSR.Reg, volatile.LoadUint32(&o.PTSR.Reg)&^(0x100)|value<<8)
}
func (o *DACC_Type) GetPTSR_TXTEN() uint32 {
	return (volatile.LoadUint32(&o.PTSR.Reg) & 0x100) >> 8
}

// Analog Comparator Controller
type ACC_Type struct {
	CR   volatile.Register32 // 0x0
	MR   volatile.Register32 // 0x4
	_    [28]byte
	IER  volatile.Register32 // 0x24
	IDR  volatile.Register32 // 0x28
	IMR  volatile.Register32 // 0x2C
	ISR  volatile.Register32 // 0x30
	_    [96]byte
	ACR  volatile.Register32 // 0x94
	_    [76]byte
	WPMR volatile.Register32 // 0xE4
	WPSR volatile.Register32 // 0xE8
}

// ACC.CR: Control Register
func (o *ACC_Type) SetCR_SWRST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *ACC_Type) GetCR_SWRST() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}

// ACC.MR: Mode Register
func (o *ACC_Type) SetMR_SELMINUS(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x7)|value)
}
func (o *ACC_Type) GetMR_SELMINUS() uint32 {
	return volatile.LoadUint32(&o.MR.Reg) & 0x7
}
func (o *ACC_Type) SetMR_SELPLUS(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x70)|value<<4)
}
func (o *ACC_Type) GetMR_SELPLUS() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x70) >> 4
}
func (o *ACC_Type) SetMR_ACEN(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x100)|value<<8)
}
func (o *ACC_Type) GetMR_ACEN() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x100) >> 8
}
func (o *ACC_Type) SetMR_EDGETYP(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x600)|value<<9)
}
func (o *ACC_Type) GetMR_EDGETYP() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x600) >> 9
}
func (o *ACC_Type) SetMR_INV(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x1000)|value<<12)
}
func (o *ACC_Type) GetMR_INV() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x1000) >> 12
}
func (o *ACC_Type) SetMR_SELFS(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x2000)|value<<13)
}
func (o *ACC_Type) GetMR_SELFS() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x2000) >> 13
}
func (o *ACC_Type) SetMR_FE(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x4000)|value<<14)
}
func (o *ACC_Type) GetMR_FE() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x4000) >> 14
}

// ACC.IER: Interrupt Enable Register
func (o *ACC_Type) SetIER_CE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *ACC_Type) GetIER_CE() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}

// ACC.IDR: Interrupt Disable Register
func (o *ACC_Type) SetIDR_CE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *ACC_Type) GetIDR_CE() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}

// ACC.IMR: Interrupt Mask Register
func (o *ACC_Type) SetIMR_CE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *ACC_Type) GetIMR_CE() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}

// ACC.ISR: Interrupt Status Register
func (o *ACC_Type) SetISR_CE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *ACC_Type) GetISR_CE() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}
func (o *ACC_Type) SetISR_SCO(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *ACC_Type) GetISR_SCO() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *ACC_Type) SetISR_MASK(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80000000)|value<<31)
}
func (o *ACC_Type) GetISR_MASK() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80000000) >> 31
}

// ACC.ACR: Analog Control Register
func (o *ACC_Type) SetACR_ISEL(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x1)|value)
}
func (o *ACC_Type) GetACR_ISEL() uint32 {
	return volatile.LoadUint32(&o.ACR.Reg) & 0x1
}
func (o *ACC_Type) SetACR_HYST(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x6)|value<<1)
}
func (o *ACC_Type) GetACR_HYST() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x6) >> 1
}

// ACC.WPMR: Write Protection Mode Register
func (o *ACC_Type) SetWPMR_WPEN(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0x1)|value)
}
func (o *ACC_Type) GetWPMR_WPEN() uint32 {
	return volatile.LoadUint32(&o.WPMR.Reg) & 0x1
}
func (o *ACC_Type) SetWPMR_WPKEY(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0xffffff00)|value<<8)
}
func (o *ACC_Type) GetWPMR_WPKEY() uint32 {
	return (volatile.LoadUint32(&o.WPMR.Reg) & 0xffffff00) >> 8
}

// ACC.WPSR: Write Protection Status Register
func (o *ACC_Type) SetWPSR_WPVS(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x1)|value)
}
func (o *ACC_Type) GetWPSR_WPVS() uint32 {
	return volatile.LoadUint32(&o.WPSR.Reg) & 0x1
}

// Cyclic Redundancy Check Calculation Unit
type CRCCU_Type struct {
	DSCR    volatile.Register32 // 0x0
	_       [4]byte
	DMA_EN  volatile.Register32 // 0x8
	DMA_DIS volatile.Register32 // 0xC
	DMA_SR  volatile.Register32 // 0x10
	DMA_IER volatile.Register32 // 0x14
	DMA_IDR volatile.Register32 // 0x18
	DMA_IMR volatile.Register32 // 0x1C
	DMA_ISR volatile.Register32 // 0x20
	_       [16]byte
	CR      volatile.Register32 // 0x34
	MR      volatile.Register32 // 0x38
	SR      volatile.Register32 // 0x3C
	IER     volatile.Register32 // 0x40
	IDR     volatile.Register32 // 0x44
	IMR     volatile.Register32 // 0x48
	ISR     volatile.Register32 // 0x4C
}

// CRCCU.DSCR: CRCCU Descriptor Base Register
func (o *CRCCU_Type) SetDSCR(value uint32) {
	volatile.StoreUint32(&o.DSCR.Reg, volatile.LoadUint32(&o.DSCR.Reg)&^(0xfffffe00)|value<<9)
}
func (o *CRCCU_Type) GetDSCR() uint32 {
	return (volatile.LoadUint32(&o.DSCR.Reg) & 0xfffffe00) >> 9
}

// CRCCU.DMA_EN: CRCCU DMA Enable Register
func (o *CRCCU_Type) SetDMA_EN_DMAEN(value uint32) {
	volatile.StoreUint32(&o.DMA_EN.Reg, volatile.LoadUint32(&o.DMA_EN.Reg)&^(0x1)|value)
}
func (o *CRCCU_Type) GetDMA_EN_DMAEN() uint32 {
	return volatile.LoadUint32(&o.DMA_EN.Reg) & 0x1
}

// CRCCU.DMA_DIS: CRCCU DMA Disable Register
func (o *CRCCU_Type) SetDMA_DIS_DMADIS(value uint32) {
	volatile.StoreUint32(&o.DMA_DIS.Reg, volatile.LoadUint32(&o.DMA_DIS.Reg)&^(0x1)|value)
}
func (o *CRCCU_Type) GetDMA_DIS_DMADIS() uint32 {
	return volatile.LoadUint32(&o.DMA_DIS.Reg) & 0x1
}

// CRCCU.DMA_SR: CRCCU DMA Status Register
func (o *CRCCU_Type) SetDMA_SR_DMASR(value uint32) {
	volatile.StoreUint32(&o.DMA_SR.Reg, volatile.LoadUint32(&o.DMA_SR.Reg)&^(0x1)|value)
}
func (o *CRCCU_Type) GetDMA_SR_DMASR() uint32 {
	return volatile.LoadUint32(&o.DMA_SR.Reg) & 0x1
}

// CRCCU.DMA_IER: CRCCU DMA Interrupt Enable Register
func (o *CRCCU_Type) SetDMA_IER_DMAIER(value uint32) {
	volatile.StoreUint32(&o.DMA_IER.Reg, volatile.LoadUint32(&o.DMA_IER.Reg)&^(0x1)|value)
}
func (o *CRCCU_Type) GetDMA_IER_DMAIER() uint32 {
	return volatile.LoadUint32(&o.DMA_IER.Reg) & 0x1
}

// CRCCU.DMA_IDR: CRCCU DMA Interrupt Disable Register
func (o *CRCCU_Type) SetDMA_IDR_DMAIDR(value uint32) {
	volatile.StoreUint32(&o.DMA_IDR.Reg, volatile.LoadUint32(&o.DMA_IDR.Reg)&^(0x1)|value)
}
func (o *CRCCU_Type) GetDMA_IDR_DMAIDR() uint32 {
	return volatile.LoadUint32(&o.DMA_IDR.Reg) & 0x1
}

// CRCCU.DMA_IMR: CRCCU DMA Interrupt Mask Register
func (o *CRCCU_Type) SetDMA_IMR_DMAIMR(value uint32) {
	volatile.StoreUint32(&o.DMA_IMR.Reg, volatile.LoadUint32(&o.DMA_IMR.Reg)&^(0x1)|value)
}
func (o *CRCCU_Type) GetDMA_IMR_DMAIMR() uint32 {
	return volatile.LoadUint32(&o.DMA_IMR.Reg) & 0x1
}

// CRCCU.DMA_ISR: CRCCU DMA Interrupt Status Register
func (o *CRCCU_Type) SetDMA_ISR_DMAISR(value uint32) {
	volatile.StoreUint32(&o.DMA_ISR.Reg, volatile.LoadUint32(&o.DMA_ISR.Reg)&^(0x1)|value)
}
func (o *CRCCU_Type) GetDMA_ISR_DMAISR() uint32 {
	return volatile.LoadUint32(&o.DMA_ISR.Reg) & 0x1
}

// CRCCU.CR: CRCCU Control Register
func (o *CRCCU_Type) SetCR_RESET(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *CRCCU_Type) GetCR_RESET() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}

// CRCCU.MR: CRCCU Mode Register
func (o *CRCCU_Type) SetMR_ENABLE(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x1)|value)
}
func (o *CRCCU_Type) GetMR_ENABLE() uint32 {
	return volatile.LoadUint32(&o.MR.Reg) & 0x1
}
func (o *CRCCU_Type) SetMR_COMPARE(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x2)|value<<1)
}
func (o *CRCCU_Type) GetMR_COMPARE() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x2) >> 1
}
func (o *CRCCU_Type) SetMR_PTYPE(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xc)|value<<2)
}
func (o *CRCCU_Type) GetMR_PTYPE() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xc) >> 2
}
func (o *CRCCU_Type) SetMR_DIVIDER(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xf0)|value<<4)
}
func (o *CRCCU_Type) GetMR_DIVIDER() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xf0) >> 4
}

// CRCCU.SR: CRCCU Status Register
func (o *CRCCU_Type) SetSR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, value)
}
func (o *CRCCU_Type) GetSR() uint32 {
	return volatile.LoadUint32(&o.SR.Reg)
}

// CRCCU.IER: CRCCU Interrupt Enable Register
func (o *CRCCU_Type) SetIER_ERRIER(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *CRCCU_Type) GetIER_ERRIER() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}

// CRCCU.IDR: CRCCU Interrupt Disable Register
func (o *CRCCU_Type) SetIDR_ERRIDR(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *CRCCU_Type) GetIDR_ERRIDR() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}

// CRCCU.IMR: CRCCU Interrupt Mask Register
func (o *CRCCU_Type) SetIMR_ERRIMR(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *CRCCU_Type) GetIMR_ERRIMR() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}

// CRCCU.ISR: CRCCU Interrupt Status Register
func (o *CRCCU_Type) SetISR_ERRISR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *CRCCU_Type) GetISR_ERRISR() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}

// Cortex-M Cache Controller
type CMCC_Type struct {
	TYPE   volatile.Register32 // 0x0
	CFG    volatile.Register32 // 0x4
	CTRL   volatile.Register32 // 0x8
	SR     volatile.Register32 // 0xC
	_      [16]byte
	MAINT0 volatile.Register32 // 0x20
	MAINT1 volatile.Register32 // 0x24
	MCFG   volatile.Register32 // 0x28
	MEN    volatile.Register32 // 0x2C
	MCTRL  volatile.Register32 // 0x30
	MSR    volatile.Register32 // 0x34
}

// CMCC.TYPE: Cache Controller Type Register
func (o *CMCC_Type) SetTYPE_AP(value uint32) {
	volatile.StoreUint32(&o.TYPE.Reg, volatile.LoadUint32(&o.TYPE.Reg)&^(0x1)|value)
}
func (o *CMCC_Type) GetTYPE_AP() uint32 {
	return volatile.LoadUint32(&o.TYPE.Reg) & 0x1
}
func (o *CMCC_Type) SetTYPE_GCLK(value uint32) {
	volatile.StoreUint32(&o.TYPE.Reg, volatile.LoadUint32(&o.TYPE.Reg)&^(0x2)|value<<1)
}
func (o *CMCC_Type) GetTYPE_GCLK() uint32 {
	return (volatile.LoadUint32(&o.TYPE.Reg) & 0x2) >> 1
}
func (o *CMCC_Type) SetTYPE_RANDP(value uint32) {
	volatile.StoreUint32(&o.TYPE.Reg, volatile.LoadUint32(&o.TYPE.Reg)&^(0x4)|value<<2)
}
func (o *CMCC_Type) GetTYPE_RANDP() uint32 {
	return (volatile.LoadUint32(&o.TYPE.Reg) & 0x4) >> 2
}
func (o *CMCC_Type) SetTYPE_LRUP(value uint32) {
	volatile.StoreUint32(&o.TYPE.Reg, volatile.LoadUint32(&o.TYPE.Reg)&^(0x8)|value<<3)
}
func (o *CMCC_Type) GetTYPE_LRUP() uint32 {
	return (volatile.LoadUint32(&o.TYPE.Reg) & 0x8) >> 3
}
func (o *CMCC_Type) SetTYPE_RRP(value uint32) {
	volatile.StoreUint32(&o.TYPE.Reg, volatile.LoadUint32(&o.TYPE.Reg)&^(0x10)|value<<4)
}
func (o *CMCC_Type) GetTYPE_RRP() uint32 {
	return (volatile.LoadUint32(&o.TYPE.Reg) & 0x10) >> 4
}
func (o *CMCC_Type) SetTYPE_WAYNUM(value uint32) {
	volatile.StoreUint32(&o.TYPE.Reg, volatile.LoadUint32(&o.TYPE.Reg)&^(0x60)|value<<5)
}
func (o *CMCC_Type) GetTYPE_WAYNUM() uint32 {
	return (volatile.LoadUint32(&o.TYPE.Reg) & 0x60) >> 5
}
func (o *CMCC_Type) SetTYPE_LCKDOWN(value uint32) {
	volatile.StoreUint32(&o.TYPE.Reg, volatile.LoadUint32(&o.TYPE.Reg)&^(0x80)|value<<7)
}
func (o *CMCC_Type) GetTYPE_LCKDOWN() uint32 {
	return (volatile.LoadUint32(&o.TYPE.Reg) & 0x80) >> 7
}
func (o *CMCC_Type) SetTYPE_CSIZE(value uint32) {
	volatile.StoreUint32(&o.TYPE.Reg, volatile.LoadUint32(&o.TYPE.Reg)&^(0x700)|value<<8)
}
func (o *CMCC_Type) GetTYPE_CSIZE() uint32 {
	return (volatile.LoadUint32(&o.TYPE.Reg) & 0x700) >> 8
}
func (o *CMCC_Type) SetTYPE_CLSIZE(value uint32) {
	volatile.StoreUint32(&o.TYPE.Reg, volatile.LoadUint32(&o.TYPE.Reg)&^(0x3800)|value<<11)
}
func (o *CMCC_Type) GetTYPE_CLSIZE() uint32 {
	return (volatile.LoadUint32(&o.TYPE.Reg) & 0x3800) >> 11
}

// CMCC.CFG: Cache Controller Configuration Register
func (o *CMCC_Type) SetCFG_GCLKDIS(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x1)|value)
}
func (o *CMCC_Type) GetCFG_GCLKDIS() uint32 {
	return volatile.LoadUint32(&o.CFG.Reg) & 0x1
}

// CMCC.CTRL: Cache Controller Control Register
func (o *CMCC_Type) SetCTRL_CEN(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x1)|value)
}
func (o *CMCC_Type) GetCTRL_CEN() uint32 {
	return volatile.LoadUint32(&o.CTRL.Reg) & 0x1
}

// CMCC.SR: Cache Controller Status Register
func (o *CMCC_Type) SetSR_CSTS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *CMCC_Type) GetSR_CSTS() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}

// CMCC.MAINT0: Cache Controller Maintenance Register 0
func (o *CMCC_Type) SetMAINT0_INVALL(value uint32) {
	volatile.StoreUint32(&o.MAINT0.Reg, volatile.LoadUint32(&o.MAINT0.Reg)&^(0x1)|value)
}
func (o *CMCC_Type) GetMAINT0_INVALL() uint32 {
	return volatile.LoadUint32(&o.MAINT0.Reg) & 0x1
}

// CMCC.MAINT1: Cache Controller Maintenance Register 1
func (o *CMCC_Type) SetMAINT1_INDEX(value uint32) {
	volatile.StoreUint32(&o.MAINT1.Reg, volatile.LoadUint32(&o.MAINT1.Reg)&^(0x1f0)|value<<4)
}
func (o *CMCC_Type) GetMAINT1_INDEX() uint32 {
	return (volatile.LoadUint32(&o.MAINT1.Reg) & 0x1f0) >> 4
}
func (o *CMCC_Type) SetMAINT1_WAY(value uint32) {
	volatile.StoreUint32(&o.MAINT1.Reg, volatile.LoadUint32(&o.MAINT1.Reg)&^(0xc0000000)|value<<30)
}
func (o *CMCC_Type) GetMAINT1_WAY() uint32 {
	return (volatile.LoadUint32(&o.MAINT1.Reg) & 0xc0000000) >> 30
}

// CMCC.MCFG: Cache Controller Monitor Configuration Register
func (o *CMCC_Type) SetMCFG_MODE(value uint32) {
	volatile.StoreUint32(&o.MCFG.Reg, volatile.LoadUint32(&o.MCFG.Reg)&^(0x3)|value)
}
func (o *CMCC_Type) GetMCFG_MODE() uint32 {
	return volatile.LoadUint32(&o.MCFG.Reg) & 0x3
}

// CMCC.MEN: Cache Controller Monitor Enable Register
func (o *CMCC_Type) SetMEN_MENABLE(value uint32) {
	volatile.StoreUint32(&o.MEN.Reg, volatile.LoadUint32(&o.MEN.Reg)&^(0x1)|value)
}
func (o *CMCC_Type) GetMEN_MENABLE() uint32 {
	return volatile.LoadUint32(&o.MEN.Reg) & 0x1
}

// CMCC.MCTRL: Cache Controller Monitor Control Register
func (o *CMCC_Type) SetMCTRL_SWRST(value uint32) {
	volatile.StoreUint32(&o.MCTRL.Reg, volatile.LoadUint32(&o.MCTRL.Reg)&^(0x1)|value)
}
func (o *CMCC_Type) GetMCTRL_SWRST() uint32 {
	return volatile.LoadUint32(&o.MCTRL.Reg) & 0x1
}

// CMCC.MSR: Cache Controller Monitor Status Register
func (o *CMCC_Type) SetMSR(value uint32) {
	volatile.StoreUint32(&o.MSR.Reg, value)
}
func (o *CMCC_Type) GetMSR() uint32 {
	return volatile.LoadUint32(&o.MSR.Reg)
}

// Static Memory Controller
type EBI_Type struct {
	SETUP0 volatile.Register32 // 0x0
	PULSE0 volatile.Register32 // 0x4
	CYCLE0 volatile.Register32 // 0x8
	MODE0  volatile.Register32 // 0xC
	SETUP1 volatile.Register32 // 0x10
	PULSE1 volatile.Register32 // 0x14
	CYCLE1 volatile.Register32 // 0x18
	MODE1  volatile.Register32 // 0x1C
	SETUP2 volatile.Register32 // 0x20
	PULSE2 volatile.Register32 // 0x24
	CYCLE2 volatile.Register32 // 0x28
	MODE2  volatile.Register32 // 0x2C
	SETUP3 volatile.Register32 // 0x30
	PULSE3 volatile.Register32 // 0x34
	CYCLE3 volatile.Register32 // 0x38
	MODE3  volatile.Register32 // 0x3C
	_      [64]byte
	OCMS   volatile.Register32 // 0x80
	KEY1   volatile.Register32 // 0x84
	KEY2   volatile.Register32 // 0x88
	_      [88]byte
	WPMR   volatile.Register32 // 0xE4
	WPSR   volatile.Register32 // 0xE8
}

// EBI.SETUP0: SMC Setup Register (CS_number = 0)
func (o *EBI_Type) SetSETUP0_NWE_SETUP(value uint32) {
	volatile.StoreUint32(&o.SETUP0.Reg, volatile.LoadUint32(&o.SETUP0.Reg)&^(0x3f)|value)
}
func (o *EBI_Type) GetSETUP0_NWE_SETUP() uint32 {
	return volatile.LoadUint32(&o.SETUP0.Reg) & 0x3f
}
func (o *EBI_Type) SetSETUP0_NCS_WR_SETUP(value uint32) {
	volatile.StoreUint32(&o.SETUP0.Reg, volatile.LoadUint32(&o.SETUP0.Reg)&^(0x3f00)|value<<8)
}
func (o *EBI_Type) GetSETUP0_NCS_WR_SETUP() uint32 {
	return (volatile.LoadUint32(&o.SETUP0.Reg) & 0x3f00) >> 8
}
func (o *EBI_Type) SetSETUP0_NRD_SETUP(value uint32) {
	volatile.StoreUint32(&o.SETUP0.Reg, volatile.LoadUint32(&o.SETUP0.Reg)&^(0x3f0000)|value<<16)
}
func (o *EBI_Type) GetSETUP0_NRD_SETUP() uint32 {
	return (volatile.LoadUint32(&o.SETUP0.Reg) & 0x3f0000) >> 16
}
func (o *EBI_Type) SetSETUP0_NCS_RD_SETUP(value uint32) {
	volatile.StoreUint32(&o.SETUP0.Reg, volatile.LoadUint32(&o.SETUP0.Reg)&^(0x3f000000)|value<<24)
}
func (o *EBI_Type) GetSETUP0_NCS_RD_SETUP() uint32 {
	return (volatile.LoadUint32(&o.SETUP0.Reg) & 0x3f000000) >> 24
}

// EBI.PULSE0: SMC Pulse Register (CS_number = 0)
func (o *EBI_Type) SetPULSE0_NWE_PULSE(value uint32) {
	volatile.StoreUint32(&o.PULSE0.Reg, volatile.LoadUint32(&o.PULSE0.Reg)&^(0x7f)|value)
}
func (o *EBI_Type) GetPULSE0_NWE_PULSE() uint32 {
	return volatile.LoadUint32(&o.PULSE0.Reg) & 0x7f
}
func (o *EBI_Type) SetPULSE0_NCS_WR_PULSE(value uint32) {
	volatile.StoreUint32(&o.PULSE0.Reg, volatile.LoadUint32(&o.PULSE0.Reg)&^(0x7f00)|value<<8)
}
func (o *EBI_Type) GetPULSE0_NCS_WR_PULSE() uint32 {
	return (volatile.LoadUint32(&o.PULSE0.Reg) & 0x7f00) >> 8
}
func (o *EBI_Type) SetPULSE0_NRD_PULSE(value uint32) {
	volatile.StoreUint32(&o.PULSE0.Reg, volatile.LoadUint32(&o.PULSE0.Reg)&^(0x7f0000)|value<<16)
}
func (o *EBI_Type) GetPULSE0_NRD_PULSE() uint32 {
	return (volatile.LoadUint32(&o.PULSE0.Reg) & 0x7f0000) >> 16
}
func (o *EBI_Type) SetPULSE0_NCS_RD_PULSE(value uint32) {
	volatile.StoreUint32(&o.PULSE0.Reg, volatile.LoadUint32(&o.PULSE0.Reg)&^(0x7f000000)|value<<24)
}
func (o *EBI_Type) GetPULSE0_NCS_RD_PULSE() uint32 {
	return (volatile.LoadUint32(&o.PULSE0.Reg) & 0x7f000000) >> 24
}

// EBI.CYCLE0: SMC Cycle Register (CS_number = 0)
func (o *EBI_Type) SetCYCLE0_NWE_CYCLE(value uint32) {
	volatile.StoreUint32(&o.CYCLE0.Reg, volatile.LoadUint32(&o.CYCLE0.Reg)&^(0x1ff)|value)
}
func (o *EBI_Type) GetCYCLE0_NWE_CYCLE() uint32 {
	return volatile.LoadUint32(&o.CYCLE0.Reg) & 0x1ff
}
func (o *EBI_Type) SetCYCLE0_NRD_CYCLE(value uint32) {
	volatile.StoreUint32(&o.CYCLE0.Reg, volatile.LoadUint32(&o.CYCLE0.Reg)&^(0x1ff0000)|value<<16)
}
func (o *EBI_Type) GetCYCLE0_NRD_CYCLE() uint32 {
	return (volatile.LoadUint32(&o.CYCLE0.Reg) & 0x1ff0000) >> 16
}

// EBI.MODE0: SMC MODE Register (CS_number = 0)
func (o *EBI_Type) SetMODE0_READ_MODE(value uint32) {
	volatile.StoreUint32(&o.MODE0.Reg, volatile.LoadUint32(&o.MODE0.Reg)&^(0x1)|value)
}
func (o *EBI_Type) GetMODE0_READ_MODE() uint32 {
	return volatile.LoadUint32(&o.MODE0.Reg) & 0x1
}
func (o *EBI_Type) SetMODE0_WRITE_MODE(value uint32) {
	volatile.StoreUint32(&o.MODE0.Reg, volatile.LoadUint32(&o.MODE0.Reg)&^(0x2)|value<<1)
}
func (o *EBI_Type) GetMODE0_WRITE_MODE() uint32 {
	return (volatile.LoadUint32(&o.MODE0.Reg) & 0x2) >> 1
}
func (o *EBI_Type) SetMODE0_EXNW_MODE(value uint32) {
	volatile.StoreUint32(&o.MODE0.Reg, volatile.LoadUint32(&o.MODE0.Reg)&^(0x30)|value<<4)
}
func (o *EBI_Type) GetMODE0_EXNW_MODE() uint32 {
	return (volatile.LoadUint32(&o.MODE0.Reg) & 0x30) >> 4
}
func (o *EBI_Type) SetMODE0_TDF_CYCLES(value uint32) {
	volatile.StoreUint32(&o.MODE0.Reg, volatile.LoadUint32(&o.MODE0.Reg)&^(0xf0000)|value<<16)
}
func (o *EBI_Type) GetMODE0_TDF_CYCLES() uint32 {
	return (volatile.LoadUint32(&o.MODE0.Reg) & 0xf0000) >> 16
}
func (o *EBI_Type) SetMODE0_TDF_MODE(value uint32) {
	volatile.StoreUint32(&o.MODE0.Reg, volatile.LoadUint32(&o.MODE0.Reg)&^(0x100000)|value<<20)
}
func (o *EBI_Type) GetMODE0_TDF_MODE() uint32 {
	return (volatile.LoadUint32(&o.MODE0.Reg) & 0x100000) >> 20
}
func (o *EBI_Type) SetMODE0_PMEN(value uint32) {
	volatile.StoreUint32(&o.MODE0.Reg, volatile.LoadUint32(&o.MODE0.Reg)&^(0x1000000)|value<<24)
}
func (o *EBI_Type) GetMODE0_PMEN() uint32 {
	return (volatile.LoadUint32(&o.MODE0.Reg) & 0x1000000) >> 24
}
func (o *EBI_Type) SetMODE0_PS(value uint32) {
	volatile.StoreUint32(&o.MODE0.Reg, volatile.LoadUint32(&o.MODE0.Reg)&^(0x30000000)|value<<28)
}
func (o *EBI_Type) GetMODE0_PS() uint32 {
	return (volatile.LoadUint32(&o.MODE0.Reg) & 0x30000000) >> 28
}

// EBI.SETUP1: SMC Setup Register (CS_number = 1)
func (o *EBI_Type) SetSETUP1_NWE_SETUP(value uint32) {
	volatile.StoreUint32(&o.SETUP1.Reg, volatile.LoadUint32(&o.SETUP1.Reg)&^(0x3f)|value)
}
func (o *EBI_Type) GetSETUP1_NWE_SETUP() uint32 {
	return volatile.LoadUint32(&o.SETUP1.Reg) & 0x3f
}
func (o *EBI_Type) SetSETUP1_NCS_WR_SETUP(value uint32) {
	volatile.StoreUint32(&o.SETUP1.Reg, volatile.LoadUint32(&o.SETUP1.Reg)&^(0x3f00)|value<<8)
}
func (o *EBI_Type) GetSETUP1_NCS_WR_SETUP() uint32 {
	return (volatile.LoadUint32(&o.SETUP1.Reg) & 0x3f00) >> 8
}
func (o *EBI_Type) SetSETUP1_NRD_SETUP(value uint32) {
	volatile.StoreUint32(&o.SETUP1.Reg, volatile.LoadUint32(&o.SETUP1.Reg)&^(0x3f0000)|value<<16)
}
func (o *EBI_Type) GetSETUP1_NRD_SETUP() uint32 {
	return (volatile.LoadUint32(&o.SETUP1.Reg) & 0x3f0000) >> 16
}
func (o *EBI_Type) SetSETUP1_NCS_RD_SETUP(value uint32) {
	volatile.StoreUint32(&o.SETUP1.Reg, volatile.LoadUint32(&o.SETUP1.Reg)&^(0x3f000000)|value<<24)
}
func (o *EBI_Type) GetSETUP1_NCS_RD_SETUP() uint32 {
	return (volatile.LoadUint32(&o.SETUP1.Reg) & 0x3f000000) >> 24
}

// EBI.PULSE1: SMC Pulse Register (CS_number = 1)
func (o *EBI_Type) SetPULSE1_NWE_PULSE(value uint32) {
	volatile.StoreUint32(&o.PULSE1.Reg, volatile.LoadUint32(&o.PULSE1.Reg)&^(0x7f)|value)
}
func (o *EBI_Type) GetPULSE1_NWE_PULSE() uint32 {
	return volatile.LoadUint32(&o.PULSE1.Reg) & 0x7f
}
func (o *EBI_Type) SetPULSE1_NCS_WR_PULSE(value uint32) {
	volatile.StoreUint32(&o.PULSE1.Reg, volatile.LoadUint32(&o.PULSE1.Reg)&^(0x7f00)|value<<8)
}
func (o *EBI_Type) GetPULSE1_NCS_WR_PULSE() uint32 {
	return (volatile.LoadUint32(&o.PULSE1.Reg) & 0x7f00) >> 8
}
func (o *EBI_Type) SetPULSE1_NRD_PULSE(value uint32) {
	volatile.StoreUint32(&o.PULSE1.Reg, volatile.LoadUint32(&o.PULSE1.Reg)&^(0x7f0000)|value<<16)
}
func (o *EBI_Type) GetPULSE1_NRD_PULSE() uint32 {
	return (volatile.LoadUint32(&o.PULSE1.Reg) & 0x7f0000) >> 16
}
func (o *EBI_Type) SetPULSE1_NCS_RD_PULSE(value uint32) {
	volatile.StoreUint32(&o.PULSE1.Reg, volatile.LoadUint32(&o.PULSE1.Reg)&^(0x7f000000)|value<<24)
}
func (o *EBI_Type) GetPULSE1_NCS_RD_PULSE() uint32 {
	return (volatile.LoadUint32(&o.PULSE1.Reg) & 0x7f000000) >> 24
}

// EBI.CYCLE1: SMC Cycle Register (CS_number = 1)
func (o *EBI_Type) SetCYCLE1_NWE_CYCLE(value uint32) {
	volatile.StoreUint32(&o.CYCLE1.Reg, volatile.LoadUint32(&o.CYCLE1.Reg)&^(0x1ff)|value)
}
func (o *EBI_Type) GetCYCLE1_NWE_CYCLE() uint32 {
	return volatile.LoadUint32(&o.CYCLE1.Reg) & 0x1ff
}
func (o *EBI_Type) SetCYCLE1_NRD_CYCLE(value uint32) {
	volatile.StoreUint32(&o.CYCLE1.Reg, volatile.LoadUint32(&o.CYCLE1.Reg)&^(0x1ff0000)|value<<16)
}
func (o *EBI_Type) GetCYCLE1_NRD_CYCLE() uint32 {
	return (volatile.LoadUint32(&o.CYCLE1.Reg) & 0x1ff0000) >> 16
}

// EBI.MODE1: SMC MODE Register (CS_number = 1)
func (o *EBI_Type) SetMODE1_READ_MODE(value uint32) {
	volatile.StoreUint32(&o.MODE1.Reg, volatile.LoadUint32(&o.MODE1.Reg)&^(0x1)|value)
}
func (o *EBI_Type) GetMODE1_READ_MODE() uint32 {
	return volatile.LoadUint32(&o.MODE1.Reg) & 0x1
}
func (o *EBI_Type) SetMODE1_WRITE_MODE(value uint32) {
	volatile.StoreUint32(&o.MODE1.Reg, volatile.LoadUint32(&o.MODE1.Reg)&^(0x2)|value<<1)
}
func (o *EBI_Type) GetMODE1_WRITE_MODE() uint32 {
	return (volatile.LoadUint32(&o.MODE1.Reg) & 0x2) >> 1
}
func (o *EBI_Type) SetMODE1_EXNW_MODE(value uint32) {
	volatile.StoreUint32(&o.MODE1.Reg, volatile.LoadUint32(&o.MODE1.Reg)&^(0x30)|value<<4)
}
func (o *EBI_Type) GetMODE1_EXNW_MODE() uint32 {
	return (volatile.LoadUint32(&o.MODE1.Reg) & 0x30) >> 4
}
func (o *EBI_Type) SetMODE1_TDF_CYCLES(value uint32) {
	volatile.StoreUint32(&o.MODE1.Reg, volatile.LoadUint32(&o.MODE1.Reg)&^(0xf0000)|value<<16)
}
func (o *EBI_Type) GetMODE1_TDF_CYCLES() uint32 {
	return (volatile.LoadUint32(&o.MODE1.Reg) & 0xf0000) >> 16
}
func (o *EBI_Type) SetMODE1_TDF_MODE(value uint32) {
	volatile.StoreUint32(&o.MODE1.Reg, volatile.LoadUint32(&o.MODE1.Reg)&^(0x100000)|value<<20)
}
func (o *EBI_Type) GetMODE1_TDF_MODE() uint32 {
	return (volatile.LoadUint32(&o.MODE1.Reg) & 0x100000) >> 20
}
func (o *EBI_Type) SetMODE1_PMEN(value uint32) {
	volatile.StoreUint32(&o.MODE1.Reg, volatile.LoadUint32(&o.MODE1.Reg)&^(0x1000000)|value<<24)
}
func (o *EBI_Type) GetMODE1_PMEN() uint32 {
	return (volatile.LoadUint32(&o.MODE1.Reg) & 0x1000000) >> 24
}
func (o *EBI_Type) SetMODE1_PS(value uint32) {
	volatile.StoreUint32(&o.MODE1.Reg, volatile.LoadUint32(&o.MODE1.Reg)&^(0x30000000)|value<<28)
}
func (o *EBI_Type) GetMODE1_PS() uint32 {
	return (volatile.LoadUint32(&o.MODE1.Reg) & 0x30000000) >> 28
}

// EBI.SETUP2: SMC Setup Register (CS_number = 2)
func (o *EBI_Type) SetSETUP2_NWE_SETUP(value uint32) {
	volatile.StoreUint32(&o.SETUP2.Reg, volatile.LoadUint32(&o.SETUP2.Reg)&^(0x3f)|value)
}
func (o *EBI_Type) GetSETUP2_NWE_SETUP() uint32 {
	return volatile.LoadUint32(&o.SETUP2.Reg) & 0x3f
}
func (o *EBI_Type) SetSETUP2_NCS_WR_SETUP(value uint32) {
	volatile.StoreUint32(&o.SETUP2.Reg, volatile.LoadUint32(&o.SETUP2.Reg)&^(0x3f00)|value<<8)
}
func (o *EBI_Type) GetSETUP2_NCS_WR_SETUP() uint32 {
	return (volatile.LoadUint32(&o.SETUP2.Reg) & 0x3f00) >> 8
}
func (o *EBI_Type) SetSETUP2_NRD_SETUP(value uint32) {
	volatile.StoreUint32(&o.SETUP2.Reg, volatile.LoadUint32(&o.SETUP2.Reg)&^(0x3f0000)|value<<16)
}
func (o *EBI_Type) GetSETUP2_NRD_SETUP() uint32 {
	return (volatile.LoadUint32(&o.SETUP2.Reg) & 0x3f0000) >> 16
}
func (o *EBI_Type) SetSETUP2_NCS_RD_SETUP(value uint32) {
	volatile.StoreUint32(&o.SETUP2.Reg, volatile.LoadUint32(&o.SETUP2.Reg)&^(0x3f000000)|value<<24)
}
func (o *EBI_Type) GetSETUP2_NCS_RD_SETUP() uint32 {
	return (volatile.LoadUint32(&o.SETUP2.Reg) & 0x3f000000) >> 24
}

// EBI.PULSE2: SMC Pulse Register (CS_number = 2)
func (o *EBI_Type) SetPULSE2_NWE_PULSE(value uint32) {
	volatile.StoreUint32(&o.PULSE2.Reg, volatile.LoadUint32(&o.PULSE2.Reg)&^(0x7f)|value)
}
func (o *EBI_Type) GetPULSE2_NWE_PULSE() uint32 {
	return volatile.LoadUint32(&o.PULSE2.Reg) & 0x7f
}
func (o *EBI_Type) SetPULSE2_NCS_WR_PULSE(value uint32) {
	volatile.StoreUint32(&o.PULSE2.Reg, volatile.LoadUint32(&o.PULSE2.Reg)&^(0x7f00)|value<<8)
}
func (o *EBI_Type) GetPULSE2_NCS_WR_PULSE() uint32 {
	return (volatile.LoadUint32(&o.PULSE2.Reg) & 0x7f00) >> 8
}
func (o *EBI_Type) SetPULSE2_NRD_PULSE(value uint32) {
	volatile.StoreUint32(&o.PULSE2.Reg, volatile.LoadUint32(&o.PULSE2.Reg)&^(0x7f0000)|value<<16)
}
func (o *EBI_Type) GetPULSE2_NRD_PULSE() uint32 {
	return (volatile.LoadUint32(&o.PULSE2.Reg) & 0x7f0000) >> 16
}
func (o *EBI_Type) SetPULSE2_NCS_RD_PULSE(value uint32) {
	volatile.StoreUint32(&o.PULSE2.Reg, volatile.LoadUint32(&o.PULSE2.Reg)&^(0x7f000000)|value<<24)
}
func (o *EBI_Type) GetPULSE2_NCS_RD_PULSE() uint32 {
	return (volatile.LoadUint32(&o.PULSE2.Reg) & 0x7f000000) >> 24
}

// EBI.CYCLE2: SMC Cycle Register (CS_number = 2)
func (o *EBI_Type) SetCYCLE2_NWE_CYCLE(value uint32) {
	volatile.StoreUint32(&o.CYCLE2.Reg, volatile.LoadUint32(&o.CYCLE2.Reg)&^(0x1ff)|value)
}
func (o *EBI_Type) GetCYCLE2_NWE_CYCLE() uint32 {
	return volatile.LoadUint32(&o.CYCLE2.Reg) & 0x1ff
}
func (o *EBI_Type) SetCYCLE2_NRD_CYCLE(value uint32) {
	volatile.StoreUint32(&o.CYCLE2.Reg, volatile.LoadUint32(&o.CYCLE2.Reg)&^(0x1ff0000)|value<<16)
}
func (o *EBI_Type) GetCYCLE2_NRD_CYCLE() uint32 {
	return (volatile.LoadUint32(&o.CYCLE2.Reg) & 0x1ff0000) >> 16
}

// EBI.MODE2: SMC MODE Register (CS_number = 2)
func (o *EBI_Type) SetMODE2_READ_MODE(value uint32) {
	volatile.StoreUint32(&o.MODE2.Reg, volatile.LoadUint32(&o.MODE2.Reg)&^(0x1)|value)
}
func (o *EBI_Type) GetMODE2_READ_MODE() uint32 {
	return volatile.LoadUint32(&o.MODE2.Reg) & 0x1
}
func (o *EBI_Type) SetMODE2_WRITE_MODE(value uint32) {
	volatile.StoreUint32(&o.MODE2.Reg, volatile.LoadUint32(&o.MODE2.Reg)&^(0x2)|value<<1)
}
func (o *EBI_Type) GetMODE2_WRITE_MODE() uint32 {
	return (volatile.LoadUint32(&o.MODE2.Reg) & 0x2) >> 1
}
func (o *EBI_Type) SetMODE2_EXNW_MODE(value uint32) {
	volatile.StoreUint32(&o.MODE2.Reg, volatile.LoadUint32(&o.MODE2.Reg)&^(0x30)|value<<4)
}
func (o *EBI_Type) GetMODE2_EXNW_MODE() uint32 {
	return (volatile.LoadUint32(&o.MODE2.Reg) & 0x30) >> 4
}
func (o *EBI_Type) SetMODE2_TDF_CYCLES(value uint32) {
	volatile.StoreUint32(&o.MODE2.Reg, volatile.LoadUint32(&o.MODE2.Reg)&^(0xf0000)|value<<16)
}
func (o *EBI_Type) GetMODE2_TDF_CYCLES() uint32 {
	return (volatile.LoadUint32(&o.MODE2.Reg) & 0xf0000) >> 16
}
func (o *EBI_Type) SetMODE2_TDF_MODE(value uint32) {
	volatile.StoreUint32(&o.MODE2.Reg, volatile.LoadUint32(&o.MODE2.Reg)&^(0x100000)|value<<20)
}
func (o *EBI_Type) GetMODE2_TDF_MODE() uint32 {
	return (volatile.LoadUint32(&o.MODE2.Reg) & 0x100000) >> 20
}
func (o *EBI_Type) SetMODE2_PMEN(value uint32) {
	volatile.StoreUint32(&o.MODE2.Reg, volatile.LoadUint32(&o.MODE2.Reg)&^(0x1000000)|value<<24)
}
func (o *EBI_Type) GetMODE2_PMEN() uint32 {
	return (volatile.LoadUint32(&o.MODE2.Reg) & 0x1000000) >> 24
}
func (o *EBI_Type) SetMODE2_PS(value uint32) {
	volatile.StoreUint32(&o.MODE2.Reg, volatile.LoadUint32(&o.MODE2.Reg)&^(0x30000000)|value<<28)
}
func (o *EBI_Type) GetMODE2_PS() uint32 {
	return (volatile.LoadUint32(&o.MODE2.Reg) & 0x30000000) >> 28
}

// EBI.SETUP3: SMC Setup Register (CS_number = 3)
func (o *EBI_Type) SetSETUP3_NWE_SETUP(value uint32) {
	volatile.StoreUint32(&o.SETUP3.Reg, volatile.LoadUint32(&o.SETUP3.Reg)&^(0x3f)|value)
}
func (o *EBI_Type) GetSETUP3_NWE_SETUP() uint32 {
	return volatile.LoadUint32(&o.SETUP3.Reg) & 0x3f
}
func (o *EBI_Type) SetSETUP3_NCS_WR_SETUP(value uint32) {
	volatile.StoreUint32(&o.SETUP3.Reg, volatile.LoadUint32(&o.SETUP3.Reg)&^(0x3f00)|value<<8)
}
func (o *EBI_Type) GetSETUP3_NCS_WR_SETUP() uint32 {
	return (volatile.LoadUint32(&o.SETUP3.Reg) & 0x3f00) >> 8
}
func (o *EBI_Type) SetSETUP3_NRD_SETUP(value uint32) {
	volatile.StoreUint32(&o.SETUP3.Reg, volatile.LoadUint32(&o.SETUP3.Reg)&^(0x3f0000)|value<<16)
}
func (o *EBI_Type) GetSETUP3_NRD_SETUP() uint32 {
	return (volatile.LoadUint32(&o.SETUP3.Reg) & 0x3f0000) >> 16
}
func (o *EBI_Type) SetSETUP3_NCS_RD_SETUP(value uint32) {
	volatile.StoreUint32(&o.SETUP3.Reg, volatile.LoadUint32(&o.SETUP3.Reg)&^(0x3f000000)|value<<24)
}
func (o *EBI_Type) GetSETUP3_NCS_RD_SETUP() uint32 {
	return (volatile.LoadUint32(&o.SETUP3.Reg) & 0x3f000000) >> 24
}

// EBI.PULSE3: SMC Pulse Register (CS_number = 3)
func (o *EBI_Type) SetPULSE3_NWE_PULSE(value uint32) {
	volatile.StoreUint32(&o.PULSE3.Reg, volatile.LoadUint32(&o.PULSE3.Reg)&^(0x7f)|value)
}
func (o *EBI_Type) GetPULSE3_NWE_PULSE() uint32 {
	return volatile.LoadUint32(&o.PULSE3.Reg) & 0x7f
}
func (o *EBI_Type) SetPULSE3_NCS_WR_PULSE(value uint32) {
	volatile.StoreUint32(&o.PULSE3.Reg, volatile.LoadUint32(&o.PULSE3.Reg)&^(0x7f00)|value<<8)
}
func (o *EBI_Type) GetPULSE3_NCS_WR_PULSE() uint32 {
	return (volatile.LoadUint32(&o.PULSE3.Reg) & 0x7f00) >> 8
}
func (o *EBI_Type) SetPULSE3_NRD_PULSE(value uint32) {
	volatile.StoreUint32(&o.PULSE3.Reg, volatile.LoadUint32(&o.PULSE3.Reg)&^(0x7f0000)|value<<16)
}
func (o *EBI_Type) GetPULSE3_NRD_PULSE() uint32 {
	return (volatile.LoadUint32(&o.PULSE3.Reg) & 0x7f0000) >> 16
}
func (o *EBI_Type) SetPULSE3_NCS_RD_PULSE(value uint32) {
	volatile.StoreUint32(&o.PULSE3.Reg, volatile.LoadUint32(&o.PULSE3.Reg)&^(0x7f000000)|value<<24)
}
func (o *EBI_Type) GetPULSE3_NCS_RD_PULSE() uint32 {
	return (volatile.LoadUint32(&o.PULSE3.Reg) & 0x7f000000) >> 24
}

// EBI.CYCLE3: SMC Cycle Register (CS_number = 3)
func (o *EBI_Type) SetCYCLE3_NWE_CYCLE(value uint32) {
	volatile.StoreUint32(&o.CYCLE3.Reg, volatile.LoadUint32(&o.CYCLE3.Reg)&^(0x1ff)|value)
}
func (o *EBI_Type) GetCYCLE3_NWE_CYCLE() uint32 {
	return volatile.LoadUint32(&o.CYCLE3.Reg) & 0x1ff
}
func (o *EBI_Type) SetCYCLE3_NRD_CYCLE(value uint32) {
	volatile.StoreUint32(&o.CYCLE3.Reg, volatile.LoadUint32(&o.CYCLE3.Reg)&^(0x1ff0000)|value<<16)
}
func (o *EBI_Type) GetCYCLE3_NRD_CYCLE() uint32 {
	return (volatile.LoadUint32(&o.CYCLE3.Reg) & 0x1ff0000) >> 16
}

// EBI.MODE3: SMC MODE Register (CS_number = 3)
func (o *EBI_Type) SetMODE3_READ_MODE(value uint32) {
	volatile.StoreUint32(&o.MODE3.Reg, volatile.LoadUint32(&o.MODE3.Reg)&^(0x1)|value)
}
func (o *EBI_Type) GetMODE3_READ_MODE() uint32 {
	return volatile.LoadUint32(&o.MODE3.Reg) & 0x1
}
func (o *EBI_Type) SetMODE3_WRITE_MODE(value uint32) {
	volatile.StoreUint32(&o.MODE3.Reg, volatile.LoadUint32(&o.MODE3.Reg)&^(0x2)|value<<1)
}
func (o *EBI_Type) GetMODE3_WRITE_MODE() uint32 {
	return (volatile.LoadUint32(&o.MODE3.Reg) & 0x2) >> 1
}
func (o *EBI_Type) SetMODE3_EXNW_MODE(value uint32) {
	volatile.StoreUint32(&o.MODE3.Reg, volatile.LoadUint32(&o.MODE3.Reg)&^(0x30)|value<<4)
}
func (o *EBI_Type) GetMODE3_EXNW_MODE() uint32 {
	return (volatile.LoadUint32(&o.MODE3.Reg) & 0x30) >> 4
}
func (o *EBI_Type) SetMODE3_TDF_CYCLES(value uint32) {
	volatile.StoreUint32(&o.MODE3.Reg, volatile.LoadUint32(&o.MODE3.Reg)&^(0xf0000)|value<<16)
}
func (o *EBI_Type) GetMODE3_TDF_CYCLES() uint32 {
	return (volatile.LoadUint32(&o.MODE3.Reg) & 0xf0000) >> 16
}
func (o *EBI_Type) SetMODE3_TDF_MODE(value uint32) {
	volatile.StoreUint32(&o.MODE3.Reg, volatile.LoadUint32(&o.MODE3.Reg)&^(0x100000)|value<<20)
}
func (o *EBI_Type) GetMODE3_TDF_MODE() uint32 {
	return (volatile.LoadUint32(&o.MODE3.Reg) & 0x100000) >> 20
}
func (o *EBI_Type) SetMODE3_PMEN(value uint32) {
	volatile.StoreUint32(&o.MODE3.Reg, volatile.LoadUint32(&o.MODE3.Reg)&^(0x1000000)|value<<24)
}
func (o *EBI_Type) GetMODE3_PMEN() uint32 {
	return (volatile.LoadUint32(&o.MODE3.Reg) & 0x1000000) >> 24
}
func (o *EBI_Type) SetMODE3_PS(value uint32) {
	volatile.StoreUint32(&o.MODE3.Reg, volatile.LoadUint32(&o.MODE3.Reg)&^(0x30000000)|value<<28)
}
func (o *EBI_Type) GetMODE3_PS() uint32 {
	return (volatile.LoadUint32(&o.MODE3.Reg) & 0x30000000) >> 28
}

// EBI.OCMS: SMC OCMS MODE Register
func (o *EBI_Type) SetOCMS_SMSE(value uint32) {
	volatile.StoreUint32(&o.OCMS.Reg, volatile.LoadUint32(&o.OCMS.Reg)&^(0x1)|value)
}
func (o *EBI_Type) GetOCMS_SMSE() uint32 {
	return volatile.LoadUint32(&o.OCMS.Reg) & 0x1
}
func (o *EBI_Type) SetOCMS_CS0SE(value uint32) {
	volatile.StoreUint32(&o.OCMS.Reg, volatile.LoadUint32(&o.OCMS.Reg)&^(0x10000)|value<<16)
}
func (o *EBI_Type) GetOCMS_CS0SE() uint32 {
	return (volatile.LoadUint32(&o.OCMS.Reg) & 0x10000) >> 16
}
func (o *EBI_Type) SetOCMS_CS1SE(value uint32) {
	volatile.StoreUint32(&o.OCMS.Reg, volatile.LoadUint32(&o.OCMS.Reg)&^(0x20000)|value<<17)
}
func (o *EBI_Type) GetOCMS_CS1SE() uint32 {
	return (volatile.LoadUint32(&o.OCMS.Reg) & 0x20000) >> 17
}
func (o *EBI_Type) SetOCMS_CS2SE(value uint32) {
	volatile.StoreUint32(&o.OCMS.Reg, volatile.LoadUint32(&o.OCMS.Reg)&^(0x40000)|value<<18)
}
func (o *EBI_Type) GetOCMS_CS2SE() uint32 {
	return (volatile.LoadUint32(&o.OCMS.Reg) & 0x40000) >> 18
}
func (o *EBI_Type) SetOCMS_CS3SE(value uint32) {
	volatile.StoreUint32(&o.OCMS.Reg, volatile.LoadUint32(&o.OCMS.Reg)&^(0x80000)|value<<19)
}
func (o *EBI_Type) GetOCMS_CS3SE() uint32 {
	return (volatile.LoadUint32(&o.OCMS.Reg) & 0x80000) >> 19
}

// EBI.KEY1: SMC OCMS KEY1 Register
func (o *EBI_Type) SetKEY1(value uint32) {
	volatile.StoreUint32(&o.KEY1.Reg, value)
}
func (o *EBI_Type) GetKEY1() uint32 {
	return volatile.LoadUint32(&o.KEY1.Reg)
}

// EBI.KEY2: SMC OCMS KEY2 Register
func (o *EBI_Type) SetKEY2(value uint32) {
	volatile.StoreUint32(&o.KEY2.Reg, value)
}
func (o *EBI_Type) GetKEY2() uint32 {
	return volatile.LoadUint32(&o.KEY2.Reg)
}

// EBI.WPMR: SMC Write Protection Mode Register
func (o *EBI_Type) SetWPMR_WPEN(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0x1)|value)
}
func (o *EBI_Type) GetWPMR_WPEN() uint32 {
	return volatile.LoadUint32(&o.WPMR.Reg) & 0x1
}
func (o *EBI_Type) SetWPMR_WPKEY(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0xffffff00)|value<<8)
}
func (o *EBI_Type) GetWPMR_WPKEY() uint32 {
	return (volatile.LoadUint32(&o.WPMR.Reg) & 0xffffff00) >> 8
}

// EBI.WPSR: SMC Write Protection Status Register
func (o *EBI_Type) SetWPSR_WPVS(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x1)|value)
}
func (o *EBI_Type) GetWPSR_WPVS() uint32 {
	return volatile.LoadUint32(&o.WPSR.Reg) & 0x1
}
func (o *EBI_Type) SetWPSR_WPVSRC(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0xffff00)|value<<8)
}
func (o *EBI_Type) GetWPSR_WPVSRC() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0xffff00) >> 8
}

// AHB Bus Matrix
type MATRIX_Type struct {
	MATRIX_MCFG  [4]volatile.Register32 // 0x0
	_            [48]byte
	MATRIX_SCFG  [5]volatile.Register32 // 0x40
	_            [44]byte
	MATRIX_PRAS0 volatile.Register32 // 0x80
	_            [4]byte
	MATRIX_PRAS1 volatile.Register32 // 0x88
	_            [4]byte
	MATRIX_PRAS2 volatile.Register32 // 0x90
	_            [4]byte
	MATRIX_PRAS3 volatile.Register32 // 0x98
	_            [4]byte
	MATRIX_PRAS4 volatile.Register32 // 0xA0
	_            [112]byte
	CCFG_SYSIO   volatile.Register32 // 0x114
	_            [4]byte
	CCFG_SMCNFCS volatile.Register32 // 0x11C
	_            [196]byte
	MATRIX_WPMR  volatile.Register32 // 0x1E4
	MATRIX_WPSR  volatile.Register32 // 0x1E8
}

// MATRIX.MATRIX_MCFG: Master Configuration Register
func (o *MATRIX_Type) SetMATRIX_MCFG_ULBT(idx int, value uint32) {
	volatile.StoreUint32(&o.MATRIX_MCFG[idx].Reg, volatile.LoadUint32(&o.MATRIX_MCFG[idx].Reg)&^(0x7)|value)
}
func (o *MATRIX_Type) GetMATRIX_MCFG_ULBT(idx int) uint32 {
	return volatile.LoadUint32(&o.MATRIX_MCFG[idx].Reg) & 0x7
}

// MATRIX.MATRIX_SCFG: Slave Configuration Register
func (o *MATRIX_Type) SetMATRIX_SCFG_SLOT_CYCLE(idx int, value uint32) {
	volatile.StoreUint32(&o.MATRIX_SCFG[idx].Reg, volatile.LoadUint32(&o.MATRIX_SCFG[idx].Reg)&^(0xff)|value)
}
func (o *MATRIX_Type) GetMATRIX_SCFG_SLOT_CYCLE(idx int) uint32 {
	return volatile.LoadUint32(&o.MATRIX_SCFG[idx].Reg) & 0xff
}
func (o *MATRIX_Type) SetMATRIX_SCFG_DEFMSTR_TYPE(idx int, value uint32) {
	volatile.StoreUint32(&o.MATRIX_SCFG[idx].Reg, volatile.LoadUint32(&o.MATRIX_SCFG[idx].Reg)&^(0x30000)|value<<16)
}
func (o *MATRIX_Type) GetMATRIX_SCFG_DEFMSTR_TYPE(idx int) uint32 {
	return (volatile.LoadUint32(&o.MATRIX_SCFG[idx].Reg) & 0x30000) >> 16
}
func (o *MATRIX_Type) SetMATRIX_SCFG_FIXED_DEFMSTR(idx int, value uint32) {
	volatile.StoreUint32(&o.MATRIX_SCFG[idx].Reg, volatile.LoadUint32(&o.MATRIX_SCFG[idx].Reg)&^(0x1c0000)|value<<18)
}
func (o *MATRIX_Type) GetMATRIX_SCFG_FIXED_DEFMSTR(idx int) uint32 {
	return (volatile.LoadUint32(&o.MATRIX_SCFG[idx].Reg) & 0x1c0000) >> 18
}
func (o *MATRIX_Type) SetMATRIX_SCFG_ARBT(idx int, value uint32) {
	volatile.StoreUint32(&o.MATRIX_SCFG[idx].Reg, volatile.LoadUint32(&o.MATRIX_SCFG[idx].Reg)&^(0x3000000)|value<<24)
}
func (o *MATRIX_Type) GetMATRIX_SCFG_ARBT(idx int) uint32 {
	return (volatile.LoadUint32(&o.MATRIX_SCFG[idx].Reg) & 0x3000000) >> 24
}

// MATRIX.MATRIX_PRAS0: Priority Register A for Slave 0
func (o *MATRIX_Type) SetMATRIX_PRAS0_M0PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRAS0.Reg, volatile.LoadUint32(&o.MATRIX_PRAS0.Reg)&^(0x3)|value)
}
func (o *MATRIX_Type) GetMATRIX_PRAS0_M0PR() uint32 {
	return volatile.LoadUint32(&o.MATRIX_PRAS0.Reg) & 0x3
}
func (o *MATRIX_Type) SetMATRIX_PRAS0_M1PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRAS0.Reg, volatile.LoadUint32(&o.MATRIX_PRAS0.Reg)&^(0x30)|value<<4)
}
func (o *MATRIX_Type) GetMATRIX_PRAS0_M1PR() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_PRAS0.Reg) & 0x30) >> 4
}
func (o *MATRIX_Type) SetMATRIX_PRAS0_M2PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRAS0.Reg, volatile.LoadUint32(&o.MATRIX_PRAS0.Reg)&^(0x300)|value<<8)
}
func (o *MATRIX_Type) GetMATRIX_PRAS0_M2PR() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_PRAS0.Reg) & 0x300) >> 8
}
func (o *MATRIX_Type) SetMATRIX_PRAS0_M3PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRAS0.Reg, volatile.LoadUint32(&o.MATRIX_PRAS0.Reg)&^(0x3000)|value<<12)
}
func (o *MATRIX_Type) GetMATRIX_PRAS0_M3PR() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_PRAS0.Reg) & 0x3000) >> 12
}
func (o *MATRIX_Type) SetMATRIX_PRAS0_M4PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRAS0.Reg, volatile.LoadUint32(&o.MATRIX_PRAS0.Reg)&^(0x30000)|value<<16)
}
func (o *MATRIX_Type) GetMATRIX_PRAS0_M4PR() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_PRAS0.Reg) & 0x30000) >> 16
}

// MATRIX.MATRIX_PRAS1: Priority Register A for Slave 1
func (o *MATRIX_Type) SetMATRIX_PRAS1_M0PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRAS1.Reg, volatile.LoadUint32(&o.MATRIX_PRAS1.Reg)&^(0x3)|value)
}
func (o *MATRIX_Type) GetMATRIX_PRAS1_M0PR() uint32 {
	return volatile.LoadUint32(&o.MATRIX_PRAS1.Reg) & 0x3
}
func (o *MATRIX_Type) SetMATRIX_PRAS1_M1PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRAS1.Reg, volatile.LoadUint32(&o.MATRIX_PRAS1.Reg)&^(0x30)|value<<4)
}
func (o *MATRIX_Type) GetMATRIX_PRAS1_M1PR() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_PRAS1.Reg) & 0x30) >> 4
}
func (o *MATRIX_Type) SetMATRIX_PRAS1_M2PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRAS1.Reg, volatile.LoadUint32(&o.MATRIX_PRAS1.Reg)&^(0x300)|value<<8)
}
func (o *MATRIX_Type) GetMATRIX_PRAS1_M2PR() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_PRAS1.Reg) & 0x300) >> 8
}
func (o *MATRIX_Type) SetMATRIX_PRAS1_M3PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRAS1.Reg, volatile.LoadUint32(&o.MATRIX_PRAS1.Reg)&^(0x3000)|value<<12)
}
func (o *MATRIX_Type) GetMATRIX_PRAS1_M3PR() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_PRAS1.Reg) & 0x3000) >> 12
}
func (o *MATRIX_Type) SetMATRIX_PRAS1_M4PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRAS1.Reg, volatile.LoadUint32(&o.MATRIX_PRAS1.Reg)&^(0x30000)|value<<16)
}
func (o *MATRIX_Type) GetMATRIX_PRAS1_M4PR() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_PRAS1.Reg) & 0x30000) >> 16
}

// MATRIX.MATRIX_PRAS2: Priority Register A for Slave 2
func (o *MATRIX_Type) SetMATRIX_PRAS2_M0PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRAS2.Reg, volatile.LoadUint32(&o.MATRIX_PRAS2.Reg)&^(0x3)|value)
}
func (o *MATRIX_Type) GetMATRIX_PRAS2_M0PR() uint32 {
	return volatile.LoadUint32(&o.MATRIX_PRAS2.Reg) & 0x3
}
func (o *MATRIX_Type) SetMATRIX_PRAS2_M1PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRAS2.Reg, volatile.LoadUint32(&o.MATRIX_PRAS2.Reg)&^(0x30)|value<<4)
}
func (o *MATRIX_Type) GetMATRIX_PRAS2_M1PR() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_PRAS2.Reg) & 0x30) >> 4
}
func (o *MATRIX_Type) SetMATRIX_PRAS2_M2PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRAS2.Reg, volatile.LoadUint32(&o.MATRIX_PRAS2.Reg)&^(0x300)|value<<8)
}
func (o *MATRIX_Type) GetMATRIX_PRAS2_M2PR() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_PRAS2.Reg) & 0x300) >> 8
}
func (o *MATRIX_Type) SetMATRIX_PRAS2_M3PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRAS2.Reg, volatile.LoadUint32(&o.MATRIX_PRAS2.Reg)&^(0x3000)|value<<12)
}
func (o *MATRIX_Type) GetMATRIX_PRAS2_M3PR() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_PRAS2.Reg) & 0x3000) >> 12
}
func (o *MATRIX_Type) SetMATRIX_PRAS2_M4PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRAS2.Reg, volatile.LoadUint32(&o.MATRIX_PRAS2.Reg)&^(0x30000)|value<<16)
}
func (o *MATRIX_Type) GetMATRIX_PRAS2_M4PR() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_PRAS2.Reg) & 0x30000) >> 16
}

// MATRIX.MATRIX_PRAS3: Priority Register A for Slave 3
func (o *MATRIX_Type) SetMATRIX_PRAS3_M0PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRAS3.Reg, volatile.LoadUint32(&o.MATRIX_PRAS3.Reg)&^(0x3)|value)
}
func (o *MATRIX_Type) GetMATRIX_PRAS3_M0PR() uint32 {
	return volatile.LoadUint32(&o.MATRIX_PRAS3.Reg) & 0x3
}
func (o *MATRIX_Type) SetMATRIX_PRAS3_M1PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRAS3.Reg, volatile.LoadUint32(&o.MATRIX_PRAS3.Reg)&^(0x30)|value<<4)
}
func (o *MATRIX_Type) GetMATRIX_PRAS3_M1PR() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_PRAS3.Reg) & 0x30) >> 4
}
func (o *MATRIX_Type) SetMATRIX_PRAS3_M2PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRAS3.Reg, volatile.LoadUint32(&o.MATRIX_PRAS3.Reg)&^(0x300)|value<<8)
}
func (o *MATRIX_Type) GetMATRIX_PRAS3_M2PR() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_PRAS3.Reg) & 0x300) >> 8
}
func (o *MATRIX_Type) SetMATRIX_PRAS3_M3PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRAS3.Reg, volatile.LoadUint32(&o.MATRIX_PRAS3.Reg)&^(0x3000)|value<<12)
}
func (o *MATRIX_Type) GetMATRIX_PRAS3_M3PR() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_PRAS3.Reg) & 0x3000) >> 12
}
func (o *MATRIX_Type) SetMATRIX_PRAS3_M4PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRAS3.Reg, volatile.LoadUint32(&o.MATRIX_PRAS3.Reg)&^(0x30000)|value<<16)
}
func (o *MATRIX_Type) GetMATRIX_PRAS3_M4PR() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_PRAS3.Reg) & 0x30000) >> 16
}

// MATRIX.MATRIX_PRAS4: Priority Register A for Slave 4
func (o *MATRIX_Type) SetMATRIX_PRAS4_M0PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRAS4.Reg, volatile.LoadUint32(&o.MATRIX_PRAS4.Reg)&^(0x3)|value)
}
func (o *MATRIX_Type) GetMATRIX_PRAS4_M0PR() uint32 {
	return volatile.LoadUint32(&o.MATRIX_PRAS4.Reg) & 0x3
}
func (o *MATRIX_Type) SetMATRIX_PRAS4_M1PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRAS4.Reg, volatile.LoadUint32(&o.MATRIX_PRAS4.Reg)&^(0x30)|value<<4)
}
func (o *MATRIX_Type) GetMATRIX_PRAS4_M1PR() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_PRAS4.Reg) & 0x30) >> 4
}
func (o *MATRIX_Type) SetMATRIX_PRAS4_M2PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRAS4.Reg, volatile.LoadUint32(&o.MATRIX_PRAS4.Reg)&^(0x300)|value<<8)
}
func (o *MATRIX_Type) GetMATRIX_PRAS4_M2PR() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_PRAS4.Reg) & 0x300) >> 8
}
func (o *MATRIX_Type) SetMATRIX_PRAS4_M3PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRAS4.Reg, volatile.LoadUint32(&o.MATRIX_PRAS4.Reg)&^(0x3000)|value<<12)
}
func (o *MATRIX_Type) GetMATRIX_PRAS4_M3PR() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_PRAS4.Reg) & 0x3000) >> 12
}
func (o *MATRIX_Type) SetMATRIX_PRAS4_M4PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRAS4.Reg, volatile.LoadUint32(&o.MATRIX_PRAS4.Reg)&^(0x30000)|value<<16)
}
func (o *MATRIX_Type) GetMATRIX_PRAS4_M4PR() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_PRAS4.Reg) & 0x30000) >> 16
}

// MATRIX.CCFG_SYSIO: System I/O Configuration register
func (o *MATRIX_Type) SetCCFG_SYSIO_SYSIO4(value uint32) {
	volatile.StoreUint32(&o.CCFG_SYSIO.Reg, volatile.LoadUint32(&o.CCFG_SYSIO.Reg)&^(0x10)|value<<4)
}
func (o *MATRIX_Type) GetCCFG_SYSIO_SYSIO4() uint32 {
	return (volatile.LoadUint32(&o.CCFG_SYSIO.Reg) & 0x10) >> 4
}
func (o *MATRIX_Type) SetCCFG_SYSIO_SYSIO5(value uint32) {
	volatile.StoreUint32(&o.CCFG_SYSIO.Reg, volatile.LoadUint32(&o.CCFG_SYSIO.Reg)&^(0x20)|value<<5)
}
func (o *MATRIX_Type) GetCCFG_SYSIO_SYSIO5() uint32 {
	return (volatile.LoadUint32(&o.CCFG_SYSIO.Reg) & 0x20) >> 5
}
func (o *MATRIX_Type) SetCCFG_SYSIO_SYSIO6(value uint32) {
	volatile.StoreUint32(&o.CCFG_SYSIO.Reg, volatile.LoadUint32(&o.CCFG_SYSIO.Reg)&^(0x40)|value<<6)
}
func (o *MATRIX_Type) GetCCFG_SYSIO_SYSIO6() uint32 {
	return (volatile.LoadUint32(&o.CCFG_SYSIO.Reg) & 0x40) >> 6
}
func (o *MATRIX_Type) SetCCFG_SYSIO_SYSIO7(value uint32) {
	volatile.StoreUint32(&o.CCFG_SYSIO.Reg, volatile.LoadUint32(&o.CCFG_SYSIO.Reg)&^(0x80)|value<<7)
}
func (o *MATRIX_Type) GetCCFG_SYSIO_SYSIO7() uint32 {
	return (volatile.LoadUint32(&o.CCFG_SYSIO.Reg) & 0x80) >> 7
}
func (o *MATRIX_Type) SetCCFG_SYSIO_SYSIO10(value uint32) {
	volatile.StoreUint32(&o.CCFG_SYSIO.Reg, volatile.LoadUint32(&o.CCFG_SYSIO.Reg)&^(0x400)|value<<10)
}
func (o *MATRIX_Type) GetCCFG_SYSIO_SYSIO10() uint32 {
	return (volatile.LoadUint32(&o.CCFG_SYSIO.Reg) & 0x400) >> 10
}
func (o *MATRIX_Type) SetCCFG_SYSIO_SYSIO11(value uint32) {
	volatile.StoreUint32(&o.CCFG_SYSIO.Reg, volatile.LoadUint32(&o.CCFG_SYSIO.Reg)&^(0x800)|value<<11)
}
func (o *MATRIX_Type) GetCCFG_SYSIO_SYSIO11() uint32 {
	return (volatile.LoadUint32(&o.CCFG_SYSIO.Reg) & 0x800) >> 11
}
func (o *MATRIX_Type) SetCCFG_SYSIO_SYSIO12(value uint32) {
	volatile.StoreUint32(&o.CCFG_SYSIO.Reg, volatile.LoadUint32(&o.CCFG_SYSIO.Reg)&^(0x1000)|value<<12)
}
func (o *MATRIX_Type) GetCCFG_SYSIO_SYSIO12() uint32 {
	return (volatile.LoadUint32(&o.CCFG_SYSIO.Reg) & 0x1000) >> 12
}

// MATRIX.CCFG_SMCNFCS: SMC Chip Select NAND Flash Assignment Register
func (o *MATRIX_Type) SetCCFG_SMCNFCS_SMC_NFCS0(value uint32) {
	volatile.StoreUint32(&o.CCFG_SMCNFCS.Reg, volatile.LoadUint32(&o.CCFG_SMCNFCS.Reg)&^(0x1)|value)
}
func (o *MATRIX_Type) GetCCFG_SMCNFCS_SMC_NFCS0() uint32 {
	return volatile.LoadUint32(&o.CCFG_SMCNFCS.Reg) & 0x1
}
func (o *MATRIX_Type) SetCCFG_SMCNFCS_SMC_NFCS1(value uint32) {
	volatile.StoreUint32(&o.CCFG_SMCNFCS.Reg, volatile.LoadUint32(&o.CCFG_SMCNFCS.Reg)&^(0x2)|value<<1)
}
func (o *MATRIX_Type) GetCCFG_SMCNFCS_SMC_NFCS1() uint32 {
	return (volatile.LoadUint32(&o.CCFG_SMCNFCS.Reg) & 0x2) >> 1
}
func (o *MATRIX_Type) SetCCFG_SMCNFCS_SMC_NFCS2(value uint32) {
	volatile.StoreUint32(&o.CCFG_SMCNFCS.Reg, volatile.LoadUint32(&o.CCFG_SMCNFCS.Reg)&^(0x4)|value<<2)
}
func (o *MATRIX_Type) GetCCFG_SMCNFCS_SMC_NFCS2() uint32 {
	return (volatile.LoadUint32(&o.CCFG_SMCNFCS.Reg) & 0x4) >> 2
}
func (o *MATRIX_Type) SetCCFG_SMCNFCS_SMC_NFCS3(value uint32) {
	volatile.StoreUint32(&o.CCFG_SMCNFCS.Reg, volatile.LoadUint32(&o.CCFG_SMCNFCS.Reg)&^(0x8)|value<<3)
}
func (o *MATRIX_Type) GetCCFG_SMCNFCS_SMC_NFCS3() uint32 {
	return (volatile.LoadUint32(&o.CCFG_SMCNFCS.Reg) & 0x8) >> 3
}

// MATRIX.MATRIX_WPMR: Write Protection Mode Register
func (o *MATRIX_Type) SetMATRIX_WPMR_WPEN(value uint32) {
	volatile.StoreUint32(&o.MATRIX_WPMR.Reg, volatile.LoadUint32(&o.MATRIX_WPMR.Reg)&^(0x1)|value)
}
func (o *MATRIX_Type) GetMATRIX_WPMR_WPEN() uint32 {
	return volatile.LoadUint32(&o.MATRIX_WPMR.Reg) & 0x1
}
func (o *MATRIX_Type) SetMATRIX_WPMR_WPKEY(value uint32) {
	volatile.StoreUint32(&o.MATRIX_WPMR.Reg, volatile.LoadUint32(&o.MATRIX_WPMR.Reg)&^(0xffffff00)|value<<8)
}
func (o *MATRIX_Type) GetMATRIX_WPMR_WPKEY() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_WPMR.Reg) & 0xffffff00) >> 8
}

// MATRIX.MATRIX_WPSR: Write Protection Status Register
func (o *MATRIX_Type) SetMATRIX_WPSR_WPVS(value uint32) {
	volatile.StoreUint32(&o.MATRIX_WPSR.Reg, volatile.LoadUint32(&o.MATRIX_WPSR.Reg)&^(0x1)|value)
}
func (o *MATRIX_Type) GetMATRIX_WPSR_WPVS() uint32 {
	return volatile.LoadUint32(&o.MATRIX_WPSR.Reg) & 0x1
}
func (o *MATRIX_Type) SetMATRIX_WPSR_WPVSRC(value uint32) {
	volatile.StoreUint32(&o.MATRIX_WPSR.Reg, volatile.LoadUint32(&o.MATRIX_WPSR.Reg)&^(0xffff00)|value<<8)
}
func (o *MATRIX_Type) GetMATRIX_WPSR_WPVSRC() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_WPSR.Reg) & 0xffff00) >> 8
}

// Power Management Controller
type PMC_Type struct {
	PMC_SCER   volatile.Register32 // 0x0
	PMC_SCDR   volatile.Register32 // 0x4
	PMC_SCSR   volatile.Register32 // 0x8
	_          [4]byte
	PMC_PCER0  volatile.Register32 // 0x10
	PMC_PCDR0  volatile.Register32 // 0x14
	PMC_PCSR0  volatile.Register32 // 0x18
	_          [4]byte
	CKGR_MOR   volatile.Register32 // 0x20
	CKGR_MCFR  volatile.Register32 // 0x24
	CKGR_PLLAR volatile.Register32 // 0x28
	CKGR_PLLBR volatile.Register32 // 0x2C
	PMC_MCKR   volatile.Register32 // 0x30
	_          [4]byte
	PMC_USB    volatile.Register32 // 0x38
	_          [4]byte
	PMC_PCK    [3]volatile.Register32 // 0x40
	_          [20]byte
	PMC_IER    volatile.Register32 // 0x60
	PMC_IDR    volatile.Register32 // 0x64
	PMC_SR     volatile.Register32 // 0x68
	PMC_IMR    volatile.Register32 // 0x6C
	PMC_FSMR   volatile.Register32 // 0x70
	PMC_FSPR   volatile.Register32 // 0x74
	PMC_FOCR   volatile.Register32 // 0x78
	_          [104]byte
	PMC_WPMR   volatile.Register32 // 0xE4
	PMC_WPSR   volatile.Register32 // 0xE8
	_          [20]byte
	PMC_PCER1  volatile.Register32 // 0x100
	PMC_PCDR1  volatile.Register32 // 0x104
	PMC_PCSR1  volatile.Register32 // 0x108
	_          [4]byte
	PMC_OCR    volatile.Register32 // 0x110
}

// PMC.PMC_SCER: System Clock Enable Register
func (o *PMC_Type) SetPMC_SCER_UDP(value uint32) {
	volatile.StoreUint32(&o.PMC_SCER.Reg, volatile.LoadUint32(&o.PMC_SCER.Reg)&^(0x80)|value<<7)
}
func (o *PMC_Type) GetPMC_SCER_UDP() uint32 {
	return (volatile.LoadUint32(&o.PMC_SCER.Reg) & 0x80) >> 7
}
func (o *PMC_Type) SetPMC_SCER_PCK0(value uint32) {
	volatile.StoreUint32(&o.PMC_SCER.Reg, volatile.LoadUint32(&o.PMC_SCER.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetPMC_SCER_PCK0() uint32 {
	return (volatile.LoadUint32(&o.PMC_SCER.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetPMC_SCER_PCK1(value uint32) {
	volatile.StoreUint32(&o.PMC_SCER.Reg, volatile.LoadUint32(&o.PMC_SCER.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetPMC_SCER_PCK1() uint32 {
	return (volatile.LoadUint32(&o.PMC_SCER.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetPMC_SCER_PCK2(value uint32) {
	volatile.StoreUint32(&o.PMC_SCER.Reg, volatile.LoadUint32(&o.PMC_SCER.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetPMC_SCER_PCK2() uint32 {
	return (volatile.LoadUint32(&o.PMC_SCER.Reg) & 0x400) >> 10
}

// PMC.PMC_SCDR: System Clock Disable Register
func (o *PMC_Type) SetPMC_SCDR_UDP(value uint32) {
	volatile.StoreUint32(&o.PMC_SCDR.Reg, volatile.LoadUint32(&o.PMC_SCDR.Reg)&^(0x80)|value<<7)
}
func (o *PMC_Type) GetPMC_SCDR_UDP() uint32 {
	return (volatile.LoadUint32(&o.PMC_SCDR.Reg) & 0x80) >> 7
}
func (o *PMC_Type) SetPMC_SCDR_PCK0(value uint32) {
	volatile.StoreUint32(&o.PMC_SCDR.Reg, volatile.LoadUint32(&o.PMC_SCDR.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetPMC_SCDR_PCK0() uint32 {
	return (volatile.LoadUint32(&o.PMC_SCDR.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetPMC_SCDR_PCK1(value uint32) {
	volatile.StoreUint32(&o.PMC_SCDR.Reg, volatile.LoadUint32(&o.PMC_SCDR.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetPMC_SCDR_PCK1() uint32 {
	return (volatile.LoadUint32(&o.PMC_SCDR.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetPMC_SCDR_PCK2(value uint32) {
	volatile.StoreUint32(&o.PMC_SCDR.Reg, volatile.LoadUint32(&o.PMC_SCDR.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetPMC_SCDR_PCK2() uint32 {
	return (volatile.LoadUint32(&o.PMC_SCDR.Reg) & 0x400) >> 10
}

// PMC.PMC_SCSR: System Clock Status Register
func (o *PMC_Type) SetPMC_SCSR_UDP(value uint32) {
	volatile.StoreUint32(&o.PMC_SCSR.Reg, volatile.LoadUint32(&o.PMC_SCSR.Reg)&^(0x80)|value<<7)
}
func (o *PMC_Type) GetPMC_SCSR_UDP() uint32 {
	return (volatile.LoadUint32(&o.PMC_SCSR.Reg) & 0x80) >> 7
}
func (o *PMC_Type) SetPMC_SCSR_PCK0(value uint32) {
	volatile.StoreUint32(&o.PMC_SCSR.Reg, volatile.LoadUint32(&o.PMC_SCSR.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetPMC_SCSR_PCK0() uint32 {
	return (volatile.LoadUint32(&o.PMC_SCSR.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetPMC_SCSR_PCK1(value uint32) {
	volatile.StoreUint32(&o.PMC_SCSR.Reg, volatile.LoadUint32(&o.PMC_SCSR.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetPMC_SCSR_PCK1() uint32 {
	return (volatile.LoadUint32(&o.PMC_SCSR.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetPMC_SCSR_PCK2(value uint32) {
	volatile.StoreUint32(&o.PMC_SCSR.Reg, volatile.LoadUint32(&o.PMC_SCSR.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetPMC_SCSR_PCK2() uint32 {
	return (volatile.LoadUint32(&o.PMC_SCSR.Reg) & 0x400) >> 10
}

// PMC.PMC_PCER0: Peripheral Clock Enable Register 0
func (o *PMC_Type) SetPMC_PCER0_PID8(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetPMC_PCER0_PID8() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetPMC_PCER0_PID9(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetPMC_PCER0_PID9() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetPMC_PCER0_PID10(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetPMC_PCER0_PID10() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetPMC_PCER0_PID11(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x800)|value<<11)
}
func (o *PMC_Type) GetPMC_PCER0_PID11() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x800) >> 11
}
func (o *PMC_Type) SetPMC_PCER0_PID12(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x1000)|value<<12)
}
func (o *PMC_Type) GetPMC_PCER0_PID12() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x1000) >> 12
}
func (o *PMC_Type) SetPMC_PCER0_PID13(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x2000)|value<<13)
}
func (o *PMC_Type) GetPMC_PCER0_PID13() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x2000) >> 13
}
func (o *PMC_Type) SetPMC_PCER0_PID14(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x4000)|value<<14)
}
func (o *PMC_Type) GetPMC_PCER0_PID14() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x4000) >> 14
}
func (o *PMC_Type) SetPMC_PCER0_PID15(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x8000)|value<<15)
}
func (o *PMC_Type) GetPMC_PCER0_PID15() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x8000) >> 15
}
func (o *PMC_Type) SetPMC_PCER0_PID16(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetPMC_PCER0_PID16() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x10000) >> 16
}
func (o *PMC_Type) SetPMC_PCER0_PID17(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x20000)|value<<17)
}
func (o *PMC_Type) GetPMC_PCER0_PID17() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x20000) >> 17
}
func (o *PMC_Type) SetPMC_PCER0_PID18(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x40000)|value<<18)
}
func (o *PMC_Type) GetPMC_PCER0_PID18() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x40000) >> 18
}
func (o *PMC_Type) SetPMC_PCER0_PID19(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x80000)|value<<19)
}
func (o *PMC_Type) GetPMC_PCER0_PID19() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x80000) >> 19
}
func (o *PMC_Type) SetPMC_PCER0_PID20(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x100000)|value<<20)
}
func (o *PMC_Type) GetPMC_PCER0_PID20() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x100000) >> 20
}
func (o *PMC_Type) SetPMC_PCER0_PID21(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x200000)|value<<21)
}
func (o *PMC_Type) GetPMC_PCER0_PID21() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x200000) >> 21
}
func (o *PMC_Type) SetPMC_PCER0_PID22(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x400000)|value<<22)
}
func (o *PMC_Type) GetPMC_PCER0_PID22() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x400000) >> 22
}
func (o *PMC_Type) SetPMC_PCER0_PID23(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x800000)|value<<23)
}
func (o *PMC_Type) GetPMC_PCER0_PID23() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x800000) >> 23
}
func (o *PMC_Type) SetPMC_PCER0_PID24(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x1000000)|value<<24)
}
func (o *PMC_Type) GetPMC_PCER0_PID24() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x1000000) >> 24
}
func (o *PMC_Type) SetPMC_PCER0_PID25(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x2000000)|value<<25)
}
func (o *PMC_Type) GetPMC_PCER0_PID25() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x2000000) >> 25
}
func (o *PMC_Type) SetPMC_PCER0_PID26(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x4000000)|value<<26)
}
func (o *PMC_Type) GetPMC_PCER0_PID26() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x4000000) >> 26
}
func (o *PMC_Type) SetPMC_PCER0_PID27(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x8000000)|value<<27)
}
func (o *PMC_Type) GetPMC_PCER0_PID27() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x8000000) >> 27
}
func (o *PMC_Type) SetPMC_PCER0_PID28(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x10000000)|value<<28)
}
func (o *PMC_Type) GetPMC_PCER0_PID28() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x10000000) >> 28
}
func (o *PMC_Type) SetPMC_PCER0_PID29(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x20000000)|value<<29)
}
func (o *PMC_Type) GetPMC_PCER0_PID29() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x20000000) >> 29
}
func (o *PMC_Type) SetPMC_PCER0_PID30(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x40000000)|value<<30)
}
func (o *PMC_Type) GetPMC_PCER0_PID30() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x40000000) >> 30
}
func (o *PMC_Type) SetPMC_PCER0_PID31(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x80000000)|value<<31)
}
func (o *PMC_Type) GetPMC_PCER0_PID31() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x80000000) >> 31
}

// PMC.PMC_PCDR0: Peripheral Clock Disable Register 0
func (o *PMC_Type) SetPMC_PCDR0_PID8(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetPMC_PCDR0_PID8() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetPMC_PCDR0_PID9(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetPMC_PCDR0_PID9() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetPMC_PCDR0_PID10(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetPMC_PCDR0_PID10() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetPMC_PCDR0_PID11(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x800)|value<<11)
}
func (o *PMC_Type) GetPMC_PCDR0_PID11() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x800) >> 11
}
func (o *PMC_Type) SetPMC_PCDR0_PID12(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x1000)|value<<12)
}
func (o *PMC_Type) GetPMC_PCDR0_PID12() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x1000) >> 12
}
func (o *PMC_Type) SetPMC_PCDR0_PID13(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x2000)|value<<13)
}
func (o *PMC_Type) GetPMC_PCDR0_PID13() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x2000) >> 13
}
func (o *PMC_Type) SetPMC_PCDR0_PID14(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x4000)|value<<14)
}
func (o *PMC_Type) GetPMC_PCDR0_PID14() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x4000) >> 14
}
func (o *PMC_Type) SetPMC_PCDR0_PID15(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x8000)|value<<15)
}
func (o *PMC_Type) GetPMC_PCDR0_PID15() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x8000) >> 15
}
func (o *PMC_Type) SetPMC_PCDR0_PID16(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetPMC_PCDR0_PID16() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x10000) >> 16
}
func (o *PMC_Type) SetPMC_PCDR0_PID17(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x20000)|value<<17)
}
func (o *PMC_Type) GetPMC_PCDR0_PID17() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x20000) >> 17
}
func (o *PMC_Type) SetPMC_PCDR0_PID18(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x40000)|value<<18)
}
func (o *PMC_Type) GetPMC_PCDR0_PID18() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x40000) >> 18
}
func (o *PMC_Type) SetPMC_PCDR0_PID19(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x80000)|value<<19)
}
func (o *PMC_Type) GetPMC_PCDR0_PID19() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x80000) >> 19
}
func (o *PMC_Type) SetPMC_PCDR0_PID20(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x100000)|value<<20)
}
func (o *PMC_Type) GetPMC_PCDR0_PID20() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x100000) >> 20
}
func (o *PMC_Type) SetPMC_PCDR0_PID21(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x200000)|value<<21)
}
func (o *PMC_Type) GetPMC_PCDR0_PID21() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x200000) >> 21
}
func (o *PMC_Type) SetPMC_PCDR0_PID22(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x400000)|value<<22)
}
func (o *PMC_Type) GetPMC_PCDR0_PID22() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x400000) >> 22
}
func (o *PMC_Type) SetPMC_PCDR0_PID23(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x800000)|value<<23)
}
func (o *PMC_Type) GetPMC_PCDR0_PID23() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x800000) >> 23
}
func (o *PMC_Type) SetPMC_PCDR0_PID24(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x1000000)|value<<24)
}
func (o *PMC_Type) GetPMC_PCDR0_PID24() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x1000000) >> 24
}
func (o *PMC_Type) SetPMC_PCDR0_PID25(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x2000000)|value<<25)
}
func (o *PMC_Type) GetPMC_PCDR0_PID25() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x2000000) >> 25
}
func (o *PMC_Type) SetPMC_PCDR0_PID26(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x4000000)|value<<26)
}
func (o *PMC_Type) GetPMC_PCDR0_PID26() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x4000000) >> 26
}
func (o *PMC_Type) SetPMC_PCDR0_PID27(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x8000000)|value<<27)
}
func (o *PMC_Type) GetPMC_PCDR0_PID27() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x8000000) >> 27
}
func (o *PMC_Type) SetPMC_PCDR0_PID28(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x10000000)|value<<28)
}
func (o *PMC_Type) GetPMC_PCDR0_PID28() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x10000000) >> 28
}
func (o *PMC_Type) SetPMC_PCDR0_PID29(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x20000000)|value<<29)
}
func (o *PMC_Type) GetPMC_PCDR0_PID29() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x20000000) >> 29
}
func (o *PMC_Type) SetPMC_PCDR0_PID30(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x40000000)|value<<30)
}
func (o *PMC_Type) GetPMC_PCDR0_PID30() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x40000000) >> 30
}
func (o *PMC_Type) SetPMC_PCDR0_PID31(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x80000000)|value<<31)
}
func (o *PMC_Type) GetPMC_PCDR0_PID31() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x80000000) >> 31
}

// PMC.PMC_PCSR0: Peripheral Clock Status Register 0
func (o *PMC_Type) SetPMC_PCSR0_PID8(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetPMC_PCSR0_PID8() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetPMC_PCSR0_PID9(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetPMC_PCSR0_PID9() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetPMC_PCSR0_PID10(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetPMC_PCSR0_PID10() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetPMC_PCSR0_PID11(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x800)|value<<11)
}
func (o *PMC_Type) GetPMC_PCSR0_PID11() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x800) >> 11
}
func (o *PMC_Type) SetPMC_PCSR0_PID12(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x1000)|value<<12)
}
func (o *PMC_Type) GetPMC_PCSR0_PID12() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x1000) >> 12
}
func (o *PMC_Type) SetPMC_PCSR0_PID13(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x2000)|value<<13)
}
func (o *PMC_Type) GetPMC_PCSR0_PID13() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x2000) >> 13
}
func (o *PMC_Type) SetPMC_PCSR0_PID14(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x4000)|value<<14)
}
func (o *PMC_Type) GetPMC_PCSR0_PID14() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x4000) >> 14
}
func (o *PMC_Type) SetPMC_PCSR0_PID15(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x8000)|value<<15)
}
func (o *PMC_Type) GetPMC_PCSR0_PID15() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x8000) >> 15
}
func (o *PMC_Type) SetPMC_PCSR0_PID16(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetPMC_PCSR0_PID16() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x10000) >> 16
}
func (o *PMC_Type) SetPMC_PCSR0_PID17(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x20000)|value<<17)
}
func (o *PMC_Type) GetPMC_PCSR0_PID17() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x20000) >> 17
}
func (o *PMC_Type) SetPMC_PCSR0_PID18(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x40000)|value<<18)
}
func (o *PMC_Type) GetPMC_PCSR0_PID18() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x40000) >> 18
}
func (o *PMC_Type) SetPMC_PCSR0_PID19(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x80000)|value<<19)
}
func (o *PMC_Type) GetPMC_PCSR0_PID19() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x80000) >> 19
}
func (o *PMC_Type) SetPMC_PCSR0_PID20(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x100000)|value<<20)
}
func (o *PMC_Type) GetPMC_PCSR0_PID20() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x100000) >> 20
}
func (o *PMC_Type) SetPMC_PCSR0_PID21(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x200000)|value<<21)
}
func (o *PMC_Type) GetPMC_PCSR0_PID21() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x200000) >> 21
}
func (o *PMC_Type) SetPMC_PCSR0_PID22(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x400000)|value<<22)
}
func (o *PMC_Type) GetPMC_PCSR0_PID22() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x400000) >> 22
}
func (o *PMC_Type) SetPMC_PCSR0_PID23(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x800000)|value<<23)
}
func (o *PMC_Type) GetPMC_PCSR0_PID23() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x800000) >> 23
}
func (o *PMC_Type) SetPMC_PCSR0_PID24(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x1000000)|value<<24)
}
func (o *PMC_Type) GetPMC_PCSR0_PID24() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x1000000) >> 24
}
func (o *PMC_Type) SetPMC_PCSR0_PID25(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x2000000)|value<<25)
}
func (o *PMC_Type) GetPMC_PCSR0_PID25() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x2000000) >> 25
}
func (o *PMC_Type) SetPMC_PCSR0_PID26(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x4000000)|value<<26)
}
func (o *PMC_Type) GetPMC_PCSR0_PID26() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x4000000) >> 26
}
func (o *PMC_Type) SetPMC_PCSR0_PID27(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x8000000)|value<<27)
}
func (o *PMC_Type) GetPMC_PCSR0_PID27() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x8000000) >> 27
}
func (o *PMC_Type) SetPMC_PCSR0_PID28(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x10000000)|value<<28)
}
func (o *PMC_Type) GetPMC_PCSR0_PID28() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x10000000) >> 28
}
func (o *PMC_Type) SetPMC_PCSR0_PID29(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x20000000)|value<<29)
}
func (o *PMC_Type) GetPMC_PCSR0_PID29() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x20000000) >> 29
}
func (o *PMC_Type) SetPMC_PCSR0_PID30(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x40000000)|value<<30)
}
func (o *PMC_Type) GetPMC_PCSR0_PID30() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x40000000) >> 30
}
func (o *PMC_Type) SetPMC_PCSR0_PID31(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x80000000)|value<<31)
}
func (o *PMC_Type) GetPMC_PCSR0_PID31() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x80000000) >> 31
}

// PMC.CKGR_MOR: Main Oscillator Register
func (o *PMC_Type) SetCKGR_MOR_MOSCXTEN(value uint32) {
	volatile.StoreUint32(&o.CKGR_MOR.Reg, volatile.LoadUint32(&o.CKGR_MOR.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetCKGR_MOR_MOSCXTEN() uint32 {
	return volatile.LoadUint32(&o.CKGR_MOR.Reg) & 0x1
}
func (o *PMC_Type) SetCKGR_MOR_MOSCXTBY(value uint32) {
	volatile.StoreUint32(&o.CKGR_MOR.Reg, volatile.LoadUint32(&o.CKGR_MOR.Reg)&^(0x2)|value<<1)
}
func (o *PMC_Type) GetCKGR_MOR_MOSCXTBY() uint32 {
	return (volatile.LoadUint32(&o.CKGR_MOR.Reg) & 0x2) >> 1
}
func (o *PMC_Type) SetCKGR_MOR_WAITMODE(value uint32) {
	volatile.StoreUint32(&o.CKGR_MOR.Reg, volatile.LoadUint32(&o.CKGR_MOR.Reg)&^(0x4)|value<<2)
}
func (o *PMC_Type) GetCKGR_MOR_WAITMODE() uint32 {
	return (volatile.LoadUint32(&o.CKGR_MOR.Reg) & 0x4) >> 2
}
func (o *PMC_Type) SetCKGR_MOR_MOSCRCEN(value uint32) {
	volatile.StoreUint32(&o.CKGR_MOR.Reg, volatile.LoadUint32(&o.CKGR_MOR.Reg)&^(0x8)|value<<3)
}
func (o *PMC_Type) GetCKGR_MOR_MOSCRCEN() uint32 {
	return (volatile.LoadUint32(&o.CKGR_MOR.Reg) & 0x8) >> 3
}
func (o *PMC_Type) SetCKGR_MOR_MOSCRCF(value uint32) {
	volatile.StoreUint32(&o.CKGR_MOR.Reg, volatile.LoadUint32(&o.CKGR_MOR.Reg)&^(0x70)|value<<4)
}
func (o *PMC_Type) GetCKGR_MOR_MOSCRCF() uint32 {
	return (volatile.LoadUint32(&o.CKGR_MOR.Reg) & 0x70) >> 4
}
func (o *PMC_Type) SetCKGR_MOR_MOSCXTST(value uint32) {
	volatile.StoreUint32(&o.CKGR_MOR.Reg, volatile.LoadUint32(&o.CKGR_MOR.Reg)&^(0xff00)|value<<8)
}
func (o *PMC_Type) GetCKGR_MOR_MOSCXTST() uint32 {
	return (volatile.LoadUint32(&o.CKGR_MOR.Reg) & 0xff00) >> 8
}
func (o *PMC_Type) SetCKGR_MOR_KEY(value uint32) {
	volatile.StoreUint32(&o.CKGR_MOR.Reg, volatile.LoadUint32(&o.CKGR_MOR.Reg)&^(0xff0000)|value<<16)
}
func (o *PMC_Type) GetCKGR_MOR_KEY() uint32 {
	return (volatile.LoadUint32(&o.CKGR_MOR.Reg) & 0xff0000) >> 16
}
func (o *PMC_Type) SetCKGR_MOR_MOSCSEL(value uint32) {
	volatile.StoreUint32(&o.CKGR_MOR.Reg, volatile.LoadUint32(&o.CKGR_MOR.Reg)&^(0x1000000)|value<<24)
}
func (o *PMC_Type) GetCKGR_MOR_MOSCSEL() uint32 {
	return (volatile.LoadUint32(&o.CKGR_MOR.Reg) & 0x1000000) >> 24
}
func (o *PMC_Type) SetCKGR_MOR_CFDEN(value uint32) {
	volatile.StoreUint32(&o.CKGR_MOR.Reg, volatile.LoadUint32(&o.CKGR_MOR.Reg)&^(0x2000000)|value<<25)
}
func (o *PMC_Type) GetCKGR_MOR_CFDEN() uint32 {
	return (volatile.LoadUint32(&o.CKGR_MOR.Reg) & 0x2000000) >> 25
}

// PMC.CKGR_MCFR: Main Clock Frequency Register
func (o *PMC_Type) SetCKGR_MCFR_MAINF(value uint32) {
	volatile.StoreUint32(&o.CKGR_MCFR.Reg, volatile.LoadUint32(&o.CKGR_MCFR.Reg)&^(0xffff)|value)
}
func (o *PMC_Type) GetCKGR_MCFR_MAINF() uint32 {
	return volatile.LoadUint32(&o.CKGR_MCFR.Reg) & 0xffff
}
func (o *PMC_Type) SetCKGR_MCFR_MAINFRDY(value uint32) {
	volatile.StoreUint32(&o.CKGR_MCFR.Reg, volatile.LoadUint32(&o.CKGR_MCFR.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetCKGR_MCFR_MAINFRDY() uint32 {
	return (volatile.LoadUint32(&o.CKGR_MCFR.Reg) & 0x10000) >> 16
}
func (o *PMC_Type) SetCKGR_MCFR_RCMEAS(value uint32) {
	volatile.StoreUint32(&o.CKGR_MCFR.Reg, volatile.LoadUint32(&o.CKGR_MCFR.Reg)&^(0x100000)|value<<20)
}
func (o *PMC_Type) GetCKGR_MCFR_RCMEAS() uint32 {
	return (volatile.LoadUint32(&o.CKGR_MCFR.Reg) & 0x100000) >> 20
}

// PMC.CKGR_PLLAR: PLLA Register
func (o *PMC_Type) SetCKGR_PLLAR_DIVA(value uint32) {
	volatile.StoreUint32(&o.CKGR_PLLAR.Reg, volatile.LoadUint32(&o.CKGR_PLLAR.Reg)&^(0xff)|value)
}
func (o *PMC_Type) GetCKGR_PLLAR_DIVA() uint32 {
	return volatile.LoadUint32(&o.CKGR_PLLAR.Reg) & 0xff
}
func (o *PMC_Type) SetCKGR_PLLAR_PLLACOUNT(value uint32) {
	volatile.StoreUint32(&o.CKGR_PLLAR.Reg, volatile.LoadUint32(&o.CKGR_PLLAR.Reg)&^(0x3f00)|value<<8)
}
func (o *PMC_Type) GetCKGR_PLLAR_PLLACOUNT() uint32 {
	return (volatile.LoadUint32(&o.CKGR_PLLAR.Reg) & 0x3f00) >> 8
}
func (o *PMC_Type) SetCKGR_PLLAR_MULA(value uint32) {
	volatile.StoreUint32(&o.CKGR_PLLAR.Reg, volatile.LoadUint32(&o.CKGR_PLLAR.Reg)&^(0x7ff0000)|value<<16)
}
func (o *PMC_Type) GetCKGR_PLLAR_MULA() uint32 {
	return (volatile.LoadUint32(&o.CKGR_PLLAR.Reg) & 0x7ff0000) >> 16
}
func (o *PMC_Type) SetCKGR_PLLAR_ONE(value uint32) {
	volatile.StoreUint32(&o.CKGR_PLLAR.Reg, volatile.LoadUint32(&o.CKGR_PLLAR.Reg)&^(0x20000000)|value<<29)
}
func (o *PMC_Type) GetCKGR_PLLAR_ONE() uint32 {
	return (volatile.LoadUint32(&o.CKGR_PLLAR.Reg) & 0x20000000) >> 29
}

// PMC.CKGR_PLLBR: PLLB Register
func (o *PMC_Type) SetCKGR_PLLBR_DIVB(value uint32) {
	volatile.StoreUint32(&o.CKGR_PLLBR.Reg, volatile.LoadUint32(&o.CKGR_PLLBR.Reg)&^(0xff)|value)
}
func (o *PMC_Type) GetCKGR_PLLBR_DIVB() uint32 {
	return volatile.LoadUint32(&o.CKGR_PLLBR.Reg) & 0xff
}
func (o *PMC_Type) SetCKGR_PLLBR_PLLBCOUNT(value uint32) {
	volatile.StoreUint32(&o.CKGR_PLLBR.Reg, volatile.LoadUint32(&o.CKGR_PLLBR.Reg)&^(0x3f00)|value<<8)
}
func (o *PMC_Type) GetCKGR_PLLBR_PLLBCOUNT() uint32 {
	return (volatile.LoadUint32(&o.CKGR_PLLBR.Reg) & 0x3f00) >> 8
}
func (o *PMC_Type) SetCKGR_PLLBR_MULB(value uint32) {
	volatile.StoreUint32(&o.CKGR_PLLBR.Reg, volatile.LoadUint32(&o.CKGR_PLLBR.Reg)&^(0x7ff0000)|value<<16)
}
func (o *PMC_Type) GetCKGR_PLLBR_MULB() uint32 {
	return (volatile.LoadUint32(&o.CKGR_PLLBR.Reg) & 0x7ff0000) >> 16
}

// PMC.PMC_MCKR: Master Clock Register
func (o *PMC_Type) SetPMC_MCKR_CSS(value uint32) {
	volatile.StoreUint32(&o.PMC_MCKR.Reg, volatile.LoadUint32(&o.PMC_MCKR.Reg)&^(0x3)|value)
}
func (o *PMC_Type) GetPMC_MCKR_CSS() uint32 {
	return volatile.LoadUint32(&o.PMC_MCKR.Reg) & 0x3
}
func (o *PMC_Type) SetPMC_MCKR_PRES(value uint32) {
	volatile.StoreUint32(&o.PMC_MCKR.Reg, volatile.LoadUint32(&o.PMC_MCKR.Reg)&^(0x70)|value<<4)
}
func (o *PMC_Type) GetPMC_MCKR_PRES() uint32 {
	return (volatile.LoadUint32(&o.PMC_MCKR.Reg) & 0x70) >> 4
}
func (o *PMC_Type) SetPMC_MCKR_PLLADIV2(value uint32) {
	volatile.StoreUint32(&o.PMC_MCKR.Reg, volatile.LoadUint32(&o.PMC_MCKR.Reg)&^(0x1000)|value<<12)
}
func (o *PMC_Type) GetPMC_MCKR_PLLADIV2() uint32 {
	return (volatile.LoadUint32(&o.PMC_MCKR.Reg) & 0x1000) >> 12
}
func (o *PMC_Type) SetPMC_MCKR_PLLBDIV2(value uint32) {
	volatile.StoreUint32(&o.PMC_MCKR.Reg, volatile.LoadUint32(&o.PMC_MCKR.Reg)&^(0x2000)|value<<13)
}
func (o *PMC_Type) GetPMC_MCKR_PLLBDIV2() uint32 {
	return (volatile.LoadUint32(&o.PMC_MCKR.Reg) & 0x2000) >> 13
}

// PMC.PMC_USB: USB Clock Register
func (o *PMC_Type) SetPMC_USB_USBS(value uint32) {
	volatile.StoreUint32(&o.PMC_USB.Reg, volatile.LoadUint32(&o.PMC_USB.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetPMC_USB_USBS() uint32 {
	return volatile.LoadUint32(&o.PMC_USB.Reg) & 0x1
}
func (o *PMC_Type) SetPMC_USB_USBDIV(value uint32) {
	volatile.StoreUint32(&o.PMC_USB.Reg, volatile.LoadUint32(&o.PMC_USB.Reg)&^(0xf00)|value<<8)
}
func (o *PMC_Type) GetPMC_USB_USBDIV() uint32 {
	return (volatile.LoadUint32(&o.PMC_USB.Reg) & 0xf00) >> 8
}

// PMC.PMC_PCK: Programmable Clock 0 Register
func (o *PMC_Type) SetPMC_PCK_CSS(idx int, value uint32) {
	volatile.StoreUint32(&o.PMC_PCK[idx].Reg, volatile.LoadUint32(&o.PMC_PCK[idx].Reg)&^(0x7)|value)
}
func (o *PMC_Type) GetPMC_PCK_CSS(idx int) uint32 {
	return volatile.LoadUint32(&o.PMC_PCK[idx].Reg) & 0x7
}
func (o *PMC_Type) SetPMC_PCK_PRES(idx int, value uint32) {
	volatile.StoreUint32(&o.PMC_PCK[idx].Reg, volatile.LoadUint32(&o.PMC_PCK[idx].Reg)&^(0x70)|value<<4)
}
func (o *PMC_Type) GetPMC_PCK_PRES(idx int) uint32 {
	return (volatile.LoadUint32(&o.PMC_PCK[idx].Reg) & 0x70) >> 4
}

// PMC.PMC_IER: Interrupt Enable Register
func (o *PMC_Type) SetPMC_IER_MOSCXTS(value uint32) {
	volatile.StoreUint32(&o.PMC_IER.Reg, volatile.LoadUint32(&o.PMC_IER.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetPMC_IER_MOSCXTS() uint32 {
	return volatile.LoadUint32(&o.PMC_IER.Reg) & 0x1
}
func (o *PMC_Type) SetPMC_IER_LOCKA(value uint32) {
	volatile.StoreUint32(&o.PMC_IER.Reg, volatile.LoadUint32(&o.PMC_IER.Reg)&^(0x2)|value<<1)
}
func (o *PMC_Type) GetPMC_IER_LOCKA() uint32 {
	return (volatile.LoadUint32(&o.PMC_IER.Reg) & 0x2) >> 1
}
func (o *PMC_Type) SetPMC_IER_LOCKB(value uint32) {
	volatile.StoreUint32(&o.PMC_IER.Reg, volatile.LoadUint32(&o.PMC_IER.Reg)&^(0x4)|value<<2)
}
func (o *PMC_Type) GetPMC_IER_LOCKB() uint32 {
	return (volatile.LoadUint32(&o.PMC_IER.Reg) & 0x4) >> 2
}
func (o *PMC_Type) SetPMC_IER_MCKRDY(value uint32) {
	volatile.StoreUint32(&o.PMC_IER.Reg, volatile.LoadUint32(&o.PMC_IER.Reg)&^(0x8)|value<<3)
}
func (o *PMC_Type) GetPMC_IER_MCKRDY() uint32 {
	return (volatile.LoadUint32(&o.PMC_IER.Reg) & 0x8) >> 3
}
func (o *PMC_Type) SetPMC_IER_PCKRDY0(value uint32) {
	volatile.StoreUint32(&o.PMC_IER.Reg, volatile.LoadUint32(&o.PMC_IER.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetPMC_IER_PCKRDY0() uint32 {
	return (volatile.LoadUint32(&o.PMC_IER.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetPMC_IER_PCKRDY1(value uint32) {
	volatile.StoreUint32(&o.PMC_IER.Reg, volatile.LoadUint32(&o.PMC_IER.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetPMC_IER_PCKRDY1() uint32 {
	return (volatile.LoadUint32(&o.PMC_IER.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetPMC_IER_PCKRDY2(value uint32) {
	volatile.StoreUint32(&o.PMC_IER.Reg, volatile.LoadUint32(&o.PMC_IER.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetPMC_IER_PCKRDY2() uint32 {
	return (volatile.LoadUint32(&o.PMC_IER.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetPMC_IER_MOSCSELS(value uint32) {
	volatile.StoreUint32(&o.PMC_IER.Reg, volatile.LoadUint32(&o.PMC_IER.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetPMC_IER_MOSCSELS() uint32 {
	return (volatile.LoadUint32(&o.PMC_IER.Reg) & 0x10000) >> 16
}
func (o *PMC_Type) SetPMC_IER_MOSCRCS(value uint32) {
	volatile.StoreUint32(&o.PMC_IER.Reg, volatile.LoadUint32(&o.PMC_IER.Reg)&^(0x20000)|value<<17)
}
func (o *PMC_Type) GetPMC_IER_MOSCRCS() uint32 {
	return (volatile.LoadUint32(&o.PMC_IER.Reg) & 0x20000) >> 17
}
func (o *PMC_Type) SetPMC_IER_CFDEV(value uint32) {
	volatile.StoreUint32(&o.PMC_IER.Reg, volatile.LoadUint32(&o.PMC_IER.Reg)&^(0x40000)|value<<18)
}
func (o *PMC_Type) GetPMC_IER_CFDEV() uint32 {
	return (volatile.LoadUint32(&o.PMC_IER.Reg) & 0x40000) >> 18
}

// PMC.PMC_IDR: Interrupt Disable Register
func (o *PMC_Type) SetPMC_IDR_MOSCXTS(value uint32) {
	volatile.StoreUint32(&o.PMC_IDR.Reg, volatile.LoadUint32(&o.PMC_IDR.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetPMC_IDR_MOSCXTS() uint32 {
	return volatile.LoadUint32(&o.PMC_IDR.Reg) & 0x1
}
func (o *PMC_Type) SetPMC_IDR_LOCKA(value uint32) {
	volatile.StoreUint32(&o.PMC_IDR.Reg, volatile.LoadUint32(&o.PMC_IDR.Reg)&^(0x2)|value<<1)
}
func (o *PMC_Type) GetPMC_IDR_LOCKA() uint32 {
	return (volatile.LoadUint32(&o.PMC_IDR.Reg) & 0x2) >> 1
}
func (o *PMC_Type) SetPMC_IDR_LOCKB(value uint32) {
	volatile.StoreUint32(&o.PMC_IDR.Reg, volatile.LoadUint32(&o.PMC_IDR.Reg)&^(0x4)|value<<2)
}
func (o *PMC_Type) GetPMC_IDR_LOCKB() uint32 {
	return (volatile.LoadUint32(&o.PMC_IDR.Reg) & 0x4) >> 2
}
func (o *PMC_Type) SetPMC_IDR_MCKRDY(value uint32) {
	volatile.StoreUint32(&o.PMC_IDR.Reg, volatile.LoadUint32(&o.PMC_IDR.Reg)&^(0x8)|value<<3)
}
func (o *PMC_Type) GetPMC_IDR_MCKRDY() uint32 {
	return (volatile.LoadUint32(&o.PMC_IDR.Reg) & 0x8) >> 3
}
func (o *PMC_Type) SetPMC_IDR_PCKRDY0(value uint32) {
	volatile.StoreUint32(&o.PMC_IDR.Reg, volatile.LoadUint32(&o.PMC_IDR.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetPMC_IDR_PCKRDY0() uint32 {
	return (volatile.LoadUint32(&o.PMC_IDR.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetPMC_IDR_PCKRDY1(value uint32) {
	volatile.StoreUint32(&o.PMC_IDR.Reg, volatile.LoadUint32(&o.PMC_IDR.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetPMC_IDR_PCKRDY1() uint32 {
	return (volatile.LoadUint32(&o.PMC_IDR.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetPMC_IDR_PCKRDY2(value uint32) {
	volatile.StoreUint32(&o.PMC_IDR.Reg, volatile.LoadUint32(&o.PMC_IDR.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetPMC_IDR_PCKRDY2() uint32 {
	return (volatile.LoadUint32(&o.PMC_IDR.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetPMC_IDR_MOSCSELS(value uint32) {
	volatile.StoreUint32(&o.PMC_IDR.Reg, volatile.LoadUint32(&o.PMC_IDR.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetPMC_IDR_MOSCSELS() uint32 {
	return (volatile.LoadUint32(&o.PMC_IDR.Reg) & 0x10000) >> 16
}
func (o *PMC_Type) SetPMC_IDR_MOSCRCS(value uint32) {
	volatile.StoreUint32(&o.PMC_IDR.Reg, volatile.LoadUint32(&o.PMC_IDR.Reg)&^(0x20000)|value<<17)
}
func (o *PMC_Type) GetPMC_IDR_MOSCRCS() uint32 {
	return (volatile.LoadUint32(&o.PMC_IDR.Reg) & 0x20000) >> 17
}
func (o *PMC_Type) SetPMC_IDR_CFDEV(value uint32) {
	volatile.StoreUint32(&o.PMC_IDR.Reg, volatile.LoadUint32(&o.PMC_IDR.Reg)&^(0x40000)|value<<18)
}
func (o *PMC_Type) GetPMC_IDR_CFDEV() uint32 {
	return (volatile.LoadUint32(&o.PMC_IDR.Reg) & 0x40000) >> 18
}

// PMC.PMC_SR: Status Register
func (o *PMC_Type) SetPMC_SR_MOSCXTS(value uint32) {
	volatile.StoreUint32(&o.PMC_SR.Reg, volatile.LoadUint32(&o.PMC_SR.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetPMC_SR_MOSCXTS() uint32 {
	return volatile.LoadUint32(&o.PMC_SR.Reg) & 0x1
}
func (o *PMC_Type) SetPMC_SR_LOCKA(value uint32) {
	volatile.StoreUint32(&o.PMC_SR.Reg, volatile.LoadUint32(&o.PMC_SR.Reg)&^(0x2)|value<<1)
}
func (o *PMC_Type) GetPMC_SR_LOCKA() uint32 {
	return (volatile.LoadUint32(&o.PMC_SR.Reg) & 0x2) >> 1
}
func (o *PMC_Type) SetPMC_SR_LOCKB(value uint32) {
	volatile.StoreUint32(&o.PMC_SR.Reg, volatile.LoadUint32(&o.PMC_SR.Reg)&^(0x4)|value<<2)
}
func (o *PMC_Type) GetPMC_SR_LOCKB() uint32 {
	return (volatile.LoadUint32(&o.PMC_SR.Reg) & 0x4) >> 2
}
func (o *PMC_Type) SetPMC_SR_MCKRDY(value uint32) {
	volatile.StoreUint32(&o.PMC_SR.Reg, volatile.LoadUint32(&o.PMC_SR.Reg)&^(0x8)|value<<3)
}
func (o *PMC_Type) GetPMC_SR_MCKRDY() uint32 {
	return (volatile.LoadUint32(&o.PMC_SR.Reg) & 0x8) >> 3
}
func (o *PMC_Type) SetPMC_SR_OSCSELS(value uint32) {
	volatile.StoreUint32(&o.PMC_SR.Reg, volatile.LoadUint32(&o.PMC_SR.Reg)&^(0x80)|value<<7)
}
func (o *PMC_Type) GetPMC_SR_OSCSELS() uint32 {
	return (volatile.LoadUint32(&o.PMC_SR.Reg) & 0x80) >> 7
}
func (o *PMC_Type) SetPMC_SR_PCKRDY0(value uint32) {
	volatile.StoreUint32(&o.PMC_SR.Reg, volatile.LoadUint32(&o.PMC_SR.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetPMC_SR_PCKRDY0() uint32 {
	return (volatile.LoadUint32(&o.PMC_SR.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetPMC_SR_PCKRDY1(value uint32) {
	volatile.StoreUint32(&o.PMC_SR.Reg, volatile.LoadUint32(&o.PMC_SR.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetPMC_SR_PCKRDY1() uint32 {
	return (volatile.LoadUint32(&o.PMC_SR.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetPMC_SR_PCKRDY2(value uint32) {
	volatile.StoreUint32(&o.PMC_SR.Reg, volatile.LoadUint32(&o.PMC_SR.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetPMC_SR_PCKRDY2() uint32 {
	return (volatile.LoadUint32(&o.PMC_SR.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetPMC_SR_MOSCSELS(value uint32) {
	volatile.StoreUint32(&o.PMC_SR.Reg, volatile.LoadUint32(&o.PMC_SR.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetPMC_SR_MOSCSELS() uint32 {
	return (volatile.LoadUint32(&o.PMC_SR.Reg) & 0x10000) >> 16
}
func (o *PMC_Type) SetPMC_SR_MOSCRCS(value uint32) {
	volatile.StoreUint32(&o.PMC_SR.Reg, volatile.LoadUint32(&o.PMC_SR.Reg)&^(0x20000)|value<<17)
}
func (o *PMC_Type) GetPMC_SR_MOSCRCS() uint32 {
	return (volatile.LoadUint32(&o.PMC_SR.Reg) & 0x20000) >> 17
}
func (o *PMC_Type) SetPMC_SR_CFDEV(value uint32) {
	volatile.StoreUint32(&o.PMC_SR.Reg, volatile.LoadUint32(&o.PMC_SR.Reg)&^(0x40000)|value<<18)
}
func (o *PMC_Type) GetPMC_SR_CFDEV() uint32 {
	return (volatile.LoadUint32(&o.PMC_SR.Reg) & 0x40000) >> 18
}
func (o *PMC_Type) SetPMC_SR_CFDS(value uint32) {
	volatile.StoreUint32(&o.PMC_SR.Reg, volatile.LoadUint32(&o.PMC_SR.Reg)&^(0x80000)|value<<19)
}
func (o *PMC_Type) GetPMC_SR_CFDS() uint32 {
	return (volatile.LoadUint32(&o.PMC_SR.Reg) & 0x80000) >> 19
}
func (o *PMC_Type) SetPMC_SR_FOS(value uint32) {
	volatile.StoreUint32(&o.PMC_SR.Reg, volatile.LoadUint32(&o.PMC_SR.Reg)&^(0x100000)|value<<20)
}
func (o *PMC_Type) GetPMC_SR_FOS() uint32 {
	return (volatile.LoadUint32(&o.PMC_SR.Reg) & 0x100000) >> 20
}

// PMC.PMC_IMR: Interrupt Mask Register
func (o *PMC_Type) SetPMC_IMR_MOSCXTS(value uint32) {
	volatile.StoreUint32(&o.PMC_IMR.Reg, volatile.LoadUint32(&o.PMC_IMR.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetPMC_IMR_MOSCXTS() uint32 {
	return volatile.LoadUint32(&o.PMC_IMR.Reg) & 0x1
}
func (o *PMC_Type) SetPMC_IMR_LOCKA(value uint32) {
	volatile.StoreUint32(&o.PMC_IMR.Reg, volatile.LoadUint32(&o.PMC_IMR.Reg)&^(0x2)|value<<1)
}
func (o *PMC_Type) GetPMC_IMR_LOCKA() uint32 {
	return (volatile.LoadUint32(&o.PMC_IMR.Reg) & 0x2) >> 1
}
func (o *PMC_Type) SetPMC_IMR_LOCKB(value uint32) {
	volatile.StoreUint32(&o.PMC_IMR.Reg, volatile.LoadUint32(&o.PMC_IMR.Reg)&^(0x4)|value<<2)
}
func (o *PMC_Type) GetPMC_IMR_LOCKB() uint32 {
	return (volatile.LoadUint32(&o.PMC_IMR.Reg) & 0x4) >> 2
}
func (o *PMC_Type) SetPMC_IMR_MCKRDY(value uint32) {
	volatile.StoreUint32(&o.PMC_IMR.Reg, volatile.LoadUint32(&o.PMC_IMR.Reg)&^(0x8)|value<<3)
}
func (o *PMC_Type) GetPMC_IMR_MCKRDY() uint32 {
	return (volatile.LoadUint32(&o.PMC_IMR.Reg) & 0x8) >> 3
}
func (o *PMC_Type) SetPMC_IMR_PCKRDY0(value uint32) {
	volatile.StoreUint32(&o.PMC_IMR.Reg, volatile.LoadUint32(&o.PMC_IMR.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetPMC_IMR_PCKRDY0() uint32 {
	return (volatile.LoadUint32(&o.PMC_IMR.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetPMC_IMR_PCKRDY1(value uint32) {
	volatile.StoreUint32(&o.PMC_IMR.Reg, volatile.LoadUint32(&o.PMC_IMR.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetPMC_IMR_PCKRDY1() uint32 {
	return (volatile.LoadUint32(&o.PMC_IMR.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetPMC_IMR_PCKRDY2(value uint32) {
	volatile.StoreUint32(&o.PMC_IMR.Reg, volatile.LoadUint32(&o.PMC_IMR.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetPMC_IMR_PCKRDY2() uint32 {
	return (volatile.LoadUint32(&o.PMC_IMR.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetPMC_IMR_MOSCSELS(value uint32) {
	volatile.StoreUint32(&o.PMC_IMR.Reg, volatile.LoadUint32(&o.PMC_IMR.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetPMC_IMR_MOSCSELS() uint32 {
	return (volatile.LoadUint32(&o.PMC_IMR.Reg) & 0x10000) >> 16
}
func (o *PMC_Type) SetPMC_IMR_MOSCRCS(value uint32) {
	volatile.StoreUint32(&o.PMC_IMR.Reg, volatile.LoadUint32(&o.PMC_IMR.Reg)&^(0x20000)|value<<17)
}
func (o *PMC_Type) GetPMC_IMR_MOSCRCS() uint32 {
	return (volatile.LoadUint32(&o.PMC_IMR.Reg) & 0x20000) >> 17
}
func (o *PMC_Type) SetPMC_IMR_CFDEV(value uint32) {
	volatile.StoreUint32(&o.PMC_IMR.Reg, volatile.LoadUint32(&o.PMC_IMR.Reg)&^(0x40000)|value<<18)
}
func (o *PMC_Type) GetPMC_IMR_CFDEV() uint32 {
	return (volatile.LoadUint32(&o.PMC_IMR.Reg) & 0x40000) >> 18
}

// PMC.PMC_FSMR: Fast Startup Mode Register
func (o *PMC_Type) SetPMC_FSMR_FSTT0(value uint32) {
	volatile.StoreUint32(&o.PMC_FSMR.Reg, volatile.LoadUint32(&o.PMC_FSMR.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetPMC_FSMR_FSTT0() uint32 {
	return volatile.LoadUint32(&o.PMC_FSMR.Reg) & 0x1
}
func (o *PMC_Type) SetPMC_FSMR_FSTT1(value uint32) {
	volatile.StoreUint32(&o.PMC_FSMR.Reg, volatile.LoadUint32(&o.PMC_FSMR.Reg)&^(0x2)|value<<1)
}
func (o *PMC_Type) GetPMC_FSMR_FSTT1() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSMR.Reg) & 0x2) >> 1
}
func (o *PMC_Type) SetPMC_FSMR_FSTT2(value uint32) {
	volatile.StoreUint32(&o.PMC_FSMR.Reg, volatile.LoadUint32(&o.PMC_FSMR.Reg)&^(0x4)|value<<2)
}
func (o *PMC_Type) GetPMC_FSMR_FSTT2() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSMR.Reg) & 0x4) >> 2
}
func (o *PMC_Type) SetPMC_FSMR_FSTT3(value uint32) {
	volatile.StoreUint32(&o.PMC_FSMR.Reg, volatile.LoadUint32(&o.PMC_FSMR.Reg)&^(0x8)|value<<3)
}
func (o *PMC_Type) GetPMC_FSMR_FSTT3() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSMR.Reg) & 0x8) >> 3
}
func (o *PMC_Type) SetPMC_FSMR_FSTT4(value uint32) {
	volatile.StoreUint32(&o.PMC_FSMR.Reg, volatile.LoadUint32(&o.PMC_FSMR.Reg)&^(0x10)|value<<4)
}
func (o *PMC_Type) GetPMC_FSMR_FSTT4() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSMR.Reg) & 0x10) >> 4
}
func (o *PMC_Type) SetPMC_FSMR_FSTT5(value uint32) {
	volatile.StoreUint32(&o.PMC_FSMR.Reg, volatile.LoadUint32(&o.PMC_FSMR.Reg)&^(0x20)|value<<5)
}
func (o *PMC_Type) GetPMC_FSMR_FSTT5() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSMR.Reg) & 0x20) >> 5
}
func (o *PMC_Type) SetPMC_FSMR_FSTT6(value uint32) {
	volatile.StoreUint32(&o.PMC_FSMR.Reg, volatile.LoadUint32(&o.PMC_FSMR.Reg)&^(0x40)|value<<6)
}
func (o *PMC_Type) GetPMC_FSMR_FSTT6() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSMR.Reg) & 0x40) >> 6
}
func (o *PMC_Type) SetPMC_FSMR_FSTT7(value uint32) {
	volatile.StoreUint32(&o.PMC_FSMR.Reg, volatile.LoadUint32(&o.PMC_FSMR.Reg)&^(0x80)|value<<7)
}
func (o *PMC_Type) GetPMC_FSMR_FSTT7() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSMR.Reg) & 0x80) >> 7
}
func (o *PMC_Type) SetPMC_FSMR_FSTT8(value uint32) {
	volatile.StoreUint32(&o.PMC_FSMR.Reg, volatile.LoadUint32(&o.PMC_FSMR.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetPMC_FSMR_FSTT8() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSMR.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetPMC_FSMR_FSTT9(value uint32) {
	volatile.StoreUint32(&o.PMC_FSMR.Reg, volatile.LoadUint32(&o.PMC_FSMR.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetPMC_FSMR_FSTT9() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSMR.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetPMC_FSMR_FSTT10(value uint32) {
	volatile.StoreUint32(&o.PMC_FSMR.Reg, volatile.LoadUint32(&o.PMC_FSMR.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetPMC_FSMR_FSTT10() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSMR.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetPMC_FSMR_FSTT11(value uint32) {
	volatile.StoreUint32(&o.PMC_FSMR.Reg, volatile.LoadUint32(&o.PMC_FSMR.Reg)&^(0x800)|value<<11)
}
func (o *PMC_Type) GetPMC_FSMR_FSTT11() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSMR.Reg) & 0x800) >> 11
}
func (o *PMC_Type) SetPMC_FSMR_FSTT12(value uint32) {
	volatile.StoreUint32(&o.PMC_FSMR.Reg, volatile.LoadUint32(&o.PMC_FSMR.Reg)&^(0x1000)|value<<12)
}
func (o *PMC_Type) GetPMC_FSMR_FSTT12() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSMR.Reg) & 0x1000) >> 12
}
func (o *PMC_Type) SetPMC_FSMR_FSTT13(value uint32) {
	volatile.StoreUint32(&o.PMC_FSMR.Reg, volatile.LoadUint32(&o.PMC_FSMR.Reg)&^(0x2000)|value<<13)
}
func (o *PMC_Type) GetPMC_FSMR_FSTT13() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSMR.Reg) & 0x2000) >> 13
}
func (o *PMC_Type) SetPMC_FSMR_FSTT14(value uint32) {
	volatile.StoreUint32(&o.PMC_FSMR.Reg, volatile.LoadUint32(&o.PMC_FSMR.Reg)&^(0x4000)|value<<14)
}
func (o *PMC_Type) GetPMC_FSMR_FSTT14() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSMR.Reg) & 0x4000) >> 14
}
func (o *PMC_Type) SetPMC_FSMR_FSTT15(value uint32) {
	volatile.StoreUint32(&o.PMC_FSMR.Reg, volatile.LoadUint32(&o.PMC_FSMR.Reg)&^(0x8000)|value<<15)
}
func (o *PMC_Type) GetPMC_FSMR_FSTT15() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSMR.Reg) & 0x8000) >> 15
}
func (o *PMC_Type) SetPMC_FSMR_RTTAL(value uint32) {
	volatile.StoreUint32(&o.PMC_FSMR.Reg, volatile.LoadUint32(&o.PMC_FSMR.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetPMC_FSMR_RTTAL() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSMR.Reg) & 0x10000) >> 16
}
func (o *PMC_Type) SetPMC_FSMR_RTCAL(value uint32) {
	volatile.StoreUint32(&o.PMC_FSMR.Reg, volatile.LoadUint32(&o.PMC_FSMR.Reg)&^(0x20000)|value<<17)
}
func (o *PMC_Type) GetPMC_FSMR_RTCAL() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSMR.Reg) & 0x20000) >> 17
}
func (o *PMC_Type) SetPMC_FSMR_USBAL(value uint32) {
	volatile.StoreUint32(&o.PMC_FSMR.Reg, volatile.LoadUint32(&o.PMC_FSMR.Reg)&^(0x40000)|value<<18)
}
func (o *PMC_Type) GetPMC_FSMR_USBAL() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSMR.Reg) & 0x40000) >> 18
}
func (o *PMC_Type) SetPMC_FSMR_LPM(value uint32) {
	volatile.StoreUint32(&o.PMC_FSMR.Reg, volatile.LoadUint32(&o.PMC_FSMR.Reg)&^(0x100000)|value<<20)
}
func (o *PMC_Type) GetPMC_FSMR_LPM() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSMR.Reg) & 0x100000) >> 20
}
func (o *PMC_Type) SetPMC_FSMR_FLPM(value uint32) {
	volatile.StoreUint32(&o.PMC_FSMR.Reg, volatile.LoadUint32(&o.PMC_FSMR.Reg)&^(0x600000)|value<<21)
}
func (o *PMC_Type) GetPMC_FSMR_FLPM() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSMR.Reg) & 0x600000) >> 21
}

// PMC.PMC_FSPR: Fast Startup Polarity Register
func (o *PMC_Type) SetPMC_FSPR_FSTP0(value uint32) {
	volatile.StoreUint32(&o.PMC_FSPR.Reg, volatile.LoadUint32(&o.PMC_FSPR.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetPMC_FSPR_FSTP0() uint32 {
	return volatile.LoadUint32(&o.PMC_FSPR.Reg) & 0x1
}
func (o *PMC_Type) SetPMC_FSPR_FSTP1(value uint32) {
	volatile.StoreUint32(&o.PMC_FSPR.Reg, volatile.LoadUint32(&o.PMC_FSPR.Reg)&^(0x2)|value<<1)
}
func (o *PMC_Type) GetPMC_FSPR_FSTP1() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSPR.Reg) & 0x2) >> 1
}
func (o *PMC_Type) SetPMC_FSPR_FSTP2(value uint32) {
	volatile.StoreUint32(&o.PMC_FSPR.Reg, volatile.LoadUint32(&o.PMC_FSPR.Reg)&^(0x4)|value<<2)
}
func (o *PMC_Type) GetPMC_FSPR_FSTP2() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSPR.Reg) & 0x4) >> 2
}
func (o *PMC_Type) SetPMC_FSPR_FSTP3(value uint32) {
	volatile.StoreUint32(&o.PMC_FSPR.Reg, volatile.LoadUint32(&o.PMC_FSPR.Reg)&^(0x8)|value<<3)
}
func (o *PMC_Type) GetPMC_FSPR_FSTP3() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSPR.Reg) & 0x8) >> 3
}
func (o *PMC_Type) SetPMC_FSPR_FSTP4(value uint32) {
	volatile.StoreUint32(&o.PMC_FSPR.Reg, volatile.LoadUint32(&o.PMC_FSPR.Reg)&^(0x10)|value<<4)
}
func (o *PMC_Type) GetPMC_FSPR_FSTP4() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSPR.Reg) & 0x10) >> 4
}
func (o *PMC_Type) SetPMC_FSPR_FSTP5(value uint32) {
	volatile.StoreUint32(&o.PMC_FSPR.Reg, volatile.LoadUint32(&o.PMC_FSPR.Reg)&^(0x20)|value<<5)
}
func (o *PMC_Type) GetPMC_FSPR_FSTP5() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSPR.Reg) & 0x20) >> 5
}
func (o *PMC_Type) SetPMC_FSPR_FSTP6(value uint32) {
	volatile.StoreUint32(&o.PMC_FSPR.Reg, volatile.LoadUint32(&o.PMC_FSPR.Reg)&^(0x40)|value<<6)
}
func (o *PMC_Type) GetPMC_FSPR_FSTP6() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSPR.Reg) & 0x40) >> 6
}
func (o *PMC_Type) SetPMC_FSPR_FSTP7(value uint32) {
	volatile.StoreUint32(&o.PMC_FSPR.Reg, volatile.LoadUint32(&o.PMC_FSPR.Reg)&^(0x80)|value<<7)
}
func (o *PMC_Type) GetPMC_FSPR_FSTP7() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSPR.Reg) & 0x80) >> 7
}
func (o *PMC_Type) SetPMC_FSPR_FSTP8(value uint32) {
	volatile.StoreUint32(&o.PMC_FSPR.Reg, volatile.LoadUint32(&o.PMC_FSPR.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetPMC_FSPR_FSTP8() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSPR.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetPMC_FSPR_FSTP9(value uint32) {
	volatile.StoreUint32(&o.PMC_FSPR.Reg, volatile.LoadUint32(&o.PMC_FSPR.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetPMC_FSPR_FSTP9() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSPR.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetPMC_FSPR_FSTP10(value uint32) {
	volatile.StoreUint32(&o.PMC_FSPR.Reg, volatile.LoadUint32(&o.PMC_FSPR.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetPMC_FSPR_FSTP10() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSPR.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetPMC_FSPR_FSTP11(value uint32) {
	volatile.StoreUint32(&o.PMC_FSPR.Reg, volatile.LoadUint32(&o.PMC_FSPR.Reg)&^(0x800)|value<<11)
}
func (o *PMC_Type) GetPMC_FSPR_FSTP11() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSPR.Reg) & 0x800) >> 11
}
func (o *PMC_Type) SetPMC_FSPR_FSTP12(value uint32) {
	volatile.StoreUint32(&o.PMC_FSPR.Reg, volatile.LoadUint32(&o.PMC_FSPR.Reg)&^(0x1000)|value<<12)
}
func (o *PMC_Type) GetPMC_FSPR_FSTP12() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSPR.Reg) & 0x1000) >> 12
}
func (o *PMC_Type) SetPMC_FSPR_FSTP13(value uint32) {
	volatile.StoreUint32(&o.PMC_FSPR.Reg, volatile.LoadUint32(&o.PMC_FSPR.Reg)&^(0x2000)|value<<13)
}
func (o *PMC_Type) GetPMC_FSPR_FSTP13() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSPR.Reg) & 0x2000) >> 13
}
func (o *PMC_Type) SetPMC_FSPR_FSTP14(value uint32) {
	volatile.StoreUint32(&o.PMC_FSPR.Reg, volatile.LoadUint32(&o.PMC_FSPR.Reg)&^(0x4000)|value<<14)
}
func (o *PMC_Type) GetPMC_FSPR_FSTP14() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSPR.Reg) & 0x4000) >> 14
}
func (o *PMC_Type) SetPMC_FSPR_FSTP15(value uint32) {
	volatile.StoreUint32(&o.PMC_FSPR.Reg, volatile.LoadUint32(&o.PMC_FSPR.Reg)&^(0x8000)|value<<15)
}
func (o *PMC_Type) GetPMC_FSPR_FSTP15() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSPR.Reg) & 0x8000) >> 15
}

// PMC.PMC_FOCR: Fault Output Clear Register
func (o *PMC_Type) SetPMC_FOCR_FOCLR(value uint32) {
	volatile.StoreUint32(&o.PMC_FOCR.Reg, volatile.LoadUint32(&o.PMC_FOCR.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetPMC_FOCR_FOCLR() uint32 {
	return volatile.LoadUint32(&o.PMC_FOCR.Reg) & 0x1
}

// PMC.PMC_WPMR: Write Protection Mode Register
func (o *PMC_Type) SetPMC_WPMR_WPEN(value uint32) {
	volatile.StoreUint32(&o.PMC_WPMR.Reg, volatile.LoadUint32(&o.PMC_WPMR.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetPMC_WPMR_WPEN() uint32 {
	return volatile.LoadUint32(&o.PMC_WPMR.Reg) & 0x1
}
func (o *PMC_Type) SetPMC_WPMR_WPKEY(value uint32) {
	volatile.StoreUint32(&o.PMC_WPMR.Reg, volatile.LoadUint32(&o.PMC_WPMR.Reg)&^(0xffffff00)|value<<8)
}
func (o *PMC_Type) GetPMC_WPMR_WPKEY() uint32 {
	return (volatile.LoadUint32(&o.PMC_WPMR.Reg) & 0xffffff00) >> 8
}

// PMC.PMC_WPSR: Write Protection Status Register
func (o *PMC_Type) SetPMC_WPSR_WPVS(value uint32) {
	volatile.StoreUint32(&o.PMC_WPSR.Reg, volatile.LoadUint32(&o.PMC_WPSR.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetPMC_WPSR_WPVS() uint32 {
	return volatile.LoadUint32(&o.PMC_WPSR.Reg) & 0x1
}
func (o *PMC_Type) SetPMC_WPSR_WPVSRC(value uint32) {
	volatile.StoreUint32(&o.PMC_WPSR.Reg, volatile.LoadUint32(&o.PMC_WPSR.Reg)&^(0xffff00)|value<<8)
}
func (o *PMC_Type) GetPMC_WPSR_WPVSRC() uint32 {
	return (volatile.LoadUint32(&o.PMC_WPSR.Reg) & 0xffff00) >> 8
}

// PMC.PMC_PCER1: Peripheral Clock Enable Register 1
func (o *PMC_Type) SetPMC_PCER1_PID32(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER1.Reg, volatile.LoadUint32(&o.PMC_PCER1.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetPMC_PCER1_PID32() uint32 {
	return volatile.LoadUint32(&o.PMC_PCER1.Reg) & 0x1
}
func (o *PMC_Type) SetPMC_PCER1_PID33(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER1.Reg, volatile.LoadUint32(&o.PMC_PCER1.Reg)&^(0x2)|value<<1)
}
func (o *PMC_Type) GetPMC_PCER1_PID33() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER1.Reg) & 0x2) >> 1
}
func (o *PMC_Type) SetPMC_PCER1_PID34(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER1.Reg, volatile.LoadUint32(&o.PMC_PCER1.Reg)&^(0x4)|value<<2)
}
func (o *PMC_Type) GetPMC_PCER1_PID34() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER1.Reg) & 0x4) >> 2
}

// PMC.PMC_PCDR1: Peripheral Clock Disable Register 1
func (o *PMC_Type) SetPMC_PCDR1_PID32(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR1.Reg, volatile.LoadUint32(&o.PMC_PCDR1.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetPMC_PCDR1_PID32() uint32 {
	return volatile.LoadUint32(&o.PMC_PCDR1.Reg) & 0x1
}
func (o *PMC_Type) SetPMC_PCDR1_PID33(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR1.Reg, volatile.LoadUint32(&o.PMC_PCDR1.Reg)&^(0x2)|value<<1)
}
func (o *PMC_Type) GetPMC_PCDR1_PID33() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR1.Reg) & 0x2) >> 1
}
func (o *PMC_Type) SetPMC_PCDR1_PID34(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR1.Reg, volatile.LoadUint32(&o.PMC_PCDR1.Reg)&^(0x4)|value<<2)
}
func (o *PMC_Type) GetPMC_PCDR1_PID34() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR1.Reg) & 0x4) >> 2
}

// PMC.PMC_PCSR1: Peripheral Clock Status Register 1
func (o *PMC_Type) SetPMC_PCSR1_PID32(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR1.Reg, volatile.LoadUint32(&o.PMC_PCSR1.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetPMC_PCSR1_PID32() uint32 {
	return volatile.LoadUint32(&o.PMC_PCSR1.Reg) & 0x1
}
func (o *PMC_Type) SetPMC_PCSR1_PID33(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR1.Reg, volatile.LoadUint32(&o.PMC_PCSR1.Reg)&^(0x2)|value<<1)
}
func (o *PMC_Type) GetPMC_PCSR1_PID33() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR1.Reg) & 0x2) >> 1
}
func (o *PMC_Type) SetPMC_PCSR1_PID34(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR1.Reg, volatile.LoadUint32(&o.PMC_PCSR1.Reg)&^(0x4)|value<<2)
}
func (o *PMC_Type) GetPMC_PCSR1_PID34() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR1.Reg) & 0x4) >> 2
}

// PMC.PMC_OCR: Oscillator Calibration Register
func (o *PMC_Type) SetPMC_OCR_CAL4(value uint32) {
	volatile.StoreUint32(&o.PMC_OCR.Reg, volatile.LoadUint32(&o.PMC_OCR.Reg)&^(0x7f)|value)
}
func (o *PMC_Type) GetPMC_OCR_CAL4() uint32 {
	return volatile.LoadUint32(&o.PMC_OCR.Reg) & 0x7f
}
func (o *PMC_Type) SetPMC_OCR_SEL4(value uint32) {
	volatile.StoreUint32(&o.PMC_OCR.Reg, volatile.LoadUint32(&o.PMC_OCR.Reg)&^(0x80)|value<<7)
}
func (o *PMC_Type) GetPMC_OCR_SEL4() uint32 {
	return (volatile.LoadUint32(&o.PMC_OCR.Reg) & 0x80) >> 7
}
func (o *PMC_Type) SetPMC_OCR_CAL8(value uint32) {
	volatile.StoreUint32(&o.PMC_OCR.Reg, volatile.LoadUint32(&o.PMC_OCR.Reg)&^(0x7f00)|value<<8)
}
func (o *PMC_Type) GetPMC_OCR_CAL8() uint32 {
	return (volatile.LoadUint32(&o.PMC_OCR.Reg) & 0x7f00) >> 8
}
func (o *PMC_Type) SetPMC_OCR_SEL8(value uint32) {
	volatile.StoreUint32(&o.PMC_OCR.Reg, volatile.LoadUint32(&o.PMC_OCR.Reg)&^(0x8000)|value<<15)
}
func (o *PMC_Type) GetPMC_OCR_SEL8() uint32 {
	return (volatile.LoadUint32(&o.PMC_OCR.Reg) & 0x8000) >> 15
}
func (o *PMC_Type) SetPMC_OCR_CAL12(value uint32) {
	volatile.StoreUint32(&o.PMC_OCR.Reg, volatile.LoadUint32(&o.PMC_OCR.Reg)&^(0x7f0000)|value<<16)
}
func (o *PMC_Type) GetPMC_OCR_CAL12() uint32 {
	return (volatile.LoadUint32(&o.PMC_OCR.Reg) & 0x7f0000) >> 16
}
func (o *PMC_Type) SetPMC_OCR_SEL12(value uint32) {
	volatile.StoreUint32(&o.PMC_OCR.Reg, volatile.LoadUint32(&o.PMC_OCR.Reg)&^(0x800000)|value<<23)
}
func (o *PMC_Type) GetPMC_OCR_SEL12() uint32 {
	return (volatile.LoadUint32(&o.PMC_OCR.Reg) & 0x800000) >> 23
}

// Universal Asynchronous Receiver Transmitter 0
type UART_Type struct {
	CR   volatile.Register32 // 0x0
	MR   volatile.Register32 // 0x4
	IER  volatile.Register32 // 0x8
	IDR  volatile.Register32 // 0xC
	IMR  volatile.Register32 // 0x10
	SR   volatile.Register32 // 0x14
	RHR  volatile.Register32 // 0x18
	THR  volatile.Register32 // 0x1C
	BRGR volatile.Register32 // 0x20
	_    [220]byte
	RPR  volatile.Register32 // 0x100
	RCR  volatile.Register32 // 0x104
	TPR  volatile.Register32 // 0x108
	TCR  volatile.Register32 // 0x10C
	RNPR volatile.Register32 // 0x110
	RNCR volatile.Register32 // 0x114
	TNPR volatile.Register32 // 0x118
	TNCR volatile.Register32 // 0x11C
	PTCR volatile.Register32 // 0x120
	PTSR volatile.Register32 // 0x124
}

// UART.CR: Control Register
func (o *UART_Type) SetCR_RSTRX(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *UART_Type) GetCR_RSTRX() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *UART_Type) SetCR_RSTTX(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *UART_Type) GetCR_RSTTX() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *UART_Type) SetCR_RXEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *UART_Type) GetCR_RXEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *UART_Type) SetCR_RXDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20)|value<<5)
}
func (o *UART_Type) GetCR_RXDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20) >> 5
}
func (o *UART_Type) SetCR_TXEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40)|value<<6)
}
func (o *UART_Type) GetCR_TXEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40) >> 6
}
func (o *UART_Type) SetCR_TXDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *UART_Type) GetCR_TXDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *UART_Type) SetCR_RSTSTA(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100)|value<<8)
}
func (o *UART_Type) GetCR_RSTSTA() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100) >> 8
}

// UART.MR: Mode Register
func (o *UART_Type) SetMR_PAR(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xe00)|value<<9)
}
func (o *UART_Type) GetMR_PAR() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xe00) >> 9
}
func (o *UART_Type) SetMR_CHMODE(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xc000)|value<<14)
}
func (o *UART_Type) GetMR_CHMODE() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xc000) >> 14
}

// UART.IER: Interrupt Enable Register
func (o *UART_Type) SetIER_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *UART_Type) GetIER_RXRDY() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *UART_Type) SetIER_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *UART_Type) GetIER_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *UART_Type) SetIER_ENDRX(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *UART_Type) GetIER_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *UART_Type) SetIER_ENDTX(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *UART_Type) GetIER_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *UART_Type) SetIER_OVRE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *UART_Type) GetIER_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *UART_Type) SetIER_FRAME(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40)|value<<6)
}
func (o *UART_Type) GetIER_FRAME() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40) >> 6
}
func (o *UART_Type) SetIER_PARE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80)|value<<7)
}
func (o *UART_Type) GetIER_PARE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80) >> 7
}
func (o *UART_Type) SetIER_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200)|value<<9)
}
func (o *UART_Type) GetIER_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200) >> 9
}
func (o *UART_Type) SetIER_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x800)|value<<11)
}
func (o *UART_Type) GetIER_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x800) >> 11
}
func (o *UART_Type) SetIER_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1000)|value<<12)
}
func (o *UART_Type) GetIER_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x1000) >> 12
}

// UART.IDR: Interrupt Disable Register
func (o *UART_Type) SetIDR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *UART_Type) GetIDR_RXRDY() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *UART_Type) SetIDR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *UART_Type) GetIDR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *UART_Type) SetIDR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8)|value<<3)
}
func (o *UART_Type) GetIDR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8) >> 3
}
func (o *UART_Type) SetIDR_ENDTX(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10)|value<<4)
}
func (o *UART_Type) GetIDR_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10) >> 4
}
func (o *UART_Type) SetIDR_OVRE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20)|value<<5)
}
func (o *UART_Type) GetIDR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20) >> 5
}
func (o *UART_Type) SetIDR_FRAME(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40)|value<<6)
}
func (o *UART_Type) GetIDR_FRAME() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40) >> 6
}
func (o *UART_Type) SetIDR_PARE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80)|value<<7)
}
func (o *UART_Type) GetIDR_PARE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80) >> 7
}
func (o *UART_Type) SetIDR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200)|value<<9)
}
func (o *UART_Type) GetIDR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200) >> 9
}
func (o *UART_Type) SetIDR_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x800)|value<<11)
}
func (o *UART_Type) GetIDR_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x800) >> 11
}
func (o *UART_Type) SetIDR_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1000)|value<<12)
}
func (o *UART_Type) GetIDR_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x1000) >> 12
}

// UART.IMR: Interrupt Mask Register
func (o *UART_Type) SetIMR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *UART_Type) GetIMR_RXRDY() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *UART_Type) SetIMR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *UART_Type) GetIMR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *UART_Type) SetIMR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8)|value<<3)
}
func (o *UART_Type) GetIMR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8) >> 3
}
func (o *UART_Type) SetIMR_ENDTX(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10)|value<<4)
}
func (o *UART_Type) GetIMR_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10) >> 4
}
func (o *UART_Type) SetIMR_OVRE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20)|value<<5)
}
func (o *UART_Type) GetIMR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20) >> 5
}
func (o *UART_Type) SetIMR_FRAME(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40)|value<<6)
}
func (o *UART_Type) GetIMR_FRAME() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40) >> 6
}
func (o *UART_Type) SetIMR_PARE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80)|value<<7)
}
func (o *UART_Type) GetIMR_PARE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80) >> 7
}
func (o *UART_Type) SetIMR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200)|value<<9)
}
func (o *UART_Type) GetIMR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200) >> 9
}
func (o *UART_Type) SetIMR_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x800)|value<<11)
}
func (o *UART_Type) GetIMR_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x800) >> 11
}
func (o *UART_Type) SetIMR_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1000)|value<<12)
}
func (o *UART_Type) GetIMR_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x1000) >> 12
}

// UART.SR: Status Register
func (o *UART_Type) SetSR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *UART_Type) GetSR_RXRDY() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *UART_Type) SetSR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *UART_Type) GetSR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *UART_Type) SetSR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *UART_Type) GetSR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *UART_Type) SetSR_ENDTX(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *UART_Type) GetSR_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *UART_Type) SetSR_OVRE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *UART_Type) GetSR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *UART_Type) SetSR_FRAME(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *UART_Type) GetSR_FRAME() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *UART_Type) SetSR_PARE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80)|value<<7)
}
func (o *UART_Type) GetSR_PARE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80) >> 7
}
func (o *UART_Type) SetSR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x200)|value<<9)
}
func (o *UART_Type) GetSR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x200) >> 9
}
func (o *UART_Type) SetSR_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x800)|value<<11)
}
func (o *UART_Type) GetSR_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x800) >> 11
}
func (o *UART_Type) SetSR_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1000)|value<<12)
}
func (o *UART_Type) GetSR_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x1000) >> 12
}

// UART.RHR: Receive Holding Register
func (o *UART_Type) SetRHR_RXCHR(value uint32) {
	volatile.StoreUint32(&o.RHR.Reg, volatile.LoadUint32(&o.RHR.Reg)&^(0xff)|value)
}
func (o *UART_Type) GetRHR_RXCHR() uint32 {
	return volatile.LoadUint32(&o.RHR.Reg) & 0xff
}

// UART.THR: Transmit Holding Register
func (o *UART_Type) SetTHR_TXCHR(value uint32) {
	volatile.StoreUint32(&o.THR.Reg, volatile.LoadUint32(&o.THR.Reg)&^(0xff)|value)
}
func (o *UART_Type) GetTHR_TXCHR() uint32 {
	return volatile.LoadUint32(&o.THR.Reg) & 0xff
}

// UART.BRGR: Baud Rate Generator Register
func (o *UART_Type) SetBRGR_CD(value uint32) {
	volatile.StoreUint32(&o.BRGR.Reg, volatile.LoadUint32(&o.BRGR.Reg)&^(0xffff)|value)
}
func (o *UART_Type) GetBRGR_CD() uint32 {
	return volatile.LoadUint32(&o.BRGR.Reg) & 0xffff
}

// UART.RPR: Receive Pointer Register
func (o *UART_Type) SetRPR(value uint32) {
	volatile.StoreUint32(&o.RPR.Reg, value)
}
func (o *UART_Type) GetRPR() uint32 {
	return volatile.LoadUint32(&o.RPR.Reg)
}

// UART.RCR: Receive Counter Register
func (o *UART_Type) SetRCR_RXCTR(value uint32) {
	volatile.StoreUint32(&o.RCR.Reg, volatile.LoadUint32(&o.RCR.Reg)&^(0xffff)|value)
}
func (o *UART_Type) GetRCR_RXCTR() uint32 {
	return volatile.LoadUint32(&o.RCR.Reg) & 0xffff
}

// UART.TPR: Transmit Pointer Register
func (o *UART_Type) SetTPR(value uint32) {
	volatile.StoreUint32(&o.TPR.Reg, value)
}
func (o *UART_Type) GetTPR() uint32 {
	return volatile.LoadUint32(&o.TPR.Reg)
}

// UART.TCR: Transmit Counter Register
func (o *UART_Type) SetTCR_TXCTR(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0xffff)|value)
}
func (o *UART_Type) GetTCR_TXCTR() uint32 {
	return volatile.LoadUint32(&o.TCR.Reg) & 0xffff
}

// UART.RNPR: Receive Next Pointer Register
func (o *UART_Type) SetRNPR(value uint32) {
	volatile.StoreUint32(&o.RNPR.Reg, value)
}
func (o *UART_Type) GetRNPR() uint32 {
	return volatile.LoadUint32(&o.RNPR.Reg)
}

// UART.RNCR: Receive Next Counter Register
func (o *UART_Type) SetRNCR_RXNCTR(value uint32) {
	volatile.StoreUint32(&o.RNCR.Reg, volatile.LoadUint32(&o.RNCR.Reg)&^(0xffff)|value)
}
func (o *UART_Type) GetRNCR_RXNCTR() uint32 {
	return volatile.LoadUint32(&o.RNCR.Reg) & 0xffff
}

// UART.TNPR: Transmit Next Pointer Register
func (o *UART_Type) SetTNPR(value uint32) {
	volatile.StoreUint32(&o.TNPR.Reg, value)
}
func (o *UART_Type) GetTNPR() uint32 {
	return volatile.LoadUint32(&o.TNPR.Reg)
}

// UART.TNCR: Transmit Next Counter Register
func (o *UART_Type) SetTNCR_TXNCTR(value uint32) {
	volatile.StoreUint32(&o.TNCR.Reg, volatile.LoadUint32(&o.TNCR.Reg)&^(0xffff)|value)
}
func (o *UART_Type) GetTNCR_TXNCTR() uint32 {
	return volatile.LoadUint32(&o.TNCR.Reg) & 0xffff
}

// UART.PTCR: Transfer Control Register
func (o *UART_Type) SetPTCR_RXTEN(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x1)|value)
}
func (o *UART_Type) GetPTCR_RXTEN() uint32 {
	return volatile.LoadUint32(&o.PTCR.Reg) & 0x1
}
func (o *UART_Type) SetPTCR_RXTDIS(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x2)|value<<1)
}
func (o *UART_Type) GetPTCR_RXTDIS() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x2) >> 1
}
func (o *UART_Type) SetPTCR_TXTEN(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x100)|value<<8)
}
func (o *UART_Type) GetPTCR_TXTEN() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x100) >> 8
}
func (o *UART_Type) SetPTCR_TXTDIS(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x200)|value<<9)
}
func (o *UART_Type) GetPTCR_TXTDIS() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x200) >> 9
}

// UART.PTSR: Transfer Status Register
func (o *UART_Type) SetPTSR_RXTEN(value uint32) {
	volatile.StoreUint32(&o.PTSR.Reg, volatile.LoadUint32(&o.PTSR.Reg)&^(0x1)|value)
}
func (o *UART_Type) GetPTSR_RXTEN() uint32 {
	return volatile.LoadUint32(&o.PTSR.Reg) & 0x1
}
func (o *UART_Type) SetPTSR_TXTEN(value uint32) {
	volatile.StoreUint32(&o.PTSR.Reg, volatile.LoadUint32(&o.PTSR.Reg)&^(0x100)|value<<8)
}
func (o *UART_Type) GetPTSR_TXTEN() uint32 {
	return (volatile.LoadUint32(&o.PTSR.Reg) & 0x100) >> 8
}

// Chip Identifier
type CHIPID_Type struct {
	CIDR volatile.Register32 // 0x0
	EXID volatile.Register32 // 0x4
}

// CHIPID.CIDR: Chip ID Register
func (o *CHIPID_Type) SetCIDR_VERSION(value uint32) {
	volatile.StoreUint32(&o.CIDR.Reg, volatile.LoadUint32(&o.CIDR.Reg)&^(0x1f)|value)
}
func (o *CHIPID_Type) GetCIDR_VERSION() uint32 {
	return volatile.LoadUint32(&o.CIDR.Reg) & 0x1f
}
func (o *CHIPID_Type) SetCIDR_EPROC(value uint32) {
	volatile.StoreUint32(&o.CIDR.Reg, volatile.LoadUint32(&o.CIDR.Reg)&^(0xe0)|value<<5)
}
func (o *CHIPID_Type) GetCIDR_EPROC() uint32 {
	return (volatile.LoadUint32(&o.CIDR.Reg) & 0xe0) >> 5
}
func (o *CHIPID_Type) SetCIDR_NVPSIZ(value uint32) {
	volatile.StoreUint32(&o.CIDR.Reg, volatile.LoadUint32(&o.CIDR.Reg)&^(0xf00)|value<<8)
}
func (o *CHIPID_Type) GetCIDR_NVPSIZ() uint32 {
	return (volatile.LoadUint32(&o.CIDR.Reg) & 0xf00) >> 8
}
func (o *CHIPID_Type) SetCIDR_NVPSIZ2(value uint32) {
	volatile.StoreUint32(&o.CIDR.Reg, volatile.LoadUint32(&o.CIDR.Reg)&^(0xf000)|value<<12)
}
func (o *CHIPID_Type) GetCIDR_NVPSIZ2() uint32 {
	return (volatile.LoadUint32(&o.CIDR.Reg) & 0xf000) >> 12
}
func (o *CHIPID_Type) SetCIDR_SRAMSIZ(value uint32) {
	volatile.StoreUint32(&o.CIDR.Reg, volatile.LoadUint32(&o.CIDR.Reg)&^(0xf0000)|value<<16)
}
func (o *CHIPID_Type) GetCIDR_SRAMSIZ() uint32 {
	return (volatile.LoadUint32(&o.CIDR.Reg) & 0xf0000) >> 16
}
func (o *CHIPID_Type) SetCIDR_ARCH(value uint32) {
	volatile.StoreUint32(&o.CIDR.Reg, volatile.LoadUint32(&o.CIDR.Reg)&^(0xff00000)|value<<20)
}
func (o *CHIPID_Type) GetCIDR_ARCH() uint32 {
	return (volatile.LoadUint32(&o.CIDR.Reg) & 0xff00000) >> 20
}
func (o *CHIPID_Type) SetCIDR_NVPTYP(value uint32) {
	volatile.StoreUint32(&o.CIDR.Reg, volatile.LoadUint32(&o.CIDR.Reg)&^(0x70000000)|value<<28)
}
func (o *CHIPID_Type) GetCIDR_NVPTYP() uint32 {
	return (volatile.LoadUint32(&o.CIDR.Reg) & 0x70000000) >> 28
}
func (o *CHIPID_Type) SetCIDR_EXT(value uint32) {
	volatile.StoreUint32(&o.CIDR.Reg, volatile.LoadUint32(&o.CIDR.Reg)&^(0x80000000)|value<<31)
}
func (o *CHIPID_Type) GetCIDR_EXT() uint32 {
	return (volatile.LoadUint32(&o.CIDR.Reg) & 0x80000000) >> 31
}

// CHIPID.EXID: Chip ID Extension Register
func (o *CHIPID_Type) SetEXID(value uint32) {
	volatile.StoreUint32(&o.EXID.Reg, value)
}
func (o *CHIPID_Type) GetEXID() uint32 {
	return volatile.LoadUint32(&o.EXID.Reg)
}

// Embedded Flash Controller 0
type EFC_Type struct {
	FMR volatile.Register32 // 0x0
	FCR volatile.Register32 // 0x4
	FSR volatile.Register32 // 0x8
	FRR volatile.Register32 // 0xC
}

// EFC.FMR: EEFC Flash Mode Register
func (o *EFC_Type) SetFMR_FRDY(value uint32) {
	volatile.StoreUint32(&o.FMR.Reg, volatile.LoadUint32(&o.FMR.Reg)&^(0x1)|value)
}
func (o *EFC_Type) GetFMR_FRDY() uint32 {
	return volatile.LoadUint32(&o.FMR.Reg) & 0x1
}
func (o *EFC_Type) SetFMR_FWS(value uint32) {
	volatile.StoreUint32(&o.FMR.Reg, volatile.LoadUint32(&o.FMR.Reg)&^(0xf00)|value<<8)
}
func (o *EFC_Type) GetFMR_FWS() uint32 {
	return (volatile.LoadUint32(&o.FMR.Reg) & 0xf00) >> 8
}
func (o *EFC_Type) SetFMR_SCOD(value uint32) {
	volatile.StoreUint32(&o.FMR.Reg, volatile.LoadUint32(&o.FMR.Reg)&^(0x10000)|value<<16)
}
func (o *EFC_Type) GetFMR_SCOD() uint32 {
	return (volatile.LoadUint32(&o.FMR.Reg) & 0x10000) >> 16
}
func (o *EFC_Type) SetFMR_FAM(value uint32) {
	volatile.StoreUint32(&o.FMR.Reg, volatile.LoadUint32(&o.FMR.Reg)&^(0x1000000)|value<<24)
}
func (o *EFC_Type) GetFMR_FAM() uint32 {
	return (volatile.LoadUint32(&o.FMR.Reg) & 0x1000000) >> 24
}
func (o *EFC_Type) SetFMR_CLOE(value uint32) {
	volatile.StoreUint32(&o.FMR.Reg, volatile.LoadUint32(&o.FMR.Reg)&^(0x4000000)|value<<26)
}
func (o *EFC_Type) GetFMR_CLOE() uint32 {
	return (volatile.LoadUint32(&o.FMR.Reg) & 0x4000000) >> 26
}

// EFC.FCR: EEFC Flash Command Register
func (o *EFC_Type) SetFCR_FCMD(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0xff)|value)
}
func (o *EFC_Type) GetFCR_FCMD() uint32 {
	return volatile.LoadUint32(&o.FCR.Reg) & 0xff
}
func (o *EFC_Type) SetFCR_FARG(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0xffff00)|value<<8)
}
func (o *EFC_Type) GetFCR_FARG() uint32 {
	return (volatile.LoadUint32(&o.FCR.Reg) & 0xffff00) >> 8
}
func (o *EFC_Type) SetFCR_FKEY(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0xff000000)|value<<24)
}
func (o *EFC_Type) GetFCR_FKEY() uint32 {
	return (volatile.LoadUint32(&o.FCR.Reg) & 0xff000000) >> 24
}

// EFC.FSR: EEFC Flash Status Register
func (o *EFC_Type) SetFSR_FRDY(value uint32) {
	volatile.StoreUint32(&o.FSR.Reg, volatile.LoadUint32(&o.FSR.Reg)&^(0x1)|value)
}
func (o *EFC_Type) GetFSR_FRDY() uint32 {
	return volatile.LoadUint32(&o.FSR.Reg) & 0x1
}
func (o *EFC_Type) SetFSR_FCMDE(value uint32) {
	volatile.StoreUint32(&o.FSR.Reg, volatile.LoadUint32(&o.FSR.Reg)&^(0x2)|value<<1)
}
func (o *EFC_Type) GetFSR_FCMDE() uint32 {
	return (volatile.LoadUint32(&o.FSR.Reg) & 0x2) >> 1
}
func (o *EFC_Type) SetFSR_FLOCKE(value uint32) {
	volatile.StoreUint32(&o.FSR.Reg, volatile.LoadUint32(&o.FSR.Reg)&^(0x4)|value<<2)
}
func (o *EFC_Type) GetFSR_FLOCKE() uint32 {
	return (volatile.LoadUint32(&o.FSR.Reg) & 0x4) >> 2
}
func (o *EFC_Type) SetFSR_FLERR(value uint32) {
	volatile.StoreUint32(&o.FSR.Reg, volatile.LoadUint32(&o.FSR.Reg)&^(0x8)|value<<3)
}
func (o *EFC_Type) GetFSR_FLERR() uint32 {
	return (volatile.LoadUint32(&o.FSR.Reg) & 0x8) >> 3
}

// EFC.FRR: EEFC Flash Result Register
func (o *EFC_Type) SetFRR(value uint32) {
	volatile.StoreUint32(&o.FRR.Reg, value)
}
func (o *EFC_Type) GetFRR() uint32 {
	return volatile.LoadUint32(&o.FRR.Reg)
}

// Parallel Input/Output Controller A
type PIO_Type struct {
	PER     volatile.Register32 // 0x0
	PDR     volatile.Register32 // 0x4
	PSR     volatile.Register32 // 0x8
	_       [4]byte
	OER     volatile.Register32 // 0x10
	ODR     volatile.Register32 // 0x14
	OSR     volatile.Register32 // 0x18
	_       [4]byte
	IFER    volatile.Register32 // 0x20
	IFDR    volatile.Register32 // 0x24
	IFSR    volatile.Register32 // 0x28
	_       [4]byte
	SODR    volatile.Register32 // 0x30
	CODR    volatile.Register32 // 0x34
	ODSR    volatile.Register32 // 0x38
	PDSR    volatile.Register32 // 0x3C
	IER     volatile.Register32 // 0x40
	IDR     volatile.Register32 // 0x44
	IMR     volatile.Register32 // 0x48
	ISR     volatile.Register32 // 0x4C
	MDER    volatile.Register32 // 0x50
	MDDR    volatile.Register32 // 0x54
	MDSR    volatile.Register32 // 0x58
	_       [4]byte
	PUDR    volatile.Register32 // 0x60
	PUER    volatile.Register32 // 0x64
	PUSR    volatile.Register32 // 0x68
	_       [4]byte
	ABCDSR  [2]volatile.Register32 // 0x70
	_       [8]byte
	IFSCDR  volatile.Register32 // 0x80
	IFSCER  volatile.Register32 // 0x84
	IFSCSR  volatile.Register32 // 0x88
	SCDR    volatile.Register32 // 0x8C
	PPDDR   volatile.Register32 // 0x90
	PPDER   volatile.Register32 // 0x94
	PPDSR   volatile.Register32 // 0x98
	_       [4]byte
	OWER    volatile.Register32 // 0xA0
	OWDR    volatile.Register32 // 0xA4
	OWSR    volatile.Register32 // 0xA8
	_       [4]byte
	AIMER   volatile.Register32 // 0xB0
	AIMDR   volatile.Register32 // 0xB4
	AIMMR   volatile.Register32 // 0xB8
	_       [4]byte
	ESR     volatile.Register32 // 0xC0
	LSR     volatile.Register32 // 0xC4
	ELSR    volatile.Register32 // 0xC8
	_       [4]byte
	FELLSR  volatile.Register32 // 0xD0
	REHLSR  volatile.Register32 // 0xD4
	FRLHSR  volatile.Register32 // 0xD8
	_       [4]byte
	LOCKSR  volatile.Register32 // 0xE0
	WPMR    volatile.Register32 // 0xE4
	WPSR    volatile.Register32 // 0xE8
	_       [20]byte
	SCHMITT volatile.Register32 // 0x100
	_       [76]byte
	PCMR    volatile.Register32 // 0x150
	PCIER   volatile.Register32 // 0x154
	PCIDR   volatile.Register32 // 0x158
	PCIMR   volatile.Register32 // 0x15C
	PCISR   volatile.Register32 // 0x160
	PCRHR   volatile.Register32 // 0x164
	RPR     volatile.Register32 // 0x168
	RCR     volatile.Register32 // 0x16C
	_       [8]byte
	RNPR    volatile.Register32 // 0x178
	RNCR    volatile.Register32 // 0x17C
	_       [8]byte
	PTCR    volatile.Register32 // 0x188
	PTSR    volatile.Register32 // 0x18C
}

// PIO.PER: PIO Enable Register
func (o *PIO_Type) SetPER_P0(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPER_P0() uint32 {
	return volatile.LoadUint32(&o.PER.Reg) & 0x1
}
func (o *PIO_Type) SetPER_P1(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPER_P1() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPER_P2(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPER_P2() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPER_P3(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPER_P3() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPER_P4(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPER_P4() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPER_P5(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPER_P5() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPER_P6(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPER_P6() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPER_P7(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPER_P7() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPER_P8(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPER_P8() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPER_P9(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPER_P9() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPER_P10(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPER_P10() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPER_P11(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPER_P11() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPER_P12(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPER_P12() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPER_P13(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPER_P13() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPER_P14(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPER_P14() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPER_P15(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPER_P15() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPER_P16(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPER_P16() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPER_P17(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPER_P17() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPER_P18(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPER_P18() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPER_P19(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPER_P19() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPER_P20(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPER_P20() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPER_P21(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPER_P21() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPER_P22(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPER_P22() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPER_P23(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPER_P23() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPER_P24(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPER_P24() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPER_P25(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPER_P25() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPER_P26(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPER_P26() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPER_P27(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPER_P27() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPER_P28(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPER_P28() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPER_P29(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPER_P29() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPER_P30(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPER_P30() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPER_P31(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPER_P31() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x80000000) >> 31
}

// PIO.PDR: PIO Disable Register
func (o *PIO_Type) SetPDR_P0(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPDR_P0() uint32 {
	return volatile.LoadUint32(&o.PDR.Reg) & 0x1
}
func (o *PIO_Type) SetPDR_P1(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPDR_P1() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPDR_P2(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPDR_P2() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPDR_P3(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPDR_P3() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPDR_P4(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPDR_P4() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPDR_P5(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPDR_P5() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPDR_P6(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPDR_P6() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPDR_P7(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPDR_P7() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPDR_P8(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPDR_P8() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPDR_P9(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPDR_P9() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPDR_P10(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPDR_P10() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPDR_P11(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPDR_P11() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPDR_P12(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPDR_P12() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPDR_P13(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPDR_P13() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPDR_P14(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPDR_P14() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPDR_P15(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPDR_P15() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPDR_P16(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPDR_P16() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPDR_P17(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPDR_P17() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPDR_P18(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPDR_P18() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPDR_P19(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPDR_P19() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPDR_P20(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPDR_P20() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPDR_P21(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPDR_P21() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPDR_P22(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPDR_P22() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPDR_P23(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPDR_P23() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPDR_P24(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPDR_P24() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPDR_P25(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPDR_P25() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPDR_P26(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPDR_P26() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPDR_P27(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPDR_P27() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPDR_P28(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPDR_P28() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPDR_P29(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPDR_P29() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPDR_P30(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPDR_P30() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPDR_P31(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPDR_P31() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x80000000) >> 31
}

// PIO.PSR: PIO Status Register
func (o *PIO_Type) SetPSR_P0(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPSR_P0() uint32 {
	return volatile.LoadUint32(&o.PSR.Reg) & 0x1
}
func (o *PIO_Type) SetPSR_P1(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPSR_P1() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPSR_P2(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPSR_P2() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPSR_P3(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPSR_P3() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPSR_P4(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPSR_P4() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPSR_P5(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPSR_P5() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPSR_P6(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPSR_P6() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPSR_P7(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPSR_P7() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPSR_P8(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPSR_P8() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPSR_P9(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPSR_P9() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPSR_P10(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPSR_P10() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPSR_P11(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPSR_P11() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPSR_P12(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPSR_P12() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPSR_P13(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPSR_P13() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPSR_P14(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPSR_P14() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPSR_P15(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPSR_P15() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPSR_P16(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPSR_P16() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPSR_P17(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPSR_P17() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPSR_P18(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPSR_P18() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPSR_P19(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPSR_P19() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPSR_P20(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPSR_P20() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPSR_P21(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPSR_P21() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPSR_P22(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPSR_P22() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPSR_P23(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPSR_P23() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPSR_P24(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPSR_P24() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPSR_P25(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPSR_P25() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPSR_P26(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPSR_P26() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPSR_P27(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPSR_P27() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPSR_P28(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPSR_P28() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPSR_P29(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPSR_P29() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPSR_P30(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPSR_P30() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPSR_P31(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPSR_P31() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x80000000) >> 31
}

// PIO.OER: Output Enable Register
func (o *PIO_Type) SetOER_P0(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetOER_P0() uint32 {
	return volatile.LoadUint32(&o.OER.Reg) & 0x1
}
func (o *PIO_Type) SetOER_P1(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetOER_P1() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetOER_P2(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetOER_P2() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetOER_P3(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetOER_P3() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetOER_P4(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetOER_P4() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetOER_P5(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetOER_P5() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetOER_P6(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetOER_P6() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetOER_P7(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetOER_P7() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetOER_P8(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetOER_P8() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetOER_P9(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetOER_P9() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetOER_P10(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetOER_P10() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetOER_P11(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetOER_P11() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetOER_P12(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetOER_P12() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetOER_P13(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetOER_P13() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetOER_P14(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetOER_P14() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetOER_P15(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetOER_P15() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetOER_P16(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetOER_P16() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetOER_P17(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetOER_P17() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetOER_P18(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetOER_P18() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetOER_P19(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetOER_P19() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetOER_P20(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetOER_P20() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetOER_P21(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetOER_P21() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetOER_P22(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetOER_P22() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetOER_P23(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetOER_P23() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetOER_P24(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetOER_P24() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetOER_P25(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetOER_P25() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetOER_P26(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetOER_P26() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetOER_P27(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetOER_P27() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetOER_P28(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetOER_P28() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetOER_P29(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetOER_P29() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetOER_P30(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetOER_P30() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetOER_P31(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetOER_P31() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x80000000) >> 31
}

// PIO.ODR: Output Disable Register
func (o *PIO_Type) SetODR_P0(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetODR_P0() uint32 {
	return volatile.LoadUint32(&o.ODR.Reg) & 0x1
}
func (o *PIO_Type) SetODR_P1(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetODR_P1() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetODR_P2(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetODR_P2() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetODR_P3(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetODR_P3() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetODR_P4(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetODR_P4() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetODR_P5(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetODR_P5() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetODR_P6(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetODR_P6() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetODR_P7(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetODR_P7() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetODR_P8(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetODR_P8() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetODR_P9(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetODR_P9() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetODR_P10(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetODR_P10() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetODR_P11(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetODR_P11() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetODR_P12(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetODR_P12() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetODR_P13(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetODR_P13() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetODR_P14(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetODR_P14() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetODR_P15(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetODR_P15() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetODR_P16(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetODR_P16() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetODR_P17(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetODR_P17() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetODR_P18(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetODR_P18() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetODR_P19(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetODR_P19() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetODR_P20(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetODR_P20() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetODR_P21(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetODR_P21() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetODR_P22(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetODR_P22() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetODR_P23(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetODR_P23() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetODR_P24(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetODR_P24() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetODR_P25(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetODR_P25() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetODR_P26(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetODR_P26() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetODR_P27(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetODR_P27() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetODR_P28(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetODR_P28() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetODR_P29(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetODR_P29() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetODR_P30(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetODR_P30() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetODR_P31(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetODR_P31() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x80000000) >> 31
}

// PIO.OSR: Output Status Register
func (o *PIO_Type) SetOSR_P0(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetOSR_P0() uint32 {
	return volatile.LoadUint32(&o.OSR.Reg) & 0x1
}
func (o *PIO_Type) SetOSR_P1(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetOSR_P1() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetOSR_P2(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetOSR_P2() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetOSR_P3(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetOSR_P3() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetOSR_P4(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetOSR_P4() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetOSR_P5(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetOSR_P5() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetOSR_P6(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetOSR_P6() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetOSR_P7(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetOSR_P7() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetOSR_P8(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetOSR_P8() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetOSR_P9(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetOSR_P9() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetOSR_P10(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetOSR_P10() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetOSR_P11(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetOSR_P11() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetOSR_P12(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetOSR_P12() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetOSR_P13(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetOSR_P13() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetOSR_P14(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetOSR_P14() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetOSR_P15(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetOSR_P15() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetOSR_P16(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetOSR_P16() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetOSR_P17(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetOSR_P17() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetOSR_P18(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetOSR_P18() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetOSR_P19(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetOSR_P19() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetOSR_P20(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetOSR_P20() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetOSR_P21(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetOSR_P21() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetOSR_P22(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetOSR_P22() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetOSR_P23(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetOSR_P23() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetOSR_P24(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetOSR_P24() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetOSR_P25(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetOSR_P25() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetOSR_P26(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetOSR_P26() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetOSR_P27(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetOSR_P27() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetOSR_P28(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetOSR_P28() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetOSR_P29(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetOSR_P29() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetOSR_P30(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetOSR_P30() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetOSR_P31(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetOSR_P31() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x80000000) >> 31
}

// PIO.IFER: Glitch Input Filter Enable Register
func (o *PIO_Type) SetIFER_P0(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetIFER_P0() uint32 {
	return volatile.LoadUint32(&o.IFER.Reg) & 0x1
}
func (o *PIO_Type) SetIFER_P1(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetIFER_P1() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetIFER_P2(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetIFER_P2() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetIFER_P3(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetIFER_P3() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetIFER_P4(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetIFER_P4() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetIFER_P5(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetIFER_P5() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetIFER_P6(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetIFER_P6() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetIFER_P7(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetIFER_P7() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetIFER_P8(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetIFER_P8() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetIFER_P9(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetIFER_P9() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetIFER_P10(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetIFER_P10() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetIFER_P11(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetIFER_P11() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetIFER_P12(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetIFER_P12() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetIFER_P13(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetIFER_P13() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetIFER_P14(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetIFER_P14() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetIFER_P15(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetIFER_P15() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetIFER_P16(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetIFER_P16() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetIFER_P17(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetIFER_P17() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetIFER_P18(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetIFER_P18() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetIFER_P19(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetIFER_P19() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetIFER_P20(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetIFER_P20() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetIFER_P21(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetIFER_P21() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetIFER_P22(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetIFER_P22() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetIFER_P23(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetIFER_P23() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetIFER_P24(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetIFER_P24() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetIFER_P25(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetIFER_P25() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetIFER_P26(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetIFER_P26() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetIFER_P27(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetIFER_P27() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetIFER_P28(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetIFER_P28() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetIFER_P29(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetIFER_P29() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetIFER_P30(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetIFER_P30() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetIFER_P31(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetIFER_P31() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x80000000) >> 31
}

// PIO.IFDR: Glitch Input Filter Disable Register
func (o *PIO_Type) SetIFDR_P0(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetIFDR_P0() uint32 {
	return volatile.LoadUint32(&o.IFDR.Reg) & 0x1
}
func (o *PIO_Type) SetIFDR_P1(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetIFDR_P1() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetIFDR_P2(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetIFDR_P2() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetIFDR_P3(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetIFDR_P3() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetIFDR_P4(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetIFDR_P4() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetIFDR_P5(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetIFDR_P5() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetIFDR_P6(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetIFDR_P6() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetIFDR_P7(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetIFDR_P7() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetIFDR_P8(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetIFDR_P8() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetIFDR_P9(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetIFDR_P9() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetIFDR_P10(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetIFDR_P10() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetIFDR_P11(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetIFDR_P11() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetIFDR_P12(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetIFDR_P12() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetIFDR_P13(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetIFDR_P13() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetIFDR_P14(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetIFDR_P14() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetIFDR_P15(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetIFDR_P15() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetIFDR_P16(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetIFDR_P16() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetIFDR_P17(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetIFDR_P17() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetIFDR_P18(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetIFDR_P18() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetIFDR_P19(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetIFDR_P19() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetIFDR_P20(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetIFDR_P20() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetIFDR_P21(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetIFDR_P21() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetIFDR_P22(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetIFDR_P22() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetIFDR_P23(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetIFDR_P23() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetIFDR_P24(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetIFDR_P24() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetIFDR_P25(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetIFDR_P25() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetIFDR_P26(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetIFDR_P26() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetIFDR_P27(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetIFDR_P27() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetIFDR_P28(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetIFDR_P28() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetIFDR_P29(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetIFDR_P29() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetIFDR_P30(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetIFDR_P30() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetIFDR_P31(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetIFDR_P31() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x80000000) >> 31
}

// PIO.IFSR: Glitch Input Filter Status Register
func (o *PIO_Type) SetIFSR_P0(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetIFSR_P0() uint32 {
	return volatile.LoadUint32(&o.IFSR.Reg) & 0x1
}
func (o *PIO_Type) SetIFSR_P1(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetIFSR_P1() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetIFSR_P2(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetIFSR_P2() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetIFSR_P3(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetIFSR_P3() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetIFSR_P4(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetIFSR_P4() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetIFSR_P5(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetIFSR_P5() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetIFSR_P6(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetIFSR_P6() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetIFSR_P7(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetIFSR_P7() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetIFSR_P8(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetIFSR_P8() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetIFSR_P9(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetIFSR_P9() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetIFSR_P10(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetIFSR_P10() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetIFSR_P11(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetIFSR_P11() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetIFSR_P12(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetIFSR_P12() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetIFSR_P13(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetIFSR_P13() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetIFSR_P14(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetIFSR_P14() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetIFSR_P15(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetIFSR_P15() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetIFSR_P16(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetIFSR_P16() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetIFSR_P17(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetIFSR_P17() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetIFSR_P18(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetIFSR_P18() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetIFSR_P19(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetIFSR_P19() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetIFSR_P20(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetIFSR_P20() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetIFSR_P21(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetIFSR_P21() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetIFSR_P22(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetIFSR_P22() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetIFSR_P23(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetIFSR_P23() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetIFSR_P24(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetIFSR_P24() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetIFSR_P25(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetIFSR_P25() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetIFSR_P26(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetIFSR_P26() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetIFSR_P27(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetIFSR_P27() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetIFSR_P28(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetIFSR_P28() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetIFSR_P29(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetIFSR_P29() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetIFSR_P30(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetIFSR_P30() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetIFSR_P31(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetIFSR_P31() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x80000000) >> 31
}

// PIO.SODR: Set Output Data Register
func (o *PIO_Type) SetSODR_P0(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetSODR_P0() uint32 {
	return volatile.LoadUint32(&o.SODR.Reg) & 0x1
}
func (o *PIO_Type) SetSODR_P1(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetSODR_P1() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetSODR_P2(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetSODR_P2() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetSODR_P3(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetSODR_P3() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetSODR_P4(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetSODR_P4() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetSODR_P5(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetSODR_P5() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetSODR_P6(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetSODR_P6() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetSODR_P7(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetSODR_P7() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetSODR_P8(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetSODR_P8() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetSODR_P9(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetSODR_P9() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetSODR_P10(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetSODR_P10() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetSODR_P11(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetSODR_P11() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetSODR_P12(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetSODR_P12() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetSODR_P13(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetSODR_P13() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetSODR_P14(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetSODR_P14() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetSODR_P15(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetSODR_P15() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetSODR_P16(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetSODR_P16() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetSODR_P17(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetSODR_P17() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetSODR_P18(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetSODR_P18() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetSODR_P19(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetSODR_P19() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetSODR_P20(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetSODR_P20() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetSODR_P21(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetSODR_P21() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetSODR_P22(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetSODR_P22() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetSODR_P23(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetSODR_P23() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetSODR_P24(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetSODR_P24() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetSODR_P25(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetSODR_P25() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetSODR_P26(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetSODR_P26() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetSODR_P27(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetSODR_P27() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetSODR_P28(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetSODR_P28() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetSODR_P29(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetSODR_P29() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetSODR_P30(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetSODR_P30() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetSODR_P31(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetSODR_P31() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x80000000) >> 31
}

// PIO.CODR: Clear Output Data Register
func (o *PIO_Type) SetCODR_P0(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetCODR_P0() uint32 {
	return volatile.LoadUint32(&o.CODR.Reg) & 0x1
}
func (o *PIO_Type) SetCODR_P1(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetCODR_P1() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetCODR_P2(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetCODR_P2() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetCODR_P3(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetCODR_P3() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetCODR_P4(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetCODR_P4() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetCODR_P5(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetCODR_P5() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetCODR_P6(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetCODR_P6() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetCODR_P7(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetCODR_P7() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetCODR_P8(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetCODR_P8() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetCODR_P9(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetCODR_P9() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetCODR_P10(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetCODR_P10() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetCODR_P11(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetCODR_P11() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetCODR_P12(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetCODR_P12() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetCODR_P13(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetCODR_P13() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetCODR_P14(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetCODR_P14() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetCODR_P15(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetCODR_P15() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetCODR_P16(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetCODR_P16() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetCODR_P17(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetCODR_P17() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetCODR_P18(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetCODR_P18() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetCODR_P19(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetCODR_P19() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetCODR_P20(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetCODR_P20() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetCODR_P21(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetCODR_P21() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetCODR_P22(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetCODR_P22() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetCODR_P23(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetCODR_P23() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetCODR_P24(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetCODR_P24() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetCODR_P25(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetCODR_P25() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetCODR_P26(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetCODR_P26() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetCODR_P27(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetCODR_P27() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetCODR_P28(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetCODR_P28() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetCODR_P29(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetCODR_P29() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetCODR_P30(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetCODR_P30() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetCODR_P31(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetCODR_P31() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x80000000) >> 31
}

// PIO.ODSR: Output Data Status Register
func (o *PIO_Type) SetODSR_P0(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetODSR_P0() uint32 {
	return volatile.LoadUint32(&o.ODSR.Reg) & 0x1
}
func (o *PIO_Type) SetODSR_P1(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetODSR_P1() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetODSR_P2(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetODSR_P2() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetODSR_P3(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetODSR_P3() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetODSR_P4(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetODSR_P4() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetODSR_P5(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetODSR_P5() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetODSR_P6(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetODSR_P6() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetODSR_P7(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetODSR_P7() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetODSR_P8(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetODSR_P8() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetODSR_P9(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetODSR_P9() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetODSR_P10(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetODSR_P10() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetODSR_P11(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetODSR_P11() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetODSR_P12(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetODSR_P12() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetODSR_P13(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetODSR_P13() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetODSR_P14(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetODSR_P14() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetODSR_P15(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetODSR_P15() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetODSR_P16(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetODSR_P16() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetODSR_P17(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetODSR_P17() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetODSR_P18(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetODSR_P18() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetODSR_P19(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetODSR_P19() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetODSR_P20(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetODSR_P20() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetODSR_P21(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetODSR_P21() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetODSR_P22(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetODSR_P22() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetODSR_P23(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetODSR_P23() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetODSR_P24(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetODSR_P24() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetODSR_P25(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetODSR_P25() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetODSR_P26(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetODSR_P26() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetODSR_P27(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetODSR_P27() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetODSR_P28(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetODSR_P28() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetODSR_P29(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetODSR_P29() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetODSR_P30(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetODSR_P30() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetODSR_P31(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetODSR_P31() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x80000000) >> 31
}

// PIO.PDSR: Pin Data Status Register
func (o *PIO_Type) SetPDSR_P0(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPDSR_P0() uint32 {
	return volatile.LoadUint32(&o.PDSR.Reg) & 0x1
}
func (o *PIO_Type) SetPDSR_P1(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPDSR_P1() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPDSR_P2(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPDSR_P2() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPDSR_P3(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPDSR_P3() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPDSR_P4(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPDSR_P4() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPDSR_P5(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPDSR_P5() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPDSR_P6(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPDSR_P6() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPDSR_P7(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPDSR_P7() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPDSR_P8(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPDSR_P8() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPDSR_P9(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPDSR_P9() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPDSR_P10(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPDSR_P10() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPDSR_P11(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPDSR_P11() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPDSR_P12(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPDSR_P12() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPDSR_P13(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPDSR_P13() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPDSR_P14(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPDSR_P14() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPDSR_P15(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPDSR_P15() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPDSR_P16(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPDSR_P16() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPDSR_P17(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPDSR_P17() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPDSR_P18(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPDSR_P18() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPDSR_P19(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPDSR_P19() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPDSR_P20(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPDSR_P20() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPDSR_P21(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPDSR_P21() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPDSR_P22(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPDSR_P22() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPDSR_P23(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPDSR_P23() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPDSR_P24(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPDSR_P24() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPDSR_P25(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPDSR_P25() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPDSR_P26(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPDSR_P26() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPDSR_P27(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPDSR_P27() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPDSR_P28(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPDSR_P28() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPDSR_P29(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPDSR_P29() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPDSR_P30(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPDSR_P30() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPDSR_P31(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPDSR_P31() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x80000000) >> 31
}

// PIO.IER: Interrupt Enable Register
func (o *PIO_Type) SetIER_P0(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetIER_P0() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *PIO_Type) SetIER_P1(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetIER_P1() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetIER_P2(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetIER_P2() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetIER_P3(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetIER_P3() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetIER_P4(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetIER_P4() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetIER_P5(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetIER_P5() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetIER_P6(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetIER_P6() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetIER_P7(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetIER_P7() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetIER_P8(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetIER_P8() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetIER_P9(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetIER_P9() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetIER_P10(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetIER_P10() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetIER_P11(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetIER_P11() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetIER_P12(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetIER_P12() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetIER_P13(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetIER_P13() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetIER_P14(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetIER_P14() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetIER_P15(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetIER_P15() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetIER_P16(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetIER_P16() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetIER_P17(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetIER_P17() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetIER_P18(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetIER_P18() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetIER_P19(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetIER_P19() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetIER_P20(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetIER_P20() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetIER_P21(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetIER_P21() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetIER_P22(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetIER_P22() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetIER_P23(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetIER_P23() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetIER_P24(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetIER_P24() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetIER_P25(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetIER_P25() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetIER_P26(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetIER_P26() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetIER_P27(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetIER_P27() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetIER_P28(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetIER_P28() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetIER_P29(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetIER_P29() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetIER_P30(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetIER_P30() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetIER_P31(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetIER_P31() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80000000) >> 31
}

// PIO.IDR: Interrupt Disable Register
func (o *PIO_Type) SetIDR_P0(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetIDR_P0() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *PIO_Type) SetIDR_P1(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetIDR_P1() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetIDR_P2(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetIDR_P2() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetIDR_P3(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetIDR_P3() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetIDR_P4(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetIDR_P4() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetIDR_P5(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetIDR_P5() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetIDR_P6(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetIDR_P6() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetIDR_P7(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetIDR_P7() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetIDR_P8(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetIDR_P8() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetIDR_P9(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetIDR_P9() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetIDR_P10(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetIDR_P10() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetIDR_P11(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetIDR_P11() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetIDR_P12(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetIDR_P12() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetIDR_P13(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetIDR_P13() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetIDR_P14(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetIDR_P14() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetIDR_P15(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetIDR_P15() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetIDR_P16(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetIDR_P16() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetIDR_P17(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetIDR_P17() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetIDR_P18(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetIDR_P18() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetIDR_P19(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetIDR_P19() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetIDR_P20(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetIDR_P20() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetIDR_P21(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetIDR_P21() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetIDR_P22(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetIDR_P22() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetIDR_P23(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetIDR_P23() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetIDR_P24(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetIDR_P24() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetIDR_P25(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetIDR_P25() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetIDR_P26(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetIDR_P26() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetIDR_P27(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetIDR_P27() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetIDR_P28(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetIDR_P28() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetIDR_P29(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetIDR_P29() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetIDR_P30(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetIDR_P30() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetIDR_P31(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetIDR_P31() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80000000) >> 31
}

// PIO.IMR: Interrupt Mask Register
func (o *PIO_Type) SetIMR_P0(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetIMR_P0() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *PIO_Type) SetIMR_P1(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetIMR_P1() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetIMR_P2(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetIMR_P2() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetIMR_P3(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetIMR_P3() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetIMR_P4(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetIMR_P4() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetIMR_P5(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetIMR_P5() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetIMR_P6(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetIMR_P6() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetIMR_P7(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetIMR_P7() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetIMR_P8(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetIMR_P8() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetIMR_P9(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetIMR_P9() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetIMR_P10(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetIMR_P10() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetIMR_P11(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetIMR_P11() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetIMR_P12(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetIMR_P12() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetIMR_P13(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetIMR_P13() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetIMR_P14(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetIMR_P14() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetIMR_P15(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetIMR_P15() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetIMR_P16(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetIMR_P16() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetIMR_P17(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetIMR_P17() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetIMR_P18(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetIMR_P18() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetIMR_P19(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetIMR_P19() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetIMR_P20(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetIMR_P20() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetIMR_P21(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetIMR_P21() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetIMR_P22(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetIMR_P22() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetIMR_P23(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetIMR_P23() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetIMR_P24(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetIMR_P24() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetIMR_P25(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetIMR_P25() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetIMR_P26(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetIMR_P26() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetIMR_P27(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetIMR_P27() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetIMR_P28(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetIMR_P28() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetIMR_P29(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetIMR_P29() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetIMR_P30(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetIMR_P30() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetIMR_P31(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetIMR_P31() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80000000) >> 31
}

// PIO.ISR: Interrupt Status Register
func (o *PIO_Type) SetISR_P0(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetISR_P0() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}
func (o *PIO_Type) SetISR_P1(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetISR_P1() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetISR_P2(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetISR_P2() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetISR_P3(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetISR_P3() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetISR_P4(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetISR_P4() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetISR_P5(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetISR_P5() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetISR_P6(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetISR_P6() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetISR_P7(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetISR_P7() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetISR_P8(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetISR_P8() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetISR_P9(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetISR_P9() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetISR_P10(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetISR_P10() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetISR_P11(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetISR_P11() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetISR_P12(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetISR_P12() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetISR_P13(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetISR_P13() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetISR_P14(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetISR_P14() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetISR_P15(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetISR_P15() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetISR_P16(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetISR_P16() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetISR_P17(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetISR_P17() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetISR_P18(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetISR_P18() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetISR_P19(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetISR_P19() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetISR_P20(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetISR_P20() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetISR_P21(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetISR_P21() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetISR_P22(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetISR_P22() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetISR_P23(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetISR_P23() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetISR_P24(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetISR_P24() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetISR_P25(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetISR_P25() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetISR_P26(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetISR_P26() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetISR_P27(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetISR_P27() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetISR_P28(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetISR_P28() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetISR_P29(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetISR_P29() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetISR_P30(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetISR_P30() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetISR_P31(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetISR_P31() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80000000) >> 31
}

// PIO.MDER: Multi-driver Enable Register
func (o *PIO_Type) SetMDER_P0(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetMDER_P0() uint32 {
	return volatile.LoadUint32(&o.MDER.Reg) & 0x1
}
func (o *PIO_Type) SetMDER_P1(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetMDER_P1() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetMDER_P2(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetMDER_P2() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetMDER_P3(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetMDER_P3() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetMDER_P4(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetMDER_P4() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetMDER_P5(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetMDER_P5() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetMDER_P6(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetMDER_P6() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetMDER_P7(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetMDER_P7() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetMDER_P8(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetMDER_P8() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetMDER_P9(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetMDER_P9() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetMDER_P10(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetMDER_P10() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetMDER_P11(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetMDER_P11() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetMDER_P12(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetMDER_P12() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetMDER_P13(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetMDER_P13() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetMDER_P14(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetMDER_P14() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetMDER_P15(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetMDER_P15() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetMDER_P16(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetMDER_P16() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetMDER_P17(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetMDER_P17() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetMDER_P18(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetMDER_P18() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetMDER_P19(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetMDER_P19() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetMDER_P20(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetMDER_P20() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetMDER_P21(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetMDER_P21() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetMDER_P22(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetMDER_P22() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetMDER_P23(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetMDER_P23() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetMDER_P24(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetMDER_P24() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetMDER_P25(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetMDER_P25() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetMDER_P26(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetMDER_P26() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetMDER_P27(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetMDER_P27() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetMDER_P28(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetMDER_P28() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetMDER_P29(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetMDER_P29() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetMDER_P30(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetMDER_P30() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetMDER_P31(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetMDER_P31() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x80000000) >> 31
}

// PIO.MDDR: Multi-driver Disable Register
func (o *PIO_Type) SetMDDR_P0(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetMDDR_P0() uint32 {
	return volatile.LoadUint32(&o.MDDR.Reg) & 0x1
}
func (o *PIO_Type) SetMDDR_P1(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetMDDR_P1() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetMDDR_P2(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetMDDR_P2() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetMDDR_P3(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetMDDR_P3() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetMDDR_P4(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetMDDR_P4() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetMDDR_P5(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetMDDR_P5() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetMDDR_P6(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetMDDR_P6() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetMDDR_P7(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetMDDR_P7() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetMDDR_P8(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetMDDR_P8() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetMDDR_P9(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetMDDR_P9() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetMDDR_P10(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetMDDR_P10() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetMDDR_P11(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetMDDR_P11() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetMDDR_P12(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetMDDR_P12() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetMDDR_P13(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetMDDR_P13() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetMDDR_P14(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetMDDR_P14() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetMDDR_P15(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetMDDR_P15() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetMDDR_P16(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetMDDR_P16() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetMDDR_P17(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetMDDR_P17() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetMDDR_P18(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetMDDR_P18() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetMDDR_P19(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetMDDR_P19() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetMDDR_P20(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetMDDR_P20() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetMDDR_P21(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetMDDR_P21() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetMDDR_P22(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetMDDR_P22() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetMDDR_P23(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetMDDR_P23() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetMDDR_P24(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetMDDR_P24() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetMDDR_P25(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetMDDR_P25() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetMDDR_P26(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetMDDR_P26() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetMDDR_P27(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetMDDR_P27() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetMDDR_P28(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetMDDR_P28() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetMDDR_P29(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetMDDR_P29() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetMDDR_P30(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetMDDR_P30() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetMDDR_P31(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetMDDR_P31() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x80000000) >> 31
}

// PIO.MDSR: Multi-driver Status Register
func (o *PIO_Type) SetMDSR_P0(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetMDSR_P0() uint32 {
	return volatile.LoadUint32(&o.MDSR.Reg) & 0x1
}
func (o *PIO_Type) SetMDSR_P1(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetMDSR_P1() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetMDSR_P2(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetMDSR_P2() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetMDSR_P3(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetMDSR_P3() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetMDSR_P4(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetMDSR_P4() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetMDSR_P5(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetMDSR_P5() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetMDSR_P6(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetMDSR_P6() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetMDSR_P7(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetMDSR_P7() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetMDSR_P8(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetMDSR_P8() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetMDSR_P9(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetMDSR_P9() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetMDSR_P10(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetMDSR_P10() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetMDSR_P11(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetMDSR_P11() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetMDSR_P12(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetMDSR_P12() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetMDSR_P13(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetMDSR_P13() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetMDSR_P14(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetMDSR_P14() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetMDSR_P15(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetMDSR_P15() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetMDSR_P16(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetMDSR_P16() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetMDSR_P17(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetMDSR_P17() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetMDSR_P18(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetMDSR_P18() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetMDSR_P19(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetMDSR_P19() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetMDSR_P20(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetMDSR_P20() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetMDSR_P21(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetMDSR_P21() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetMDSR_P22(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetMDSR_P22() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetMDSR_P23(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetMDSR_P23() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetMDSR_P24(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetMDSR_P24() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetMDSR_P25(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetMDSR_P25() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetMDSR_P26(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetMDSR_P26() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetMDSR_P27(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetMDSR_P27() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetMDSR_P28(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetMDSR_P28() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetMDSR_P29(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetMDSR_P29() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetMDSR_P30(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetMDSR_P30() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetMDSR_P31(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetMDSR_P31() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x80000000) >> 31
}

// PIO.PUDR: Pull-up Disable Register
func (o *PIO_Type) SetPUDR_P0(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPUDR_P0() uint32 {
	return volatile.LoadUint32(&o.PUDR.Reg) & 0x1
}
func (o *PIO_Type) SetPUDR_P1(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPUDR_P1() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPUDR_P2(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPUDR_P2() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPUDR_P3(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPUDR_P3() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPUDR_P4(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPUDR_P4() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPUDR_P5(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPUDR_P5() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPUDR_P6(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPUDR_P6() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPUDR_P7(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPUDR_P7() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPUDR_P8(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPUDR_P8() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPUDR_P9(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPUDR_P9() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPUDR_P10(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPUDR_P10() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPUDR_P11(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPUDR_P11() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPUDR_P12(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPUDR_P12() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPUDR_P13(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPUDR_P13() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPUDR_P14(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPUDR_P14() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPUDR_P15(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPUDR_P15() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPUDR_P16(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPUDR_P16() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPUDR_P17(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPUDR_P17() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPUDR_P18(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPUDR_P18() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPUDR_P19(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPUDR_P19() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPUDR_P20(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPUDR_P20() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPUDR_P21(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPUDR_P21() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPUDR_P22(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPUDR_P22() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPUDR_P23(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPUDR_P23() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPUDR_P24(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPUDR_P24() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPUDR_P25(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPUDR_P25() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPUDR_P26(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPUDR_P26() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPUDR_P27(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPUDR_P27() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPUDR_P28(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPUDR_P28() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPUDR_P29(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPUDR_P29() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPUDR_P30(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPUDR_P30() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPUDR_P31(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPUDR_P31() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x80000000) >> 31
}

// PIO.PUER: Pull-up Enable Register
func (o *PIO_Type) SetPUER_P0(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPUER_P0() uint32 {
	return volatile.LoadUint32(&o.PUER.Reg) & 0x1
}
func (o *PIO_Type) SetPUER_P1(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPUER_P1() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPUER_P2(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPUER_P2() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPUER_P3(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPUER_P3() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPUER_P4(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPUER_P4() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPUER_P5(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPUER_P5() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPUER_P6(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPUER_P6() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPUER_P7(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPUER_P7() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPUER_P8(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPUER_P8() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPUER_P9(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPUER_P9() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPUER_P10(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPUER_P10() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPUER_P11(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPUER_P11() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPUER_P12(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPUER_P12() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPUER_P13(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPUER_P13() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPUER_P14(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPUER_P14() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPUER_P15(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPUER_P15() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPUER_P16(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPUER_P16() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPUER_P17(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPUER_P17() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPUER_P18(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPUER_P18() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPUER_P19(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPUER_P19() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPUER_P20(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPUER_P20() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPUER_P21(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPUER_P21() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPUER_P22(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPUER_P22() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPUER_P23(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPUER_P23() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPUER_P24(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPUER_P24() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPUER_P25(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPUER_P25() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPUER_P26(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPUER_P26() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPUER_P27(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPUER_P27() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPUER_P28(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPUER_P28() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPUER_P29(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPUER_P29() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPUER_P30(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPUER_P30() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPUER_P31(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPUER_P31() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x80000000) >> 31
}

// PIO.PUSR: Pad Pull-up Status Register
func (o *PIO_Type) SetPUSR_P0(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPUSR_P0() uint32 {
	return volatile.LoadUint32(&o.PUSR.Reg) & 0x1
}
func (o *PIO_Type) SetPUSR_P1(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPUSR_P1() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPUSR_P2(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPUSR_P2() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPUSR_P3(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPUSR_P3() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPUSR_P4(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPUSR_P4() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPUSR_P5(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPUSR_P5() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPUSR_P6(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPUSR_P6() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPUSR_P7(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPUSR_P7() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPUSR_P8(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPUSR_P8() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPUSR_P9(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPUSR_P9() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPUSR_P10(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPUSR_P10() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPUSR_P11(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPUSR_P11() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPUSR_P12(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPUSR_P12() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPUSR_P13(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPUSR_P13() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPUSR_P14(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPUSR_P14() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPUSR_P15(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPUSR_P15() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPUSR_P16(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPUSR_P16() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPUSR_P17(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPUSR_P17() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPUSR_P18(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPUSR_P18() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPUSR_P19(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPUSR_P19() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPUSR_P20(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPUSR_P20() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPUSR_P21(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPUSR_P21() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPUSR_P22(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPUSR_P22() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPUSR_P23(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPUSR_P23() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPUSR_P24(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPUSR_P24() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPUSR_P25(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPUSR_P25() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPUSR_P26(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPUSR_P26() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPUSR_P27(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPUSR_P27() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPUSR_P28(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPUSR_P28() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPUSR_P29(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPUSR_P29() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPUSR_P30(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPUSR_P30() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPUSR_P31(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPUSR_P31() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x80000000) >> 31
}

// PIO.ABCDSR: Peripheral Select Register
func (o *PIO_Type) SetABCDSR_P0(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetABCDSR_P0(idx int) uint32 {
	return volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x1
}
func (o *PIO_Type) SetABCDSR_P1(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetABCDSR_P1(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetABCDSR_P2(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetABCDSR_P2(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetABCDSR_P3(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetABCDSR_P3(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetABCDSR_P4(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetABCDSR_P4(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetABCDSR_P5(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetABCDSR_P5(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetABCDSR_P6(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetABCDSR_P6(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetABCDSR_P7(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetABCDSR_P7(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetABCDSR_P8(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetABCDSR_P8(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetABCDSR_P9(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetABCDSR_P9(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetABCDSR_P10(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetABCDSR_P10(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetABCDSR_P11(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetABCDSR_P11(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetABCDSR_P12(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetABCDSR_P12(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetABCDSR_P13(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetABCDSR_P13(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetABCDSR_P14(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetABCDSR_P14(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetABCDSR_P15(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetABCDSR_P15(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetABCDSR_P16(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetABCDSR_P16(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetABCDSR_P17(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetABCDSR_P17(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetABCDSR_P18(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetABCDSR_P18(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetABCDSR_P19(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetABCDSR_P19(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetABCDSR_P20(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetABCDSR_P20(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetABCDSR_P21(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetABCDSR_P21(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetABCDSR_P22(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetABCDSR_P22(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetABCDSR_P23(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetABCDSR_P23(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetABCDSR_P24(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetABCDSR_P24(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetABCDSR_P25(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetABCDSR_P25(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetABCDSR_P26(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetABCDSR_P26(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetABCDSR_P27(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetABCDSR_P27(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetABCDSR_P28(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetABCDSR_P28(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetABCDSR_P29(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetABCDSR_P29(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetABCDSR_P30(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetABCDSR_P30(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetABCDSR_P31(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetABCDSR_P31(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x80000000) >> 31
}

// PIO.IFSCDR: Input Filter Slow Clock Disable Register
func (o *PIO_Type) SetIFSCDR_P0(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetIFSCDR_P0() uint32 {
	return volatile.LoadUint32(&o.IFSCDR.Reg) & 0x1
}
func (o *PIO_Type) SetIFSCDR_P1(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetIFSCDR_P1() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetIFSCDR_P2(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetIFSCDR_P2() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetIFSCDR_P3(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetIFSCDR_P3() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetIFSCDR_P4(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetIFSCDR_P4() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetIFSCDR_P5(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetIFSCDR_P5() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetIFSCDR_P6(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetIFSCDR_P6() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetIFSCDR_P7(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetIFSCDR_P7() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetIFSCDR_P8(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetIFSCDR_P8() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetIFSCDR_P9(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetIFSCDR_P9() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetIFSCDR_P10(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetIFSCDR_P10() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetIFSCDR_P11(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetIFSCDR_P11() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetIFSCDR_P12(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetIFSCDR_P12() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetIFSCDR_P13(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetIFSCDR_P13() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetIFSCDR_P14(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetIFSCDR_P14() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetIFSCDR_P15(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetIFSCDR_P15() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetIFSCDR_P16(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetIFSCDR_P16() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetIFSCDR_P17(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetIFSCDR_P17() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetIFSCDR_P18(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetIFSCDR_P18() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetIFSCDR_P19(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetIFSCDR_P19() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetIFSCDR_P20(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetIFSCDR_P20() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetIFSCDR_P21(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetIFSCDR_P21() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetIFSCDR_P22(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetIFSCDR_P22() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetIFSCDR_P23(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetIFSCDR_P23() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetIFSCDR_P24(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetIFSCDR_P24() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetIFSCDR_P25(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetIFSCDR_P25() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetIFSCDR_P26(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetIFSCDR_P26() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetIFSCDR_P27(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetIFSCDR_P27() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetIFSCDR_P28(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetIFSCDR_P28() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetIFSCDR_P29(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetIFSCDR_P29() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetIFSCDR_P30(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetIFSCDR_P30() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetIFSCDR_P31(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetIFSCDR_P31() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x80000000) >> 31
}

// PIO.IFSCER: Input Filter Slow Clock Enable Register
func (o *PIO_Type) SetIFSCER_P0(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetIFSCER_P0() uint32 {
	return volatile.LoadUint32(&o.IFSCER.Reg) & 0x1
}
func (o *PIO_Type) SetIFSCER_P1(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetIFSCER_P1() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetIFSCER_P2(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetIFSCER_P2() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetIFSCER_P3(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetIFSCER_P3() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetIFSCER_P4(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetIFSCER_P4() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetIFSCER_P5(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetIFSCER_P5() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetIFSCER_P6(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetIFSCER_P6() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetIFSCER_P7(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetIFSCER_P7() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetIFSCER_P8(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetIFSCER_P8() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetIFSCER_P9(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetIFSCER_P9() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetIFSCER_P10(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetIFSCER_P10() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetIFSCER_P11(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetIFSCER_P11() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetIFSCER_P12(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetIFSCER_P12() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetIFSCER_P13(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetIFSCER_P13() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetIFSCER_P14(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetIFSCER_P14() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetIFSCER_P15(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetIFSCER_P15() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetIFSCER_P16(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetIFSCER_P16() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetIFSCER_P17(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetIFSCER_P17() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetIFSCER_P18(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetIFSCER_P18() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetIFSCER_P19(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetIFSCER_P19() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetIFSCER_P20(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetIFSCER_P20() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetIFSCER_P21(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetIFSCER_P21() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetIFSCER_P22(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetIFSCER_P22() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetIFSCER_P23(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetIFSCER_P23() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetIFSCER_P24(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetIFSCER_P24() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetIFSCER_P25(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetIFSCER_P25() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetIFSCER_P26(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetIFSCER_P26() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetIFSCER_P27(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetIFSCER_P27() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetIFSCER_P28(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetIFSCER_P28() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetIFSCER_P29(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetIFSCER_P29() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetIFSCER_P30(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetIFSCER_P30() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetIFSCER_P31(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetIFSCER_P31() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x80000000) >> 31
}

// PIO.IFSCSR: Input Filter Slow Clock Status Register
func (o *PIO_Type) SetIFSCSR_P0(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetIFSCSR_P0() uint32 {
	return volatile.LoadUint32(&o.IFSCSR.Reg) & 0x1
}
func (o *PIO_Type) SetIFSCSR_P1(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetIFSCSR_P1() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetIFSCSR_P2(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetIFSCSR_P2() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetIFSCSR_P3(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetIFSCSR_P3() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetIFSCSR_P4(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetIFSCSR_P4() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetIFSCSR_P5(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetIFSCSR_P5() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetIFSCSR_P6(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetIFSCSR_P6() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetIFSCSR_P7(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetIFSCSR_P7() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetIFSCSR_P8(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetIFSCSR_P8() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetIFSCSR_P9(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetIFSCSR_P9() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetIFSCSR_P10(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetIFSCSR_P10() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetIFSCSR_P11(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetIFSCSR_P11() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetIFSCSR_P12(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetIFSCSR_P12() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetIFSCSR_P13(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetIFSCSR_P13() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetIFSCSR_P14(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetIFSCSR_P14() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetIFSCSR_P15(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetIFSCSR_P15() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetIFSCSR_P16(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetIFSCSR_P16() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetIFSCSR_P17(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetIFSCSR_P17() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetIFSCSR_P18(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetIFSCSR_P18() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetIFSCSR_P19(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetIFSCSR_P19() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetIFSCSR_P20(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetIFSCSR_P20() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetIFSCSR_P21(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetIFSCSR_P21() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetIFSCSR_P22(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetIFSCSR_P22() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetIFSCSR_P23(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetIFSCSR_P23() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetIFSCSR_P24(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetIFSCSR_P24() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetIFSCSR_P25(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetIFSCSR_P25() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetIFSCSR_P26(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetIFSCSR_P26() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetIFSCSR_P27(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetIFSCSR_P27() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetIFSCSR_P28(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetIFSCSR_P28() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetIFSCSR_P29(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetIFSCSR_P29() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetIFSCSR_P30(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetIFSCSR_P30() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetIFSCSR_P31(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetIFSCSR_P31() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x80000000) >> 31
}

// PIO.SCDR: Slow Clock Divider Debouncing Register
func (o *PIO_Type) SetSCDR_DIV(value uint32) {
	volatile.StoreUint32(&o.SCDR.Reg, volatile.LoadUint32(&o.SCDR.Reg)&^(0x3fff)|value)
}
func (o *PIO_Type) GetSCDR_DIV() uint32 {
	return volatile.LoadUint32(&o.SCDR.Reg) & 0x3fff
}

// PIO.PPDDR: Pad Pull-down Disable Register
func (o *PIO_Type) SetPPDDR_P0(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPPDDR_P0() uint32 {
	return volatile.LoadUint32(&o.PPDDR.Reg) & 0x1
}
func (o *PIO_Type) SetPPDDR_P1(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPPDDR_P1() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPPDDR_P2(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPPDDR_P2() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPPDDR_P3(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPPDDR_P3() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPPDDR_P4(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPPDDR_P4() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPPDDR_P5(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPPDDR_P5() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPPDDR_P6(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPPDDR_P6() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPPDDR_P7(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPPDDR_P7() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPPDDR_P8(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPPDDR_P8() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPPDDR_P9(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPPDDR_P9() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPPDDR_P10(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPPDDR_P10() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPPDDR_P11(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPPDDR_P11() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPPDDR_P12(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPPDDR_P12() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPPDDR_P13(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPPDDR_P13() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPPDDR_P14(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPPDDR_P14() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPPDDR_P15(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPPDDR_P15() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPPDDR_P16(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPPDDR_P16() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPPDDR_P17(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPPDDR_P17() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPPDDR_P18(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPPDDR_P18() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPPDDR_P19(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPPDDR_P19() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPPDDR_P20(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPPDDR_P20() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPPDDR_P21(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPPDDR_P21() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPPDDR_P22(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPPDDR_P22() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPPDDR_P23(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPPDDR_P23() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPPDDR_P24(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPPDDR_P24() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPPDDR_P25(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPPDDR_P25() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPPDDR_P26(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPPDDR_P26() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPPDDR_P27(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPPDDR_P27() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPPDDR_P28(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPPDDR_P28() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPPDDR_P29(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPPDDR_P29() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPPDDR_P30(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPPDDR_P30() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPPDDR_P31(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPPDDR_P31() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x80000000) >> 31
}

// PIO.PPDER: Pad Pull-down Enable Register
func (o *PIO_Type) SetPPDER_P0(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPPDER_P0() uint32 {
	return volatile.LoadUint32(&o.PPDER.Reg) & 0x1
}
func (o *PIO_Type) SetPPDER_P1(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPPDER_P1() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPPDER_P2(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPPDER_P2() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPPDER_P3(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPPDER_P3() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPPDER_P4(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPPDER_P4() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPPDER_P5(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPPDER_P5() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPPDER_P6(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPPDER_P6() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPPDER_P7(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPPDER_P7() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPPDER_P8(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPPDER_P8() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPPDER_P9(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPPDER_P9() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPPDER_P10(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPPDER_P10() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPPDER_P11(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPPDER_P11() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPPDER_P12(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPPDER_P12() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPPDER_P13(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPPDER_P13() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPPDER_P14(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPPDER_P14() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPPDER_P15(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPPDER_P15() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPPDER_P16(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPPDER_P16() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPPDER_P17(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPPDER_P17() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPPDER_P18(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPPDER_P18() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPPDER_P19(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPPDER_P19() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPPDER_P20(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPPDER_P20() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPPDER_P21(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPPDER_P21() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPPDER_P22(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPPDER_P22() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPPDER_P23(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPPDER_P23() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPPDER_P24(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPPDER_P24() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPPDER_P25(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPPDER_P25() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPPDER_P26(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPPDER_P26() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPPDER_P27(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPPDER_P27() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPPDER_P28(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPPDER_P28() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPPDER_P29(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPPDER_P29() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPPDER_P30(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPPDER_P30() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPPDER_P31(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPPDER_P31() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x80000000) >> 31
}

// PIO.PPDSR: Pad Pull-down Status Register
func (o *PIO_Type) SetPPDSR_P0(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPPDSR_P0() uint32 {
	return volatile.LoadUint32(&o.PPDSR.Reg) & 0x1
}
func (o *PIO_Type) SetPPDSR_P1(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPPDSR_P1() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPPDSR_P2(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPPDSR_P2() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPPDSR_P3(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPPDSR_P3() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPPDSR_P4(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPPDSR_P4() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPPDSR_P5(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPPDSR_P5() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPPDSR_P6(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPPDSR_P6() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPPDSR_P7(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPPDSR_P7() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPPDSR_P8(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPPDSR_P8() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPPDSR_P9(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPPDSR_P9() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPPDSR_P10(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPPDSR_P10() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPPDSR_P11(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPPDSR_P11() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPPDSR_P12(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPPDSR_P12() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPPDSR_P13(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPPDSR_P13() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPPDSR_P14(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPPDSR_P14() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPPDSR_P15(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPPDSR_P15() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPPDSR_P16(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPPDSR_P16() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPPDSR_P17(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPPDSR_P17() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPPDSR_P18(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPPDSR_P18() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPPDSR_P19(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPPDSR_P19() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPPDSR_P20(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPPDSR_P20() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPPDSR_P21(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPPDSR_P21() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPPDSR_P22(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPPDSR_P22() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPPDSR_P23(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPPDSR_P23() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPPDSR_P24(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPPDSR_P24() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPPDSR_P25(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPPDSR_P25() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPPDSR_P26(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPPDSR_P26() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPPDSR_P27(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPPDSR_P27() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPPDSR_P28(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPPDSR_P28() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPPDSR_P29(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPPDSR_P29() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPPDSR_P30(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPPDSR_P30() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPPDSR_P31(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPPDSR_P31() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x80000000) >> 31
}

// PIO.OWER: Output Write Enable
func (o *PIO_Type) SetOWER_P0(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetOWER_P0() uint32 {
	return volatile.LoadUint32(&o.OWER.Reg) & 0x1
}
func (o *PIO_Type) SetOWER_P1(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetOWER_P1() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetOWER_P2(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetOWER_P2() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetOWER_P3(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetOWER_P3() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetOWER_P4(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetOWER_P4() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetOWER_P5(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetOWER_P5() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetOWER_P6(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetOWER_P6() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetOWER_P7(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetOWER_P7() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetOWER_P8(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetOWER_P8() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetOWER_P9(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetOWER_P9() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetOWER_P10(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetOWER_P10() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetOWER_P11(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetOWER_P11() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetOWER_P12(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetOWER_P12() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetOWER_P13(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetOWER_P13() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetOWER_P14(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetOWER_P14() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetOWER_P15(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetOWER_P15() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetOWER_P16(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetOWER_P16() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetOWER_P17(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetOWER_P17() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetOWER_P18(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetOWER_P18() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetOWER_P19(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetOWER_P19() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetOWER_P20(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetOWER_P20() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetOWER_P21(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetOWER_P21() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetOWER_P22(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetOWER_P22() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetOWER_P23(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetOWER_P23() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetOWER_P24(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetOWER_P24() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetOWER_P25(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetOWER_P25() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetOWER_P26(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetOWER_P26() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetOWER_P27(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetOWER_P27() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetOWER_P28(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetOWER_P28() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetOWER_P29(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetOWER_P29() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetOWER_P30(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetOWER_P30() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetOWER_P31(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetOWER_P31() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x80000000) >> 31
}

// PIO.OWDR: Output Write Disable
func (o *PIO_Type) SetOWDR_P0(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetOWDR_P0() uint32 {
	return volatile.LoadUint32(&o.OWDR.Reg) & 0x1
}
func (o *PIO_Type) SetOWDR_P1(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetOWDR_P1() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetOWDR_P2(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetOWDR_P2() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetOWDR_P3(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetOWDR_P3() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetOWDR_P4(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetOWDR_P4() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetOWDR_P5(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetOWDR_P5() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetOWDR_P6(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetOWDR_P6() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetOWDR_P7(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetOWDR_P7() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetOWDR_P8(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetOWDR_P8() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetOWDR_P9(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetOWDR_P9() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetOWDR_P10(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetOWDR_P10() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetOWDR_P11(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetOWDR_P11() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetOWDR_P12(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetOWDR_P12() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetOWDR_P13(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetOWDR_P13() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetOWDR_P14(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetOWDR_P14() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetOWDR_P15(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetOWDR_P15() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetOWDR_P16(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetOWDR_P16() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetOWDR_P17(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetOWDR_P17() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetOWDR_P18(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetOWDR_P18() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetOWDR_P19(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetOWDR_P19() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetOWDR_P20(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetOWDR_P20() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetOWDR_P21(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetOWDR_P21() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetOWDR_P22(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetOWDR_P22() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetOWDR_P23(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetOWDR_P23() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetOWDR_P24(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetOWDR_P24() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetOWDR_P25(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetOWDR_P25() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetOWDR_P26(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetOWDR_P26() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetOWDR_P27(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetOWDR_P27() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetOWDR_P28(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetOWDR_P28() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetOWDR_P29(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetOWDR_P29() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetOWDR_P30(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetOWDR_P30() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetOWDR_P31(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetOWDR_P31() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x80000000) >> 31
}

// PIO.OWSR: Output Write Status Register
func (o *PIO_Type) SetOWSR_P0(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetOWSR_P0() uint32 {
	return volatile.LoadUint32(&o.OWSR.Reg) & 0x1
}
func (o *PIO_Type) SetOWSR_P1(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetOWSR_P1() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetOWSR_P2(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetOWSR_P2() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetOWSR_P3(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetOWSR_P3() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetOWSR_P4(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetOWSR_P4() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetOWSR_P5(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetOWSR_P5() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetOWSR_P6(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetOWSR_P6() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetOWSR_P7(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetOWSR_P7() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetOWSR_P8(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetOWSR_P8() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetOWSR_P9(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetOWSR_P9() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetOWSR_P10(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetOWSR_P10() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetOWSR_P11(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetOWSR_P11() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetOWSR_P12(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetOWSR_P12() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetOWSR_P13(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetOWSR_P13() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetOWSR_P14(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetOWSR_P14() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetOWSR_P15(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetOWSR_P15() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetOWSR_P16(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetOWSR_P16() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetOWSR_P17(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetOWSR_P17() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetOWSR_P18(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetOWSR_P18() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetOWSR_P19(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetOWSR_P19() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetOWSR_P20(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetOWSR_P20() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetOWSR_P21(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetOWSR_P21() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetOWSR_P22(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetOWSR_P22() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetOWSR_P23(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetOWSR_P23() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetOWSR_P24(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetOWSR_P24() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetOWSR_P25(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetOWSR_P25() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetOWSR_P26(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetOWSR_P26() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetOWSR_P27(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetOWSR_P27() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetOWSR_P28(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetOWSR_P28() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetOWSR_P29(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetOWSR_P29() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetOWSR_P30(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetOWSR_P30() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetOWSR_P31(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetOWSR_P31() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x80000000) >> 31
}

// PIO.AIMER: Additional Interrupt Modes Enable Register
func (o *PIO_Type) SetAIMER_P0(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetAIMER_P0() uint32 {
	return volatile.LoadUint32(&o.AIMER.Reg) & 0x1
}
func (o *PIO_Type) SetAIMER_P1(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetAIMER_P1() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetAIMER_P2(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetAIMER_P2() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetAIMER_P3(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetAIMER_P3() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetAIMER_P4(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetAIMER_P4() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetAIMER_P5(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetAIMER_P5() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetAIMER_P6(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetAIMER_P6() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetAIMER_P7(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetAIMER_P7() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetAIMER_P8(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetAIMER_P8() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetAIMER_P9(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetAIMER_P9() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetAIMER_P10(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetAIMER_P10() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetAIMER_P11(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetAIMER_P11() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetAIMER_P12(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetAIMER_P12() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetAIMER_P13(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetAIMER_P13() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetAIMER_P14(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetAIMER_P14() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetAIMER_P15(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetAIMER_P15() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetAIMER_P16(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetAIMER_P16() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetAIMER_P17(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetAIMER_P17() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetAIMER_P18(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetAIMER_P18() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetAIMER_P19(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetAIMER_P19() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetAIMER_P20(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetAIMER_P20() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetAIMER_P21(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetAIMER_P21() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetAIMER_P22(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetAIMER_P22() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetAIMER_P23(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetAIMER_P23() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetAIMER_P24(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetAIMER_P24() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetAIMER_P25(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetAIMER_P25() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetAIMER_P26(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetAIMER_P26() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetAIMER_P27(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetAIMER_P27() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetAIMER_P28(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetAIMER_P28() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetAIMER_P29(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetAIMER_P29() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetAIMER_P30(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetAIMER_P30() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetAIMER_P31(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetAIMER_P31() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x80000000) >> 31
}

// PIO.AIMDR: Additional Interrupt Modes Disable Register
func (o *PIO_Type) SetAIMDR_P0(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetAIMDR_P0() uint32 {
	return volatile.LoadUint32(&o.AIMDR.Reg) & 0x1
}
func (o *PIO_Type) SetAIMDR_P1(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetAIMDR_P1() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetAIMDR_P2(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetAIMDR_P2() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetAIMDR_P3(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetAIMDR_P3() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetAIMDR_P4(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetAIMDR_P4() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetAIMDR_P5(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetAIMDR_P5() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetAIMDR_P6(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetAIMDR_P6() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetAIMDR_P7(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetAIMDR_P7() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetAIMDR_P8(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetAIMDR_P8() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetAIMDR_P9(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetAIMDR_P9() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetAIMDR_P10(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetAIMDR_P10() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetAIMDR_P11(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetAIMDR_P11() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetAIMDR_P12(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetAIMDR_P12() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetAIMDR_P13(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetAIMDR_P13() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetAIMDR_P14(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetAIMDR_P14() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetAIMDR_P15(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetAIMDR_P15() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetAIMDR_P16(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetAIMDR_P16() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetAIMDR_P17(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetAIMDR_P17() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetAIMDR_P18(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetAIMDR_P18() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetAIMDR_P19(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetAIMDR_P19() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetAIMDR_P20(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetAIMDR_P20() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetAIMDR_P21(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetAIMDR_P21() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetAIMDR_P22(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetAIMDR_P22() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetAIMDR_P23(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetAIMDR_P23() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetAIMDR_P24(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetAIMDR_P24() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetAIMDR_P25(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetAIMDR_P25() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetAIMDR_P26(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetAIMDR_P26() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetAIMDR_P27(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetAIMDR_P27() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetAIMDR_P28(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetAIMDR_P28() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetAIMDR_P29(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetAIMDR_P29() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetAIMDR_P30(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetAIMDR_P30() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetAIMDR_P31(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetAIMDR_P31() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x80000000) >> 31
}

// PIO.AIMMR: Additional Interrupt Modes Mask Register
func (o *PIO_Type) SetAIMMR_P0(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetAIMMR_P0() uint32 {
	return volatile.LoadUint32(&o.AIMMR.Reg) & 0x1
}
func (o *PIO_Type) SetAIMMR_P1(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetAIMMR_P1() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetAIMMR_P2(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetAIMMR_P2() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetAIMMR_P3(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetAIMMR_P3() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetAIMMR_P4(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetAIMMR_P4() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetAIMMR_P5(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetAIMMR_P5() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetAIMMR_P6(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetAIMMR_P6() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetAIMMR_P7(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetAIMMR_P7() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetAIMMR_P8(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetAIMMR_P8() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetAIMMR_P9(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetAIMMR_P9() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetAIMMR_P10(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetAIMMR_P10() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetAIMMR_P11(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetAIMMR_P11() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetAIMMR_P12(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetAIMMR_P12() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetAIMMR_P13(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetAIMMR_P13() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetAIMMR_P14(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetAIMMR_P14() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetAIMMR_P15(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetAIMMR_P15() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetAIMMR_P16(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetAIMMR_P16() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetAIMMR_P17(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetAIMMR_P17() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetAIMMR_P18(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetAIMMR_P18() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetAIMMR_P19(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetAIMMR_P19() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetAIMMR_P20(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetAIMMR_P20() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetAIMMR_P21(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetAIMMR_P21() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetAIMMR_P22(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetAIMMR_P22() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetAIMMR_P23(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetAIMMR_P23() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetAIMMR_P24(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetAIMMR_P24() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetAIMMR_P25(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetAIMMR_P25() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetAIMMR_P26(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetAIMMR_P26() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetAIMMR_P27(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetAIMMR_P27() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetAIMMR_P28(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetAIMMR_P28() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetAIMMR_P29(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetAIMMR_P29() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetAIMMR_P30(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetAIMMR_P30() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetAIMMR_P31(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetAIMMR_P31() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x80000000) >> 31
}

// PIO.ESR: Edge Select Register
func (o *PIO_Type) SetESR_P0(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetESR_P0() uint32 {
	return volatile.LoadUint32(&o.ESR.Reg) & 0x1
}
func (o *PIO_Type) SetESR_P1(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetESR_P1() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetESR_P2(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetESR_P2() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetESR_P3(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetESR_P3() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetESR_P4(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetESR_P4() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetESR_P5(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetESR_P5() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetESR_P6(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetESR_P6() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetESR_P7(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetESR_P7() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetESR_P8(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetESR_P8() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetESR_P9(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetESR_P9() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetESR_P10(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetESR_P10() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetESR_P11(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetESR_P11() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetESR_P12(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetESR_P12() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetESR_P13(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetESR_P13() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetESR_P14(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetESR_P14() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetESR_P15(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetESR_P15() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetESR_P16(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetESR_P16() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetESR_P17(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetESR_P17() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetESR_P18(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetESR_P18() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetESR_P19(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetESR_P19() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetESR_P20(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetESR_P20() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetESR_P21(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetESR_P21() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetESR_P22(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetESR_P22() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetESR_P23(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetESR_P23() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetESR_P24(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetESR_P24() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetESR_P25(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetESR_P25() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetESR_P26(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetESR_P26() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetESR_P27(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetESR_P27() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetESR_P28(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetESR_P28() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetESR_P29(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetESR_P29() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetESR_P30(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetESR_P30() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetESR_P31(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetESR_P31() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x80000000) >> 31
}

// PIO.LSR: Level Select Register
func (o *PIO_Type) SetLSR_P0(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetLSR_P0() uint32 {
	return volatile.LoadUint32(&o.LSR.Reg) & 0x1
}
func (o *PIO_Type) SetLSR_P1(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetLSR_P1() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetLSR_P2(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetLSR_P2() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetLSR_P3(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetLSR_P3() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetLSR_P4(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetLSR_P4() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetLSR_P5(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetLSR_P5() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetLSR_P6(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetLSR_P6() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetLSR_P7(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetLSR_P7() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetLSR_P8(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetLSR_P8() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetLSR_P9(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetLSR_P9() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetLSR_P10(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetLSR_P10() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetLSR_P11(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetLSR_P11() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetLSR_P12(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetLSR_P12() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetLSR_P13(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetLSR_P13() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetLSR_P14(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetLSR_P14() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetLSR_P15(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetLSR_P15() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetLSR_P16(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetLSR_P16() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetLSR_P17(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetLSR_P17() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetLSR_P18(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetLSR_P18() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetLSR_P19(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetLSR_P19() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetLSR_P20(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetLSR_P20() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetLSR_P21(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetLSR_P21() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetLSR_P22(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetLSR_P22() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetLSR_P23(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetLSR_P23() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetLSR_P24(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetLSR_P24() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetLSR_P25(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetLSR_P25() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetLSR_P26(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetLSR_P26() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetLSR_P27(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetLSR_P27() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetLSR_P28(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetLSR_P28() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetLSR_P29(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetLSR_P29() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetLSR_P30(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetLSR_P30() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetLSR_P31(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetLSR_P31() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x80000000) >> 31
}

// PIO.ELSR: Edge/Level Status Register
func (o *PIO_Type) SetELSR_P0(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetELSR_P0() uint32 {
	return volatile.LoadUint32(&o.ELSR.Reg) & 0x1
}
func (o *PIO_Type) SetELSR_P1(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetELSR_P1() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetELSR_P2(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetELSR_P2() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetELSR_P3(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetELSR_P3() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetELSR_P4(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetELSR_P4() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetELSR_P5(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetELSR_P5() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetELSR_P6(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetELSR_P6() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetELSR_P7(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetELSR_P7() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetELSR_P8(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetELSR_P8() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetELSR_P9(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetELSR_P9() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetELSR_P10(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetELSR_P10() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetELSR_P11(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetELSR_P11() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetELSR_P12(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetELSR_P12() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetELSR_P13(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetELSR_P13() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetELSR_P14(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetELSR_P14() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetELSR_P15(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetELSR_P15() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetELSR_P16(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetELSR_P16() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetELSR_P17(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetELSR_P17() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetELSR_P18(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetELSR_P18() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetELSR_P19(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetELSR_P19() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetELSR_P20(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetELSR_P20() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetELSR_P21(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetELSR_P21() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetELSR_P22(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetELSR_P22() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetELSR_P23(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetELSR_P23() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetELSR_P24(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetELSR_P24() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetELSR_P25(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetELSR_P25() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetELSR_P26(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetELSR_P26() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetELSR_P27(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetELSR_P27() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetELSR_P28(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetELSR_P28() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetELSR_P29(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetELSR_P29() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetELSR_P30(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetELSR_P30() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetELSR_P31(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetELSR_P31() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x80000000) >> 31
}

// PIO.FELLSR: Falling Edge/Low-Level Select Register
func (o *PIO_Type) SetFELLSR_P0(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetFELLSR_P0() uint32 {
	return volatile.LoadUint32(&o.FELLSR.Reg) & 0x1
}
func (o *PIO_Type) SetFELLSR_P1(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetFELLSR_P1() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetFELLSR_P2(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetFELLSR_P2() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetFELLSR_P3(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetFELLSR_P3() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetFELLSR_P4(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetFELLSR_P4() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetFELLSR_P5(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetFELLSR_P5() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetFELLSR_P6(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetFELLSR_P6() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetFELLSR_P7(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetFELLSR_P7() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetFELLSR_P8(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetFELLSR_P8() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetFELLSR_P9(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetFELLSR_P9() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetFELLSR_P10(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetFELLSR_P10() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetFELLSR_P11(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetFELLSR_P11() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetFELLSR_P12(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetFELLSR_P12() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetFELLSR_P13(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetFELLSR_P13() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetFELLSR_P14(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetFELLSR_P14() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetFELLSR_P15(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetFELLSR_P15() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetFELLSR_P16(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetFELLSR_P16() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetFELLSR_P17(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetFELLSR_P17() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetFELLSR_P18(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetFELLSR_P18() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetFELLSR_P19(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetFELLSR_P19() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetFELLSR_P20(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetFELLSR_P20() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetFELLSR_P21(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetFELLSR_P21() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetFELLSR_P22(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetFELLSR_P22() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetFELLSR_P23(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetFELLSR_P23() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetFELLSR_P24(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetFELLSR_P24() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetFELLSR_P25(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetFELLSR_P25() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetFELLSR_P26(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetFELLSR_P26() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetFELLSR_P27(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetFELLSR_P27() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetFELLSR_P28(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetFELLSR_P28() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetFELLSR_P29(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetFELLSR_P29() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetFELLSR_P30(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetFELLSR_P30() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetFELLSR_P31(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetFELLSR_P31() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x80000000) >> 31
}

// PIO.REHLSR: Rising Edge/High-Level Select Register
func (o *PIO_Type) SetREHLSR_P0(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetREHLSR_P0() uint32 {
	return volatile.LoadUint32(&o.REHLSR.Reg) & 0x1
}
func (o *PIO_Type) SetREHLSR_P1(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetREHLSR_P1() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetREHLSR_P2(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetREHLSR_P2() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetREHLSR_P3(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetREHLSR_P3() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetREHLSR_P4(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetREHLSR_P4() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetREHLSR_P5(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetREHLSR_P5() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetREHLSR_P6(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetREHLSR_P6() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetREHLSR_P7(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetREHLSR_P7() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetREHLSR_P8(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetREHLSR_P8() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetREHLSR_P9(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetREHLSR_P9() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetREHLSR_P10(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetREHLSR_P10() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetREHLSR_P11(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetREHLSR_P11() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetREHLSR_P12(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetREHLSR_P12() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetREHLSR_P13(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetREHLSR_P13() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetREHLSR_P14(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetREHLSR_P14() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetREHLSR_P15(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetREHLSR_P15() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetREHLSR_P16(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetREHLSR_P16() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetREHLSR_P17(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetREHLSR_P17() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetREHLSR_P18(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetREHLSR_P18() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetREHLSR_P19(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetREHLSR_P19() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetREHLSR_P20(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetREHLSR_P20() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetREHLSR_P21(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetREHLSR_P21() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetREHLSR_P22(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetREHLSR_P22() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetREHLSR_P23(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetREHLSR_P23() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetREHLSR_P24(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetREHLSR_P24() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetREHLSR_P25(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetREHLSR_P25() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetREHLSR_P26(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetREHLSR_P26() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetREHLSR_P27(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetREHLSR_P27() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetREHLSR_P28(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetREHLSR_P28() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetREHLSR_P29(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetREHLSR_P29() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetREHLSR_P30(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetREHLSR_P30() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetREHLSR_P31(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetREHLSR_P31() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x80000000) >> 31
}

// PIO.FRLHSR: Fall/Rise - Low/High Status Register
func (o *PIO_Type) SetFRLHSR_P0(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetFRLHSR_P0() uint32 {
	return volatile.LoadUint32(&o.FRLHSR.Reg) & 0x1
}
func (o *PIO_Type) SetFRLHSR_P1(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetFRLHSR_P1() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetFRLHSR_P2(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetFRLHSR_P2() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetFRLHSR_P3(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetFRLHSR_P3() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetFRLHSR_P4(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetFRLHSR_P4() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetFRLHSR_P5(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetFRLHSR_P5() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetFRLHSR_P6(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetFRLHSR_P6() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetFRLHSR_P7(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetFRLHSR_P7() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetFRLHSR_P8(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetFRLHSR_P8() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetFRLHSR_P9(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetFRLHSR_P9() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetFRLHSR_P10(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetFRLHSR_P10() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetFRLHSR_P11(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetFRLHSR_P11() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetFRLHSR_P12(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetFRLHSR_P12() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetFRLHSR_P13(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetFRLHSR_P13() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetFRLHSR_P14(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetFRLHSR_P14() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetFRLHSR_P15(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetFRLHSR_P15() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetFRLHSR_P16(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetFRLHSR_P16() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetFRLHSR_P17(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetFRLHSR_P17() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetFRLHSR_P18(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetFRLHSR_P18() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetFRLHSR_P19(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetFRLHSR_P19() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetFRLHSR_P20(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetFRLHSR_P20() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetFRLHSR_P21(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetFRLHSR_P21() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetFRLHSR_P22(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetFRLHSR_P22() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetFRLHSR_P23(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetFRLHSR_P23() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetFRLHSR_P24(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetFRLHSR_P24() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetFRLHSR_P25(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetFRLHSR_P25() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetFRLHSR_P26(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetFRLHSR_P26() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetFRLHSR_P27(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetFRLHSR_P27() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetFRLHSR_P28(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetFRLHSR_P28() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetFRLHSR_P29(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetFRLHSR_P29() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetFRLHSR_P30(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetFRLHSR_P30() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetFRLHSR_P31(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetFRLHSR_P31() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x80000000) >> 31
}

// PIO.LOCKSR: Lock Status
func (o *PIO_Type) SetLOCKSR_P0(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetLOCKSR_P0() uint32 {
	return volatile.LoadUint32(&o.LOCKSR.Reg) & 0x1
}
func (o *PIO_Type) SetLOCKSR_P1(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetLOCKSR_P1() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetLOCKSR_P2(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetLOCKSR_P2() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetLOCKSR_P3(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetLOCKSR_P3() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetLOCKSR_P4(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetLOCKSR_P4() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetLOCKSR_P5(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetLOCKSR_P5() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetLOCKSR_P6(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetLOCKSR_P6() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetLOCKSR_P7(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetLOCKSR_P7() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetLOCKSR_P8(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetLOCKSR_P8() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetLOCKSR_P9(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetLOCKSR_P9() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetLOCKSR_P10(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetLOCKSR_P10() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetLOCKSR_P11(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetLOCKSR_P11() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetLOCKSR_P12(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetLOCKSR_P12() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetLOCKSR_P13(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetLOCKSR_P13() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetLOCKSR_P14(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetLOCKSR_P14() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetLOCKSR_P15(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetLOCKSR_P15() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetLOCKSR_P16(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetLOCKSR_P16() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetLOCKSR_P17(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetLOCKSR_P17() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetLOCKSR_P18(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetLOCKSR_P18() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetLOCKSR_P19(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetLOCKSR_P19() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetLOCKSR_P20(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetLOCKSR_P20() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetLOCKSR_P21(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetLOCKSR_P21() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetLOCKSR_P22(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetLOCKSR_P22() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetLOCKSR_P23(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetLOCKSR_P23() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetLOCKSR_P24(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetLOCKSR_P24() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetLOCKSR_P25(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetLOCKSR_P25() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetLOCKSR_P26(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetLOCKSR_P26() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetLOCKSR_P27(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetLOCKSR_P27() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetLOCKSR_P28(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetLOCKSR_P28() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetLOCKSR_P29(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetLOCKSR_P29() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetLOCKSR_P30(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetLOCKSR_P30() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetLOCKSR_P31(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetLOCKSR_P31() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x80000000) >> 31
}

// PIO.WPMR: Write Protection Mode Register
func (o *PIO_Type) SetWPMR_WPEN(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetWPMR_WPEN() uint32 {
	return volatile.LoadUint32(&o.WPMR.Reg) & 0x1
}
func (o *PIO_Type) SetWPMR_WPKEY(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0xffffff00)|value<<8)
}
func (o *PIO_Type) GetWPMR_WPKEY() uint32 {
	return (volatile.LoadUint32(&o.WPMR.Reg) & 0xffffff00) >> 8
}

// PIO.WPSR: Write Protection Status Register
func (o *PIO_Type) SetWPSR_WPVS(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetWPSR_WPVS() uint32 {
	return volatile.LoadUint32(&o.WPSR.Reg) & 0x1
}
func (o *PIO_Type) SetWPSR_WPVSRC(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0xffff00)|value<<8)
}
func (o *PIO_Type) GetWPSR_WPVSRC() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0xffff00) >> 8
}

// PIO.SCHMITT: Schmitt Trigger Register
func (o *PIO_Type) SetSCHMITT_SCHMITT0(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT0() uint32 {
	return volatile.LoadUint32(&o.SCHMITT.Reg) & 0x1
}
func (o *PIO_Type) SetSCHMITT_SCHMITT1(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT1() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetSCHMITT_SCHMITT2(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT2() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetSCHMITT_SCHMITT3(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT3() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetSCHMITT_SCHMITT4(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT4() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetSCHMITT_SCHMITT5(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT5() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetSCHMITT_SCHMITT6(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT6() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetSCHMITT_SCHMITT7(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT7() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetSCHMITT_SCHMITT8(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT8() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetSCHMITT_SCHMITT9(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT9() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetSCHMITT_SCHMITT10(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT10() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetSCHMITT_SCHMITT11(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT11() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetSCHMITT_SCHMITT12(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT12() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetSCHMITT_SCHMITT13(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT13() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetSCHMITT_SCHMITT14(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT14() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetSCHMITT_SCHMITT15(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT15() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetSCHMITT_SCHMITT16(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT16() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetSCHMITT_SCHMITT17(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT17() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetSCHMITT_SCHMITT18(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT18() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetSCHMITT_SCHMITT19(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT19() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetSCHMITT_SCHMITT20(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT20() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetSCHMITT_SCHMITT21(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT21() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetSCHMITT_SCHMITT22(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT22() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetSCHMITT_SCHMITT23(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT23() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetSCHMITT_SCHMITT24(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT24() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetSCHMITT_SCHMITT25(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT25() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetSCHMITT_SCHMITT26(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT26() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetSCHMITT_SCHMITT27(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT27() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetSCHMITT_SCHMITT28(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT28() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetSCHMITT_SCHMITT29(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT29() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetSCHMITT_SCHMITT30(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT30() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetSCHMITT_SCHMITT31(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT31() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x80000000) >> 31
}

// PIO.PCMR: Parallel Capture Mode Register
func (o *PIO_Type) SetPCMR_PCEN(value uint32) {
	volatile.StoreUint32(&o.PCMR.Reg, volatile.LoadUint32(&o.PCMR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPCMR_PCEN() uint32 {
	return volatile.LoadUint32(&o.PCMR.Reg) & 0x1
}
func (o *PIO_Type) SetPCMR_DSIZE(value uint32) {
	volatile.StoreUint32(&o.PCMR.Reg, volatile.LoadUint32(&o.PCMR.Reg)&^(0x30)|value<<4)
}
func (o *PIO_Type) GetPCMR_DSIZE() uint32 {
	return (volatile.LoadUint32(&o.PCMR.Reg) & 0x30) >> 4
}
func (o *PIO_Type) SetPCMR_ALWYS(value uint32) {
	volatile.StoreUint32(&o.PCMR.Reg, volatile.LoadUint32(&o.PCMR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPCMR_ALWYS() uint32 {
	return (volatile.LoadUint32(&o.PCMR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPCMR_HALFS(value uint32) {
	volatile.StoreUint32(&o.PCMR.Reg, volatile.LoadUint32(&o.PCMR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPCMR_HALFS() uint32 {
	return (volatile.LoadUint32(&o.PCMR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPCMR_FRSTS(value uint32) {
	volatile.StoreUint32(&o.PCMR.Reg, volatile.LoadUint32(&o.PCMR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPCMR_FRSTS() uint32 {
	return (volatile.LoadUint32(&o.PCMR.Reg) & 0x800) >> 11
}

// PIO.PCIER: Parallel Capture Interrupt Enable Register
func (o *PIO_Type) SetPCIER_DRDY(value uint32) {
	volatile.StoreUint32(&o.PCIER.Reg, volatile.LoadUint32(&o.PCIER.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPCIER_DRDY() uint32 {
	return volatile.LoadUint32(&o.PCIER.Reg) & 0x1
}
func (o *PIO_Type) SetPCIER_OVRE(value uint32) {
	volatile.StoreUint32(&o.PCIER.Reg, volatile.LoadUint32(&o.PCIER.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPCIER_OVRE() uint32 {
	return (volatile.LoadUint32(&o.PCIER.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPCIER_ENDRX(value uint32) {
	volatile.StoreUint32(&o.PCIER.Reg, volatile.LoadUint32(&o.PCIER.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPCIER_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.PCIER.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPCIER_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.PCIER.Reg, volatile.LoadUint32(&o.PCIER.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPCIER_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.PCIER.Reg) & 0x8) >> 3
}

// PIO.PCIDR: Parallel Capture Interrupt Disable Register
func (o *PIO_Type) SetPCIDR_DRDY(value uint32) {
	volatile.StoreUint32(&o.PCIDR.Reg, volatile.LoadUint32(&o.PCIDR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPCIDR_DRDY() uint32 {
	return volatile.LoadUint32(&o.PCIDR.Reg) & 0x1
}
func (o *PIO_Type) SetPCIDR_OVRE(value uint32) {
	volatile.StoreUint32(&o.PCIDR.Reg, volatile.LoadUint32(&o.PCIDR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPCIDR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.PCIDR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPCIDR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.PCIDR.Reg, volatile.LoadUint32(&o.PCIDR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPCIDR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.PCIDR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPCIDR_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.PCIDR.Reg, volatile.LoadUint32(&o.PCIDR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPCIDR_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.PCIDR.Reg) & 0x8) >> 3
}

// PIO.PCIMR: Parallel Capture Interrupt Mask Register
func (o *PIO_Type) SetPCIMR_DRDY(value uint32) {
	volatile.StoreUint32(&o.PCIMR.Reg, volatile.LoadUint32(&o.PCIMR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPCIMR_DRDY() uint32 {
	return volatile.LoadUint32(&o.PCIMR.Reg) & 0x1
}
func (o *PIO_Type) SetPCIMR_OVRE(value uint32) {
	volatile.StoreUint32(&o.PCIMR.Reg, volatile.LoadUint32(&o.PCIMR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPCIMR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.PCIMR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPCIMR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.PCIMR.Reg, volatile.LoadUint32(&o.PCIMR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPCIMR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.PCIMR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPCIMR_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.PCIMR.Reg, volatile.LoadUint32(&o.PCIMR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPCIMR_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.PCIMR.Reg) & 0x8) >> 3
}

// PIO.PCISR: Parallel Capture Interrupt Status Register
func (o *PIO_Type) SetPCISR_DRDY(value uint32) {
	volatile.StoreUint32(&o.PCISR.Reg, volatile.LoadUint32(&o.PCISR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPCISR_DRDY() uint32 {
	return volatile.LoadUint32(&o.PCISR.Reg) & 0x1
}
func (o *PIO_Type) SetPCISR_OVRE(value uint32) {
	volatile.StoreUint32(&o.PCISR.Reg, volatile.LoadUint32(&o.PCISR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPCISR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.PCISR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPCISR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.PCISR.Reg, volatile.LoadUint32(&o.PCISR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPCISR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.PCISR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPCISR_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.PCISR.Reg, volatile.LoadUint32(&o.PCISR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPCISR_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.PCISR.Reg) & 0x8) >> 3
}

// PIO.PCRHR: Parallel Capture Reception Holding Register
func (o *PIO_Type) SetPCRHR(value uint32) {
	volatile.StoreUint32(&o.PCRHR.Reg, value)
}
func (o *PIO_Type) GetPCRHR() uint32 {
	return volatile.LoadUint32(&o.PCRHR.Reg)
}

// PIO.RPR: Receive Pointer Register
func (o *PIO_Type) SetRPR(value uint32) {
	volatile.StoreUint32(&o.RPR.Reg, value)
}
func (o *PIO_Type) GetRPR() uint32 {
	return volatile.LoadUint32(&o.RPR.Reg)
}

// PIO.RCR: Receive Counter Register
func (o *PIO_Type) SetRCR_RXCTR(value uint32) {
	volatile.StoreUint32(&o.RCR.Reg, volatile.LoadUint32(&o.RCR.Reg)&^(0xffff)|value)
}
func (o *PIO_Type) GetRCR_RXCTR() uint32 {
	return volatile.LoadUint32(&o.RCR.Reg) & 0xffff
}

// PIO.RNPR: Receive Next Pointer Register
func (o *PIO_Type) SetRNPR(value uint32) {
	volatile.StoreUint32(&o.RNPR.Reg, value)
}
func (o *PIO_Type) GetRNPR() uint32 {
	return volatile.LoadUint32(&o.RNPR.Reg)
}

// PIO.RNCR: Receive Next Counter Register
func (o *PIO_Type) SetRNCR_RXNCTR(value uint32) {
	volatile.StoreUint32(&o.RNCR.Reg, volatile.LoadUint32(&o.RNCR.Reg)&^(0xffff)|value)
}
func (o *PIO_Type) GetRNCR_RXNCTR() uint32 {
	return volatile.LoadUint32(&o.RNCR.Reg) & 0xffff
}

// PIO.PTCR: Transfer Control Register
func (o *PIO_Type) SetPTCR_RXTEN(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPTCR_RXTEN() uint32 {
	return volatile.LoadUint32(&o.PTCR.Reg) & 0x1
}
func (o *PIO_Type) SetPTCR_RXTDIS(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPTCR_RXTDIS() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPTCR_TXTEN(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPTCR_TXTEN() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPTCR_TXTDIS(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPTCR_TXTDIS() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x200) >> 9
}

// PIO.PTSR: Transfer Status Register
func (o *PIO_Type) SetPTSR_RXTEN(value uint32) {
	volatile.StoreUint32(&o.PTSR.Reg, volatile.LoadUint32(&o.PTSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPTSR_RXTEN() uint32 {
	return volatile.LoadUint32(&o.PTSR.Reg) & 0x1
}
func (o *PIO_Type) SetPTSR_TXTEN(value uint32) {
	volatile.StoreUint32(&o.PTSR.Reg, volatile.LoadUint32(&o.PTSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPTSR_TXTEN() uint32 {
	return (volatile.LoadUint32(&o.PTSR.Reg) & 0x100) >> 8
}

// Reset Controller
type SYSC_Type struct {
	CR volatile.Register32 // 0x0
	SR volatile.Register32 // 0x4
	MR volatile.Register32 // 0x8
}

// SYSC.CR: Control Register
func (o *SYSC_Type) SetCR_PROCRST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *SYSC_Type) GetCR_PROCRST() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *SYSC_Type) SetCR_PERRST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *SYSC_Type) GetCR_PERRST() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *SYSC_Type) SetCR_EXTRST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *SYSC_Type) GetCR_EXTRST() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *SYSC_Type) SetCR_KEY(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xff000000)|value<<24)
}
func (o *SYSC_Type) GetCR_KEY() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xff000000) >> 24
}

// SYSC.SR: Status Register
func (o *SYSC_Type) SetSR_URSTS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *SYSC_Type) GetSR_URSTS() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *SYSC_Type) SetSR_RSTTYP(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x700)|value<<8)
}
func (o *SYSC_Type) GetSR_RSTTYP() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x700) >> 8
}
func (o *SYSC_Type) SetSR_NRSTL(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10000)|value<<16)
}
func (o *SYSC_Type) GetSR_NRSTL() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10000) >> 16
}
func (o *SYSC_Type) SetSR_SRCMP(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20000)|value<<17)
}
func (o *SYSC_Type) GetSR_SRCMP() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20000) >> 17
}

// SYSC.MR: Mode Register
func (o *SYSC_Type) SetMR_URSTEN(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x1)|value)
}
func (o *SYSC_Type) GetMR_URSTEN() uint32 {
	return volatile.LoadUint32(&o.MR.Reg) & 0x1
}
func (o *SYSC_Type) SetMR_URSTIEN(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x10)|value<<4)
}
func (o *SYSC_Type) GetMR_URSTIEN() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x10) >> 4
}
func (o *SYSC_Type) SetMR_ERSTL(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xf00)|value<<8)
}
func (o *SYSC_Type) GetMR_ERSTL() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xf00) >> 8
}
func (o *SYSC_Type) SetMR_KEY(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xff000000)|value<<24)
}
func (o *SYSC_Type) GetMR_KEY() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xff000000) >> 24
}

// Constants for HSMCI: High Speed MultiMedia Card Interface
const (
	// CR: Control Register
	// Position of MCIEN field.
	HSMCI_CR_MCIEN_Pos = 0x0
	// Bit mask of MCIEN field.
	HSMCI_CR_MCIEN_Msk = 0x1
	// Bit MCIEN.
	HSMCI_CR_MCIEN = 0x1
	// Position of MCIDIS field.
	HSMCI_CR_MCIDIS_Pos = 0x1
	// Bit mask of MCIDIS field.
	HSMCI_CR_MCIDIS_Msk = 0x2
	// Bit MCIDIS.
	HSMCI_CR_MCIDIS = 0x2
	// Position of PWSEN field.
	HSMCI_CR_PWSEN_Pos = 0x2
	// Bit mask of PWSEN field.
	HSMCI_CR_PWSEN_Msk = 0x4
	// Bit PWSEN.
	HSMCI_CR_PWSEN = 0x4
	// Position of PWSDIS field.
	HSMCI_CR_PWSDIS_Pos = 0x3
	// Bit mask of PWSDIS field.
	HSMCI_CR_PWSDIS_Msk = 0x8
	// Bit PWSDIS.
	HSMCI_CR_PWSDIS = 0x8
	// Position of SWRST field.
	HSMCI_CR_SWRST_Pos = 0x7
	// Bit mask of SWRST field.
	HSMCI_CR_SWRST_Msk = 0x80
	// Bit SWRST.
	HSMCI_CR_SWRST = 0x80

	// MR: Mode Register
	// Position of CLKDIV field.
	HSMCI_MR_CLKDIV_Pos = 0x0
	// Bit mask of CLKDIV field.
	HSMCI_MR_CLKDIV_Msk = 0xff
	// Position of PWSDIV field.
	HSMCI_MR_PWSDIV_Pos = 0x8
	// Bit mask of PWSDIV field.
	HSMCI_MR_PWSDIV_Msk = 0x700
	// Position of RDPROOF field.
	HSMCI_MR_RDPROOF_Pos = 0xb
	// Bit mask of RDPROOF field.
	HSMCI_MR_RDPROOF_Msk = 0x800
	// Bit RDPROOF.
	HSMCI_MR_RDPROOF = 0x800
	// Position of WRPROOF field.
	HSMCI_MR_WRPROOF_Pos = 0xc
	// Bit mask of WRPROOF field.
	HSMCI_MR_WRPROOF_Msk = 0x1000
	// Bit WRPROOF.
	HSMCI_MR_WRPROOF = 0x1000
	// Position of FBYTE field.
	HSMCI_MR_FBYTE_Pos = 0xd
	// Bit mask of FBYTE field.
	HSMCI_MR_FBYTE_Msk = 0x2000
	// Bit FBYTE.
	HSMCI_MR_FBYTE = 0x2000
	// Position of PADV field.
	HSMCI_MR_PADV_Pos = 0xe
	// Bit mask of PADV field.
	HSMCI_MR_PADV_Msk = 0x4000
	// Bit PADV.
	HSMCI_MR_PADV = 0x4000
	// Position of PDCMODE field.
	HSMCI_MR_PDCMODE_Pos = 0xf
	// Bit mask of PDCMODE field.
	HSMCI_MR_PDCMODE_Msk = 0x8000
	// Bit PDCMODE.
	HSMCI_MR_PDCMODE = 0x8000

	// DTOR: Data Timeout Register
	// Position of DTOCYC field.
	HSMCI_DTOR_DTOCYC_Pos = 0x0
	// Bit mask of DTOCYC field.
	HSMCI_DTOR_DTOCYC_Msk = 0xf
	// Position of DTOMUL field.
	HSMCI_DTOR_DTOMUL_Pos = 0x4
	// Bit mask of DTOMUL field.
	HSMCI_DTOR_DTOMUL_Msk = 0x70
	// DTOCYC
	HSMCI_DTOR_DTOMUL_1 = 0x0
	// DTOCYC x 16
	HSMCI_DTOR_DTOMUL_16 = 0x1
	// DTOCYC x 128
	HSMCI_DTOR_DTOMUL_128 = 0x2
	// DTOCYC x 256
	HSMCI_DTOR_DTOMUL_256 = 0x3
	// DTOCYC x 1024
	HSMCI_DTOR_DTOMUL_1024 = 0x4
	// DTOCYC x 4096
	HSMCI_DTOR_DTOMUL_4096 = 0x5
	// DTOCYC x 65536
	HSMCI_DTOR_DTOMUL_65536 = 0x6
	// DTOCYC x 1048576
	HSMCI_DTOR_DTOMUL_1048576 = 0x7

	// SDCR: SD/SDIO Card Register
	// Position of SDCSEL field.
	HSMCI_SDCR_SDCSEL_Pos = 0x0
	// Bit mask of SDCSEL field.
	HSMCI_SDCR_SDCSEL_Msk = 0x3
	// Slot A is selected.
	HSMCI_SDCR_SDCSEL_SLOTA = 0x0
	// -
	HSMCI_SDCR_SDCSEL_SLOTB = 0x1
	// -
	HSMCI_SDCR_SDCSEL_SLOTC = 0x2
	// -
	HSMCI_SDCR_SDCSEL_SLOTD = 0x3
	// Position of SDCBUS field.
	HSMCI_SDCR_SDCBUS_Pos = 0x6
	// Bit mask of SDCBUS field.
	HSMCI_SDCR_SDCBUS_Msk = 0xc0
	// 1 bit
	HSMCI_SDCR_SDCBUS_1 = 0x0
	// 4 bits
	HSMCI_SDCR_SDCBUS_4 = 0x2
	// 8 bits
	HSMCI_SDCR_SDCBUS_8 = 0x3

	// ARGR: Argument Register
	// Position of ARG field.
	HSMCI_ARGR_ARG_Pos = 0x0
	// Bit mask of ARG field.
	HSMCI_ARGR_ARG_Msk = 0xffffffff

	// CMDR: Command Register
	// Position of CMDNB field.
	HSMCI_CMDR_CMDNB_Pos = 0x0
	// Bit mask of CMDNB field.
	HSMCI_CMDR_CMDNB_Msk = 0x3f
	// Position of RSPTYP field.
	HSMCI_CMDR_RSPTYP_Pos = 0x6
	// Bit mask of RSPTYP field.
	HSMCI_CMDR_RSPTYP_Msk = 0xc0
	// No response
	HSMCI_CMDR_RSPTYP_NORESP = 0x0
	// 48-bit response
	HSMCI_CMDR_RSPTYP_48_BIT = 0x1
	// 136-bit response
	HSMCI_CMDR_RSPTYP_136_BIT = 0x2
	// R1b response type
	HSMCI_CMDR_RSPTYP_R1B = 0x3
	// Position of SPCMD field.
	HSMCI_CMDR_SPCMD_Pos = 0x8
	// Bit mask of SPCMD field.
	HSMCI_CMDR_SPCMD_Msk = 0x700
	// Not a special CMD.
	HSMCI_CMDR_SPCMD_STD = 0x0
	// Initialization CMD: 74 clock cycles for initialization sequence.
	HSMCI_CMDR_SPCMD_INIT = 0x1
	// Synchronized CMD: Wait for the end of the current data block transfer before sending the pending command.
	HSMCI_CMDR_SPCMD_SYNC = 0x2
	// CE-ATA Completion Signal disable Command. The host cancels the ability for the device to return a command completion signal on the command line.
	HSMCI_CMDR_SPCMD_CE_ATA = 0x3
	// Interrupt command: Corresponds to the Interrupt Mode (CMD40).
	HSMCI_CMDR_SPCMD_IT_CMD = 0x4
	// Interrupt response: Corresponds to the Interrupt Mode (CMD40).
	HSMCI_CMDR_SPCMD_IT_RESP = 0x5
	// Boot Operation Request. Start a boot operation mode, the host processor can read boot data from the MMC device directly.
	HSMCI_CMDR_SPCMD_BOR = 0x6
	// End Boot Operation. This command allows the host processor to terminate the boot operation mode.
	HSMCI_CMDR_SPCMD_EBO = 0x7
	// Position of OPDCMD field.
	HSMCI_CMDR_OPDCMD_Pos = 0xb
	// Bit mask of OPDCMD field.
	HSMCI_CMDR_OPDCMD_Msk = 0x800
	// Bit OPDCMD.
	HSMCI_CMDR_OPDCMD = 0x800
	// Push pull command.
	HSMCI_CMDR_OPDCMD_PUSHPULL = 0x0
	// Open drain command.
	HSMCI_CMDR_OPDCMD_OPENDRAIN = 0x1
	// Position of MAXLAT field.
	HSMCI_CMDR_MAXLAT_Pos = 0xc
	// Bit mask of MAXLAT field.
	HSMCI_CMDR_MAXLAT_Msk = 0x1000
	// Bit MAXLAT.
	HSMCI_CMDR_MAXLAT = 0x1000
	// 5-cycle max latency.
	HSMCI_CMDR_MAXLAT_5 = 0x0
	// 64-cycle max latency.
	HSMCI_CMDR_MAXLAT_64 = 0x1
	// Position of TRCMD field.
	HSMCI_CMDR_TRCMD_Pos = 0x10
	// Bit mask of TRCMD field.
	HSMCI_CMDR_TRCMD_Msk = 0x30000
	// No data transfer
	HSMCI_CMDR_TRCMD_NO_DATA = 0x0
	// Start data transfer
	HSMCI_CMDR_TRCMD_START_DATA = 0x1
	// Stop data transfer
	HSMCI_CMDR_TRCMD_STOP_DATA = 0x2
	// Position of TRDIR field.
	HSMCI_CMDR_TRDIR_Pos = 0x12
	// Bit mask of TRDIR field.
	HSMCI_CMDR_TRDIR_Msk = 0x40000
	// Bit TRDIR.
	HSMCI_CMDR_TRDIR = 0x40000
	// Write.
	HSMCI_CMDR_TRDIR_WRITE = 0x0
	// Read.
	HSMCI_CMDR_TRDIR_READ = 0x1
	// Position of TRTYP field.
	HSMCI_CMDR_TRTYP_Pos = 0x13
	// Bit mask of TRTYP field.
	HSMCI_CMDR_TRTYP_Msk = 0x380000
	// MMC/SD Card Single Block
	HSMCI_CMDR_TRTYP_SINGLE = 0x0
	// MMC/SD Card Multiple Block
	HSMCI_CMDR_TRTYP_MULTIPLE = 0x1
	// MMC Stream
	HSMCI_CMDR_TRTYP_STREAM = 0x2
	// SDIO Byte
	HSMCI_CMDR_TRTYP_BYTE = 0x4
	// SDIO Block
	HSMCI_CMDR_TRTYP_BLOCK = 0x5
	// Position of IOSPCMD field.
	HSMCI_CMDR_IOSPCMD_Pos = 0x18
	// Bit mask of IOSPCMD field.
	HSMCI_CMDR_IOSPCMD_Msk = 0x3000000
	// Not an SDIO Special Command
	HSMCI_CMDR_IOSPCMD_STD = 0x0
	// SDIO Suspend Command
	HSMCI_CMDR_IOSPCMD_SUSPEND = 0x1
	// SDIO Resume Command
	HSMCI_CMDR_IOSPCMD_RESUME = 0x2
	// Position of ATACS field.
	HSMCI_CMDR_ATACS_Pos = 0x1a
	// Bit mask of ATACS field.
	HSMCI_CMDR_ATACS_Msk = 0x4000000
	// Bit ATACS.
	HSMCI_CMDR_ATACS = 0x4000000
	// Normal operation mode.
	HSMCI_CMDR_ATACS_NORMAL = 0x0
	// This bit indicates that a completion signal is expected within a programmed amount of time (HSMCI_CSTOR).
	HSMCI_CMDR_ATACS_COMPLETION = 0x1
	// Position of BOOT_ACK field.
	HSMCI_CMDR_BOOT_ACK_Pos = 0x1b
	// Bit mask of BOOT_ACK field.
	HSMCI_CMDR_BOOT_ACK_Msk = 0x8000000
	// Bit BOOT_ACK.
	HSMCI_CMDR_BOOT_ACK = 0x8000000

	// BLKR: Block Register
	// Position of BCNT field.
	HSMCI_BLKR_BCNT_Pos = 0x0
	// Bit mask of BCNT field.
	HSMCI_BLKR_BCNT_Msk = 0xffff
	// Position of BLKLEN field.
	HSMCI_BLKR_BLKLEN_Pos = 0x10
	// Bit mask of BLKLEN field.
	HSMCI_BLKR_BLKLEN_Msk = 0xffff0000

	// CSTOR: Completion Signal Timeout Register
	// Position of CSTOCYC field.
	HSMCI_CSTOR_CSTOCYC_Pos = 0x0
	// Bit mask of CSTOCYC field.
	HSMCI_CSTOR_CSTOCYC_Msk = 0xf
	// Position of CSTOMUL field.
	HSMCI_CSTOR_CSTOMUL_Pos = 0x4
	// Bit mask of CSTOMUL field.
	HSMCI_CSTOR_CSTOMUL_Msk = 0x70
	// CSTOCYC x 1
	HSMCI_CSTOR_CSTOMUL_1 = 0x0
	// CSTOCYC x 16
	HSMCI_CSTOR_CSTOMUL_16 = 0x1
	// CSTOCYC x 128
	HSMCI_CSTOR_CSTOMUL_128 = 0x2
	// CSTOCYC x 256
	HSMCI_CSTOR_CSTOMUL_256 = 0x3
	// CSTOCYC x 1024
	HSMCI_CSTOR_CSTOMUL_1024 = 0x4
	// CSTOCYC x 4096
	HSMCI_CSTOR_CSTOMUL_4096 = 0x5
	// CSTOCYC x 65536
	HSMCI_CSTOR_CSTOMUL_65536 = 0x6
	// CSTOCYC x 1048576
	HSMCI_CSTOR_CSTOMUL_1048576 = 0x7

	// RSPR: Response Register
	// Position of RSP field.
	HSMCI_RSPR_RSP_Pos = 0x0
	// Bit mask of RSP field.
	HSMCI_RSPR_RSP_Msk = 0xffffffff

	// RDR: Receive Data Register
	// Position of DATA field.
	HSMCI_RDR_DATA_Pos = 0x0
	// Bit mask of DATA field.
	HSMCI_RDR_DATA_Msk = 0xffffffff

	// TDR: Transmit Data Register
	// Position of DATA field.
	HSMCI_TDR_DATA_Pos = 0x0
	// Bit mask of DATA field.
	HSMCI_TDR_DATA_Msk = 0xffffffff

	// SR: Status Register
	// Position of CMDRDY field.
	HSMCI_SR_CMDRDY_Pos = 0x0
	// Bit mask of CMDRDY field.
	HSMCI_SR_CMDRDY_Msk = 0x1
	// Bit CMDRDY.
	HSMCI_SR_CMDRDY = 0x1
	// Position of RXRDY field.
	HSMCI_SR_RXRDY_Pos = 0x1
	// Bit mask of RXRDY field.
	HSMCI_SR_RXRDY_Msk = 0x2
	// Bit RXRDY.
	HSMCI_SR_RXRDY = 0x2
	// Position of TXRDY field.
	HSMCI_SR_TXRDY_Pos = 0x2
	// Bit mask of TXRDY field.
	HSMCI_SR_TXRDY_Msk = 0x4
	// Bit TXRDY.
	HSMCI_SR_TXRDY = 0x4
	// Position of BLKE field.
	HSMCI_SR_BLKE_Pos = 0x3
	// Bit mask of BLKE field.
	HSMCI_SR_BLKE_Msk = 0x8
	// Bit BLKE.
	HSMCI_SR_BLKE = 0x8
	// Position of DTIP field.
	HSMCI_SR_DTIP_Pos = 0x4
	// Bit mask of DTIP field.
	HSMCI_SR_DTIP_Msk = 0x10
	// Bit DTIP.
	HSMCI_SR_DTIP = 0x10
	// Position of NOTBUSY field.
	HSMCI_SR_NOTBUSY_Pos = 0x5
	// Bit mask of NOTBUSY field.
	HSMCI_SR_NOTBUSY_Msk = 0x20
	// Bit NOTBUSY.
	HSMCI_SR_NOTBUSY = 0x20
	// Position of ENDRX field.
	HSMCI_SR_ENDRX_Pos = 0x6
	// Bit mask of ENDRX field.
	HSMCI_SR_ENDRX_Msk = 0x40
	// Bit ENDRX.
	HSMCI_SR_ENDRX = 0x40
	// Position of ENDTX field.
	HSMCI_SR_ENDTX_Pos = 0x7
	// Bit mask of ENDTX field.
	HSMCI_SR_ENDTX_Msk = 0x80
	// Bit ENDTX.
	HSMCI_SR_ENDTX = 0x80
	// Position of SDIOIRQA field.
	HSMCI_SR_SDIOIRQA_Pos = 0x8
	// Bit mask of SDIOIRQA field.
	HSMCI_SR_SDIOIRQA_Msk = 0x100
	// Bit SDIOIRQA.
	HSMCI_SR_SDIOIRQA = 0x100
	// Position of SDIOWAIT field.
	HSMCI_SR_SDIOWAIT_Pos = 0xc
	// Bit mask of SDIOWAIT field.
	HSMCI_SR_SDIOWAIT_Msk = 0x1000
	// Bit SDIOWAIT.
	HSMCI_SR_SDIOWAIT = 0x1000
	// Position of CSRCV field.
	HSMCI_SR_CSRCV_Pos = 0xd
	// Bit mask of CSRCV field.
	HSMCI_SR_CSRCV_Msk = 0x2000
	// Bit CSRCV.
	HSMCI_SR_CSRCV = 0x2000
	// Position of RXBUFF field.
	HSMCI_SR_RXBUFF_Pos = 0xe
	// Bit mask of RXBUFF field.
	HSMCI_SR_RXBUFF_Msk = 0x4000
	// Bit RXBUFF.
	HSMCI_SR_RXBUFF = 0x4000
	// Position of TXBUFE field.
	HSMCI_SR_TXBUFE_Pos = 0xf
	// Bit mask of TXBUFE field.
	HSMCI_SR_TXBUFE_Msk = 0x8000
	// Bit TXBUFE.
	HSMCI_SR_TXBUFE = 0x8000
	// Position of RINDE field.
	HSMCI_SR_RINDE_Pos = 0x10
	// Bit mask of RINDE field.
	HSMCI_SR_RINDE_Msk = 0x10000
	// Bit RINDE.
	HSMCI_SR_RINDE = 0x10000
	// Position of RDIRE field.
	HSMCI_SR_RDIRE_Pos = 0x11
	// Bit mask of RDIRE field.
	HSMCI_SR_RDIRE_Msk = 0x20000
	// Bit RDIRE.
	HSMCI_SR_RDIRE = 0x20000
	// Position of RCRCE field.
	HSMCI_SR_RCRCE_Pos = 0x12
	// Bit mask of RCRCE field.
	HSMCI_SR_RCRCE_Msk = 0x40000
	// Bit RCRCE.
	HSMCI_SR_RCRCE = 0x40000
	// Position of RENDE field.
	HSMCI_SR_RENDE_Pos = 0x13
	// Bit mask of RENDE field.
	HSMCI_SR_RENDE_Msk = 0x80000
	// Bit RENDE.
	HSMCI_SR_RENDE = 0x80000
	// Position of RTOE field.
	HSMCI_SR_RTOE_Pos = 0x14
	// Bit mask of RTOE field.
	HSMCI_SR_RTOE_Msk = 0x100000
	// Bit RTOE.
	HSMCI_SR_RTOE = 0x100000
	// Position of DCRCE field.
	HSMCI_SR_DCRCE_Pos = 0x15
	// Bit mask of DCRCE field.
	HSMCI_SR_DCRCE_Msk = 0x200000
	// Bit DCRCE.
	HSMCI_SR_DCRCE = 0x200000
	// Position of DTOE field.
	HSMCI_SR_DTOE_Pos = 0x16
	// Bit mask of DTOE field.
	HSMCI_SR_DTOE_Msk = 0x400000
	// Bit DTOE.
	HSMCI_SR_DTOE = 0x400000
	// Position of CSTOE field.
	HSMCI_SR_CSTOE_Pos = 0x17
	// Bit mask of CSTOE field.
	HSMCI_SR_CSTOE_Msk = 0x800000
	// Bit CSTOE.
	HSMCI_SR_CSTOE = 0x800000
	// Position of FIFOEMPTY field.
	HSMCI_SR_FIFOEMPTY_Pos = 0x1a
	// Bit mask of FIFOEMPTY field.
	HSMCI_SR_FIFOEMPTY_Msk = 0x4000000
	// Bit FIFOEMPTY.
	HSMCI_SR_FIFOEMPTY = 0x4000000
	// Position of XFRDONE field.
	HSMCI_SR_XFRDONE_Pos = 0x1b
	// Bit mask of XFRDONE field.
	HSMCI_SR_XFRDONE_Msk = 0x8000000
	// Bit XFRDONE.
	HSMCI_SR_XFRDONE = 0x8000000
	// Position of ACKRCV field.
	HSMCI_SR_ACKRCV_Pos = 0x1c
	// Bit mask of ACKRCV field.
	HSMCI_SR_ACKRCV_Msk = 0x10000000
	// Bit ACKRCV.
	HSMCI_SR_ACKRCV = 0x10000000
	// Position of ACKRCVE field.
	HSMCI_SR_ACKRCVE_Pos = 0x1d
	// Bit mask of ACKRCVE field.
	HSMCI_SR_ACKRCVE_Msk = 0x20000000
	// Bit ACKRCVE.
	HSMCI_SR_ACKRCVE = 0x20000000
	// Position of OVRE field.
	HSMCI_SR_OVRE_Pos = 0x1e
	// Bit mask of OVRE field.
	HSMCI_SR_OVRE_Msk = 0x40000000
	// Bit OVRE.
	HSMCI_SR_OVRE = 0x40000000
	// Position of UNRE field.
	HSMCI_SR_UNRE_Pos = 0x1f
	// Bit mask of UNRE field.
	HSMCI_SR_UNRE_Msk = 0x80000000
	// Bit UNRE.
	HSMCI_SR_UNRE = 0x80000000

	// IER: Interrupt Enable Register
	// Position of CMDRDY field.
	HSMCI_IER_CMDRDY_Pos = 0x0
	// Bit mask of CMDRDY field.
	HSMCI_IER_CMDRDY_Msk = 0x1
	// Bit CMDRDY.
	HSMCI_IER_CMDRDY = 0x1
	// Position of RXRDY field.
	HSMCI_IER_RXRDY_Pos = 0x1
	// Bit mask of RXRDY field.
	HSMCI_IER_RXRDY_Msk = 0x2
	// Bit RXRDY.
	HSMCI_IER_RXRDY = 0x2
	// Position of TXRDY field.
	HSMCI_IER_TXRDY_Pos = 0x2
	// Bit mask of TXRDY field.
	HSMCI_IER_TXRDY_Msk = 0x4
	// Bit TXRDY.
	HSMCI_IER_TXRDY = 0x4
	// Position of BLKE field.
	HSMCI_IER_BLKE_Pos = 0x3
	// Bit mask of BLKE field.
	HSMCI_IER_BLKE_Msk = 0x8
	// Bit BLKE.
	HSMCI_IER_BLKE = 0x8
	// Position of DTIP field.
	HSMCI_IER_DTIP_Pos = 0x4
	// Bit mask of DTIP field.
	HSMCI_IER_DTIP_Msk = 0x10
	// Bit DTIP.
	HSMCI_IER_DTIP = 0x10
	// Position of NOTBUSY field.
	HSMCI_IER_NOTBUSY_Pos = 0x5
	// Bit mask of NOTBUSY field.
	HSMCI_IER_NOTBUSY_Msk = 0x20
	// Bit NOTBUSY.
	HSMCI_IER_NOTBUSY = 0x20
	// Position of ENDRX field.
	HSMCI_IER_ENDRX_Pos = 0x6
	// Bit mask of ENDRX field.
	HSMCI_IER_ENDRX_Msk = 0x40
	// Bit ENDRX.
	HSMCI_IER_ENDRX = 0x40
	// Position of ENDTX field.
	HSMCI_IER_ENDTX_Pos = 0x7
	// Bit mask of ENDTX field.
	HSMCI_IER_ENDTX_Msk = 0x80
	// Bit ENDTX.
	HSMCI_IER_ENDTX = 0x80
	// Position of SDIOIRQA field.
	HSMCI_IER_SDIOIRQA_Pos = 0x8
	// Bit mask of SDIOIRQA field.
	HSMCI_IER_SDIOIRQA_Msk = 0x100
	// Bit SDIOIRQA.
	HSMCI_IER_SDIOIRQA = 0x100
	// Position of SDIOWAIT field.
	HSMCI_IER_SDIOWAIT_Pos = 0xc
	// Bit mask of SDIOWAIT field.
	HSMCI_IER_SDIOWAIT_Msk = 0x1000
	// Bit SDIOWAIT.
	HSMCI_IER_SDIOWAIT = 0x1000
	// Position of CSRCV field.
	HSMCI_IER_CSRCV_Pos = 0xd
	// Bit mask of CSRCV field.
	HSMCI_IER_CSRCV_Msk = 0x2000
	// Bit CSRCV.
	HSMCI_IER_CSRCV = 0x2000
	// Position of RXBUFF field.
	HSMCI_IER_RXBUFF_Pos = 0xe
	// Bit mask of RXBUFF field.
	HSMCI_IER_RXBUFF_Msk = 0x4000
	// Bit RXBUFF.
	HSMCI_IER_RXBUFF = 0x4000
	// Position of TXBUFE field.
	HSMCI_IER_TXBUFE_Pos = 0xf
	// Bit mask of TXBUFE field.
	HSMCI_IER_TXBUFE_Msk = 0x8000
	// Bit TXBUFE.
	HSMCI_IER_TXBUFE = 0x8000
	// Position of RINDE field.
	HSMCI_IER_RINDE_Pos = 0x10
	// Bit mask of RINDE field.
	HSMCI_IER_RINDE_Msk = 0x10000
	// Bit RINDE.
	HSMCI_IER_RINDE = 0x10000
	// Position of RDIRE field.
	HSMCI_IER_RDIRE_Pos = 0x11
	// Bit mask of RDIRE field.
	HSMCI_IER_RDIRE_Msk = 0x20000
	// Bit RDIRE.
	HSMCI_IER_RDIRE = 0x20000
	// Position of RCRCE field.
	HSMCI_IER_RCRCE_Pos = 0x12
	// Bit mask of RCRCE field.
	HSMCI_IER_RCRCE_Msk = 0x40000
	// Bit RCRCE.
	HSMCI_IER_RCRCE = 0x40000
	// Position of RENDE field.
	HSMCI_IER_RENDE_Pos = 0x13
	// Bit mask of RENDE field.
	HSMCI_IER_RENDE_Msk = 0x80000
	// Bit RENDE.
	HSMCI_IER_RENDE = 0x80000
	// Position of RTOE field.
	HSMCI_IER_RTOE_Pos = 0x14
	// Bit mask of RTOE field.
	HSMCI_IER_RTOE_Msk = 0x100000
	// Bit RTOE.
	HSMCI_IER_RTOE = 0x100000
	// Position of DCRCE field.
	HSMCI_IER_DCRCE_Pos = 0x15
	// Bit mask of DCRCE field.
	HSMCI_IER_DCRCE_Msk = 0x200000
	// Bit DCRCE.
	HSMCI_IER_DCRCE = 0x200000
	// Position of DTOE field.
	HSMCI_IER_DTOE_Pos = 0x16
	// Bit mask of DTOE field.
	HSMCI_IER_DTOE_Msk = 0x400000
	// Bit DTOE.
	HSMCI_IER_DTOE = 0x400000
	// Position of CSTOE field.
	HSMCI_IER_CSTOE_Pos = 0x17
	// Bit mask of CSTOE field.
	HSMCI_IER_CSTOE_Msk = 0x800000
	// Bit CSTOE.
	HSMCI_IER_CSTOE = 0x800000
	// Position of FIFOEMPTY field.
	HSMCI_IER_FIFOEMPTY_Pos = 0x1a
	// Bit mask of FIFOEMPTY field.
	HSMCI_IER_FIFOEMPTY_Msk = 0x4000000
	// Bit FIFOEMPTY.
	HSMCI_IER_FIFOEMPTY = 0x4000000
	// Position of XFRDONE field.
	HSMCI_IER_XFRDONE_Pos = 0x1b
	// Bit mask of XFRDONE field.
	HSMCI_IER_XFRDONE_Msk = 0x8000000
	// Bit XFRDONE.
	HSMCI_IER_XFRDONE = 0x8000000
	// Position of ACKRCV field.
	HSMCI_IER_ACKRCV_Pos = 0x1c
	// Bit mask of ACKRCV field.
	HSMCI_IER_ACKRCV_Msk = 0x10000000
	// Bit ACKRCV.
	HSMCI_IER_ACKRCV = 0x10000000
	// Position of ACKRCVE field.
	HSMCI_IER_ACKRCVE_Pos = 0x1d
	// Bit mask of ACKRCVE field.
	HSMCI_IER_ACKRCVE_Msk = 0x20000000
	// Bit ACKRCVE.
	HSMCI_IER_ACKRCVE = 0x20000000
	// Position of OVRE field.
	HSMCI_IER_OVRE_Pos = 0x1e
	// Bit mask of OVRE field.
	HSMCI_IER_OVRE_Msk = 0x40000000
	// Bit OVRE.
	HSMCI_IER_OVRE = 0x40000000
	// Position of UNRE field.
	HSMCI_IER_UNRE_Pos = 0x1f
	// Bit mask of UNRE field.
	HSMCI_IER_UNRE_Msk = 0x80000000
	// Bit UNRE.
	HSMCI_IER_UNRE = 0x80000000

	// IDR: Interrupt Disable Register
	// Position of CMDRDY field.
	HSMCI_IDR_CMDRDY_Pos = 0x0
	// Bit mask of CMDRDY field.
	HSMCI_IDR_CMDRDY_Msk = 0x1
	// Bit CMDRDY.
	HSMCI_IDR_CMDRDY = 0x1
	// Position of RXRDY field.
	HSMCI_IDR_RXRDY_Pos = 0x1
	// Bit mask of RXRDY field.
	HSMCI_IDR_RXRDY_Msk = 0x2
	// Bit RXRDY.
	HSMCI_IDR_RXRDY = 0x2
	// Position of TXRDY field.
	HSMCI_IDR_TXRDY_Pos = 0x2
	// Bit mask of TXRDY field.
	HSMCI_IDR_TXRDY_Msk = 0x4
	// Bit TXRDY.
	HSMCI_IDR_TXRDY = 0x4
	// Position of BLKE field.
	HSMCI_IDR_BLKE_Pos = 0x3
	// Bit mask of BLKE field.
	HSMCI_IDR_BLKE_Msk = 0x8
	// Bit BLKE.
	HSMCI_IDR_BLKE = 0x8
	// Position of DTIP field.
	HSMCI_IDR_DTIP_Pos = 0x4
	// Bit mask of DTIP field.
	HSMCI_IDR_DTIP_Msk = 0x10
	// Bit DTIP.
	HSMCI_IDR_DTIP = 0x10
	// Position of NOTBUSY field.
	HSMCI_IDR_NOTBUSY_Pos = 0x5
	// Bit mask of NOTBUSY field.
	HSMCI_IDR_NOTBUSY_Msk = 0x20
	// Bit NOTBUSY.
	HSMCI_IDR_NOTBUSY = 0x20
	// Position of ENDRX field.
	HSMCI_IDR_ENDRX_Pos = 0x6
	// Bit mask of ENDRX field.
	HSMCI_IDR_ENDRX_Msk = 0x40
	// Bit ENDRX.
	HSMCI_IDR_ENDRX = 0x40
	// Position of ENDTX field.
	HSMCI_IDR_ENDTX_Pos = 0x7
	// Bit mask of ENDTX field.
	HSMCI_IDR_ENDTX_Msk = 0x80
	// Bit ENDTX.
	HSMCI_IDR_ENDTX = 0x80
	// Position of SDIOIRQA field.
	HSMCI_IDR_SDIOIRQA_Pos = 0x8
	// Bit mask of SDIOIRQA field.
	HSMCI_IDR_SDIOIRQA_Msk = 0x100
	// Bit SDIOIRQA.
	HSMCI_IDR_SDIOIRQA = 0x100
	// Position of SDIOWAIT field.
	HSMCI_IDR_SDIOWAIT_Pos = 0xc
	// Bit mask of SDIOWAIT field.
	HSMCI_IDR_SDIOWAIT_Msk = 0x1000
	// Bit SDIOWAIT.
	HSMCI_IDR_SDIOWAIT = 0x1000
	// Position of CSRCV field.
	HSMCI_IDR_CSRCV_Pos = 0xd
	// Bit mask of CSRCV field.
	HSMCI_IDR_CSRCV_Msk = 0x2000
	// Bit CSRCV.
	HSMCI_IDR_CSRCV = 0x2000
	// Position of RXBUFF field.
	HSMCI_IDR_RXBUFF_Pos = 0xe
	// Bit mask of RXBUFF field.
	HSMCI_IDR_RXBUFF_Msk = 0x4000
	// Bit RXBUFF.
	HSMCI_IDR_RXBUFF = 0x4000
	// Position of TXBUFE field.
	HSMCI_IDR_TXBUFE_Pos = 0xf
	// Bit mask of TXBUFE field.
	HSMCI_IDR_TXBUFE_Msk = 0x8000
	// Bit TXBUFE.
	HSMCI_IDR_TXBUFE = 0x8000
	// Position of RINDE field.
	HSMCI_IDR_RINDE_Pos = 0x10
	// Bit mask of RINDE field.
	HSMCI_IDR_RINDE_Msk = 0x10000
	// Bit RINDE.
	HSMCI_IDR_RINDE = 0x10000
	// Position of RDIRE field.
	HSMCI_IDR_RDIRE_Pos = 0x11
	// Bit mask of RDIRE field.
	HSMCI_IDR_RDIRE_Msk = 0x20000
	// Bit RDIRE.
	HSMCI_IDR_RDIRE = 0x20000
	// Position of RCRCE field.
	HSMCI_IDR_RCRCE_Pos = 0x12
	// Bit mask of RCRCE field.
	HSMCI_IDR_RCRCE_Msk = 0x40000
	// Bit RCRCE.
	HSMCI_IDR_RCRCE = 0x40000
	// Position of RENDE field.
	HSMCI_IDR_RENDE_Pos = 0x13
	// Bit mask of RENDE field.
	HSMCI_IDR_RENDE_Msk = 0x80000
	// Bit RENDE.
	HSMCI_IDR_RENDE = 0x80000
	// Position of RTOE field.
	HSMCI_IDR_RTOE_Pos = 0x14
	// Bit mask of RTOE field.
	HSMCI_IDR_RTOE_Msk = 0x100000
	// Bit RTOE.
	HSMCI_IDR_RTOE = 0x100000
	// Position of DCRCE field.
	HSMCI_IDR_DCRCE_Pos = 0x15
	// Bit mask of DCRCE field.
	HSMCI_IDR_DCRCE_Msk = 0x200000
	// Bit DCRCE.
	HSMCI_IDR_DCRCE = 0x200000
	// Position of DTOE field.
	HSMCI_IDR_DTOE_Pos = 0x16
	// Bit mask of DTOE field.
	HSMCI_IDR_DTOE_Msk = 0x400000
	// Bit DTOE.
	HSMCI_IDR_DTOE = 0x400000
	// Position of CSTOE field.
	HSMCI_IDR_CSTOE_Pos = 0x17
	// Bit mask of CSTOE field.
	HSMCI_IDR_CSTOE_Msk = 0x800000
	// Bit CSTOE.
	HSMCI_IDR_CSTOE = 0x800000
	// Position of FIFOEMPTY field.
	HSMCI_IDR_FIFOEMPTY_Pos = 0x1a
	// Bit mask of FIFOEMPTY field.
	HSMCI_IDR_FIFOEMPTY_Msk = 0x4000000
	// Bit FIFOEMPTY.
	HSMCI_IDR_FIFOEMPTY = 0x4000000
	// Position of XFRDONE field.
	HSMCI_IDR_XFRDONE_Pos = 0x1b
	// Bit mask of XFRDONE field.
	HSMCI_IDR_XFRDONE_Msk = 0x8000000
	// Bit XFRDONE.
	HSMCI_IDR_XFRDONE = 0x8000000
	// Position of ACKRCV field.
	HSMCI_IDR_ACKRCV_Pos = 0x1c
	// Bit mask of ACKRCV field.
	HSMCI_IDR_ACKRCV_Msk = 0x10000000
	// Bit ACKRCV.
	HSMCI_IDR_ACKRCV = 0x10000000
	// Position of ACKRCVE field.
	HSMCI_IDR_ACKRCVE_Pos = 0x1d
	// Bit mask of ACKRCVE field.
	HSMCI_IDR_ACKRCVE_Msk = 0x20000000
	// Bit ACKRCVE.
	HSMCI_IDR_ACKRCVE = 0x20000000
	// Position of OVRE field.
	HSMCI_IDR_OVRE_Pos = 0x1e
	// Bit mask of OVRE field.
	HSMCI_IDR_OVRE_Msk = 0x40000000
	// Bit OVRE.
	HSMCI_IDR_OVRE = 0x40000000
	// Position of UNRE field.
	HSMCI_IDR_UNRE_Pos = 0x1f
	// Bit mask of UNRE field.
	HSMCI_IDR_UNRE_Msk = 0x80000000
	// Bit UNRE.
	HSMCI_IDR_UNRE = 0x80000000

	// IMR: Interrupt Mask Register
	// Position of CMDRDY field.
	HSMCI_IMR_CMDRDY_Pos = 0x0
	// Bit mask of CMDRDY field.
	HSMCI_IMR_CMDRDY_Msk = 0x1
	// Bit CMDRDY.
	HSMCI_IMR_CMDRDY = 0x1
	// Position of RXRDY field.
	HSMCI_IMR_RXRDY_Pos = 0x1
	// Bit mask of RXRDY field.
	HSMCI_IMR_RXRDY_Msk = 0x2
	// Bit RXRDY.
	HSMCI_IMR_RXRDY = 0x2
	// Position of TXRDY field.
	HSMCI_IMR_TXRDY_Pos = 0x2
	// Bit mask of TXRDY field.
	HSMCI_IMR_TXRDY_Msk = 0x4
	// Bit TXRDY.
	HSMCI_IMR_TXRDY = 0x4
	// Position of BLKE field.
	HSMCI_IMR_BLKE_Pos = 0x3
	// Bit mask of BLKE field.
	HSMCI_IMR_BLKE_Msk = 0x8
	// Bit BLKE.
	HSMCI_IMR_BLKE = 0x8
	// Position of DTIP field.
	HSMCI_IMR_DTIP_Pos = 0x4
	// Bit mask of DTIP field.
	HSMCI_IMR_DTIP_Msk = 0x10
	// Bit DTIP.
	HSMCI_IMR_DTIP = 0x10
	// Position of NOTBUSY field.
	HSMCI_IMR_NOTBUSY_Pos = 0x5
	// Bit mask of NOTBUSY field.
	HSMCI_IMR_NOTBUSY_Msk = 0x20
	// Bit NOTBUSY.
	HSMCI_IMR_NOTBUSY = 0x20
	// Position of ENDRX field.
	HSMCI_IMR_ENDRX_Pos = 0x6
	// Bit mask of ENDRX field.
	HSMCI_IMR_ENDRX_Msk = 0x40
	// Bit ENDRX.
	HSMCI_IMR_ENDRX = 0x40
	// Position of ENDTX field.
	HSMCI_IMR_ENDTX_Pos = 0x7
	// Bit mask of ENDTX field.
	HSMCI_IMR_ENDTX_Msk = 0x80
	// Bit ENDTX.
	HSMCI_IMR_ENDTX = 0x80
	// Position of SDIOIRQA field.
	HSMCI_IMR_SDIOIRQA_Pos = 0x8
	// Bit mask of SDIOIRQA field.
	HSMCI_IMR_SDIOIRQA_Msk = 0x100
	// Bit SDIOIRQA.
	HSMCI_IMR_SDIOIRQA = 0x100
	// Position of SDIOWAIT field.
	HSMCI_IMR_SDIOWAIT_Pos = 0xc
	// Bit mask of SDIOWAIT field.
	HSMCI_IMR_SDIOWAIT_Msk = 0x1000
	// Bit SDIOWAIT.
	HSMCI_IMR_SDIOWAIT = 0x1000
	// Position of CSRCV field.
	HSMCI_IMR_CSRCV_Pos = 0xd
	// Bit mask of CSRCV field.
	HSMCI_IMR_CSRCV_Msk = 0x2000
	// Bit CSRCV.
	HSMCI_IMR_CSRCV = 0x2000
	// Position of RXBUFF field.
	HSMCI_IMR_RXBUFF_Pos = 0xe
	// Bit mask of RXBUFF field.
	HSMCI_IMR_RXBUFF_Msk = 0x4000
	// Bit RXBUFF.
	HSMCI_IMR_RXBUFF = 0x4000
	// Position of TXBUFE field.
	HSMCI_IMR_TXBUFE_Pos = 0xf
	// Bit mask of TXBUFE field.
	HSMCI_IMR_TXBUFE_Msk = 0x8000
	// Bit TXBUFE.
	HSMCI_IMR_TXBUFE = 0x8000
	// Position of RINDE field.
	HSMCI_IMR_RINDE_Pos = 0x10
	// Bit mask of RINDE field.
	HSMCI_IMR_RINDE_Msk = 0x10000
	// Bit RINDE.
	HSMCI_IMR_RINDE = 0x10000
	// Position of RDIRE field.
	HSMCI_IMR_RDIRE_Pos = 0x11
	// Bit mask of RDIRE field.
	HSMCI_IMR_RDIRE_Msk = 0x20000
	// Bit RDIRE.
	HSMCI_IMR_RDIRE = 0x20000
	// Position of RCRCE field.
	HSMCI_IMR_RCRCE_Pos = 0x12
	// Bit mask of RCRCE field.
	HSMCI_IMR_RCRCE_Msk = 0x40000
	// Bit RCRCE.
	HSMCI_IMR_RCRCE = 0x40000
	// Position of RENDE field.
	HSMCI_IMR_RENDE_Pos = 0x13
	// Bit mask of RENDE field.
	HSMCI_IMR_RENDE_Msk = 0x80000
	// Bit RENDE.
	HSMCI_IMR_RENDE = 0x80000
	// Position of RTOE field.
	HSMCI_IMR_RTOE_Pos = 0x14
	// Bit mask of RTOE field.
	HSMCI_IMR_RTOE_Msk = 0x100000
	// Bit RTOE.
	HSMCI_IMR_RTOE = 0x100000
	// Position of DCRCE field.
	HSMCI_IMR_DCRCE_Pos = 0x15
	// Bit mask of DCRCE field.
	HSMCI_IMR_DCRCE_Msk = 0x200000
	// Bit DCRCE.
	HSMCI_IMR_DCRCE = 0x200000
	// Position of DTOE field.
	HSMCI_IMR_DTOE_Pos = 0x16
	// Bit mask of DTOE field.
	HSMCI_IMR_DTOE_Msk = 0x400000
	// Bit DTOE.
	HSMCI_IMR_DTOE = 0x400000
	// Position of CSTOE field.
	HSMCI_IMR_CSTOE_Pos = 0x17
	// Bit mask of CSTOE field.
	HSMCI_IMR_CSTOE_Msk = 0x800000
	// Bit CSTOE.
	HSMCI_IMR_CSTOE = 0x800000
	// Position of FIFOEMPTY field.
	HSMCI_IMR_FIFOEMPTY_Pos = 0x1a
	// Bit mask of FIFOEMPTY field.
	HSMCI_IMR_FIFOEMPTY_Msk = 0x4000000
	// Bit FIFOEMPTY.
	HSMCI_IMR_FIFOEMPTY = 0x4000000
	// Position of XFRDONE field.
	HSMCI_IMR_XFRDONE_Pos = 0x1b
	// Bit mask of XFRDONE field.
	HSMCI_IMR_XFRDONE_Msk = 0x8000000
	// Bit XFRDONE.
	HSMCI_IMR_XFRDONE = 0x8000000
	// Position of ACKRCV field.
	HSMCI_IMR_ACKRCV_Pos = 0x1c
	// Bit mask of ACKRCV field.
	HSMCI_IMR_ACKRCV_Msk = 0x10000000
	// Bit ACKRCV.
	HSMCI_IMR_ACKRCV = 0x10000000
	// Position of ACKRCVE field.
	HSMCI_IMR_ACKRCVE_Pos = 0x1d
	// Bit mask of ACKRCVE field.
	HSMCI_IMR_ACKRCVE_Msk = 0x20000000
	// Bit ACKRCVE.
	HSMCI_IMR_ACKRCVE = 0x20000000
	// Position of OVRE field.
	HSMCI_IMR_OVRE_Pos = 0x1e
	// Bit mask of OVRE field.
	HSMCI_IMR_OVRE_Msk = 0x40000000
	// Bit OVRE.
	HSMCI_IMR_OVRE = 0x40000000
	// Position of UNRE field.
	HSMCI_IMR_UNRE_Pos = 0x1f
	// Bit mask of UNRE field.
	HSMCI_IMR_UNRE_Msk = 0x80000000
	// Bit UNRE.
	HSMCI_IMR_UNRE = 0x80000000

	// CFG: Configuration Register
	// Position of FIFOMODE field.
	HSMCI_CFG_FIFOMODE_Pos = 0x0
	// Bit mask of FIFOMODE field.
	HSMCI_CFG_FIFOMODE_Msk = 0x1
	// Bit FIFOMODE.
	HSMCI_CFG_FIFOMODE = 0x1
	// Position of FERRCTRL field.
	HSMCI_CFG_FERRCTRL_Pos = 0x4
	// Bit mask of FERRCTRL field.
	HSMCI_CFG_FERRCTRL_Msk = 0x10
	// Bit FERRCTRL.
	HSMCI_CFG_FERRCTRL = 0x10
	// Position of HSMODE field.
	HSMCI_CFG_HSMODE_Pos = 0x8
	// Bit mask of HSMODE field.
	HSMCI_CFG_HSMODE_Msk = 0x100
	// Bit HSMODE.
	HSMCI_CFG_HSMODE = 0x100
	// Position of LSYNC field.
	HSMCI_CFG_LSYNC_Pos = 0xc
	// Bit mask of LSYNC field.
	HSMCI_CFG_LSYNC_Msk = 0x1000
	// Bit LSYNC.
	HSMCI_CFG_LSYNC = 0x1000

	// WPMR: Write Protection Mode Register
	// Position of WPEN field.
	HSMCI_WPMR_WPEN_Pos = 0x0
	// Bit mask of WPEN field.
	HSMCI_WPMR_WPEN_Msk = 0x1
	// Bit WPEN.
	HSMCI_WPMR_WPEN = 0x1
	// Position of WPKEY field.
	HSMCI_WPMR_WPKEY_Pos = 0x8
	// Bit mask of WPKEY field.
	HSMCI_WPMR_WPKEY_Msk = 0xffffff00
	// Writing any other value in this field aborts the write operation of the WPEN bit.Always reads as 0.
	HSMCI_WPMR_WPKEY_PASSWD = 0x4d4349

	// WPSR: Write Protection Status Register
	// Position of WPVS field.
	HSMCI_WPSR_WPVS_Pos = 0x0
	// Bit mask of WPVS field.
	HSMCI_WPSR_WPVS_Msk = 0x1
	// Bit WPVS.
	HSMCI_WPSR_WPVS = 0x1
	// Position of WPVSRC field.
	HSMCI_WPSR_WPVSRC_Pos = 0x8
	// Bit mask of WPVSRC field.
	HSMCI_WPSR_WPVSRC_Msk = 0xffff00

	// RPR: Receive Pointer Register
	// Position of RXPTR field.
	HSMCI_RPR_RXPTR_Pos = 0x0
	// Bit mask of RXPTR field.
	HSMCI_RPR_RXPTR_Msk = 0xffffffff

	// RCR: Receive Counter Register
	// Position of RXCTR field.
	HSMCI_RCR_RXCTR_Pos = 0x0
	// Bit mask of RXCTR field.
	HSMCI_RCR_RXCTR_Msk = 0xffff

	// TPR: Transmit Pointer Register
	// Position of TXPTR field.
	HSMCI_TPR_TXPTR_Pos = 0x0
	// Bit mask of TXPTR field.
	HSMCI_TPR_TXPTR_Msk = 0xffffffff

	// TCR: Transmit Counter Register
	// Position of TXCTR field.
	HSMCI_TCR_TXCTR_Pos = 0x0
	// Bit mask of TXCTR field.
	HSMCI_TCR_TXCTR_Msk = 0xffff

	// RNPR: Receive Next Pointer Register
	// Position of RXNPTR field.
	HSMCI_RNPR_RXNPTR_Pos = 0x0
	// Bit mask of RXNPTR field.
	HSMCI_RNPR_RXNPTR_Msk = 0xffffffff

	// RNCR: Receive Next Counter Register
	// Position of RXNCTR field.
	HSMCI_RNCR_RXNCTR_Pos = 0x0
	// Bit mask of RXNCTR field.
	HSMCI_RNCR_RXNCTR_Msk = 0xffff

	// TNPR: Transmit Next Pointer Register
	// Position of TXNPTR field.
	HSMCI_TNPR_TXNPTR_Pos = 0x0
	// Bit mask of TXNPTR field.
	HSMCI_TNPR_TXNPTR_Msk = 0xffffffff

	// TNCR: Transmit Next Counter Register
	// Position of TXNCTR field.
	HSMCI_TNCR_TXNCTR_Pos = 0x0
	// Bit mask of TXNCTR field.
	HSMCI_TNCR_TXNCTR_Msk = 0xffff

	// PTCR: Transfer Control Register
	// Position of RXTEN field.
	HSMCI_PTCR_RXTEN_Pos = 0x0
	// Bit mask of RXTEN field.
	HSMCI_PTCR_RXTEN_Msk = 0x1
	// Bit RXTEN.
	HSMCI_PTCR_RXTEN = 0x1
	// Position of RXTDIS field.
	HSMCI_PTCR_RXTDIS_Pos = 0x1
	// Bit mask of RXTDIS field.
	HSMCI_PTCR_RXTDIS_Msk = 0x2
	// Bit RXTDIS.
	HSMCI_PTCR_RXTDIS = 0x2
	// Position of TXTEN field.
	HSMCI_PTCR_TXTEN_Pos = 0x8
	// Bit mask of TXTEN field.
	HSMCI_PTCR_TXTEN_Msk = 0x100
	// Bit TXTEN.
	HSMCI_PTCR_TXTEN = 0x100
	// Position of TXTDIS field.
	HSMCI_PTCR_TXTDIS_Pos = 0x9
	// Bit mask of TXTDIS field.
	HSMCI_PTCR_TXTDIS_Msk = 0x200
	// Bit TXTDIS.
	HSMCI_PTCR_TXTDIS = 0x200

	// PTSR: Transfer Status Register
	// Position of RXTEN field.
	HSMCI_PTSR_RXTEN_Pos = 0x0
	// Bit mask of RXTEN field.
	HSMCI_PTSR_RXTEN_Msk = 0x1
	// Bit RXTEN.
	HSMCI_PTSR_RXTEN = 0x1
	// Position of TXTEN field.
	HSMCI_PTSR_TXTEN_Pos = 0x8
	// Bit mask of TXTEN field.
	HSMCI_PTSR_TXTEN_Msk = 0x100
	// Bit TXTEN.
	HSMCI_PTSR_TXTEN = 0x100

	// FIFO: FIFO Memory Aperture0
	// Position of DATA field.
	HSMCI_FIFO_DATA_Pos = 0x0
	// Bit mask of DATA field.
	HSMCI_FIFO_DATA_Msk = 0xffffffff
)

// Constants for SSC: Synchronous Serial Controller
const (
	// CR: Control Register
	// Position of RXEN field.
	SSC_CR_RXEN_Pos = 0x0
	// Bit mask of RXEN field.
	SSC_CR_RXEN_Msk = 0x1
	// Bit RXEN.
	SSC_CR_RXEN = 0x1
	// Position of RXDIS field.
	SSC_CR_RXDIS_Pos = 0x1
	// Bit mask of RXDIS field.
	SSC_CR_RXDIS_Msk = 0x2
	// Bit RXDIS.
	SSC_CR_RXDIS = 0x2
	// Position of TXEN field.
	SSC_CR_TXEN_Pos = 0x8
	// Bit mask of TXEN field.
	SSC_CR_TXEN_Msk = 0x100
	// Bit TXEN.
	SSC_CR_TXEN = 0x100
	// Position of TXDIS field.
	SSC_CR_TXDIS_Pos = 0x9
	// Bit mask of TXDIS field.
	SSC_CR_TXDIS_Msk = 0x200
	// Bit TXDIS.
	SSC_CR_TXDIS = 0x200
	// Position of SWRST field.
	SSC_CR_SWRST_Pos = 0xf
	// Bit mask of SWRST field.
	SSC_CR_SWRST_Msk = 0x8000
	// Bit SWRST.
	SSC_CR_SWRST = 0x8000

	// CMR: Clock Mode Register
	// Position of DIV field.
	SSC_CMR_DIV_Pos = 0x0
	// Bit mask of DIV field.
	SSC_CMR_DIV_Msk = 0xfff

	// RCMR: Receive Clock Mode Register
	// Position of CKS field.
	SSC_RCMR_CKS_Pos = 0x0
	// Bit mask of CKS field.
	SSC_RCMR_CKS_Msk = 0x3
	// Divided Clock
	SSC_RCMR_CKS_MCK = 0x0
	// TK Clock signal
	SSC_RCMR_CKS_TK = 0x1
	// RK pin
	SSC_RCMR_CKS_RK = 0x2
	// Position of CKO field.
	SSC_RCMR_CKO_Pos = 0x2
	// Bit mask of CKO field.
	SSC_RCMR_CKO_Msk = 0x1c
	// None, RK pin is an input
	SSC_RCMR_CKO_NONE = 0x0
	// Continuous Receive Clock, RK pin is an output
	SSC_RCMR_CKO_CONTINUOUS = 0x1
	// Receive Clock only during data transfers, RK pin is an output
	SSC_RCMR_CKO_TRANSFER = 0x2
	// Position of CKI field.
	SSC_RCMR_CKI_Pos = 0x5
	// Bit mask of CKI field.
	SSC_RCMR_CKI_Msk = 0x20
	// Bit CKI.
	SSC_RCMR_CKI = 0x20
	// Position of CKG field.
	SSC_RCMR_CKG_Pos = 0x6
	// Bit mask of CKG field.
	SSC_RCMR_CKG_Msk = 0xc0
	// None
	SSC_RCMR_CKG_CONTINUOUS = 0x0
	// Receive Clock enabled only if RF Low
	SSC_RCMR_CKG_EN_RF_LOW = 0x1
	// Receive Clock enabled only if RF High
	SSC_RCMR_CKG_EN_RF_HIGH = 0x2
	// Position of START field.
	SSC_RCMR_START_Pos = 0x8
	// Bit mask of START field.
	SSC_RCMR_START_Msk = 0xf00
	// Continuous, as soon as the receiver is enabled, and immediately after the end of transfer of the previous data.
	SSC_RCMR_START_CONTINUOUS = 0x0
	// Transmit start
	SSC_RCMR_START_TRANSMIT = 0x1
	// Detection of a low level on RF signal
	SSC_RCMR_START_RF_LOW = 0x2
	// Detection of a high level on RF signal
	SSC_RCMR_START_RF_HIGH = 0x3
	// Detection of a falling edge on RF signal
	SSC_RCMR_START_RF_FALLING = 0x4
	// Detection of a rising edge on RF signal
	SSC_RCMR_START_RF_RISING = 0x5
	// Detection of any level change on RF signal
	SSC_RCMR_START_RF_LEVEL = 0x6
	// Detection of any edge on RF signal
	SSC_RCMR_START_RF_EDGE = 0x7
	// Compare 0
	SSC_RCMR_START_CMP_0 = 0x8
	// Position of STOP field.
	SSC_RCMR_STOP_Pos = 0xc
	// Bit mask of STOP field.
	SSC_RCMR_STOP_Msk = 0x1000
	// Bit STOP.
	SSC_RCMR_STOP = 0x1000
	// Position of STTDLY field.
	SSC_RCMR_STTDLY_Pos = 0x10
	// Bit mask of STTDLY field.
	SSC_RCMR_STTDLY_Msk = 0xff0000
	// Position of PERIOD field.
	SSC_RCMR_PERIOD_Pos = 0x18
	// Bit mask of PERIOD field.
	SSC_RCMR_PERIOD_Msk = 0xff000000

	// RFMR: Receive Frame Mode Register
	// Position of DATLEN field.
	SSC_RFMR_DATLEN_Pos = 0x0
	// Bit mask of DATLEN field.
	SSC_RFMR_DATLEN_Msk = 0x1f
	// Position of LOOP field.
	SSC_RFMR_LOOP_Pos = 0x5
	// Bit mask of LOOP field.
	SSC_RFMR_LOOP_Msk = 0x20
	// Bit LOOP.
	SSC_RFMR_LOOP = 0x20
	// Position of MSBF field.
	SSC_RFMR_MSBF_Pos = 0x7
	// Bit mask of MSBF field.
	SSC_RFMR_MSBF_Msk = 0x80
	// Bit MSBF.
	SSC_RFMR_MSBF = 0x80
	// Position of DATNB field.
	SSC_RFMR_DATNB_Pos = 0x8
	// Bit mask of DATNB field.
	SSC_RFMR_DATNB_Msk = 0xf00
	// Position of FSLEN field.
	SSC_RFMR_FSLEN_Pos = 0x10
	// Bit mask of FSLEN field.
	SSC_RFMR_FSLEN_Msk = 0xf0000
	// Position of FSOS field.
	SSC_RFMR_FSOS_Pos = 0x14
	// Bit mask of FSOS field.
	SSC_RFMR_FSOS_Msk = 0x700000
	// None, RF pin is an input
	SSC_RFMR_FSOS_NONE = 0x0
	// Negative Pulse, RF pin is an output
	SSC_RFMR_FSOS_NEGATIVE = 0x1
	// Positive Pulse, RF pin is an output
	SSC_RFMR_FSOS_POSITIVE = 0x2
	// Driven Low during data transfer, RF pin is an output
	SSC_RFMR_FSOS_LOW = 0x3
	// Driven High during data transfer, RF pin is an output
	SSC_RFMR_FSOS_HIGH = 0x4
	// Toggling at each start of data transfer, RF pin is an output
	SSC_RFMR_FSOS_TOGGLING = 0x5
	// Position of FSEDGE field.
	SSC_RFMR_FSEDGE_Pos = 0x18
	// Bit mask of FSEDGE field.
	SSC_RFMR_FSEDGE_Msk = 0x1000000
	// Bit FSEDGE.
	SSC_RFMR_FSEDGE = 0x1000000
	// Positive Edge Detection
	SSC_RFMR_FSEDGE_POSITIVE = 0x0
	// Negative Edge Detection
	SSC_RFMR_FSEDGE_NEGATIVE = 0x1
	// Position of FSLEN_EXT field.
	SSC_RFMR_FSLEN_EXT_Pos = 0x1c
	// Bit mask of FSLEN_EXT field.
	SSC_RFMR_FSLEN_EXT_Msk = 0xf0000000

	// TCMR: Transmit Clock Mode Register
	// Position of CKS field.
	SSC_TCMR_CKS_Pos = 0x0
	// Bit mask of CKS field.
	SSC_TCMR_CKS_Msk = 0x3
	// Divided Clock
	SSC_TCMR_CKS_MCK = 0x0
	// RK Clock signal
	SSC_TCMR_CKS_RK = 0x1
	// TK pin
	SSC_TCMR_CKS_TK = 0x2
	// Position of CKO field.
	SSC_TCMR_CKO_Pos = 0x2
	// Bit mask of CKO field.
	SSC_TCMR_CKO_Msk = 0x1c
	// None, TK pin is an input
	SSC_TCMR_CKO_NONE = 0x0
	// Continuous Transmit Clock, TK pin is an output
	SSC_TCMR_CKO_CONTINUOUS = 0x1
	// Transmit Clock only during data transfers, TK pin is an output
	SSC_TCMR_CKO_TRANSFER = 0x2
	// Position of CKI field.
	SSC_TCMR_CKI_Pos = 0x5
	// Bit mask of CKI field.
	SSC_TCMR_CKI_Msk = 0x20
	// Bit CKI.
	SSC_TCMR_CKI = 0x20
	// Position of CKG field.
	SSC_TCMR_CKG_Pos = 0x6
	// Bit mask of CKG field.
	SSC_TCMR_CKG_Msk = 0xc0
	// None
	SSC_TCMR_CKG_CONTINUOUS = 0x0
	// Transmit Clock enabled only if TF Low
	SSC_TCMR_CKG_EN_TF_LOW = 0x1
	// Transmit Clock enabled only if TF High
	SSC_TCMR_CKG_EN_TF_HIGH = 0x2
	// Position of START field.
	SSC_TCMR_START_Pos = 0x8
	// Bit mask of START field.
	SSC_TCMR_START_Msk = 0xf00
	// Continuous, as soon as a word is written in the SSC_THR (if Transmit is enabled), and immediately after the end of transfer of the previous data
	SSC_TCMR_START_CONTINUOUS = 0x0
	// Receive start
	SSC_TCMR_START_RECEIVE = 0x1
	// Detection of a low level on TF signal
	SSC_TCMR_START_TF_LOW = 0x2
	// Detection of a high level on TF signal
	SSC_TCMR_START_TF_HIGH = 0x3
	// Detection of a falling edge on TF signal
	SSC_TCMR_START_TF_FALLING = 0x4
	// Detection of a rising edge on TF signal
	SSC_TCMR_START_TF_RISING = 0x5
	// Detection of any level change on TF signal
	SSC_TCMR_START_TF_LEVEL = 0x6
	// Detection of any edge on TF signal
	SSC_TCMR_START_TF_EDGE = 0x7
	// Position of STTDLY field.
	SSC_TCMR_STTDLY_Pos = 0x10
	// Bit mask of STTDLY field.
	SSC_TCMR_STTDLY_Msk = 0xff0000
	// Position of PERIOD field.
	SSC_TCMR_PERIOD_Pos = 0x18
	// Bit mask of PERIOD field.
	SSC_TCMR_PERIOD_Msk = 0xff000000

	// TFMR: Transmit Frame Mode Register
	// Position of DATLEN field.
	SSC_TFMR_DATLEN_Pos = 0x0
	// Bit mask of DATLEN field.
	SSC_TFMR_DATLEN_Msk = 0x1f
	// Position of DATDEF field.
	SSC_TFMR_DATDEF_Pos = 0x5
	// Bit mask of DATDEF field.
	SSC_TFMR_DATDEF_Msk = 0x20
	// Bit DATDEF.
	SSC_TFMR_DATDEF = 0x20
	// Position of MSBF field.
	SSC_TFMR_MSBF_Pos = 0x7
	// Bit mask of MSBF field.
	SSC_TFMR_MSBF_Msk = 0x80
	// Bit MSBF.
	SSC_TFMR_MSBF = 0x80
	// Position of DATNB field.
	SSC_TFMR_DATNB_Pos = 0x8
	// Bit mask of DATNB field.
	SSC_TFMR_DATNB_Msk = 0xf00
	// Position of FSLEN field.
	SSC_TFMR_FSLEN_Pos = 0x10
	// Bit mask of FSLEN field.
	SSC_TFMR_FSLEN_Msk = 0xf0000
	// Position of FSOS field.
	SSC_TFMR_FSOS_Pos = 0x14
	// Bit mask of FSOS field.
	SSC_TFMR_FSOS_Msk = 0x700000
	// None, TF pin is an input
	SSC_TFMR_FSOS_NONE = 0x0
	// Negative Pulse, TF pin is an output
	SSC_TFMR_FSOS_NEGATIVE = 0x1
	// Positive Pulse, TF pin is an output
	SSC_TFMR_FSOS_POSITIVE = 0x2
	// Driven Low during data transfer
	SSC_TFMR_FSOS_LOW = 0x3
	// Driven High during data transfer
	SSC_TFMR_FSOS_HIGH = 0x4
	// Toggling at each start of data transfer
	SSC_TFMR_FSOS_TOGGLING = 0x5
	// Position of FSDEN field.
	SSC_TFMR_FSDEN_Pos = 0x17
	// Bit mask of FSDEN field.
	SSC_TFMR_FSDEN_Msk = 0x800000
	// Bit FSDEN.
	SSC_TFMR_FSDEN = 0x800000
	// Position of FSEDGE field.
	SSC_TFMR_FSEDGE_Pos = 0x18
	// Bit mask of FSEDGE field.
	SSC_TFMR_FSEDGE_Msk = 0x1000000
	// Bit FSEDGE.
	SSC_TFMR_FSEDGE = 0x1000000
	// Positive Edge Detection
	SSC_TFMR_FSEDGE_POSITIVE = 0x0
	// Negative Edge Detection
	SSC_TFMR_FSEDGE_NEGATIVE = 0x1
	// Position of FSLEN_EXT field.
	SSC_TFMR_FSLEN_EXT_Pos = 0x1c
	// Bit mask of FSLEN_EXT field.
	SSC_TFMR_FSLEN_EXT_Msk = 0xf0000000

	// RHR: Receive Holding Register
	// Position of RDAT field.
	SSC_RHR_RDAT_Pos = 0x0
	// Bit mask of RDAT field.
	SSC_RHR_RDAT_Msk = 0xffffffff

	// THR: Transmit Holding Register
	// Position of TDAT field.
	SSC_THR_TDAT_Pos = 0x0
	// Bit mask of TDAT field.
	SSC_THR_TDAT_Msk = 0xffffffff

	// RSHR: Receive Sync. Holding Register
	// Position of RSDAT field.
	SSC_RSHR_RSDAT_Pos = 0x0
	// Bit mask of RSDAT field.
	SSC_RSHR_RSDAT_Msk = 0xffff

	// TSHR: Transmit Sync. Holding Register
	// Position of TSDAT field.
	SSC_TSHR_TSDAT_Pos = 0x0
	// Bit mask of TSDAT field.
	SSC_TSHR_TSDAT_Msk = 0xffff

	// RC0R: Receive Compare 0 Register
	// Position of CP0 field.
	SSC_RC0R_CP0_Pos = 0x0
	// Bit mask of CP0 field.
	SSC_RC0R_CP0_Msk = 0xffff

	// RC1R: Receive Compare 1 Register
	// Position of CP1 field.
	SSC_RC1R_CP1_Pos = 0x0
	// Bit mask of CP1 field.
	SSC_RC1R_CP1_Msk = 0xffff

	// SR: Status Register
	// Position of TXRDY field.
	SSC_SR_TXRDY_Pos = 0x0
	// Bit mask of TXRDY field.
	SSC_SR_TXRDY_Msk = 0x1
	// Bit TXRDY.
	SSC_SR_TXRDY = 0x1
	// Position of TXEMPTY field.
	SSC_SR_TXEMPTY_Pos = 0x1
	// Bit mask of TXEMPTY field.
	SSC_SR_TXEMPTY_Msk = 0x2
	// Bit TXEMPTY.
	SSC_SR_TXEMPTY = 0x2
	// Position of ENDTX field.
	SSC_SR_ENDTX_Pos = 0x2
	// Bit mask of ENDTX field.
	SSC_SR_ENDTX_Msk = 0x4
	// Bit ENDTX.
	SSC_SR_ENDTX = 0x4
	// Position of TXBUFE field.
	SSC_SR_TXBUFE_Pos = 0x3
	// Bit mask of TXBUFE field.
	SSC_SR_TXBUFE_Msk = 0x8
	// Bit TXBUFE.
	SSC_SR_TXBUFE = 0x8
	// Position of RXRDY field.
	SSC_SR_RXRDY_Pos = 0x4
	// Bit mask of RXRDY field.
	SSC_SR_RXRDY_Msk = 0x10
	// Bit RXRDY.
	SSC_SR_RXRDY = 0x10
	// Position of OVRUN field.
	SSC_SR_OVRUN_Pos = 0x5
	// Bit mask of OVRUN field.
	SSC_SR_OVRUN_Msk = 0x20
	// Bit OVRUN.
	SSC_SR_OVRUN = 0x20
	// Position of ENDRX field.
	SSC_SR_ENDRX_Pos = 0x6
	// Bit mask of ENDRX field.
	SSC_SR_ENDRX_Msk = 0x40
	// Bit ENDRX.
	SSC_SR_ENDRX = 0x40
	// Position of RXBUFF field.
	SSC_SR_RXBUFF_Pos = 0x7
	// Bit mask of RXBUFF field.
	SSC_SR_RXBUFF_Msk = 0x80
	// Bit RXBUFF.
	SSC_SR_RXBUFF = 0x80
	// Position of CP0 field.
	SSC_SR_CP0_Pos = 0x8
	// Bit mask of CP0 field.
	SSC_SR_CP0_Msk = 0x100
	// Bit CP0.
	SSC_SR_CP0 = 0x100
	// Position of CP1 field.
	SSC_SR_CP1_Pos = 0x9
	// Bit mask of CP1 field.
	SSC_SR_CP1_Msk = 0x200
	// Bit CP1.
	SSC_SR_CP1 = 0x200
	// Position of TXSYN field.
	SSC_SR_TXSYN_Pos = 0xa
	// Bit mask of TXSYN field.
	SSC_SR_TXSYN_Msk = 0x400
	// Bit TXSYN.
	SSC_SR_TXSYN = 0x400
	// Position of RXSYN field.
	SSC_SR_RXSYN_Pos = 0xb
	// Bit mask of RXSYN field.
	SSC_SR_RXSYN_Msk = 0x800
	// Bit RXSYN.
	SSC_SR_RXSYN = 0x800
	// Position of TXEN field.
	SSC_SR_TXEN_Pos = 0x10
	// Bit mask of TXEN field.
	SSC_SR_TXEN_Msk = 0x10000
	// Bit TXEN.
	SSC_SR_TXEN = 0x10000
	// Position of RXEN field.
	SSC_SR_RXEN_Pos = 0x11
	// Bit mask of RXEN field.
	SSC_SR_RXEN_Msk = 0x20000
	// Bit RXEN.
	SSC_SR_RXEN = 0x20000

	// IER: Interrupt Enable Register
	// Position of TXRDY field.
	SSC_IER_TXRDY_Pos = 0x0
	// Bit mask of TXRDY field.
	SSC_IER_TXRDY_Msk = 0x1
	// Bit TXRDY.
	SSC_IER_TXRDY = 0x1
	// Position of TXEMPTY field.
	SSC_IER_TXEMPTY_Pos = 0x1
	// Bit mask of TXEMPTY field.
	SSC_IER_TXEMPTY_Msk = 0x2
	// Bit TXEMPTY.
	SSC_IER_TXEMPTY = 0x2
	// Position of ENDTX field.
	SSC_IER_ENDTX_Pos = 0x2
	// Bit mask of ENDTX field.
	SSC_IER_ENDTX_Msk = 0x4
	// Bit ENDTX.
	SSC_IER_ENDTX = 0x4
	// Position of TXBUFE field.
	SSC_IER_TXBUFE_Pos = 0x3
	// Bit mask of TXBUFE field.
	SSC_IER_TXBUFE_Msk = 0x8
	// Bit TXBUFE.
	SSC_IER_TXBUFE = 0x8
	// Position of RXRDY field.
	SSC_IER_RXRDY_Pos = 0x4
	// Bit mask of RXRDY field.
	SSC_IER_RXRDY_Msk = 0x10
	// Bit RXRDY.
	SSC_IER_RXRDY = 0x10
	// Position of OVRUN field.
	SSC_IER_OVRUN_Pos = 0x5
	// Bit mask of OVRUN field.
	SSC_IER_OVRUN_Msk = 0x20
	// Bit OVRUN.
	SSC_IER_OVRUN = 0x20
	// Position of ENDRX field.
	SSC_IER_ENDRX_Pos = 0x6
	// Bit mask of ENDRX field.
	SSC_IER_ENDRX_Msk = 0x40
	// Bit ENDRX.
	SSC_IER_ENDRX = 0x40
	// Position of RXBUFF field.
	SSC_IER_RXBUFF_Pos = 0x7
	// Bit mask of RXBUFF field.
	SSC_IER_RXBUFF_Msk = 0x80
	// Bit RXBUFF.
	SSC_IER_RXBUFF = 0x80
	// Position of CP0 field.
	SSC_IER_CP0_Pos = 0x8
	// Bit mask of CP0 field.
	SSC_IER_CP0_Msk = 0x100
	// Bit CP0.
	SSC_IER_CP0 = 0x100
	// Position of CP1 field.
	SSC_IER_CP1_Pos = 0x9
	// Bit mask of CP1 field.
	SSC_IER_CP1_Msk = 0x200
	// Bit CP1.
	SSC_IER_CP1 = 0x200
	// Position of TXSYN field.
	SSC_IER_TXSYN_Pos = 0xa
	// Bit mask of TXSYN field.
	SSC_IER_TXSYN_Msk = 0x400
	// Bit TXSYN.
	SSC_IER_TXSYN = 0x400
	// Position of RXSYN field.
	SSC_IER_RXSYN_Pos = 0xb
	// Bit mask of RXSYN field.
	SSC_IER_RXSYN_Msk = 0x800
	// Bit RXSYN.
	SSC_IER_RXSYN = 0x800

	// IDR: Interrupt Disable Register
	// Position of TXRDY field.
	SSC_IDR_TXRDY_Pos = 0x0
	// Bit mask of TXRDY field.
	SSC_IDR_TXRDY_Msk = 0x1
	// Bit TXRDY.
	SSC_IDR_TXRDY = 0x1
	// Position of TXEMPTY field.
	SSC_IDR_TXEMPTY_Pos = 0x1
	// Bit mask of TXEMPTY field.
	SSC_IDR_TXEMPTY_Msk = 0x2
	// Bit TXEMPTY.
	SSC_IDR_TXEMPTY = 0x2
	// Position of ENDTX field.
	SSC_IDR_ENDTX_Pos = 0x2
	// Bit mask of ENDTX field.
	SSC_IDR_ENDTX_Msk = 0x4
	// Bit ENDTX.
	SSC_IDR_ENDTX = 0x4
	// Position of TXBUFE field.
	SSC_IDR_TXBUFE_Pos = 0x3
	// Bit mask of TXBUFE field.
	SSC_IDR_TXBUFE_Msk = 0x8
	// Bit TXBUFE.
	SSC_IDR_TXBUFE = 0x8
	// Position of RXRDY field.
	SSC_IDR_RXRDY_Pos = 0x4
	// Bit mask of RXRDY field.
	SSC_IDR_RXRDY_Msk = 0x10
	// Bit RXRDY.
	SSC_IDR_RXRDY = 0x10
	// Position of OVRUN field.
	SSC_IDR_OVRUN_Pos = 0x5
	// Bit mask of OVRUN field.
	SSC_IDR_OVRUN_Msk = 0x20
	// Bit OVRUN.
	SSC_IDR_OVRUN = 0x20
	// Position of ENDRX field.
	SSC_IDR_ENDRX_Pos = 0x6
	// Bit mask of ENDRX field.
	SSC_IDR_ENDRX_Msk = 0x40
	// Bit ENDRX.
	SSC_IDR_ENDRX = 0x40
	// Position of RXBUFF field.
	SSC_IDR_RXBUFF_Pos = 0x7
	// Bit mask of RXBUFF field.
	SSC_IDR_RXBUFF_Msk = 0x80
	// Bit RXBUFF.
	SSC_IDR_RXBUFF = 0x80
	// Position of CP0 field.
	SSC_IDR_CP0_Pos = 0x8
	// Bit mask of CP0 field.
	SSC_IDR_CP0_Msk = 0x100
	// Bit CP0.
	SSC_IDR_CP0 = 0x100
	// Position of CP1 field.
	SSC_IDR_CP1_Pos = 0x9
	// Bit mask of CP1 field.
	SSC_IDR_CP1_Msk = 0x200
	// Bit CP1.
	SSC_IDR_CP1 = 0x200
	// Position of TXSYN field.
	SSC_IDR_TXSYN_Pos = 0xa
	// Bit mask of TXSYN field.
	SSC_IDR_TXSYN_Msk = 0x400
	// Bit TXSYN.
	SSC_IDR_TXSYN = 0x400
	// Position of RXSYN field.
	SSC_IDR_RXSYN_Pos = 0xb
	// Bit mask of RXSYN field.
	SSC_IDR_RXSYN_Msk = 0x800
	// Bit RXSYN.
	SSC_IDR_RXSYN = 0x800

	// IMR: Interrupt Mask Register
	// Position of TXRDY field.
	SSC_IMR_TXRDY_Pos = 0x0
	// Bit mask of TXRDY field.
	SSC_IMR_TXRDY_Msk = 0x1
	// Bit TXRDY.
	SSC_IMR_TXRDY = 0x1
	// Position of TXEMPTY field.
	SSC_IMR_TXEMPTY_Pos = 0x1
	// Bit mask of TXEMPTY field.
	SSC_IMR_TXEMPTY_Msk = 0x2
	// Bit TXEMPTY.
	SSC_IMR_TXEMPTY = 0x2
	// Position of ENDTX field.
	SSC_IMR_ENDTX_Pos = 0x2
	// Bit mask of ENDTX field.
	SSC_IMR_ENDTX_Msk = 0x4
	// Bit ENDTX.
	SSC_IMR_ENDTX = 0x4
	// Position of TXBUFE field.
	SSC_IMR_TXBUFE_Pos = 0x3
	// Bit mask of TXBUFE field.
	SSC_IMR_TXBUFE_Msk = 0x8
	// Bit TXBUFE.
	SSC_IMR_TXBUFE = 0x8
	// Position of RXRDY field.
	SSC_IMR_RXRDY_Pos = 0x4
	// Bit mask of RXRDY field.
	SSC_IMR_RXRDY_Msk = 0x10
	// Bit RXRDY.
	SSC_IMR_RXRDY = 0x10
	// Position of OVRUN field.
	SSC_IMR_OVRUN_Pos = 0x5
	// Bit mask of OVRUN field.
	SSC_IMR_OVRUN_Msk = 0x20
	// Bit OVRUN.
	SSC_IMR_OVRUN = 0x20
	// Position of ENDRX field.
	SSC_IMR_ENDRX_Pos = 0x6
	// Bit mask of ENDRX field.
	SSC_IMR_ENDRX_Msk = 0x40
	// Bit ENDRX.
	SSC_IMR_ENDRX = 0x40
	// Position of RXBUFF field.
	SSC_IMR_RXBUFF_Pos = 0x7
	// Bit mask of RXBUFF field.
	SSC_IMR_RXBUFF_Msk = 0x80
	// Bit RXBUFF.
	SSC_IMR_RXBUFF = 0x80
	// Position of CP0 field.
	SSC_IMR_CP0_Pos = 0x8
	// Bit mask of CP0 field.
	SSC_IMR_CP0_Msk = 0x100
	// Bit CP0.
	SSC_IMR_CP0 = 0x100
	// Position of CP1 field.
	SSC_IMR_CP1_Pos = 0x9
	// Bit mask of CP1 field.
	SSC_IMR_CP1_Msk = 0x200
	// Bit CP1.
	SSC_IMR_CP1 = 0x200
	// Position of TXSYN field.
	SSC_IMR_TXSYN_Pos = 0xa
	// Bit mask of TXSYN field.
	SSC_IMR_TXSYN_Msk = 0x400
	// Bit TXSYN.
	SSC_IMR_TXSYN = 0x400
	// Position of RXSYN field.
	SSC_IMR_RXSYN_Pos = 0xb
	// Bit mask of RXSYN field.
	SSC_IMR_RXSYN_Msk = 0x800
	// Bit RXSYN.
	SSC_IMR_RXSYN = 0x800

	// WPMR: Write Protection Mode Register
	// Position of WPEN field.
	SSC_WPMR_WPEN_Pos = 0x0
	// Bit mask of WPEN field.
	SSC_WPMR_WPEN_Msk = 0x1
	// Bit WPEN.
	SSC_WPMR_WPEN = 0x1
	// Position of WPKEY field.
	SSC_WPMR_WPKEY_Pos = 0x8
	// Bit mask of WPKEY field.
	SSC_WPMR_WPKEY_Msk = 0xffffff00
	// Writing any other value in this field aborts the write operation of the WPEN bit.Always reads as 0.
	SSC_WPMR_WPKEY_PASSWD = 0x535343

	// WPSR: Write Protection Status Register
	// Position of WPVS field.
	SSC_WPSR_WPVS_Pos = 0x0
	// Bit mask of WPVS field.
	SSC_WPSR_WPVS_Msk = 0x1
	// Bit WPVS.
	SSC_WPSR_WPVS = 0x1
	// Position of WPVSRC field.
	SSC_WPSR_WPVSRC_Pos = 0x8
	// Bit mask of WPVSRC field.
	SSC_WPSR_WPVSRC_Msk = 0xffff00

	// RPR: Receive Pointer Register
	// Position of RXPTR field.
	SSC_RPR_RXPTR_Pos = 0x0
	// Bit mask of RXPTR field.
	SSC_RPR_RXPTR_Msk = 0xffffffff

	// RCR: Receive Counter Register
	// Position of RXCTR field.
	SSC_RCR_RXCTR_Pos = 0x0
	// Bit mask of RXCTR field.
	SSC_RCR_RXCTR_Msk = 0xffff

	// TPR: Transmit Pointer Register
	// Position of TXPTR field.
	SSC_TPR_TXPTR_Pos = 0x0
	// Bit mask of TXPTR field.
	SSC_TPR_TXPTR_Msk = 0xffffffff

	// TCR: Transmit Counter Register
	// Position of TXCTR field.
	SSC_TCR_TXCTR_Pos = 0x0
	// Bit mask of TXCTR field.
	SSC_TCR_TXCTR_Msk = 0xffff

	// RNPR: Receive Next Pointer Register
	// Position of RXNPTR field.
	SSC_RNPR_RXNPTR_Pos = 0x0
	// Bit mask of RXNPTR field.
	SSC_RNPR_RXNPTR_Msk = 0xffffffff

	// RNCR: Receive Next Counter Register
	// Position of RXNCTR field.
	SSC_RNCR_RXNCTR_Pos = 0x0
	// Bit mask of RXNCTR field.
	SSC_RNCR_RXNCTR_Msk = 0xffff

	// TNPR: Transmit Next Pointer Register
	// Position of TXNPTR field.
	SSC_TNPR_TXNPTR_Pos = 0x0
	// Bit mask of TXNPTR field.
	SSC_TNPR_TXNPTR_Msk = 0xffffffff

	// TNCR: Transmit Next Counter Register
	// Position of TXNCTR field.
	SSC_TNCR_TXNCTR_Pos = 0x0
	// Bit mask of TXNCTR field.
	SSC_TNCR_TXNCTR_Msk = 0xffff

	// PTCR: Transfer Control Register
	// Position of RXTEN field.
	SSC_PTCR_RXTEN_Pos = 0x0
	// Bit mask of RXTEN field.
	SSC_PTCR_RXTEN_Msk = 0x1
	// Bit RXTEN.
	SSC_PTCR_RXTEN = 0x1
	// Position of RXTDIS field.
	SSC_PTCR_RXTDIS_Pos = 0x1
	// Bit mask of RXTDIS field.
	SSC_PTCR_RXTDIS_Msk = 0x2
	// Bit RXTDIS.
	SSC_PTCR_RXTDIS = 0x2
	// Position of TXTEN field.
	SSC_PTCR_TXTEN_Pos = 0x8
	// Bit mask of TXTEN field.
	SSC_PTCR_TXTEN_Msk = 0x100
	// Bit TXTEN.
	SSC_PTCR_TXTEN = 0x100
	// Position of TXTDIS field.
	SSC_PTCR_TXTDIS_Pos = 0x9
	// Bit mask of TXTDIS field.
	SSC_PTCR_TXTDIS_Msk = 0x200
	// Bit TXTDIS.
	SSC_PTCR_TXTDIS = 0x200

	// PTSR: Transfer Status Register
	// Position of RXTEN field.
	SSC_PTSR_RXTEN_Pos = 0x0
	// Bit mask of RXTEN field.
	SSC_PTSR_RXTEN_Msk = 0x1
	// Bit RXTEN.
	SSC_PTSR_RXTEN = 0x1
	// Position of TXTEN field.
	SSC_PTSR_TXTEN_Pos = 0x8
	// Bit mask of TXTEN field.
	SSC_PTSR_TXTEN_Msk = 0x100
	// Bit TXTEN.
	SSC_PTSR_TXTEN = 0x100
)

// Constants for SPI: Serial Peripheral Interface
const (
	// CR: Control Register
	// Position of SPIEN field.
	SPI_CR_SPIEN_Pos = 0x0
	// Bit mask of SPIEN field.
	SPI_CR_SPIEN_Msk = 0x1
	// Bit SPIEN.
	SPI_CR_SPIEN = 0x1
	// Position of SPIDIS field.
	SPI_CR_SPIDIS_Pos = 0x1
	// Bit mask of SPIDIS field.
	SPI_CR_SPIDIS_Msk = 0x2
	// Bit SPIDIS.
	SPI_CR_SPIDIS = 0x2
	// Position of SWRST field.
	SPI_CR_SWRST_Pos = 0x7
	// Bit mask of SWRST field.
	SPI_CR_SWRST_Msk = 0x80
	// Bit SWRST.
	SPI_CR_SWRST = 0x80
	// Position of LASTXFER field.
	SPI_CR_LASTXFER_Pos = 0x18
	// Bit mask of LASTXFER field.
	SPI_CR_LASTXFER_Msk = 0x1000000
	// Bit LASTXFER.
	SPI_CR_LASTXFER = 0x1000000

	// MR: Mode Register
	// Position of MSTR field.
	SPI_MR_MSTR_Pos = 0x0
	// Bit mask of MSTR field.
	SPI_MR_MSTR_Msk = 0x1
	// Bit MSTR.
	SPI_MR_MSTR = 0x1
	// Position of PS field.
	SPI_MR_PS_Pos = 0x1
	// Bit mask of PS field.
	SPI_MR_PS_Msk = 0x2
	// Bit PS.
	SPI_MR_PS = 0x2
	// Position of PCSDEC field.
	SPI_MR_PCSDEC_Pos = 0x2
	// Bit mask of PCSDEC field.
	SPI_MR_PCSDEC_Msk = 0x4
	// Bit PCSDEC.
	SPI_MR_PCSDEC = 0x4
	// Position of MODFDIS field.
	SPI_MR_MODFDIS_Pos = 0x4
	// Bit mask of MODFDIS field.
	SPI_MR_MODFDIS_Msk = 0x10
	// Bit MODFDIS.
	SPI_MR_MODFDIS = 0x10
	// Position of WDRBT field.
	SPI_MR_WDRBT_Pos = 0x5
	// Bit mask of WDRBT field.
	SPI_MR_WDRBT_Msk = 0x20
	// Bit WDRBT.
	SPI_MR_WDRBT = 0x20
	// Position of LLB field.
	SPI_MR_LLB_Pos = 0x7
	// Bit mask of LLB field.
	SPI_MR_LLB_Msk = 0x80
	// Bit LLB.
	SPI_MR_LLB = 0x80
	// Position of PCS field.
	SPI_MR_PCS_Pos = 0x10
	// Bit mask of PCS field.
	SPI_MR_PCS_Msk = 0xf0000
	// Position of DLYBCS field.
	SPI_MR_DLYBCS_Pos = 0x18
	// Bit mask of DLYBCS field.
	SPI_MR_DLYBCS_Msk = 0xff000000

	// RDR: Receive Data Register
	// Position of RD field.
	SPI_RDR_RD_Pos = 0x0
	// Bit mask of RD field.
	SPI_RDR_RD_Msk = 0xffff
	// Position of PCS field.
	SPI_RDR_PCS_Pos = 0x10
	// Bit mask of PCS field.
	SPI_RDR_PCS_Msk = 0xf0000

	// TDR: Transmit Data Register
	// Position of TD field.
	SPI_TDR_TD_Pos = 0x0
	// Bit mask of TD field.
	SPI_TDR_TD_Msk = 0xffff
	// Position of PCS field.
	SPI_TDR_PCS_Pos = 0x10
	// Bit mask of PCS field.
	SPI_TDR_PCS_Msk = 0xf0000
	// Position of LASTXFER field.
	SPI_TDR_LASTXFER_Pos = 0x18
	// Bit mask of LASTXFER field.
	SPI_TDR_LASTXFER_Msk = 0x1000000
	// Bit LASTXFER.
	SPI_TDR_LASTXFER = 0x1000000

	// SR: Status Register
	// Position of RDRF field.
	SPI_SR_RDRF_Pos = 0x0
	// Bit mask of RDRF field.
	SPI_SR_RDRF_Msk = 0x1
	// Bit RDRF.
	SPI_SR_RDRF = 0x1
	// Position of TDRE field.
	SPI_SR_TDRE_Pos = 0x1
	// Bit mask of TDRE field.
	SPI_SR_TDRE_Msk = 0x2
	// Bit TDRE.
	SPI_SR_TDRE = 0x2
	// Position of MODF field.
	SPI_SR_MODF_Pos = 0x2
	// Bit mask of MODF field.
	SPI_SR_MODF_Msk = 0x4
	// Bit MODF.
	SPI_SR_MODF = 0x4
	// Position of OVRES field.
	SPI_SR_OVRES_Pos = 0x3
	// Bit mask of OVRES field.
	SPI_SR_OVRES_Msk = 0x8
	// Bit OVRES.
	SPI_SR_OVRES = 0x8
	// Position of ENDRX field.
	SPI_SR_ENDRX_Pos = 0x4
	// Bit mask of ENDRX field.
	SPI_SR_ENDRX_Msk = 0x10
	// Bit ENDRX.
	SPI_SR_ENDRX = 0x10
	// Position of ENDTX field.
	SPI_SR_ENDTX_Pos = 0x5
	// Bit mask of ENDTX field.
	SPI_SR_ENDTX_Msk = 0x20
	// Bit ENDTX.
	SPI_SR_ENDTX = 0x20
	// Position of RXBUFF field.
	SPI_SR_RXBUFF_Pos = 0x6
	// Bit mask of RXBUFF field.
	SPI_SR_RXBUFF_Msk = 0x40
	// Bit RXBUFF.
	SPI_SR_RXBUFF = 0x40
	// Position of TXBUFE field.
	SPI_SR_TXBUFE_Pos = 0x7
	// Bit mask of TXBUFE field.
	SPI_SR_TXBUFE_Msk = 0x80
	// Bit TXBUFE.
	SPI_SR_TXBUFE = 0x80
	// Position of NSSR field.
	SPI_SR_NSSR_Pos = 0x8
	// Bit mask of NSSR field.
	SPI_SR_NSSR_Msk = 0x100
	// Bit NSSR.
	SPI_SR_NSSR = 0x100
	// Position of TXEMPTY field.
	SPI_SR_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	SPI_SR_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	SPI_SR_TXEMPTY = 0x200
	// Position of UNDES field.
	SPI_SR_UNDES_Pos = 0xa
	// Bit mask of UNDES field.
	SPI_SR_UNDES_Msk = 0x400
	// Bit UNDES.
	SPI_SR_UNDES = 0x400
	// Position of SPIENS field.
	SPI_SR_SPIENS_Pos = 0x10
	// Bit mask of SPIENS field.
	SPI_SR_SPIENS_Msk = 0x10000
	// Bit SPIENS.
	SPI_SR_SPIENS = 0x10000

	// IER: Interrupt Enable Register
	// Position of RDRF field.
	SPI_IER_RDRF_Pos = 0x0
	// Bit mask of RDRF field.
	SPI_IER_RDRF_Msk = 0x1
	// Bit RDRF.
	SPI_IER_RDRF = 0x1
	// Position of TDRE field.
	SPI_IER_TDRE_Pos = 0x1
	// Bit mask of TDRE field.
	SPI_IER_TDRE_Msk = 0x2
	// Bit TDRE.
	SPI_IER_TDRE = 0x2
	// Position of MODF field.
	SPI_IER_MODF_Pos = 0x2
	// Bit mask of MODF field.
	SPI_IER_MODF_Msk = 0x4
	// Bit MODF.
	SPI_IER_MODF = 0x4
	// Position of OVRES field.
	SPI_IER_OVRES_Pos = 0x3
	// Bit mask of OVRES field.
	SPI_IER_OVRES_Msk = 0x8
	// Bit OVRES.
	SPI_IER_OVRES = 0x8
	// Position of ENDRX field.
	SPI_IER_ENDRX_Pos = 0x4
	// Bit mask of ENDRX field.
	SPI_IER_ENDRX_Msk = 0x10
	// Bit ENDRX.
	SPI_IER_ENDRX = 0x10
	// Position of ENDTX field.
	SPI_IER_ENDTX_Pos = 0x5
	// Bit mask of ENDTX field.
	SPI_IER_ENDTX_Msk = 0x20
	// Bit ENDTX.
	SPI_IER_ENDTX = 0x20
	// Position of RXBUFF field.
	SPI_IER_RXBUFF_Pos = 0x6
	// Bit mask of RXBUFF field.
	SPI_IER_RXBUFF_Msk = 0x40
	// Bit RXBUFF.
	SPI_IER_RXBUFF = 0x40
	// Position of TXBUFE field.
	SPI_IER_TXBUFE_Pos = 0x7
	// Bit mask of TXBUFE field.
	SPI_IER_TXBUFE_Msk = 0x80
	// Bit TXBUFE.
	SPI_IER_TXBUFE = 0x80
	// Position of NSSR field.
	SPI_IER_NSSR_Pos = 0x8
	// Bit mask of NSSR field.
	SPI_IER_NSSR_Msk = 0x100
	// Bit NSSR.
	SPI_IER_NSSR = 0x100
	// Position of TXEMPTY field.
	SPI_IER_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	SPI_IER_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	SPI_IER_TXEMPTY = 0x200
	// Position of UNDES field.
	SPI_IER_UNDES_Pos = 0xa
	// Bit mask of UNDES field.
	SPI_IER_UNDES_Msk = 0x400
	// Bit UNDES.
	SPI_IER_UNDES = 0x400

	// IDR: Interrupt Disable Register
	// Position of RDRF field.
	SPI_IDR_RDRF_Pos = 0x0
	// Bit mask of RDRF field.
	SPI_IDR_RDRF_Msk = 0x1
	// Bit RDRF.
	SPI_IDR_RDRF = 0x1
	// Position of TDRE field.
	SPI_IDR_TDRE_Pos = 0x1
	// Bit mask of TDRE field.
	SPI_IDR_TDRE_Msk = 0x2
	// Bit TDRE.
	SPI_IDR_TDRE = 0x2
	// Position of MODF field.
	SPI_IDR_MODF_Pos = 0x2
	// Bit mask of MODF field.
	SPI_IDR_MODF_Msk = 0x4
	// Bit MODF.
	SPI_IDR_MODF = 0x4
	// Position of OVRES field.
	SPI_IDR_OVRES_Pos = 0x3
	// Bit mask of OVRES field.
	SPI_IDR_OVRES_Msk = 0x8
	// Bit OVRES.
	SPI_IDR_OVRES = 0x8
	// Position of ENDRX field.
	SPI_IDR_ENDRX_Pos = 0x4
	// Bit mask of ENDRX field.
	SPI_IDR_ENDRX_Msk = 0x10
	// Bit ENDRX.
	SPI_IDR_ENDRX = 0x10
	// Position of ENDTX field.
	SPI_IDR_ENDTX_Pos = 0x5
	// Bit mask of ENDTX field.
	SPI_IDR_ENDTX_Msk = 0x20
	// Bit ENDTX.
	SPI_IDR_ENDTX = 0x20
	// Position of RXBUFF field.
	SPI_IDR_RXBUFF_Pos = 0x6
	// Bit mask of RXBUFF field.
	SPI_IDR_RXBUFF_Msk = 0x40
	// Bit RXBUFF.
	SPI_IDR_RXBUFF = 0x40
	// Position of TXBUFE field.
	SPI_IDR_TXBUFE_Pos = 0x7
	// Bit mask of TXBUFE field.
	SPI_IDR_TXBUFE_Msk = 0x80
	// Bit TXBUFE.
	SPI_IDR_TXBUFE = 0x80
	// Position of NSSR field.
	SPI_IDR_NSSR_Pos = 0x8
	// Bit mask of NSSR field.
	SPI_IDR_NSSR_Msk = 0x100
	// Bit NSSR.
	SPI_IDR_NSSR = 0x100
	// Position of TXEMPTY field.
	SPI_IDR_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	SPI_IDR_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	SPI_IDR_TXEMPTY = 0x200
	// Position of UNDES field.
	SPI_IDR_UNDES_Pos = 0xa
	// Bit mask of UNDES field.
	SPI_IDR_UNDES_Msk = 0x400
	// Bit UNDES.
	SPI_IDR_UNDES = 0x400

	// IMR: Interrupt Mask Register
	// Position of RDRF field.
	SPI_IMR_RDRF_Pos = 0x0
	// Bit mask of RDRF field.
	SPI_IMR_RDRF_Msk = 0x1
	// Bit RDRF.
	SPI_IMR_RDRF = 0x1
	// Position of TDRE field.
	SPI_IMR_TDRE_Pos = 0x1
	// Bit mask of TDRE field.
	SPI_IMR_TDRE_Msk = 0x2
	// Bit TDRE.
	SPI_IMR_TDRE = 0x2
	// Position of MODF field.
	SPI_IMR_MODF_Pos = 0x2
	// Bit mask of MODF field.
	SPI_IMR_MODF_Msk = 0x4
	// Bit MODF.
	SPI_IMR_MODF = 0x4
	// Position of OVRES field.
	SPI_IMR_OVRES_Pos = 0x3
	// Bit mask of OVRES field.
	SPI_IMR_OVRES_Msk = 0x8
	// Bit OVRES.
	SPI_IMR_OVRES = 0x8
	// Position of ENDRX field.
	SPI_IMR_ENDRX_Pos = 0x4
	// Bit mask of ENDRX field.
	SPI_IMR_ENDRX_Msk = 0x10
	// Bit ENDRX.
	SPI_IMR_ENDRX = 0x10
	// Position of ENDTX field.
	SPI_IMR_ENDTX_Pos = 0x5
	// Bit mask of ENDTX field.
	SPI_IMR_ENDTX_Msk = 0x20
	// Bit ENDTX.
	SPI_IMR_ENDTX = 0x20
	// Position of RXBUFF field.
	SPI_IMR_RXBUFF_Pos = 0x6
	// Bit mask of RXBUFF field.
	SPI_IMR_RXBUFF_Msk = 0x40
	// Bit RXBUFF.
	SPI_IMR_RXBUFF = 0x40
	// Position of TXBUFE field.
	SPI_IMR_TXBUFE_Pos = 0x7
	// Bit mask of TXBUFE field.
	SPI_IMR_TXBUFE_Msk = 0x80
	// Bit TXBUFE.
	SPI_IMR_TXBUFE = 0x80
	// Position of NSSR field.
	SPI_IMR_NSSR_Pos = 0x8
	// Bit mask of NSSR field.
	SPI_IMR_NSSR_Msk = 0x100
	// Bit NSSR.
	SPI_IMR_NSSR = 0x100
	// Position of TXEMPTY field.
	SPI_IMR_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	SPI_IMR_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	SPI_IMR_TXEMPTY = 0x200
	// Position of UNDES field.
	SPI_IMR_UNDES_Pos = 0xa
	// Bit mask of UNDES field.
	SPI_IMR_UNDES_Msk = 0x400
	// Bit UNDES.
	SPI_IMR_UNDES = 0x400

	// CSR: Chip Select Register
	// Position of CPOL field.
	SPI_CSR_CPOL_Pos = 0x0
	// Bit mask of CPOL field.
	SPI_CSR_CPOL_Msk = 0x1
	// Bit CPOL.
	SPI_CSR_CPOL = 0x1
	// Position of NCPHA field.
	SPI_CSR_NCPHA_Pos = 0x1
	// Bit mask of NCPHA field.
	SPI_CSR_NCPHA_Msk = 0x2
	// Bit NCPHA.
	SPI_CSR_NCPHA = 0x2
	// Position of CSNAAT field.
	SPI_CSR_CSNAAT_Pos = 0x2
	// Bit mask of CSNAAT field.
	SPI_CSR_CSNAAT_Msk = 0x4
	// Bit CSNAAT.
	SPI_CSR_CSNAAT = 0x4
	// Position of CSAAT field.
	SPI_CSR_CSAAT_Pos = 0x3
	// Bit mask of CSAAT field.
	SPI_CSR_CSAAT_Msk = 0x8
	// Bit CSAAT.
	SPI_CSR_CSAAT = 0x8
	// Position of BITS field.
	SPI_CSR_BITS_Pos = 0x4
	// Bit mask of BITS field.
	SPI_CSR_BITS_Msk = 0xf0
	// 8 bits for transfer
	SPI_CSR_BITS_8_BIT = 0x0
	// 9 bits for transfer
	SPI_CSR_BITS_9_BIT = 0x1
	// 10 bits for transfer
	SPI_CSR_BITS_10_BIT = 0x2
	// 11 bits for transfer
	SPI_CSR_BITS_11_BIT = 0x3
	// 12 bits for transfer
	SPI_CSR_BITS_12_BIT = 0x4
	// 13 bits for transfer
	SPI_CSR_BITS_13_BIT = 0x5
	// 14 bits for transfer
	SPI_CSR_BITS_14_BIT = 0x6
	// 15 bits for transfer
	SPI_CSR_BITS_15_BIT = 0x7
	// 16 bits for transfer
	SPI_CSR_BITS_16_BIT = 0x8
	// Position of SCBR field.
	SPI_CSR_SCBR_Pos = 0x8
	// Bit mask of SCBR field.
	SPI_CSR_SCBR_Msk = 0xff00
	// Position of DLYBS field.
	SPI_CSR_DLYBS_Pos = 0x10
	// Bit mask of DLYBS field.
	SPI_CSR_DLYBS_Msk = 0xff0000
	// Position of DLYBCT field.
	SPI_CSR_DLYBCT_Pos = 0x18
	// Bit mask of DLYBCT field.
	SPI_CSR_DLYBCT_Msk = 0xff000000

	// WPMR: Write Protection Mode Register
	// Position of WPEN field.
	SPI_WPMR_WPEN_Pos = 0x0
	// Bit mask of WPEN field.
	SPI_WPMR_WPEN_Msk = 0x1
	// Bit WPEN.
	SPI_WPMR_WPEN = 0x1
	// Position of WPKEY field.
	SPI_WPMR_WPKEY_Pos = 0x8
	// Bit mask of WPKEY field.
	SPI_WPMR_WPKEY_Msk = 0xffffff00
	// Writing any other value in this field aborts the write operation of the WPEN bit.Always reads as 0.
	SPI_WPMR_WPKEY_PASSWD = 0x535049

	// WPSR: Write Protection Status Register
	// Position of WPVS field.
	SPI_WPSR_WPVS_Pos = 0x0
	// Bit mask of WPVS field.
	SPI_WPSR_WPVS_Msk = 0x1
	// Bit WPVS.
	SPI_WPSR_WPVS = 0x1
	// Position of WPVSRC field.
	SPI_WPSR_WPVSRC_Pos = 0x8
	// Bit mask of WPVSRC field.
	SPI_WPSR_WPVSRC_Msk = 0xff00

	// RPR: Receive Pointer Register
	// Position of RXPTR field.
	SPI_RPR_RXPTR_Pos = 0x0
	// Bit mask of RXPTR field.
	SPI_RPR_RXPTR_Msk = 0xffffffff

	// RCR: Receive Counter Register
	// Position of RXCTR field.
	SPI_RCR_RXCTR_Pos = 0x0
	// Bit mask of RXCTR field.
	SPI_RCR_RXCTR_Msk = 0xffff

	// TPR: Transmit Pointer Register
	// Position of TXPTR field.
	SPI_TPR_TXPTR_Pos = 0x0
	// Bit mask of TXPTR field.
	SPI_TPR_TXPTR_Msk = 0xffffffff

	// TCR: Transmit Counter Register
	// Position of TXCTR field.
	SPI_TCR_TXCTR_Pos = 0x0
	// Bit mask of TXCTR field.
	SPI_TCR_TXCTR_Msk = 0xffff

	// RNPR: Receive Next Pointer Register
	// Position of RXNPTR field.
	SPI_RNPR_RXNPTR_Pos = 0x0
	// Bit mask of RXNPTR field.
	SPI_RNPR_RXNPTR_Msk = 0xffffffff

	// RNCR: Receive Next Counter Register
	// Position of RXNCTR field.
	SPI_RNCR_RXNCTR_Pos = 0x0
	// Bit mask of RXNCTR field.
	SPI_RNCR_RXNCTR_Msk = 0xffff

	// TNPR: Transmit Next Pointer Register
	// Position of TXNPTR field.
	SPI_TNPR_TXNPTR_Pos = 0x0
	// Bit mask of TXNPTR field.
	SPI_TNPR_TXNPTR_Msk = 0xffffffff

	// TNCR: Transmit Next Counter Register
	// Position of TXNCTR field.
	SPI_TNCR_TXNCTR_Pos = 0x0
	// Bit mask of TXNCTR field.
	SPI_TNCR_TXNCTR_Msk = 0xffff

	// PTCR: Transfer Control Register
	// Position of RXTEN field.
	SPI_PTCR_RXTEN_Pos = 0x0
	// Bit mask of RXTEN field.
	SPI_PTCR_RXTEN_Msk = 0x1
	// Bit RXTEN.
	SPI_PTCR_RXTEN = 0x1
	// Position of RXTDIS field.
	SPI_PTCR_RXTDIS_Pos = 0x1
	// Bit mask of RXTDIS field.
	SPI_PTCR_RXTDIS_Msk = 0x2
	// Bit RXTDIS.
	SPI_PTCR_RXTDIS = 0x2
	// Position of TXTEN field.
	SPI_PTCR_TXTEN_Pos = 0x8
	// Bit mask of TXTEN field.
	SPI_PTCR_TXTEN_Msk = 0x100
	// Bit TXTEN.
	SPI_PTCR_TXTEN = 0x100
	// Position of TXTDIS field.
	SPI_PTCR_TXTDIS_Pos = 0x9
	// Bit mask of TXTDIS field.
	SPI_PTCR_TXTDIS_Msk = 0x200
	// Bit TXTDIS.
	SPI_PTCR_TXTDIS = 0x200

	// PTSR: Transfer Status Register
	// Position of RXTEN field.
	SPI_PTSR_RXTEN_Pos = 0x0
	// Bit mask of RXTEN field.
	SPI_PTSR_RXTEN_Msk = 0x1
	// Bit RXTEN.
	SPI_PTSR_RXTEN = 0x1
	// Position of TXTEN field.
	SPI_PTSR_TXTEN_Pos = 0x8
	// Bit mask of TXTEN field.
	SPI_PTSR_TXTEN_Msk = 0x100
	// Bit TXTEN.
	SPI_PTSR_TXTEN = 0x100
)

// Constants for TC0: Timer Counter 0
const (
	// CCR0: Channel Control Register (channel = 0)
	// Position of CLKEN field.
	TC_CCR0_CLKEN_Pos = 0x0
	// Bit mask of CLKEN field.
	TC_CCR0_CLKEN_Msk = 0x1
	// Bit CLKEN.
	TC_CCR0_CLKEN = 0x1
	// Position of CLKDIS field.
	TC_CCR0_CLKDIS_Pos = 0x1
	// Bit mask of CLKDIS field.
	TC_CCR0_CLKDIS_Msk = 0x2
	// Bit CLKDIS.
	TC_CCR0_CLKDIS = 0x2
	// Position of SWTRG field.
	TC_CCR0_SWTRG_Pos = 0x2
	// Bit mask of SWTRG field.
	TC_CCR0_SWTRG_Msk = 0x4
	// Bit SWTRG.
	TC_CCR0_SWTRG = 0x4

	// CMR0: Channel Mode Register (channel = 0)
	// Position of TCCLKS field.
	TC_CMR0_TCCLKS_Pos = 0x0
	// Bit mask of TCCLKS field.
	TC_CMR0_TCCLKS_Msk = 0x7
	// Clock selected: internal MCK/2 clock signal (from PMC)
	TC_CMR0_TCCLKS_TIMER_CLOCK1 = 0x0
	// Clock selected: internal MCK/8 clock signal (from PMC)
	TC_CMR0_TCCLKS_TIMER_CLOCK2 = 0x1
	// Clock selected: internal MCK/32 clock signal (from PMC)
	TC_CMR0_TCCLKS_TIMER_CLOCK3 = 0x2
	// Clock selected: internal MCK/128 clock signal (from PMC)
	TC_CMR0_TCCLKS_TIMER_CLOCK4 = 0x3
	// Clock selected: internal SLCK clock signal (from PMC)
	TC_CMR0_TCCLKS_TIMER_CLOCK5 = 0x4
	// Clock selected: XC0
	TC_CMR0_TCCLKS_XC0 = 0x5
	// Clock selected: XC1
	TC_CMR0_TCCLKS_XC1 = 0x6
	// Clock selected: XC2
	TC_CMR0_TCCLKS_XC2 = 0x7
	// Position of CLKI field.
	TC_CMR0_CLKI_Pos = 0x3
	// Bit mask of CLKI field.
	TC_CMR0_CLKI_Msk = 0x8
	// Bit CLKI.
	TC_CMR0_CLKI = 0x8
	// Position of BURST field.
	TC_CMR0_BURST_Pos = 0x4
	// Bit mask of BURST field.
	TC_CMR0_BURST_Msk = 0x30
	// The clock is not gated by an external signal.
	TC_CMR0_BURST_NONE = 0x0
	// XC0 is ANDed with the selected clock.
	TC_CMR0_BURST_XC0 = 0x1
	// XC1 is ANDed with the selected clock.
	TC_CMR0_BURST_XC1 = 0x2
	// XC2 is ANDed with the selected clock.
	TC_CMR0_BURST_XC2 = 0x3
	// Position of LDBSTOP field.
	TC_CMR0_LDBSTOP_Pos = 0x6
	// Bit mask of LDBSTOP field.
	TC_CMR0_LDBSTOP_Msk = 0x40
	// Bit LDBSTOP.
	TC_CMR0_LDBSTOP = 0x40
	// Position of LDBDIS field.
	TC_CMR0_LDBDIS_Pos = 0x7
	// Bit mask of LDBDIS field.
	TC_CMR0_LDBDIS_Msk = 0x80
	// Bit LDBDIS.
	TC_CMR0_LDBDIS = 0x80
	// Position of ETRGEDG field.
	TC_CMR0_ETRGEDG_Pos = 0x8
	// Bit mask of ETRGEDG field.
	TC_CMR0_ETRGEDG_Msk = 0x300
	// The clock is not gated by an external signal.
	TC_CMR0_ETRGEDG_NONE = 0x0
	// Rising edge
	TC_CMR0_ETRGEDG_RISING = 0x1
	// Falling edge
	TC_CMR0_ETRGEDG_FALLING = 0x2
	// Each edge
	TC_CMR0_ETRGEDG_EDGE = 0x3
	// Position of ABETRG field.
	TC_CMR0_ABETRG_Pos = 0xa
	// Bit mask of ABETRG field.
	TC_CMR0_ABETRG_Msk = 0x400
	// Bit ABETRG.
	TC_CMR0_ABETRG = 0x400
	// Position of CPCTRG field.
	TC_CMR0_CPCTRG_Pos = 0xe
	// Bit mask of CPCTRG field.
	TC_CMR0_CPCTRG_Msk = 0x4000
	// Bit CPCTRG.
	TC_CMR0_CPCTRG = 0x4000
	// Position of WAVE field.
	TC_CMR0_WAVE_Pos = 0xf
	// Bit mask of WAVE field.
	TC_CMR0_WAVE_Msk = 0x8000
	// Bit WAVE.
	TC_CMR0_WAVE = 0x8000
	// Position of LDRA field.
	TC_CMR0_LDRA_Pos = 0x10
	// Bit mask of LDRA field.
	TC_CMR0_LDRA_Msk = 0x30000
	// None
	TC_CMR0_LDRA_NONE = 0x0
	// Rising edge of TIOA
	TC_CMR0_LDRA_RISING = 0x1
	// Falling edge of TIOA
	TC_CMR0_LDRA_FALLING = 0x2
	// Each edge of TIOA
	TC_CMR0_LDRA_EDGE = 0x3
	// Position of LDRB field.
	TC_CMR0_LDRB_Pos = 0x12
	// Bit mask of LDRB field.
	TC_CMR0_LDRB_Msk = 0xc0000
	// None
	TC_CMR0_LDRB_NONE = 0x0
	// Rising edge of TIOA
	TC_CMR0_LDRB_RISING = 0x1
	// Falling edge of TIOA
	TC_CMR0_LDRB_FALLING = 0x2
	// Each edge of TIOA
	TC_CMR0_LDRB_EDGE = 0x3

	// CMR0_WAVEFORM_MODE: Channel Mode Register (channel = 0)
	// Position of TCCLKS field.
	TC_CMR0_WAVEFORM_MODE_TCCLKS_Pos = 0x0
	// Bit mask of TCCLKS field.
	TC_CMR0_WAVEFORM_MODE_TCCLKS_Msk = 0x7
	// Clock selected: internal MCK/2 clock signal (from PMC)
	TC_CMR0_WAVEFORM_MODE_TCCLKS_TIMER_CLOCK1 = 0x0
	// Clock selected: internal MCK/8 clock signal (from PMC)
	TC_CMR0_WAVEFORM_MODE_TCCLKS_TIMER_CLOCK2 = 0x1
	// Clock selected: internal MCK/32 clock signal (from PMC)
	TC_CMR0_WAVEFORM_MODE_TCCLKS_TIMER_CLOCK3 = 0x2
	// Clock selected: internal MCK/128 clock signal (from PMC)
	TC_CMR0_WAVEFORM_MODE_TCCLKS_TIMER_CLOCK4 = 0x3
	// Clock selected: internal SLCK clock signal (from PMC)
	TC_CMR0_WAVEFORM_MODE_TCCLKS_TIMER_CLOCK5 = 0x4
	// Clock selected: XC0
	TC_CMR0_WAVEFORM_MODE_TCCLKS_XC0 = 0x5
	// Clock selected: XC1
	TC_CMR0_WAVEFORM_MODE_TCCLKS_XC1 = 0x6
	// Clock selected: XC2
	TC_CMR0_WAVEFORM_MODE_TCCLKS_XC2 = 0x7
	// Position of CLKI field.
	TC_CMR0_WAVEFORM_MODE_CLKI_Pos = 0x3
	// Bit mask of CLKI field.
	TC_CMR0_WAVEFORM_MODE_CLKI_Msk = 0x8
	// Bit CLKI.
	TC_CMR0_WAVEFORM_MODE_CLKI = 0x8
	// Position of BURST field.
	TC_CMR0_WAVEFORM_MODE_BURST_Pos = 0x4
	// Bit mask of BURST field.
	TC_CMR0_WAVEFORM_MODE_BURST_Msk = 0x30
	// The clock is not gated by an external signal.
	TC_CMR0_WAVEFORM_MODE_BURST_NONE = 0x0
	// XC0 is ANDed with the selected clock.
	TC_CMR0_WAVEFORM_MODE_BURST_XC0 = 0x1
	// XC1 is ANDed with the selected clock.
	TC_CMR0_WAVEFORM_MODE_BURST_XC1 = 0x2
	// XC2 is ANDed with the selected clock.
	TC_CMR0_WAVEFORM_MODE_BURST_XC2 = 0x3
	// Position of CPCSTOP field.
	TC_CMR0_WAVEFORM_MODE_CPCSTOP_Pos = 0x6
	// Bit mask of CPCSTOP field.
	TC_CMR0_WAVEFORM_MODE_CPCSTOP_Msk = 0x40
	// Bit CPCSTOP.
	TC_CMR0_WAVEFORM_MODE_CPCSTOP = 0x40
	// Position of CPCDIS field.
	TC_CMR0_WAVEFORM_MODE_CPCDIS_Pos = 0x7
	// Bit mask of CPCDIS field.
	TC_CMR0_WAVEFORM_MODE_CPCDIS_Msk = 0x80
	// Bit CPCDIS.
	TC_CMR0_WAVEFORM_MODE_CPCDIS = 0x80
	// Position of EEVTEDG field.
	TC_CMR0_WAVEFORM_MODE_EEVTEDG_Pos = 0x8
	// Bit mask of EEVTEDG field.
	TC_CMR0_WAVEFORM_MODE_EEVTEDG_Msk = 0x300
	// None
	TC_CMR0_WAVEFORM_MODE_EEVTEDG_NONE = 0x0
	// Rising edge
	TC_CMR0_WAVEFORM_MODE_EEVTEDG_RISING = 0x1
	// Falling edge
	TC_CMR0_WAVEFORM_MODE_EEVTEDG_FALLING = 0x2
	// Each edge
	TC_CMR0_WAVEFORM_MODE_EEVTEDG_EDGE = 0x3
	// Position of EEVT field.
	TC_CMR0_WAVEFORM_MODE_EEVT_Pos = 0xa
	// Bit mask of EEVT field.
	TC_CMR0_WAVEFORM_MODE_EEVT_Msk = 0xc00
	// TIOB
	TC_CMR0_WAVEFORM_MODE_EEVT_TIOB = 0x0
	// XC0
	TC_CMR0_WAVEFORM_MODE_EEVT_XC0 = 0x1
	// XC1
	TC_CMR0_WAVEFORM_MODE_EEVT_XC1 = 0x2
	// XC2
	TC_CMR0_WAVEFORM_MODE_EEVT_XC2 = 0x3
	// Position of ENETRG field.
	TC_CMR0_WAVEFORM_MODE_ENETRG_Pos = 0xc
	// Bit mask of ENETRG field.
	TC_CMR0_WAVEFORM_MODE_ENETRG_Msk = 0x1000
	// Bit ENETRG.
	TC_CMR0_WAVEFORM_MODE_ENETRG = 0x1000
	// Position of WAVSEL field.
	TC_CMR0_WAVEFORM_MODE_WAVSEL_Pos = 0xd
	// Bit mask of WAVSEL field.
	TC_CMR0_WAVEFORM_MODE_WAVSEL_Msk = 0x6000
	// UP mode without automatic trigger on RC Compare
	TC_CMR0_WAVEFORM_MODE_WAVSEL_UP = 0x0
	// UPDOWN mode without automatic trigger on RC Compare
	TC_CMR0_WAVEFORM_MODE_WAVSEL_UPDOWN = 0x1
	// UP mode with automatic trigger on RC Compare
	TC_CMR0_WAVEFORM_MODE_WAVSEL_UP_RC = 0x2
	// UPDOWN mode with automatic trigger on RC Compare
	TC_CMR0_WAVEFORM_MODE_WAVSEL_UPDOWN_RC = 0x3
	// Position of WAVE field.
	TC_CMR0_WAVEFORM_MODE_WAVE_Pos = 0xf
	// Bit mask of WAVE field.
	TC_CMR0_WAVEFORM_MODE_WAVE_Msk = 0x8000
	// Bit WAVE.
	TC_CMR0_WAVEFORM_MODE_WAVE = 0x8000
	// Position of ACPA field.
	TC_CMR0_WAVEFORM_MODE_ACPA_Pos = 0x10
	// Bit mask of ACPA field.
	TC_CMR0_WAVEFORM_MODE_ACPA_Msk = 0x30000
	// None
	TC_CMR0_WAVEFORM_MODE_ACPA_NONE = 0x0
	// Set
	TC_CMR0_WAVEFORM_MODE_ACPA_SET = 0x1
	// Clear
	TC_CMR0_WAVEFORM_MODE_ACPA_CLEAR = 0x2
	// Toggle
	TC_CMR0_WAVEFORM_MODE_ACPA_TOGGLE = 0x3
	// Position of ACPC field.
	TC_CMR0_WAVEFORM_MODE_ACPC_Pos = 0x12
	// Bit mask of ACPC field.
	TC_CMR0_WAVEFORM_MODE_ACPC_Msk = 0xc0000
	// None
	TC_CMR0_WAVEFORM_MODE_ACPC_NONE = 0x0
	// Set
	TC_CMR0_WAVEFORM_MODE_ACPC_SET = 0x1
	// Clear
	TC_CMR0_WAVEFORM_MODE_ACPC_CLEAR = 0x2
	// Toggle
	TC_CMR0_WAVEFORM_MODE_ACPC_TOGGLE = 0x3
	// Position of AEEVT field.
	TC_CMR0_WAVEFORM_MODE_AEEVT_Pos = 0x14
	// Bit mask of AEEVT field.
	TC_CMR0_WAVEFORM_MODE_AEEVT_Msk = 0x300000
	// None
	TC_CMR0_WAVEFORM_MODE_AEEVT_NONE = 0x0
	// Set
	TC_CMR0_WAVEFORM_MODE_AEEVT_SET = 0x1
	// Clear
	TC_CMR0_WAVEFORM_MODE_AEEVT_CLEAR = 0x2
	// Toggle
	TC_CMR0_WAVEFORM_MODE_AEEVT_TOGGLE = 0x3
	// Position of ASWTRG field.
	TC_CMR0_WAVEFORM_MODE_ASWTRG_Pos = 0x16
	// Bit mask of ASWTRG field.
	TC_CMR0_WAVEFORM_MODE_ASWTRG_Msk = 0xc00000
	// None
	TC_CMR0_WAVEFORM_MODE_ASWTRG_NONE = 0x0
	// Set
	TC_CMR0_WAVEFORM_MODE_ASWTRG_SET = 0x1
	// Clear
	TC_CMR0_WAVEFORM_MODE_ASWTRG_CLEAR = 0x2
	// Toggle
	TC_CMR0_WAVEFORM_MODE_ASWTRG_TOGGLE = 0x3
	// Position of BCPB field.
	TC_CMR0_WAVEFORM_MODE_BCPB_Pos = 0x18
	// Bit mask of BCPB field.
	TC_CMR0_WAVEFORM_MODE_BCPB_Msk = 0x3000000
	// None
	TC_CMR0_WAVEFORM_MODE_BCPB_NONE = 0x0
	// Set
	TC_CMR0_WAVEFORM_MODE_BCPB_SET = 0x1
	// Clear
	TC_CMR0_WAVEFORM_MODE_BCPB_CLEAR = 0x2
	// Toggle
	TC_CMR0_WAVEFORM_MODE_BCPB_TOGGLE = 0x3
	// Position of BCPC field.
	TC_CMR0_WAVEFORM_MODE_BCPC_Pos = 0x1a
	// Bit mask of BCPC field.
	TC_CMR0_WAVEFORM_MODE_BCPC_Msk = 0xc000000
	// None
	TC_CMR0_WAVEFORM_MODE_BCPC_NONE = 0x0
	// Set
	TC_CMR0_WAVEFORM_MODE_BCPC_SET = 0x1
	// Clear
	TC_CMR0_WAVEFORM_MODE_BCPC_CLEAR = 0x2
	// Toggle
	TC_CMR0_WAVEFORM_MODE_BCPC_TOGGLE = 0x3
	// Position of BEEVT field.
	TC_CMR0_WAVEFORM_MODE_BEEVT_Pos = 0x1c
	// Bit mask of BEEVT field.
	TC_CMR0_WAVEFORM_MODE_BEEVT_Msk = 0x30000000
	// None
	TC_CMR0_WAVEFORM_MODE_BEEVT_NONE = 0x0
	// Set
	TC_CMR0_WAVEFORM_MODE_BEEVT_SET = 0x1
	// Clear
	TC_CMR0_WAVEFORM_MODE_BEEVT_CLEAR = 0x2
	// Toggle
	TC_CMR0_WAVEFORM_MODE_BEEVT_TOGGLE = 0x3
	// Position of BSWTRG field.
	TC_CMR0_WAVEFORM_MODE_BSWTRG_Pos = 0x1e
	// Bit mask of BSWTRG field.
	TC_CMR0_WAVEFORM_MODE_BSWTRG_Msk = 0xc0000000
	// None
	TC_CMR0_WAVEFORM_MODE_BSWTRG_NONE = 0x0
	// Set
	TC_CMR0_WAVEFORM_MODE_BSWTRG_SET = 0x1
	// Clear
	TC_CMR0_WAVEFORM_MODE_BSWTRG_CLEAR = 0x2
	// Toggle
	TC_CMR0_WAVEFORM_MODE_BSWTRG_TOGGLE = 0x3

	// SMMR0: Stepper Motor Mode Register (channel = 0)
	// Position of GCEN field.
	TC_SMMR0_GCEN_Pos = 0x0
	// Bit mask of GCEN field.
	TC_SMMR0_GCEN_Msk = 0x1
	// Bit GCEN.
	TC_SMMR0_GCEN = 0x1
	// Position of DOWN field.
	TC_SMMR0_DOWN_Pos = 0x1
	// Bit mask of DOWN field.
	TC_SMMR0_DOWN_Msk = 0x2
	// Bit DOWN.
	TC_SMMR0_DOWN = 0x2

	// CV0: Counter Value (channel = 0)
	// Position of CV field.
	TC_CV0_CV_Pos = 0x0
	// Bit mask of CV field.
	TC_CV0_CV_Msk = 0xffffffff

	// RA0: Register A (channel = 0)
	// Position of RA field.
	TC_RA0_RA_Pos = 0x0
	// Bit mask of RA field.
	TC_RA0_RA_Msk = 0xffffffff

	// RB0: Register B (channel = 0)
	// Position of RB field.
	TC_RB0_RB_Pos = 0x0
	// Bit mask of RB field.
	TC_RB0_RB_Msk = 0xffffffff

	// RC0: Register C (channel = 0)
	// Position of RC field.
	TC_RC0_RC_Pos = 0x0
	// Bit mask of RC field.
	TC_RC0_RC_Msk = 0xffffffff

	// SR0: Status Register (channel = 0)
	// Position of COVFS field.
	TC_SR0_COVFS_Pos = 0x0
	// Bit mask of COVFS field.
	TC_SR0_COVFS_Msk = 0x1
	// Bit COVFS.
	TC_SR0_COVFS = 0x1
	// Position of LOVRS field.
	TC_SR0_LOVRS_Pos = 0x1
	// Bit mask of LOVRS field.
	TC_SR0_LOVRS_Msk = 0x2
	// Bit LOVRS.
	TC_SR0_LOVRS = 0x2
	// Position of CPAS field.
	TC_SR0_CPAS_Pos = 0x2
	// Bit mask of CPAS field.
	TC_SR0_CPAS_Msk = 0x4
	// Bit CPAS.
	TC_SR0_CPAS = 0x4
	// Position of CPBS field.
	TC_SR0_CPBS_Pos = 0x3
	// Bit mask of CPBS field.
	TC_SR0_CPBS_Msk = 0x8
	// Bit CPBS.
	TC_SR0_CPBS = 0x8
	// Position of CPCS field.
	TC_SR0_CPCS_Pos = 0x4
	// Bit mask of CPCS field.
	TC_SR0_CPCS_Msk = 0x10
	// Bit CPCS.
	TC_SR0_CPCS = 0x10
	// Position of LDRAS field.
	TC_SR0_LDRAS_Pos = 0x5
	// Bit mask of LDRAS field.
	TC_SR0_LDRAS_Msk = 0x20
	// Bit LDRAS.
	TC_SR0_LDRAS = 0x20
	// Position of LDRBS field.
	TC_SR0_LDRBS_Pos = 0x6
	// Bit mask of LDRBS field.
	TC_SR0_LDRBS_Msk = 0x40
	// Bit LDRBS.
	TC_SR0_LDRBS = 0x40
	// Position of ETRGS field.
	TC_SR0_ETRGS_Pos = 0x7
	// Bit mask of ETRGS field.
	TC_SR0_ETRGS_Msk = 0x80
	// Bit ETRGS.
	TC_SR0_ETRGS = 0x80
	// Position of CLKSTA field.
	TC_SR0_CLKSTA_Pos = 0x10
	// Bit mask of CLKSTA field.
	TC_SR0_CLKSTA_Msk = 0x10000
	// Bit CLKSTA.
	TC_SR0_CLKSTA = 0x10000
	// Position of MTIOA field.
	TC_SR0_MTIOA_Pos = 0x11
	// Bit mask of MTIOA field.
	TC_SR0_MTIOA_Msk = 0x20000
	// Bit MTIOA.
	TC_SR0_MTIOA = 0x20000
	// Position of MTIOB field.
	TC_SR0_MTIOB_Pos = 0x12
	// Bit mask of MTIOB field.
	TC_SR0_MTIOB_Msk = 0x40000
	// Bit MTIOB.
	TC_SR0_MTIOB = 0x40000

	// IER0: Interrupt Enable Register (channel = 0)
	// Position of COVFS field.
	TC_IER0_COVFS_Pos = 0x0
	// Bit mask of COVFS field.
	TC_IER0_COVFS_Msk = 0x1
	// Bit COVFS.
	TC_IER0_COVFS = 0x1
	// Position of LOVRS field.
	TC_IER0_LOVRS_Pos = 0x1
	// Bit mask of LOVRS field.
	TC_IER0_LOVRS_Msk = 0x2
	// Bit LOVRS.
	TC_IER0_LOVRS = 0x2
	// Position of CPAS field.
	TC_IER0_CPAS_Pos = 0x2
	// Bit mask of CPAS field.
	TC_IER0_CPAS_Msk = 0x4
	// Bit CPAS.
	TC_IER0_CPAS = 0x4
	// Position of CPBS field.
	TC_IER0_CPBS_Pos = 0x3
	// Bit mask of CPBS field.
	TC_IER0_CPBS_Msk = 0x8
	// Bit CPBS.
	TC_IER0_CPBS = 0x8
	// Position of CPCS field.
	TC_IER0_CPCS_Pos = 0x4
	// Bit mask of CPCS field.
	TC_IER0_CPCS_Msk = 0x10
	// Bit CPCS.
	TC_IER0_CPCS = 0x10
	// Position of LDRAS field.
	TC_IER0_LDRAS_Pos = 0x5
	// Bit mask of LDRAS field.
	TC_IER0_LDRAS_Msk = 0x20
	// Bit LDRAS.
	TC_IER0_LDRAS = 0x20
	// Position of LDRBS field.
	TC_IER0_LDRBS_Pos = 0x6
	// Bit mask of LDRBS field.
	TC_IER0_LDRBS_Msk = 0x40
	// Bit LDRBS.
	TC_IER0_LDRBS = 0x40
	// Position of ETRGS field.
	TC_IER0_ETRGS_Pos = 0x7
	// Bit mask of ETRGS field.
	TC_IER0_ETRGS_Msk = 0x80
	// Bit ETRGS.
	TC_IER0_ETRGS = 0x80

	// IDR0: Interrupt Disable Register (channel = 0)
	// Position of COVFS field.
	TC_IDR0_COVFS_Pos = 0x0
	// Bit mask of COVFS field.
	TC_IDR0_COVFS_Msk = 0x1
	// Bit COVFS.
	TC_IDR0_COVFS = 0x1
	// Position of LOVRS field.
	TC_IDR0_LOVRS_Pos = 0x1
	// Bit mask of LOVRS field.
	TC_IDR0_LOVRS_Msk = 0x2
	// Bit LOVRS.
	TC_IDR0_LOVRS = 0x2
	// Position of CPAS field.
	TC_IDR0_CPAS_Pos = 0x2
	// Bit mask of CPAS field.
	TC_IDR0_CPAS_Msk = 0x4
	// Bit CPAS.
	TC_IDR0_CPAS = 0x4
	// Position of CPBS field.
	TC_IDR0_CPBS_Pos = 0x3
	// Bit mask of CPBS field.
	TC_IDR0_CPBS_Msk = 0x8
	// Bit CPBS.
	TC_IDR0_CPBS = 0x8
	// Position of CPCS field.
	TC_IDR0_CPCS_Pos = 0x4
	// Bit mask of CPCS field.
	TC_IDR0_CPCS_Msk = 0x10
	// Bit CPCS.
	TC_IDR0_CPCS = 0x10
	// Position of LDRAS field.
	TC_IDR0_LDRAS_Pos = 0x5
	// Bit mask of LDRAS field.
	TC_IDR0_LDRAS_Msk = 0x20
	// Bit LDRAS.
	TC_IDR0_LDRAS = 0x20
	// Position of LDRBS field.
	TC_IDR0_LDRBS_Pos = 0x6
	// Bit mask of LDRBS field.
	TC_IDR0_LDRBS_Msk = 0x40
	// Bit LDRBS.
	TC_IDR0_LDRBS = 0x40
	// Position of ETRGS field.
	TC_IDR0_ETRGS_Pos = 0x7
	// Bit mask of ETRGS field.
	TC_IDR0_ETRGS_Msk = 0x80
	// Bit ETRGS.
	TC_IDR0_ETRGS = 0x80

	// IMR0: Interrupt Mask Register (channel = 0)
	// Position of COVFS field.
	TC_IMR0_COVFS_Pos = 0x0
	// Bit mask of COVFS field.
	TC_IMR0_COVFS_Msk = 0x1
	// Bit COVFS.
	TC_IMR0_COVFS = 0x1
	// Position of LOVRS field.
	TC_IMR0_LOVRS_Pos = 0x1
	// Bit mask of LOVRS field.
	TC_IMR0_LOVRS_Msk = 0x2
	// Bit LOVRS.
	TC_IMR0_LOVRS = 0x2
	// Position of CPAS field.
	TC_IMR0_CPAS_Pos = 0x2
	// Bit mask of CPAS field.
	TC_IMR0_CPAS_Msk = 0x4
	// Bit CPAS.
	TC_IMR0_CPAS = 0x4
	// Position of CPBS field.
	TC_IMR0_CPBS_Pos = 0x3
	// Bit mask of CPBS field.
	TC_IMR0_CPBS_Msk = 0x8
	// Bit CPBS.
	TC_IMR0_CPBS = 0x8
	// Position of CPCS field.
	TC_IMR0_CPCS_Pos = 0x4
	// Bit mask of CPCS field.
	TC_IMR0_CPCS_Msk = 0x10
	// Bit CPCS.
	TC_IMR0_CPCS = 0x10
	// Position of LDRAS field.
	TC_IMR0_LDRAS_Pos = 0x5
	// Bit mask of LDRAS field.
	TC_IMR0_LDRAS_Msk = 0x20
	// Bit LDRAS.
	TC_IMR0_LDRAS = 0x20
	// Position of LDRBS field.
	TC_IMR0_LDRBS_Pos = 0x6
	// Bit mask of LDRBS field.
	TC_IMR0_LDRBS_Msk = 0x40
	// Bit LDRBS.
	TC_IMR0_LDRBS = 0x40
	// Position of ETRGS field.
	TC_IMR0_ETRGS_Pos = 0x7
	// Bit mask of ETRGS field.
	TC_IMR0_ETRGS_Msk = 0x80
	// Bit ETRGS.
	TC_IMR0_ETRGS = 0x80

	// CCR1: Channel Control Register (channel = 1)
	// Position of CLKEN field.
	TC_CCR1_CLKEN_Pos = 0x0
	// Bit mask of CLKEN field.
	TC_CCR1_CLKEN_Msk = 0x1
	// Bit CLKEN.
	TC_CCR1_CLKEN = 0x1
	// Position of CLKDIS field.
	TC_CCR1_CLKDIS_Pos = 0x1
	// Bit mask of CLKDIS field.
	TC_CCR1_CLKDIS_Msk = 0x2
	// Bit CLKDIS.
	TC_CCR1_CLKDIS = 0x2
	// Position of SWTRG field.
	TC_CCR1_SWTRG_Pos = 0x2
	// Bit mask of SWTRG field.
	TC_CCR1_SWTRG_Msk = 0x4
	// Bit SWTRG.
	TC_CCR1_SWTRG = 0x4

	// CMR1: Channel Mode Register (channel = 1)
	// Position of TCCLKS field.
	TC_CMR1_TCCLKS_Pos = 0x0
	// Bit mask of TCCLKS field.
	TC_CMR1_TCCLKS_Msk = 0x7
	// Clock selected: internal MCK/2 clock signal (from PMC)
	TC_CMR1_TCCLKS_TIMER_CLOCK1 = 0x0
	// Clock selected: internal MCK/8 clock signal (from PMC)
	TC_CMR1_TCCLKS_TIMER_CLOCK2 = 0x1
	// Clock selected: internal MCK/32 clock signal (from PMC)
	TC_CMR1_TCCLKS_TIMER_CLOCK3 = 0x2
	// Clock selected: internal MCK/128 clock signal (from PMC)
	TC_CMR1_TCCLKS_TIMER_CLOCK4 = 0x3
	// Clock selected: internal SLCK clock signal (from PMC)
	TC_CMR1_TCCLKS_TIMER_CLOCK5 = 0x4
	// Clock selected: XC0
	TC_CMR1_TCCLKS_XC0 = 0x5
	// Clock selected: XC1
	TC_CMR1_TCCLKS_XC1 = 0x6
	// Clock selected: XC2
	TC_CMR1_TCCLKS_XC2 = 0x7
	// Position of CLKI field.
	TC_CMR1_CLKI_Pos = 0x3
	// Bit mask of CLKI field.
	TC_CMR1_CLKI_Msk = 0x8
	// Bit CLKI.
	TC_CMR1_CLKI = 0x8
	// Position of BURST field.
	TC_CMR1_BURST_Pos = 0x4
	// Bit mask of BURST field.
	TC_CMR1_BURST_Msk = 0x30
	// The clock is not gated by an external signal.
	TC_CMR1_BURST_NONE = 0x0
	// XC0 is ANDed with the selected clock.
	TC_CMR1_BURST_XC0 = 0x1
	// XC1 is ANDed with the selected clock.
	TC_CMR1_BURST_XC1 = 0x2
	// XC2 is ANDed with the selected clock.
	TC_CMR1_BURST_XC2 = 0x3
	// Position of LDBSTOP field.
	TC_CMR1_LDBSTOP_Pos = 0x6
	// Bit mask of LDBSTOP field.
	TC_CMR1_LDBSTOP_Msk = 0x40
	// Bit LDBSTOP.
	TC_CMR1_LDBSTOP = 0x40
	// Position of LDBDIS field.
	TC_CMR1_LDBDIS_Pos = 0x7
	// Bit mask of LDBDIS field.
	TC_CMR1_LDBDIS_Msk = 0x80
	// Bit LDBDIS.
	TC_CMR1_LDBDIS = 0x80
	// Position of ETRGEDG field.
	TC_CMR1_ETRGEDG_Pos = 0x8
	// Bit mask of ETRGEDG field.
	TC_CMR1_ETRGEDG_Msk = 0x300
	// The clock is not gated by an external signal.
	TC_CMR1_ETRGEDG_NONE = 0x0
	// Rising edge
	TC_CMR1_ETRGEDG_RISING = 0x1
	// Falling edge
	TC_CMR1_ETRGEDG_FALLING = 0x2
	// Each edge
	TC_CMR1_ETRGEDG_EDGE = 0x3
	// Position of ABETRG field.
	TC_CMR1_ABETRG_Pos = 0xa
	// Bit mask of ABETRG field.
	TC_CMR1_ABETRG_Msk = 0x400
	// Bit ABETRG.
	TC_CMR1_ABETRG = 0x400
	// Position of CPCTRG field.
	TC_CMR1_CPCTRG_Pos = 0xe
	// Bit mask of CPCTRG field.
	TC_CMR1_CPCTRG_Msk = 0x4000
	// Bit CPCTRG.
	TC_CMR1_CPCTRG = 0x4000
	// Position of WAVE field.
	TC_CMR1_WAVE_Pos = 0xf
	// Bit mask of WAVE field.
	TC_CMR1_WAVE_Msk = 0x8000
	// Bit WAVE.
	TC_CMR1_WAVE = 0x8000
	// Position of LDRA field.
	TC_CMR1_LDRA_Pos = 0x10
	// Bit mask of LDRA field.
	TC_CMR1_LDRA_Msk = 0x30000
	// None
	TC_CMR1_LDRA_NONE = 0x0
	// Rising edge of TIOA
	TC_CMR1_LDRA_RISING = 0x1
	// Falling edge of TIOA
	TC_CMR1_LDRA_FALLING = 0x2
	// Each edge of TIOA
	TC_CMR1_LDRA_EDGE = 0x3
	// Position of LDRB field.
	TC_CMR1_LDRB_Pos = 0x12
	// Bit mask of LDRB field.
	TC_CMR1_LDRB_Msk = 0xc0000
	// None
	TC_CMR1_LDRB_NONE = 0x0
	// Rising edge of TIOA
	TC_CMR1_LDRB_RISING = 0x1
	// Falling edge of TIOA
	TC_CMR1_LDRB_FALLING = 0x2
	// Each edge of TIOA
	TC_CMR1_LDRB_EDGE = 0x3

	// CMR1_WAVEFORM_MODE: Channel Mode Register (channel = 1)
	// Position of TCCLKS field.
	TC_CMR1_WAVEFORM_MODE_TCCLKS_Pos = 0x0
	// Bit mask of TCCLKS field.
	TC_CMR1_WAVEFORM_MODE_TCCLKS_Msk = 0x7
	// Clock selected: internal MCK/2 clock signal (from PMC)
	TC_CMR1_WAVEFORM_MODE_TCCLKS_TIMER_CLOCK1 = 0x0
	// Clock selected: internal MCK/8 clock signal (from PMC)
	TC_CMR1_WAVEFORM_MODE_TCCLKS_TIMER_CLOCK2 = 0x1
	// Clock selected: internal MCK/32 clock signal (from PMC)
	TC_CMR1_WAVEFORM_MODE_TCCLKS_TIMER_CLOCK3 = 0x2
	// Clock selected: internal MCK/128 clock signal (from PMC)
	TC_CMR1_WAVEFORM_MODE_TCCLKS_TIMER_CLOCK4 = 0x3
	// Clock selected: internal SLCK clock signal (from PMC)
	TC_CMR1_WAVEFORM_MODE_TCCLKS_TIMER_CLOCK5 = 0x4
	// Clock selected: XC0
	TC_CMR1_WAVEFORM_MODE_TCCLKS_XC0 = 0x5
	// Clock selected: XC1
	TC_CMR1_WAVEFORM_MODE_TCCLKS_XC1 = 0x6
	// Clock selected: XC2
	TC_CMR1_WAVEFORM_MODE_TCCLKS_XC2 = 0x7
	// Position of CLKI field.
	TC_CMR1_WAVEFORM_MODE_CLKI_Pos = 0x3
	// Bit mask of CLKI field.
	TC_CMR1_WAVEFORM_MODE_CLKI_Msk = 0x8
	// Bit CLKI.
	TC_CMR1_WAVEFORM_MODE_CLKI = 0x8
	// Position of BURST field.
	TC_CMR1_WAVEFORM_MODE_BURST_Pos = 0x4
	// Bit mask of BURST field.
	TC_CMR1_WAVEFORM_MODE_BURST_Msk = 0x30
	// The clock is not gated by an external signal.
	TC_CMR1_WAVEFORM_MODE_BURST_NONE = 0x0
	// XC0 is ANDed with the selected clock.
	TC_CMR1_WAVEFORM_MODE_BURST_XC0 = 0x1
	// XC1 is ANDed with the selected clock.
	TC_CMR1_WAVEFORM_MODE_BURST_XC1 = 0x2
	// XC2 is ANDed with the selected clock.
	TC_CMR1_WAVEFORM_MODE_BURST_XC2 = 0x3
	// Position of CPCSTOP field.
	TC_CMR1_WAVEFORM_MODE_CPCSTOP_Pos = 0x6
	// Bit mask of CPCSTOP field.
	TC_CMR1_WAVEFORM_MODE_CPCSTOP_Msk = 0x40
	// Bit CPCSTOP.
	TC_CMR1_WAVEFORM_MODE_CPCSTOP = 0x40
	// Position of CPCDIS field.
	TC_CMR1_WAVEFORM_MODE_CPCDIS_Pos = 0x7
	// Bit mask of CPCDIS field.
	TC_CMR1_WAVEFORM_MODE_CPCDIS_Msk = 0x80
	// Bit CPCDIS.
	TC_CMR1_WAVEFORM_MODE_CPCDIS = 0x80
	// Position of EEVTEDG field.
	TC_CMR1_WAVEFORM_MODE_EEVTEDG_Pos = 0x8
	// Bit mask of EEVTEDG field.
	TC_CMR1_WAVEFORM_MODE_EEVTEDG_Msk = 0x300
	// None
	TC_CMR1_WAVEFORM_MODE_EEVTEDG_NONE = 0x0
	// Rising edge
	TC_CMR1_WAVEFORM_MODE_EEVTEDG_RISING = 0x1
	// Falling edge
	TC_CMR1_WAVEFORM_MODE_EEVTEDG_FALLING = 0x2
	// Each edge
	TC_CMR1_WAVEFORM_MODE_EEVTEDG_EDGE = 0x3
	// Position of EEVT field.
	TC_CMR1_WAVEFORM_MODE_EEVT_Pos = 0xa
	// Bit mask of EEVT field.
	TC_CMR1_WAVEFORM_MODE_EEVT_Msk = 0xc00
	// TIOB
	TC_CMR1_WAVEFORM_MODE_EEVT_TIOB = 0x0
	// XC0
	TC_CMR1_WAVEFORM_MODE_EEVT_XC0 = 0x1
	// XC1
	TC_CMR1_WAVEFORM_MODE_EEVT_XC1 = 0x2
	// XC2
	TC_CMR1_WAVEFORM_MODE_EEVT_XC2 = 0x3
	// Position of ENETRG field.
	TC_CMR1_WAVEFORM_MODE_ENETRG_Pos = 0xc
	// Bit mask of ENETRG field.
	TC_CMR1_WAVEFORM_MODE_ENETRG_Msk = 0x1000
	// Bit ENETRG.
	TC_CMR1_WAVEFORM_MODE_ENETRG = 0x1000
	// Position of WAVSEL field.
	TC_CMR1_WAVEFORM_MODE_WAVSEL_Pos = 0xd
	// Bit mask of WAVSEL field.
	TC_CMR1_WAVEFORM_MODE_WAVSEL_Msk = 0x6000
	// UP mode without automatic trigger on RC Compare
	TC_CMR1_WAVEFORM_MODE_WAVSEL_UP = 0x0
	// UPDOWN mode without automatic trigger on RC Compare
	TC_CMR1_WAVEFORM_MODE_WAVSEL_UPDOWN = 0x1
	// UP mode with automatic trigger on RC Compare
	TC_CMR1_WAVEFORM_MODE_WAVSEL_UP_RC = 0x2
	// UPDOWN mode with automatic trigger on RC Compare
	TC_CMR1_WAVEFORM_MODE_WAVSEL_UPDOWN_RC = 0x3
	// Position of WAVE field.
	TC_CMR1_WAVEFORM_MODE_WAVE_Pos = 0xf
	// Bit mask of WAVE field.
	TC_CMR1_WAVEFORM_MODE_WAVE_Msk = 0x8000
	// Bit WAVE.
	TC_CMR1_WAVEFORM_MODE_WAVE = 0x8000
	// Position of ACPA field.
	TC_CMR1_WAVEFORM_MODE_ACPA_Pos = 0x10
	// Bit mask of ACPA field.
	TC_CMR1_WAVEFORM_MODE_ACPA_Msk = 0x30000
	// None
	TC_CMR1_WAVEFORM_MODE_ACPA_NONE = 0x0
	// Set
	TC_CMR1_WAVEFORM_MODE_ACPA_SET = 0x1
	// Clear
	TC_CMR1_WAVEFORM_MODE_ACPA_CLEAR = 0x2
	// Toggle
	TC_CMR1_WAVEFORM_MODE_ACPA_TOGGLE = 0x3
	// Position of ACPC field.
	TC_CMR1_WAVEFORM_MODE_ACPC_Pos = 0x12
	// Bit mask of ACPC field.
	TC_CMR1_WAVEFORM_MODE_ACPC_Msk = 0xc0000
	// None
	TC_CMR1_WAVEFORM_MODE_ACPC_NONE = 0x0
	// Set
	TC_CMR1_WAVEFORM_MODE_ACPC_SET = 0x1
	// Clear
	TC_CMR1_WAVEFORM_MODE_ACPC_CLEAR = 0x2
	// Toggle
	TC_CMR1_WAVEFORM_MODE_ACPC_TOGGLE = 0x3
	// Position of AEEVT field.
	TC_CMR1_WAVEFORM_MODE_AEEVT_Pos = 0x14
	// Bit mask of AEEVT field.
	TC_CMR1_WAVEFORM_MODE_AEEVT_Msk = 0x300000
	// None
	TC_CMR1_WAVEFORM_MODE_AEEVT_NONE = 0x0
	// Set
	TC_CMR1_WAVEFORM_MODE_AEEVT_SET = 0x1
	// Clear
	TC_CMR1_WAVEFORM_MODE_AEEVT_CLEAR = 0x2
	// Toggle
	TC_CMR1_WAVEFORM_MODE_AEEVT_TOGGLE = 0x3
	// Position of ASWTRG field.
	TC_CMR1_WAVEFORM_MODE_ASWTRG_Pos = 0x16
	// Bit mask of ASWTRG field.
	TC_CMR1_WAVEFORM_MODE_ASWTRG_Msk = 0xc00000
	// None
	TC_CMR1_WAVEFORM_MODE_ASWTRG_NONE = 0x0
	// Set
	TC_CMR1_WAVEFORM_MODE_ASWTRG_SET = 0x1
	// Clear
	TC_CMR1_WAVEFORM_MODE_ASWTRG_CLEAR = 0x2
	// Toggle
	TC_CMR1_WAVEFORM_MODE_ASWTRG_TOGGLE = 0x3
	// Position of BCPB field.
	TC_CMR1_WAVEFORM_MODE_BCPB_Pos = 0x18
	// Bit mask of BCPB field.
	TC_CMR1_WAVEFORM_MODE_BCPB_Msk = 0x3000000
	// None
	TC_CMR1_WAVEFORM_MODE_BCPB_NONE = 0x0
	// Set
	TC_CMR1_WAVEFORM_MODE_BCPB_SET = 0x1
	// Clear
	TC_CMR1_WAVEFORM_MODE_BCPB_CLEAR = 0x2
	// Toggle
	TC_CMR1_WAVEFORM_MODE_BCPB_TOGGLE = 0x3
	// Position of BCPC field.
	TC_CMR1_WAVEFORM_MODE_BCPC_Pos = 0x1a
	// Bit mask of BCPC field.
	TC_CMR1_WAVEFORM_MODE_BCPC_Msk = 0xc000000
	// None
	TC_CMR1_WAVEFORM_MODE_BCPC_NONE = 0x0
	// Set
	TC_CMR1_WAVEFORM_MODE_BCPC_SET = 0x1
	// Clear
	TC_CMR1_WAVEFORM_MODE_BCPC_CLEAR = 0x2
	// Toggle
	TC_CMR1_WAVEFORM_MODE_BCPC_TOGGLE = 0x3
	// Position of BEEVT field.
	TC_CMR1_WAVEFORM_MODE_BEEVT_Pos = 0x1c
	// Bit mask of BEEVT field.
	TC_CMR1_WAVEFORM_MODE_BEEVT_Msk = 0x30000000
	// None
	TC_CMR1_WAVEFORM_MODE_BEEVT_NONE = 0x0
	// Set
	TC_CMR1_WAVEFORM_MODE_BEEVT_SET = 0x1
	// Clear
	TC_CMR1_WAVEFORM_MODE_BEEVT_CLEAR = 0x2
	// Toggle
	TC_CMR1_WAVEFORM_MODE_BEEVT_TOGGLE = 0x3
	// Position of BSWTRG field.
	TC_CMR1_WAVEFORM_MODE_BSWTRG_Pos = 0x1e
	// Bit mask of BSWTRG field.
	TC_CMR1_WAVEFORM_MODE_BSWTRG_Msk = 0xc0000000
	// None
	TC_CMR1_WAVEFORM_MODE_BSWTRG_NONE = 0x0
	// Set
	TC_CMR1_WAVEFORM_MODE_BSWTRG_SET = 0x1
	// Clear
	TC_CMR1_WAVEFORM_MODE_BSWTRG_CLEAR = 0x2
	// Toggle
	TC_CMR1_WAVEFORM_MODE_BSWTRG_TOGGLE = 0x3

	// SMMR1: Stepper Motor Mode Register (channel = 1)
	// Position of GCEN field.
	TC_SMMR1_GCEN_Pos = 0x0
	// Bit mask of GCEN field.
	TC_SMMR1_GCEN_Msk = 0x1
	// Bit GCEN.
	TC_SMMR1_GCEN = 0x1
	// Position of DOWN field.
	TC_SMMR1_DOWN_Pos = 0x1
	// Bit mask of DOWN field.
	TC_SMMR1_DOWN_Msk = 0x2
	// Bit DOWN.
	TC_SMMR1_DOWN = 0x2

	// CV1: Counter Value (channel = 1)
	// Position of CV field.
	TC_CV1_CV_Pos = 0x0
	// Bit mask of CV field.
	TC_CV1_CV_Msk = 0xffffffff

	// RA1: Register A (channel = 1)
	// Position of RA field.
	TC_RA1_RA_Pos = 0x0
	// Bit mask of RA field.
	TC_RA1_RA_Msk = 0xffffffff

	// RB1: Register B (channel = 1)
	// Position of RB field.
	TC_RB1_RB_Pos = 0x0
	// Bit mask of RB field.
	TC_RB1_RB_Msk = 0xffffffff

	// RC1: Register C (channel = 1)
	// Position of RC field.
	TC_RC1_RC_Pos = 0x0
	// Bit mask of RC field.
	TC_RC1_RC_Msk = 0xffffffff

	// SR1: Status Register (channel = 1)
	// Position of COVFS field.
	TC_SR1_COVFS_Pos = 0x0
	// Bit mask of COVFS field.
	TC_SR1_COVFS_Msk = 0x1
	// Bit COVFS.
	TC_SR1_COVFS = 0x1
	// Position of LOVRS field.
	TC_SR1_LOVRS_Pos