/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming;

import java.util.Hashtable;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.naming.ContextBindings;
import org.apache.naming.NamingContext;
import org.apache.naming.StringManager;

public class SelectorContext
implements Context {
    public static final String prefix = "java:";
    public static final int prefixLength = "java:".length();
    public static final String IC_PREFIX = "IC_";
    private static final Log log = LogFactory.getLog(SelectorContext.class);
    protected final Hashtable<String, Object> env;
    protected static final StringManager sm = StringManager.getManager(SelectorContext.class);
    protected final boolean initialContext;

    public SelectorContext(Hashtable<String, Object> hashtable) {
        this.env = hashtable;
        this.initialContext = false;
    }

    public SelectorContext(Hashtable<String, Object> hashtable, boolean bl) {
        this.env = hashtable;
        this.initialContext = bl;
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        if (log.isTraceEnabled()) {
            log.trace((Object)sm.getString("selectorContext.methodUsingName", "lookup", name));
        }
        return this.getBoundContext().lookup(this.parseName(name));
    }

    @Override
    public Object lookup(String string) throws NamingException {
        if (log.isTraceEnabled()) {
            log.trace((Object)sm.getString("selectorContext.methodUsingString", "lookup", string));
        }
        return this.getBoundContext().lookup(this.parseName(string));
    }

    @Override
    public void bind(Name name, Object object) throws NamingException {
        this.getBoundContext().bind(this.parseName(name), object);
    }

    @Override
    public void bind(String string, Object object) throws NamingException {
        this.getBoundContext().bind(this.parseName(string), object);
    }

    @Override
    public void rebind(Name name, Object object) throws NamingException {
        this.getBoundContext().rebind(this.parseName(name), object);
    }

    @Override
    public void rebind(String string, Object object) throws NamingException {
        this.getBoundContext().rebind(this.parseName(string), object);
    }

    @Override
    public void unbind(Name name) throws NamingException {
        this.getBoundContext().unbind(this.parseName(name));
    }

    @Override
    public void unbind(String string) throws NamingException {
        this.getBoundContext().unbind(this.parseName(string));
    }

    @Override
    public void rename(Name name, Name name2) throws NamingException {
        this.getBoundContext().rename(this.parseName(name), this.parseName(name2));
    }

    @Override
    public void rename(String string, String string2) throws NamingException {
        this.getBoundContext().rename(this.parseName(string), this.parseName(string2));
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        if (log.isTraceEnabled()) {
            log.trace((Object)sm.getString("selectorContext.methodUsingName", "list", name));
        }
        return this.getBoundContext().list(this.parseName(name));
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String string) throws NamingException {
        if (log.isTraceEnabled()) {
            log.trace((Object)sm.getString("selectorContext.methodUsingString", "list", string));
        }
        return this.getBoundContext().list(this.parseName(string));
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        if (log.isTraceEnabled()) {
            log.trace((Object)sm.getString("selectorContext.methodUsingName", "listBindings", name));
        }
        return this.getBoundContext().listBindings(this.parseName(name));
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String string) throws NamingException {
        if (log.isTraceEnabled()) {
            log.trace((Object)sm.getString("selectorContext.methodUsingString", "listBindings", string));
        }
        return this.getBoundContext().listBindings(this.parseName(string));
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        this.getBoundContext().destroySubcontext(this.parseName(name));
    }

    @Override
    public void destroySubcontext(String string) throws NamingException {
        this.getBoundContext().destroySubcontext(this.parseName(string));
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        return this.getBoundContext().createSubcontext(this.parseName(name));
    }

    @Override
    public Context createSubcontext(String string) throws NamingException {
        return this.getBoundContext().createSubcontext(this.parseName(string));
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        if (log.isTraceEnabled()) {
            log.trace((Object)sm.getString("selectorContext.methodUsingName", "lookupLink", name));
        }
        return this.getBoundContext().lookupLink(this.parseName(name));
    }

    @Override
    public Object lookupLink(String string) throws NamingException {
        if (log.isTraceEnabled()) {
            log.trace((Object)sm.getString("selectorContext.methodUsingString", "lookupLink", string));
        }
        return this.getBoundContext().lookupLink(this.parseName(string));
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        return this.getBoundContext().getNameParser(this.parseName(name));
    }

    @Override
    public NameParser getNameParser(String string) throws NamingException {
        return this.getBoundContext().getNameParser(this.parseName(string));
    }

    @Override
    public Name composeName(Name name, Name name2) throws NamingException {
        Name name3 = (Name)name2.clone();
        return name3.addAll(name);
    }

    @Override
    public String composeName(String string, String string2) throws NamingException {
        return string2 + "/" + string;
    }

    @Override
    public Object addToEnvironment(String string, Object object) throws NamingException {
        return this.getBoundContext().addToEnvironment(string, object);
    }

    @Override
    public Object removeFromEnvironment(String string) throws NamingException {
        return this.getBoundContext().removeFromEnvironment(string);
    }

    @Override
    public Hashtable<?, ?> getEnvironment() throws NamingException {
        return this.getBoundContext().getEnvironment();
    }

    @Override
    public void close() throws NamingException {
        this.getBoundContext().close();
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        return prefix;
    }

    protected Context getBoundContext() throws NamingException {
        if (this.initialContext) {
            String string = IC_PREFIX;
            if (ContextBindings.isThreadBound()) {
                string = string + ContextBindings.getThreadName();
            } else if (ContextBindings.isClassLoaderBound()) {
                string = string + ContextBindings.getClassLoaderName();
            }
            Context context = ContextBindings.getContext(string);
            if (context == null) {
                context = new NamingContext(this.env, string);
                ContextBindings.bindContext(string, context);
            }
            return context;
        }
        if (ContextBindings.isThreadBound()) {
            return ContextBindings.getThread();
        }
        return ContextBindings.getClassLoader();
    }

    protected String parseName(String string) throws NamingException {
        if (!this.initialContext && string.startsWith(prefix)) {
            return string.substring(prefixLength);
        }
        if (this.initialContext) {
            return string;
        }
        throw new NamingException(sm.getString("selectorContext.noJavaUrl"));
    }

    protected Name parseName(Name name) throws NamingException {
        if (!this.initialContext && !name.isEmpty() && name.get(0).startsWith(prefix)) {
            if (name.get(0).equals(prefix)) {
                return name.getSuffix(1);
            }
            Name name2 = name.getSuffix(1);
            name2.add(0, name.get(0).substring(prefixLength));
            return name2;
        }
        if (this.initialContext) {
            return name;
        }
        throw new NamingException(sm.getString("selectorContext.noJavaUrl"));
    }
}

