/*
 * Decompiled with CFR 0.152.
 */
package org.apache.el.util;

import java.security.AccessController;

public class Validation {
    private static final String[] invalidIdentifiers = new String[]{"abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while"};
    private static final boolean IS_SECURITY_ENABLED = System.getSecurityManager() != null;
    private static final boolean SKIP_IDENTIFIER_CHECK;

    private Validation() {
    }

    public static boolean isIdentifier(String string) {
        if (SKIP_IDENTIFIER_CHECK) {
            return true;
        }
        if (string == null || string.isEmpty()) {
            return false;
        }
        int n = 0;
        int n2 = invalidIdentifiers.length;
        while (n < n2) {
            int n3 = n + n2 >>> 1;
            int n4 = invalidIdentifiers[n3].compareTo(string);
            if (n4 == 0) {
                return false;
            }
            if (n4 < 0) {
                n = n3 + 1;
                continue;
            }
            n2 = n3;
        }
        return string.charAt(0) != '#';
    }

    static {
        String string = IS_SECURITY_ENABLED ? AccessController.doPrivileged(() -> System.getProperty("org.apache.el.parser.SKIP_IDENTIFIER_CHECK", "false")) : System.getProperty("org.apache.el.parser.SKIP_IDENTIFIER_CHECK", "false");
        SKIP_IDENTIFIER_CHECK = Boolean.parseBoolean(string);
    }
}

