/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jfr.views.browser;

import javax.swing.JLabel;
import org.graalvm.visualvm.jfr.views.browser.BrowserNode;
import org.graalvm.visualvm.lib.ui.swing.renderer.LabelRenderer;
import org.graalvm.visualvm.lib.ui.swing.renderer.NormalBoldGrayRenderer;
import org.graalvm.visualvm.lib.ui.swing.renderer.NumberRenderer;

final class BrowserRenderers {
    BrowserRenderers() {
    }

    private static int getMinimumWidth(String valueName) {
        return new JLabel((String)valueName).getPreferredSize().width + 30;
    }

    static class EventsCountRenderer
    extends NumberRenderer {
        EventsCountRenderer() {
        }

        static String getDisplayName() {
            return "Count";
        }

        static boolean isInitiallyVisible() {
            return false;
        }

        int getPreferredWidth() {
            this.setValue(1234567, -1);
            return Math.max(this.getPreferredSize().width, BrowserRenderers.getMinimumWidth(EventsCountRenderer.getDisplayName()));
        }
    }

    static class TypeIDRenderer
    extends LabelRenderer {
        TypeIDRenderer() {
        }

        static String getDisplayName() {
            return "ID";
        }

        static boolean isInitiallyVisible() {
            return false;
        }

        int getPreferredWidth() {
            this.setText("jdk.MetaspaceChunkFreeListSummary");
            return Math.max(this.getPreferredSize().width, BrowserRenderers.getMinimumWidth(TypeIDRenderer.getDisplayName()));
        }
    }

    static class NameRenderer
    extends NormalBoldGrayRenderer {
        private boolean showsCount;

        NameRenderer() {
        }

        void setShowsCount(boolean showsCount) {
            this.showsCount = showsCount;
        }

        public void setValue(Object value, int row) {
            if (value instanceof BrowserNode) {
                BrowserNode node = (BrowserNode)((Object)value);
                boolean cat = node instanceof BrowserNode.Category;
                this.setNormalValue(cat ? null : node.toString());
                this.setBoldValue(cat ? node.toString() : null);
                this.setGrayValue(this.showsCount ? (node.eventsCount == 1L ? " (1 event)" : " (" + node.eventsCount + " events)") : null);
            } else {
                super.setValue(value, row);
            }
        }

        static String getDisplayName() {
            return "Name";
        }
    }
}

